;  asm_all.asm --
;
;  This file is part of the UCL data compression library.
;
;  Copyright (C) 1996-2003 Markus Franz Xaver Johannes Oberhumer
;  All Rights Reserved.
;
;  The UCL library is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License as
;  published by the Free Software Foundation; either version 2 of
;  the License, or (at your option) any later version.
;
;  The UCL library is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
;
;  You should have received a copy of the GNU General Public License
;  along with the UCL library; see the file COPYING.
;  If not, write to the Free Software Foundation, Inc.,
;  59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;
;  Markus F.X.J. Oberhumer
;  <markus@oberhumer.com>
;  http://www.oberhumer.com/opensource/ucl/
;

; /***** DO NOT EDIT - GENERATED AUTOMATICALLY *****/

%define F(name) name
%ifidni __OUTPUT_FORMAT__,elf
%define globalf(x) global x:function
%else
%define globalf(x) global x
%endif
bits 32
%ifidni __OUTPUT_FORMAT__,obj
segment _TEXT class=CODE public use32 flat align=16
%else
section .text
%endif

globalf(_ucl_cpuid_asm)
globalf(F(ucl_cpuid_asm))
_ucl_cpuid_asm:
F(ucl_cpuid_asm):
db 85,87,86,83,81,82,137,229,131,228,252,252,139,125,28,186
db 0,0,4,0,232,68,0,0,0,116,58,193,226,3,232,58
db 0,0,0,116,48,49,192,232,66,0,0,0,184,1,0,0
db 0,232,56,0,0,0,184,0,0,0,128,232,46,0,0,0
db 184,1,0,0,128,232,36,0,0,0,49,192,137,236,90,89
db 91,94,95,93,195,141,72,16,243,171,72,235,239,156,156,88
db 137,193,49,208,80,157,156,88,157,49,200,33,208,195,49,219
db 49,201,49,210,15,162,171,137,31,137,79,4,137,87,8,131
db 199,12,195,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_crc32_asm)
globalf(F(ucl_crc32_asm))
_ucl_crc32_asm:
F(ucl_crc32_asm):
db 85,87,86,83,81,82,49,192,139,116,36,32,139,76,36,36
db 139,124,36,40,133,246,15,132,159,0,0,0,139,68,36,28
db 247,208,133,201,15,132,143,0,0,0,247,198,3,0,0,0
db 116,15,50,6,70,15,182,216,193,232,8,51,4,159,73,117
db 233,137,202,193,234,3,116,93,144,141,180,38,0,0,0,0
db 51,6,131,198,4,15,182,216,193,232,8,51,4,159,15,182
db 216,193,232,8,51,4,159,15,182,216,193,232,8,51,4,159
db 15,182,216,193,232,8,51,4,159,51,6,131,198,4,15,182
db 216,193,232,8,51,4,159,15,182,216,193,232,8,51,4,159
db 15,182,216,193,232,8,51,4,159,15,182,216,193,232,8,51
db 4,159,74,117,171,131,225,7,116,15,50,6,70,15,182,216
db 193,232,8,51,4,159,73,117,241,247,208,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_crc32_asm_small)
globalf(F(ucl_crc32_asm_small))
_ucl_crc32_asm_small:
F(ucl_crc32_asm_small):
db 81,49,192,139,76,36,12,227,121,87,83,232,64,0,0,0
db 0,0,0,0,100,16,183,29,200,32,110,59,172,48,217,38
db 144,65,220,118,244,81,107,107,88,97,178,77,60,113,5,80
db 32,131,184,237,68,147,15,240,232,163,214,214,140,179,97,203
db 176,194,100,155,212,210,211,134,120,226,10,160,28,242,189,189
db 95,82,139,84,36,28,1,202,139,68,36,20,247,208,235,25
db 50,1,65,137,195,193,232,4,131,227,15,51,4,159,137,195
db 193,232,4,131,227,15,51,4,159,57,209,117,227,247,208,90
db 91,95,89,195,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_le32)
globalf(F(ucl_nrv2b_decompress_asm_fast_le32))
_ucl_nrv2b_decompress_asm_fast_le32:
F(ucl_nrv2b_decompress_asm_fast_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,239,117,9,139,30,131
db 238,252,17,219,115,228,131,232,3,114,13,193,224,8,138,6
db 70,131,240,255,116,118,137,197,1,219,117,7,139,30,131,238
db 252,17,219,17,201,1,219,117,7,139,30,131,238,252,17,219
db 17,201,117,32,65,1,219,117,7,139,30,131,238,252,17,219
db 17,201,1,219,115,239,117,9,139,30,131,238,252,17,219,115
db 228,131,193,2,129,253,0,243,255,255,131,209,1,141,20,47
db 131,253,252,118,15,138,2,66,136,7,71,73,117,247,233,99
db 255,255,255,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,74,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_safe_le32)
globalf(F(ucl_nrv2b_decompress_asm_fast_safe_le32))
_ucl_nrv2b_decompress_asm_fast_safe_le32:
F(ucl_nrv2b_decompress_asm_fast_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,182,1,0,0,137
db 3,137,240,3,67,44,15,130,169,1,0,0,137,67,4,131
db 232,4,15,130,111,1,0,0,57,240,15,130,103,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,77,1,0,0,59,60,36,15,131,100
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,46,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,18,1,0,0,139,30,131,238,252,17,219,17,192,15,136
db 42,1,0,0,1,219,115,223,117,19,59,116,36,8,15,135
db 243,0,0,0,139,30,131,238,252,17,219,115,202,61,2,0
db 0,1,15,135,6,1,0,0,131,232,3,114,27,193,224,8
db 59,116,36,4,15,131,205,0,0,0,138,6,70,131,240,255
db 15,132,182,0,0,0,137,197,1,219,117,17,59,116,36,8
db 15,135,177,0,0,0,139,30,131,238,252,17,219,17,201,1
db 219,117,17,59,116,36,8,15,135,154,0,0,0,139,30,131
db 238,252,17,219,17,201,117,54,65,1,219,117,17,59,116,36
db 8,15,135,128,0,0,0,139,30,131,238,252,17,219,17,201
db 15,136,145,0,0,0,1,219,115,223,117,15,59,116,36,8
db 119,101,139,30,131,238,252,17,219,115,206,131,193,2,129,253
db 0,243,255,255,131,209,1,137,250,1,202,114,106,59,20,36
db 119,101,137,250,1,234,115,102,59,84,36,48,114,96,131,253
db 252,118,17,138,2,66,136,7,71,73,117,247,233,232,254,255
db 255,144,144,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,205,254,255,255,59,60,36,119
db 38,59,116,36,4,118,7,184,55,255,255,255,235,5,116,3
db 72,176,51,43,124,36,48,139,84,36,52,137,58,131,196,12
db 90,89,91,94,95,93,195,184,54,255,255,255,235,229,184,53
db 255,255,255,235,222,131,200,255,235,217,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_8)
globalf(F(ucl_nrv2b_decompress_asm_fast_8))
_ucl_nrv2b_decompress_asm_fast_8:
F(ucl_nrv2b_decompress_asm_fast_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,241,117,7,138,30,70,16,219,115,232
db 131,232,3,114,13,193,224,8,138,6,70,131,240,255,116,112
db 137,197,0,219,117,5,138,30,70,16,219,17,201,0,219,117
db 5,138,30,70,16,219,17,201,117,28,65,0,219,117,5,138
db 30,70,16,219,17,201,0,219,115,241,117,7,138,30,70,16
db 219,115,232,131,193,2,129,253,0,243,255,255,131,209,1,141
db 20,47,131,253,252,118,17,138,2,66,136,7,71,73,117,247
db 233,113,255,255,255,144,144,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,86,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_safe_8)
globalf(F(ucl_nrv2b_decompress_asm_fast_safe_8))
_ucl_nrv2b_decompress_asm_fast_safe_8:
F(ucl_nrv2b_decompress_asm_fast_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,146,1,0,0,137
db 3,137,240,3,67,40,15,130,133,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,57,1,0,0,59,60,36,15,131,80
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,26,1,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,0
db 1,0,0,138,30,70,16,219,17,192,15,136,26,1,0,0
db 0,219,115,225,117,17,59,116,36,4,15,131,227,0,0,0
db 138,30,70,16,219,115,206,61,2,0,0,1,15,135,248,0
db 0,0,131,232,3,114,27,193,224,8,59,116,36,4,15,131
db 191,0,0,0,138,6,70,131,240,255,15,132,168,0,0,0
db 137,197,0,219,117,15,59,116,36,4,15,131,163,0,0,0
db 138,30,70,16,219,17,201,0,219,117,15,59,116,36,4,15
db 131,142,0,0,0,138,30,70,16,219,17,201,117,46,65,0
db 219,117,11,59,116,36,4,115,122,138,30,70,16,219,17,201
db 15,136,141,0,0,0,0,219,115,229,117,13,59,116,36,4
db 115,97,138,30,70,16,219,115,214,131,193,2,129,253,0,243
db 255,255,131,209,1,137,250,1,202,114,104,59,20,36,119,99
db 137,250,1,234,115,100,59,84,36,44,114,94,131,253,252,118
db 15,138,2,66,136,7,71,73,117,247,233,250,254,255,255,144
db 139,2,131,194,4,137,7,131,199,4,131,233,4,119,241,1
db 207,49,201,233,225,254,255,255,59,60,36,119,38,59,116,36
db 4,118,7,184,55,255,255,255,235,5,116,3,72,176,51,43
db 124,36,44,139,84,36,48,137,58,131,196,8,90,89,91,94
db 95,93,195,184,54,255,255,255,235,229,184,53,255,255,255,235
db 222,131,200,255,235,217,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_le16)
globalf(F(ucl_nrv2b_decompress_asm_fast_le16))
_ucl_nrv2b_decompress_asm_fast_le16:
F(ucl_nrv2b_decompress_asm_fast_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,235,117,11,102,139,30,131,238,254,102,17,219,115,222,131
db 232,3,114,17,193,224,8,138,6,70,131,240,255,15,132,129
db 0,0,0,137,197,102,1,219,117,9,102,139,30,131,238,254
db 102,17,219,17,201,102,1,219,117,9,102,139,30,131,238,254
db 102,17,219,17,201,117,38,65,102,1,219,117,9,102,139,30
db 131,238,254,102,17,219,17,201,102,1,219,115,235,117,11,102
db 139,30,131,238,254,102,17,219,115,222,131,193,2,129,253,0
db 243,255,255,131,209,1,141,20,47,131,253,252,118,14,138,2
db 66,136,7,71,73,117,247,233,74,255,255,255,139,2,131,194
db 4,137,7,131,199,4,131,233,4,119,241,1,207,49,201,233
db 50,255,255,255,137,227,139,83,28,3,83,32,57,214,116,7
db 72,176,55,119,2,176,51,43,123,36,139,83,40,137,58,90
db 89,91,94,95,93,195,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_fast_safe_le16)
globalf(F(ucl_nrv2b_decompress_asm_fast_safe_le16))
_ucl_nrv2b_decompress_asm_fast_safe_le16:
F(ucl_nrv2b_decompress_asm_fast_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,202,1,0,0,137
db 3,137,240,3,67,44,15,130,189,1,0,0,137,67,4,131
db 232,2,15,130,131,1,0,0,57,240,15,130,123,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,97,1,0,0,59,60,36,15,131,120
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,65,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,34,1,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,56,1,0,0,102,1,219,115,219,117
db 21,59,116,36,8,15,135,0,1,0,0,102,139,30,131,238
db 254,102,17,219,115,196,61,2,0,0,1,15,135,17,1,0
db 0,131,232,3,114,27,193,224,8,59,116,36,4,15,131,216
db 0,0,0,138,6,70,131,240,255,15,132,193,0,0,0,137
db 197,102,1,219,117,19,59,116,36,8,15,135,187,0,0,0
db 102,139,30,131,238,254,102,17,219,17,201,102,1,219,117,19
db 59,116,36,8,15,135,161,0,0,0,102,139,30,131,238,254
db 102,17,219,17,201,117,60,65,102,1,219,117,19,59,116,36
db 8,15,135,132,0,0,0,102,139,30,131,238,254,102,17,219
db 17,201,15,136,147,0,0,0,102,1,219,115,219,117,17,59
db 116,36,8,119,102,102,139,30,131,238,254,102,17,219,115,200
db 131,193,2,129,253,0,243,255,255,131,209,1,137,250,1,202
db 114,105,59,20,36,119,100,137,250,1,234,115,101,59,84,36
db 48,114,95,131,253,252,118,16,138,2,66,136,7,71,73,117
db 247,233,211,254,255,255,144,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,185,254,255,255
db 59,60,36,119,38,59,116,36,4,118,7,184,55,255,255,255
db 235,5,116,3,72,176,51,43,124,36,48,139,84,36,52,137
db 58,131,196,12,90,89,91,94,95,93,195,184,54,255,255,255
db 235,229,184,53,255,255,255,235,222,131,200,255,235,217,144,144

globalf(_ucl_nrv2b_decompress_asm_le32)
globalf(F(ucl_nrv2b_decompress_asm_le32))
_ucl_nrv2b_decompress_asm_le32:
F(ucl_nrv2b_decompress_asm_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,239,117,9,139,30,131
db 238,252,17,219,115,228,131,232,3,114,13,193,224,8,138,6
db 70,131,240,255,116,88,137,197,1,219,117,7,139,30,131,238
db 252,17,219,17,201,1,219,117,7,139,30,131,238,252,17,219
db 17,201,117,32,65,1,219,117,7,139,30,131,238,252,17,219
db 17,201,1,219,115,239,117,9,139,30,131,238,252,17,219,115
db 228,131,193,2,129,253,0,243,255,255,131,209,1,141,20,47
db 138,2,66,136,7,71,73,117,247,233,104,255,255,255,137,227
db 139,83,28,3,83,32,57,214,116,7,72,176,55,119,2,176
db 51,43,123,36,139,83,40,137,58,90,89,91,94,95,93,195

globalf(_ucl_nrv2b_decompress_asm_safe_le32)
globalf(F(ucl_nrv2b_decompress_asm_safe_le32))
_ucl_nrv2b_decompress_asm_safe_le32:
F(ucl_nrv2b_decompress_asm_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,138,1,0,0,137
db 3,137,240,3,67,44,15,130,125,1,0,0,137,67,4,131
db 232,4,15,130,67,1,0,0,57,240,15,130,59,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,33,1,0,0,59,60,36,15,131,56
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,2,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,230,0,0,0,139,30,131,238,252,17,219,17,192,15,136
db 254,0,0,0,1,219,115,223,117,19,59,116,36,8,15,135
db 199,0,0,0,139,30,131,238,252,17,219,115,202,61,2,0
db 0,1,15,135,218,0,0,0,131,232,3,114,27,193,224,8
db 59,116,36,4,15,131,161,0,0,0,138,6,70,131,240,255
db 15,132,138,0,0,0,137,197,1,219,117,17,59,116,36,8
db 15,135,133,0,0,0,139,30,131,238,252,17,219,17,201,1
db 219,117,13,59,116,36,8,119,114,139,30,131,238,252,17,219
db 17,201,117,46,65,1,219,117,13,59,116,36,8,119,92,139
db 30,131,238,252,17,219,17,201,120,113,1,219,115,231,117,15
db 59,116,36,8,119,69,139,30,131,238,252,17,219,115,214,131
db 193,2,129,253,0,243,255,255,131,209,1,137,250,1,202,114
db 74,59,20,36,119,69,137,250,1,234,115,70,59,84,36,48
db 114,64,138,2,66,136,7,71,73,117,247,233,249,254,255,255
db 59,60,36,119,38,59,116,36,4,118,7,184,55,255,255,255
db 235,5,116,3,72,176,51,43,124,36,48,139,84,36,52,137
db 58,131,196,12,90,89,91,94,95,93,195,184,54,255,255,255
db 235,229,184,53,255,255,255,235,222,131,200,255,235,217,144,144

globalf(_ucl_nrv2b_decompress_asm_8)
globalf(F(ucl_nrv2b_decompress_asm_8))
_ucl_nrv2b_decompress_asm_8:
F(ucl_nrv2b_decompress_asm_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,241,117,7,138,30,70,16,219,115,232
db 131,232,3,114,13,193,224,8,138,6,70,131,240,255,116,80
db 137,197,0,219,117,5,138,30,70,16,219,17,201,0,219,117
db 5,138,30,70,16,219,17,201,117,28,65,0,219,117,5,138
db 30,70,16,219,17,201,0,219,115,241,117,7,138,30,70,16
db 219,115,232,131,193,2,129,253,0,243,255,255,131,209,1,141
db 20,47,138,2,66,136,7,71,73,117,247,233,118,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_safe_8)
globalf(F(ucl_nrv2b_decompress_asm_safe_8))
_ucl_nrv2b_decompress_asm_safe_8:
F(ucl_nrv2b_decompress_asm_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,100,1,0,0,137
db 3,137,240,3,67,40,15,130,87,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,11,1,0,0,59,60,36,15,131,34
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,236,0,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,210
db 0,0,0,138,30,70,16,219,17,192,15,136,236,0,0,0
db 0,219,115,225,117,17,59,116,36,4,15,131,181,0,0,0
db 138,30,70,16,219,115,206,61,2,0,0,1,15,135,202,0
db 0,0,131,232,3,114,23,193,224,8,59,116,36,4,15,131
db 145,0,0,0,138,6,70,131,240,255,116,126,137,197,0,219
db 117,11,59,116,36,4,115,125,138,30,70,16,219,17,201,0
db 219,117,11,59,116,36,4,115,108,138,30,70,16,219,17,201
db 117,42,65,0,219,117,11,59,116,36,4,115,88,138,30,70
db 16,219,17,201,120,111,0,219,115,233,117,13,59,116,36,4
db 115,67,138,30,70,16,219,115,218,131,193,2,129,253,0,243
db 255,255,131,209,1,137,250,1,202,114,74,59,20,36,119,69
db 137,250,1,234,115,70,59,84,36,44,114,64,138,2,66,136
db 7,71,73,117,247,233,15,255,255,255,59,60,36,119,38,59
db 116,36,4,118,7,184,55,255,255,255,235,5,116,3,72,176
db 51,43,124,36,44,139,84,36,48,137,58,131,196,8,90,89
db 91,94,95,93,195,184,54,255,255,255,235,229,184,53,255,255
db 255,235,222,131,200,255,235,217,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_le16)
globalf(F(ucl_nrv2b_decompress_asm_le16))
_ucl_nrv2b_decompress_asm_le16:
F(ucl_nrv2b_decompress_asm_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,235,117,11,102,139,30,131,238,254,102,17,219,115,222,131
db 232,3,114,13,193,224,8,138,6,70,131,240,255,116,100,137
db 197,102,1,219,117,9,102,139,30,131,238,254,102,17,219,17
db 201,102,1,219,117,9,102,139,30,131,238,254,102,17,219,17
db 201,117,38,65,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,17,201,102,1,219,115,235,117,11,102,139,30,131,238
db 254,102,17,219,115,222,131,193,2,129,253,0,243,255,255,131
db 209,1,141,20,47,138,2,66,136,7,71,73,117,247,233,83
db 255,255,255,137,227,139,83,28,3,83,32,57,214,116,7,72
db 176,55,119,2,176,51,43,123,36,139,83,40,137,58,90,89
db 91,94,95,93,195,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_safe_le16)
globalf(F(ucl_nrv2b_decompress_asm_safe_le16))
_ucl_nrv2b_decompress_asm_safe_le16:
F(ucl_nrv2b_decompress_asm_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,159,1,0,0,137
db 3,137,240,3,67,44,15,130,146,1,0,0,137,67,4,131
db 232,2,15,130,88,1,0,0,57,240,15,130,80,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,54,1,0,0,59,60,36,15,131,77
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,22,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,247,0,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,13,1,0,0,102,1,219,115,219,117
db 21,59,116,36,8,15,135,213,0,0,0,102,139,30,131,238
db 254,102,17,219,115,196,61,2,0,0,1,15,135,230,0,0
db 0,131,232,3,114,27,193,224,8,59,116,36,4,15,131,173
db 0,0,0,138,6,70,131,240,255,15,132,150,0,0,0,137
db 197,102,1,219,117,19,59,116,36,8,15,135,144,0,0,0
db 102,139,30,131,238,254,102,17,219,17,201,102,1,219,117,15
db 59,116,36,8,119,122,102,139,30,131,238,254,102,17,219,17
db 201,117,52,65,102,1,219,117,15,59,116,36,8,119,97,102
db 139,30,131,238,254,102,17,219,17,201,120,116,102,1,219,115
db 227,117,17,59,116,36,8,119,71,102,139,30,131,238,254,102
db 17,219,115,208,131,193,2,129,253,0,243,255,255,131,209,1
db 137,250,1,202,114,74,59,20,36,119,69,137,250,1,234,115
db 70,59,84,36,48,114,64,138,2,66,136,7,71,73,117,247
db 233,228,254,255,255,59,60,36,119,38,59,116,36,4,118,7
db 184,55,255,255,255,235,5,116,3,72,176,51,43,124,36,48
db 139,84,36,52,137,58,131,196,12,90,89,91,94,95,93,195
db 184,54,255,255,255,235,229,184,53,255,255,255,235,222,131,200
db 255,235,217,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_le32)
globalf(F(ucl_nrv2b_decompress_asm_small_le32))
_ucl_nrv2b_decompress_asm_small_le32:
F(ucl_nrv2b_decompress_asm_small_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,5,164,1,219,117,7,139,30,131,238,252
db 17,219,114,242,49,192,64,1,219,117,7,139,30,131,238,252
db 17,219,17,192,1,219,117,7,139,30,131,238,252,17,219,115
db 230,131,232,3,114,11,193,224,8,172,131,240,255,116,81,137
db 197,1,219,117,7,139,30,131,238,252,17,219,17,201,1,219
db 117,7,139,30,131,238,252,17,219,17,201,117,30,65,1,219
db 117,7,139,30,131,238,252,17,219,17,201,1,219,117,7,139
db 30,131,238,252,17,219,115,230,131,193,2,129,253,0,243,255
db 255,131,209,1,86,141,52,47,243,164,94,233,119,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_safe_le32)
globalf(F(ucl_nrv2b_decompress_asm_small_safe_le32))
_ucl_nrv2b_decompress_asm_small_safe_le32:
F(ucl_nrv2b_decompress_asm_small_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,114,1,0,0,137
db 3,137,240,3,67,44,15,130,101,1,0,0,137,67,4,131
db 232,4,15,130,43,1,0,0,57,240,15,130,35,1,0,0
db 137,67,8,131,205,255,49,201,235,24,59,116,36,4,15,131
db 15,1,0,0,59,60,36,15,131,38,1,0,0,164,1,219
db 117,17,59,116,36,8,15,135,247,0,0,0,139,30,131,238
db 252,17,219,114,213,49,192,64,1,219,117,17,59,116,36,8
db 15,135,221,0,0,0,139,30,131,238,252,17,219,17,192,15
db 136,245,0,0,0,1,219,117,17,59,116,36,8,15,135,192
db 0,0,0,139,30,131,238,252,17,219,115,204,61,2,0,0
db 1,15,135,211,0,0,0,131,232,3,114,25,193,224,8,59
db 116,36,4,15,131,154,0,0,0,172,131,240,255,15,132,133
db 0,0,0,137,197,1,219,117,17,59,116,36,8,15,135,128
db 0,0,0,139,30,131,238,252,17,219,17,201,1,219,117,13
db 59,116,36,8,119,109,139,30,131,238,252,17,219,17,201,117
db 44,65,1,219,117,13,59,116,36,8,119,87,139,30,131,238
db 252,17,219,17,201,120,108,1,219,117,13,59,116,36,8,119
db 66,139,30,131,238,252,17,219,115,216,131,193,2,129,253,0
db 243,255,255,131,209,1,137,242,137,254,1,206,114,69,59,52
db 36,119,64,137,254,1,238,115,65,59,116,36,48,114,59,243
db 164,137,214,233,6,255,255,255,59,60,36,119,38,59,116,36
db 4,118,7,184,55,255,255,255,235,5,116,3,72,176,51,43
db 124,36,48,139,84,36,52,137,58,131,196,12,90,89,91,94
db 95,93,195,184,54,255,255,255,235,229,184,53,255,255,255,235
db 222,131,200,255,235,217,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_8)
globalf(F(ucl_nrv2b_decompress_asm_small_8))
_ucl_nrv2b_decompress_asm_small_8:
F(ucl_nrv2b_decompress_asm_small_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,5,164,0,219,117,5,138,30,70,16
db 219,114,244,49,192,64,0,219,117,5,138,30,70,16,219,17
db 192,0,219,117,5,138,30,70,16,219,115,234,131,232,3,114
db 11,193,224,8,172,131,240,255,116,70,137,197,0,219,117,5
db 138,30,70,16,219,17,201,0,219,117,5,138,30,70,16,219
db 17,201,117,26,65,0,219,117,5,138,30,70,16,219,17,201
db 0,219,117,5,138,30,70,16,219,115,234,131,193,2,129,253
db 0,243,255,255,131,209,1,86,141,52,47,243,164,94,235,136
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_safe_8)
globalf(F(ucl_nrv2b_decompress_asm_small_safe_8))
_ucl_nrv2b_decompress_asm_small_safe_8:
F(ucl_nrv2b_decompress_asm_small_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,72,1,0,0,137
db 3,137,240,3,67,40,15,130,59,1,0,0,137,67,4,131
db 205,255,49,201,235,24,59,116,36,4,15,131,249,0,0,0
db 59,60,36,15,131,16,1,0,0,164,0,219,117,15,59,116
db 36,4,15,131,225,0,0,0,138,30,70,16,219,114,215,49
db 192,64,0,219,117,15,59,116,36,4,15,131,201,0,0,0
db 138,30,70,16,219,17,192,15,136,227,0,0,0,0,219,117
db 15,59,116,36,4,15,131,174,0,0,0,138,30,70,16,219
db 115,208,61,2,0,0,1,15,135,195,0,0,0,131,232,3
db 114,21,193,224,8,59,116,36,4,15,131,138,0,0,0,172
db 131,240,255,116,121,137,197,0,219,117,11,59,116,36,4,115
db 120,138,30,70,16,219,17,201,0,219,117,11,59,116,36,4
db 115,103,138,30,70,16,219,17,201,117,40,65,0,219,117,11
db 59,116,36,4,115,83,138,30,70,16,219,17,201,120,106,0
db 219,117,11,59,116,36,4,115,64,138,30,70,16,219,115,220
db 131,193,2,129,253,0,243,255,255,131,209,1,137,242,137,254
db 1,206,114,69,59,52,36,119,64,137,254,1,238,115,65,59
db 116,36,44,114,59,243,164,137,214,233,28,255,255,255,59,60
db 36,119,38,59,116,36,4,118,7,184,55,255,255,255,235,5
db 116,3,72,176,51,43,124,36,44,139,84,36,48,137,58,131
db 196,8,90,89,91,94,95,93,195,184,54,255,255,255,235,229
db 184,53,255,255,255,235,222,131,200,255,235,217,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_le16)
globalf(F(ucl_nrv2b_decompress_asm_small_le16))
_ucl_nrv2b_decompress_asm_small_le16:
F(ucl_nrv2b_decompress_asm_small_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,6,164,102,1,219,117,9,102,139,30,131
db 238,254,102,17,219,114,239,49,192,64,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,17,192,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,115,224,131,232,3,114,11,193
db 224,8,172,131,240,255,116,93,137,197,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,17,201,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,17,201,117,36,65,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,201,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,115,224,131,193,2
db 129,253,0,243,255,255,131,209,1,86,141,52,47,243,164,94
db 233,98,255,255,255,137,227,139,83,28,3,83,32,57,214,116
db 7,72,176,55,119,2,176,51,43,123,36,139,83,40,137,58
db 90,89,91,94,95,93,195,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2b_decompress_asm_small_safe_le16)
globalf(F(ucl_nrv2b_decompress_asm_small_safe_le16))
_ucl_nrv2b_decompress_asm_small_safe_le16:
F(ucl_nrv2b_decompress_asm_small_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,135,1,0,0,137
db 3,137,240,3,67,44,15,130,122,1,0,0,137,67,4,131
db 232,2,15,130,64,1,0,0,57,240,15,130,56,1,0,0
db 137,67,8,131,205,255,49,201,235,25,59,116,36,4,15,131
db 36,1,0,0,59,60,36,15,131,59,1,0,0,164,102,1
db 219,117,19,59,116,36,8,15,135,11,1,0,0,102,139,30
db 131,238,254,102,17,219,114,210,49,192,64,102,1,219,117,19
db 59,116,36,8,15,135,238,0,0,0,102,139,30,131,238,254
db 102,17,219,17,192,15,136,4,1,0,0,102,1,219,117,19
db 59,116,36,8,15,135,206,0,0,0,102,139,30,131,238,254
db 102,17,219,115,198,61,2,0,0,1,15,135,223,0,0,0
db 131,232,3,114,25,193,224,8,59,116,36,4,15,131,166,0
db 0,0,172,131,240,255,15,132,145,0,0,0,137,197,102,1
db 219,117,19,59,116,36,8,15,135,139,0,0,0,102,139,30
db 131,238,254,102,17,219,17,201,102,1,219,117,15,59,116,36
db 8,119,117,102,139,30,131,238,254,102,17,219,17,201,117,50
db 65,102,1,219,117,15,59,116,36,8,119,92,102,139,30,131
db 238,254,102,17,219,17,201,120,111,102,1,219,117,15,59,116
db 36,8,119,68,102,139,30,131,238,254,102,17,219,115,210,131
db 193,2,129,253,0,243,255,255,131,209,1,137,242,137,254,1
db 206,114,69,59,52,36,119,64,137,254,1,238,115,65,59,116
db 36,48,114,59,243,164,137,214,233,241,254,255,255,59,60,36
db 119,38,59,116,36,4,118,7,184,55,255,255,255,235,5,116
db 3,72,176,51,43,124,36,48,139,84,36,52,137,58,131,196
db 12,90,89,91,94,95,93,195,184,54,255,255,255,235,229,184
db 53,255,255,255,235,222,131,200,255,235,217,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_le32)
globalf(F(ucl_nrv2d_decompress_asm_fast_le32))
_ucl_nrv2d_decompress_asm_fast_le32:
F(ucl_nrv2d_decompress_asm_fast_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,11,117,25,139,30,131
db 238,252,17,219,114,16,72,1,219,117,7,139,30,131,238,252
db 17,219,17,192,235,212,131,232,3,114,17,193,224,8,138,6
db 70,131,240,255,116,122,209,248,137,197,235,11,1,219,117,7
db 139,30,131,238,252,17,219,17,201,1,219,117,7,139,30,131
db 238,252,17,219,17,201,117,32,65,1,219,117,7,139,30,131
db 238,252,17,219,17,201,1,219,115,239,117,9,139,30,131,238
db 252,17,219,115,228,131,193,2,129,253,0,251,255,255,131,209
db 1,141,20,47,131,253,252,118,15,138,2,66,136,7,71,73
db 117,247,233,79,255,255,255,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,54,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_safe_le32)
globalf(F(ucl_nrv2d_decompress_asm_fast_safe_le32))
_ucl_nrv2d_decompress_asm_fast_safe_le32:
F(ucl_nrv2d_decompress_asm_fast_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,218,1,0,0,137
db 3,137,240,3,67,44,15,130,205,1,0,0,137,67,4,131
db 232,4,15,130,147,1,0,0,57,240,15,130,139,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,113,1,0,0,59,60,36,15,131,136
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,82,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,54,1,0,0,139,30,131,238,252,17,219,17,192,15,136
db 78,1,0,0,1,219,115,21,117,51,59,116,36,8,15,135
db 23,1,0,0,139,30,131,238,252,17,219,114,32,72,1,219
db 117,17,59,116,36,8,15,135,255,0,0,0,139,30,131,238
db 252,17,219,17,192,15,136,23,1,0,0,235,170,61,2,0
db 0,1,15,135,10,1,0,0,131,232,3,114,37,193,224,8
db 59,116,36,4,15,131,209,0,0,0,138,6,70,131,240,255
db 15,132,186,0,0,0,15,137,230,0,0,0,209,248,137,197
db 235,21,1,219,117,17,59,116,36,8,15,135,171,0,0,0
db 139,30,131,238,252,17,219,17,201,1,219,117,17,59,116,36
db 8,15,135,148,0,0,0,139,30,131,238,252,17,219,17,201
db 117,50,65,1,219,117,13,59,116,36,8,119,126,139,30,131
db 238,252,17,219,17,201,15,136,143,0,0,0,1,219,115,227
db 117,15,59,116,36,8,119,99,139,30,131,238,252,17,219,115
db 210,131,193,2,129,253,0,251,255,255,131,209,1,137,250,1
db 202,114,104,59,20,36,119,99,137,250,1,234,115,100,59,84
db 36,48,114,94,131,253,252,118,15,138,2,66,136,7,71,73
db 117,247,233,194,254,255,255,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,169,254,255,255
db 59,60,36,119,38,59,116,36,4,118,7,184,55,255,255,255
db 235,5,116,3,72,176,51,43,124,36,48,139,84,36,52,137
db 58,131,196,12,90,89,91,94,95,93,195,184,54,255,255,255
db 235,229,184,53,255,255,255,235,222,131,200,255,235,217,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_8)
globalf(F(ucl_nrv2d_decompress_asm_fast_8))
_ucl_nrv2d_decompress_asm_fast_8:
F(ucl_nrv2d_decompress_asm_fast_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,9,117,21,138,30,70,16,219,114,14
db 72,0,219,117,5,138,30,70,16,219,17,192,235,218,131,232
db 3,114,17,193,224,8,138,6,70,131,240,255,116,114,209,248
db 137,197,235,9,0,219,117,5,138,30,70,16,219,17,201,0
db 219,117,5,138,30,70,16,219,17,201,117,28,65,0,219,117
db 5,138,30,70,16,219,17,201,0,219,115,241,117,7,138,30
db 70,16,219,115,232,131,193,2,129,253,0,251,255,255,131,209
db 1,141,20,47,131,253,252,118,15,138,2,66,136,7,71,73
db 117,247,233,95,255,255,255,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,70,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_safe_8)
globalf(F(ucl_nrv2d_decompress_asm_fast_safe_8))
_ucl_nrv2d_decompress_asm_fast_safe_8:
F(ucl_nrv2d_decompress_asm_fast_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,186,1,0,0,137
db 3,137,240,3,67,40,15,130,173,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,97,1,0,0,59,60,36,15,131,120
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,66,1,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,40
db 1,0,0,138,30,70,16,219,17,192,15,136,66,1,0,0
db 0,219,115,19,117,47,59,116,36,4,15,131,11,1,0,0
db 138,30,70,16,219,114,30,72,0,219,117,15,59,116,36,4
db 15,131,245,0,0,0,138,30,70,16,219,17,192,15,136,15
db 1,0,0,235,176,61,2,0,0,1,15,135,2,1,0,0
db 131,232,3,114,37,193,224,8,59,116,36,4,15,131,201,0
db 0,0,138,6,70,131,240,255,15,132,178,0,0,0,15,137
db 222,0,0,0,209,248,137,197,235,19,0,219,117,15,59,116
db 36,4,15,131,163,0,0,0,138,30,70,16,219,17,201,0
db 219,117,15,59,116,36,4,15,131,142,0,0,0,138,30,70
db 16,219,17,201,117,46,65,0,219,117,11,59,116,36,4,115
db 122,138,30,70,16,219,17,201,15,136,141,0,0,0,0,219
db 115,229,117,13,59,116,36,4,115,97,138,30,70,16,219,115
db 214,131,193,2,129,253,0,251,255,255,131,209,1,137,250,1
db 202,114,104,59,20,36,119,99,137,250,1,234,115,100,59,84
db 36,44,114,94,131,253,252,118,15,138,2,66,136,7,71,73
db 117,247,233,210,254,255,255,144,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,185,254,255,255
db 59,60,36,119,38,59,116,36,4,118,7,184,55,255,255,255
db 235,5,116,3,72,176,51,43,124,36,44,139,84,36,48,137
db 58,131,196,8,90,89,91,94,95,93,195,184,54,255,255,255
db 235,229,184,53,255,255,255,235,222,131,200,255,235,217,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_le16)
globalf(F(ucl_nrv2d_decompress_asm_fast_le16))
_ucl_nrv2d_decompress_asm_fast_le16:
F(ucl_nrv2d_decompress_asm_fast_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,13,117,30,102,139,30,131,238,254,102,17,219,114,19,72
db 102,1,219,117,9,102,139,30,131,238,254,102,17,219,17,192
db 235,203,131,232,3,114,21,193,224,8,138,6,70,131,240,255
db 15,132,134,0,0,0,209,248,137,197,235,14,102,1,219,117
db 9,102,139,30,131,238,254,102,17,219,17,201,102,1,219,117
db 9,102,139,30,131,238,254,102,17,219,17,201,117,38,65,102
db 1,219,117,9,102,139,30,131,238,254,102,17,219,17,201,102
db 1,219,115,235,117,11,102,139,30,131,238,254,102,17,219,115
db 222,131,193,2,129,253,0,251,255,255,131,209,1,141,20,47
db 131,253,252,118,15,138,2,66,136,7,71,73,117,247,233,51
db 255,255,255,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,26,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2d_decompress_asm_fast_safe_le16)
globalf(F(ucl_nrv2d_decompress_asm_fast_safe_le16))
_ucl_nrv2d_decompress_asm_fast_safe_le16:
F(ucl_nrv2d_decompress_asm_fast_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,246,1,0,0,137
db 3,137,240,3,67,44,15,130,233,1,0,0,137,67,4,131
db 232,2,15,130,175,1,0,0,57,240,15,130,167,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,141,1,0,0,59,60,36,15,131,164
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,109,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,78,1,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,100,1,0,0,102,1,219,115,23,117
db 56,59,116,36,8,15,135,44,1,0,0,102,139,30,131,238
db 254,102,17,219,114,35,72,102,1,219,117,19,59,116,36,8
db 15,135,17,1,0,0,102,139,30,131,238,254,102,17,219,17
db 192,15,136,39,1,0,0,235,161,61,2,0,0,1,15,135
db 26,1,0,0,131,232,3,114,37,193,224,8,59,116,36,4
db 15,131,225,0,0,0,138,6,70,131,240,255,15,132,202,0
db 0,0,15,137,246,0,0,0,209,248,137,197,235,24,102,1
db 219,117,19,59,116,36,8,15,135,186,0,0,0,102,139,30
db 131,238,254,102,17,219,17,201,102,1,219,117,19,59,116,36
db 8,15,135,160,0,0,0,102,139,30,131,238,254,102,17,219
db 17,201,117,60,65,102,1,219,117,19,59,116,36,8,15,135
db 131,0,0,0,102,139,30,131,238,254,102,17,219,17,201,15
db 136,146,0,0,0,102,1,219,115,219,117,17,59,116,36,8
db 119,101,102,139,30,131,238,254,102,17,219,115,200,131,193,2
db 129,253,0,251,255,255,131,209,1,137,250,1,202,114,104,59
db 20,36,119,99,137,250,1,234,115,100,59,84,36,48,114,94
db 131,253,252,118,15,138,2,66,136,7,71,73,117,247,233,166
db 254,255,255,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,141,254,255,255,59,60,36,119
db 38,59,116,36,4,118,7,184,55,255,255,255,235,5,116,3
db 72,176,51,43,124,36,48,139,84,36,52,137,58,131,196,12
db 90,89,91,94,95,93,195,184,54,255,255,255,235,229,184,53
db 255,255,255,235,222,131,200,255,235,217,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_le32)
globalf(F(ucl_nrv2d_decompress_asm_le32))
_ucl_nrv2d_decompress_asm_le32:
F(ucl_nrv2d_decompress_asm_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,11,117,25,139,30,131
db 238,252,17,219,114,16,72,1,219,117,7,139,30,131,238,252
db 17,219,17,192,235,212,131,232,3,114,17,193,224,8,138,6
db 70,131,240,255,116,92,209,248,137,197,235,11,1,219,117,7
db 139,30,131,238,252,17,219,17,201,1,219,117,7,139,30,131
db 238,252,17,219,17,201,117,32,65,1,219,117,7,139,30,131
db 238,252,17,219,17,201,1,219,115,239,117,9,139,30,131,238
db 252,17,219,115,228,131,193,2,129,253,0,251,255,255,131,209
db 1,141,20,47,138,2,66,136,7,71,73,117,247,233,84,255
db 255,255,137,227,139,83,28,3,83,32,57,214,116,7,72,176
db 55,119,2,176,51,43,123,36,139,83,40,137,58,90,89,91
db 94,95,93,195,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_safe_le32)
globalf(F(ucl_nrv2d_decompress_asm_safe_le32))
_ucl_nrv2d_decompress_asm_safe_le32:
F(ucl_nrv2d_decompress_asm_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,180,1,0,0,137
db 3,137,240,3,67,44,15,130,167,1,0,0,137,67,4,131
db 232,4,15,130,109,1,0,0,57,240,15,130,101,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,75,1,0,0,59,60,36,15,131,98
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,44,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,16,1,0,0,139,30,131,238,252,17,219,17,192,15,136
db 40,1,0,0,1,219,115,21,117,51,59,116,36,8,15,135
db 241,0,0,0,139,30,131,238,252,17,219,114,32,72,1,219
db 117,17,59,116,36,8,15,135,217,0,0,0,139,30,131,238
db 252,17,219,17,192,15,136,241,0,0,0,235,170,61,2,0
db 0,1,15,135,228,0,0,0,131,232,3,114,37,193,224,8
db 59,116,36,4,15,131,171,0,0,0,138,6,70,131,240,255
db 15,132,148,0,0,0,15,137,192,0,0,0,209,248,137,197
db 235,21,1,219,117,17,59,116,36,8,15,135,133,0,0,0
db 139,30,131,238,252,17,219,17,201,1,219,117,13,59,116,36
db 8,119,114,139,30,131,238,252,17,219,17,201,117,46,65,1
db 219,117,13,59,116,36,8,119,92,139,30,131,238,252,17,219
db 17,201,120,113,1,219,115,231,117,15,59,116,36,8,119,69
db 139,30,131,238,252,17,219,115,214,131,193,2,129,253,0,251
db 255,255,131,209,1,137,250,1,202,114,74,59,20,36,119,69
db 137,250,1,234,115,70,59,84,36,48,114,64,138,2,66,136
db 7,71,73,117,247,233,207,254,255,255,59,60,36,119,38,59
db 116,36,4,118,7,184,55,255,255,255,235,5,116,3,72,176
db 51,43,124,36,48,139,84,36,52,137,58,131,196,12,90,89
db 91,94,95,93,195,184,54,255,255,255,235,229,184,53,255,255
db 255,235,222,131,200,255,235,217,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_8)
globalf(F(ucl_nrv2d_decompress_asm_8))
_ucl_nrv2d_decompress_asm_8:
F(ucl_nrv2d_decompress_asm_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,9,117,21,138,30,70,16,219,114,14
db 72,0,219,117,5,138,30,70,16,219,17,192,235,218,131,232
db 3,114,17,193,224,8,138,6,70,131,240,255,116,84,209,248
db 137,197,235,9,0,219,117,5,138,30,70,16,219,17,201,0
db 219,117,5,138,30,70,16,219,17,201,117,28,65,0,219,117
db 5,138,30,70,16,219,17,201,0,219,115,241,117,7,138,30
db 70,16,219,115,232,131,193,2,129,253,0,251,255,255,131,209
db 1,141,20,47,138,2,66,136,7,71,73,117,247,233,100,255
db 255,255,137,227,139,83,28,3,83,32,57,214,116,7,72,176
db 55,119,2,176,51,43,123,36,139,83,40,137,58,90,89,91
db 94,95,93,195,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_safe_8)
globalf(F(ucl_nrv2d_decompress_asm_safe_8))
_ucl_nrv2d_decompress_asm_safe_8:
F(ucl_nrv2d_decompress_asm_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,144,1,0,0,137
db 3,137,240,3,67,40,15,130,131,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,55,1,0,0,59,60,36,15,131,78
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,24,1,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,254
db 0,0,0,138,30,70,16,219,17,192,15,136,24,1,0,0
db 0,219,115,19,117,47,59,116,36,4,15,131,225,0,0,0
db 138,30,70,16,219,114,30,72,0,219,117,15,59,116,36,4
db 15,131,203,0,0,0,138,30,70,16,219,17,192,15,136,229
db 0,0,0,235,176,61,2,0,0,1,15,135,216,0,0,0
db 131,232,3,114,37,193,224,8,59,116,36,4,15,131,159,0
db 0,0,138,6,70,131,240,255,15,132,136,0,0,0,15,137
db 180,0,0,0,209,248,137,197,235,15,0,219,117,11,59,116
db 36,4,115,125,138,30,70,16,219,17,201,0,219,117,11,59
db 116,36,4,115,108,138,30,70,16,219,17,201,117,42,65,0
db 219,117,11,59,116,36,4,115,88,138,30,70,16,219,17,201
db 120,111,0,219,115,233,117,13,59,116,36,4,115,67,138,30
db 70,16,219,115,218,131,193,2,129,253,0,251,255,255,131,209
db 1,137,250,1,202,114,74,59,20,36,119,69,137,250,1,234
db 115,70,59,84,36,44,114,64,138,2,66,136,7,71,73,117
db 247,233,227,254,255,255,59,60,36,119,38,59,116,36,4,118
db 7,184,55,255,255,255,235,5,116,3,72,176,51,43,124,36
db 44,139,84,36,48,137,58,131,196,8,90,89,91,94,95,93
db 195,184,54,255,255,255,235,229,184,53,255,255,255,235,222,131
db 200,255,235,217,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_le16)
globalf(F(ucl_nrv2d_decompress_asm_le16))
_ucl_nrv2d_decompress_asm_le16:
F(ucl_nrv2d_decompress_asm_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,13,117,30,102,139,30,131,238,254,102,17,219,114,19,72
db 102,1,219,117,9,102,139,30,131,238,254,102,17,219,17,192
db 235,203,131,232,3,114,17,193,224,8,138,6,70,131,240,255
db 116,104,209,248,137,197,235,14,102,1,219,117,9,102,139,30
db 131,238,254,102,17,219,17,201,102,1,219,117,9,102,139,30
db 131,238,254,102,17,219,17,201,117,38,65,102,1,219,117,9
db 102,139,30,131,238,254,102,17,219,17,201,102,1,219,115,235
db 117,11,102,139,30,131,238,254,102,17,219,115,222,131,193,2
db 129,253,0,251,255,255,131,209,1,141,20,47,138,2,66,136
db 7,71,73,117,247,233,60,255,255,255,137,227,139,83,28,3
db 83,32,57,214,116,7,72,176,55,119,2,176,51,43,123,36
db 139,83,40,137,58,90,89,91,94,95,93,195,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_safe_le16)
globalf(F(ucl_nrv2d_decompress_asm_safe_le16))
_ucl_nrv2d_decompress_asm_safe_le16:
F(ucl_nrv2d_decompress_asm_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,204,1,0,0,137
db 3,137,240,3,67,44,15,130,191,1,0,0,137,67,4,131
db 232,2,15,130,133,1,0,0,57,240,15,130,125,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,99,1,0,0,59,60,36,15,131,122
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,67,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,36,1,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,58,1,0,0,102,1,219,115,23,117
db 56,59,116,36,8,15,135,2,1,0,0,102,139,30,131,238
db 254,102,17,219,114,35,72,102,1,219,117,19,59,116,36,8
db 15,135,231,0,0,0,102,139,30,131,238,254,102,17,219,17
db 192,15,136,253,0,0,0,235,161,61,2,0,0,1,15,135
db 240,0,0,0,131,232,3,114,37,193,224,8,59,116,36,4
db 15,131,183,0,0,0,138,6,70,131,240,255,15,132,160,0
db 0,0,15,137,204,0,0,0,209,248,137,197,235,24,102,1
db 219,117,19,59,116,36,8,15,135,144,0,0,0,102,139,30
db 131,238,254,102,17,219,17,201,102,1,219,117,15,59,116,36
db 8,119,122,102,139,30,131,238,254,102,17,219,17,201,117,52
db 65,102,1,219,117,15,59,116,36,8,119,97,102,139,30,131
db 238,254,102,17,219,17,201,120,116,102,1,219,115,227,117,17
db 59,116,36,8,119,71,102,139,30,131,238,254,102,17,219,115
db 208,131,193,2,129,253,0,251,255,255,131,209,1,137,250,1
db 202,114,74,59,20,36,119,69,137,250,1,234,115,70,59,84
db 36,48,114,64,138,2,66,136,7,71,73,117,247,233,183,254
db 255,255,59,60,36,119,38,59,116,36,4,118,7,184,55,255
db 255,255,235,5,116,3,72,176,51,43,124,36,48,139,84,36
db 52,137,58,131,196,12,90,89,91,94,95,93,195,184,54,255
db 255,255,235,229,184,53,255,255,255,235,222,131,200,255,235,217

globalf(_ucl_nrv2d_decompress_asm_small_le32)
globalf(F(ucl_nrv2d_decompress_asm_small_le32))
_ucl_nrv2d_decompress_asm_small_le32:
F(ucl_nrv2d_decompress_asm_small_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,5,164,1,219,117,7,139,30,131,238,252
db 17,219,114,242,49,192,64,1,219,117,7,139,30,131,238,252
db 17,219,17,192,1,219,117,7,139,30,131,238,252,17,219,114
db 16,72,1,219,117,7,139,30,131,238,252,17,219,17,192,235
db 214,131,232,3,114,15,193,224,8,172,131,240,255,116,85,209
db 248,137,197,235,11,1,219,117,7,139,30,131,238,252,17,219
db 17,201,1,219,117,7,139,30,131,238,252,17,219,17,201,117
db 30,65,1,219,117,7,139,30,131,238,252,17,219,17,201,1
db 219,117,7,139,30,131,238,252,17,219,115,230,131,193,2,129
db 253,0,251,255,255,131,209,1,86,141,52,47,243,164,94,233
db 99,255,255,255,137,227,139,83,28,3,83,32,57,214,116,7
db 72,176,55,119,2,176,51,43,123,36,139,83,40,137,58,90
db 89,91,94,95,93,195,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_small_safe_le32)
globalf(F(ucl_nrv2d_decompress_asm_small_safe_le32))
_ucl_nrv2d_decompress_asm_small_safe_le32:
F(ucl_nrv2d_decompress_asm_small_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,156,1,0,0,137
db 3,137,240,3,67,44,15,130,143,1,0,0,137,67,4,131
db 232,4,15,130,85,1,0,0,57,240,15,130,77,1,0,0
db 137,67,8,131,205,255,49,201,235,24,59,116,36,4,15,131
db 57,1,0,0,59,60,36,15,131,80,1,0,0,164,1,219
db 117,17,59,116,36,8,15,135,33,1,0,0,139,30,131,238
db 252,17,219,114,213,49,192,64,1,219,117,17,59,116,36,8
db 15,135,7,1,0,0,139,30,131,238,252,17,219,17,192,15
db 136,31,1,0,0,1,219,117,17,59,116,36,8,15,135,234
db 0,0,0,139,30,131,238,252,17,219,114,32,72,1,219,117
db 17,59,116,36,8,15,135,210,0,0,0,139,30,131,238,252
db 17,219,17,192,15,136,234,0,0,0,235,172,61,2,0,0
db 1,15,135,221,0,0,0,131,232,3,114,35,193,224,8,59
db 116,36,4,15,131,164,0,0,0,172,131,240,255,15,132,143
db 0,0,0,15,137,187,0,0,0,209,248,137,197,235,21,1
db 219,117,17,59,116,36,8,15,135,128,0,0,0,139,30,131
db 238,252,17,219,17,201,1,219,117,13,59,116,36,8,119,109
db 139,30,131,238,252,17,219,17,201,117,44,65,1,219,117,13
db 59,116,36,8,119,87,139,30,131,238,252,17,219,17,201,120
db 108,1,219,117,13,59,116,36,8,119,66,139,30,131,238,252
db 17,219,115,216,131,193,2,129,253,0,251,255,255,131,209,1
db 137,242,137,254,1,206,114,69,59,52,36,119,64,137,254,1
db 238,115,65,59,116,36,48,114,59,243,164,137,214,233,220,254
db 255,255,59,60,36,119,38,59,116,36,4,118,7,184,55,255
db 255,255,235,5,116,3,72,176,51,43,124,36,48,139,84,36
db 52,137,58,131,196,12,90,89,91,94,95,93,195,184,54,255
db 255,255,235,229,184,53,255,255,255,235,222,131,200,255,235,217

globalf(_ucl_nrv2d_decompress_asm_small_8)
globalf(F(ucl_nrv2d_decompress_asm_small_8))
_ucl_nrv2d_decompress_asm_small_8:
F(ucl_nrv2d_decompress_asm_small_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,5,164,0,219,117,5,138,30,70,16
db 219,114,244,49,192,64,0,219,117,5,138,30,70,16,219,17
db 192,0,219,117,5,138,30,70,16,219,114,14,72,0,219,117
db 5,138,30,70,16,219,17,192,235,220,131,232,3,114,15,193
db 224,8,172,131,240,255,116,77,209,248,137,197,235,9,0,219
db 117,5,138,30,70,16,219,17,201,0,219,117,5,138,30,70
db 16,219,17,201,117,26,65,0,219,117,5,138,30,70,16,219
db 17,201,0,219,117,5,138,30,70,16,219,115,234,131,193,2
db 129,253,0,251,255,255,131,209,1,86,141,52,47,243,164,94
db 233,115,255,255,255,137,227,139,83,28,3,83,32,57,214,116
db 7,72,176,55,119,2,176,51,43,123,36,139,83,40,137,58
db 90,89,91,94,95,93,195,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_small_safe_8)
globalf(F(ucl_nrv2d_decompress_asm_small_safe_8))
_ucl_nrv2d_decompress_asm_small_safe_8:
F(ucl_nrv2d_decompress_asm_small_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,116,1,0,0,137
db 3,137,240,3,67,40,15,130,103,1,0,0,137,67,4,131
db 205,255,49,201,235,24,59,116,36,4,15,131,37,1,0,0
db 59,60,36,15,131,60,1,0,0,164,0,219,117,15,59,116
db 36,4,15,131,13,1,0,0,138,30,70,16,219,114,215,49
db 192,64,0,219,117,15,59,116,36,4,15,131,245,0,0,0
db 138,30,70,16,219,17,192,15,136,15,1,0,0,0,219,117
db 15,59,116,36,4,15,131,218,0,0,0,138,30,70,16,219
db 114,30,72,0,219,117,15,59,116,36,4,15,131,196,0,0
db 0,138,30,70,16,219,17,192,15,136,222,0,0,0,235,178
db 61,2,0,0,1,15,135,209,0,0,0,131,232,3,114,35
db 193,224,8,59,116,36,4,15,131,152,0,0,0,172,131,240
db 255,15,132,131,0,0,0,15,137,175,0,0,0,209,248,137
db 197,235,15,0,219,117,11,59,116,36,4,115,120,138,30,70
db 16,219,17,201,0,219,117,11,59,116,36,4,115,103,138,30
db 70,16,219,17,201,117,40,65,0,219,117,11,59,116,36,4
db 115,83,138,30,70,16,219,17,201,120,106,0,219,117,11,59
db 116,36,4,115,64,138,30,70,16,219,115,220,131,193,2,129
db 253,0,251,255,255,131,209,1,137,242,137,254,1,206,114,69
db 59,52,36,119,64,137,254,1,238,115,65,59,116,36,44,114
db 59,243,164,137,214,233,240,254,255,255,59,60,36,119,38,59
db 116,36,4,118,7,184,55,255,255,255,235,5,116,3,72,176
db 51,43,124,36,44,139,84,36,48,137,58,131,196,8,90,89
db 91,94,95,93,195,184,54,255,255,255,235,229,184,53,255,255
db 255,235,222,131,200,255,235,217,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2d_decompress_asm_small_le16)
globalf(F(ucl_nrv2d_decompress_asm_small_le16))
_ucl_nrv2d_decompress_asm_small_le16:
F(ucl_nrv2d_decompress_asm_small_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,6,164,102,1,219,117,9,102,139,30,131
db 238,254,102,17,219,114,239,49,192,64,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,17,192,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,114,19,72,102,1,219,117,9
db 102,139,30,131,238,254,102,17,219,17,192,235,205,131,232,3
db 114,15,193,224,8,172,131,240,255,116,97,209,248,137,197,235
db 14,102,1,219,117,9,102,139,30,131,238,254,102,17,219,17
db 201,102,1,219,117,9,102,139,30,131,238,254,102,17,219,17
db 201,117,36,65,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,17,201,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,115,224,131,193,2,129,253,0,251,255,255,131,209,1
db 86,141,52,47,243,164,94,233,75,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2d_decompress_asm_small_safe_le16)
globalf(F(ucl_nrv2d_decompress_asm_small_safe_le16))
_ucl_nrv2d_decompress_asm_small_safe_le16:
F(ucl_nrv2d_decompress_asm_small_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,180,1,0,0,137
db 3,137,240,3,67,44,15,130,167,1,0,0,137,67,4,131
db 232,2,15,130,109,1,0,0,57,240,15,130,101,1,0,0
db 137,67,8,131,205,255,49,201,235,25,59,116,36,4,15,131
db 81,1,0,0,59,60,36,15,131,104,1,0,0,164,102,1
db 219,117,19,59,116,36,8,15,135,56,1,0,0,102,139,30
db 131,238,254,102,17,219,114,210,49,192,64,102,1,219,117,19
db 59,116,36,8,15,135,27,1,0,0,102,139,30,131,238,254
db 102,17,219,17,192,15,136,49,1,0,0,102,1,219,117,19
db 59,116,36,8,15,135,251,0,0,0,102,139,30,131,238,254
db 102,17,219,114,35,72,102,1,219,117,19,59,116,36,8,15
db 135,224,0,0,0,102,139,30,131,238,254,102,17,219,17,192
db 15,136,246,0,0,0,235,163,61,2,0,0,1,15,135,233
db 0,0,0,131,232,3,114,35,193,224,8,59,116,36,4,15
db 131,176,0,0,0,172,131,240,255,15,132,155,0,0,0,15
db 137,199,0,0,0,209,248,137,197,235,24,102,1,219,117,19
db 59,116,36,8,15,135,139,0,0,0,102,139,30,131,238,254
db 102,17,219,17,201,102,1,219,117,15,59,116,36,8,119,117
db 102,139,30,131,238,254,102,17,219,17,201,117,50,65,102,1
db 219,117,15,59,116,36,8,119,92,102,139,30,131,238,254,102
db 17,219,17,201,120,111,102,1,219,117,15,59,116,36,8,119
db 68,102,139,30,131,238,254,102,17,219,115,210,131,193,2,129
db 253,0,251,255,255,131,209,1,137,242,137,254,1,206,114,69
db 59,52,36,119,64,137,254,1,238,115,65,59,116,36,48,114
db 59,243,164,137,214,233,196,254,255,255,59,60,36,119,38,59
db 116,36,4,118,7,184,55,255,255,255,235,5,116,3,72,176
db 51,43,124,36,48,139,84,36,52,137,58,131,196,12,90,89
db 91,94,95,93,195,184,54,255,255,255,235,229,184,53,255,255
db 255,235,222,131,200,255,235,217,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_le32)
globalf(F(ucl_nrv2e_decompress_asm_fast_le32))
_ucl_nrv2e_decompress_asm_fast_le32:
F(ucl_nrv2e_decompress_asm_fast_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,11,117,25,139,30,131
db 238,252,17,219,114,16,72,1,219,117,7,139,30,131,238,252
db 17,219,17,192,235,212,131,232,3,114,36,193,224,8,138,6
db 70,131,240,255,15,132,134,0,0,0,209,248,137,197,115,28
db 1,219,117,7,139,30,131,238,252,17,219,17,201,235,58,1
db 219,117,7,139,30,131,238,252,17,219,114,228,65,1,219,117
db 7,139,30,131,238,252,17,219,114,214,1,219,117,7,139,30
db 131,238,252,17,219,17,201,1,219,115,239,117,9,139,30,131
db 238,252,17,219,115,228,131,193,2,129,253,0,251,255,255,131
db 209,2,141,20,47,131,253,252,118,14,138,2,66,136,7,71
db 73,117,247,233,62,255,255,255,139,2,131,194,4,137,7,131
db 199,4,131,233,4,119,241,1,207,49,201,233,38,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_safe_le32)
globalf(F(ucl_nrv2e_decompress_asm_fast_safe_le32))
_ucl_nrv2e_decompress_asm_fast_safe_le32:
F(ucl_nrv2e_decompress_asm_fast_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,242,1,0,0,137
db 3,137,240,3,67,44,15,130,229,1,0,0,137,67,4,131
db 232,4,15,130,171,1,0,0,57,240,15,130,163,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,137,1,0,0,59,60,36,15,131,160
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,106,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,78,1,0,0,139,30,131,238,252,17,219,17,192,15,136
db 102,1,0,0,1,219,115,21,117,51,59,116,36,8,15,135
db 47,1,0,0,139,30,131,238,252,17,219,114,32,72,1,219
db 117,17,59,116,36,8,15,135,23,1,0,0,139,30,131,238
db 252,17,219,17,192,15,136,47,1,0,0,235,170,61,2,0
db 0,1,15,135,34,1,0,0,131,232,3,114,62,193,224,8
db 59,116,36,4,15,131,233,0,0,0,138,6,70,131,240,255
db 15,132,210,0,0,0,15,137,254,0,0,0,209,248,137,197
db 115,48,1,219,117,17,59,116,36,8,15,135,195,0,0,0
db 139,30,131,238,252,17,219,17,201,235,96,1,219,117,17,59
db 116,36,8,15,135,170,0,0,0,139,30,131,238,252,17,219
db 114,208,65,1,219,117,17,59,116,36,8,15,135,146,0,0
db 0,139,30,131,238,252,17,219,114,184,1,219,117,13,59,116
db 36,8,119,127,139,30,131,238,252,17,219,17,201,15,136,144
db 0,0,0,1,219,115,227,117,15,59,116,36,8,119,100,139
db 30,131,238,252,17,219,115,210,131,193,2,129,253,0,251,255
db 255,131,209,2,137,250,1,202,114,105,59,20,36,119,100,137
db 250,1,234,115,101,59,84,36,48,114,95,131,253,252,118,16
db 138,2,66,136,7,71,73,117,247,233,171,254,255,255,144,144
db 139,2,131,194,4,137,7,131,199,4,131,233,4,119,241,1
db 207,49,201,233,145,254,255,255,59,60,36,119,38,59,116,36
db 4,118,7,184,55,255,255,255,235,5,116,3,72,176,51,43
db 124,36,48,139,84,36,52,137,58,131,196,12,90,89,91,94
db 95,93,195,184,54,255,255,255,235,229,184,53,255,255,255,235
db 222,131,200,255,235,217,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_8)
globalf(F(ucl_nrv2e_decompress_asm_fast_8))
_ucl_nrv2e_decompress_asm_fast_8:
F(ucl_nrv2e_decompress_asm_fast_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,9,117,21,138,30,70,16,219,114,14
db 72,0,219,117,5,138,30,70,16,219,17,192,235,218,131,232
db 3,114,30,193,224,8,138,6,70,131,240,255,116,126,209,248
db 137,197,115,24,0,219,117,5,138,30,70,16,219,17,201,235
db 50,0,219,117,5,138,30,70,16,219,114,232,65,0,219,117
db 5,138,30,70,16,219,114,220,0,219,117,5,138,30,70,16
db 219,17,201,0,219,115,241,117,7,138,30,70,16,219,115,232
db 131,193,2,129,253,0,251,255,255,131,209,2,141,20,47,131
db 253,252,118,16,138,2,66,136,7,71,73,117,247,233,84,255
db 255,255,144,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,58,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_safe_8)
globalf(F(ucl_nrv2e_decompress_asm_fast_safe_8))
_ucl_nrv2e_decompress_asm_fast_safe_8:
F(ucl_nrv2e_decompress_asm_fast_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,206,1,0,0,137
db 3,137,240,3,67,40,15,130,193,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,117,1,0,0,59,60,36,15,131,140
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,86,1,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,60
db 1,0,0,138,30,70,16,219,17,192,15,136,86,1,0,0
db 0,219,115,19,117,47,59,116,36,4,15,131,31,1,0,0
db 138,30,70,16,219,114,30,72,0,219,117,15,59,116,36,4
db 15,131,9,1,0,0,138,30,70,16,219,17,192,15,136,35
db 1,0,0,235,176,61,2,0,0,1,15,135,22,1,0,0
db 131,232,3,114,60,193,224,8,59,116,36,4,15,131,221,0
db 0,0,138,6,70,131,240,255,15,132,198,0,0,0,15,137
db 242,0,0,0,209,248,137,197,115,44,0,219,117,15,59,116
db 36,4,15,131,183,0,0,0,138,30,70,16,219,17,201,235
db 88,0,219,117,15,59,116,36,4,15,131,160,0,0,0,138
db 30,70,16,219,114,212,65,0,219,117,15,59,116,36,4,15
db 131,138,0,0,0,138,30,70,16,219,114,190,0,219,117,11
db 59,116,36,4,115,121,138,30,70,16,219,17,201,15,136,140
db 0,0,0,0,219,115,229,117,13,59,116,36,4,115,96,138
db 30,70,16,219,115,214,131,193,2,129,253,0,251,255,255,131
db 209,2,137,250,1,202,114,103,59,20,36,119,98,137,250,1
db 234,115,99,59,84,36,44,114,93,131,253,252,118,14,138,2
db 66,136,7,71,73,117,247,233,189,254,255,255,139,2,131,194
db 4,137,7,131,199,4,131,233,4,119,241,1,207,49,201,233
db 165,254,255,255,59,60,36,119,38,59,116,36,4,118,7,184
db 55,255,255,255,235,5,116,3,72,176,51,43,124,36,44,139
db 84,36,48,137,58,131,196,8,90,89,91,94,95,93,195,184
db 54,255,255,255,235,229,184,53,255,255,255,235,222,131,200,255
db 235,217,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_le16)
globalf(F(ucl_nrv2e_decompress_asm_fast_le16))
_ucl_nrv2e_decompress_asm_fast_le16:
F(ucl_nrv2e_decompress_asm_fast_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,13,117,30,102,139,30,131,238,254,102,17,219,114,19,72
db 102,1,219,117,9,102,139,30,131,238,254,102,17,219,17,192
db 235,203,131,232,3,114,39,193,224,8,138,6,70,131,240,255
db 15,132,150,0,0,0,209,248,137,197,115,34,102,1,219,117
db 9,102,139,30,131,238,254,102,17,219,17,201,235,70,102,1
db 219,117,9,102,139,30,131,238,254,102,17,219,114,222,65,102
db 1,219,117,9,102,139,30,131,238,254,102,17,219,114,205,102
db 1,219,117,9,102,139,30,131,238,254,102,17,219,17,201,102
db 1,219,115,235,117,11,102,139,30,131,238,254,102,17,219,115
db 222,131,193,2,129,253,0,251,255,255,131,209,2,141,20,47
db 131,253,252,118,15,138,2,66,136,7,71,73,117,247,233,35
db 255,255,255,144,139,2,131,194,4,137,7,131,199,4,131,233
db 4,119,241,1,207,49,201,233,10,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2e_decompress_asm_fast_safe_le16)
globalf(F(ucl_nrv2e_decompress_asm_fast_safe_le16))
_ucl_nrv2e_decompress_asm_fast_safe_le16:
F(ucl_nrv2e_decompress_asm_fast_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,18,2,0,0,137
db 3,137,240,3,67,44,15,130,5,2,0,0,137,67,4,131
db 232,2,15,130,203,1,0,0,57,240,15,130,195,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,169,1,0,0,59,60,36,15,131,192
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,137,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,106,1,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,128,1,0,0,102,1,219,115,23,117
db 56,59,116,36,8,15,135,72,1,0,0,102,139,30,131,238
db 254,102,17,219,114,35,72,102,1,219,117,19,59,116,36,8
db 15,135,45,1,0,0,102,139,30,131,238,254,102,17,219,17
db 192,15,136,67,1,0,0,235,161,61,2,0,0,1,15,135
db 54,1,0,0,131,232,3,114,65,193,224,8,59,116,36,4
db 15,131,253,0,0,0,138,6,70,131,240,255,15,132,230,0
db 0,0,15,137,18,1,0,0,209,248,137,197,115,54,102,1
db 219,117,19,59,116,36,8,15,135,214,0,0,0,102,139,30
db 131,238,254,102,17,219,17,201,235,112,102,1,219,117,19,59
db 116,36,8,15,135,186,0,0,0,102,139,30,131,238,254,102
db 17,219,114,202,65,102,1,219,117,19,59,116,36,8,15,135
db 159,0,0,0,102,139,30,131,238,254,102,17,219,114,175,102
db 1,219,117,19,59,116,36,8,15,135,133,0,0,0,102,139
db 30,131,238,254,102,17,219,17,201,15,136,148,0,0,0,102
db 1,219,115,219,117,17,59,116,36,8,119,103,102,139,30,131
db 238,254,102,17,219,115,200,131,193,2,129,253,0,251,255,255
db 131,209,2,137,250,1,202,114,106,59,20,36,119,101,137,250
db 1,234,115,102,59,84,36,48,114,96,131,253,252,118,17,138
db 2,66,136,7,71,73,117,247,233,140,254,255,255,144,144,144
db 139,2,131,194,4,137,7,131,199,4,131,233,4,119,241,1
db 207,49,201,233,113,254,255,255,59,60,36,119,38,59,116,36
db 4,118,7,184,55,255,255,255,235,5,116,3,72,176,51,43
db 124,36,48,139,84,36,52,137,58,131,196,12,90,89,91,94
db 95,93,195,184,54,255,255,255,235,229,184,53,255,255,255,235
db 222,131,200,255,235,217,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_le32)
globalf(F(ucl_nrv2e_decompress_asm_le32))
_ucl_nrv2e_decompress_asm_le32:
F(ucl_nrv2e_decompress_asm_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,22,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,1,219,115,11,117,244,139,30,131,238
db 252,17,219,114,235,184,1,0,0,0,1,219,117,7,139,30
db 131,238,252,17,219,17,192,1,219,115,11,117,25,139,30,131
db 238,252,17,219,114,16,72,1,219,117,7,139,30,131,238,252
db 17,219,17,192,235,212,131,232,3,114,32,193,224,8,138,6
db 70,131,240,255,116,105,209,248,137,197,115,28,1,219,117,7
db 139,30,131,238,252,17,219,17,201,235,58,1,219,117,7,139
db 30,131,238,252,17,219,114,228,65,1,219,117,7,139,30,131
db 238,252,17,219,114,214,1,219,117,7,139,30,131,238,252,17
db 219,17,201,1,219,115,239,117,9,139,30,131,238,252,17,219
db 115,228,131,193,2,129,253,0,251,255,255,131,209,2,141,20
db 47,138,2,66,136,7,71,73,117,247,233,71,255,255,255,137
db 227,139,83,28,3,83,32,57,214,116,7,72,176,55,119,2
db 176,51,43,123,36,139,83,40,137,58,90,89,91,94,95,93
db 195,144,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_safe_le32)
globalf(F(ucl_nrv2e_decompress_asm_safe_le32))
_ucl_nrv2e_decompress_asm_safe_le32:
F(ucl_nrv2e_decompress_asm_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,203,1,0,0,137
db 3,137,240,3,67,44,15,130,190,1,0,0,137,67,4,131
db 232,4,15,130,132,1,0,0,57,240,15,130,124,1,0,0
db 137,67,8,131,205,255,49,201,235,37,144,144,144,144,144,144
db 59,116,36,4,15,131,98,1,0,0,59,60,36,15,131,121
db 1,0,0,138,6,70,136,7,71,1,219,115,21,117,225,59
db 116,36,8,15,135,67,1,0,0,139,30,131,238,252,17,219
db 114,206,184,1,0,0,0,1,219,117,17,59,116,36,8,15
db 135,39,1,0,0,139,30,131,238,252,17,219,17,192,15,136
db 63,1,0,0,1,219,115,21,117,51,59,116,36,8,15,135
db 8,1,0,0,139,30,131,238,252,17,219,114,32,72,1,219
db 117,17,59,116,36,8,15,135,240,0,0,0,139,30,131,238
db 252,17,219,17,192,15,136,8,1,0,0,235,170,61,2,0
db 0,1,15,135,251,0,0,0,131,232,3,114,62,193,224,8
db 59,116,36,4,15,131,194,0,0,0,138,6,70,131,240,255
db 15,132,171,0,0,0,15,137,215,0,0,0,209,248,137,197
db 115,48,1,219,117,17,59,116,36,8,15,135,156,0,0,0
db 139,30,131,238,252,17,219,17,201,235,88,1,219,117,17,59
db 116,36,8,15,135,131,0,0,0,139,30,131,238,252,17,219
db 114,208,65,1,219,117,13,59,116,36,8,119,111,139,30,131
db 238,252,17,219,114,188,1,219,117,13,59,116,36,8,119,92
db 139,30,131,238,252,17,219,17,201,120,113,1,219,115,231,117
db 15,59,116,36,8,119,69,139,30,131,238,252,17,219,115,214
db 131,193,2,129,253,0,251,255,255,131,209,2,137,250,1,202
db 114,74,59,20,36,119,69,137,250,1,234,115,70,59,84,36
db 48,114,64,138,2,66,136,7,71,73,117,247,233,184,254,255
db 255,59,60,36,119,38,59,116,36,4,118,7,184,55,255,255
db 255,235,5,116,3,72,176,51,43,124,36,48,139,84,36,52
db 137,58,131,196,12,90,89,91,94,95,93,195,184,54,255,255
db 255,235,229,184,53,255,255,255,235,222,131,200,255,235,217,144

globalf(_ucl_nrv2e_decompress_asm_8)
globalf(F(ucl_nrv2e_decompress_asm_8))
_ucl_nrv2e_decompress_asm_8:
F(ucl_nrv2e_decompress_asm_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,21,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,0,219,115,9,117,244,138,30,70,16
db 219,114,237,184,1,0,0,0,0,219,117,5,138,30,70,16
db 219,17,192,0,219,115,9,117,21,138,30,70,16,219,114,14
db 72,0,219,117,5,138,30,70,16,219,17,192,235,218,131,232
db 3,114,30,193,224,8,138,6,70,131,240,255,116,95,209,248
db 137,197,115,24,0,219,117,5,138,30,70,16,219,17,201,235
db 50,0,219,117,5,138,30,70,16,219,114,232,65,0,219,117
db 5,138,30,70,16,219,114,220,0,219,117,5,138,30,70,16
db 219,17,201,0,219,115,241,117,7,138,30,70,16,219,115,232
db 131,193,2,129,253,0,251,255,255,131,209,2,141,20,47,138
db 2,66,136,7,71,73,117,247,233,89,255,255,255,137,227,139
db 83,28,3,83,32,57,214,116,7,72,176,55,119,2,176,51
db 43,123,36,139,83,40,137,58,90,89,91,94,95,93,195,144

globalf(_ucl_nrv2e_decompress_asm_safe_8)
globalf(F(ucl_nrv2e_decompress_asm_safe_8))
_ucl_nrv2e_decompress_asm_safe_8:
F(ucl_nrv2e_decompress_asm_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,165,1,0,0,137
db 3,137,240,3,67,40,15,130,152,1,0,0,137,67,4,131
db 205,255,49,201,235,41,144,144,144,144,144,144,144,144,144,144
db 59,116,36,4,15,131,76,1,0,0,59,60,36,15,131,99
db 1,0,0,138,6,70,136,7,71,0,219,115,19,117,225,59
db 116,36,4,15,131,45,1,0,0,138,30,70,16,219,114,208
db 184,1,0,0,0,0,219,117,15,59,116,36,4,15,131,19
db 1,0,0,138,30,70,16,219,17,192,15,136,45,1,0,0
db 0,219,115,19,117,47,59,116,36,4,15,131,246,0,0,0
db 138,30,70,16,219,114,30,72,0,219,117,15,59,116,36,4
db 15,131,224,0,0,0,138,30,70,16,219,17,192,15,136,250
db 0,0,0,235,176,61,2,0,0,1,15,135,237,0,0,0
db 131,232,3,114,60,193,224,8,59,116,36,4,15,131,180,0
db 0,0,138,6,70,131,240,255,15,132,157,0,0,0,15,137
db 201,0,0,0,209,248,137,197,115,40,0,219,117,15,59,116
db 36,4,15,131,142,0,0,0,138,30,70,16,219,17,201,235
db 76,0,219,117,11,59,116,36,4,115,123,138,30,70,16,219
db 114,216,65,0,219,117,11,59,116,36,4,115,105,138,30,70
db 16,219,114,198,0,219,117,11,59,116,36,4,115,88,138,30
db 70,16,219,17,201,120,111,0,219,115,233,117,13,59,116,36
db 4,115,67,138,30,70,16,219,115,218,131,193,2,129,253,0
db 251,255,255,131,209,2,137,250,1,202,114,74,59,20,36,119
db 69,137,250,1,234,115,70,59,84,36,44,114,64,138,2,66
db 136,7,71,73,117,247,233,206,254,255,255,59,60,36,119,38
db 59,116,36,4,118,7,184,55,255,255,255,235,5,116,3,72
db 176,51,43,124,36,44,139,84,36,48,137,58,131,196,8,90
db 89,91,94,95,93,195,184,54,255,255,255,235,229,184,53,255
db 255,255,235,222,131,200,255,235,217,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_le16)
globalf(F(ucl_nrv2e_decompress_asm_le16))
_ucl_nrv2e_decompress_asm_le16:
F(ucl_nrv2e_decompress_asm_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,23,144,144,144,144,144,144,144,144,144,144
db 138,6,70,136,7,71,102,1,219,115,13,117,243,102,139,30
db 131,238,254,102,17,219,114,232,184,1,0,0,0,102,1,219
db 117,9,102,139,30,131,238,254,102,17,219,17,192,102,1,219
db 115,13,117,30,102,139,30,131,238,254,102,17,219,114,19,72
db 102,1,219,117,9,102,139,30,131,238,254,102,17,219,17,192
db 235,203,131,232,3,114,35,193,224,8,138,6,70,131,240,255
db 116,120,209,248,137,197,115,34,102,1,219,117,9,102,139,30
db 131,238,254,102,17,219,17,201,235,70,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,114,222,65,102,1,219,117,9
db 102,139,30,131,238,254,102,17,219,114,205,102,1,219,117,9
db 102,139,30,131,238,254,102,17,219,17,201,102,1,219,115,235
db 117,11,102,139,30,131,238,254,102,17,219,115,222,131,193,2
db 129,253,0,251,255,255,131,209,2,141,20,47,138,2,66,136
db 7,71,73,117,247,233,44,255,255,255,137,227,139,83,28,3
db 83,32,57,214,116,7,72,176,55,119,2,176,51,43,123,36
db 139,83,40,137,58,90,89,91,94,95,93,195,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_safe_le16)
globalf(F(ucl_nrv2e_decompress_asm_safe_le16))
_ucl_nrv2e_decompress_asm_safe_le16:
F(ucl_nrv2e_decompress_asm_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,230,1,0,0,137
db 3,137,240,3,67,44,15,130,217,1,0,0,137,67,4,131
db 232,2,15,130,159,1,0,0,57,240,15,130,151,1,0,0
db 137,67,8,131,205,255,49,201,235,38,144,144,144,144,144,144
db 59,116,36,4,15,131,125,1,0,0,59,60,36,15,131,148
db 1,0,0,138,6,70,136,7,71,102,1,219,115,23,117,224
db 59,116,36,8,15,135,93,1,0,0,102,139,30,131,238,254
db 102,17,219,114,203,184,1,0,0,0,102,1,219,117,19,59
db 116,36,8,15,135,62,1,0,0,102,139,30,131,238,254,102
db 17,219,17,192,15,136,84,1,0,0,102,1,219,115,23,117
db 56,59,116,36,8,15,135,28,1,0,0,102,139,30,131,238
db 254,102,17,219,114,35,72,102,1,219,117,19,59,116,36,8
db 15,135,1,1,0,0,102,139,30,131,238,254,102,17,219,17
db 192,15,136,23,1,0,0,235,161,61,2,0,0,1,15,135
db 10,1,0,0,131,232,3,114,65,193,224,8,59,116,36,4
db 15,131,209,0,0,0,138,6,70,131,240,255,15,132,186,0
db 0,0,15,137,230,0,0,0,209,248,137,197,115,54,102,1
db 219,117,19,59,116,36,8,15,135,170,0,0,0,102,139,30
db 131,238,254,102,17,219,17,201,235,100,102,1,219,117,19,59
db 116,36,8,15,135,142,0,0,0,102,139,30,131,238,254,102
db 17,219,114,202,65,102,1,219,117,15,59,116,36,8,119,119
db 102,139,30,131,238,254,102,17,219,114,179,102,1,219,117,15
db 59,116,36,8,119,97,102,139,30,131,238,254,102,17,219,17
db 201,120,116,102,1,219,115,227,117,17,59,116,36,8,119,71
db 102,139,30,131,238,254,102,17,219,115,208,131,193,2,129,253
db 0,251,255,255,131,209,2,137,250,1,202,114,74,59,20,36
db 119,69,137,250,1,234,115,70,59,84,36,48,114,64,138,2
db 66,136,7,71,73,117,247,233,157,254,255,255,59,60,36,119
db 38,59,116,36,4,118,7,184,55,255,255,255,235,5,116,3
db 72,176,51,43,124,36,48,139,84,36,52,137,58,131,196,12
db 90,89,91,94,95,93,195,184,54,255,255,255,235,229,184,53
db 255,255,255,235,222,131,200,255,235,217,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_small_le32)
globalf(F(ucl_nrv2e_decompress_asm_small_le32))
_ucl_nrv2e_decompress_asm_small_le32:
F(ucl_nrv2e_decompress_asm_small_le32):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,5,164,1,219,117,7,139,30,131,238,252
db 17,219,114,242,49,192,64,1,219,117,7,139,30,131,238,252
db 17,219,17,192,1,219,117,7,139,30,131,238,252,17,219,114
db 16,72,1,219,117,7,139,30,131,238,252,17,219,17,192,235
db 214,131,232,3,114,30,193,224,8,172,131,240,255,116,98,209
db 248,137,197,115,28,1,219,117,7,139,30,131,238,252,17,219
db 17,201,235,56,1,219,117,7,139,30,131,238,252,17,219,114
db 228,65,1,219,117,7,139,30,131,238,252,17,219,114,214,1
db 219,117,7,139,30,131,238,252,17,219,17,201,1,219,117,7
db 139,30,131,238,252,17,219,115,230,131,193,2,129,253,0,251
db 255,255,131,209,2,86,141,52,47,243,164,94,233,86,255,255
db 255,137,227,139,83,28,3,83,32,57,214,116,7,72,176,55
db 119,2,176,51,43,123,36,139,83,40,137,58,90,89,91,94
db 95,93,195,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_small_safe_le32)
globalf(F(ucl_nrv2e_decompress_asm_small_safe_le32))
_ucl_nrv2e_decompress_asm_small_safe_le32:
F(ucl_nrv2e_decompress_asm_small_safe_le32):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,175,1,0,0,137
db 3,137,240,3,67,44,15,130,162,1,0,0,137,67,4,131
db 232,4,15,130,104,1,0,0,57,240,15,130,96,1,0,0
db 137,67,8,131,205,255,49,201,235,24,59,116,36,4,15,131
db 76,1,0,0,59,60,36,15,131,99,1,0,0,164,1,219
db 117,17,59,116,36,8,15,135,52,1,0,0,139,30,131,238
db 252,17,219,114,213,49,192,64,1,219,117,17,59,116,36,8
db 15,135,26,1,0,0,139,30,131,238,252,17,219,17,192,15
db 136,50,1,0,0,1,219,117,17,59,116,36,8,15,135,253
db 0,0,0,139,30,131,238,252,17,219,114,32,72,1,219,117
db 17,59,116,36,8,15,135,229,0,0,0,139,30,131,238,252
db 17,219,17,192,15,136,253,0,0,0,235,172,61,2,0,0
db 1,15,135,240,0,0,0,131,232,3,114,60,193,224,8,59
db 116,36,4,15,131,183,0,0,0,172,131,240,255,15,132,162
db 0,0,0,15,137,206,0,0,0,209,248,137,197,115,44,1
db 219,117,17,59,116,36,8,15,135,147,0,0,0,139,30,131
db 238,252,17,219,17,201,235,82,1,219,117,13,59,116,36,8
db 119,126,139,30,131,238,252,17,219,114,212,65,1,219,117,13
db 59,116,36,8,119,106,139,30,131,238,252,17,219,114,192,1
db 219,117,13,59,116,36,8,119,87,139,30,131,238,252,17,219
db 17,201,120,108,1,219,117,13,59,116,36,8,119,66,139,30
db 131,238,252,17,219,115,216,131,193,2,129,253,0,251,255,255
db 131,209,2,137,242,137,254,1,206,114,69,59,52,36,119,64
db 137,254,1,238,115,65,59,116,36,48,114,59,243,164,137,214
db 233,201,254,255,255,59,60,36,119,38,59,116,36,4,118,7
db 184,55,255,255,255,235,5,116,3,72,176,51,43,124,36,48
db 139,84,36,52,137,58,131,196,12,90,89,91,94,95,93,195
db 184,54,255,255,255,235,229,184,53,255,255,255,235,222,131,200
db 255,235,217,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_small_8)
globalf(F(ucl_nrv2e_decompress_asm_small_8))
_ucl_nrv2e_decompress_asm_small_8:
F(ucl_nrv2e_decompress_asm_small_8):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,249,235,5,164,0,219,117,5,138,30,70,16
db 219,114,244,49,192,64,0,219,117,5,138,30,70,16,219,17
db 192,0,219,117,5,138,30,70,16,219,114,14,72,0,219,117
db 5,138,30,70,16,219,17,192,235,220,131,232,3,114,28,193
db 224,8,172,131,240,255,116,88,209,248,137,197,115,24,0,219
db 117,5,138,30,70,16,219,17,201,235,48,0,219,117,5,138
db 30,70,16,219,114,232,65,0,219,117,5,138,30,70,16,219
db 114,220,0,219,117,5,138,30,70,16,219,17,201,0,219,117
db 5,138,30,70,16,219,115,234,131,193,2,129,253,0,251,255
db 255,131,209,2,86,141,52,47,243,164,94,233,104,255,255,255
db 137,227,139,83,28,3,83,32,57,214,116,7,72,176,55,119
db 2,176,51,43,123,36,139,83,40,137,58,90,89,91,94,95
db 93,195,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_nrv2e_decompress_asm_small_safe_8)
globalf(F(ucl_nrv2e_decompress_asm_small_safe_8))
_ucl_nrv2e_decompress_asm_small_safe_8:
F(ucl_nrv2e_decompress_asm_small_safe_8):
db 85,87,86,83,81,82,131,236,8,137,227,252,139,115,36,139
db 123,44,137,248,139,83,48,3,2,15,130,137,1,0,0,137
db 3,137,240,3,67,40,15,130,124,1,0,0,137,67,4,131
db 205,255,49,201,235,24,59,116,36,4,15,131,58,1,0,0
db 59,60,36,15,131,81,1,0,0,164,0,219,117,15,59,116
db 36,4,15,131,34,1,0,0,138,30,70,16,219,114,215,49
db 192,64,0,219,117,15,59,116,36,4,15,131,10,1,0,0
db 138,30,70,16,219,17,192,15,136,36,1,0,0,0,219,117
db 15,59,116,36,4,15,131,239,0,0,0,138,30,70,16,219
db 114,30,72,0,219,117,15,59,116,36,4,15,131,217,0,0
db 0,138,30,70,16,219,17,192,15,136,243,0,0,0,235,178
db 61,2,0,0,1,15,135,230,0,0,0,131,232,3,114,58
db 193,224,8,59,116,36,4,15,131,173,0,0,0,172,131,240
db 255,15,132,152,0,0,0,15,137,196,0,0,0,209,248,137
db 197,115,40,0,219,117,15,59,116,36,4,15,131,137,0,0
db 0,138,30,70,16,219,17,201,235,74,0,219,117,11,59,116
db 36,4,115,118,138,30,70,16,219,114,216,65,0,219,117,11
db 59,116,36,4,115,100,138,30,70,16,219,114,198,0,219,117
db 11,59,116,36,4,115,83,138,30,70,16,219,17,201,120,106
db 0,219,117,11,59,116,36,4,115,64,138,30,70,16,219,115
db 220,131,193,2,129,253,0,251,255,255,131,209,2,137,242,137
db 254,1,206,114,69,59,52,36,119,64,137,254,1,238,115,65
db 59,116,36,44,114,59,243,164,137,214,233,219,254,255,255,59
db 60,36,119,38,59,116,36,4,118,7,184,55,255,255,255,235
db 5,116,3,72,176,51,43,124,36,44,139,84,36,48,137,58
db 131,196,8,90,89,91,94,95,93,195,184,54,255,255,255,235
db 229,184,53,255,255,255,235,222,131,200,255,235,217,144,144,144

globalf(_ucl_nrv2e_decompress_asm_small_le16)
globalf(F(ucl_nrv2e_decompress_asm_small_le16))
_ucl_nrv2e_decompress_asm_small_le16:
F(ucl_nrv2e_decompress_asm_small_le16):
db 85,87,86,83,81,82,252,139,116,36,28,139,124,36,36,131
db 205,255,49,201,235,6,164,102,1,219,117,9,102,139,30,131
db 238,254,102,17,219,114,239,49,192,64,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,17,192,102,1,219,117,9,102
db 139,30,131,238,254,102,17,219,114,19,72,102,1,219,117,9
db 102,139,30,131,238,254,102,17,219,17,192,235,205,131,232,3
db 114,33,193,224,8,172,131,240,255,116,113,209,248,137,197,115
db 34,102,1,219,117,9,102,139,30,131,238,254,102,17,219,17
db 201,235,68,102,1,219,117,9,102,139,30,131,238,254,102,17
db 219,114,222,65,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,114,205,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,17,201,102,1,219,117,9,102,139,30,131,238,254,102
db 17,219,115,224,131,193,2,129,253,0,251,255,255,131,209,2
db 86,141,52,47,243,164,94,233,59,255,255,255,137,227,139,83
db 28,3,83,32,57,214,116,7,72,176,55,119,2,176,51,43
db 123,36,139,83,40,137,58,90,89,91,94,95,93,195,144,144

globalf(_ucl_nrv2e_decompress_asm_small_safe_le16)
globalf(F(ucl_nrv2e_decompress_asm_small_safe_le16))
_ucl_nrv2e_decompress_asm_small_safe_le16:
F(ucl_nrv2e_decompress_asm_small_safe_le16):
db 85,87,86,83,81,82,131,236,12,137,227,252,139,115,40,139
db 123,48,137,248,139,83,52,3,2,15,130,206,1,0,0,137
db 3,137,240,3,67,44,15,130,193,1,0,0,137,67,4,131
db 232,2,15,130,135,1,0,0,57,240,15,130,127,1,0,0
db 137,67,8,131,205,255,49,201,235,25,59,116,36,4,15,131
db 107,1,0,0,59,60,36,15,131,130,1,0,0,164,102,1
db 219,117,19,59,116,36,8,15,135,82,1,0,0,102,139,30
db 131,238,254,102,17,219,114,210,49,192,64,102,1,219,117,19
db 59,116,36,8,15,135,53,1,0,0,102,139,30,131,238,254
db 102,17,219,17,192,15,136,75,1,0,0,102,1,219,117,19
db 59,116,36,8,15,135,21,1,0,0,102,139,30,131,238,254
db 102,17,219,114,35,72,102,1,219,117,19,59,116,36,8,15
db 135,250,0,0,0,102,139,30,131,238,254,102,17,219,17,192
db 15,136,16,1,0,0,235,163,61,2,0,0,1,15,135,3
db 1,0,0,131,232,3,114,63,193,224,8,59,116,36,4,15
db 131,202,0,0,0,172,131,240,255,15,132,181,0,0,0,15
db 137,225,0,0,0,209,248,137,197,115,54,102,1,219,117,19
db 59,116,36,8,15,135,165,0,0,0,102,139,30,131,238,254
db 102,17,219,17,201,235,98,102,1,219,117,19,59,116,36,8
db 15,135,137,0,0,0,102,139,30,131,238,254,102,17,219,114
db 202,65,102,1,219,117,15,59,116,36,8,119,114,102,139,30
db 131,238,254,102,17,219,114,179,102,1,219,117,15,59,116,36
db 8,119,92,102,139,30,131,238,254,102,17,219,17,201,120,111
db 102,1,219,117,15,59,116,36,8,119,68,102,139,30,131,238
db 254,102,17,219,115,210,131,193,2,129,253,0,251,255,255,131
db 209,2,137,242,137,254,1,206,114,69,59,52,36,119,64,137
db 254,1,238,115,65,59,116,36,48,114,59,243,164,137,214,233
db 170,254,255,255,59,60,36,119,38,59,116,36,4,118,7,184
db 55,255,255,255,235,5,116,3,72,176,51,43,124,36,48,139
db 84,36,52,137,58,131,196,12,90,89,91,94,95,93,195,184
db 54,255,255,255,235,229,184,53,255,255,255,235,222,131,200,255
db 235,217,144,144,144,144,144,144,144,144,144,144,144,144,144,144

globalf(_ucl_rdtsc_asm)
globalf(F(ucl_rdtsc_asm))
_ucl_rdtsc_asm:
F(ucl_rdtsc_asm):
db 82,81,139,76,36,12,15,49,137,1,137,81,4,89,90,195

