cc="`head -1 ../conf-cc`"
systype="`cat systype`"


cc -c trycpp.c -malign-double >/dev/null 2>&1 \
&& ccad="-malign-double"

cc -c trycpp.c -march=ultrasparc >/dev/null 2>&1 \
&& ccus="-march=ultrasparc"

cc -c trycpp.c -march=powerpc >/dev/null 2>&1 \
&& ccpp="-march=powerpc"

cc -c trycpp.c -march=21164 >/dev/null 2>&1 \
&& cc21="-march=21164"

cc -c trycpp.c -march=native >/dev/null 2>&1 \
&& ccarm="-march=native"

rm -f trycpp.o

ccssl="`head -1 ../conf-ssl`"
eval cc -c tryssl.c $ccssl >/dev/null 2>&1 \
|| ccssl=""

ccedh="`head -1 ../conf-ecdh`"
eval cc -pedantic tryssl.c $ccedh >/dev/null 2>&1 \
|| ccedh=""

ccbase="gcc -fomit-frame-pointer -Wimplicit -Wunused -Wcomment -Wchar-subscripts -Wuninitialized -Wshadow -Wcast-qual -Wcast-align -Wwrite-strings"

case "$cc:$systype" in
  auto:*:i386-*:*)
    cc="$ccbase -O1 $ccad"
    ;;
  auto:*:amd64-*:*)
    cc="$ccbase -O2 $ccad"
    ;;
  auto:*:x86_64-*:*)
    cc="$ccbase -O2 $ccad"
    ;;
  auto:*:sparc-*:*:*:*)
    cc="$ccbase -O1 $ccus"
    ;;
  auto:*:ppc-*:*:*:*)
    cc="$ccbase -O2 $ccpp"
    ;;
  auto:*:alpha-*:*:*:*)
    cc="$ccbase -O2 $cc21"
    ;;
  auto:aix-*:-:-:*:-)
    cc="$ccbase -O2 $ccpp"
    ;;
  auto:*:armv7l-:*)
    cc="$ccbase -O2 $ccarm"
    ;;
  auto:*)
    cc="$ccbase -O2"
    ;;
esac

cat warn-auto.sh
echo exec "$cc" "$ccssl" "$ccedh" '-c ${1+"$@"}'
