#!/bin/bash

source helpers/shell-compat-KV.sh

errcnt=0

test_kv()
{
	local input="$1" actual= expected="$2"
	actual=$(KV_to_int "$input" 2>/dev/null)
	if [[ "$actual" = "$expected" ]]; then
		echo "ok: KV_to_int $input"
	else
		echo "fail: KV_to_int input=$input, expected=$expected, actual=$actual"
		errcnt=$(($errcnt+1))
	fi
}

echo "Testing KV_to_int"

# two digit ones
test_kv 2.6	132608
test_kv 3.0	196608
test_kv 3.1	196864

# normal three digit numbers
test_kv 2.6.0	132608
test_kv 2.6.1	132609
test_kv 2.6.2	132610
test_kv 2.6.35	132643
test_kv 3.0.1	196609

# four digit numbers
test_kv 2.6.35.1	132643
test_kv 2.6.35.995	132643

# with suffix
test_kv 2.6.35+1suf	132643
test_kv 2.6.35-2suf	132643
test_kv 2.6.35%3suf	132643
test_kv 2.6.35x4suf	132643

test_kv 3.0+1suf	196608
test_kv 3.0-2suf	196608
test_kv 3.0%3suf	196608
test_kv 3.0x4suf	196608

if [[ "$errcnt" = 0 ]]; then
	echo "Test success"
	exit 0
else
	echo "Tests failed: $errcnt"
	exit 1
fi

