#!/usr/bin/perl -w
#
# URLblocked.cgi - explain to the user that the URL is blocked and by which rule set.
#
# Currently the error messages supports 
# en (english), 
# de (german), 
# pl (polish)
# it (Italian)
# pt (Portuguese)
# fr (French)
# nl (dutch).
# You can add a language yourself: search for NEWLANGUAGE and translate the 6 lines.

use strict;
use Socket;

my $admin = 'unknown';
my $clientaddr = 'unknown';
my $clientname = 'unknown';
my $clientuser = 'unknown';
my $clientgroup = 'unknown';
my $targetgroup = 'unknown';
my $color = 'orange';
my $size = 'normal';
my $mode = 'default';
my $textcolor;
my $bgcolor;
my $titlesize;
my $textsize;
my $url = 'unknown';
my @day = ("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday");
my @month = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");
my @languages;
my $lang;
my ($protocol,$address,$port,$path);
sub init();
sub getPreferedLanguage(@);
sub parseURL($);
sub parseQuery($);

@languages   = (
		"en (English),",
		"nl (Nederlands),",
		"de (Deutsch),",
		"pl (Polish),",
		"pt (Portuguese),",
		"fr (French),",
		"it (Italian),",
	       );


sub init () 
{
  ($admin,$clientaddr,$clientname,$clientuser,$clientgroup,$targetgroup,$url)
    = parseQuery($ENV{"QUERY_STRING"});
  # ($protocol,$address,$port,$path) = parseURL($url);
  $lang = getPreferedLanguage(@languages);
}

#
# Find the first supported language of the client.
#
sub getPreferedLanguage (@) 
{
  my @supported = @_;
  my @clientLanguages = split(/\s*,\s*/,$ENV{"HTTP_ACCEPT_LANGUAGE"}) if(defined($ENV{"HTTP_ACCEPT_LANGUAGE"}));
  my $lang;
  my $supp;

  push(@clientLanguages,$supported[0]);
  for $lang (@clientLanguages) 
  {
    $lang =~ s/\s.*//;
    $lang =~ s/-.*//;
    for $supp (@supported) 
    {
      $supp =~ s/\s.*//;
      return($lang) if ($lang eq $supp);
    }
  }
  return 'en';   # default language is 'en'
}


sub parseQuery ($) 
{
  my $query       = shift;
  my $admin       = 'The system administrator.';
  my $clientaddr  = '??';
  my $clientname  = '??';
  my $clientuser  = '??';
  my $clientgroup = '??';
  my $targetgroup = '??';
  my $url         = '??';

  if (defined($query))
  {
    while ($query =~ /^\&?([^\&=]+)=\"([^\"]*)\"(.*)/  || 
           $query =~ /^\&?([^\&=]+)=([^\&=]*)(.*)/)
    {
      my $key = $1;
      my $value = $2;
      $value = '??' unless(defined($value) && $value && $value ne '??');
      $query = $3;

      if ($key =~ /^(admin|clientaddr|clientname|clientuser|clientgroup|category|targetgroup|color|size|mode|url)$/) 
      {
	$value =~ s/%20/ /g;
	$value =~ s/%22/"/g;
	$value =~ s/%26/\&/g;
	$value =~ s/%3D/=/g;
	$value =~ s/%5C/\\/g;
	$key = 'targetgroup' if ($key eq 'category');
	eval "\$$key = \$value";
      }

      if ($query =~ /^url=(.*)/) 
      {
	$url = $1;
	last;
      }
    }
  }

  return ($admin,$clientaddr,$clientname,$clientuser,$clientgroup,$targetgroup,$url);
}


sub parseURL ($) 
{
  my $url      = shift;
  my $protocol = "";
  my $address  = "";
  my $port     = "";
  my $path     = "";
  $url =~ /^([^\/:]+):\/\/([^\/:]+)(:\d*)?(.*)/;
  $protocol = $1 if(defined($1));
  $address  = $2 if(defined($2));
  $port     = $3 if(defined($3));
  $path     = $4 if(defined($4));
  return($protocol,$address,$port,$path);
}


init();

#     NOTE1: ALLWAYS ESCAPE EMBEDDED VARIABLES (I.E. \$var)            
#    	     IF YOU DON'T YOU MAY OPEN A SECURITY HOLE	               
#     NOTE2: TRIPLE ESCAPE EMBEDDED `\', `"', `$', `@', `%' and `&'    
#    	     (I.E. \\\\, \\\", \\\$, \\\@, \\\&)	               
#     NOTE3: ESCAPE OTHER SPECIAL INLINE CHARACTERS	               
#    	     (I.E. \;, \')				               

# the default is english
my $forbidden = '403 no access';
my $title = $forbidden;
my $explanation_prefix = 'URL blocked because it is';
my $explanation_suffix = '';
my $go_back = 'back';
my $more_info = 'More information about URLfilterDB is <a href="http://www.urlfilterdb.com">here</a>.';

if ($lang eq 'de') {
   $forbidden = '403 Verboten';
   $title = "403 zugriff verweigert ($targetgroup)";
   $explanation_prefix = 'Zugriff verweigert weil die URL die Klassifizierung';
   $explanation_suffix = 'hat.';
   $more_info = 'Mehr Informationen &uuml;ber URLfilterDB ist <a href="http://www.urlfilterdb.com">hier</a>.';
   $go_back = 'Klicken Sie hier um zur&uuml;ck zu gehen.';
}
elsif ($lang eq 'pl') {
   $forbidden = 'Pobranie tej strony jest zabronione!';
   $title = "403: Cenzura, zakaz pobrania ($targetgroup)";
   $explanation_prefix = 'Nie otworzysz tej strony bo jest ona sklasyfikowana jako';
   $explanation_suffix = 'przez program kontroli URLfilterDB';
   $more_info = 'Informacja (po angielsku) o tym programie kontroli jest na <a href="http://www.urlfilterdb.com">stronie</a>.';
   $go_back = 'Wycofaj do poprzedniej strony';
}
elsif ($lang eq 'nl') {
   $forbidden = '403 Geen Toegang';
   $title = "403 geen toegang ($targetgroup)";
   $explanation_prefix = 'De toegang is geblokkeerd omdat de URL in de categorie';
   $explanation_suffix = 'valt.';
   $more_info = 'Meer informatie over URLfilterDB is <a href="http://www.urlfilterdb.com">hier</a>.';
   $go_back = 'Klik hier om terug te gaan';
}
elsif ($lang eq 'es') {
   $forbidden = '403 Ning&uacute;n acceso';
   $title = "403 ning&uacute;n acceso ($targetgroup)";
   $explanation_prefix = 'Se bloquea el acceso puesto que el URL se considera ser';
   $explanation_suffix = '';
   $more_info = 'M&aacute;s informaci&oacute;n sobre URLfilterDB est&aacute; <a href="http://www.urlfilterdb.com">aqu&iacute;</a>.';
   $go_back = 'ir detrás';
}
elsif ($lang eq 'it') {
   $forbidden = '403 Accesso non permesso';
   $title = "403 accesso non permesso ($targetgroup)";
   $explanation_prefix = "L'accesso &egrave; ostruito poich&eacute; il URL &egrave; considerato come";
   $explanation_suffix = '';
   $more_info = 'Le pi&ugrave; informazioni su URLfilterDB sono <a href="http://www.urlfilterdb.com">qui</a>.';
   $go_back = 'andare indietro';
}
elsif ($lang eq 'pt') {
   $forbidden = '403 Proibido';
   $title = "403 Proibido ($targetgroup)";
   $explanation_prefix = "O acesso a este site foi bloqueado porque o conte&uacute;do est&aacute;";
   $explanation_suffix = '';
   $more_info = 'Mais informa&ccedil;&atilde;o sobre URLfilterDB est&aacute; <a href="http://www.urlfilterdb.com">aqui</a>.';
   $go_back = 'volte';
}
elsif ($lang eq 'fr') {
   $forbidden = '403 Interdit';
   $title = "403 Interdit ($targetgroup)";
   $explanation_prefix = "L'access est inderdit parce que le site est";
   $explanation_suffix = '';
   $more_info = "Plus d'information de URLfilterDB est <a href=\"http://www.urlfilterdb.com\">ici</a>.";
   $go_back = 'rentrer';
}
else {   # default (matches 'en')
   $forbidden = '403 Forbidden';
   $title = "403 Forbidden ($targetgroup)";
   $explanation_prefix = 'Access is blocked since the URL is considered to be';
   $explanation_suffix = '';
   $more_info = 'More information about URLfilterDB is <a href="http://www.urlfilterdb.com">here</a>.';
   $go_back = 'Click here to go back';
   $lang = 'en';
}

if ($color eq 'orange')
{
   $textcolor = 'white';
   $bgcolor = '#ee8811';
}
elsif ($color eq 'white')
{
   $textcolor = '#3f003f';
   $bgcolor = 'white';
}
elsif ($color eq 'black')
{
   $textcolor = '#f0f0f0';
   $bgcolor = 'black';
}
elsif ($color eq 'red')
{
   $textcolor = '#f0f0f0';
   $bgcolor = 'red';
}
elsif ($color eq 'grey'  ||  $color eq 'gray')
{
   $textcolor = '#111111';
   $bgcolor = '#c2c2c2';
}
else	# default color: orange
{
   $textcolor = 'white';
   $bgcolor = '#ee8811';
}

if ($size eq 'normal')
{
   $titlesize = '+2';
   $textsize = '+0';
}
elsif ($size eq 'small')
{
   $titlesize = '+1';
   $textsize = '-1';
}
elsif ($size eq 'large')
{
   $titlesize = '+3';
   $textsize = '+1';
}
else    # default size: normal
{
   $titlesize = '+2';
   $textsize = '+0';
   $size = 'normal';
}

my $time = time;
my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);

$url =~ s/[?].*//;

if ($url =~ /\.(bmp|gif|jpg|jpeg|png|mpg|mpeg|divx|xvid|qt|ra|ram|rv|wmv|avi|mov|swf|mp4|mv4)$/i)
{
   my $root;
   my $buffer;

   print "Content-Type: image/png\n";
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime( $time + 180 );
   printf "Expires: %s, %02d-%s-%02d %02d:%02d:%02d GMT\n", $day[$wday], $mday, $month[$mon], $year, $hour, $min, $sec;
   print "\n";

   $root = $ENV{'DOCUMENT_ROOT'};
   my $file = "$root/images/forbidden-normal-$lang.png";
   if ($targetgroup eq 'ads')
   {
      $file = "$root/images/transparent.png";
      $file = "$root/images/no-ads.png" if $mode eq 'noads';
      $file = "$root/images/square.png" if $mode eq 'square';
      $file = "$root/images/smallcross.png" if $mode eq 'cross';
   }
   open( BLOCKEDPNG, "$file" );
   print $buffer while (read (BLOCKEDPNG,$buffer,8192));
   close( BLOCKEDPNG );
}
elsif ($url =~ /\.(js|jar|css)$/i)	
{
   print "Content-Type: text/plain\n";
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime( $time + 180 );
   printf "Expires: %s, %02d-%s-%02d %02d:%02d:%02d GMT\n", 
          $day[$wday], $mday, $month[$mon], $year, $hour, $min, $sec;
   print "\n";

   print "\n";
}
else
{
   print "Content-Type: text/html\n";
   ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime( $time + 180 );
   printf "Expires: %s, %02d-%s-%02d %02d:%02d:%02d GMT\n", 
          $day[$wday], $mday, $month[$mon], $year, $hour, $min, $sec;
   print "Content-Language: $lang\n";
   print "\n";

   if ($targetgroup eq 'ads')
   {
      print "<html>\n";
      print "<head><title>$title</title></head>\n";
      print "<body>\n";
      my $text;
      $text = " ";	 # transparent
      $text = " no ads " if $mode eq 'noads';
      $text = " [] "     if $mode eq 'square';
      $text = " x "      if $mode eq 'cross';
      print "<font size=\"$textsize\">$text</font>\n";
      print "</body>\n";
      print "</html>\n";
   }
   else
   {
      print "<html>";
      print "<head> <title>$title</title> </head>\n";
      print "<body bgcolor=\"$bgcolor\" text=\"$textcolor\">\n";
      print "<font size=\"$titlesize\">$forbidden</font> <br>\n";
      print "<font size=\"$textsize\">\n";
      print "$explanation_prefix <i>$targetgroup</i> $explanation_suffix <br>\n";
      print "URL: $url <br>\n";
      print "<p>\n";
      print "<a href=\"javascript:history.go(-1);\">$go_back</a>. <br>\n";
      print "$admin\n";
      print "<p>\n";
      print "$more_info\n";
      print "</font>\n";

      print "</body>\n";
      print "</html>\n";
   }
}

# TODO: log this event

exit 0;


