/*
 * ufdb-api.h - URLfilterDB
 *
 * ufdbGuard API is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
 *
 * ufdbGuard API is used to integrate the functionality of ufdbGuard into
 * programs of 3rd parties.
 *
 * RCS $Id: ufdb-api.h,v 1.10 2007/11/09 21:23:01 root Exp root $
 */

#if 0

A 3rd party typically has an administration of used categories, 
its associated file names and a category handle (UFDBcategory).
We assume this global data structure:

   struct UFDBusedCategory usedCategory[UFDB_MAX_CATEGORIES];
   int numUsedCategories;
   UFDBthreadAdmin * admin;


See applInit() for the required initialisation code.


An application lookup function might look like this:

void MYAPPverifyURL(
   char *       URL )	 /* e.g. http://user:password@www.asite.com:8080/cgi-bin/x.pl?a=0 */
{
   int          i;
   int          blockurl;
   UFDBrevURL * revUrl;
   int          port;
   char         protocol[16];
   char         strippedUrl[1024];
   char         domain[1024];

   blockurl = 0;
   UFDBstripURL( URL, strippedUrl, domain, protocol, &port );
   revUrl = UFDBgenRevURL( admin, strippedURL );    /* revURL conversion is outside the loop */
   for (i = 0; i < numUsedCategories; i++)
   {
      if (usedCategory[i].block   &&
          UFDBverifyUrlCategory( strippedUrl, revUrl, &usedCategory[i].handle ))
      {
         blockurl = 1;
	 break;
      }
   }
   UFDBfreeRevURL( admin, revUrl );
   if (blockurl)
      fprintf( stderr, "URL %s blocked since it is in category %s\n", URL, usedCategory[i].name );
}
#endif



#ifndef UFDB_UFDBAPI_H_INCLUDED
#define UFDB_UFDBAPI_H_INCLUDED

#include "ufdb.h"
#include "ufdblib.h"

#define UFDB_MAX_CATEGORIES 30


typedef struct
{
   char                 c_name[16];
   struct UFDBmemTable  c_table;
   struct ufdbRegExp *  c_expressions;
}
UFDBcategory;


/* 
 * Load a category.
 */
int UFDBloadCategory( 		/* return value: 0 is success */
   char *         dbfile, 	/* file name of .ufdb file */
   char *         exprfile, 	/* file name of expressions file, may be NULL */
   UFDBcategory * category );	/* category administration must be allocated by the caller */


/*
 * Unload a category.
 */
void UFDBunloadCategory( 
   UFDBcategory * category );


/*
 * strip a URL; 
 * remove http:// prefix, remove www[0-9*]. prefix,
 * remove port number, remove username and password
 */
void UFDBstripURL( 
   char * URL, 			/* input URL string */
   char * strippedUrl,  	/* output char array (must be 1024 bytes) */
   char * domain,  		/* output char array (must be 1024 bytes) */
   char * protocol,		/* output char array (must be 16 bytes) */
   int  * portnumber );		/* output integer */


/* 
 * perform a lookup of a URL in a category
 */
typedef struct UFDBusedCategory_s
{
   char *       name;		/* category name, e.g. "adult" */
   int          block;		/* boolean: use this category to block URLs ? */
   UFDBcategory handle;		/* pointer to category table */
   void *       userData;	/* pointer to application data that is not managed by the API */
} UFDBusedCategory;

int UFDBverifyUrlCategory(	/* return value: 0 means URL is not in the category */
   char *         strippedUrl,	/* stripped URL, e.g. asite.com/cgi-bin/x.pl?a=0 */
   UFDBrevURL *   revUrl,       /* stripped URL in reverse order */
   UFDBusedCategory * category );	/* category handle */

/*
 *  functions to maintain the list of uncategorised URLs.
 */
int UFDBuploadUncategorisedURLs( char * agent );

int UFDBsaveUncategorisedURL( char * domain );

char * UFDBretrieveUncategorisedURLs( void );

void UFDBresetUncategorisedURLs( void );

int UFDBVerifyURLisUncategorised( 
   char *           URL,
   UFDBrevURL *     revURL,  
   UFDBusedCategory category[],
   int              n_categories  );


#endif

