/*
 * ufdblogerror.c - URLfilterDB
 *
 * ufdbGuard API is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
 *
 * ufdbGuard API is used to integrate the functionality of ufdbGuard into
 * programs of 3rd parties.
 *
 * RCS $Id: ufdblogerror.c,v 1.3 2007/11/09 21:23:13 root Exp root $
 */

 
#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE  600
#endif

#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE  200112L
#endif

#include <stdio.h>
#include <stdarg.h>

#ifndef MAX_BUF
#define MAX_BUF 1024
#endif


void ufdbLogError( char * format, ... )
{
   va_list ap;
   char    msg[MAX_BUF];

   va_start(ap, format);
   if (vsnprintf(msg, MAX_BUF-1, format, ap) > (MAX_BUF - 2))
      msg[MAX_BUF-1] = '\0';
   va_end(ap);

   fprintf( stderr, "%s\n", msg );
}


void ufdbLogMessage( char * format, ... )
{
   va_list ap;
   char    msg[MAX_BUF];

   va_start(ap, format);
   if (vsnprintf(msg, MAX_BUF-1, format, ap) > (MAX_BUF - 2))
      msg[MAX_BUF-1] = '\0';
   va_end(ap);

   fprintf( stderr, "%s\n", msg );
}

