#!/bin/sh
#
# install_etcfiles.sh
#
# $Id: install_etcfiles.sh,v 1.10 2007/11/26 15:42:49 root Exp root $

PATH=/usr/xpg4/bin:$PATH
export PATH

OS=unix

ID=`id -un`
if [ "$ID" != root ]
then
   echo
   echo "***  You must be root but you appear to be $ID."
   echo
   exit 1
fi

CFGDIR="$1"
if [ ! -d "$CFGDIR" ]
then
   echo "install_etcfiles.sh: $CFGDIR is not a directory"
   exit 1
fi

BINDIR="$2"
if [ ! -d "$BINDIR" ]
then
   echo "install_etcfiles.sh: $BINDIR is not a directory"
   exit 1
fi

if [ -d /usr/pkg/etc/rc.d ]
then
   OS=netbsd
   INITDIR=/usr/pkg/etc/rc.d
else
   if [ -d /usr/local/etc/rc.d ]		# freebsd 
   then
      OS=freebsd
      INITDIR=/usr/local/etc/rc.d
   else
      if [ -d /etc/rc3.d ]			# Solaris 9, 10
      then
	 OS=solaris
	 RCROOT=/etc/rc3.d
	 if [ -d /etc/init.d ]
	 then
	    INITDIR=/etc/init.d
	 fi
      else
	 if [ -d /etc/rc.d/init.d ]		# linux 2.6
	 then 
	    INITDIR=/etc/rc.d/init.d
	    if [ -d /etc/rc.d/rc3.d ]
	    then
	       RCROOT=/etc/rc.d
	    else
	       RCROOT=$INITDIR
	    fi
	 else
	    if [ -d /etc/init.d ]			# linux 2.4
	    then 
	       INITDIR=/etc/init.d
	       if [ -d /etc/rc.d/rc3.d ]
	       then
		  RCROOT=/etc/rc.d
	       else
		  RCROOT=$INITDIR 			# linux 2.4
	       fi
	    else
	       if [ -d /sbin/init.d ]		# HPUX 11.x
	       then
		  INITDIR=/sbin/init.d
		  RCROOT=$INITDIR
	       else
		  echo "cannot find the system rc init.d directory"
		  echo "please run install_etcfiles.sh manually and specify the directory"
		  exit 1
	       fi
	    fi
	 fi
      fi
   fi
fi


install_netbsd () {

   if [ ! -w $INITDIR ]
   then
      echo "No permission to write to $INITDIR"
      exit 1
   fi

   rm -f $INITDIR/ufdb.sh
   cp mtserver/ufdb.sh $INITDIR/ufdb.sh
   chmod 755 $INITDIR/ufdb.sh

   echo "ufdb.sh copied to $INITDIR"
}


install_freebsd () {

   if [ ! -w $INITDIR ]
   then
      echo "No permission to write to $INITDIR"
      exit 1
   fi

   rm -f $INITDIR/ufdb.sh
   cp mtserver/ufdb.sh $INITDIR/ufdb.sh
   chmod 755 $INITDIR/ufdb.sh
}


install_solaris () {

   if [ ! -w "$RCROOT" ]
   then
      echo "No permission to write to $RCROOT"
      exit 1
   fi

   for file in /etc/rc0.d/K15ufdb /etc/rc1.d/K15ufdb /etc/rc2.d/K15ufdb /etc/rc3.d/S40ufdb \
	       /etc/rc4.d/K15ufdb /etc/rc5.d/S40ufdb /etc/rcS.d/K15ufdb
   do
      if [ -d `dirname $file` ]
      then
	 rm -f $file
	 cp mtserver/ufdb.sh $file
	 chmod 755 $file
      fi
   done

}


install_unix () {

   if [ ! -w $INITDIR ]
   then
      echo "No permission to write to $INITDIR"
      exit 1
   fi

   rm -f $INITDIR/ufdb
   cp mtserver/ufdb.sh $INITDIR/ufdb
   chmod 755 $INITDIR/ufdb

   if [ ! -f $RCROOT/rc3.d/K02ufdb ]		# rc3
   then
      ln -s $INITDIR/ufdb $RCROOT/rc3.d/K02ufdb
   fi
   if [ ! -f $RCROOT/rc3.d/S50ufdb ]
   then
      ln -s $INITDIR/ufdb $RCROOT/rc3.d/S50ufdb
   fi

   if [ ! -f $RCROOT/rc5.d/K02ufdb ]		# rc5
   then
      ln -s $INITDIR/ufdb $RCROOT/rc5.d/K02ufdb
   fi
   if [ ! -f $RCROOT/rc5.d/S50ufdb ]
   then
      ln -s $INITDIR/ufdb $RCROOT/rc5.d/S50ufdb
   fi
}


check_su () {

   eval `grep ^RUNAS= mtserver/ufdb.sh `
   if [ "$RUNAS" != ""  -a  "$RUNAS" != root ]
   then
      SUTEST=`su $RUNAS -c "echo sutest" | tail -1`
      if [ "$SUTEST" != sutest ]
      then
         echo
	 echo "***** \"su $RUNAS\" failed.  Make sure that user $RUNAS has a valid login shell.  *****"
	 echo
      fi
   fi
}

case $OS in
   netbsd)      install_netbsd ;;
   freebsd)     install_freebsd ;;
   solaris)     install_solaris ;;
   *) 		install_unix ;;
esac



SERVICE=`grep ufdbguardd /etc/services`
if [ "$SERVICE" = "" ]
then
   (
      echo ""
      echo "# for URLfilterDB daemon : "
      echo "ufdbguardd      3977/tcp"
   ) >> /etc/services
fi

