void * accept_main( void * ptr )
{
   sigset_t            signals;
   int                 s;
   int                 sock_parm;
   struct sockaddr_in  addr;
   struct linger       linger;
   struct tms 	       timer;
   char                timeString[256];

   /* The HUP signal must be blocked.
    * This is a requirement to use sigwait() in a thread.
    */
   sigemptyset( &signals );
   sigaddset( &signals, SIGHUP );
   pthread_sigmask( SIG_BLOCK, &signals, NULL );

   UFDBtimerInit( &timer );
   gettimeofday( &start_time, NULL );

   globalArgv = my_argv;
   globalEnvp = my_envp;
   sgSetGlobalErrorLogFile();
   globalFatalError = 0;
   sgReadConfig( configFile );
   /* sgSetGlobalErrorLogFile(); */

   if (noRedirects)
      ufdbLogError( "-T option is used.  In test mode no URLs are ever blocked." );
   if (globalFatalError)
      ufdbLogError( "A FATAL ERROR OCCURRED: ALL REQUESTS ARE ANSWERED WITH \"OK\" (see previous lines)  *****" );

   /*
    * create the daemon socket that the listen/accept connections on.
    */
   s = socket( AF_INET, SOCK_STREAM, 0 );
   if (s < 0)
   {
      ufdbLogError( "cannot create daemon socket: %s", strerror(errno) );
      pthread_exit( (void *) 1 );    /* TO-DO */
   }

   /* 
    * The port number can be specified in the config file (portNum is set by the parser)
    * or a command line parameter (portNumCmdLine is set in main).
    * The command line setting has preference.
    */
   if (portNumCmdLine >= 0)
      portNum = portNumCmdLine;
   addr.sin_family = AF_INET;
   addr.sin_addr.s_addr = htonl( INADDR_ANY );
   addr.sin_port = htons( portNum );

   /*
    * Allow server-side addresses to be reused (don't have to wait for timeout).
    */
   sock_parm = 1;
   setsockopt( s, SOL_SOCKET, SO_REUSEADDR, (void *) &sock_parm, sizeof(sock_parm) );

   if (bind( s, (struct sockaddr *) &addr, sizeof(addr) ) < 0)
   {
      ufdbLogError( "cannot bind daemon socket: %s", strerror(errno) );
      ufdbLogError( "check for and kill old daemon processes" );
      fprintf( stderr, "cannot bind daemon socket: %s\n", strerror(errno) );
      fprintf( stderr, "check for and kill old daemon processes" );
      close( s );
      pthread_exit( (void *) 1 );
   }
   
   /*
    * According to comment in the Apache httpd source code, these socket
    * options should only be set after a successful bind....
    *
    * Turn off NAGLE.
    */
   sock_parm = 1;
   setsockopt( s, SOL_SOCKET, SO_KEEPALIVE, (void *) &sock_parm, sizeof(sock_parm) );

   linger.l_onoff = 1;
   linger.l_linger = 2;
   setsockopt( s, SOL_SOCKET, SO_LINGER, (void *) &linger, sizeof(linger) );

   sock_parm = 1;
   setsockopt( s, IPPROTO_TCP, TCP_NODELAY, (void *) &sock_parm, sizeof(sock_parm) );

   if (listen( s, UFDB_MAX_WORKERS ) < 0)
   {
      ufdbLogError( "cannot listen on daemon socket: %s", strerror(errno) );
      fprintf( stderr, "cannot listen on daemon socket: %s\n", strerror(errno) );
      close( s );
      pthread_exit( (void *) 1 );
   }

   /* Now is the right moment to write out main PID to the pid file
    * that is used by /etc/init.d/ufdb to send signals to ufdbguardd.
    */
   writePidFile();
   atexit( removePidFile );

   ufdbLogError( "ufdbguardd " VERSION " started with %d threads", n_workers );

   UFDBreconfig = 0;

   daemon_accept_connections( s, (struct sockaddr *) &addr );

   UFDBtimerStop( &timer );
   UFDBtimerPrintString( timeString, &timer, "S" );
   ufdbLogError( timeString );

   removePidFile();
   pthread_exit( NULL );

   return NULL;
}



void ufdbCatchBadSignal( int signum )
{
   int       i;
   int       num;
   int       i_am_thread;
   pthread_t self;
   char      me[32];
   
   UFDBreconfig = 1;		/* be extra careful and set UFDBreconfig */

   self = pthread_self();

   /* find out which thread has a signal */
   i_am_thread = 0;
   sprintf( me, "pid %d", (int) getpid() );
   if (self == HUPhandler)
   {
      strcpy( me, "thread HUP-handler" );
      i_am_thread = 1;
   }
   else if (self == sockethandler)
   {
      strcpy( me, "thread socket-handler" );
      i_am_thread = 1;
   }
   else 
   {
      num = UFDB_NUM_HTTPS_VERIFIERS;
      for (i = 0; i < num; i++)
         if (self == httpsthr[i])
	 {
	    sprintf( me, "thread https-verifier-%02d", i );
	    i_am_thread = 1;
	    break;
	 }
      num = n_workers;
      for (i = 0; i < num; i++)
         if (self == workers[i])
	 {
	    sprintf( me, "thread worker-%02d", i );
	    i_am_thread = 1;
	    break;
	 }
   }
   ufdbLogError( "\"%s\" caught signal %d.", me, signum );

#if defined(__linux__) && 0
   if (signum != SIGINT && signum != SIGTERM)
   {
      void *    functions[32];
      char **   function_names;

      num = backtrace( functions, 32 );
      function_names = backtrace_symbols( functions, num );
      for (i = 0; i < num; i++)
	 ufdbLogError( "   function %s", function_names[i] );
      free( function_names );
   }
#endif

   if (signum == SIGINT || signum == SIGTERM)
   {
#if defined(UFDB_FREE_MEMORY)
      /* usleep( 200000 ); */
      sleep( 1 );
      ufdbLogError( "freeing memory ..." );
      ufdbFreeAllMemory();
      ufdbLogError( "done freeing memory." );
#endif
      /* implement our own linger_close() */
      removePidFile();
      pthread_cancel( sockethandler );
      sleep( 2 );
      exit( 0 );
   }
   else
   {
      removePidFile();

      if (i_am_thread)
      {
	 kill( globalPid, SIGABRT );
      }

      exit( 2 );
   }
}


static void catchHUPSignal( int signal )
{
   pthread_kill( HUPhandler, SIGHUP );
}


int main( 
   int            argc,
   char **        argv,
   char **        envp )
{
   int            i;
   pid_t          pid;
   pthread_attr_t attr;
   time_t 	  t;
   char           niso_str[22];

   strcpy( progname, "ufdbguardd" );

   while ((i = getopt(argc, argv, "ATdDPh?rt:c:L:p:vw:")) != EOF)
   {
      switch (i) {
      case 'A':
	 fprintf( stderr, "-A option is obsolete\n");
	 break;
      case '?':
      case 'h':
         usage( '\0' );
	 break;
      default:
         usage( i );
      }
   }

   if (runAsDaemon)
   {
      if ((pid = fork()) != 0)
	 exit( 0 );        
      setsid();
   }

   globalPid = getpid();

   /*
    * Initialise signal handlers.
    * The HUP signal is dealt with on a per thread basis.
    */
   sgSetSignalHandler( SIGINT,  ufdbCatchBadSignal );
   sgSetSignalHandler( SIGQUIT, ufdbCatchBadSignal );
   sgSetSignalHandler( SIGILL,  ufdbCatchBadSignal );
   sgSetSignalHandler( SIGBUS,  ufdbCatchBadSignal );
   sgSetSignalHandler( SIGABRT, ufdbCatchBadSignal );
   sgSetSignalHandler( SIGSEGV, ufdbCatchBadSignal );
   sgSetSignalHandler( SIGTERM, ufdbCatchBadSignal );

   sgSetSignalHandler( SIGPIPE, SIG_IGN );
   sgSetSignalHandler( SIGHUP,  catchHUPSignal );

   return 0;
}


