/*
 * perftest1.c
 *
 * open as many sockets to ufdbhttpd as possible.
 */

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/times.h>

#include "ufdblib.h"

FILE * globalErrorLog = NULL;
int    globalFatalError = 0;
int    globalDebugTimeDelta = 0;
struct LogFile * globalLogFile = NULL;

int    globalPid = 0;
char   progname[80] = "perftest1";

main( int argc, char * argv[] )
{
   int  s;
   int  i;
   int  n, len;
   struct tms t;
   char buffer[8192];

   UFDBglobalDebug = 1;
   UFDBtimerInit( &t );

   for (i = 0; i < 10000; i++)
   {
      s = UFDBopenSocket( "localhost", 8081 );
      if (s < 0)
      {
         fprintf( stderr, "UFDBopenSocket failed: i=%d %s\n", i, strerror(errno) );
	 exit( 1 );
      }

      sprintf( buffer, "GET /cgi-bin/URLblocked.cgi?mode=normal&color=black&category=proxies&url=www.aap.nl/%d\r\n"
                       "Connection: close\r\n"
		       "\r\n",
		       i );
      len = strlen( buffer );
      n = write( s, buffer, len );
      if (n != len)
      {
         fprintf( stderr, "write failed: i=%d n=%d len=%d %s\n", i, n, len, strerror(errno) );
	 exit( 2 );
      }

      n = read( s, buffer, 8192 );
      if (n <= 0)
      {
         fprintf( stderr, "read failed: i=%d n=%d %s\n", i, n, strerror(errno) );
	 exit( 3 );
      }

      close( s );
   }

   UFDBtimerStop( &t );
   UFDBtimerPrint( &t, "perftest1 10000" );

   return 0;
}
