/*
  By accepting this notice, you agree to be bound by the following
  agreements:
  
  ufdbGuard is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
  ufdbGuard is based on squidGuard.

  squidGuard is copyrighted (C) 1998 by
  ElTele st AS, Oslo, Norway, with all rights reserved.
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License (version 2) as
  published by the Free Software Foundation.  It is distributed in the
  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License (GPL) for more details.
  
  You should have received a copy of the GNU General Public License
  (GPL) along with this program.
*/

%{

#include "ufdb.h"
#include "sg.h"
#include "y.tab.h"

#include <stdio.h>
#include <string.h>

%}

ignore   [,\t\r ]+
s        [\t ]
d        [0-9]
ip       {d}{1,3}\.{d}{1,3}\.{d}{1,3}\.{d}{1,3}
tval     {d}{d}[:]{d}{d}
dval     {d}{d}{d}{d}[\.-]{d}{d}[\.-]{d}{d}
dvalcron ({d}{d}{d}{d}|[\*])[\.-]({d}{d}|[\*])[\.-]({d}{d}|[\*])
weekday  (mon|mondays?|tue|tuesdays?|wed|wednesdays?|thu|thursdays?|fri|fridays?|sat|saturdays?|sun|sundays?)
weekdays (({weekday}{s}*[, \t]+{s}*)*{weekday})|[\*]

%e 14000
%p 30000
%n 4000
%a 8000

%x REDIRECT_STATE

%%

[ \t]*#.*        ;
"{"          return START_BRACKET;
"}"          return STOP_BRACKET; 
","	     return COMMA;
"="	     return EQUAL;

^cat         return CATEGORY;
^category    return CATEGORY;
^dest        return CATEGORY;
^destination return CATEGORY;
^src         return SOURCE;
^source      return SOURCE;

^rew         return REWRITE;
^rewrite     return REWRITE;
^time        return TIME;
^acl         return ACL;

http-server { return HTTP_SERVER; }
images      { return IMAGES; }
interface   { return INTERFACE; }
port        { return PORT; }

^dbhome     { return DBHOME; }
^logdir     { return LOGDIR; }
^cpus       { return CPUS; }
^analyse-uncategorised-urls   { return ANALYSE_UNCATEGORISED; }
^analyze-uncategorised-urls   { return ANALYSE_UNCATEGORISED; }

administrator               return ADMINISTRATOR;

option			    return OPTION;
safe-search          	    return SAFE_SEARCH;
max-logfile-size       	    return MAX_LOGFILE_SIZE;
check-proxy-tunnels         return CHECK_PROXY_TUNNELS;
queue-checks	            return QUEUE_CHECKS;
agressive                   return AGRESSIVE;
log-only                    return LOG_ONLY;
off                         return OFF;
on                          return ON;
enforce-https-with-hostname return ENFORCE_HTTPS_WITH_HOSTNAME;
enforce-https-offical-certificate return ENFORCE_HTTPS_OFFICAL_CERTIFICATE;
https-connection-cache-size return HTTPS_CONNECTION_CACHE_SIZE;
logblock		    return LOGBLOCK;
logall  		    return LOGALL;

domainlist                  return DOMAINLIST;
urllist                     return URLLIST;
expressionlist              return EXPRESSIONLIST;

unix        return UNIX;
ldap        return LDAP;
user        return USER;
userlist    return USERLIST;
group       return GROUP;

userquota   return USERQUOTA;
iplist      return IPLIST;
domain      return DOMAIN;
pass        return PASS;
rewrite     return REWRITE;
redirect    { BEGIN REDIRECT_STATE; return REDIRECT; }

minutely    return MINUTELY;
hourly      return HOURLY;
daily       return DAILY;
weekly      return WEEKLY;
continuous  return CONTINIOUS;
continue    return CONTINUE;
sporadic    return SPORADIC;
date        return DATE;

anonymous   return ANONYMOUS;
log         return LOGFILE;
logfile     return LOGFILE;
{weekdays}  { yylval.string = yytext; return WEEKDAY; }
within      return WITHIN;
outside     return OUTSIDE;
else        return ELSE;
ip          return IP;
{ip}        { yylval.string = yytext; return IPADDR; }
[/]{d}+     { yylval.string = yytext; return CIDR; }
[/]{ip}     { yylval.string = yytext; return IPCLASS; }
{tval}      { yylval.string = yytext; return TVAL; }
{dval}      { yylval.string = yytext; return DVAL; }
{dvalcron}  { yylval.string = yytext; return DVALCRON; }
{d}+        { yylval.string = yytext; return NUMBER; }
{d}+","[0-9,]+   { yylval.string = yytext; return NUMBERS; }

\".+\"         { yylval.string = yytext+1; *(strchr(yytext+1,'"')) = '\0'; return QSTRING; }

<REDIRECT_STATE>[0-9a-zA-Z\/\.][a-zA-Z0-9/_\-\.\/\:\%\+\?=&]*  { yylval.string = yytext; BEGIN 0; return WORD; }
<REDIRECT_STATE>[ \t]+    ;
<REDIRECT_STATE>\n        { lineno++; }
<REDIRECT_STATE>.         { return yytext[0]; }

[a-zA-Z\/\.][a-zA-Z0-9/_\-\.\/\:\%\+\?=&]*        { yylval.string = yytext; return WORD; }
s@(([^@}]|\\@|\\\})+)@(([^@}]|\\@|\\\})+)@[girR]* { yylval.string = yytext; return SUBST; }
[ \t]+     ;
\n        { lineno++; }
.         { return yytext[0]; }


%%



