/*
  By accepting this notice, you agree to be bound by the following
  agreements:
  
  ufdbGuard is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
  ufdbGuard is based on squidGuard.

  squidGuard is copyrighted (C) 1998 by
  ElTele st AS, Oslo, Norway, with all rights reserved.
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License (version 2) as
  published by the Free Software Foundation.  It is distributed in the
  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License (GPL) for more details.
  
  You should have received a copy of the GNU General Public License
  (GPL) along with this program.

  $Id: sgLog.c,v 1.27 2007/11/13 19:50:57 root Exp root $
*/

#include "ufdb.h"
#include "ufdblib.h"
#include "sg.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>

extern int    globalFatalError; 
extern int    globalPid;      		/* from main.c */
extern char * UFDBglobalLogDir;   
extern FILE * globalErrorLog;
extern int    globalDebugTimeDelta;

static pthread_mutex_t log_mutex = UFDB_STATIC_MUTEX_INIT;
static int    globalLogging = 1;

static int    UFDBforceLogRotation = 0;
static char   UFDBlogFilename[1024];


/* Rotate log files.
 * There is a race condition when multiple instances try to rotate.
 * Therefore acquire a lock and sleep for 1 second if the lock fails.
 */
static void RotateLogfile( char * filename )
{
   int         i;
   char        oldfile[1024];
   char        newfile[1024];

   /* rotate the log file:
    * file.log.4  ->  file.log.5
    * file.log.3  ->  file.log.4
    * file.log.2  ->  file.log.3
    * file.log.1  ->  file.log.2
    * file.log    ->  file.log.1
    */

   for (i = 8; i > 1; i--)
   {
      sprintf( newfile, "%s.%d", filename, i );
      sprintf( oldfile, "%s.%d", filename, i-1 );
      rename( oldfile, newfile );
   }

   sprintf( newfile, "%s.%d", filename, 1 );
   rename( filename, newfile );
}


void ufdbGlobalSetLogging( int logging )
{
   globalLogging = logging;
}


void UFDBrotateLogfile( void )
{
   UFDBforceLogRotation = 1;
}


void ufdbSetGlobalErrorLogFile( void )
{
   struct stat s;

   if (!globalLogging)
      return;

   if (UFDBglobalDebug)
      return;

   if (globalErrorLog != NULL)
   {
      fclose( globalErrorLog );
      globalErrorLog = NULL;
   }

   if (UFDBglobalLogDir == NULL)
      strcpy( UFDBlogFilename, DEFAULT_LOGDIR );
   else
      strcpy( UFDBlogFilename, UFDBglobalLogDir );
   strcat( UFDBlogFilename, "/" );

   if (progname != NULL  &&  progname[0] != '\0')
   {
      strcat( UFDBlogFilename, progname );
      strcat( UFDBlogFilename, ".log" );
   }
   else
      strcat( UFDBlogFilename, DEFAULT_LOGFILE );

   if (stat(UFDBlogFilename,&s) == 0)
   {
      if (s.st_size > UFDBglobalMaxLogfileSize)
	 RotateLogfile( UFDBlogFilename );
   }

   globalErrorLog = fopen( UFDBlogFilename, "a" );
   if (globalErrorLog == NULL)
   {
      ufdbLogError( "%s: can't write to logfile %s; %s (uid=%d,euid=%d)", 
      	 	    progname, UFDBlogFilename, strerror(errno), getuid(), geteuid() );
      /*
       * We *want* a logfile, try an other directory...
       */
      strcpy( UFDBlogFilename, "/tmp/" );
      strcat( UFDBlogFilename, progname );
      strcat( UFDBlogFilename, ".log" );
      globalErrorLog = fopen( UFDBlogFilename, "a" );
      if (globalErrorLog == NULL)
	 ufdbLogError( "%s: can't write to logfile %s; %s", progname, UFDBlogFilename, strerror(errno) );
   }
}


void niso( time_t t, char * buf )
{
  time_t    tp;
  struct tm lc;

  if (t == 0)
    tp = time(NULL) + globalDebugTimeDelta;
  else
    tp = t;
  localtime_r( &tp, &lc );
  sprintf( buf, "%04d-%02d-%02d %02d:%02d:%02d", lc.tm_year + 1900, lc.tm_mon + 1,
	  lc.tm_mday, lc.tm_hour, lc.tm_min, lc.tm_sec );
}



static void ufdbLog( 
   char * msg  )
{
   char    date[22];
   char    logmsg[MAX_BUF];

   if (!globalLogging)
      return;

   niso( 0, date );
   sprintf( logmsg, "%s [%d] %s\n", date, globalPid, msg );

   pthread_mutex_lock( &log_mutex );			/* LOG_MUTEX *******************/

   if (UFDBforceLogRotation)
   {
      UFDBforceLogRotation = 0;
      if (globalErrorLog != NULL)  
      {
	 RotateLogfile( UFDBlogFilename );
	 ufdbSetGlobalErrorLogFile();
      }
   }

   if (UFDBglobalDebug || globalErrorLog == NULL) 
   {
     fputs( logmsg, stderr );
     fflush( stderr );
   }
   else
   {
      if (globalErrorLog == NULL)
      {
#if 0
	 UFDBglobalDebug = 1;
#endif
	 fputs( logmsg, stderr );
	 fflush( stderr );
      }
      else 
      {
	 static  int sizecheckcounter = 0;	/* this var is OK in multithreaded app */

	 fputs( logmsg, globalErrorLog );
	 fflush( globalErrorLog );

	 if (--sizecheckcounter < 0)
	 {
	    long  pos;

	    sizecheckcounter = 100;		/* minimize the number of calls to ftell() */
	    pos = ftell( globalErrorLog );
	    if (pos > UFDBglobalMaxLogfileSize)
	    {
	       RotateLogfile( UFDBlogFilename );
	       ufdbSetGlobalErrorLogFile();
	    }
	 }
      }
   }

   pthread_mutex_unlock( &log_mutex );			/* LOG_MUTEX *******************/
}


void ufdbLogError( char * format, ... )
{
   va_list ap;
   char    msg[MAX_BUF];

   if (!globalLogging)
      return;

   VA_START( ap, format );
   vsnprintf( msg, MAX_BUF-32, format, ap );
   msg[MAX_BUF-32] = '\0';
   va_end( ap );

   ufdbLog( msg );
}


void ufdbLogMessage( char * format, ... )
{
   va_list ap;
   char    msg[MAX_BUF];

   if (!globalLogging)
      return;

   VA_START( ap, format );
   vsnprintf( msg, MAX_BUF-32, format, ap );
   msg[MAX_BUF-32] = '\0';
   va_end( ap );

   ufdbLog( msg );
}


void ufdbLogFatalError( char * format, ... )
{
   va_list ap;
   char    msg[MAX_BUF];
   char    logmsg[MAX_BUF];

   VA_START( ap, format );
   vsnprintf( msg, MAX_BUF-48, format, ap );
   msg[MAX_BUF-48] = '\0';
   va_end( ap );

   sprintf( logmsg, "*FATAL* %s  *****", msg );
   ufdbLog( logmsg );

   globalFatalError = 1;
}


