/*
 * ufdb.h - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
 * ufdbGuard is based on squidGuard.
 *
 * squidGuard is copyrighted (C) 1998 by
 * ElTele st AS, Oslo, Norway, with all rights reserved.
 *
 * RCS $Id: ufdb.h,v 1.28 2007/11/23 01:46:39 root Exp root $
 */

/* 
 * An ordered table looks like this:
 *
 * UNIVERSE
 *         com 
 *             foobar
 *                    girls
 *                    boys
 *             pussy
 *             sex
 *             sluts
 *         net 
 *             sluts
 *             whores
 *     
 * The ordered table is implemented with a tree and each node in the tree
 * has nNextLevels children.
 *
 * "UNIVERSE" 0xSUBLEVEL "com" 0xSUBLEVEL "foobar"  0xSUBLEVEL "girls" 0xSAMELEVEL 
 *                                                             "boys"  0xPREVLEVEL
 *                                        "pussy"   0xSAMELEVEL
 *                                        "sex"     0xSAMELEVEL
 *                                        "slut"    0xPREVLEVEL
 *                       "net" 0xSUBLEVEL "mysluts" 0xSAMELEVEL
 *                                        "whores"  0xPREVLEVEL
 *                       0xPREVLEVEL
 * 0xENDTABLE
 *
 * The idea behind this is that the whole table can be loaded into 1 malloc-ed area
 * and that the 0xXXXX tokens can be substitued by a '\0' in memory.
 * The levelTag pointer will point into the table without malloc-ing memory which
 * will save a lot on malloc overhead, memory and CPU time to load the table.
 *
 * The major drawback is that the number of children of a node is unknown when
 * a table is loaded and the arrays of child nodes (nextLevel[]) must be reallocated
 * many times.  This implies a relatively large malloc()/realloc() overhead.
 *
 * To get rid of the malloc() overhead, the number of child nodes (nNextLevels) is 
 * coded into the file.  This is a new feature for database file format 1.2.
 *
 * 254034 lines
 * 173984 nodes with 0 children
 *  67779 nodes with 1 child
 *   7762 nodes with 2 children
 *   2075            3
 *    772            4
 */

#ifndef UFDB_UFDB_H_INCLUDED
#define UFDB_UFDB_H_INCLUDED

#ifndef _REENTRANT
#define _REENTRANT
#endif

#ifndef _XOPEN_SOURCE
#ifdef __sun
#if __STDC_VERSION__ - 0 >= 199901L
#define _XOPEN_SOURCE 600
#else
#define _XOPEN_SOURCE 500
#endif
#else
#define _XOPEN_SOURCE  600
#endif
#endif

#if 0
#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE  200112L
#endif
#endif

#if 0
#ifndef _XOPEN_SOURCE_EXTENDED
#define _XOPEN_SOURCE_EXTENDED  1
#endif
#endif

#ifndef _BSD_SOURCE
#define _BSD_SOURCE 1
#endif

#ifndef UFDB_MALLOC_IS_THREADSAFE
#define UFDB_MALLOC_IS_THREADSAFE 1
#endif

#ifdef UFDB_DEBUG
#ifndef _GNU_SOURCE
#define _GNU_SOURCE
#endif
#ifdef PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP
#define UFDB_STATIC_MUTEX_INIT  PTHREAD_ERRORCHECK_MUTEX_INITIALIZER_NP
#else
#define UFDB_STATIC_MUTEX_INIT  PTHREAD_MUTEX_INITIALIZER
#endif
#else
#define UFDB_STATIC_MUTEX_INIT  PTHREAD_MUTEX_INITIALIZER
#endif

#include "config.h"
#include "version.h"

#if HAVE_VSPRINTF != 1
#error The C library does not have the vsprintf function.
#endif

#if HAVE_STRERROR != 1
#error The C library does not have the strerror function.
#endif

#if HAVE_REGCOMP != 1
#error The C library does not have the regcomp function.
#endif

#if HAVE_SIGACTION != 1
#error The C library does not have the sigaction function.
#endif

#define UFDB_USE_SSL 1


#include <sys/types.h>
#include <regex.h>

#ifndef UFDB_UPLOAD_UNCATEGORISED_URLS_WEBSITE
#define UFDB_UPLOAD_UNCATEGORISED_URLS_WEBSITE  "updates.urlfilterdb.com"
#endif

#ifndef UFDB_UPLOAD_UNCATEGORISED_URLS_CGI
#define UFDB_UPLOAD_UNCATEGORISED_URLS_CGI      "/cgi-bin/uncat.pl"
#endif

#ifndef UFDB_UPLOAD_ANALYSE_SQUID_LOG_CGI
#define UFDB_UPLOAD_ANALYSE_SQUID_LOG_CGI       "/cgi-bin/analyseSquidLog.pl"
#endif

#define UFDB_USERQUOTA_SUPPORT  1

#define UFDB_MAX_THREADS	65
#define UFDB_DAEMON_PORT        3977

void   ufdbFree( void * ptr );
void * ufdbMalloc( size_t n );
void * ufdbRealloc( void * ptr, size_t n );
void * ufdbCalloc( size_t n, size_t num );
void   ufdbGetMallocMutex( char * fn );
void   ufdbReleaseMallocMutex( char * fn );

char * ufdbStrdup( const char * s );

void   ufdbFreeAllMemory( void );

typedef enum { UFDBdomain, UFDBurl } UFDBurlType;

struct UFDBtable;

struct UFDBtable
{
   unsigned char *     tag;
   int                 nNextLevels;
   struct UFDBtable *  nextLevel;
};

struct UFDBfileHeader
{
   char   string[99];  /* UFDB version category numEntries key */
};

struct UFDBfile
{
   struct UFDBfileHeader header;
   struct UFDBtable      table;
};

struct UFDBmemTable
{
   void *              mem;
   char		       version[8];
   char                key[16];
   char                flags[8];
   int                 numEntries;
   long		       tableSize;
   struct UFDBtable    table;
};

typedef struct
{
   unsigned int x;
   unsigned int y;
   unsigned char state[256];
} ufdbCrypt;

void ufdbCryptInit(   ufdbCrypt * uc, const unsigned char * key, unsigned int keySize );
void ufdbEncryptText( ufdbCrypt * uc, unsigned char * dest, const unsigned char * src, unsigned int len );

#define UFDBsubLevel  '\001'
#define UFDBsameLevel '\002'
#define UFDBprevLevel '\003'
#define UFDBendTable  '\020'

#define UFDBmaxDomainNameLength 255
#define UFDBmaxURLsize          512

#define UFDBdbVersion  "1.2"
#define UFDBtableTag   "Hyuj-2Nuz-TfgY-qxC7-KahN-L28x"

#define UFDBfileSuffix ".ufdb"

/* when URL is www.mydomain.com/asubdir/index.html,
 * urlPart is asubdir/index.html
 */
typedef unsigned char UFDBurlPart[120];

struct UFDBrevURL_s;

typedef struct UFDBrevURL_s
{
   UFDBurlPart           part;
   struct UFDBrevURL_s * next;
} UFDBrevURL;

#define MAX_REVURLS	 32

typedef struct UFDBthreadAdmin_s
{
   int                   nAlloced;
   int                   myArrayUsage[MAX_REVURLS];
   UFDBrevURL            myArray[MAX_REVURLS];
} UFDBthreadAdmin;


UFDBthreadAdmin * UFDBallocThreadAdmin( void );

int ufdbguard_main( int argc, char ** argv, char ** envp );

#define UFDB_GROUPTYPE_UNIX    1
#define UFDB_GROUPTYPE_LDAP    2

#define UFDB_API_OK                0
#define UFDB_API_ERR_NULL          1
#define UFDB_API_ERR_NOFILE        2
#define UFDB_API_ERR_READ          3
#define UFDB_API_ERR_EXPR          4
#define UFDB_API_ERR_RANGE         5
#define UFDB_API_ERR_ERRNO         6
#define UFDB_API_ERR_SOCKET        7
#define UFDB_API_ERR_NOMEM         8
#define UFDB_API_REQ_QUEUED        9
#define UFDB_API_ERR_TUNNEL       10
#define UFDB_API_ERR_INVALID_CERT 11
#define UFDB_API_ERR_IP_ADDRESS   12

#define UFDB_API_ALLOW_QUEUING     	   1
#define UFDB_API_VERBOSE_OUTPUT    	   2
#define UFDB_OPT_HTTPS_WITH_HOSTNAME       4
#define UFDB_OPT_HTTPS_OFFICAL_CERTIFICATE 8

#define UFDB_API_HTTPS_CHECK_OFF           0
#define UFDB_API_HTTPS_CHECK_QUEUE_CHECKS  1
#define UFDB_API_HTTPS_CHECK_AGRESSIVE     2
#define UFDB_API_HTTPS_LOG_ONLY            3

#define UFDB_DEF_HTTPS_CONN_CACHE_SIZE     1000

struct ufdbRegExp {
  char *    pattern;
  char *    substitute;
  regex_t * compiled;
  int       error;
  int       flags;
  int       global;
  char *    httpcode;
  struct ufdbRegExp * next;
};

struct ufdbRegExp * ufdbNewPatternBuffer( char * pattern, int flags );

int ufdbRegExpMatch(   
   struct ufdbRegExp * regexp, 
   char *              str );

void ufdbSetSignalHandler( 
   int signal, 
   void (*handler)(int)  );
#endif


