/*
  By accepting this notice, you agree to be bound by the following
  agreements:
  
  ufdbGuard is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
  ufdbGuard is based on squidGuard.

  squidGuard is copyrighted (C) 1998 by
  ElTele st AS, Oslo, Norway, with all rights reserved.
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License (version 2) as
  published by the Free Software Foundation.  It is distributed in the
  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License (GPL) for more details.
  
  You should have received a copy of the GNU General Public License
  (GPL) along with this program.
*/

#include "sg.h"
#include "ufdb.h"
#include "ufdblib.h"

#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#define DATABASE        NULL

extern int     globalUpdate;
extern char *  globalCreateDb;
extern char ** globalArgv;

/*
 * initialise a DB (open and/or create a .ufdb file) 
 */
void sgDbInit( struct sgDb * Db, char * file )
{
   struct UFDBmemTable * tab;
   int                   n;
   int                   in;
   struct stat           fileStat;
   char                  f[1024];

   if (file == NULL)
   {
      ufdbLogError( "  sgDbInit( file = NULL )", file );
      Db->dbcp = NULL;
      Db->entries = -1;
      return;
   }

#if 0
   ufdbLogError( "  sgDbInit( 0x%08x, %s )", Db, file );
#endif

   sprintf( f, "%s%s", file, UFDBfileSuffix );
   in = open( f, O_RDONLY );
   if (in < 0)
   {
      ufdbLogFatalError( "cannot read from \"%s\" (read-only)", f );
      return;
   }

   if (fstat(in,&fileStat) < 0)
   {
      ufdbLogFatalError( "fstat failed on \"%s\"", file );
   }

   tab = ufdbMalloc( sizeof(struct UFDBmemTable) );
   tab->table.tag = (unsigned char *) "UNIVERSE";
   tab->table.nNextLevels = 0;
   tab->table.nextLevel = NULL;
   tab->mem = ufdbMalloc( fileStat.st_size + 1 );
   tab->tableSize = fileStat.st_size - sizeof(struct UFDBfileHeader);
   n = read( in, tab->mem, fileStat.st_size );
   close( in );
   if (n != fileStat.st_size)
   {
      fprintf( stderr, "read failed on \"%s\" n=%d st_size=%ld\n", file, n, fileStat.st_size );
      exit( 1 );
   }

   UFDBparseTableHeader( tab );
   UFDBparseTable( tab );

   Db->dbcp = (void *) tab;
   Db->entries = tab->numEntries;
}


/*
 *  sgDbLookup: lookup a domain/URL in domain and URL databases.  
 *  return 1 if found.
 */
int sgDbLookup( struct sgDb * Db, char * request, char ** retval )
{
#if 0
  ufdbLogError( "  sgDbLookup( 0x%08x, %s, 0x%08x )", Db, request, retval );
#endif

  return UFDBlookup( NULL, (struct UFDBmemTable *) Db->dbcp, request );
}


/* 
 * update a database (INSERT a new key).
 */
struct UFDBmemDB * UFDBmemDBinit( void )
{
   struct UFDBmemDB * m;

   m = ufdbMalloc( sizeof(struct UFDBmemDB) );
   m->key = NULL;
   m->value = NULL;
   m->next = NULL;

   return m;
}


void UFDBmemDBinsert( 
   struct UFDBmemDB * db, 
   char * key, 
   char * value, 
   int    length )
{
   struct UFDBmemDB * prev;

#if 0
   ufdbLogError( "  UFDBmemDBinsert( db=%08x, %s, XXX, %d )", db, key, length );
#endif

   if (db->key == NULL)		/* is the list empty ? */
   {
      db->key = ufdbStrdup( key );
      if (value == NULL || length == 0)
      {
         db->value = NULL;
	 db->length = 0;
      }
      else
      {
	 db->value = ufdbMalloc( length );
	 memcpy( db->value, (void *) value, length );
	 db->length = length;
      }
   }
   else
   {				/* search end of list or key */
      prev = NULL;		
      while (db != NULL  &&  strcmp( db->key, key ) != 0)
      {
	 prev = db;
         db = db->next;
      }

      if (db == NULL)		/* we are at the end, key was not found */
      {
         db = ufdbMalloc( sizeof(struct UFDBmemDB) );
	 db->key = ufdbStrdup( key );
	 if (value == NULL || length == 0)
	 {
	    db->value = NULL;
	    db->length = 0;
	 }
	 else
	 {
	    db->value = ufdbMalloc( length );
	    memcpy( db->value, (void *) value, length );
	    db->length = length;
	 }
	 db->next = NULL;
	 prev->next = db;
      }
      else			/* key was found, overwrite value */
      {
         ufdbFree( db->value );
	 if (value == NULL || length == 0)
	 {
	    db->value = NULL;
	    db->length = 0;
	 }
	 else
	 {
	    db->value = ufdbMalloc( length );
	    memcpy( db->value, (void *) value, length );
	    db->length = length;
	 }
      }
   }
}


int UFDBmemDBfind( 
   struct UFDBmemDB * db,
   char *  key,
   char ** value  )
{
#if 0
   ufdbLogError( "  UFDBmemDBfind( db=%08x, %s )", db, key );
#endif

   if (db == NULL || db->key == NULL)
      return 0;

   while (db != NULL)
   {
      if (strcmp( db->key, key ) == 0)
      {
	 if (*value != NULL)
	    *value = db->value;
         return 1;
      }

      db = db->next;
   }

   return 0;
}


void UFDBmemDBdeleteDB( 
   struct UFDBmemDB * db  )
{
   struct UFDBmemDB * tmp;

   while (db != NULL)
   {
      ufdbFree( db->key );
      ufdbFree( db->value );
      tmp = db->next;
      ufdbFree( db );
      db = tmp;
   }
}


