/*
 * ufdbhttpd  -  extremely simplified http daemon.
 *
 * This daemon is for the ONLY purpose of serving http requests like
 * http://HOST:port/cgi-bin/URLblocked.cgi
 * 
 * copyrighted (C) 2007 by URLfilterDB with all rights reserved.
 */

#include "ufdb.h"
#include "ufdb.h"
#include "ufdblib.h"
#include "httpserver.h"

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <libgen.h>
#include <errno.h>
#include <sys/time.h>

FILE * globalErrorLog = NULL;
int    globalFatalError = 0;
int    globalDebugTimeDelta = 0;
struct LogFile * globalLogFile = NULL;

int    globalPid = 0;
char   progname[80];
int    runAsDaemon = 1;

char   interface[256] = "all";
char   imagesDirectory[256] = "";
int    portnumber = 0;

char * globalPidFile = UFDBHTTPD_PID_FILE;


static void usage( void )
{
   fprintf( stderr, "usage: ufdbhttpd [-U <user>] -p <port> -I <images-directory> -l <log-directory> [-i <interface>]\n" );
   exit( 1 );
}


static void writePidFile( void )
{
   FILE * fp;

   (void) unlink( globalPidFile );
   fp = fopen( globalPidFile, "w" );
   if (fp == NULL)
      ufdbLogError( "cannot write to PID file %s", globalPidFile );
   else
   {
      fprintf( fp, "%d\n", globalPid );
      fclose( fp );
   }
}


static void removePidFile( void )
{
   (void) unlink( globalPidFile );
}


static void mySignalHandler( int sig )
{
   char  sigDesc[16];

   switch (sig)
   {
   case SIGHUP:   strcpy( sigDesc, "HUP" );   break;
   case SIGINT:   strcpy( sigDesc, "INT" );   break;
   case SIGTERM:  strcpy( sigDesc, "TERM" );  break;
   case SIGILL:   strcpy( sigDesc, "ILL" );   break;
   case SIGSEGV:  strcpy( sigDesc, "SEGV" );  break;
   default:       sprintf( sigDesc, "number %d", sig );  break;
   }
   ufdbLogError( "signal %s received. exiting...", sigDesc );
   removePidFile();
   _exit( 2 );
}


static void USR1signalReceived( int sig )
{
   ufdbLogMessage( "USR1 signal received for logfile rotation" );
   UFDBrotateLogfile();
   ufdbLogMessage( "USR1 signal received for logfile rotation" );
}


static void closeAllFiles( void )
{
   int fd;
   int fdlog;

   if (globalErrorLog != NULL)
      fdlog = fileno( globalErrorLog );
   else
      fdlog = -1;

   for (fd = 0; fd < 150; fd++)
   {
      if (fd != fdlog)
         close( fd );
   }
}


int main( int argc, char ** argv )
{
   int    ch;

   strcpy( progname, "ufdbhttpd" );

   globalPid = getpid();
   while ((ch = getopt(argc, argv, "Ddhi:p:I:l:L:U:")) > 0)
   {
      switch (ch) {
      case 'D':				/* undocumented -D option: do not daemonize */
      	 runAsDaemon = 0;
	 break;
      case 'd':
	 UFDBglobalDebug = 1;
	 break;
      case 'i':
	 strcpy( interface, optarg );
	 break;
      case 'p':
	 portnumber = atoi( optarg );
	 break;
      case 'I':
	 strcpy( imagesDirectory, optarg );
	 break;
      case 'l':
	 UFDBglobalLogDir = optarg;
	 break;
      case 'L':				/* undocumented -L option for alternate PID file */
	 globalPidFile = optarg;
         break;
      case 'U':
	 if (strlen(optarg) <= 31)
	    strcpy( UFDBglobalUserName, optarg );
	 else
	    ufdbLogFatalError( "username supplied with -U option is too long" );
         break;
      case '?':
      case 'h':
      default:
	 usage();
      }
   }

   ufdbSetGlobalErrorLogFile();

   if (UFDBglobalLogDir == NULL ||
       imagesDirectory[0] == '\0'  ||
       portnumber <= 0)
   {
      ufdbLogFatalError( "%s started with incorrect parameters. aborting...", progname );
      usage();
      exit( 1 );
   }

   if (runAsDaemon)
   {
      pid_t pid;
      if ((pid = fork()) != 0)
	 exit( 0 );        
      if (setsid() < 0)
         ufdbLogFatalError( "cannot create daemon session: %s", strerror(errno) );
      closeAllFiles();
   }
   globalPid = getpid();

   ufdbSetSignalHandler( SIGPIPE, SIG_IGN );
   ufdbSetSignalHandler( SIGUSR1, USR1signalReceived );
   ufdbSetSignalHandler( SIGHUP,  mySignalHandler );
   ufdbSetSignalHandler( SIGINT,  mySignalHandler );
   ufdbSetSignalHandler( SIGTERM, mySignalHandler );
   ufdbSetSignalHandler( SIGILL,  mySignalHandler );
   ufdbSetSignalHandler( SIGSEGV, mySignalHandler );
   
   writePidFile();
   atexit( removePidFile );
   ufdbLogError( "%s " VERSION " started", progname );
   ufdbLogMessage( "interface=%s  port=%d  images=%s", interface, portnumber, imagesDirectory );
   if (UFDBglobalUserName[0] != '\0' && UFDBglobalDebug)
      ufdbLogMessage( "will drop privileges user=%s", UFDBglobalUserName );
   ufdbSimulateHttpServer( interface, portnumber, UFDBglobalUserName, imagesDirectory, 0 );

   exit( 0 );
   return 0;  /* make compiler happy */
}

