/*
 * ufdblib.h - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005,2006,2007 by URLfilterDB with all rights reserved.
 * ufdbGuard is based on squidGuard.
 *
 * squidGuard is copyrighted (C) 1998 by
 * ElTele st AS, Oslo, Norway, with all rights reserved.
 *
 * RCS $Id: ufdblib.h,v 1.31 2007/11/20 16:35:03 root Exp root $
 */

#ifndef UFDB_UFDBLIB_H_INCLUDED
#define UFDB_UFDBLIB_H_INCLUDED

#include "ufdb.h"
#include <stdio.h>
#include <sys/times.h>


extern int    UFDBglobalDebug;
extern char   UFDBglobalUserName[31+1];
extern char * UFDBglobalLogDir;
extern int    UFDBglobalLogBlock;
extern int    UFDBglobalLogAllRequests;
extern int    UFDBglobalSafeSearch;
extern int    UFDBglobalHttpsWithHostname;
extern int    UFDBglobalHttpsOfficialCertificate;
extern int    UFDBglobalHttpdPort;
extern char   UFDBglobalHttpdInterface[256];
extern char   UFDBglobalHttpdImagesDirectory[256];
extern unsigned long UFDBglobalMaxLogfileSize;
volatile extern unsigned long UFDBglobalTunnelCounter;

extern FILE * globalErrorLog;

UFDBrevURL * UFDBgenRevURL( UFDBthreadAdmin * admin, unsigned char * URL );
void UFDBprintRevURL( UFDBrevURL * revURL );
void UFDBfreeRevURL( UFDBthreadAdmin * admin, UFDBrevURL * revURL );

void UFDBparseTableHeader( struct UFDBmemTable * memTable );
void UFDBparseTable( struct UFDBmemTable * memTable );
void UFDBfreeTableIndex( struct UFDBtable * t );

int UFDBlookup( UFDBthreadAdmin * admin, struct UFDBmemTable * mt, char * request );
int UFDBlookupRevUrl( struct UFDBtable * t, UFDBrevURL * revUrl );

void UFDBdropPrivileges( const char * username );

struct UFDBmemDB;	/* forward declaration */

struct UFDBmemDB
{
   char * key;
   char * value;
   int    length;
   struct UFDBmemDB * next;
};

struct UFDBmemDB * UFDBmemDBinit( void );
void UFDBmemDBinsert( struct UFDBmemDB * db, char * key, char * value, int length );
int UFDBmemDBfind( struct UFDBmemDB * db, char *  key, char ** value );
void UFDBmemDBdeleteDB( struct UFDBmemDB * db );

void UFDBappInit( void );
unsigned long UFDBappMemUsage( void );

void UFDBtimerInit( struct tms * t );
void UFDBtimerStop( struct tms * t );
void UFDBtimerPrint( struct tms * t, char * tag );
void UFDBtimerPrintString( char * line, struct tms * t, char * tag );
void UFDBlogTimer( struct tms * t, char * tag );

int UFDBloadDatabase( 
   struct UFDBmemTable * mtable, 
   char *                file    );

int UFDBloadExpressions( 
   struct ufdbRegExp ** exprList,
   char *               file     );

void ufdbFreeRegExprList( struct ufdbRegExp * re );

int  UFDBregcomp( regex_t * preg, const char * regex, int cflags );
void UFDBregfree( regex_t * preg );
int  UFDBregexec( const regex_t * preg, const char * string, size_t nmatch, regmatch_t pmatch[], int eflags );

int  ufdbSetCPU( char * CPUspec );
int  ufdbSetThreadCPUaffinity( int thread_num );
void ufdbResetCPUs( void );

#define URL_HIST_SIZE 60000

int    ufdbVerifyURLallCats( UFDBrevURL * revURL );
int    ufdbRegisterUnknownURL( char * webserver );
char * ufdbGetUnknownURLs( void );
void   ufdbResetUnknownURLs( void );

int UFDBopenSocket( char * serverName, int port );

void UFDBregisterCountedIP( const char * address );
void UFDBinitializeIPcounters( void );
unsigned long UFDBgetNumberOfRegisteredIPs( void );

struct ufdbSetting {
  char *           name;
  char *           value;
  struct ufdbSetting * next;
};

void   ufdbSetting( char *, char * );
struct ufdbSetting * ufdbSettingFindName( char * );
char * ufdbSettingGetValue( char * );

void   ufdbLogFile( int, int, char * );
void   ufdbGlobalSetLogging( int logging );
void   ufdbRotateLogfile( char * );
void   UFDBrotateLogfile( void );
void   ufdbLogMessage( char * format, ... );
void   ufdbLogError( char *, ... );
void   ufdbLogFatalError( char *, ... );
void   ufdbSetGlobalErrorLogFile( void );


#endif

