/*
 * ufdbpeek.c
 *
 * RCS: $Id$
 */

#include "ufdb.h"
#include "ufdbchkport.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include "sg.h"

char progname[80];
FILE * globalErrorLog = NULL;
int globalFatalError = 0;
int globalDebugTimeDelta = 0;
int sig_hup = 0;
int sig_other = 0;
int sig_alrm = 0;
pid_t globalPid;

extern int UFDBglobalDebug;


int main( int argc, char * argv[] )
{
   char * t;
   char * url;

   strcpy( progname, "ufdbpeek" );
   globalPid = getpid();
   ufdbSetGlobalErrorLogFile();
#if 1
   UFDBglobalDebug = 1;
#endif

   UFDBsetTunnelCheckMethod( UFDB_API_HTTPS_CHECK_AGRESSIVE );

   UFDBinitHTTPSchecker();
   url = argv[1];
   if (strncmp( url, "http://", 7 ) == 0)
      url += 7;
   if (strncmp( url, "https://", 8 ) == 0)
      url += 8;
   if ((t = strchr( url, '@' )) != NULL)
      *t = '\0';
   if ((t = strchr( url, ':' )) != NULL)
      *t = '\0';
   if ((t = strchr( url, '/' )) != NULL)
      *t = '\0';

   (void) UFDBcheckForHTTPStunnel( url, 443, UFDB_API_VERBOSE_OUTPUT );

   ufdbLogError( "" );

   if (globalErrorLog != NULL)
   {
      fflush( globalErrorLog );
      fclose( globalErrorLog );
   }

   return 0;
}


char * ufdbSettingGetValue( char * p )
{
   return NULL;
}
