/***************************************************************************
                                  CopyThread.h
                              -------------------
 
     Begin        : Fri Dec 21 2007 22:42 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the copyThread
 
****************************************************************************/

#include <QObject>
#include <QThread>
#include <QFile>
#include <QDir>
#include <QWaitCondition>
#include <QMutex>
#include <QTimer>
#include <QTime>
#include <QCryptographicHash>
#include <QByteArray>
#include <QMutexLocker>

#include "env.h"
#include "structDef.h"

#ifdef ULTRACOPIER_MODE_KDE4
#include <kdirlister.h>
#include <KUrl>
#endif

#ifndef COPY_THREAD_H
#define COPY_THREAD_H

#include "WriteThread.h"
class WriteThread;
class Main_window;

/** \brief Thread for do the copy.

This thread do the copy, it store the permanently options, and use shared memory for get and set the variable, and use signal/slot for the events.
*/
class copyThread : public QThread
{
	Q_OBJECT
public slots:
	//add one entry to source dir list
	void addEntryToDirList(const QDir& theDir);
	//add one entry to empty dir destination list
	void addEntryToEmptyDestinationDirList(const QDir& theDir);

	//set the copy info and options before runing
	void setRightCopy(const int doRightCopy);
	//set keep date
	void setKeepDate(const int);
	//set the current max speed in KB/s
	void setMaxSpeed(int tempMaxSpeed);
	//set if in copy or move mode
	void setMovingMode(const bool setMove);
	//set block size
	bool setBlockSize(const int block=64);
	//set prealoc file size
	void setPreallocateFileSize(const bool prealloc);

	//add item to list
	void addToList(quint64 id,const QFileInfo& source,qint64 size,const QFileInfo& destination);
	//pause the copy
	void pauseCopy();
	//resume the copy
	void resumeCopy();
	//stop the current copy
	void stopTheCopy();
	//skip the current file
	void skipCurrentFile();

	//return the progression percent
	int getProgressionPercent(const int max=100);
	//return the progression percent
	int getProgressionPercentTotal(const int max=100);
	//get copy speed in byte per second
	QString getCopySpeed();
	//set thread write
	void setThreadWrite(int useWriteThread);
	//insert at end without count
	void insterAtEndWithoutCount(copyItemInternal theItem);
public:
	enum currentStat {
			Stopped,
			Paused,
			Running
	}; ///< Enumeration for have copy state
	//the contructor
	copyThread(Main_window * parent);
	//the desytructor
	~copyThread();
	/// \brief set action on file exist
	void fileExistsAction(int action);
	/// \brief set action on error
	void errorAction(int action);
	/// \brief get current file copied as String as Name and
	QString getCurrentFileCopied();
	/// \brief return text overall
	QString getTextOverall();
	/// \brief return text overall
	QString getSyntetizedStringTo();
	/// \brief return string to
	QString getSyntetizedStringFrom();
	/// \brief lenght string from
	int lenghtOfCopyList();
	/// \brief number of item removed
	int getNumberOfItemRemoved();
	/// \brief return the statut
	currentStat getCurrentStat();
	/// \brief Return string for the
	static QString intToQtringSize(double nb);
	//remove one entry
	void removeItems(QList<int> ids);
	//put on top
	returnIdsTransaction putOnTop(QList<int> ids);
	//move up
	returnIdsTransaction moveUp(QList<int> ids);
	//move down
	returnIdsTransaction moveDown(QList<int> ids);
	//put on bottom
	returnIdsTransaction putOnBottom(QList<int> ids);
	//remaining time
	QString remainingTime();
	#if (DEBUG_ULTRACOPIER>0)
	QStringList DebugReturnCopyThreadStat();
	enum currentWait {
			NoWait,
			WaitInRead,
			WaitInWrite,
			WaitInThread
	};
	QString WaitInWhat();
	#endif
	bool allThreadIsFinish();
	//put at end after error occured
	QList<copyItemInternal> putAtEndAfterError();
signals:
	/// \brief error on file or folder, bouton enable, file path, error message
	void errorOnFile(int,QString,QString,quint64);
	/// \brief signal emited when file is same
	void fileIsSame(QString);
	/// \brief signal emited when file exists, Source, Destination
	void fileIsExists(QString,QString);
	/// \brief query new write thread
	void queryNewWriteThread();
	/// \brief all write thread is finish
	void allThreadIsFinishNow();
	/// \brief for restart write after it have been closed
	void queryStartThread(int);
	/// \brief wait in pause
	void isInPauseOrNot();
protected:
	void run();
	void stop();
private:
	#if (DEBUG_ULTRACOPIER>0)
	currentWait theCurrentWait;
	#endif
	// Remove all the empty source folder
	void removeAllFolderEmpty(const QDir& TheDir);
	//try open file in special mode
        bool tryOpenFileInSpecialMode(QFile *theFile,QIODevice::OpenMode theModeShouldBeUsed);
	//remove source folder and create destination folder
	void flush();
	//return the right string precision
	static QString adaptStr(float nb);
	//check if need wait write thread
	void checkIfNeedWaitWriteThread();
	//check if need wait one write thread
	void checkIfNeedWaitOneWriteThread(WriteThread*);
	//wait because need action
	void waitNeedAction();
	/// \brief error on file or folder, bouton enable, file path, error message, and wait
	int errorOnFileAndWait(int,QString,QString,quint64);
	
	volatile bool	stopped;
	volatile bool	waitInPause;		///< Wait in pause the thread
	volatile bool	stopIt;			///< For store the stop query
	QString		errorMessageInCopy;	///< The message error
	qint64		totalCopiedSize;	///< The copied, read or manipuled size
	qint64		previousSizeReturned;	///< Previous size returned
	qint64		firstScanTot;		///< Store total size at first scan
	qint64		firstScanCur;		///< Store curent size at first scan
	volatile int	maxSpeed;		///< The max speed in MB/s, 0 for no limit
	volatile bool	RightCopy;		///< Do rights copy
	volatile bool	movingMode;		///< Set if is in moving mode
	volatile bool	preallocation;		///< Flag for know if need preallocation
	volatile bool	keepDate;		///< For keep date file
	volatile bool	useWriteThread;		///< For set if need write thread
	QTime		intervalCopySpeed;	///< For detect the interval beteew 2 copy speed mesurement
	volatile int	actionAfterUnlock;	///< For action after unlock the mutex
	QList<QDir>	sourceDirList;		///< List of source dir for delete it in moving mode
	QList<QDir>	emptyDestDir;		///< List of empty destination should be created
	QTimer		clockForTheCopySpeed;	///< For the speed throttling
	QSemaphore	waitNewWriteThread;	///< For wiat the new write thread
	volatile int	MultForBigSpeed;	///< Multiple for count the number of block needed
	volatile int	numberOfBlockCopied;	///< Multiple for count the number of block copied
	volatile int	blockSizeCurrent;	///< The current size of the buffer
	currentStat	theCurrentStat;		///< The current stat
	QFile		sourceFile;		///< For have global copie progression
	QFile		destinationFile;	///< For have global copie progression
	QMutex		MultiThreadCopyList;	///< For be thread safe while operate on copy list
	QMutex		MultiThread_ThreadList;	///< For be thread safe while operate on copy list
	//at remove:
	int		numberOfItemRemoved;	///< For unmber of item removed
	int		NumberOfFileTot;	///< For number of file to copy
	int		NumberOfFileCopied;	///< For number of file to copied
	QString		syntetizedStringCurrentFile;///< For store sytetized string for current file
	QString		syntetizedStringOverall;///< For store sytetized string for overall
	QString		syntetizedStringTo;	///< For store sytetized string for To:
	QString		syntetizedStringFrom;	///< For store sytetized string for From:
	bool		copyHadBegin;		///< Store if copy had begin
	bool		skipThecurrentFile;	///< Skip the current file
	Main_window	*parent;		///< Store the parrent
	bool		needRemoveFileToList;
	qint64		currentFileSize;
	qint64		currentFileTotPos;

	QString		translationOfCopyOf;			///< Store the "copy of " translated
	QString		translationErrorResize;			///< Store the translation of error in resizing
	QString		translationErrorWriting;		///< Store the translation of error in writing
	QString		translationErrorDate;			///< Store the translation of error in date
	QString		translationErrorRemove;			///< Store the translation of error in removing
	QString		translationErrorSourceReadWrite;	///< Store the translation of error in open source in read write
	QString		translationErrorSourceRead;		///< Store the translation of error in open source in read
	QString		translationErrorDestinationWrite;	///< Store the translation of error in open destination in write
	QString		translationErrorPermissions;		///< Store the translation of error in permissions
	QString		translationErrorReadSource;		///< Store the translation of error in read source
	QString		translationDay;
	QString		translationDays;
	QString		translationHour;
	QString		translationHours;
	QString		translationMinute;
	QString		translationMinutes;
	QString		translationSecond;
	QString		translationSeconds;

	// for copy list
	int		timeCopyElapsed;	///< Time copy elapsed
	QList<copyItemInternal> theCopyList;
	QList<WriteThread*>	theWriteThreadList;///< For store the write thread list
	QList<copyItemInternal> putAtEnd;
	QSemaphore	waitNewClockForSpeed;
	QSemaphore	waitAction;
	QSemaphore	*writeThreadSem;
	QTime		tempTimeElapsed;
	WriteThread	*theCurrentThread;

private slots:
	/// \brief the time allocated for copy this block is finish
	void timeOfTheBlockCopyFinished();
	/// \brief do the operation before start the copy thread
	void pre_operation();
	/// \brief do the operation after stop the copy thread
	void post_operation();
	/// \brief create new  write thread object
	void createNewWriteThread();
	/// \brief write thread have finish
	void newWriteThreadFinish();
	/// \brief call when the write thread have end their task
	void writeThreadOperationFinish();
	/// \brief call when the file should be put at the end
	void putFirstFileAtEnd();
	/// \brief for restart write thread which have been stop
	void startWriteThread(int id);
};

#endif
