/***************************************************************************
                                  Ewindow.cpp
                              -------------------

     Begin        : Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the constructor and the methode of the error window

****************************************************************************/

#include <QtGui>

#include "Ewindow.h"
#include "env.h"

/** \brief Initiate the error window

Create the error window, setup too the action and menu
\param parent The parent of the window
*/
ErrorWindow::ErrorWindow(QWidget *parent)
    : QDialog(parent)
{
	//setup the interface
	setupUi(this);
	layout()->setSizeConstraint(QLayout::SetFixedSize);
	
	//setup the menu
	menuEndOf	= new QMenu("endof", this);
	alwaysEndOf	= new QAction(tr("Always put at end of list"), this);
	menuEndOf->addAction(alwaysEndOf);
	toolButton_End->setMenu(menuEndOf);
	
	menuSkip	= new QMenu("skip", this);
	alwaysSkip	= new QAction(tr("Always skip"), this);
	menuSkip->addAction(alwaysSkip);
	toolButton_Skip->setMenu(menuSkip);
	
	//connect the action
	connect(toolButton_Retry,	SIGNAL(clicked()), this, SLOT(retryAction()));
	connect(toolButton_End,		SIGNAL(clicked()), this, SLOT(enfOfAction()));
	connect(toolButton_Skip,	SIGNAL(clicked()), this, SLOT(skipAction()));
	connect(toolButton_Cancel,	SIGNAL(clicked()), this, SLOT(cancelAction()));
	
	connect(alwaysSkip,		SIGNAL(triggered()), this, SLOT(allwaysSkipAction()));
	connect(alwaysEndOf,		SIGNAL(triggered()), this, SLOT(allwaysEnfOfAction()));
	
	//update the style
	this->UpdateStyle();
}

/** \brief Set the subject of the error
\param fileOrDir Set on which file or folder the error at occured
*/
void ErrorWindow::file(const QString& fileOrDir)
{
	if(fileOrDir.endsWith("/"))
		label_fileName->setText(tr("Error on the folder")+":\n"+fileOrDir+"\n"+tr("was interrupted for the following reason:"));
	else
		label_fileName->setText(tr("Error on the file")+":\n"+fileOrDir+"\n"+tr("was interrupted for the following reason:"));
}

/** \brief Set the error text
\param errorText The error text
*/
void ErrorWindow::error(const QString& errorText)
{
	ErrorMessage->setText(errorText);
}

void ErrorWindow::retryAction()
{
	emit ActionClicked(UC_ERROR_RETRY);
	this->close();
}

void ErrorWindow::cancelAction()
{
	emit ActionClicked(UC_ERROR_CANCEL);
	this->close();
}

void ErrorWindow::allwaysSkipAction()
{
	emit ActionClicked(UC_ERROR_SKIP_ALL);
	this->close();
}

void ErrorWindow::skipAction()
{
	emit ActionClicked(UC_ERROR_SKIP);
	this->close();
}

void ErrorWindow::enfOfAction()
{
	emit ActionClicked(UC_ERROR_ENDOFLIST);
	this->close();
}

void ErrorWindow::allwaysEnfOfAction()
{
	emit ActionClicked(UC_ERROR_ENDOFLIST_ALL);
	this->close();
}

/** \brief Disable the specified button
\param ButtonActivated The action code
\see env.h
*/
void ErrorWindow::setButtonActivated(int ButtonActivated)
{
	switch(ButtonActivated)
	{
		case ERROR_DEF_ALL:
		break;
		case ERROR_DEF_NOSKIPNOENDOF:
			toolButton_Skip->setEnabled(false);
		case ERROR_DEF_NOENDOF:
			toolButton_End->setEnabled(false);
		break;
		default:
			DEBUGCONSOLE(10,"ErrorWindow::setButtonActivated","sould not be "+QString::number(ButtonActivated)+"!");
		break;
	}
}

/// \brief Update the style
void ErrorWindow::UpdateStyle()
{
	//update style here
	bigIcon->setPixmap(loadImagePixmap("big/error.png"));
	toolButton_Retry->setIcon(loadImage("reload.png"));
	toolButton_End->setIcon(loadImage("2downarrow.png"));
	toolButton_Skip->setIcon(loadImage("player_end.png"));
	toolButton_Cancel->setIcon(loadImage("cancel.png"));
	this->setWindowIcon(loadImage("error.png"));
}

/// \brief The destructor
ErrorWindow::~ErrorWindow()
{
	delete menuEndOf;
	delete alwaysEndOf;
	delete menuSkip;
	delete alwaysSkip;
}
