/***************************************************************************
                                   Ewindow.h
                              -------------------
 
     Begin        : Sat Oct 20 2007 20:20 alpha_one_x86
     Project      : Ultracopier
     Email        : ultracopier@first-world.info
     Note         : See README for copyright and developer
     Target       : Define the class of the error window
 
****************************************************************************/

#ifndef INCLUDE_EWINDOW_H
#define INCLUDE_EWINDOW_H

#include <QDialog>

#include "ui_copyError.h"

/** \brief The error window

This window show what error is append, and ask what to do.
*/
class ErrorWindow : public QDialog, public Ui::Ewindow
{
	Q_OBJECT
public:
	ErrorWindow(QWidget *parent);
	~ErrorWindow();
	//set the subject of the error
	void file(const QString& fileOrDir);
	//set the error text
	void error(const QString& errorText);
	//disable the specified button
	void setButtonActivated(int ButtonActivated);
private:
	QMenu	*menuEndOf;	///< Menu on the "end of" button
	QAction *alwaysEndOf;	///< Action on the "end of" button
	QMenu	*menuSkip;	///< Menu on the skip button
	QAction *alwaysSkip;	///< Action on the skip button
	QWidget *parent;	///< The parrent of the window
private slots:
	void retryAction();
	void cancelAction();
	void skipAction();
	void allwaysSkipAction();
	void enfOfAction();
	void allwaysEnfOfAction();
signals:
	//send the query action
	void ActionClicked(int action);
public slots:
	//for update style
	void UpdateStyle();
};

#endif
