include(CheckLibraryExists)
include(CheckFunctionExists)

function(SelectRTBackend)
  check_library_exists(rt clock_gettime "time.h" HAVE_CLOCK_GETTIME_RT)

  if(NOT HAVE_CLOCK_GETTIME_RT)
    check_function_exists(clock_gettime HAVE_CLOCK_GETTIME)
    if(NOT HAVE_CLOCK_GETTIME)
      check_library_exists(c clock_get_time "mach/time.h" HAVE_CLOCK_GET_TIME)
      if(NOT HAVE_CLOCK_GET_TIME)
        message(FATAL_ERROR "Didn't find clock_gettime() or clock_get_time()!")
      endif()
    endif()
  else()
    set(LIBRT rt PARENT_SCOPE)
  endif()
endfunction()
