// Copyright 2013 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Flags: --track-fields --track-double-fields --allow-natives-syntax
// Flags: --parallel-recompilation --parallel-recompilation-delay=50

if (!%IsParallelRecompilationSupported()) {
  print("Parallel recompilation is disabled. Skipping this test.");
  quit();
}

function assertUnoptimized(fun) {
  assertTrue(%GetOptimizationStatus(fun) != 1);
}

function new_object() {
  var o = {};
  o.a = 1;
  o.b = 2;
  return o;
}

function add_field(obj) {
  obj.c = 3;
}

add_field(new_object());
add_field(new_object());
%OptimizeFunctionOnNextCall(add_field, "parallel");

var o = new_object();
add_field(o);                      // Trigger optimization.
assertUnoptimized(add_field);      // Not yet optimized.
o.c = 2.2;                         // Invalidate transition map.
%CompleteOptimization(add_field);  // Conclude optimization with...
assertUnoptimized(add_field);      // ... bailing out due to map dependency.

