// Copyright 2008 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Flags: --gc-greedy --noverify-heap

function IterativeFib(n) {
  var f0 = 0, f1 = 1;
  for (; n > 0; --n) {
    var f2 = f0 + f1;
    f0 = f1; f1 = f2;
  }
  return f0;
}

function RecursiveFib(n) {
  if (n <= 1) return n;
  return RecursiveFib(n - 1) + RecursiveFib(n - 2);
}

function Check(n, expected) {
  var i = IterativeFib(n);
  var r = RecursiveFib(n);
  assertEquals(i, expected);
  assertEquals(r, expected);
}

Check(0, 0);
Check(1, 1);
Check(2, 1);
Check(3, 1 + 1);
Check(4, 2 + 1);
Check(5, 3 + 2);
Check(10, 55);
Check(15, 610);
Check(20, 6765);
assertEquals(IterativeFib(75), 2111485077978050);
