.\" -*-nroff-*-
.\"
.\"
.\"     Copyright (C) 1996-2000 Michael R. Elkins <me@cs.hmc.edu>
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
.\"
.TH vacation 1 "March 2000" Unix "User Manuals"
.UC 1
.SH NAME
vacation \- reply to mail automatically
.PP
.SH SYNOPSIS
.B vacation
[
.B \-I | \-i
]
.br
.B vacation
[
.B \-j
]
[
.BI \-a " alias"
]
[
.BI \-t N
]
[
.B \-r
]
[
.B \-?
]
.I username
.SH DESCRIPTION
.IX vacation "" "\fLvacation\fR \(em automatic mail replies"
.LP
.B vacation
automatically replies to incoming mail.  The reply is
contained in the file
.BR .vacation.msg
in your home directory.  
.\"(or the file
.\".B /usr/lib/vacation.def
.\"by default).
The
.B vacation
program run interactively will create and/or edit a 
.BR .vacation.msg
file in your home directory. The old
.BR .vacation.msg
will be backed up to
.BR .vacation.old
file.
Type 
.B
vacation
with no arguments.  (See
.B
USAGE 
below.)
.LP
For example, the message created by
.B
vacation
is:
.RS
.sp .5
.nf
.ft B
Subject: away from my mail
From:  smith (via the vacation program)
I will not be reading my mail for a while. Your 
mail regarding "$\s-1SUBJECT\s0" will be 
read when I return.
.ft R
.fi
.RE
.LP
The
.BR .vacation.msg
file should include a header with at least a
.RB ` Subject: '
line (it should not contain a
.RB ` To: '
line and need not contain a
.RB ` From: '
line, since these are generated automatically).
.LP
The fields 
.RB ` From ',
.RB ` From: '
and 
.RB ` Reply-To: '
are evaluated in the following order: If there is a
.RB ` Reply-To: ',
and the option 
.B \-r
is given, then its entry is accepted. Otherwise, the entry of the 
.RB ` From: ' 
field is taken. Should this entry lack a complete domain
address (e.g. user@site instead of user@site.domain), 
.B vacation 
evaluates the 
.RB ` From '
field, converting the contained UUCP bang path into a domain style
address. If this fails too, 
.B vacation
gives up.
.LP
If the string
.SB $SUBJECT
appears in the
.B \&.vacation.msg
file, it is replaced with the subject of the original message when the
reply is sent.  
.LP
No message is sent if the
.RB ` To: '
or the
.RB ` Cc: '
line does not list the user to whom the original message was sent or
one of a number of aliases for them,
if the initial
.B From
line includes one of the strings
.BR \-\s-1request\s0@ , 
.BR postmaster , 
.BR uucp , 
.BR mailer-daemon ,
.BR mailer 
or
.BR -relay
or if a
.RB ` "Precedence: bulk" '
or
.RB ` "Precedence: junk" '
or
.RB ` "Precedence: list" '
line is included in the header. The search for special 
senders is made case-independant.
.SH OPTIONS
.TP
.B \-I
Initialize the
.B \&.vacation.db
file and start
.BR vacation .
.LP
If the
.B \-I
flag is not specified, and a
.I user
argument is given,
.B vacation
reads the first line from the standard input
(for a
.RB ` From: '
line, no colon).
If absent, it produces an error message.  The following options may be
specified:
.TP
.BI \-a " alias"
Indicate that
.I alias
is one of the valid aliases for the user running
.BR vacation ,
so that mail addressed to that alias generates a reply.
.TP
.B \-j
Do not check whether the recipient appears in the
.RB ` To: '
or the
.RB ` Cc: '
line. Reply always.
.TP
.BI \-t N
Change the interval between repeat replies to the same sender.
.B N
is the number of days between replies. Default is one week.
.TP
.BI \-r
If there is a 
.RB ` Reply-To: '
header, send the automatic reply to the address given there.
Otherwise, use the 
.RB ` From: '
entry.
.TP
.BI \-?
issue short usage line.
.SH USAGE
.LP
The
.BR vacation ,
create a
.B \&.forward
file in your home directory containing a line of the form:
.IP
\fB\e\fIusername\fB, "|/usr/bin/vacation \fIusername\fB"\fR
.LP
where
.I username
is your login name. The original
.B \&.forward
will be backed up to
.B \&.forward.old
file.

.LP
Then type in the command:
.IP
.B vacation \-I
.LP
To stop
.BR vacation ,
remove the
.B \&.forward
file, or move it to a new name.
.br
.ne 6
.LP
If
.B vacation
is run with no arguments, it will create a new
.B \&.vacation.msg
file for you, using the editor specified by the
.SB VISUAL
or
.SB EDITOR
environment variable, or
.BR vi (1)
if neither of those environment variables are set.  If a
.B \&.forward
file is not present in your home directory, it creates
it for you, and automatically performs a
.RB ` "vacation \-I" '
function, turning on
.BR vacation .
.SH FILES
.PD 0
.TP 20
.B $\s-1HOME\s0/.forward
.\".TP
.\".B /usr/lib/vacation.def
.TP
.B $\s-1HOME\s0/.vacation.msg
.PD
.LP
A list of senders is kept in the file
.B \&.vacation.db
in your home directory.
.SH SEE ALSO
.BR vi (1),
.BR sendmail (8)
.SH AUTHOR
.I vacation
is Copyright (c) 1983 by Eric P. Allman, University of
Berkeley, California, and Copyright (c) 1993 by Harald Milz
(hm@seneca.ix.de). Tiny patches 1998 by Mark Seuffert (moak@pirate.de).
Now maintained by Sean Rima (thecivvie@softhome.net)
