/* valareport.c generated by valac, the Vala compiler
 * generated from valareport.vala, do not modify */

/* valareport.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define VALA_TYPE_REPORT (vala_report_get_type ())
#define VALA_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REPORT, ValaReport))
#define VALA_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REPORT, ValaReportClass))
#define VALA_IS_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REPORT))
#define VALA_IS_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REPORT))
#define VALA_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REPORT, ValaReportClass))

typedef struct _ValaReport ValaReport;
typedef struct _ValaReportClass ValaReportClass;
typedef struct _ValaReportPrivate ValaReportPrivate;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaReport {
	GObject parent_instance;
	ValaReportPrivate * priv;
};

struct _ValaReportClass {
	GObjectClass parent_class;
	void (*note) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*depr) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*warn) (ValaReport* self, ValaSourceReference* source, const gchar* message);
	void (*err) (ValaReport* self, ValaSourceReference* source, const gchar* message);
};

struct _ValaReportPrivate {
	gint warnings;
	gint errors;
	gboolean verbose_errors;
	gboolean _enable_warnings;
};


static gpointer vala_report_parent_class = NULL;

GType vala_report_get_type (void) G_GNUC_CONST;
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
#define VALA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REPORT, ValaReportPrivate))
enum  {
	VALA_REPORT_DUMMY_PROPERTY,
	VALA_REPORT_ENABLE_WARNINGS
};
void vala_report_set_verbose_errors (ValaReport* self, gboolean verbose);
gint vala_report_get_warnings (ValaReport* self);
gint vala_report_get_errors (ValaReport* self);
static void vala_report_report_source (ValaSourceReference* source);
gint vala_source_reference_get_first_line (ValaSourceReference* self);
gint vala_source_reference_get_last_line (ValaSourceReference* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
gchar* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno);
gint vala_source_reference_get_first_column (ValaSourceReference* self);
gint vala_source_reference_get_last_column (ValaSourceReference* self);
void vala_report_note (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_note (ValaReport* self, ValaSourceReference* source, const gchar* message);
gboolean vala_report_get_enable_warnings (ValaReport* self);
gchar* vala_source_reference_to_string (ValaSourceReference* self);
void vala_report_depr (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_depr (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_warn (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_warn (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_err (ValaReport* self, ValaSourceReference* source, const gchar* message);
static void vala_report_real_err (ValaReport* self, ValaSourceReference* source, const gchar* message);
void vala_report_notice (ValaSourceReference* source, const gchar* message);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
ValaCodeContext* vala_code_context_get (void);
ValaReport* vala_code_context_get_report (ValaCodeContext* self);
void vala_report_deprecated (ValaSourceReference* source, const gchar* message);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_report_error (ValaSourceReference* source, const gchar* message);
ValaReport* vala_report_new (void);
ValaReport* vala_report_construct (GType object_type);
void vala_report_set_enable_warnings (ValaReport* self, gboolean value);
static void vala_report_finalize (GObject* obj);
static void _vala_vala_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_vala_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
 * Set the error verbosity.
 */
void vala_report_set_verbose_errors (ValaReport* self, gboolean verbose) {
	g_return_if_fail (self != NULL);
	self->priv->verbose_errors = verbose;
}


/**
 * Returns the total number of warnings reported.
 */
gint vala_report_get_warnings (ValaReport* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->warnings;
	return result;
}


/**
 * Returns the total number of errors reported.
 */
gint vala_report_get_errors (ValaReport* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->errors;
	return result;
}


/**
 * Pretty-print the actual line of offending code if possible.
 */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static void vala_report_report_source (ValaSourceReference* source) {
	gint _tmp0_;
	gint _tmp1_;
	ValaSourceFile* _tmp2_ = NULL;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* offending_line;
	g_return_if_fail (source != NULL);
	_tmp0_ = vala_source_reference_get_first_line (source);
	_tmp1_ = vala_source_reference_get_last_line (source);
	if (_tmp0_ != _tmp1_) {
		return;
	}
	_tmp2_ = vala_source_reference_get_file (source);
	_tmp3_ = vala_source_reference_get_first_line (source);
	_tmp4_ = vala_source_file_get_source_line (_tmp2_, _tmp3_);
	offending_line = _tmp4_;
	if (offending_line != NULL) {
		gint idx = 0;
		fprintf (stderr, "%s\n", offending_line);
		{
			gboolean _tmp5_;
			idx = 1;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gchar _tmp7_;
				if (!_tmp5_) {
					idx = idx + 1;
				}
				_tmp5_ = FALSE;
				_tmp6_ = vala_source_reference_get_first_column (source);
				if (!(idx < _tmp6_)) {
					break;
				}
				_tmp7_ = string_get (offending_line, (glong) (idx - 1));
				if (_tmp7_ == '\t') {
					fprintf (stderr, "\t");
				} else {
					fprintf (stderr, " ");
				}
			}
		}
		{
			gint _tmp8_;
			gboolean _tmp9_;
			_tmp8_ = vala_source_reference_get_first_column (source);
			idx = _tmp8_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gchar _tmp11_;
				if (!_tmp9_) {
					idx = idx + 1;
				}
				_tmp9_ = FALSE;
				_tmp10_ = vala_source_reference_get_last_column (source);
				if (!(idx <= _tmp10_)) {
					break;
				}
				_tmp11_ = string_get (offending_line, (glong) (idx - 1));
				if (_tmp11_ == '\t') {
					fprintf (stderr, "\t");
				} else {
					fprintf (stderr, "^");
				}
			}
		}
		fprintf (stderr, "\n");
	}
	_g_free0 (offending_line);
}


/**
 * Reports the specified message as note.
 *
 * @param source  reference to source code
 * @param message note message
 */
static void vala_report_real_note (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	if (!self->priv->_enable_warnings) {
		return;
	}
	if (source == NULL) {
		fprintf (stderr, "note: %s\n", message);
	} else {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_source_reference_to_string (source);
		_tmp1_ = _tmp0_;
		fprintf (stderr, "%s: note: %s\n", _tmp1_, message);
		_g_free0 (_tmp1_);
		if (self->priv->verbose_errors) {
			vala_report_report_source (source);
		}
	}
}


void vala_report_note (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	VALA_REPORT_GET_CLASS (self)->note (self, source, message);
}


/**
 * Reports the specified message as deprecation warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void vala_report_real_depr (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	if (!self->priv->_enable_warnings) {
		return;
	}
	self->priv->warnings++;
	if (source == NULL) {
		fprintf (stderr, "warning: %s\n", message);
	} else {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_source_reference_to_string (source);
		_tmp1_ = _tmp0_;
		fprintf (stderr, "%s: warning: %s\n", _tmp1_, message);
		_g_free0 (_tmp1_);
	}
}


void vala_report_depr (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	VALA_REPORT_GET_CLASS (self)->depr (self, source, message);
}


/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void vala_report_real_warn (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	if (!self->priv->_enable_warnings) {
		return;
	}
	self->priv->warnings++;
	if (source == NULL) {
		fprintf (stderr, "warning: %s\n", message);
	} else {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_source_reference_to_string (source);
		_tmp1_ = _tmp0_;
		fprintf (stderr, "%s: warning: %s\n", _tmp1_, message);
		_g_free0 (_tmp1_);
		if (self->priv->verbose_errors) {
			vala_report_report_source (source);
		}
	}
}


void vala_report_warn (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	VALA_REPORT_GET_CLASS (self)->warn (self, source, message);
}


/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
static void vala_report_real_err (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	self->priv->errors++;
	if (source == NULL) {
		fprintf (stderr, "error: %s\n", message);
	} else {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = vala_source_reference_to_string (source);
		_tmp1_ = _tmp0_;
		fprintf (stderr, "%s: error: %s\n", _tmp1_, message);
		_g_free0 (_tmp1_);
		if (self->priv->verbose_errors) {
			vala_report_report_source (source);
		}
	}
}


void vala_report_err (ValaReport* self, ValaSourceReference* source, const gchar* message) {
	VALA_REPORT_GET_CLASS (self)->err (self, source, message);
}


void vala_report_notice (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	vala_report_note (_tmp2_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_deprecated (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	vala_report_depr (_tmp2_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_warning (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	vala_report_warn (_tmp2_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void vala_report_error (ValaSourceReference* source, const gchar* message) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_ = NULL;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	vala_report_err (_tmp2_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


ValaReport* vala_report_construct (GType object_type) {
	ValaReport * self = NULL;
	self = (ValaReport*) g_object_new (object_type, NULL);
	return self;
}


ValaReport* vala_report_new (void) {
	return vala_report_construct (VALA_TYPE_REPORT);
}


gboolean vala_report_get_enable_warnings (ValaReport* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_warnings;
	return result;
}


void vala_report_set_enable_warnings (ValaReport* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enable_warnings = value;
	g_object_notify ((GObject *) self, "enable-warnings");
}


static void vala_report_class_init (ValaReportClass * klass) {
	vala_report_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaReportPrivate));
	VALA_REPORT_CLASS (klass)->note = vala_report_real_note;
	VALA_REPORT_CLASS (klass)->depr = vala_report_real_depr;
	VALA_REPORT_CLASS (klass)->warn = vala_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = vala_report_real_err;
	G_OBJECT_CLASS (klass)->get_property = _vala_vala_report_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_vala_report_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_report_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_REPORT_ENABLE_WARNINGS, g_param_spec_boolean ("enable-warnings", "enable-warnings", "enable-warnings", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_report_instance_init (ValaReport * self) {
	self->priv = VALA_REPORT_GET_PRIVATE (self);
	self->priv->_enable_warnings = TRUE;
}


static void vala_report_finalize (GObject* obj) {
	ValaReport * self;
	self = VALA_REPORT (obj);
	G_OBJECT_CLASS (vala_report_parent_class)->finalize (obj);
}


/**
 * Namespace to centralize reporting warnings and errors.
 */
GType vala_report_get_type (void) {
	static volatile gsize vala_report_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReport), 0, (GInstanceInitFunc) vala_report_instance_init, NULL };
		GType vala_report_type_id;
		vala_report_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaReport", &g_define_type_info, 0);
		g_once_init_leave (&vala_report_type_id__volatile, vala_report_type_id);
	}
	return vala_report_type_id__volatile;
}


static void _vala_vala_report_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaReport * self;
	self = VALA_REPORT (object);
	switch (property_id) {
		case VALA_REPORT_ENABLE_WARNINGS:
		g_value_set_boolean (value, vala_report_get_enable_warnings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_vala_report_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaReport * self;
	self = VALA_REPORT (object);
	switch (property_id) {
		case VALA_REPORT_ENABLE_WARNINGS:
		vala_report_set_enable_warnings (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



