/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[57] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_ = NULL;
	ValaReport* _tmp2_ = NULL;
	ValaReport* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	ValaReport* _tmp11_ = NULL;
	ValaReport* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_ = NULL;
		ValaReport* _tmp6_ = NULL;
		ValaReport* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_ = NULL;
			ValaReport* _tmp17_ = NULL;
			ValaReport* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_ = FALSE;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_ = NULL;
			ValaCodeContext* _tmp22_ = NULL;
			ValaReport* _tmp23_ = NULL;
			ValaReport* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_ = NULL;
			ValaCodeContext* _tmp28_ = NULL;
			ValaReport* _tmp29_ = NULL;
			ValaReport* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			ValaCodeContext* _tmp32_ = NULL;
			ValaReport* _tmp33_ = NULL;
			ValaReport* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaCodeContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	ValaCodeContext* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	ValaCodeContext* _tmp33_ = NULL;
	gboolean _tmp34_ = FALSE;
	ValaCodeContext* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	ValaCodeContext* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	ValaCodeContext* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaCodeContext* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	ValaCodeContext* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp45_ = NULL;
	ValaReport* _tmp46_ = NULL;
	ValaReport* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	ValaCodeContext* _tmp49_ = NULL;
	ValaReport* _tmp50_ = NULL;
	ValaReport* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	ValaCodeContext* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
	ValaCodeContext* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	ValaCodeContext* _tmp57_ = NULL;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaCodeContext* _tmp62_ = NULL;
	gboolean _tmp63_ = FALSE;
	ValaCodeContext* _tmp64_ = NULL;
	const gchar* _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_ = NULL;
	ValaCodeContext* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	ValaCodeContext* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	ValaCodeContext* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	ValaCodeContext* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	ValaCodeContext* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	gboolean _tmp79_ = FALSE;
	const gchar* _tmp80_ = NULL;
	const gchar* _tmp82_ = NULL;
	const gchar* _tmp90_ = NULL;
	ValaCodeContext* _tmp99_ = NULL;
	gchar** _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gchar** _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	ValaCodeContext* _tmp102_ = NULL;
	gboolean _tmp103_ = FALSE;
	ValaCodeContext* _tmp104_ = NULL;
	gchar** _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	gchar** _tmp106_ = NULL;
	gint _tmp106__length1 = 0;
	ValaCodeContext* _tmp107_ = NULL;
	gchar** _tmp108_ = NULL;
	gint _tmp108__length1 = 0;
	gchar** _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	ValaCodeContext* _tmp110_ = NULL;
	gboolean _tmp111_ = FALSE;
	ValaCodeContext* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	ValaCodeContext* _tmp114_ = NULL;
	gboolean _tmp115_ = FALSE;
	ValaCodeContext* _tmp116_ = NULL;
	gboolean _tmp117_ = FALSE;
	gboolean _tmp118_ = FALSE;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp121_ = FALSE;
	gboolean _tmp122_ = FALSE;
	const gchar* _tmp123_ = NULL;
	gboolean _tmp131_ = FALSE;
	const gchar* _tmp132_ = NULL;
	ValaCodeContext* _tmp133_ = NULL;
	gboolean _tmp134_ = FALSE;
	ValaCodeContext* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	ValaCodeContext* _tmp137_ = NULL;
	gboolean _tmp138_ = FALSE;
	gchar** _tmp139_ = NULL;
	gint _tmp139__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp151_ = FALSE;
	const gchar* _tmp152_ = NULL;
	ValaCodeContext* _tmp155_ = NULL;
	gint _tmp156_ = 0;
	ValaCodeContext* _tmp157_ = NULL;
	gint _tmp158_ = 0;
	ValaCodeContext* _tmp159_ = NULL;
	gint _tmp160_ = 0;
	gint _tmp161_ = 0;
	gboolean _tmp170_ = FALSE;
	gchar** _tmp173_ = NULL;
	gint _tmp173__length1 = 0;
	gchar** _tmp178_ = NULL;
	gint _tmp178__length1 = 0;
	ValaCodeContext* _tmp189_ = NULL;
	gchar** _tmp190_ = NULL;
	gint _tmp190__length1 = 0;
	gchar** _tmp191_ = NULL;
	gint _tmp191__length1 = 0;
	ValaCodeContext* _tmp192_ = NULL;
	gchar** _tmp193_ = NULL;
	gint _tmp193__length1 = 0;
	gchar** _tmp194_ = NULL;
	gint _tmp194__length1 = 0;
	gboolean _tmp195_ = FALSE;
	ValaCodeContext* _tmp196_ = NULL;
	ValaReport* _tmp197_ = NULL;
	ValaReport* _tmp198_ = NULL;
	gint _tmp199_ = 0;
	ValaCodeContext* _tmp207_ = NULL;
	ValaGDBusServerModule* _tmp208_ = NULL;
	ValaGDBusServerModule* _tmp209_ = NULL;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp210_ = NULL;
	gint _tmp210__length1 = 0;
	gboolean _tmp220_ = FALSE;
	gboolean _tmp221_ = FALSE;
	gboolean _tmp225_ = FALSE;
	ValaCodeContext* _tmp226_ = NULL;
	ValaReport* _tmp227_ = NULL;
	ValaReport* _tmp228_ = NULL;
	gint _tmp229_ = 0;
	ValaParser* parser = NULL;
	ValaParser* _tmp237_ = NULL;
	ValaParser* _tmp238_ = NULL;
	ValaCodeContext* _tmp239_ = NULL;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp240_ = NULL;
	ValaGenieParser* _tmp241_ = NULL;
	ValaCodeContext* _tmp242_ = NULL;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp243_ = NULL;
	ValaGirParser* _tmp244_ = NULL;
	ValaCodeContext* _tmp245_ = NULL;
	gboolean _tmp246_ = FALSE;
	ValaCodeContext* _tmp247_ = NULL;
	ValaReport* _tmp248_ = NULL;
	ValaReport* _tmp249_ = NULL;
	gint _tmp250_ = 0;
	const gchar* _tmp258_ = NULL;
	ValaCodeContext* _tmp264_ = NULL;
	gboolean _tmp265_ = FALSE;
	ValaCodeContext* _tmp266_ = NULL;
	ValaReport* _tmp267_ = NULL;
	ValaReport* _tmp268_ = NULL;
	gint _tmp269_ = 0;
	gboolean _tmp277_ = FALSE;
	gboolean _tmp278_ = FALSE;
	gboolean _tmp279_ = FALSE;
	const gchar* _tmp287_ = NULL;
	gboolean _tmp292_ = FALSE;
	ValaCodeContext* _tmp293_ = NULL;
	ValaReport* _tmp294_ = NULL;
	ValaReport* _tmp295_ = NULL;
	gint _tmp296_ = 0;
	ValaCodeContext* _tmp304_ = NULL;
	ValaCodeGenerator* _tmp305_ = NULL;
	ValaCodeGenerator* _tmp306_ = NULL;
	ValaCodeContext* _tmp307_ = NULL;
	gboolean _tmp308_ = FALSE;
	ValaCodeContext* _tmp309_ = NULL;
	ValaReport* _tmp310_ = NULL;
	ValaReport* _tmp311_ = NULL;
	gint _tmp312_ = 0;
	gboolean _tmp320_ = FALSE;
	const gchar* _tmp321_ = NULL;
	const gchar* _tmp325_ = NULL;
	const gchar* _tmp378_ = NULL;
	const gchar* _tmp392_ = NULL;
	const gchar* _tmp415_ = NULL;
	gboolean _tmp418_ = FALSE;
	ValaCodeContext* _tmp419_ = NULL;
	ValaReport* _tmp420_ = NULL;
	ValaReport* _tmp421_ = NULL;
	gint _tmp422_ = 0;
	gboolean _tmp430_ = FALSE;
	gint _tmp454_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_ = NULL;
			ValaReport* _tmp6_ = NULL;
			ValaReport* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			vala_report_set_colors (_tmp7_, _tmp8_);
		} else {
			ValaCodeContext* _tmp9_ = NULL;
			ValaReport* _tmp10_ = NULL;
			ValaReport* _tmp11_ = NULL;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_set_colors (_tmp11_, VALA_COMPILER_DEFAULT_COLORS);
		}
	}
	_tmp14_ = vala_compiler_ccode_only;
	if (!_tmp14_) {
		gboolean _tmp15_ = FALSE;
		_tmp15_ = vala_compiler_compile_only;
		_tmp13_ = !_tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = vala_compiler_output;
		_tmp12_ = _tmp16_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		_tmp19_ = string_last_index_of_char (_tmp18_, (gunichar) '.', 0);
		if (_tmp19_ != -1) {
			gint dot = 0;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp20_ = vala_compiler_sources;
			_tmp20__length1 = _vala_array_length (vala_compiler_sources);
			_tmp21_ = _tmp20_[0];
			_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
			dot = _tmp22_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = dot;
			_tmp26_ = string_substring (_tmp24_, (glong) 0, (glong) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_path_get_basename (_tmp27_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp28_;
			_g_free0 (_tmp27_);
		}
	}
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp29_, !_tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp37_, _tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_code_context_get_report (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp47_, !_tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp51_, !_tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp55_, !_tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp57_, _tmp58_);
	_tmp60_ = vala_compiler_ccode_only;
	if (_tmp60_) {
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		_tmp61_ = vala_compiler_cc_options;
		_tmp61__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp59_ = _tmp61_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp62_, _tmp63_);
	_tmp64_ = self->priv->context;
	_tmp65_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp64_, _tmp65_);
	_tmp67_ = vala_compiler_header_filename;
	if (_tmp67_ == NULL) {
		gboolean _tmp68_ = FALSE;
		_tmp68_ = vala_compiler_use_header;
		_tmp66_ = _tmp68_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp69_ = self->priv->context;
	_tmp70_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp69_, _tmp70_);
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->context;
	_tmp76_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp75_, _tmp76_);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_output;
	vala_code_context_set_output (_tmp77_, _tmp78_);
	_tmp80_ = vala_compiler_output;
	if (_tmp80_ != NULL) {
		gboolean _tmp81_ = FALSE;
		_tmp81_ = vala_compiler_ccode_only;
		_tmp79_ = _tmp81_;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp82_ = vala_compiler_basedir;
	if (_tmp82_ == NULL) {
		ValaCodeContext* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_ = NULL;
		_tmp83_ = self->priv->context;
		_tmp84_ = vala_code_context_realpath (".");
		_tmp85_ = _tmp84_;
		vala_code_context_set_basedir (_tmp83_, _tmp85_);
		_g_free0 (_tmp85_);
	} else {
		ValaCodeContext* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		gchar* _tmp89_ = NULL;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_compiler_basedir;
		_tmp88_ = vala_code_context_realpath (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_context_set_basedir (_tmp86_, _tmp89_);
		_g_free0 (_tmp89_);
	}
	_tmp90_ = vala_compiler_directory;
	if (_tmp90_ != NULL) {
		ValaCodeContext* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		_tmp91_ = self->priv->context;
		_tmp92_ = vala_compiler_directory;
		_tmp93_ = vala_code_context_realpath (_tmp92_);
		_tmp94_ = _tmp93_;
		vala_code_context_set_directory (_tmp91_, _tmp94_);
		_g_free0 (_tmp94_);
	} else {
		ValaCodeContext* _tmp95_ = NULL;
		ValaCodeContext* _tmp96_ = NULL;
		const gchar* _tmp97_ = NULL;
		const gchar* _tmp98_ = NULL;
		_tmp95_ = self->priv->context;
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_basedir (_tmp96_);
		_tmp98_ = _tmp97_;
		vala_code_context_set_directory (_tmp95_, _tmp98_);
	}
	_tmp99_ = self->priv->context;
	_tmp100_ = vala_compiler_vapi_directories;
	_tmp100__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp101_ = (_tmp100_ != NULL) ? _vala_array_dup1 (_tmp100_, _tmp100__length1) : ((gpointer) _tmp100_);
	_tmp101__length1 = _tmp100__length1;
	_tmp99_->vapi_directories = (_vala_array_free (_tmp99_->vapi_directories, _tmp99_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp99_->vapi_directories = _tmp101_;
	_tmp99_->vapi_directories_length1 = _tmp101__length1;
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp102_, _tmp103_);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_gir_directories;
	_tmp105__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup2 (_tmp105_, _tmp105__length1) : ((gpointer) _tmp105_);
	_tmp106__length1 = _tmp105__length1;
	_tmp104_->gir_directories = (_vala_array_free (_tmp104_->gir_directories, _tmp104_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp104_->gir_directories = _tmp106_;
	_tmp104_->gir_directories_length1 = _tmp106__length1;
	_tmp107_ = self->priv->context;
	_tmp108_ = vala_compiler_metadata_directories;
	_tmp108__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp109_ = (_tmp108_ != NULL) ? _vala_array_dup3 (_tmp108_, _tmp108__length1) : ((gpointer) _tmp108_);
	_tmp109__length1 = _tmp108__length1;
	_tmp107_->metadata_directories = (_vala_array_free (_tmp107_->metadata_directories, _tmp107_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp107_->metadata_directories = _tmp109_;
	_tmp107_->metadata_directories_length1 = _tmp109__length1;
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp114_, _tmp115_);
	_tmp116_ = self->priv->context;
	_tmp117_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp116_, _tmp117_);
	_tmp119_ = vala_compiler_ccode_only;
	if (_tmp119_) {
		gboolean _tmp120_ = FALSE;
		_tmp120_ = vala_compiler_save_temps;
		_tmp118_ = _tmp120_;
	} else {
		_tmp118_ = FALSE;
	}
	if (_tmp118_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp123_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp123_, "gobject-2.0") == 0) {
		_tmp122_ = TRUE;
	} else {
		const gchar* _tmp124_ = NULL;
		_tmp124_ = vala_compiler_profile;
		_tmp122_ = g_strcmp0 (_tmp124_, "gobject") == 0;
	}
	if (_tmp122_) {
		_tmp121_ = TRUE;
	} else {
		const gchar* _tmp125_ = NULL;
		_tmp125_ = vala_compiler_profile;
		_tmp121_ = _tmp125_ == NULL;
	}
	if (_tmp121_) {
		ValaCodeContext* _tmp126_ = NULL;
		ValaCodeContext* _tmp127_ = NULL;
		_tmp126_ = self->priv->context;
		vala_code_context_set_profile (_tmp126_, VALA_PROFILE_GOBJECT);
		_tmp127_ = self->priv->context;
		vala_code_context_add_define (_tmp127_, "GOBJECT");
	} else {
		const gchar* _tmp128_ = NULL;
		gchar* _tmp129_ = NULL;
		gchar* _tmp130_ = NULL;
		_tmp128_ = vala_compiler_profile;
		_tmp129_ = g_strdup_printf ("Unknown profile %s", _tmp128_);
		_tmp130_ = _tmp129_;
		vala_report_error (NULL, _tmp130_);
		_g_free0 (_tmp130_);
	}
	_tmp131_ = vala_compiler_nostdpkg;
	_tmp132_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp131_ | (_tmp132_ != NULL);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp135_, _tmp136_);
	_tmp137_ = self->priv->context;
	_tmp138_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp137_, _tmp138_);
	_tmp139_ = vala_compiler_defines;
	_tmp139__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp139_ != NULL) {
		gchar** _tmp140_ = NULL;
		gint _tmp140__length1 = 0;
		_tmp140_ = vala_compiler_defines;
		_tmp140__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp140_;
			define_collection_length1 = _tmp140__length1;
			for (define_it = 0; define_it < _tmp140__length1; define_it = define_it + 1) {
				gchar* _tmp141_ = NULL;
				gchar* define = NULL;
				_tmp141_ = g_strdup (define_collection[define_it]);
				define = _tmp141_;
				{
					ValaCodeContext* _tmp142_ = NULL;
					const gchar* _tmp143_ = NULL;
					_tmp142_ = self->priv->context;
					_tmp143_ = define;
					vala_code_context_add_define (_tmp142_, _tmp143_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp144_ = FALSE;
			_tmp144_ = TRUE;
			while (TRUE) {
				gint _tmp146_ = 0;
				ValaCodeContext* _tmp147_ = NULL;
				gint _tmp148_ = 0;
				gchar* _tmp149_ = NULL;
				gchar* _tmp150_ = NULL;
				if (!_tmp144_) {
					gint _tmp145_ = 0;
					_tmp145_ = i;
					i = _tmp145_ + 2;
				}
				_tmp144_ = FALSE;
				_tmp146_ = i;
				if (!(_tmp146_ <= 34)) {
					break;
				}
				_tmp147_ = self->priv->context;
				_tmp148_ = i;
				_tmp149_ = g_strdup_printf ("VALA_0_%d", _tmp148_);
				_tmp150_ = _tmp149_;
				vala_code_context_add_define (_tmp147_, _tmp150_);
				_g_free0 (_tmp150_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 32;
	_tmp152_ = vala_compiler_target_glib;
	if (_tmp152_ != NULL) {
		const gchar* _tmp153_ = NULL;
		gint _tmp154_ = 0;
		_tmp153_ = vala_compiler_target_glib;
		_tmp154_ = sscanf (_tmp153_, "%d.%d", &glib_major, &glib_minor);
		_tmp151_ = _tmp154_ != 2;
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp155_ = self->priv->context;
	_tmp156_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp155_, _tmp156_);
	_tmp157_ = self->priv->context;
	_tmp158_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp157_, _tmp158_);
	_tmp159_ = self->priv->context;
	_tmp160_ = vala_code_context_get_target_glib_major (_tmp159_);
	_tmp161_ = _tmp160_;
	if (_tmp161_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp162_ = FALSE;
			_tmp162_ = TRUE;
			while (TRUE) {
				gint _tmp164_ = 0;
				gint _tmp165_ = 0;
				ValaCodeContext* _tmp166_ = NULL;
				gint _tmp167_ = 0;
				gchar* _tmp168_ = NULL;
				gchar* _tmp169_ = NULL;
				if (!_tmp162_) {
					gint _tmp163_ = 0;
					_tmp163_ = i;
					i = _tmp163_ + 2;
				}
				_tmp162_ = FALSE;
				_tmp164_ = i;
				_tmp165_ = glib_minor;
				if (!(_tmp164_ <= _tmp165_)) {
					break;
				}
				_tmp166_ = self->priv->context;
				_tmp167_ = i;
				_tmp168_ = g_strdup_printf ("GLIB_2_%d", _tmp167_);
				_tmp169_ = _tmp168_;
				vala_code_context_add_define (_tmp166_, _tmp169_);
				_g_free0 (_tmp169_);
			}
		}
	}
	_tmp170_ = vala_compiler_nostdpkg;
	if (!_tmp170_) {
		ValaCodeContext* _tmp171_ = NULL;
		ValaCodeContext* _tmp172_ = NULL;
		_tmp171_ = self->priv->context;
		vala_code_context_add_external_package (_tmp171_, "glib-2.0");
		_tmp172_ = self->priv->context;
		vala_code_context_add_external_package (_tmp172_, "gobject-2.0");
	}
	_tmp173_ = vala_compiler_packages;
	_tmp173__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp173_ != NULL) {
		gchar** _tmp174_ = NULL;
		gint _tmp174__length1 = 0;
		_tmp174_ = vala_compiler_packages;
		_tmp174__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp174_;
			package_collection_length1 = _tmp174__length1;
			for (package_it = 0; package_it < _tmp174__length1; package_it = package_it + 1) {
				gchar* _tmp175_ = NULL;
				gchar* package = NULL;
				_tmp175_ = g_strdup (package_collection[package_it]);
				package = _tmp175_;
				{
					ValaCodeContext* _tmp176_ = NULL;
					const gchar* _tmp177_ = NULL;
					_tmp176_ = self->priv->context;
					_tmp177_ = package;
					vala_code_context_add_external_package (_tmp176_, _tmp177_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp178_ = vala_compiler_fast_vapis;
	_tmp178__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp178_ != NULL) {
		gchar** _tmp179_ = NULL;
		gint _tmp179__length1 = 0;
		ValaCodeContext* _tmp188_ = NULL;
		_tmp179_ = vala_compiler_fast_vapis;
		_tmp179__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp179_;
			vapi_collection_length1 = _tmp179__length1;
			for (vapi_it = 0; vapi_it < _tmp179__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp180_ = NULL;
				gchar* vapi = NULL;
				_tmp180_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp180_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp181_ = NULL;
					gchar* _tmp182_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp183_ = NULL;
					const gchar* _tmp184_ = NULL;
					ValaSourceFile* _tmp185_ = NULL;
					ValaCodeContext* _tmp186_ = NULL;
					ValaSourceFile* _tmp187_ = NULL;
					_tmp181_ = vapi;
					_tmp182_ = vala_code_context_realpath (_tmp181_);
					rpath = _tmp182_;
					_tmp183_ = self->priv->context;
					_tmp184_ = rpath;
					_tmp185_ = vala_source_file_new (_tmp183_, VALA_SOURCE_FILE_TYPE_FAST, _tmp184_, NULL, FALSE);
					source_file = _tmp185_;
					_tmp186_ = self->priv->context;
					_tmp187_ = source_file;
					vala_code_context_add_source_file (_tmp186_, _tmp187_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp188_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp188_, TRUE);
	}
	_tmp189_ = self->priv->context;
	_tmp190_ = vala_compiler_gresources;
	_tmp190__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp191_ = (_tmp190_ != NULL) ? _vala_array_dup4 (_tmp190_, _tmp190__length1) : ((gpointer) _tmp190_);
	_tmp191__length1 = _tmp190__length1;
	_tmp189_->gresources = (_vala_array_free (_tmp189_->gresources, _tmp189_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp189_->gresources = _tmp191_;
	_tmp189_->gresources_length1 = _tmp191__length1;
	_tmp192_ = self->priv->context;
	_tmp193_ = vala_compiler_gresources_directories;
	_tmp193__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp194_ = (_tmp193_ != NULL) ? _vala_array_dup5 (_tmp193_, _tmp193__length1) : ((gpointer) _tmp193_);
	_tmp194__length1 = _tmp193__length1;
	_tmp192_->gresources_directories = (_vala_array_free (_tmp192_->gresources_directories, _tmp192_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp192_->gresources_directories = _tmp194_;
	_tmp192_->gresources_directories_length1 = _tmp194__length1;
	_tmp196_ = self->priv->context;
	_tmp197_ = vala_code_context_get_report (_tmp196_);
	_tmp198_ = _tmp197_;
	_tmp199_ = vala_report_get_errors (_tmp198_);
	if (_tmp199_ > 0) {
		_tmp195_ = TRUE;
	} else {
		gboolean _tmp200_ = FALSE;
		gboolean _tmp201_ = FALSE;
		_tmp201_ = vala_compiler_fatal_warnings;
		if (_tmp201_) {
			ValaCodeContext* _tmp202_ = NULL;
			ValaReport* _tmp203_ = NULL;
			ValaReport* _tmp204_ = NULL;
			gint _tmp205_ = 0;
			_tmp202_ = self->priv->context;
			_tmp203_ = vala_code_context_get_report (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_report_get_warnings (_tmp204_);
			_tmp200_ = _tmp205_ > 0;
		} else {
			_tmp200_ = FALSE;
		}
		_tmp195_ = _tmp200_;
	}
	if (_tmp195_) {
		gint _tmp206_ = 0;
		_tmp206_ = vala_compiler_quit (self);
		result = _tmp206_;
		return result;
	}
	_tmp207_ = self->priv->context;
	_tmp208_ = vala_gd_bus_server_module_new ();
	_tmp209_ = _tmp208_;
	vala_code_context_set_codegen (_tmp207_, (ValaCodeGenerator*) _tmp209_);
	_vala_code_visitor_unref0 (_tmp209_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp210_ = vala_compiler_sources;
	_tmp210__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp210_;
		source_collection_length1 = _tmp210__length1;
		for (source_it = 0; source_it < _tmp210__length1; source_it = source_it + 1) {
			gchar* _tmp211_ = NULL;
			gchar* source = NULL;
			_tmp211_ = g_strdup (source_collection[source_it]);
			source = _tmp211_;
			{
				ValaCodeContext* _tmp212_ = NULL;
				const gchar* _tmp213_ = NULL;
				gboolean _tmp214_ = FALSE;
				gboolean _tmp215_ = FALSE;
				_tmp212_ = self->priv->context;
				_tmp213_ = source;
				_tmp214_ = vala_compiler_run_output;
				_tmp215_ = vala_code_context_add_source_filename (_tmp212_, _tmp213_, _tmp214_, TRUE);
				if (_tmp215_) {
					const gchar* _tmp216_ = NULL;
					gboolean _tmp217_ = FALSE;
					_tmp216_ = source;
					_tmp217_ = g_str_has_suffix (_tmp216_, ".c");
					if (_tmp217_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp218_ = NULL;
						gboolean _tmp219_ = FALSE;
						_tmp218_ = source;
						_tmp219_ = g_str_has_suffix (_tmp218_, ".h");
						if (_tmp219_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp221_ = vala_compiler_ccode_only;
	if (_tmp221_) {
		gboolean _tmp222_ = FALSE;
		gboolean _tmp223_ = FALSE;
		_tmp223_ = has_c_files;
		if (_tmp223_) {
			_tmp222_ = TRUE;
		} else {
			gboolean _tmp224_ = FALSE;
			_tmp224_ = has_h_files;
			_tmp222_ = _tmp224_;
		}
		_tmp220_ = _tmp222_;
	} else {
		_tmp220_ = FALSE;
	}
	if (_tmp220_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp226_ = self->priv->context;
	_tmp227_ = vala_code_context_get_report (_tmp226_);
	_tmp228_ = _tmp227_;
	_tmp229_ = vala_report_get_errors (_tmp228_);
	if (_tmp229_ > 0) {
		_tmp225_ = TRUE;
	} else {
		gboolean _tmp230_ = FALSE;
		gboolean _tmp231_ = FALSE;
		_tmp231_ = vala_compiler_fatal_warnings;
		if (_tmp231_) {
			ValaCodeContext* _tmp232_ = NULL;
			ValaReport* _tmp233_ = NULL;
			ValaReport* _tmp234_ = NULL;
			gint _tmp235_ = 0;
			_tmp232_ = self->priv->context;
			_tmp233_ = vala_code_context_get_report (_tmp232_);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_report_get_warnings (_tmp234_);
			_tmp230_ = _tmp235_ > 0;
		} else {
			_tmp230_ = FALSE;
		}
		_tmp225_ = _tmp230_;
	}
	if (_tmp225_) {
		gint _tmp236_ = 0;
		_tmp236_ = vala_compiler_quit (self);
		result = _tmp236_;
		return result;
	}
	_tmp237_ = vala_parser_new ();
	parser = _tmp237_;
	_tmp238_ = parser;
	_tmp239_ = self->priv->context;
	vala_parser_parse (_tmp238_, _tmp239_);
	_tmp240_ = vala_genie_parser_new ();
	genie_parser = _tmp240_;
	_tmp241_ = genie_parser;
	_tmp242_ = self->priv->context;
	vala_genie_parser_parse (_tmp241_, _tmp242_);
	_tmp243_ = vala_gir_parser_new ();
	gir_parser = _tmp243_;
	_tmp244_ = gir_parser;
	_tmp245_ = self->priv->context;
	vala_gir_parser_parse (_tmp244_, _tmp245_);
	_tmp247_ = self->priv->context;
	_tmp248_ = vala_code_context_get_report (_tmp247_);
	_tmp249_ = _tmp248_;
	_tmp250_ = vala_report_get_errors (_tmp249_);
	if (_tmp250_ > 0) {
		_tmp246_ = TRUE;
	} else {
		gboolean _tmp251_ = FALSE;
		gboolean _tmp252_ = FALSE;
		_tmp252_ = vala_compiler_fatal_warnings;
		if (_tmp252_) {
			ValaCodeContext* _tmp253_ = NULL;
			ValaReport* _tmp254_ = NULL;
			ValaReport* _tmp255_ = NULL;
			gint _tmp256_ = 0;
			_tmp253_ = self->priv->context;
			_tmp254_ = vala_code_context_get_report (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_report_get_warnings (_tmp255_);
			_tmp251_ = _tmp256_ > 0;
		} else {
			_tmp251_ = FALSE;
		}
		_tmp246_ = _tmp251_;
	}
	if (_tmp246_) {
		gint _tmp257_ = 0;
		_tmp257_ = vala_compiler_quit (self);
		result = _tmp257_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp258_ = vala_compiler_fast_vapi_filename;
	if (_tmp258_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp259_ = NULL;
		ValaCodeWriter* _tmp260_ = NULL;
		ValaCodeContext* _tmp261_ = NULL;
		const gchar* _tmp262_ = NULL;
		gint _tmp263_ = 0;
		_tmp259_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp259_;
		_tmp260_ = interface_writer;
		_tmp261_ = self->priv->context;
		_tmp262_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp260_, _tmp261_, _tmp262_);
		_tmp263_ = vala_compiler_quit (self);
		result = _tmp263_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp264_ = self->priv->context;
	vala_code_context_check (_tmp264_);
	_tmp266_ = self->priv->context;
	_tmp267_ = vala_code_context_get_report (_tmp266_);
	_tmp268_ = _tmp267_;
	_tmp269_ = vala_report_get_errors (_tmp268_);
	if (_tmp269_ > 0) {
		_tmp265_ = TRUE;
	} else {
		gboolean _tmp270_ = FALSE;
		gboolean _tmp271_ = FALSE;
		_tmp271_ = vala_compiler_fatal_warnings;
		if (_tmp271_) {
			ValaCodeContext* _tmp272_ = NULL;
			ValaReport* _tmp273_ = NULL;
			ValaReport* _tmp274_ = NULL;
			gint _tmp275_ = 0;
			_tmp272_ = self->priv->context;
			_tmp273_ = vala_code_context_get_report (_tmp272_);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_report_get_warnings (_tmp274_);
			_tmp270_ = _tmp275_ > 0;
		} else {
			_tmp270_ = FALSE;
		}
		_tmp265_ = _tmp270_;
	}
	if (_tmp265_) {
		gint _tmp276_ = 0;
		_tmp276_ = vala_compiler_quit (self);
		result = _tmp276_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp279_ = vala_compiler_ccode_only;
	if (!_tmp279_) {
		gboolean _tmp280_ = FALSE;
		_tmp280_ = vala_compiler_compile_only;
		_tmp278_ = !_tmp280_;
	} else {
		_tmp278_ = FALSE;
	}
	if (_tmp278_) {
		const gchar* _tmp281_ = NULL;
		_tmp281_ = vala_compiler_library;
		_tmp277_ = _tmp281_ == NULL;
	} else {
		_tmp277_ = FALSE;
	}
	if (_tmp277_) {
		gboolean _tmp282_ = FALSE;
		gboolean _tmp283_ = FALSE;
		_tmp283_ = has_c_files;
		if (!_tmp283_) {
			ValaCodeContext* _tmp284_ = NULL;
			ValaMethod* _tmp285_ = NULL;
			ValaMethod* _tmp286_ = NULL;
			_tmp284_ = self->priv->context;
			_tmp285_ = vala_code_context_get_entry_point (_tmp284_);
			_tmp286_ = _tmp285_;
			_tmp282_ = _tmp286_ == NULL;
		} else {
			_tmp282_ = FALSE;
		}
		if (_tmp282_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp287_ = vala_compiler_dump_tree;
	if (_tmp287_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp288_ = NULL;
		ValaCodeWriter* _tmp289_ = NULL;
		ValaCodeContext* _tmp290_ = NULL;
		const gchar* _tmp291_ = NULL;
		_tmp288_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp288_;
		_tmp289_ = code_writer;
		_tmp290_ = self->priv->context;
		_tmp291_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp289_, _tmp290_, _tmp291_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp293_ = self->priv->context;
	_tmp294_ = vala_code_context_get_report (_tmp293_);
	_tmp295_ = _tmp294_;
	_tmp296_ = vala_report_get_errors (_tmp295_);
	if (_tmp296_ > 0) {
		_tmp292_ = TRUE;
	} else {
		gboolean _tmp297_ = FALSE;
		gboolean _tmp298_ = FALSE;
		_tmp298_ = vala_compiler_fatal_warnings;
		if (_tmp298_) {
			ValaCodeContext* _tmp299_ = NULL;
			ValaReport* _tmp300_ = NULL;
			ValaReport* _tmp301_ = NULL;
			gint _tmp302_ = 0;
			_tmp299_ = self->priv->context;
			_tmp300_ = vala_code_context_get_report (_tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_report_get_warnings (_tmp301_);
			_tmp297_ = _tmp302_ > 0;
		} else {
			_tmp297_ = FALSE;
		}
		_tmp292_ = _tmp297_;
	}
	if (_tmp292_) {
		gint _tmp303_ = 0;
		_tmp303_ = vala_compiler_quit (self);
		result = _tmp303_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp304_ = self->priv->context;
	_tmp305_ = vala_code_context_get_codegen (_tmp304_);
	_tmp306_ = _tmp305_;
	_tmp307_ = self->priv->context;
	vala_code_generator_emit (_tmp306_, _tmp307_);
	_tmp309_ = self->priv->context;
	_tmp310_ = vala_code_context_get_report (_tmp309_);
	_tmp311_ = _tmp310_;
	_tmp312_ = vala_report_get_errors (_tmp311_);
	if (_tmp312_ > 0) {
		_tmp308_ = TRUE;
	} else {
		gboolean _tmp313_ = FALSE;
		gboolean _tmp314_ = FALSE;
		_tmp314_ = vala_compiler_fatal_warnings;
		if (_tmp314_) {
			ValaCodeContext* _tmp315_ = NULL;
			ValaReport* _tmp316_ = NULL;
			ValaReport* _tmp317_ = NULL;
			gint _tmp318_ = 0;
			_tmp315_ = self->priv->context;
			_tmp316_ = vala_code_context_get_report (_tmp315_);
			_tmp317_ = _tmp316_;
			_tmp318_ = vala_report_get_warnings (_tmp317_);
			_tmp313_ = _tmp318_ > 0;
		} else {
			_tmp313_ = FALSE;
		}
		_tmp308_ = _tmp313_;
	}
	if (_tmp308_) {
		gint _tmp319_ = 0;
		_tmp319_ = vala_compiler_quit (self);
		result = _tmp319_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp321_ = vala_compiler_vapi_filename;
	if (_tmp321_ == NULL) {
		const gchar* _tmp322_ = NULL;
		_tmp322_ = vala_compiler_library;
		_tmp320_ = _tmp322_ != NULL;
	} else {
		_tmp320_ = FALSE;
	}
	if (_tmp320_) {
		const gchar* _tmp323_ = NULL;
		gchar* _tmp324_ = NULL;
		_tmp323_ = vala_compiler_library;
		_tmp324_ = g_strdup_printf ("%s.vapi", _tmp323_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp324_;
	}
	_tmp325_ = vala_compiler_library;
	if (_tmp325_ != NULL) {
		const gchar* _tmp326_ = NULL;
		_tmp326_ = vala_compiler_gir;
		if (_tmp326_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp327_ = NULL;
			gchar* _tmp328_ = NULL;
			glong gir_len = 0L;
			const gchar* _tmp329_ = NULL;
			gint _tmp330_ = 0;
			gint _tmp331_ = 0;
			gint last_hyphen = 0;
			const gchar* _tmp332_ = NULL;
			gint _tmp333_ = 0;
			gboolean _tmp334_ = FALSE;
			gint _tmp335_ = 0;
			_tmp327_ = vala_compiler_gir;
			_tmp328_ = g_path_get_basename (_tmp327_);
			gir_base = _tmp328_;
			_tmp329_ = gir_base;
			_tmp330_ = strlen (_tmp329_);
			_tmp331_ = _tmp330_;
			gir_len = (glong) _tmp331_;
			_tmp332_ = gir_base;
			_tmp333_ = string_last_index_of_char (_tmp332_, (gunichar) '-', 0);
			last_hyphen = _tmp333_;
			_tmp335_ = last_hyphen;
			if (_tmp335_ == -1) {
				_tmp334_ = TRUE;
			} else {
				const gchar* _tmp336_ = NULL;
				gboolean _tmp337_ = FALSE;
				_tmp336_ = gir_base;
				_tmp337_ = g_str_has_suffix (_tmp336_, ".gir");
				_tmp334_ = !_tmp337_;
			}
			if (_tmp334_) {
				const gchar* _tmp338_ = NULL;
				gchar* _tmp339_ = NULL;
				gchar* _tmp340_ = NULL;
				_tmp338_ = vala_compiler_gir;
				_tmp339_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp338_);
				_tmp340_ = _tmp339_;
				vala_report_error (NULL, _tmp340_);
				_g_free0 (_tmp340_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp341_ = NULL;
				gint _tmp342_ = 0;
				gchar* _tmp343_ = NULL;
				gchar* gir_version = NULL;
				const gchar* _tmp344_ = NULL;
				gint _tmp345_ = 0;
				glong _tmp346_ = 0L;
				gint _tmp347_ = 0;
				gchar* _tmp348_ = NULL;
				const gchar* _tmp349_ = NULL;
				gboolean _tmp350_ = FALSE;
				gboolean _tmp351_ = FALSE;
				gboolean _tmp352_ = FALSE;
				const gchar* _tmp353_ = NULL;
				_tmp341_ = gir_base;
				_tmp342_ = last_hyphen;
				_tmp343_ = string_substring (_tmp341_, (glong) 0, (glong) _tmp342_);
				gir_namespace = _tmp343_;
				_tmp344_ = gir_base;
				_tmp345_ = last_hyphen;
				_tmp346_ = gir_len;
				_tmp347_ = last_hyphen;
				_tmp348_ = string_substring (_tmp344_, (glong) (_tmp345_ + 1), (_tmp346_ - _tmp347_) - 5);
				gir_version = _tmp348_;
				_tmp349_ = gir_version;
				g_strcanon (_tmp349_, "0123456789.", '?');
				_tmp353_ = gir_namespace;
				if (g_strcmp0 (_tmp353_, "") == 0) {
					_tmp352_ = TRUE;
				} else {
					const gchar* _tmp354_ = NULL;
					_tmp354_ = gir_version;
					_tmp352_ = g_strcmp0 (_tmp354_, "") == 0;
				}
				if (_tmp352_) {
					_tmp351_ = TRUE;
				} else {
					const gchar* _tmp355_ = NULL;
					gchar _tmp356_ = '\0';
					gboolean _tmp357_ = FALSE;
					_tmp355_ = gir_version;
					_tmp356_ = string_get (_tmp355_, (glong) 0);
					_tmp357_ = g_ascii_isdigit (_tmp356_);
					_tmp351_ = !_tmp357_;
				}
				if (_tmp351_) {
					_tmp350_ = TRUE;
				} else {
					const gchar* _tmp358_ = NULL;
					gboolean _tmp359_ = FALSE;
					_tmp358_ = gir_version;
					_tmp359_ = string_contains (_tmp358_, "?");
					_tmp350_ = _tmp359_;
				}
				if (_tmp350_) {
					const gchar* _tmp360_ = NULL;
					gchar* _tmp361_ = NULL;
					gchar* _tmp362_ = NULL;
					_tmp360_ = vala_compiler_gir;
					_tmp361_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp360_);
					_tmp362_ = _tmp361_;
					vala_report_error (NULL, _tmp362_);
					_g_free0 (_tmp362_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp363_ = NULL;
					gchar* gir_directory = NULL;
					gchar* _tmp364_ = NULL;
					const gchar* _tmp365_ = NULL;
					ValaGIRWriter* _tmp370_ = NULL;
					ValaCodeContext* _tmp371_ = NULL;
					const gchar* _tmp372_ = NULL;
					const gchar* _tmp373_ = NULL;
					const gchar* _tmp374_ = NULL;
					const gchar* _tmp375_ = NULL;
					const gchar* _tmp376_ = NULL;
					const gchar* _tmp377_ = NULL;
					_tmp363_ = vala_gir_writer_new ();
					gir_writer = _tmp363_;
					_tmp364_ = g_strdup (".");
					gir_directory = _tmp364_;
					_tmp365_ = vala_compiler_directory;
					if (_tmp365_ != NULL) {
						ValaCodeContext* _tmp366_ = NULL;
						const gchar* _tmp367_ = NULL;
						const gchar* _tmp368_ = NULL;
						gchar* _tmp369_ = NULL;
						_tmp366_ = self->priv->context;
						_tmp367_ = vala_code_context_get_directory (_tmp366_);
						_tmp368_ = _tmp367_;
						_tmp369_ = g_strdup (_tmp368_);
						_g_free0 (gir_directory);
						gir_directory = _tmp369_;
					}
					_tmp370_ = gir_writer;
					_tmp371_ = self->priv->context;
					_tmp372_ = gir_directory;
					_tmp373_ = vala_compiler_gir;
					_tmp374_ = gir_namespace;
					_tmp375_ = gir_version;
					_tmp376_ = vala_compiler_library;
					_tmp377_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp370_, _tmp371_, _tmp372_, _tmp373_, _tmp374_, _tmp375_, _tmp376_, _tmp377_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp378_ = vala_compiler_vapi_filename;
	if (_tmp378_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp379_ = NULL;
		gboolean _tmp380_ = FALSE;
		const gchar* _tmp381_ = NULL;
		ValaCodeWriter* _tmp389_ = NULL;
		ValaCodeContext* _tmp390_ = NULL;
		const gchar* _tmp391_ = NULL;
		_tmp379_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp379_;
		_tmp381_ = vala_compiler_directory;
		if (_tmp381_ != NULL) {
			const gchar* _tmp382_ = NULL;
			gboolean _tmp383_ = FALSE;
			_tmp382_ = vala_compiler_vapi_filename;
			_tmp383_ = g_path_is_absolute (_tmp382_);
			_tmp380_ = !_tmp383_;
		} else {
			_tmp380_ = FALSE;
		}
		if (_tmp380_) {
			ValaCodeContext* _tmp384_ = NULL;
			const gchar* _tmp385_ = NULL;
			const gchar* _tmp386_ = NULL;
			const gchar* _tmp387_ = NULL;
			gchar* _tmp388_ = NULL;
			_tmp384_ = self->priv->context;
			_tmp385_ = vala_code_context_get_directory (_tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = vala_compiler_vapi_filename;
			_tmp388_ = g_strdup_printf ("%s%c%s", _tmp386_, (gint) G_DIR_SEPARATOR, _tmp387_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp388_;
		}
		_tmp389_ = interface_writer;
		_tmp390_ = self->priv->context;
		_tmp391_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp389_, _tmp390_, _tmp391_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp392_ = vala_compiler_internal_vapi_filename;
	if (_tmp392_ != NULL) {
		gboolean _tmp393_ = FALSE;
		const gchar* _tmp394_ = NULL;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp397_ = NULL;
		ValaCodeWriter* _tmp398_ = NULL;
		const gchar* _tmp399_ = NULL;
		const gchar* _tmp400_ = NULL;
		gchar* vapi_filename = NULL;
		const gchar* _tmp401_ = NULL;
		gchar* _tmp402_ = NULL;
		gboolean _tmp403_ = FALSE;
		const gchar* _tmp404_ = NULL;
		ValaCodeWriter* _tmp412_ = NULL;
		ValaCodeContext* _tmp413_ = NULL;
		const gchar* _tmp414_ = NULL;
		_tmp394_ = vala_compiler_internal_header_filename;
		if (_tmp394_ == NULL) {
			_tmp393_ = TRUE;
		} else {
			const gchar* _tmp395_ = NULL;
			_tmp395_ = vala_compiler_header_filename;
			_tmp393_ = _tmp395_ == NULL;
		}
		if (_tmp393_) {
			gint _tmp396_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp396_ = vala_compiler_quit (self);
			result = _tmp396_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp397_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp397_;
		_tmp398_ = interface_writer;
		_tmp399_ = vala_compiler_header_filename;
		_tmp400_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp398_, _tmp399_, _tmp400_);
		_tmp401_ = vala_compiler_internal_vapi_filename;
		_tmp402_ = g_strdup (_tmp401_);
		vapi_filename = _tmp402_;
		_tmp404_ = vala_compiler_directory;
		if (_tmp404_ != NULL) {
			const gchar* _tmp405_ = NULL;
			gboolean _tmp406_ = FALSE;
			_tmp405_ = vapi_filename;
			_tmp406_ = g_path_is_absolute (_tmp405_);
			_tmp403_ = !_tmp406_;
		} else {
			_tmp403_ = FALSE;
		}
		if (_tmp403_) {
			ValaCodeContext* _tmp407_ = NULL;
			const gchar* _tmp408_ = NULL;
			const gchar* _tmp409_ = NULL;
			const gchar* _tmp410_ = NULL;
			gchar* _tmp411_ = NULL;
			_tmp407_ = self->priv->context;
			_tmp408_ = vala_code_context_get_directory (_tmp407_);
			_tmp409_ = _tmp408_;
			_tmp410_ = vapi_filename;
			_tmp411_ = g_strdup_printf ("%s%c%s", _tmp409_, (gint) G_DIR_SEPARATOR, _tmp410_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp411_;
		}
		_tmp412_ = interface_writer;
		_tmp413_ = self->priv->context;
		_tmp414_ = vapi_filename;
		vala_code_writer_write_file (_tmp412_, _tmp413_, _tmp414_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp415_ = vala_compiler_dependencies;
	if (_tmp415_ != NULL) {
		ValaCodeContext* _tmp416_ = NULL;
		const gchar* _tmp417_ = NULL;
		_tmp416_ = self->priv->context;
		_tmp417_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp416_, _tmp417_);
	}
	_tmp419_ = self->priv->context;
	_tmp420_ = vala_code_context_get_report (_tmp419_);
	_tmp421_ = _tmp420_;
	_tmp422_ = vala_report_get_errors (_tmp421_);
	if (_tmp422_ > 0) {
		_tmp418_ = TRUE;
	} else {
		gboolean _tmp423_ = FALSE;
		gboolean _tmp424_ = FALSE;
		_tmp424_ = vala_compiler_fatal_warnings;
		if (_tmp424_) {
			ValaCodeContext* _tmp425_ = NULL;
			ValaReport* _tmp426_ = NULL;
			ValaReport* _tmp427_ = NULL;
			gint _tmp428_ = 0;
			_tmp425_ = self->priv->context;
			_tmp426_ = vala_code_context_get_report (_tmp425_);
			_tmp427_ = _tmp426_;
			_tmp428_ = vala_report_get_warnings (_tmp427_);
			_tmp423_ = _tmp428_ > 0;
		} else {
			_tmp423_ = FALSE;
		}
		_tmp418_ = _tmp423_;
	}
	if (_tmp418_) {
		gint _tmp429_ = 0;
		_tmp429_ = vala_compiler_quit (self);
		result = _tmp429_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp430_ = vala_compiler_ccode_only;
	if (!_tmp430_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp431_ = NULL;
		gboolean _tmp432_ = FALSE;
		const gchar* _tmp433_ = NULL;
		gboolean _tmp437_ = FALSE;
		const gchar* _tmp438_ = NULL;
		gchar** _tmp442_ = NULL;
		gint _tmp442__length1 = 0;
		_tmp431_ = vala_ccode_compiler_new ();
		ccompiler = _tmp431_;
		_tmp433_ = vala_compiler_cc_command;
		if (_tmp433_ == NULL) {
			const gchar* _tmp434_ = NULL;
			_tmp434_ = g_getenv ("CC");
			_tmp432_ = _tmp434_ != NULL;
		} else {
			_tmp432_ = FALSE;
		}
		if (_tmp432_) {
			const gchar* _tmp435_ = NULL;
			gchar* _tmp436_ = NULL;
			_tmp435_ = g_getenv ("CC");
			_tmp436_ = g_strdup (_tmp435_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp436_;
		}
		_tmp438_ = vala_compiler_pkg_config_command;
		if (_tmp438_ == NULL) {
			const gchar* _tmp439_ = NULL;
			_tmp439_ = g_getenv ("PKG_CONFIG");
			_tmp437_ = _tmp439_ != NULL;
		} else {
			_tmp437_ = FALSE;
		}
		if (_tmp437_) {
			const gchar* _tmp440_ = NULL;
			gchar* _tmp441_ = NULL;
			_tmp440_ = g_getenv ("PKG_CONFIG");
			_tmp441_ = g_strdup (_tmp440_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp441_;
		}
		_tmp442_ = vala_compiler_cc_options;
		_tmp442__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp442_ == NULL) {
			ValaCCodeCompiler* _tmp443_ = NULL;
			ValaCodeContext* _tmp444_ = NULL;
			const gchar* _tmp445_ = NULL;
			gchar** _tmp446_ = NULL;
			gchar** _tmp447_ = NULL;
			gint _tmp447__length1 = 0;
			const gchar* _tmp448_ = NULL;
			_tmp443_ = ccompiler;
			_tmp444_ = self->priv->context;
			_tmp445_ = vala_compiler_cc_command;
			_tmp446_ = g_new0 (gchar*, 0 + 1);
			_tmp447_ = _tmp446_;
			_tmp447__length1 = 0;
			_tmp448_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp443_, _tmp444_, _tmp445_, _tmp447_, 0, _tmp448_);
			_tmp447_ = (_vala_array_free (_tmp447_, _tmp447__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp449_ = NULL;
			ValaCodeContext* _tmp450_ = NULL;
			const gchar* _tmp451_ = NULL;
			gchar** _tmp452_ = NULL;
			gint _tmp452__length1 = 0;
			const gchar* _tmp453_ = NULL;
			_tmp449_ = ccompiler;
			_tmp450_ = self->priv->context;
			_tmp451_ = vala_compiler_cc_command;
			_tmp452_ = vala_compiler_cc_options;
			_tmp452__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp453_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp449_, _tmp450_, _tmp451_, _tmp452_, _tmp452__length1, _tmp453_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp454_ = vala_compiler_quit (self);
	result = _tmp454_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_ = 0;
	GMainLoop* _tmp1_ = NULL;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp32_ = FALSE;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp39_ = 0;
	const gchar* _tmp40_ = NULL;
	gchar** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gint _tmp43_ = 0;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar** _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gint _tmp49_ = 0;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gint outputfd = 0;
	const gchar* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp57_ = NULL;
	gint ret = 0;
	ValaCompiler* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	const gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gchar** target_args = NULL;
	const gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gint target_args_length1 = 0;
	gint _target_args_size_ = 0;
	gint _tmp87_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp31_ = 0;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar** _tmp12_ = NULL;
			gint _tmp13_ = 0;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_ = NULL;
			GOptionContext* _tmp16_ = NULL;
			GOptionContext* _tmp17_ = NULL;
			gchar** temp_args = NULL;
			gchar** _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint temp_args_length1 = 0;
			gint _temp_args_size_ = 0;
			GOptionContext* _tmp19_ = NULL;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp14_ = 0;
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp14_;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp20_ = 0;
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp20_;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stdout;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp24_ = NULL;
			GError* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			FILE* _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gint _tmp28__length1 = 0;
			const gchar* _tmp29_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = stdout;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			fprintf (_tmp24_, "%s\n", _tmp26_);
			_tmp27_ = stdout;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = _tmp28_[0];
			fprintf (_tmp27_, "Run '%s --help' to see a full list of available command line options.\n", _tmp29_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = 0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
		_tmp31_ = i;
		i = _tmp31_ + 1;
	}
	_tmp32_ = vala_compiler_version;
	if (_tmp32_) {
		FILE* _tmp33_ = NULL;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp34_ = FALSE;
		_tmp34_ = vala_compiler_api_version;
		if (_tmp34_) {
			FILE* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp35_ = stdout;
			_tmp36_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp37_ = _tmp36_;
			fprintf (_tmp35_, "%s\n", _tmp37_);
			_g_free0 (_tmp37_);
			result = 0;
			return result;
		}
	}
	_tmp38_ = args;
	_tmp38__length1 = args_length1;
	_tmp39_ = i;
	_tmp40_ = _tmp38_[_tmp39_];
	if (_tmp40_ == NULL) {
		FILE* _tmp41_ = NULL;
		_tmp41_ = stderr;
		fprintf (_tmp41_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp42_ = args;
	_tmp42__length1 = args_length1;
	_tmp43_ = i;
	_tmp44_ = _tmp42_[_tmp43_];
	_tmp45_ = g_strdup (_tmp44_);
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp46_;
	_tmp47_ = g_get_tmp_dir ();
	_tmp48_ = args;
	_tmp48__length1 = args_length1;
	_tmp49_ = i;
	_tmp50_ = _tmp48_[_tmp49_];
	_tmp51_ = g_path_get_basename (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp47_, _tmp52_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp53_;
	_g_free0 (_tmp52_);
	_tmp54_ = vala_compiler_output;
	_tmp55_ = g_mkstemp (_tmp54_);
	outputfd = _tmp55_;
	_tmp56_ = outputfd;
	if (_tmp56_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp57_ = vala_compiler_new ();
	compiler = _tmp57_;
	_tmp58_ = compiler;
	_tmp59_ = vala_compiler_run (_tmp58_);
	ret = _tmp59_;
	_tmp60_ = ret;
	if (_tmp60_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp61_ = outputfd;
	close (_tmp61_);
	_tmp62_ = vala_compiler_output;
	_tmp63_ = g_chmod (_tmp62_, 0700);
	if (_tmp63_ != 0) {
		const gchar* _tmp64_ = NULL;
		_tmp64_ = vala_compiler_output;
		g_unlink (_tmp64_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp65_ = vala_compiler_output;
	_tmp66_ = g_strdup (_tmp65_);
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	target_args = _tmp67_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp68_ = 0;
		gchar** _tmp69_ = NULL;
		gint _tmp69__length1 = 0;
		gchar** _tmp70_ = NULL;
		gint _tmp70__length1 = 0;
		gchar** _tmp71_ = NULL;
		gint _tmp71__length1 = 0;
		gint _tmp72_ = 0;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		_tmp68_ = i;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		if (!(_tmp68_ < _tmp69__length1)) {
			break;
		}
		_tmp70_ = target_args;
		_tmp70__length1 = target_args_length1;
		_tmp71_ = args;
		_tmp71__length1 = args_length1;
		_tmp72_ = i;
		_tmp73_ = _tmp71_[_tmp72_];
		_tmp74_ = g_strdup (_tmp73_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp74_);
		_tmp75_ = i;
		i = _tmp75_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp76_ = NULL;
		gchar** _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		GPid _tmp78_ = 0;
		const gchar* _tmp80_ = NULL;
		GPid _tmp81_ = 0;
		GMainLoop* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp76_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp76_;
		_data1_->child_status = 0;
		_tmp77_ = target_args;
		_tmp77__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp77_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp78_, &_inner_error_);
		pid = _tmp78_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp79_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp79_;
		}
		_tmp80_ = vala_compiler_output;
		g_unlink (_tmp80_);
		_tmp81_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp81_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp82_ = _data1_->loop;
		g_main_loop_run (_tmp82_);
		_tmp83_ = _data1_->child_status;
		result = _tmp83_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp84_ = NULL;
		GError* _tmp85_ = NULL;
		const gchar* _tmp86_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp84_ = stdout;
		_tmp85_ = e;
		_tmp86_ = _tmp85_->message;
		fprintf (_tmp84_, "%s\n", _tmp86_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp87_;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp34_ = NULL;
	ValaCompiler* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_ = NULL;
		GOptionContext* _tmp13_ = NULL;
		GOptionContext* _tmp14_ = NULL;
		GOptionContext* _tmp15_ = NULL;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp16_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		FILE* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp23_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	_tmp24_ = vala_compiler_version;
	if (_tmp24_) {
		FILE* _tmp25_ = NULL;
		_tmp25_ = stdout;
		fprintf (_tmp25_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp26_ = FALSE;
		_tmp26_ = vala_compiler_api_version;
		if (_tmp26_) {
			FILE* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			_tmp27_ = stdout;
			_tmp28_ = string_substring (PACKAGE_SUFFIX, (glong) 1, (glong) -1);
			_tmp29_ = _tmp28_;
			fprintf (_tmp27_, "%s\n", _tmp29_);
			_g_free0 (_tmp29_);
			result = 0;
			return result;
		}
	}
	_tmp31_ = vala_compiler_sources;
	_tmp31__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp31_ == NULL) {
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		_tmp32_ = vala_compiler_fast_vapis;
		_tmp32__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp30_ = _tmp32_ == NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		FILE* _tmp33_ = NULL;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = vala_compiler_new ();
	compiler = _tmp34_;
	_tmp35_ = compiler;
	_tmp36_ = vala_compiler_run (_tmp35_);
	result = _tmp36_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



