/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_tmp9_ = _type_arg_index;
			_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _type_arg_index;
			_tmp11_ = _type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_arg_list;
			_tmp13_ = _type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CONSTANT);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CONSTANT) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp20_;
	gboolean _tmp557_ = FALSE;
	gboolean _tmp558_ = FALSE;
	ValaSymbol* _tmp559_;
	ValaSymbol* _tmp560_;
	ValaSymbol* _tmp588_;
	ValaSymbol* _tmp589_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp612_;
	ValaSymbol* _tmp613_;
	ValaSymbol* _tmp614_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp615_;
	ValaSymbol* _tmp616_;
	ValaSymbol* _tmp1034_;
	ValaSymbol* _tmp1035_;
	ValaVersionAttribute* _tmp1036_;
	ValaVersionAttribute* _tmp1037_;
	ValaSourceReference* _tmp1038_;
	ValaSourceReference* _tmp1039_;
	gboolean _tmp1040_ = FALSE;
	ValaSymbolAccessibility _tmp1041_;
	gboolean _tmp1102_ = FALSE;
	gboolean _tmp1103_;
	gboolean _tmp1142_ = FALSE;
	gboolean _tmp1143_ = FALSE;
	gboolean _tmp1144_;
	gboolean _tmp1414_;
	gboolean _tmp1415_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_tmp13_ = _type_arg_index;
			_type_arg_index = _tmp13_ + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = _type_arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaScope* _tmp25_;
		ValaScope* _tmp26_;
		const gchar* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaSymbol* _tmp29_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp23_;
		_tmp24_ = base_symbol;
		_tmp25_ = vala_symbol_get_scope (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_member_name;
		_tmp28_ = vala_scope_lookup (_tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
	} else {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == NULL) {
			const gchar* _tmp32_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaSymbol* _tmp46_;
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			_tmp32_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp32_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp33_;
				ValaSemanticAnalyzer* _tmp34_;
				_tmp33_ = vala_code_context_get_analyzer (context);
				_tmp34_ = _tmp33_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp34_)) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp37_ = vala_code_context_get_analyzer (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _vala_code_node_ref0 (_tmp40_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (_tmp45_);
			sym = _tmp46_;
			while (TRUE) {
				gboolean _tmp47_ = FALSE;
				ValaSymbol* _tmp48_;
				gboolean _tmp51_;
				ValaSymbol* _tmp105_;
				const gchar* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp108_;
				gboolean _tmp109_ = FALSE;
				gboolean _tmp110_ = FALSE;
				ValaSymbol* _tmp111_;
				ValaSymbol* _tmp112_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp157_;
				_tmp48_ = sym;
				if (_tmp48_ != NULL) {
					ValaSymbol* _tmp49_;
					ValaSymbol* _tmp50_;
					_tmp49_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp50_ = _tmp49_;
					_tmp47_ = _tmp50_ == NULL;
				} else {
					_tmp47_ = FALSE;
				}
				if (!_tmp47_) {
					break;
				}
				_tmp51_ = method_found;
				if (!_tmp51_) {
					ValaSymbol* _tmp52_;
					_tmp52_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_CREATION_METHOD)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp53_;
						ValaCreationMethod* _tmp54_;
						ValaCreationMethod* _tmp55_;
						ValaParameter* _tmp56_;
						ValaParameter* _tmp57_;
						ValaParameter* _tmp58_;
						_tmp53_ = sym;
						_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp54_;
						_tmp55_ = cm;
						_tmp56_ = vala_method_get_this_parameter ((ValaMethod*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp58_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp59_;
						_tmp59_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp59_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp60_;
							ValaProperty* _tmp61_;
							ValaProperty* _tmp62_;
							ValaParameter* _tmp63_;
							ValaParameter* _tmp64_;
							ValaParameter* _tmp65_;
							ValaProperty* _tmp66_;
							ValaMemberBinding _tmp67_;
							ValaMemberBinding _tmp68_;
							ValaProperty* _tmp69_;
							ValaMemberBinding _tmp70_;
							ValaMemberBinding _tmp71_;
							_tmp60_ = sym;
							_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp61_;
							_tmp62_ = prop;
							_tmp63_ = vala_property_get_this_parameter (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = _vala_code_node_ref0 (_tmp64_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp65_;
							_tmp66_ = prop;
							_tmp67_ = vala_property_get_binding (_tmp66_);
							_tmp68_ = _tmp67_;
							may_access_instance_members = _tmp68_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp69_ = prop;
							_tmp70_ = vala_property_get_binding (_tmp69_);
							_tmp71_ = _tmp70_;
							may_access_klass_members = _tmp71_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp72_;
							_tmp72_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_CONSTRUCTOR)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaConstructor* _tmp75_;
								ValaParameter* _tmp76_;
								ValaParameter* _tmp77_;
								ValaParameter* _tmp78_;
								ValaConstructor* _tmp79_;
								ValaMemberBinding _tmp80_;
								ValaMemberBinding _tmp81_;
								_tmp73_ = sym;
								_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp74_;
								_tmp75_ = c;
								_tmp76_ = vala_constructor_get_this_parameter (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = _vala_code_node_ref0 (_tmp77_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp78_;
								_tmp79_ = c;
								_tmp80_ = vala_constructor_get_binding (_tmp79_);
								_tmp81_ = _tmp80_;
								may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp82_;
								_tmp82_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_DESTRUCTOR)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaDestructor* _tmp85_;
									ValaParameter* _tmp86_;
									ValaParameter* _tmp87_;
									ValaParameter* _tmp88_;
									ValaDestructor* _tmp89_;
									ValaMemberBinding _tmp90_;
									ValaMemberBinding _tmp91_;
									_tmp83_ = sym;
									_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp84_;
									_tmp85_ = d;
									_tmp86_ = vala_destructor_get_this_parameter (_tmp85_);
									_tmp87_ = _tmp86_;
									_tmp88_ = _vala_code_node_ref0 (_tmp87_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp88_;
									_tmp89_ = d;
									_tmp90_ = vala_destructor_get_binding (_tmp89_);
									_tmp91_ = _tmp90_;
									may_access_instance_members = _tmp91_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp92_;
									_tmp92_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_METHOD)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMethod* _tmp95_;
										ValaParameter* _tmp96_;
										ValaParameter* _tmp97_;
										ValaParameter* _tmp98_;
										ValaMethod* _tmp99_;
										ValaMemberBinding _tmp100_;
										ValaMemberBinding _tmp101_;
										ValaMethod* _tmp102_;
										ValaMemberBinding _tmp103_;
										ValaMemberBinding _tmp104_;
										_tmp93_ = sym;
										_tmp94_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp94_;
										_tmp95_ = m;
										_tmp96_ = vala_method_get_this_parameter (_tmp95_);
										_tmp97_ = _tmp96_;
										_tmp98_ = _vala_code_node_ref0 (_tmp97_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp98_;
										_tmp99_ = m;
										_tmp100_ = vala_method_get_binding (_tmp99_);
										_tmp101_ = _tmp100_;
										may_access_instance_members = _tmp101_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp102_ = m;
										_tmp103_ = vala_method_get_binding (_tmp102_);
										_tmp104_ = _tmp103_;
										may_access_klass_members = _tmp104_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp105_ = sym;
				_tmp106_ = self->priv->_member_name;
				_tmp107_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp105_, _tmp106_);
				_tmp108_ = _tmp107_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp108_);
				_vala_code_node_unref0 (_tmp108_);
				_tmp111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp112_ = _tmp111_;
				if (_tmp112_ == NULL) {
					ValaSymbol* _tmp113_;
					_tmp113_ = sym;
					_tmp110_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_TYPESYMBOL);
				} else {
					_tmp110_ = FALSE;
				}
				if (_tmp110_) {
					gboolean _tmp114_;
					_tmp114_ = may_access_instance_members;
					_tmp109_ = _tmp114_;
				} else {
					_tmp109_ = FALSE;
				}
				if (_tmp109_) {
					ValaParameter* _tmp115_;
					ValaDataType* _tmp116_;
					ValaDataType* _tmp117_;
					const gchar* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					gboolean _tmp121_ = FALSE;
					ValaSymbol* _tmp122_;
					ValaSymbol* _tmp123_;
					_tmp115_ = this_parameter;
					_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = self->priv->_member_name;
					_tmp119_ = vala_data_type_get_member (_tmp117_, _tmp118_);
					_tmp120_ = _tmp119_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp120_);
					_vala_code_node_unref0 (_tmp120_);
					_tmp122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp123_ = _tmp122_;
					if (_tmp123_ != NULL) {
						ValaSymbol* _tmp124_;
						ValaSymbol* _tmp125_;
						_tmp124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp125_ = _tmp124_;
						_tmp121_ = vala_member_access_is_instance_symbol (_tmp125_);
					} else {
						_tmp121_ = FALSE;
					}
					if (_tmp121_) {
						ValaSourceReference* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaParameter* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaDataType* _tmp136_;
						ValaExpression* _tmp137_;
						ValaExpression* _tmp138_;
						ValaDataType* _tmp139_;
						ValaDataType* _tmp140_;
						ValaExpression* _tmp141_;
						ValaExpression* _tmp142_;
						ValaParameter* _tmp143_;
						ValaExpression* _tmp144_;
						ValaExpression* _tmp145_;
						ValaDataType* _tmp146_;
						ValaDataType* _tmp147_;
						const gchar* _tmp148_;
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_member_access_new (NULL, "this", _tmp127_);
						_tmp129_ = _tmp128_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp129_);
						_vala_code_node_unref0 (_tmp129_);
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						_tmp132_ = this_parameter;
						_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_copy (_tmp134_);
						_tmp136_ = _tmp135_;
						vala_expression_set_value_type (_tmp131_, _tmp136_);
						_vala_code_node_unref0 (_tmp136_);
						_tmp137_ = vala_member_access_get_inner (self);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_expression_get_value_type (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_data_type_set_value_owned (_tmp140_, FALSE);
						_tmp141_ = vala_member_access_get_inner (self);
						_tmp142_ = _tmp141_;
						_tmp143_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp142_, (ValaSymbol*) _tmp143_);
						_tmp144_ = vala_member_access_get_inner (self);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_expression_get_value_type (_tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = self->priv->_member_name;
						_tmp149_ = vala_data_type_get_member (_tmp147_, _tmp148_);
						_tmp150_ = _tmp149_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp150_);
						_vala_code_node_unref0 (_tmp150_);
					}
				}
				_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp152_ = _tmp151_;
				if (_tmp152_ == NULL) {
					ValaSymbol* _tmp153_;
					_tmp153_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_TYPESYMBOL)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp154_ = sym;
				_tmp155_ = vala_symbol_get_parent_symbol (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = _vala_code_node_ref0 (_tmp156_);
				_vala_code_node_unref0 (sym);
				sym = _tmp157_;
			}
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			if (_tmp160_ == NULL) {
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp162_ = _tmp161_;
				_tmp158_ = _tmp162_ != NULL;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp163_;
					ValaSourceReference* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					ValaList* _tmp167_;
					gint _ns_size = 0;
					ValaList* _tmp168_;
					gint _tmp169_;
					gint _tmp170_;
					gint _ns_index = 0;
					_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_source_reference_get_using_directives (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = _vala_iterable_ref0 (_tmp166_);
					_ns_list = _tmp167_;
					_tmp168_ = _ns_list;
					_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
					_tmp170_ = _tmp169_;
					_ns_size = _tmp170_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp171_;
						gint _tmp172_;
						gint _tmp173_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp174_;
						gint _tmp175_;
						gpointer _tmp176_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp177_;
						ValaSymbol* _tmp178_;
						ValaSymbol* _tmp179_;
						ValaScope* _tmp180_;
						ValaScope* _tmp181_;
						const gchar* _tmp182_;
						ValaSymbol* _tmp183_;
						ValaSymbol* _tmp184_;
						_tmp171_ = _ns_index;
						_ns_index = _tmp171_ + 1;
						_tmp172_ = _ns_index;
						_tmp173_ = _ns_size;
						if (!(_tmp172_ < _tmp173_)) {
							break;
						}
						_tmp174_ = _ns_list;
						_tmp175_ = _ns_index;
						_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
						ns = (ValaUsingDirective*) _tmp176_;
						_tmp177_ = ns;
						_tmp178_ = vala_using_directive_get_namespace_symbol (_tmp177_);
						_tmp179_ = _tmp178_;
						_tmp180_ = vala_symbol_get_scope (_tmp179_);
						_tmp181_ = _tmp180_;
						_tmp182_ = self->priv->_member_name;
						_tmp183_ = vala_scope_lookup (_tmp181_, _tmp182_);
						local_sym = _tmp183_;
						_tmp184_ = local_sym;
						if (_tmp184_ != NULL) {
							gboolean _tmp185_ = FALSE;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp203_;
							_tmp186_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp187_ = _tmp186_;
							if (_tmp187_ != NULL) {
								ValaSymbol* _tmp188_;
								ValaSymbol* _tmp189_;
								ValaSymbol* _tmp190_;
								_tmp188_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp189_ = _tmp188_;
								_tmp190_ = local_sym;
								_tmp185_ = _tmp189_ != _tmp190_;
							} else {
								_tmp185_ = FALSE;
							}
							if (_tmp185_) {
								ValaSourceReference* _tmp191_;
								ValaSourceReference* _tmp192_;
								const gchar* _tmp193_;
								ValaSymbol* _tmp194_;
								ValaSymbol* _tmp195_;
								gchar* _tmp196_;
								gchar* _tmp197_;
								ValaSymbol* _tmp198_;
								gchar* _tmp199_;
								gchar* _tmp200_;
								gchar* _tmp201_;
								gchar* _tmp202_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp192_ = _tmp191_;
								_tmp193_ = self->priv->_member_name;
								_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_symbol_get_full_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = local_sym;
								_tmp199_ = vala_symbol_get_full_name (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp201_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp193_, _tmp197_, _tmp200_);
								_tmp202_ = _tmp201_;
								vala_report_error (_tmp192_, _tmp202_);
								_g_free0 (_tmp202_);
								_g_free0 (_tmp200_);
								_g_free0 (_tmp197_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp203_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp203_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp204_;
			ValaExpression* _tmp205_;
			gboolean _tmp206_;
			gboolean _tmp207_;
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			ValaDataType* _tmp210_;
			ValaDataType* _tmp211_;
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			gboolean _tmp247_ = FALSE;
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp271_ = FALSE;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			gboolean _tmp308_ = FALSE;
			gboolean _tmp309_ = FALSE;
			ValaSymbol* _tmp310_;
			ValaSymbol* _tmp311_;
			_tmp204_ = vala_member_access_get_inner (self);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_code_node_get_error ((ValaCodeNode*) _tmp205_);
			_tmp207_ = _tmp206_;
			if (_tmp207_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_expression_get_value_type (_tmp209_);
			_tmp211_ = _tmp210_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_POINTER_TYPE)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp212_;
				ValaExpression* _tmp213_;
				ValaDataType* _tmp214_;
				ValaDataType* _tmp215_;
				ValaPointerType* _tmp216_;
				gboolean _tmp217_ = FALSE;
				ValaPointerType* _tmp218_;
				_tmp212_ = vala_member_access_get_inner (self);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_expression_get_value_type (_tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp215_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp215_) : NULL);
				pointer_type = _tmp216_;
				_tmp218_ = pointer_type;
				if (_tmp218_ != NULL) {
					ValaPointerType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					_tmp219_ = pointer_type;
					_tmp220_ = vala_pointer_type_get_base_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp217_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_VALUE_TYPE);
				} else {
					_tmp217_ = FALSE;
				}
				if (_tmp217_) {
					ValaExpression* _tmp222_;
					ValaExpression* _tmp223_;
					ValaSourceReference* _tmp224_;
					ValaSourceReference* _tmp225_;
					ValaPointerIndirection* _tmp226_;
					ValaPointerIndirection* _tmp227_;
					ValaExpression* _tmp228_;
					ValaExpression* _tmp229_;
					_tmp222_ = vala_member_access_get_inner (self);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_pointer_indirection_new (_tmp223_, _tmp225_);
					_tmp227_ = _tmp226_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp227_);
					_vala_code_node_unref0 (_tmp227_);
					_tmp228_ = vala_member_access_get_inner (self);
					_tmp229_ = _tmp228_;
					vala_code_node_check ((ValaCodeNode*) _tmp229_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp230_ = vala_member_access_get_inner (self);
			_tmp231_ = _tmp230_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp231_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp232_;
				ValaExpression* _tmp233_;
				ValaMemberAccess* _tmp234_;
				ValaMemberAccess* _tmp235_;
				gboolean _tmp236_;
				_tmp232_ = vala_member_access_get_inner (self);
				_tmp233_ = _tmp232_;
				_tmp234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp233_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp234_;
				_tmp235_ = ma;
				_tmp236_ = _tmp235_->priv->_prototype_access;
				if (_tmp236_) {
					ValaSourceReference* _tmp237_;
					ValaSourceReference* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSymbol* _tmp241_;
					ValaSymbol* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp238_ = _tmp237_;
					_tmp239_ = vala_member_access_get_inner (self);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_symbol_get_full_name (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp244_);
					_tmp246_ = _tmp245_;
					vala_report_error (_tmp238_, _tmp246_);
					_g_free0 (_tmp246_);
					_g_free0 (_tmp244_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp249_, VALA_TYPE_MEMBER_ACCESS)) {
				_tmp247_ = TRUE;
			} else {
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				_tmp250_ = vala_member_access_get_inner (self);
				_tmp251_ = _tmp250_;
				_tmp247_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp251_, VALA_TYPE_BASE_ACCESS);
			}
			if (_tmp247_) {
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaSymbol* _tmp254_;
				ValaSymbol* _tmp255_;
				ValaSymbol* _tmp256_;
				gboolean _tmp257_ = FALSE;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_expression_get_symbol_reference (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = _vala_code_node_ref0 (_tmp255_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp256_;
				_tmp258_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp259_ = _tmp258_;
				if (_tmp259_ == NULL) {
					gboolean _tmp260_ = FALSE;
					ValaSymbol* _tmp261_;
					_tmp261_ = base_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_NAMESPACE)) {
						_tmp260_ = TRUE;
					} else {
						ValaSymbol* _tmp262_;
						_tmp262_ = base_symbol;
						_tmp260_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp262_, VALA_TYPE_TYPESYMBOL);
					}
					_tmp257_ = _tmp260_;
				} else {
					_tmp257_ = FALSE;
				}
				if (_tmp257_) {
					ValaSymbol* _tmp263_;
					ValaScope* _tmp264_;
					ValaScope* _tmp265_;
					const gchar* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaSymbol* _tmp268_;
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					_tmp263_ = base_symbol;
					_tmp264_ = vala_symbol_get_scope (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = self->priv->_member_name;
					_tmp267_ = vala_scope_lookup (_tmp265_, _tmp266_);
					_tmp268_ = _tmp267_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp268_);
					_vala_code_node_unref0 (_tmp268_);
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp270_, VALA_TYPE_BASE_ACCESS)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp272_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp273_ = _tmp272_;
			if (_tmp273_ == NULL) {
				ValaExpression* _tmp274_;
				ValaExpression* _tmp275_;
				ValaDataType* _tmp276_;
				ValaDataType* _tmp277_;
				_tmp274_ = vala_member_access_get_inner (self);
				_tmp275_ = _tmp274_;
				_tmp276_ = vala_expression_get_value_type (_tmp275_);
				_tmp277_ = _tmp276_;
				_tmp271_ = _tmp277_ != NULL;
			} else {
				_tmp271_ = FALSE;
			}
			if (_tmp271_) {
				gboolean _tmp278_;
				ValaSymbol* _tmp306_;
				ValaSymbol* _tmp307_;
				_tmp278_ = self->priv->_pointer_member_access;
				if (_tmp278_) {
					ValaExpression* _tmp279_;
					ValaExpression* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					const gchar* _tmp283_;
					ValaSymbol* _tmp284_;
					ValaSymbol* _tmp285_;
					_tmp279_ = vala_member_access_get_inner (self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_expression_get_value_type (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = self->priv->_member_name;
					_tmp284_ = vala_data_type_get_pointer_member (_tmp282_, _tmp283_);
					_tmp285_ = _tmp284_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp285_);
					_vala_code_node_unref0 (_tmp285_);
				} else {
					ValaExpression* _tmp286_;
					ValaExpression* _tmp287_;
					ValaDataType* _tmp288_;
					ValaDataType* _tmp289_;
					ValaTypeSymbol* _tmp290_;
					ValaTypeSymbol* _tmp291_;
					ValaExpression* _tmp299_;
					ValaExpression* _tmp300_;
					ValaDataType* _tmp301_;
					ValaDataType* _tmp302_;
					const gchar* _tmp303_;
					ValaSymbol* _tmp304_;
					ValaSymbol* _tmp305_;
					_tmp286_ = vala_member_access_get_inner (self);
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_expression_get_value_type (_tmp287_);
					_tmp289_ = _tmp288_;
					_tmp290_ = vala_data_type_get_data_type (_tmp289_);
					_tmp291_ = _tmp290_;
					if (_tmp291_ != NULL) {
						ValaExpression* _tmp292_;
						ValaExpression* _tmp293_;
						ValaDataType* _tmp294_;
						ValaDataType* _tmp295_;
						ValaTypeSymbol* _tmp296_;
						ValaTypeSymbol* _tmp297_;
						ValaSymbol* _tmp298_;
						_tmp292_ = vala_member_access_get_inner (self);
						_tmp293_ = _tmp292_;
						_tmp294_ = vala_expression_get_value_type (_tmp293_);
						_tmp295_ = _tmp294_;
						_tmp296_ = vala_data_type_get_data_type (_tmp295_);
						_tmp297_ = _tmp296_;
						_tmp298_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp297_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp298_;
					}
					_tmp299_ = vala_member_access_get_inner (self);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_expression_get_value_type (_tmp300_);
					_tmp302_ = _tmp301_;
					_tmp303_ = self->priv->_member_name;
					_tmp304_ = vala_data_type_get_member (_tmp302_, _tmp303_);
					_tmp305_ = _tmp304_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp305_);
					_vala_code_node_unref0 (_tmp305_);
				}
				_tmp306_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp307_ = _tmp306_;
				if (_tmp307_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp310_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp311_ = _tmp310_;
			if (_tmp311_ == NULL) {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp309_ = _tmp315_ != NULL;
			} else {
				_tmp309_ = FALSE;
			}
			if (_tmp309_) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				gboolean _tmp320_;
				gboolean _tmp321_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_expression_get_value_type (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_data_type_get_is_dynamic (_tmp319_);
				_tmp321_ = _tmp320_;
				_tmp308_ = _tmp321_;
			} else {
				_tmp308_ = FALSE;
			}
			if (_tmp308_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				ValaObjectType* _tmp326_;
				ValaCodeNode* _tmp327_;
				ValaCodeNode* _tmp328_;
				ValaSymbol* _tmp505_;
				ValaSymbol* _tmp506_;
				ValaSymbol* _tmp555_;
				ValaSymbol* _tmp556_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_value_type (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp326_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp326_;
				_tmp327_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp328_ = _tmp327_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp328_, VALA_TYPE_METHOD_CALL)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp329_;
					ValaCodeNode* _tmp330_;
					ValaMethodCall* _tmp331_;
					ValaMethodCall* _tmp332_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					_tmp329_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp330_ = _tmp329_;
					_tmp331_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp331_;
					_tmp332_ = invoc;
					_tmp333_ = vala_method_call_get_call (_tmp332_);
					_tmp334_ = _tmp333_;
					if (_tmp334_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp335_;
						ValaDataType* _tmp336_;
						ValaDataType* _tmp337_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp352_;
						ValaExpression* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDataType* _tmp355_;
						const gchar* _tmp356_;
						ValaDataType* _tmp357_;
						ValaSourceReference* _tmp358_;
						ValaSourceReference* _tmp359_;
						ValaDynamicMethod* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaMethodCall* _tmp362_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp363_;
						ValaErrorType* _tmp364_;
						ValaDynamicMethod* _tmp365_;
						ValaErrorType* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaParameter* _tmp369_;
						ValaParameter* _tmp370_;
						ValaObjectType* _tmp371_;
						ValaObjectTypeSymbol* _tmp372_;
						ValaObjectTypeSymbol* _tmp373_;
						ValaScope* _tmp374_;
						ValaScope* _tmp375_;
						ValaDynamicMethod* _tmp376_;
						ValaDynamicMethod* _tmp377_;
						_tmp335_ = invoc;
						_tmp336_ = vala_expression_get_target_type ((ValaExpression*) _tmp335_);
						_tmp337_ = _tmp336_;
						if (_tmp337_ != NULL) {
							ValaMethodCall* _tmp338_;
							ValaDataType* _tmp339_;
							ValaDataType* _tmp340_;
							ValaDataType* _tmp341_;
							ValaDataType* _tmp342_;
							_tmp338_ = invoc;
							_tmp339_ = vala_expression_get_target_type ((ValaExpression*) _tmp338_);
							_tmp340_ = _tmp339_;
							_tmp341_ = vala_data_type_copy (_tmp340_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp341_;
							_tmp342_ = ret_type;
							vala_data_type_set_value_owned (_tmp342_, TRUE);
						} else {
							ValaMethodCall* _tmp343_;
							ValaCodeNode* _tmp344_;
							ValaCodeNode* _tmp345_;
							_tmp343_ = invoc;
							_tmp344_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp343_);
							_tmp345_ = _tmp344_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp345_, VALA_TYPE_EXPRESSION_STATEMENT)) {
								ValaVoidType* _tmp346_;
								_tmp346_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp346_;
							} else {
								ValaExpression* _tmp347_;
								ValaExpression* _tmp348_;
								ValaDataType* _tmp349_;
								ValaDataType* _tmp350_;
								ValaDataType* _tmp351_;
								_tmp347_ = vala_member_access_get_inner (self);
								_tmp348_ = _tmp347_;
								_tmp349_ = vala_expression_get_value_type (_tmp348_);
								_tmp350_ = _tmp349_;
								_tmp351_ = vala_data_type_copy (_tmp350_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp351_;
							}
						}
						_tmp352_ = vala_member_access_get_inner (self);
						_tmp353_ = _tmp352_;
						_tmp354_ = vala_expression_get_value_type (_tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = self->priv->_member_name;
						_tmp357_ = ret_type;
						_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp359_ = _tmp358_;
						_tmp360_ = vala_dynamic_method_new (_tmp355_, _tmp356_, _tmp357_, _tmp359_, NULL);
						m = _tmp360_;
						_tmp361_ = m;
						_tmp362_ = invoc;
						vala_dynamic_method_set_invocation (_tmp361_, _tmp362_);
						_tmp363_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp363_;
						_tmp364_ = err;
						vala_error_type_set_dynamic_error (_tmp364_, TRUE);
						_tmp365_ = m;
						_tmp366_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp365_, (ValaDataType*) _tmp366_);
						_tmp367_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp367_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp368_ = m;
						_tmp369_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp370_ = _tmp369_;
						vala_callable_add_parameter ((ValaCallable*) _tmp368_, _tmp370_);
						_vala_code_node_unref0 (_tmp370_);
						_tmp371_ = dynamic_object_type;
						_tmp372_ = vala_object_type_get_type_symbol (_tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_symbol_get_scope ((ValaSymbol*) _tmp373_);
						_tmp375_ = _tmp374_;
						_tmp376_ = m;
						vala_scope_add (_tmp375_, NULL, (ValaSymbol*) _tmp376_);
						_tmp377_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp377_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp378_;
					ValaCodeNode* _tmp379_;
					_tmp378_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp379_ = _tmp378_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp379_, VALA_TYPE_ASSIGNMENT)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp380_;
						ValaCodeNode* _tmp381_;
						ValaAssignment* _tmp382_;
						gboolean _tmp383_ = FALSE;
						ValaAssignment* _tmp384_;
						ValaExpression* _tmp385_;
						ValaExpression* _tmp386_;
						_tmp380_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp381_ = _tmp380_;
						_tmp382_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp381_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp382_;
						_tmp384_ = a;
						_tmp385_ = vala_assignment_get_left (_tmp384_);
						_tmp386_ = _tmp385_;
						if (_tmp386_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp387_ = FALSE;
							ValaAssignment* _tmp388_;
							ValaAssignmentOperator _tmp389_;
							ValaAssignmentOperator _tmp390_;
							_tmp388_ = a;
							_tmp389_ = vala_assignment_get_operator (_tmp388_);
							_tmp390_ = _tmp389_;
							if (_tmp390_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp387_ = TRUE;
							} else {
								ValaAssignment* _tmp391_;
								ValaAssignmentOperator _tmp392_;
								ValaAssignmentOperator _tmp393_;
								_tmp391_ = a;
								_tmp392_ = vala_assignment_get_operator (_tmp391_);
								_tmp393_ = _tmp392_;
								_tmp387_ = _tmp393_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp383_ = _tmp387_;
						} else {
							_tmp383_ = FALSE;
						}
						if (_tmp383_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp394_;
							ValaExpression* _tmp395_;
							ValaDataType* _tmp396_;
							ValaDataType* _tmp397_;
							const gchar* _tmp398_;
							ValaVoidType* _tmp399_;
							ValaVoidType* _tmp400_;
							ValaSourceReference* _tmp401_;
							ValaSourceReference* _tmp402_;
							ValaDynamicSignal* _tmp403_;
							ValaDynamicSignal* _tmp404_;
							ValaDynamicSignal* _tmp405_;
							ValaAssignment* _tmp406_;
							ValaExpression* _tmp407_;
							ValaExpression* _tmp408_;
							ValaDynamicSignal* _tmp409_;
							ValaObjectType* _tmp410_;
							ValaObjectTypeSymbol* _tmp411_;
							ValaObjectTypeSymbol* _tmp412_;
							ValaScope* _tmp413_;
							ValaScope* _tmp414_;
							ValaDynamicSignal* _tmp415_;
							ValaDynamicSignal* _tmp416_;
							_tmp394_ = vala_member_access_get_inner (self);
							_tmp395_ = _tmp394_;
							_tmp396_ = vala_expression_get_value_type (_tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = self->priv->_member_name;
							_tmp399_ = vala_void_type_new (NULL);
							_tmp400_ = _tmp399_;
							_tmp401_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_dynamic_signal_new (_tmp397_, _tmp398_, (ValaDataType*) _tmp400_, _tmp402_, NULL);
							_tmp404_ = _tmp403_;
							_vala_code_node_unref0 (_tmp400_);
							s = _tmp404_;
							_tmp405_ = s;
							_tmp406_ = a;
							_tmp407_ = vala_assignment_get_right (_tmp406_);
							_tmp408_ = _tmp407_;
							vala_dynamic_signal_set_handler (_tmp405_, _tmp408_);
							_tmp409_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp409_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp410_ = dynamic_object_type;
							_tmp411_ = vala_object_type_get_type_symbol (_tmp410_);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_symbol_get_scope ((ValaSymbol*) _tmp412_);
							_tmp414_ = _tmp413_;
							_tmp415_ = s;
							vala_scope_add (_tmp414_, NULL, (ValaSymbol*) _tmp415_);
							_tmp416_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp416_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp417_;
							ValaExpression* _tmp418_;
							ValaExpression* _tmp419_;
							_tmp417_ = a;
							_tmp418_ = vala_assignment_get_left (_tmp417_);
							_tmp419_ = _tmp418_;
							if (_tmp419_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp420_;
								ValaExpression* _tmp421_;
								ValaDataType* _tmp422_;
								ValaDataType* _tmp423_;
								const gchar* _tmp424_;
								ValaSourceReference* _tmp425_;
								ValaSourceReference* _tmp426_;
								ValaDynamicProperty* _tmp427_;
								ValaDynamicProperty* _tmp428_;
								ValaDynamicProperty* _tmp429_;
								ValaDynamicProperty* _tmp430_;
								ValaSourceReference* _tmp431_;
								ValaSourceReference* _tmp432_;
								ValaPropertyAccessor* _tmp433_;
								ValaPropertyAccessor* _tmp434_;
								ValaDynamicProperty* _tmp435_;
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaTypeSymbol* _tmp440_;
								ValaTypeSymbol* _tmp441_;
								ValaScope* _tmp442_;
								ValaScope* _tmp443_;
								ValaObjectType* _tmp444_;
								ValaObjectTypeSymbol* _tmp445_;
								ValaObjectTypeSymbol* _tmp446_;
								ValaScope* _tmp447_;
								ValaScope* _tmp448_;
								ValaDynamicProperty* _tmp449_;
								ValaDynamicProperty* _tmp450_;
								_tmp420_ = vala_member_access_get_inner (self);
								_tmp421_ = _tmp420_;
								_tmp422_ = vala_expression_get_value_type (_tmp421_);
								_tmp423_ = _tmp422_;
								_tmp424_ = self->priv->_member_name;
								_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp426_ = _tmp425_;
								_tmp427_ = vala_dynamic_property_new (_tmp423_, _tmp424_, _tmp426_, NULL);
								prop = _tmp427_;
								_tmp428_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp428_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp429_ = prop;
								_tmp430_ = prop;
								_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp430_);
								_tmp432_ = _tmp431_;
								_tmp433_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp432_, NULL);
								_tmp434_ = _tmp433_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp429_, _tmp434_);
								_vala_code_node_unref0 (_tmp434_);
								_tmp435_ = prop;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_get_data_type (_tmp439_);
								_tmp441_ = _tmp440_;
								_tmp442_ = vala_symbol_get_scope ((ValaSymbol*) _tmp441_);
								_tmp443_ = _tmp442_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp435_, _tmp443_);
								_tmp444_ = dynamic_object_type;
								_tmp445_ = vala_object_type_get_type_symbol (_tmp444_);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_symbol_get_scope ((ValaSymbol*) _tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = prop;
								vala_scope_add (_tmp448_, NULL, (ValaSymbol*) _tmp449_);
								_tmp450_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp450_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp451_ = FALSE;
						gboolean _tmp452_ = FALSE;
						ValaCodeNode* _tmp453_;
						ValaCodeNode* _tmp454_;
						_tmp453_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp454_ = _tmp453_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_MEMBER_ACCESS)) {
							ValaExpression* _tmp455_;
							ValaExpression* _tmp456_;
							_tmp455_ = vala_member_access_get_inner (self);
							_tmp456_ = _tmp455_;
							_tmp452_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp456_, VALA_TYPE_MEMBER_ACCESS);
						} else {
							_tmp452_ = FALSE;
						}
						if (_tmp452_) {
							ValaCodeNode* _tmp457_;
							ValaCodeNode* _tmp458_;
							ValaCodeNode* _tmp459_;
							ValaCodeNode* _tmp460_;
							_tmp457_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp458_ = _tmp457_;
							_tmp459_ = vala_code_node_get_parent_node (_tmp458_);
							_tmp460_ = _tmp459_;
							_tmp451_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp460_, VALA_TYPE_METHOD_CALL);
						} else {
							_tmp451_ = FALSE;
						}
						if (_tmp451_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp461_;
							ValaCodeNode* _tmp462_;
							ValaMemberAccess* _tmp463_;
							gboolean _tmp464_ = FALSE;
							ValaMemberAccess* _tmp465_;
							const gchar* _tmp466_;
							_tmp461_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp462_ = _tmp461_;
							_tmp463_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp463_;
							_tmp465_ = ma;
							_tmp466_ = _tmp465_->priv->_member_name;
							if (g_strcmp0 (_tmp466_, "connect") == 0) {
								_tmp464_ = TRUE;
							} else {
								ValaMemberAccess* _tmp467_;
								const gchar* _tmp468_;
								_tmp467_ = ma;
								_tmp468_ = _tmp467_->priv->_member_name;
								_tmp464_ = g_strcmp0 (_tmp468_, "connect_after") == 0;
							}
							if (_tmp464_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp469_;
								ValaExpression* _tmp470_;
								ValaDataType* _tmp471_;
								ValaDataType* _tmp472_;
								const gchar* _tmp473_;
								ValaVoidType* _tmp474_;
								ValaVoidType* _tmp475_;
								ValaSourceReference* _tmp476_;
								ValaSourceReference* _tmp477_;
								ValaDynamicSignal* _tmp478_;
								ValaDynamicSignal* _tmp479_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp480_;
								ValaCodeNode* _tmp481_;
								ValaCodeNode* _tmp482_;
								ValaCodeNode* _tmp483_;
								ValaMethodCall* _tmp484_;
								ValaMethodCall* _tmp485_;
								ValaList* _tmp486_;
								ValaList* _tmp487_;
								gint _tmp488_;
								gint _tmp489_;
								gboolean _tmp490_;
								ValaDynamicSignal* _tmp497_;
								ValaObjectType* _tmp498_;
								ValaObjectTypeSymbol* _tmp499_;
								ValaObjectTypeSymbol* _tmp500_;
								ValaScope* _tmp501_;
								ValaScope* _tmp502_;
								ValaDynamicSignal* _tmp503_;
								ValaDynamicSignal* _tmp504_;
								_tmp469_ = vala_member_access_get_inner (self);
								_tmp470_ = _tmp469_;
								_tmp471_ = vala_expression_get_value_type (_tmp470_);
								_tmp472_ = _tmp471_;
								_tmp473_ = self->priv->_member_name;
								_tmp474_ = vala_void_type_new (NULL);
								_tmp475_ = _tmp474_;
								_tmp476_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp477_ = _tmp476_;
								_tmp478_ = vala_dynamic_signal_new (_tmp472_, _tmp473_, (ValaDataType*) _tmp475_, _tmp477_, NULL);
								_tmp479_ = _tmp478_;
								_vala_code_node_unref0 (_tmp475_);
								s = _tmp479_;
								_tmp480_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp481_ = _tmp480_;
								_tmp482_ = vala_code_node_get_parent_node (_tmp481_);
								_tmp483_ = _tmp482_;
								_tmp484_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp483_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp484_;
								_tmp485_ = mcall;
								_tmp486_ = vala_method_call_get_argument_list (_tmp485_);
								_tmp487_ = _tmp486_;
								_tmp488_ = vala_collection_get_size ((ValaCollection*) _tmp487_);
								_tmp489_ = _tmp488_;
								_tmp490_ = _tmp489_ > 0;
								_vala_iterable_unref0 (_tmp487_);
								if (_tmp490_) {
									ValaDynamicSignal* _tmp491_;
									ValaMethodCall* _tmp492_;
									ValaList* _tmp493_;
									ValaList* _tmp494_;
									gpointer _tmp495_;
									ValaExpression* _tmp496_;
									_tmp491_ = s;
									_tmp492_ = mcall;
									_tmp493_ = vala_method_call_get_argument_list (_tmp492_);
									_tmp494_ = _tmp493_;
									_tmp495_ = vala_list_get (_tmp494_, 0);
									_tmp496_ = (ValaExpression*) _tmp495_;
									vala_dynamic_signal_set_handler (_tmp491_, _tmp496_);
									_vala_code_node_unref0 (_tmp496_);
									_vala_iterable_unref0 (_tmp494_);
								}
								_tmp497_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp497_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp498_ = dynamic_object_type;
								_tmp499_ = vala_object_type_get_type_symbol (_tmp498_);
								_tmp500_ = _tmp499_;
								_tmp501_ = vala_symbol_get_scope ((ValaSymbol*) _tmp500_);
								_tmp502_ = _tmp501_;
								_tmp503_ = s;
								vala_scope_add (_tmp502_, NULL, (ValaSymbol*) _tmp503_);
								_tmp504_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp504_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp505_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp506_ = _tmp505_;
				if (_tmp506_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp507_;
					ValaExpression* _tmp508_;
					ValaDataType* _tmp509_;
					ValaDataType* _tmp510_;
					const gchar* _tmp511_;
					ValaSourceReference* _tmp512_;
					ValaSourceReference* _tmp513_;
					ValaDynamicProperty* _tmp514_;
					ValaDataType* _tmp515_;
					ValaDataType* _tmp516_;
					ValaDynamicProperty* _tmp527_;
					ValaDynamicProperty* _tmp528_;
					ValaDynamicProperty* _tmp529_;
					ValaDataType* _tmp530_;
					ValaDataType* _tmp531_;
					ValaDataType* _tmp532_;
					ValaDataType* _tmp533_;
					ValaDynamicProperty* _tmp534_;
					ValaSourceReference* _tmp535_;
					ValaSourceReference* _tmp536_;
					ValaPropertyAccessor* _tmp537_;
					ValaPropertyAccessor* _tmp538_;
					ValaDynamicProperty* _tmp539_;
					ValaExpression* _tmp540_;
					ValaExpression* _tmp541_;
					ValaDataType* _tmp542_;
					ValaDataType* _tmp543_;
					ValaTypeSymbol* _tmp544_;
					ValaTypeSymbol* _tmp545_;
					ValaScope* _tmp546_;
					ValaScope* _tmp547_;
					ValaObjectType* _tmp548_;
					ValaObjectTypeSymbol* _tmp549_;
					ValaObjectTypeSymbol* _tmp550_;
					ValaScope* _tmp551_;
					ValaScope* _tmp552_;
					ValaDynamicProperty* _tmp553_;
					ValaDynamicProperty* _tmp554_;
					_tmp507_ = vala_member_access_get_inner (self);
					_tmp508_ = _tmp507_;
					_tmp509_ = vala_expression_get_value_type (_tmp508_);
					_tmp510_ = _tmp509_;
					_tmp511_ = self->priv->_member_name;
					_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp513_ = _tmp512_;
					_tmp514_ = vala_dynamic_property_new (_tmp510_, _tmp511_, _tmp513_, NULL);
					prop = _tmp514_;
					_tmp515_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp516_ = _tmp515_;
					if (_tmp516_ != NULL) {
						ValaDynamicProperty* _tmp517_;
						ValaDataType* _tmp518_;
						ValaDataType* _tmp519_;
						_tmp517_ = prop;
						_tmp518_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp519_ = _tmp518_;
						vala_property_set_property_type ((ValaProperty*) _tmp517_, _tmp519_);
					} else {
						ValaDynamicProperty* _tmp520_;
						ValaExpression* _tmp521_;
						ValaExpression* _tmp522_;
						ValaDataType* _tmp523_;
						ValaDataType* _tmp524_;
						ValaDataType* _tmp525_;
						ValaDataType* _tmp526_;
						_tmp520_ = prop;
						_tmp521_ = vala_member_access_get_inner (self);
						_tmp522_ = _tmp521_;
						_tmp523_ = vala_expression_get_value_type (_tmp522_);
						_tmp524_ = _tmp523_;
						_tmp525_ = vala_data_type_copy (_tmp524_);
						_tmp526_ = _tmp525_;
						vala_property_set_property_type ((ValaProperty*) _tmp520_, _tmp526_);
						_vala_code_node_unref0 (_tmp526_);
					}
					_tmp527_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp527_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp528_ = prop;
					_tmp529_ = prop;
					_tmp530_ = vala_property_get_property_type ((ValaProperty*) _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = vala_data_type_copy (_tmp531_);
					_tmp533_ = _tmp532_;
					_tmp534_ = prop;
					_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp533_, NULL, _tmp536_, NULL);
					_tmp538_ = _tmp537_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp528_, _tmp538_);
					_vala_code_node_unref0 (_tmp538_);
					_vala_code_node_unref0 (_tmp533_);
					_tmp539_ = prop;
					_tmp540_ = vala_member_access_get_inner (self);
					_tmp541_ = _tmp540_;
					_tmp542_ = vala_expression_get_value_type (_tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = vala_data_type_get_data_type (_tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = vala_symbol_get_scope ((ValaSymbol*) _tmp545_);
					_tmp547_ = _tmp546_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp539_, _tmp547_);
					_tmp548_ = dynamic_object_type;
					_tmp549_ = vala_object_type_get_type_symbol (_tmp548_);
					_tmp550_ = _tmp549_;
					_tmp551_ = vala_symbol_get_scope ((ValaSymbol*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = prop;
					vala_scope_add (_tmp552_, NULL, (ValaSymbol*) _tmp553_);
					_tmp554_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp554_);
					_vala_code_node_unref0 (prop);
				}
				_tmp555_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp556_ = _tmp555_;
				if (_tmp556_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
		}
	}
	_tmp559_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp560_ = _tmp559_;
	if (_tmp560_ == NULL) {
		ValaDataType* _tmp561_;
		ValaDataType* _tmp562_;
		_tmp561_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp562_ = _tmp561_;
		_tmp558_ = _tmp562_ != NULL;
	} else {
		_tmp558_ = FALSE;
	}
	if (_tmp558_) {
		ValaDataType* _tmp563_;
		ValaDataType* _tmp564_;
		ValaTypeSymbol* _tmp565_;
		ValaTypeSymbol* _tmp566_;
		_tmp563_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp564_ = _tmp563_;
		_tmp565_ = vala_data_type_get_data_type (_tmp564_);
		_tmp566_ = _tmp565_;
		_tmp557_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp566_, VALA_TYPE_ENUM);
	} else {
		_tmp557_ = FALSE;
	}
	if (_tmp557_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp567_;
		ValaDataType* _tmp568_;
		ValaTypeSymbol* _tmp569_;
		ValaTypeSymbol* _tmp570_;
		ValaEnum* _tmp571_;
		_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp568_ = _tmp567_;
		_tmp569_ = vala_data_type_get_data_type (_tmp568_);
		_tmp570_ = _tmp569_;
		_tmp571_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp570_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp571_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp572_;
			ValaList* _tmp573_;
			gint _val_size = 0;
			ValaList* _tmp574_;
			gint _tmp575_;
			gint _tmp576_;
			gint _val_index = 0;
			_tmp572_ = enum_type;
			_tmp573_ = vala_enum_get_values (_tmp572_);
			_val_list = _tmp573_;
			_tmp574_ = _val_list;
			_tmp575_ = vala_collection_get_size ((ValaCollection*) _tmp574_);
			_tmp576_ = _tmp575_;
			_val_size = _tmp576_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp577_;
				gint _tmp578_;
				gint _tmp579_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp580_;
				gint _tmp581_;
				gpointer _tmp582_;
				const gchar* _tmp583_;
				ValaEnumValue* _tmp584_;
				const gchar* _tmp585_;
				const gchar* _tmp586_;
				_tmp577_ = _val_index;
				_val_index = _tmp577_ + 1;
				_tmp578_ = _val_index;
				_tmp579_ = _val_size;
				if (!(_tmp578_ < _tmp579_)) {
					break;
				}
				_tmp580_ = _val_list;
				_tmp581_ = _val_index;
				_tmp582_ = vala_list_get (_tmp580_, _tmp581_);
				val = (ValaEnumValue*) _tmp582_;
				_tmp583_ = self->priv->_member_name;
				_tmp584_ = val;
				_tmp585_ = vala_symbol_get_name ((ValaSymbol*) _tmp584_);
				_tmp586_ = _tmp585_;
				if (g_strcmp0 (_tmp583_, _tmp586_) == 0) {
					ValaEnumValue* _tmp587_;
					_tmp587_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp587_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp588_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp589_ = _tmp588_;
	if (_tmp589_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp590_;
		gboolean _tmp591_ = FALSE;
		ValaExpression* _tmp592_;
		ValaExpression* _tmp593_;
		ValaSourceReference* _tmp606_;
		ValaSourceReference* _tmp607_;
		const gchar* _tmp608_;
		const gchar* _tmp609_;
		gchar* _tmp610_;
		gchar* _tmp611_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp590_ = g_strdup ("(null)");
		base_type_name = _tmp590_;
		_tmp592_ = vala_member_access_get_inner (self);
		_tmp593_ = _tmp592_;
		if (_tmp593_ != NULL) {
			ValaExpression* _tmp594_;
			ValaExpression* _tmp595_;
			ValaDataType* _tmp596_;
			ValaDataType* _tmp597_;
			_tmp594_ = vala_member_access_get_inner (self);
			_tmp595_ = _tmp594_;
			_tmp596_ = vala_expression_get_value_type (_tmp595_);
			_tmp597_ = _tmp596_;
			_tmp591_ = _tmp597_ != NULL;
		} else {
			_tmp591_ = FALSE;
		}
		if (_tmp591_) {
			ValaExpression* _tmp598_;
			ValaExpression* _tmp599_;
			ValaDataType* _tmp600_;
			ValaDataType* _tmp601_;
			gchar* _tmp602_;
			_tmp598_ = vala_member_access_get_inner (self);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_expression_get_value_type (_tmp599_);
			_tmp601_ = _tmp600_;
			_tmp602_ = vala_code_node_to_string ((ValaCodeNode*) _tmp601_);
			_g_free0 (base_type_name);
			base_type_name = _tmp602_;
		} else {
			ValaSymbol* _tmp603_;
			_tmp603_ = base_symbol;
			if (_tmp603_ != NULL) {
				ValaSymbol* _tmp604_;
				gchar* _tmp605_;
				_tmp604_ = base_symbol;
				_tmp605_ = vala_symbol_get_full_name (_tmp604_);
				_g_free0 (base_type_name);
				base_type_name = _tmp605_;
			}
		}
		_tmp606_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp607_ = _tmp606_;
		_tmp608_ = self->priv->_member_name;
		_tmp609_ = base_type_name;
		_tmp610_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp608_, _tmp609_);
		_tmp611_ = _tmp610_;
		vala_report_error (_tmp607_, _tmp611_);
		_g_free0 (_tmp611_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp612_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp613_ = _tmp612_;
	_tmp614_ = _vala_code_node_ref0 (_tmp613_);
	member = _tmp614_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp615_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp615_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp616_ = member;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp616_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp617_;
		ValaLocalVariable* _tmp618_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp619_;
		ValaSymbol* _tmp620_;
		ValaSymbol* _tmp621_;
		ValaBlock* _tmp622_;
		gboolean _tmp623_ = FALSE;
		ValaBlock* _tmp624_;
		_tmp617_ = member;
		_tmp618_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp618_;
		_tmp619_ = local;
		_tmp620_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp619_);
		_tmp621_ = _tmp620_;
		_tmp622_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp621_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp621_) : NULL);
		block = _tmp622_;
		_tmp624_ = block;
		if (_tmp624_ != NULL) {
			ValaSemanticAnalyzer* _tmp625_;
			ValaSemanticAnalyzer* _tmp626_;
			ValaBlock* _tmp627_;
			ValaSymbol* _tmp628_;
			ValaSymbol* _tmp629_;
			ValaSemanticAnalyzer* _tmp630_;
			ValaSemanticAnalyzer* _tmp631_;
			ValaSymbol* _tmp632_;
			ValaSymbol* _tmp633_;
			_tmp625_ = vala_code_context_get_analyzer (context);
			_tmp626_ = _tmp625_;
			_tmp627_ = block;
			_tmp628_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp626_, (ValaSymbol*) _tmp627_);
			_tmp629_ = _tmp628_;
			_tmp630_ = vala_code_context_get_analyzer (context);
			_tmp631_ = _tmp630_;
			_tmp632_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp631_);
			_tmp633_ = _tmp632_;
			_tmp623_ = _tmp629_ != _tmp633_;
			_vala_code_node_unref0 (_tmp629_);
		} else {
			_tmp623_ = FALSE;
		}
		if (_tmp623_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp634_;
			ValaSemanticAnalyzer* _tmp635_;
			ValaSymbol* _tmp636_;
			ValaSymbol* _tmp637_;
			ValaSymbol* _tmp638_;
			ValaLocalVariable* _tmp651_;
			ValaBlock* _tmp652_;
			_tmp634_ = vala_code_context_get_analyzer (context);
			_tmp635_ = _tmp634_;
			_tmp636_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp635_);
			_tmp637_ = _tmp636_;
			_tmp638_ = _vala_code_node_ref0 (_tmp637_);
			sym = _tmp638_;
			while (TRUE) {
				ValaSymbol* _tmp639_;
				ValaBlock* _tmp640_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp641_;
				ValaMethod* _tmp642_;
				ValaMethod* _tmp643_;
				ValaSymbol* _tmp647_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				ValaSymbol* _tmp650_;
				_tmp639_ = sym;
				_tmp640_ = block;
				if (!(_tmp639_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp640_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp641_ = sym;
				_tmp642_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp641_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp641_) : NULL);
				method = _tmp642_;
				_tmp643_ = method;
				if (_tmp643_ != NULL) {
					ValaMethod* _tmp644_;
					ValaMethod* _tmp645_;
					ValaLocalVariable* _tmp646_;
					_tmp644_ = method;
					vala_method_set_closure (_tmp644_, TRUE);
					_tmp645_ = method;
					_tmp646_ = local;
					vala_method_add_captured_variable (_tmp645_, _tmp646_);
				}
				_tmp647_ = sym;
				_tmp648_ = vala_symbol_get_parent_symbol (_tmp647_);
				_tmp649_ = _tmp648_;
				_tmp650_ = _vala_code_node_ref0 (_tmp649_);
				_vala_code_node_unref0 (sym);
				sym = _tmp650_;
				_vala_code_node_unref0 (method);
			}
			_tmp651_ = local;
			vala_local_variable_set_captured (_tmp651_, TRUE);
			_tmp652_ = block;
			vala_block_set_captured (_tmp652_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp653_;
		_tmp653_ = member;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp653_, VALA_TYPE_PARAMETER)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp654_;
			ValaParameter* _tmp655_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp656_;
			ValaSymbol* _tmp657_;
			ValaSymbol* _tmp658_;
			ValaMethod* _tmp659_;
			gboolean _tmp660_ = FALSE;
			gboolean _tmp661_ = FALSE;
			ValaMethod* _tmp662_;
			_tmp654_ = member;
			_tmp655_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp654_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp655_;
			_tmp656_ = param;
			_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
			_tmp658_ = _tmp657_;
			_tmp659_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp658_) : NULL);
			m = _tmp659_;
			_tmp662_ = m;
			if (_tmp662_ != NULL) {
				ValaMethod* _tmp663_;
				ValaSemanticAnalyzer* _tmp664_;
				ValaSemanticAnalyzer* _tmp665_;
				ValaSymbol* _tmp666_;
				ValaSymbol* _tmp667_;
				_tmp663_ = m;
				_tmp664_ = vala_code_context_get_analyzer (context);
				_tmp665_ = _tmp664_;
				_tmp666_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp665_);
				_tmp667_ = _tmp666_;
				_tmp661_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp663_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp667_;
			} else {
				_tmp661_ = FALSE;
			}
			if (_tmp661_) {
				ValaParameter* _tmp668_;
				ValaMethod* _tmp669_;
				ValaParameter* _tmp670_;
				ValaParameter* _tmp671_;
				_tmp668_ = param;
				_tmp669_ = m;
				_tmp670_ = vala_method_get_this_parameter (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp660_ = _tmp668_ != _tmp671_;
			} else {
				_tmp660_ = FALSE;
			}
			if (_tmp660_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp672_;
				ValaSemanticAnalyzer* _tmp673_;
				ValaSymbol* _tmp674_;
				ValaSymbol* _tmp675_;
				ValaSymbol* _tmp676_;
				ValaParameter* _tmp687_;
				ValaMethod* _tmp688_;
				ValaBlock* _tmp689_;
				ValaBlock* _tmp690_;
				ValaParameter* _tmp691_;
				ValaParameterDirection _tmp692_;
				ValaParameterDirection _tmp693_;
				_tmp672_ = vala_code_context_get_analyzer (context);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp673_);
				_tmp675_ = _tmp674_;
				_tmp676_ = _vala_code_node_ref0 (_tmp675_);
				sym = _tmp676_;
				while (TRUE) {
					ValaSymbol* _tmp677_;
					ValaMethod* _tmp678_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp679_;
					ValaMethod* _tmp680_;
					ValaMethod* _tmp681_;
					ValaSymbol* _tmp683_;
					ValaSymbol* _tmp684_;
					ValaSymbol* _tmp685_;
					ValaSymbol* _tmp686_;
					_tmp677_ = sym;
					_tmp678_ = m;
					if (!(_tmp677_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp679_ = sym;
					_tmp680_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp679_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp679_) : NULL);
					method = _tmp680_;
					_tmp681_ = method;
					if (_tmp681_ != NULL) {
						ValaMethod* _tmp682_;
						_tmp682_ = method;
						vala_method_set_closure (_tmp682_, TRUE);
					}
					_tmp683_ = sym;
					_tmp684_ = vala_symbol_get_parent_symbol (_tmp683_);
					_tmp685_ = _tmp684_;
					_tmp686_ = _vala_code_node_ref0 (_tmp685_);
					_vala_code_node_unref0 (sym);
					sym = _tmp686_;
					_vala_code_node_unref0 (method);
				}
				_tmp687_ = param;
				vala_parameter_set_captured (_tmp687_, TRUE);
				_tmp688_ = m;
				_tmp689_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp688_);
				_tmp690_ = _tmp689_;
				vala_block_set_captured (_tmp690_, TRUE);
				_tmp691_ = param;
				_tmp692_ = vala_parameter_get_direction (_tmp691_);
				_tmp693_ = _tmp692_;
				if (_tmp693_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp694_;
					ValaSourceReference* _tmp695_;
					ValaParameter* _tmp696_;
					gchar* _tmp697_;
					gchar* _tmp698_;
					gchar* _tmp699_;
					gchar* _tmp700_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp694_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp695_ = _tmp694_;
					_tmp696_ = param;
					_tmp697_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp696_);
					_tmp698_ = _tmp697_;
					_tmp699_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp698_);
					_tmp700_ = _tmp699_;
					vala_report_error (_tmp695_, _tmp700_);
					_g_free0 (_tmp700_);
					_g_free0 (_tmp698_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp701_;
				ValaSymbol* _tmp702_;
				ValaSymbol* _tmp703_;
				ValaSymbol* _tmp704_;
				ValaSymbol* _tmp705_;
				ValaPropertyAccessor* _tmp706_;
				gboolean _tmp707_ = FALSE;
				gboolean _tmp708_ = FALSE;
				ValaPropertyAccessor* _tmp709_;
				_tmp701_ = param;
				_tmp702_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp701_);
				_tmp703_ = _tmp702_;
				_tmp704_ = vala_symbol_get_parent_symbol (_tmp703_);
				_tmp705_ = _tmp704_;
				_tmp706_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp705_, VALA_TYPE_PROPERTY_ACCESSOR) ? ((ValaPropertyAccessor*) _tmp705_) : NULL);
				acc = _tmp706_;
				_tmp709_ = acc;
				if (_tmp709_ != NULL) {
					ValaPropertyAccessor* _tmp710_;
					ValaSemanticAnalyzer* _tmp711_;
					ValaSemanticAnalyzer* _tmp712_;
					ValaSymbol* _tmp713_;
					ValaSymbol* _tmp714_;
					_tmp710_ = acc;
					_tmp711_ = vala_code_context_get_analyzer (context);
					_tmp712_ = _tmp711_;
					_tmp713_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp712_);
					_tmp714_ = _tmp713_;
					_tmp708_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp710_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp714_;
				} else {
					_tmp708_ = FALSE;
				}
				if (_tmp708_) {
					ValaParameter* _tmp715_;
					ValaPropertyAccessor* _tmp716_;
					ValaProperty* _tmp717_;
					ValaProperty* _tmp718_;
					ValaParameter* _tmp719_;
					ValaParameter* _tmp720_;
					_tmp715_ = param;
					_tmp716_ = acc;
					_tmp717_ = vala_property_accessor_get_prop (_tmp716_);
					_tmp718_ = _tmp717_;
					_tmp719_ = vala_property_get_this_parameter (_tmp718_);
					_tmp720_ = _tmp719_;
					_tmp707_ = _tmp715_ != _tmp720_;
				} else {
					_tmp707_ = FALSE;
				}
				if (_tmp707_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp721_;
					ValaSemanticAnalyzer* _tmp722_;
					ValaSymbol* _tmp723_;
					ValaSymbol* _tmp724_;
					ValaSymbol* _tmp725_;
					ValaParameter* _tmp736_;
					ValaPropertyAccessor* _tmp737_;
					ValaBlock* _tmp738_;
					ValaBlock* _tmp739_;
					_tmp721_ = vala_code_context_get_analyzer (context);
					_tmp722_ = _tmp721_;
					_tmp723_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp722_);
					_tmp724_ = _tmp723_;
					_tmp725_ = _vala_code_node_ref0 (_tmp724_);
					sym = _tmp725_;
					while (TRUE) {
						ValaSymbol* _tmp726_;
						ValaMethod* _tmp727_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp728_;
						ValaMethod* _tmp729_;
						ValaMethod* _tmp730_;
						ValaSymbol* _tmp732_;
						ValaSymbol* _tmp733_;
						ValaSymbol* _tmp734_;
						ValaSymbol* _tmp735_;
						_tmp726_ = sym;
						_tmp727_ = m;
						if (!(_tmp726_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp727_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp728_ = sym;
						_tmp729_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp728_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp728_) : NULL);
						method = _tmp729_;
						_tmp730_ = method;
						if (_tmp730_ != NULL) {
							ValaMethod* _tmp731_;
							_tmp731_ = method;
							vala_method_set_closure (_tmp731_, TRUE);
						}
						_tmp732_ = sym;
						_tmp733_ = vala_symbol_get_parent_symbol (_tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = _vala_code_node_ref0 (_tmp734_);
						_vala_code_node_unref0 (sym);
						sym = _tmp735_;
						_vala_code_node_unref0 (method);
					}
					_tmp736_ = param;
					vala_parameter_set_captured (_tmp736_, TRUE);
					_tmp737_ = acc;
					_tmp738_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp737_);
					_tmp739_ = _tmp738_;
					vala_block_set_captured (_tmp739_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp740_;
			_tmp740_ = member;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp740_, VALA_TYPE_FIELD)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp741_;
				ValaField* _tmp742_;
				ValaField* _tmp743_;
				ValaSymbolAccessibility _tmp744_;
				ValaSymbolAccessibility _tmp745_;
				ValaField* _tmp746_;
				ValaMemberBinding _tmp747_;
				ValaMemberBinding _tmp748_;
				ValaField* _tmp749_;
				ValaMemberBinding _tmp750_;
				ValaMemberBinding _tmp751_;
				ValaField* _tmp752_;
				ValaDataType* _tmp753_;
				ValaDataType* _tmp754_;
				_tmp741_ = member;
				_tmp742_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp741_, VALA_TYPE_FIELD, ValaField));
				f = _tmp742_;
				_tmp743_ = f;
				_tmp744_ = vala_symbol_get_access ((ValaSymbol*) _tmp743_);
				_tmp745_ = _tmp744_;
				access = _tmp745_;
				_tmp746_ = f;
				_tmp747_ = vala_field_get_binding (_tmp746_);
				_tmp748_ = _tmp747_;
				instance = _tmp748_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp749_ = f;
				_tmp750_ = vala_field_get_binding (_tmp749_);
				_tmp751_ = _tmp750_;
				klass = _tmp751_ == VALA_MEMBER_BINDING_CLASS;
				_tmp752_ = f;
				_tmp753_ = vala_variable_get_variable_type ((ValaVariable*) _tmp752_);
				_tmp754_ = _tmp753_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp754_, VALA_TYPE_GENERIC_TYPE)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp755_;
				_tmp755_ = member;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp755_, VALA_TYPE_CONSTANT)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp756_;
					ValaConstant* _tmp757_;
					ValaConstant* _tmp758_;
					ValaSymbolAccessibility _tmp759_;
					ValaSymbolAccessibility _tmp760_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp761_;
					ValaSymbol* _tmp762_;
					ValaSymbol* _tmp763_;
					ValaBlock* _tmp764_;
					gboolean _tmp765_ = FALSE;
					ValaBlock* _tmp766_;
					_tmp756_ = member;
					_tmp757_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp756_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp757_;
					_tmp758_ = c;
					_tmp759_ = vala_symbol_get_access ((ValaSymbol*) _tmp758_);
					_tmp760_ = _tmp759_;
					access = _tmp760_;
					_tmp761_ = c;
					_tmp762_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp761_);
					_tmp763_ = _tmp762_;
					_tmp764_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp763_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp763_) : NULL);
					block = _tmp764_;
					_tmp766_ = block;
					if (_tmp766_ != NULL) {
						ValaSemanticAnalyzer* _tmp767_;
						ValaSemanticAnalyzer* _tmp768_;
						ValaBlock* _tmp769_;
						ValaSymbol* _tmp770_;
						ValaSymbol* _tmp771_;
						ValaSemanticAnalyzer* _tmp772_;
						ValaSemanticAnalyzer* _tmp773_;
						ValaSymbol* _tmp774_;
						ValaSymbol* _tmp775_;
						_tmp767_ = vala_code_context_get_analyzer (context);
						_tmp768_ = _tmp767_;
						_tmp769_ = block;
						_tmp770_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp768_, (ValaSymbol*) _tmp769_);
						_tmp771_ = _tmp770_;
						_tmp772_ = vala_code_context_get_analyzer (context);
						_tmp773_ = _tmp772_;
						_tmp774_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp773_);
						_tmp775_ = _tmp774_;
						_tmp765_ = _tmp771_ != _tmp775_;
						_vala_code_node_unref0 (_tmp771_);
					} else {
						_tmp765_ = FALSE;
					}
					if (_tmp765_) {
						ValaSourceReference* _tmp776_;
						ValaSourceReference* _tmp777_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp776_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp777_ = _tmp776_;
						vala_report_error (_tmp777_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp778_;
					_tmp778_ = member;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp778_, VALA_TYPE_METHOD)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp779_;
						ValaMethod* _tmp780_;
						ValaMethod* _tmp781_;
						gboolean _tmp782_;
						gboolean _tmp783_;
						ValaMethod* _tmp886_;
						ValaSymbolAccessibility _tmp887_;
						ValaSymbolAccessibility _tmp888_;
						ValaMethod* _tmp889_;
						ValaMethod* _tmp893_;
						ValaMemberBinding _tmp894_;
						ValaMemberBinding _tmp895_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp918_;
						ValaDataType* _tmp919_;
						ValaDataType* _tmp920_;
						ValaGenericType* _tmp921_;
						gboolean _tmp922_ = FALSE;
						ValaGenericType* _tmp923_;
						_tmp779_ = member;
						_tmp780_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp779_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp780_;
						_tmp781_ = m;
						_tmp782_ = vala_method_get_is_async_callback (_tmp781_);
						_tmp783_ = _tmp782_;
						if (_tmp783_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp784_;
							ValaSemanticAnalyzer* _tmp785_;
							ValaMethod* _tmp786_;
							ValaMethod* _tmp787_;
							ValaMethod* _tmp788_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp789_;
							gboolean _tmp815_;
							ValaMethod* _tmp823_;
							ValaSemanticAnalyzer* _tmp824_;
							ValaSemanticAnalyzer* _tmp825_;
							ValaMethod* _tmp826_;
							ValaMethod* _tmp827_;
							ValaMethod* _tmp846_;
							ValaMethod* _tmp847_;
							ValaMethod* _tmp848_;
							ValaSymbol* _tmp849_;
							ValaSymbol* _tmp850_;
							ValaSymbol* _tmp851_;
							_tmp784_ = vala_code_context_get_analyzer (context);
							_tmp785_ = _tmp784_;
							_tmp786_ = vala_semantic_analyzer_get_current_async_method (_tmp785_);
							_tmp787_ = _tmp786_;
							_tmp788_ = _vala_code_node_ref0 (_tmp787_);
							async_method = _tmp788_;
							is_valid_access = FALSE;
							_tmp789_ = async_method;
							if (_tmp789_ != NULL) {
								ValaMethod* _tmp790_;
								ValaMethod* _tmp791_;
								ValaMethod* _tmp792_;
								ValaMethod* _tmp793_;
								gboolean _tmp794_;
								_tmp790_ = m;
								_tmp791_ = async_method;
								_tmp792_ = vala_method_get_callback_method (_tmp791_);
								_tmp793_ = _tmp792_;
								_tmp794_ = _tmp790_ == _tmp793_;
								_vala_code_node_unref0 (_tmp793_);
								if (_tmp794_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp795_ = FALSE;
									ValaMethod* _tmp796_;
									ValaMethod* _tmp797_;
									ValaMethod* _tmp798_;
									_tmp796_ = async_method;
									_tmp797_ = vala_method_get_base_method (_tmp796_);
									_tmp798_ = _tmp797_;
									if (_tmp798_ != NULL) {
										ValaMethod* _tmp799_;
										ValaMethod* _tmp800_;
										ValaMethod* _tmp801_;
										ValaMethod* _tmp802_;
										ValaMethod* _tmp803_;
										ValaMethod* _tmp804_;
										_tmp799_ = m;
										_tmp800_ = async_method;
										_tmp801_ = vala_method_get_base_method (_tmp800_);
										_tmp802_ = _tmp801_;
										_tmp803_ = vala_method_get_callback_method (_tmp802_);
										_tmp804_ = _tmp803_;
										_tmp795_ = _tmp799_ == _tmp804_;
										_vala_code_node_unref0 (_tmp804_);
									} else {
										_tmp795_ = FALSE;
									}
									if (_tmp795_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp805_ = FALSE;
										ValaMethod* _tmp806_;
										ValaMethod* _tmp807_;
										ValaMethod* _tmp808_;
										_tmp806_ = async_method;
										_tmp807_ = vala_method_get_base_interface_method (_tmp806_);
										_tmp808_ = _tmp807_;
										if (_tmp808_ != NULL) {
											ValaMethod* _tmp809_;
											ValaMethod* _tmp810_;
											ValaMethod* _tmp811_;
											ValaMethod* _tmp812_;
											ValaMethod* _tmp813_;
											ValaMethod* _tmp814_;
											_tmp809_ = m;
											_tmp810_ = async_method;
											_tmp811_ = vala_method_get_base_interface_method (_tmp810_);
											_tmp812_ = _tmp811_;
											_tmp813_ = vala_method_get_callback_method (_tmp812_);
											_tmp814_ = _tmp813_;
											_tmp805_ = _tmp809_ == _tmp814_;
											_vala_code_node_unref0 (_tmp814_);
										} else {
											_tmp805_ = FALSE;
										}
										if (_tmp805_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp815_ = is_valid_access;
							if (!_tmp815_) {
								ValaSourceReference* _tmp816_;
								ValaSourceReference* _tmp817_;
								ValaMethod* _tmp818_;
								gchar* _tmp819_;
								gchar* _tmp820_;
								gchar* _tmp821_;
								gchar* _tmp822_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp816_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp817_ = _tmp816_;
								_tmp818_ = m;
								_tmp819_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp818_);
								_tmp820_ = _tmp819_;
								_tmp821_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp820_);
								_tmp822_ = _tmp821_;
								vala_report_error (_tmp817_, _tmp822_);
								_g_free0 (_tmp822_);
								_g_free0 (_tmp820_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp823_ = async_method;
							_tmp824_ = vala_code_context_get_analyzer (context);
							_tmp825_ = _tmp824_;
							_tmp826_ = vala_semantic_analyzer_get_current_method (_tmp825_);
							_tmp827_ = _tmp826_;
							if (_tmp823_ != _tmp827_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp828_;
								ValaSemanticAnalyzer* _tmp829_;
								ValaMethod* _tmp830_;
								ValaMethod* _tmp831_;
								ValaSymbol* _tmp832_;
								ValaMethod* _tmp843_;
								ValaBlock* _tmp844_;
								ValaBlock* _tmp845_;
								_tmp828_ = vala_code_context_get_analyzer (context);
								_tmp829_ = _tmp828_;
								_tmp830_ = vala_semantic_analyzer_get_current_method (_tmp829_);
								_tmp831_ = _tmp830_;
								_tmp832_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp831_);
								sym = _tmp832_;
								while (TRUE) {
									ValaSymbol* _tmp833_;
									ValaMethod* _tmp834_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp835_;
									ValaMethod* _tmp836_;
									ValaMethod* _tmp837_;
									ValaSymbol* _tmp839_;
									ValaSymbol* _tmp840_;
									ValaSymbol* _tmp841_;
									ValaSymbol* _tmp842_;
									_tmp833_ = sym;
									_tmp834_ = async_method;
									if (!(_tmp833_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp834_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp835_ = sym;
									_tmp836_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp835_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp835_) : NULL);
									method = _tmp836_;
									_tmp837_ = method;
									if (_tmp837_ != NULL) {
										ValaMethod* _tmp838_;
										_tmp838_ = method;
										vala_method_set_closure (_tmp838_, TRUE);
									}
									_tmp839_ = sym;
									_tmp840_ = vala_symbol_get_parent_symbol (_tmp839_);
									_tmp841_ = _tmp840_;
									_tmp842_ = _vala_code_node_ref0 (_tmp841_);
									_vala_code_node_unref0 (sym);
									sym = _tmp842_;
									_vala_code_node_unref0 (method);
								}
								_tmp843_ = async_method;
								_tmp844_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp843_);
								_tmp845_ = _tmp844_;
								vala_block_set_captured (_tmp845_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp846_ = async_method;
							_tmp847_ = vala_method_get_callback_method (_tmp846_);
							_vala_code_node_unref0 (m);
							m = _tmp847_;
							_tmp848_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp848_);
							_tmp849_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp850_ = _tmp849_;
							_tmp851_ = _vala_code_node_ref0 (_tmp850_);
							_vala_code_node_unref0 (member);
							member = _tmp851_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp852_;
							ValaMethod* _tmp853_;
							ValaMethod* _tmp854_;
							_tmp852_ = m;
							_tmp853_ = vala_method_get_base_method (_tmp852_);
							_tmp854_ = _tmp853_;
							if (_tmp854_ != NULL) {
								ValaMethod* _tmp855_;
								ValaMethod* _tmp856_;
								ValaMethod* _tmp857_;
								ValaMethod* _tmp858_;
								ValaMethod* _tmp859_;
								ValaSignal* _tmp860_;
								ValaSignal* _tmp861_;
								ValaSymbol* _tmp866_;
								ValaSymbol* _tmp867_;
								ValaSymbol* _tmp868_;
								_tmp855_ = m;
								_tmp856_ = vala_method_get_base_method (_tmp855_);
								_tmp857_ = _tmp856_;
								_tmp858_ = _vala_code_node_ref0 (_tmp857_);
								_vala_code_node_unref0 (m);
								m = _tmp858_;
								_tmp859_ = m;
								_tmp860_ = vala_method_get_signal_reference (_tmp859_);
								_tmp861_ = _tmp860_;
								if (_tmp861_ != NULL) {
									ValaMethod* _tmp862_;
									ValaSignal* _tmp863_;
									ValaSignal* _tmp864_;
									_tmp862_ = m;
									_tmp863_ = vala_method_get_signal_reference (_tmp862_);
									_tmp864_ = _tmp863_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp864_);
								} else {
									ValaMethod* _tmp865_;
									_tmp865_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp865_);
								}
								_tmp866_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp867_ = _tmp866_;
								_tmp868_ = _vala_code_node_ref0 (_tmp867_);
								_vala_code_node_unref0 (member);
								member = _tmp868_;
							} else {
								ValaMethod* _tmp869_;
								ValaMethod* _tmp870_;
								ValaMethod* _tmp871_;
								_tmp869_ = m;
								_tmp870_ = vala_method_get_base_interface_method (_tmp869_);
								_tmp871_ = _tmp870_;
								if (_tmp871_ != NULL) {
									ValaMethod* _tmp872_;
									ValaMethod* _tmp873_;
									ValaMethod* _tmp874_;
									ValaMethod* _tmp875_;
									ValaMethod* _tmp876_;
									ValaSignal* _tmp877_;
									ValaSignal* _tmp878_;
									ValaSymbol* _tmp883_;
									ValaSymbol* _tmp884_;
									ValaSymbol* _tmp885_;
									_tmp872_ = m;
									_tmp873_ = vala_method_get_base_interface_method (_tmp872_);
									_tmp874_ = _tmp873_;
									_tmp875_ = _vala_code_node_ref0 (_tmp874_);
									_vala_code_node_unref0 (m);
									m = _tmp875_;
									_tmp876_ = m;
									_tmp877_ = vala_method_get_signal_reference (_tmp876_);
									_tmp878_ = _tmp877_;
									if (_tmp878_ != NULL) {
										ValaMethod* _tmp879_;
										ValaSignal* _tmp880_;
										ValaSignal* _tmp881_;
										_tmp879_ = m;
										_tmp880_ = vala_method_get_signal_reference (_tmp879_);
										_tmp881_ = _tmp880_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp881_);
									} else {
										ValaMethod* _tmp882_;
										_tmp882_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp882_);
									}
									_tmp883_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp884_ = _tmp883_;
									_tmp885_ = _vala_code_node_ref0 (_tmp884_);
									_vala_code_node_unref0 (member);
									member = _tmp885_;
								}
							}
						}
						_tmp886_ = m;
						_tmp887_ = vala_symbol_get_access ((ValaSymbol*) _tmp886_);
						_tmp888_ = _tmp887_;
						access = _tmp888_;
						_tmp889_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp889_, VALA_TYPE_CREATION_METHOD)) {
							ValaMethod* _tmp890_;
							ValaMemberBinding _tmp891_;
							ValaMemberBinding _tmp892_;
							_tmp890_ = m;
							_tmp891_ = vala_method_get_binding (_tmp890_);
							_tmp892_ = _tmp891_;
							instance = _tmp892_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp893_ = m;
						_tmp894_ = vala_method_get_binding (_tmp893_);
						_tmp895_ = _tmp894_;
						klass = _tmp895_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp896_;
							ValaList* _tmp897_;
							gint _param_size = 0;
							ValaList* _tmp898_;
							gint _tmp899_;
							gint _tmp900_;
							gint _param_index = 0;
							_tmp896_ = m;
							_tmp897_ = vala_callable_get_parameters ((ValaCallable*) _tmp896_);
							_param_list = _tmp897_;
							_tmp898_ = _param_list;
							_tmp899_ = vala_collection_get_size ((ValaCollection*) _tmp898_);
							_tmp900_ = _tmp899_;
							_param_size = _tmp900_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp901_;
								gint _tmp902_;
								gint _tmp903_;
								ValaParameter* param = NULL;
								ValaList* _tmp904_;
								gint _tmp905_;
								gpointer _tmp906_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp907_;
								ValaDataType* _tmp908_;
								ValaDataType* _tmp909_;
								ValaGenericType* _tmp910_;
								gboolean _tmp911_ = FALSE;
								ValaGenericType* _tmp912_;
								_tmp901_ = _param_index;
								_param_index = _tmp901_ + 1;
								_tmp902_ = _param_index;
								_tmp903_ = _param_size;
								if (!(_tmp902_ < _tmp903_)) {
									break;
								}
								_tmp904_ = _param_list;
								_tmp905_ = _param_index;
								_tmp906_ = vala_list_get (_tmp904_, _tmp905_);
								param = (ValaParameter*) _tmp906_;
								_tmp907_ = param;
								_tmp908_ = vala_variable_get_variable_type ((ValaVariable*) _tmp907_);
								_tmp909_ = _tmp908_;
								_tmp910_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp909_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp909_) : NULL);
								generic_type = _tmp910_;
								_tmp912_ = generic_type;
								if (_tmp912_ != NULL) {
									ValaGenericType* _tmp913_;
									ValaTypeParameter* _tmp914_;
									ValaTypeParameter* _tmp915_;
									ValaSymbol* _tmp916_;
									ValaSymbol* _tmp917_;
									_tmp913_ = generic_type;
									_tmp914_ = vala_generic_type_get_type_parameter (_tmp913_);
									_tmp915_ = _tmp914_;
									_tmp916_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp915_);
									_tmp917_ = _tmp916_;
									_tmp911_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp917_, VALA_TYPE_TYPESYMBOL);
								} else {
									_tmp911_ = FALSE;
								}
								if (_tmp911_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp918_ = m;
						_tmp919_ = vala_callable_get_return_type ((ValaCallable*) _tmp918_);
						_tmp920_ = _tmp919_;
						_tmp921_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp920_) : NULL);
						generic_type = _tmp921_;
						_tmp923_ = generic_type;
						if (_tmp923_ != NULL) {
							ValaGenericType* _tmp924_;
							ValaTypeParameter* _tmp925_;
							ValaTypeParameter* _tmp926_;
							ValaSymbol* _tmp927_;
							ValaSymbol* _tmp928_;
							_tmp924_ = generic_type;
							_tmp925_ = vala_generic_type_get_type_parameter (_tmp924_);
							_tmp926_ = _tmp925_;
							_tmp927_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp926_);
							_tmp928_ = _tmp927_;
							_tmp922_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp928_, VALA_TYPE_TYPESYMBOL);
						} else {
							_tmp922_ = FALSE;
						}
						if (_tmp922_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp929_;
						_tmp929_ = member;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp929_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp930_;
							ValaProperty* _tmp931_;
							ValaProperty* _tmp932_;
							ValaProperty* _tmp933_;
							ValaProperty* _tmp934_;
							ValaProperty* _tmp935_;
							ValaProperty* _tmp955_;
							ValaSymbolAccessibility _tmp956_;
							ValaSymbolAccessibility _tmp957_;
							gboolean _tmp958_;
							gboolean _tmp959_;
							ValaProperty* _tmp1024_;
							ValaMemberBinding _tmp1025_;
							ValaMemberBinding _tmp1026_;
							ValaProperty* _tmp1027_;
							ValaDataType* _tmp1028_;
							ValaDataType* _tmp1029_;
							_tmp930_ = member;
							_tmp931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp930_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp931_;
							_tmp932_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp932_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp933_ = prop;
							_tmp934_ = vala_property_get_base_property (_tmp933_);
							_tmp935_ = _tmp934_;
							if (_tmp935_ != NULL) {
								ValaProperty* _tmp936_;
								ValaProperty* _tmp937_;
								ValaProperty* _tmp938_;
								ValaProperty* _tmp939_;
								ValaProperty* _tmp940_;
								ValaSymbol* _tmp941_;
								ValaSymbol* _tmp942_;
								ValaSymbol* _tmp943_;
								_tmp936_ = prop;
								_tmp937_ = vala_property_get_base_property (_tmp936_);
								_tmp938_ = _tmp937_;
								_tmp939_ = _vala_code_node_ref0 (_tmp938_);
								_vala_code_node_unref0 (prop);
								prop = _tmp939_;
								_tmp940_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp940_);
								_tmp941_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp942_ = _tmp941_;
								_tmp943_ = _vala_code_node_ref0 (_tmp942_);
								_vala_code_node_unref0 (member);
								member = _tmp943_;
							} else {
								ValaProperty* _tmp944_;
								ValaProperty* _tmp945_;
								ValaProperty* _tmp946_;
								_tmp944_ = prop;
								_tmp945_ = vala_property_get_base_interface_property (_tmp944_);
								_tmp946_ = _tmp945_;
								if (_tmp946_ != NULL) {
									ValaProperty* _tmp947_;
									ValaProperty* _tmp948_;
									ValaProperty* _tmp949_;
									ValaProperty* _tmp950_;
									ValaProperty* _tmp951_;
									ValaSymbol* _tmp952_;
									ValaSymbol* _tmp953_;
									ValaSymbol* _tmp954_;
									_tmp947_ = prop;
									_tmp948_ = vala_property_get_base_interface_property (_tmp947_);
									_tmp949_ = _tmp948_;
									_tmp950_ = _vala_code_node_ref0 (_tmp949_);
									_vala_code_node_unref0 (prop);
									prop = _tmp950_;
									_tmp951_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp951_);
									_tmp952_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp953_ = _tmp952_;
									_tmp954_ = _vala_code_node_ref0 (_tmp953_);
									_vala_code_node_unref0 (member);
									member = _tmp954_;
								}
							}
							_tmp955_ = prop;
							_tmp956_ = vala_symbol_get_access ((ValaSymbol*) _tmp955_);
							_tmp957_ = _tmp956_;
							access = _tmp957_;
							_tmp958_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp959_ = _tmp958_;
							if (_tmp959_) {
								ValaProperty* _tmp960_;
								ValaPropertyAccessor* _tmp961_;
								ValaPropertyAccessor* _tmp962_;
								ValaProperty* _tmp970_;
								ValaSymbolAccessibility _tmp971_;
								ValaSymbolAccessibility _tmp972_;
								_tmp960_ = prop;
								_tmp961_ = vala_property_get_set_accessor (_tmp960_);
								_tmp962_ = _tmp961_;
								if (_tmp962_ == NULL) {
									ValaSourceReference* _tmp963_;
									ValaSourceReference* _tmp964_;
									ValaProperty* _tmp965_;
									gchar* _tmp966_;
									gchar* _tmp967_;
									gchar* _tmp968_;
									gchar* _tmp969_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp963_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp964_ = _tmp963_;
									_tmp965_ = prop;
									_tmp966_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp965_);
									_tmp967_ = _tmp966_;
									_tmp968_ = g_strdup_printf ("Property `%s' is read-only", _tmp967_);
									_tmp969_ = _tmp968_;
									vala_report_error (_tmp964_, _tmp969_);
									_g_free0 (_tmp969_);
									_g_free0 (_tmp967_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp970_ = prop;
								_tmp971_ = vala_symbol_get_access ((ValaSymbol*) _tmp970_);
								_tmp972_ = _tmp971_;
								if (_tmp972_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp973_;
									ValaPropertyAccessor* _tmp974_;
									ValaPropertyAccessor* _tmp975_;
									ValaSymbolAccessibility _tmp976_;
									ValaSymbolAccessibility _tmp977_;
									_tmp973_ = prop;
									_tmp974_ = vala_property_get_set_accessor (_tmp973_);
									_tmp975_ = _tmp974_;
									_tmp976_ = vala_symbol_get_access ((ValaSymbol*) _tmp975_);
									_tmp977_ = _tmp976_;
									access = _tmp977_;
								} else {
									gboolean _tmp978_ = FALSE;
									ValaProperty* _tmp979_;
									ValaSymbolAccessibility _tmp980_;
									ValaSymbolAccessibility _tmp981_;
									_tmp979_ = prop;
									_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
									_tmp981_ = _tmp980_;
									if (_tmp981_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp982_;
										ValaPropertyAccessor* _tmp983_;
										ValaPropertyAccessor* _tmp984_;
										ValaSymbolAccessibility _tmp985_;
										ValaSymbolAccessibility _tmp986_;
										_tmp982_ = prop;
										_tmp983_ = vala_property_get_set_accessor (_tmp982_);
										_tmp984_ = _tmp983_;
										_tmp985_ = vala_symbol_get_access ((ValaSymbol*) _tmp984_);
										_tmp986_ = _tmp985_;
										_tmp978_ = _tmp986_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp978_ = FALSE;
									}
									if (_tmp978_) {
										ValaProperty* _tmp987_;
										ValaPropertyAccessor* _tmp988_;
										ValaPropertyAccessor* _tmp989_;
										ValaSymbolAccessibility _tmp990_;
										ValaSymbolAccessibility _tmp991_;
										_tmp987_ = prop;
										_tmp988_ = vala_property_get_set_accessor (_tmp987_);
										_tmp989_ = _tmp988_;
										_tmp990_ = vala_symbol_get_access ((ValaSymbol*) _tmp989_);
										_tmp991_ = _tmp990_;
										access = _tmp991_;
									}
								}
							} else {
								ValaProperty* _tmp992_;
								ValaPropertyAccessor* _tmp993_;
								ValaPropertyAccessor* _tmp994_;
								ValaProperty* _tmp1002_;
								ValaSymbolAccessibility _tmp1003_;
								ValaSymbolAccessibility _tmp1004_;
								_tmp992_ = prop;
								_tmp993_ = vala_property_get_get_accessor (_tmp992_);
								_tmp994_ = _tmp993_;
								if (_tmp994_ == NULL) {
									ValaSourceReference* _tmp995_;
									ValaSourceReference* _tmp996_;
									ValaProperty* _tmp997_;
									gchar* _tmp998_;
									gchar* _tmp999_;
									gchar* _tmp1000_;
									gchar* _tmp1001_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp995_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp996_ = _tmp995_;
									_tmp997_ = prop;
									_tmp998_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp997_);
									_tmp999_ = _tmp998_;
									_tmp1000_ = g_strdup_printf ("Property `%s' is write-only", _tmp999_);
									_tmp1001_ = _tmp1000_;
									vala_report_error (_tmp996_, _tmp1001_);
									_g_free0 (_tmp1001_);
									_g_free0 (_tmp999_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1002_ = prop;
								_tmp1003_ = vala_symbol_get_access ((ValaSymbol*) _tmp1002_);
								_tmp1004_ = _tmp1003_;
								if (_tmp1004_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1005_;
									ValaPropertyAccessor* _tmp1006_;
									ValaPropertyAccessor* _tmp1007_;
									ValaSymbolAccessibility _tmp1008_;
									ValaSymbolAccessibility _tmp1009_;
									_tmp1005_ = prop;
									_tmp1006_ = vala_property_get_get_accessor (_tmp1005_);
									_tmp1007_ = _tmp1006_;
									_tmp1008_ = vala_symbol_get_access ((ValaSymbol*) _tmp1007_);
									_tmp1009_ = _tmp1008_;
									access = _tmp1009_;
								} else {
									gboolean _tmp1010_ = FALSE;
									ValaProperty* _tmp1011_;
									ValaSymbolAccessibility _tmp1012_;
									ValaSymbolAccessibility _tmp1013_;
									_tmp1011_ = prop;
									_tmp1012_ = vala_symbol_get_access ((ValaSymbol*) _tmp1011_);
									_tmp1013_ = _tmp1012_;
									if (_tmp1013_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1014_;
										ValaPropertyAccessor* _tmp1015_;
										ValaPropertyAccessor* _tmp1016_;
										ValaSymbolAccessibility _tmp1017_;
										ValaSymbolAccessibility _tmp1018_;
										_tmp1014_ = prop;
										_tmp1015_ = vala_property_get_get_accessor (_tmp1014_);
										_tmp1016_ = _tmp1015_;
										_tmp1017_ = vala_symbol_get_access ((ValaSymbol*) _tmp1016_);
										_tmp1018_ = _tmp1017_;
										_tmp1010_ = _tmp1018_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1010_ = FALSE;
									}
									if (_tmp1010_) {
										ValaProperty* _tmp1019_;
										ValaPropertyAccessor* _tmp1020_;
										ValaPropertyAccessor* _tmp1021_;
										ValaSymbolAccessibility _tmp1022_;
										ValaSymbolAccessibility _tmp1023_;
										_tmp1019_ = prop;
										_tmp1020_ = vala_property_get_get_accessor (_tmp1019_);
										_tmp1021_ = _tmp1020_;
										_tmp1022_ = vala_symbol_get_access ((ValaSymbol*) _tmp1021_);
										_tmp1023_ = _tmp1022_;
										access = _tmp1023_;
									}
								}
							}
							_tmp1024_ = prop;
							_tmp1025_ = vala_property_get_binding (_tmp1024_);
							_tmp1026_ = _tmp1025_;
							instance = _tmp1026_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1027_ = prop;
							_tmp1028_ = vala_property_get_property_type (_tmp1027_);
							_tmp1029_ = _tmp1028_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1029_, VALA_TYPE_GENERIC_TYPE)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1030_;
							_tmp1030_ = member;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1030_, VALA_TYPE_SIGNAL)) {
								ValaSymbol* _tmp1031_;
								ValaSymbolAccessibility _tmp1032_;
								ValaSymbolAccessibility _tmp1033_;
								instance = TRUE;
								_tmp1031_ = member;
								_tmp1032_ = vala_symbol_get_access (_tmp1031_);
								_tmp1033_ = _tmp1032_;
								access = _tmp1033_;
							}
						}
					}
				}
			}
		}
	}
	_tmp1034_ = member;
	vala_symbol_set_used (_tmp1034_, TRUE);
	_tmp1035_ = member;
	_tmp1036_ = vala_symbol_get_version (_tmp1035_);
	_tmp1037_ = _tmp1036_;
	_tmp1038_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1039_ = _tmp1038_;
	vala_version_attribute_check (_tmp1037_, _tmp1039_);
	_tmp1041_ = access;
	if (_tmp1041_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1042_;
		ValaSymbol* _tmp1043_;
		ValaSymbol* _tmp1044_;
		_tmp1042_ = member;
		_tmp1043_ = vala_symbol_get_parent_symbol (_tmp1042_);
		_tmp1044_ = _tmp1043_;
		_tmp1040_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1044_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp1040_ = FALSE;
	}
	if (_tmp1040_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1045_;
		ValaSymbol* _tmp1046_;
		ValaSymbol* _tmp1047_;
		ValaTypeSymbol* _tmp1048_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1068_;
		_tmp1045_ = member;
		_tmp1046_ = vala_symbol_get_parent_symbol (_tmp1045_);
		_tmp1047_ = _tmp1046_;
		_tmp1048_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1047_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1048_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1049_;
			ValaSemanticAnalyzer* _tmp1050_;
			ValaSymbol* _tmp1051_;
			ValaSymbol* _tmp1052_;
			ValaSymbol* _tmp1053_;
			_tmp1049_ = vala_code_context_get_analyzer (context);
			_tmp1050_ = _tmp1049_;
			_tmp1051_ = vala_semantic_analyzer_get_current_symbol (_tmp1050_);
			_tmp1052_ = _tmp1051_;
			_tmp1053_ = _vala_code_node_ref0 (_tmp1052_);
			this_symbol = _tmp1053_;
			{
				gboolean _tmp1054_ = FALSE;
				_tmp1054_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1059_;
					ValaSymbol* _tmp1060_;
					ValaTypeSymbol* _tmp1061_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1062_;
					ValaClass* _tmp1063_;
					gboolean _tmp1064_ = FALSE;
					ValaClass* _tmp1065_;
					if (!_tmp1054_) {
						ValaSymbol* _tmp1055_;
						ValaSymbol* _tmp1056_;
						ValaSymbol* _tmp1057_;
						ValaSymbol* _tmp1058_;
						_tmp1055_ = this_symbol;
						_tmp1056_ = vala_symbol_get_parent_symbol (_tmp1055_);
						_tmp1057_ = _tmp1056_;
						_tmp1058_ = _vala_code_node_ref0 (_tmp1057_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1058_;
					}
					_tmp1054_ = FALSE;
					_tmp1059_ = this_symbol;
					if (!(_tmp1059_ != NULL)) {
						break;
					}
					_tmp1060_ = this_symbol;
					_tmp1061_ = target_type;
					if (_tmp1060_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1061_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1062_ = this_symbol;
					_tmp1063_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1062_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1062_) : NULL);
					cl = _tmp1063_;
					_tmp1065_ = cl;
					if (_tmp1065_ != NULL) {
						ValaClass* _tmp1066_;
						ValaTypeSymbol* _tmp1067_;
						_tmp1066_ = cl;
						_tmp1067_ = target_type;
						_tmp1064_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1066_, _tmp1067_);
					} else {
						_tmp1064_ = FALSE;
					}
					if (_tmp1064_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1068_ = in_subtype;
		if (!_tmp1068_) {
			ValaSourceReference* _tmp1069_;
			ValaSourceReference* _tmp1070_;
			ValaSymbol* _tmp1071_;
			gchar* _tmp1072_;
			gchar* _tmp1073_;
			gchar* _tmp1074_;
			gchar* _tmp1075_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1069_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1070_ = _tmp1069_;
			_tmp1071_ = member;
			_tmp1072_ = vala_symbol_get_full_name (_tmp1071_);
			_tmp1073_ = _tmp1072_;
			_tmp1074_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1073_);
			_tmp1075_ = _tmp1074_;
			vala_report_error (_tmp1070_, _tmp1075_);
			_g_free0 (_tmp1075_);
			_g_free0 (_tmp1073_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1076_;
		_tmp1076_ = access;
		if (_tmp1076_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1077_;
			ValaSymbol* _tmp1078_;
			ValaSymbol* _tmp1079_;
			ValaSymbol* _tmp1080_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1094_;
			_tmp1077_ = member;
			_tmp1078_ = vala_symbol_get_parent_symbol (_tmp1077_);
			_tmp1079_ = _tmp1078_;
			_tmp1080_ = _vala_code_node_ref0 (_tmp1079_);
			target_type = _tmp1080_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1081_;
				ValaSemanticAnalyzer* _tmp1082_;
				ValaSymbol* _tmp1083_;
				ValaSymbol* _tmp1084_;
				ValaSymbol* _tmp1085_;
				_tmp1081_ = vala_code_context_get_analyzer (context);
				_tmp1082_ = _tmp1081_;
				_tmp1083_ = vala_semantic_analyzer_get_current_symbol (_tmp1082_);
				_tmp1084_ = _tmp1083_;
				_tmp1085_ = _vala_code_node_ref0 (_tmp1084_);
				this_symbol = _tmp1085_;
				{
					gboolean _tmp1086_ = FALSE;
					_tmp1086_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1091_;
						ValaSymbol* _tmp1092_;
						ValaSymbol* _tmp1093_;
						if (!_tmp1086_) {
							ValaSymbol* _tmp1087_;
							ValaSymbol* _tmp1088_;
							ValaSymbol* _tmp1089_;
							ValaSymbol* _tmp1090_;
							_tmp1087_ = this_symbol;
							_tmp1088_ = vala_symbol_get_parent_symbol (_tmp1087_);
							_tmp1089_ = _tmp1088_;
							_tmp1090_ = _vala_code_node_ref0 (_tmp1089_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1090_;
						}
						_tmp1086_ = FALSE;
						_tmp1091_ = this_symbol;
						if (!(_tmp1091_ != NULL)) {
							break;
						}
						_tmp1092_ = target_type;
						_tmp1093_ = this_symbol;
						if (_tmp1092_ == _tmp1093_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1094_ = in_target_type;
			if (!_tmp1094_) {
				ValaSourceReference* _tmp1095_;
				ValaSourceReference* _tmp1096_;
				ValaSymbol* _tmp1097_;
				gchar* _tmp1098_;
				gchar* _tmp1099_;
				gchar* _tmp1100_;
				gchar* _tmp1101_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1095_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1096_ = _tmp1095_;
				_tmp1097_ = member;
				_tmp1098_ = vala_symbol_get_full_name (_tmp1097_);
				_tmp1099_ = _tmp1098_;
				_tmp1100_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1099_);
				_tmp1101_ = _tmp1100_;
				vala_report_error (_tmp1096_, _tmp1101_);
				_g_free0 (_tmp1101_);
				_g_free0 (_tmp1099_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1103_ = generics;
	if (_tmp1103_) {
		ValaExpression* _tmp1104_;
		ValaExpression* _tmp1105_;
		_tmp1104_ = vala_member_access_get_inner (self);
		_tmp1105_ = _tmp1104_;
		_tmp1102_ = _tmp1105_ != NULL;
	} else {
		_tmp1102_ = FALSE;
	}
	if (_tmp1102_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1106_;
		ValaExpression* _tmp1107_;
		ValaDataType* _tmp1108_;
		ValaDataType* _tmp1109_;
		ValaDataType* _tmp1110_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1111_;
		ValaExpression* _tmp1112_;
		ValaDataType* _tmp1113_;
		ValaDataType* _tmp1114_;
		ValaPointerType* _tmp1115_;
		ValaPointerType* _tmp1116_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1121_;
		ValaObjectType* _tmp1122_;
		gboolean _tmp1123_ = FALSE;
		gboolean _tmp1124_ = FALSE;
		ValaObjectType* _tmp1125_;
		_tmp1106_ = vala_member_access_get_inner (self);
		_tmp1107_ = _tmp1106_;
		_tmp1108_ = vala_expression_get_value_type (_tmp1107_);
		_tmp1109_ = _tmp1108_;
		_tmp1110_ = _vala_code_node_ref0 (_tmp1109_);
		instance_type = _tmp1110_;
		_tmp1111_ = vala_member_access_get_inner (self);
		_tmp1112_ = _tmp1111_;
		_tmp1113_ = vala_expression_get_value_type (_tmp1112_);
		_tmp1114_ = _tmp1113_;
		_tmp1115_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1114_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp1114_) : NULL);
		pointer_type = _tmp1115_;
		_tmp1116_ = pointer_type;
		if (_tmp1116_ != NULL) {
			ValaPointerType* _tmp1117_;
			ValaDataType* _tmp1118_;
			ValaDataType* _tmp1119_;
			ValaDataType* _tmp1120_;
			_tmp1117_ = pointer_type;
			_tmp1118_ = vala_pointer_type_get_base_type (_tmp1117_);
			_tmp1119_ = _tmp1118_;
			_tmp1120_ = _vala_code_node_ref0 (_tmp1119_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1120_;
		}
		_tmp1121_ = instance_type;
		_tmp1122_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1121_, VALA_TYPE_OBJECT_TYPE) ? ((ValaObjectType*) _tmp1121_) : NULL);
		object_type = _tmp1122_;
		_tmp1125_ = object_type;
		if (_tmp1125_ != NULL) {
			ValaObjectType* _tmp1126_;
			ValaObjectTypeSymbol* _tmp1127_;
			ValaObjectTypeSymbol* _tmp1128_;
			ValaList* _tmp1129_;
			ValaList* _tmp1130_;
			gint _tmp1131_;
			gint _tmp1132_;
			_tmp1126_ = object_type;
			_tmp1127_ = vala_object_type_get_type_symbol (_tmp1126_);
			_tmp1128_ = _tmp1127_;
			_tmp1129_ = vala_object_type_symbol_get_type_parameters (_tmp1128_);
			_tmp1130_ = _tmp1129_;
			_tmp1131_ = vala_collection_get_size ((ValaCollection*) _tmp1130_);
			_tmp1132_ = _tmp1131_;
			_tmp1124_ = _tmp1132_ > 0;
			_vala_iterable_unref0 (_tmp1130_);
		} else {
			_tmp1124_ = FALSE;
		}
		if (_tmp1124_) {
			ValaDataType* _tmp1133_;
			ValaList* _tmp1134_;
			ValaList* _tmp1135_;
			gint _tmp1136_;
			gint _tmp1137_;
			_tmp1133_ = instance_type;
			_tmp1134_ = vala_data_type_get_type_arguments (_tmp1133_);
			_tmp1135_ = _tmp1134_;
			_tmp1136_ = vala_collection_get_size ((ValaCollection*) _tmp1135_);
			_tmp1137_ = _tmp1136_;
			_tmp1123_ = _tmp1137_ == 0;
			_vala_iterable_unref0 (_tmp1135_);
		} else {
			_tmp1123_ = FALSE;
		}
		if (_tmp1123_) {
			ValaExpression* _tmp1138_;
			ValaExpression* _tmp1139_;
			ValaSourceReference* _tmp1140_;
			ValaSourceReference* _tmp1141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1138_ = vala_member_access_get_inner (self);
			_tmp1139_ = _tmp1138_;
			_tmp1140_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1139_);
			_tmp1141_ = _tmp1140_;
			vala_report_error (_tmp1141_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1144_ = instance;
	if (_tmp1144_) {
		gboolean _tmp1145_;
		_tmp1145_ = may_access_instance_members;
		_tmp1143_ = !_tmp1145_;
	} else {
		_tmp1143_ = FALSE;
	}
	if (_tmp1143_) {
		_tmp1142_ = TRUE;
	} else {
		gboolean _tmp1146_ = FALSE;
		gboolean _tmp1147_;
		_tmp1147_ = klass;
		if (_tmp1147_) {
			gboolean _tmp1148_;
			_tmp1148_ = may_access_klass_members;
			_tmp1146_ = !_tmp1148_;
		} else {
			_tmp1146_ = FALSE;
		}
		_tmp1142_ = _tmp1146_;
	}
	if (_tmp1142_) {
		ValaSymbol* _tmp1149_;
		ValaSymbol* _tmp1150_;
		ValaDataType* _tmp1173_;
		ValaDataType* _tmp1174_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1150_ = _tmp1149_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1150_, VALA_TYPE_METHOD)) {
			ValaSemanticAnalyzer* _tmp1151_;
			ValaSemanticAnalyzer* _tmp1152_;
			ValaSymbol* _tmp1153_;
			ValaSymbol* _tmp1154_;
			gboolean _tmp1155_;
			gboolean _tmp1156_;
			ValaDataType* _tmp1157_;
			ValaDataType* _tmp1158_;
			_tmp1151_ = vala_code_context_get_analyzer (context);
			_tmp1152_ = _tmp1151_;
			_tmp1153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1154_ = _tmp1153_;
			_tmp1155_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1156_ = _tmp1155_;
			_tmp1157_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1152_, _tmp1154_, _tmp1156_);
			_tmp1158_ = _tmp1157_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1158_);
			_vala_code_node_unref0 (_tmp1158_);
		} else {
			ValaSymbol* _tmp1159_;
			ValaSymbol* _tmp1160_;
			_tmp1159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1160_ = _tmp1159_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1160_, VALA_TYPE_FIELD)) {
				ValaSymbol* _tmp1161_;
				ValaSymbol* _tmp1162_;
				ValaFieldPrototype* _tmp1163_;
				ValaFieldPrototype* _tmp1164_;
				_tmp1161_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1162_ = _tmp1161_;
				_tmp1163_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1162_, VALA_TYPE_FIELD, ValaField));
				_tmp1164_ = _tmp1163_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1164_);
				_vala_code_node_unref0 (_tmp1164_);
			} else {
				ValaSymbol* _tmp1165_;
				ValaSymbol* _tmp1166_;
				_tmp1165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1166_ = _tmp1165_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1166_, VALA_TYPE_PROPERTY)) {
					ValaSymbol* _tmp1167_;
					ValaSymbol* _tmp1168_;
					ValaPropertyPrototype* _tmp1169_;
					ValaPropertyPrototype* _tmp1170_;
					_tmp1167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1168_ = _tmp1167_;
					_tmp1169_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1168_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1170_ = _tmp1169_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1170_);
					_vala_code_node_unref0 (_tmp1170_);
				} else {
					ValaInvalidType* _tmp1171_;
					ValaInvalidType* _tmp1172_;
					_tmp1171_ = vala_invalid_type_new ();
					_tmp1172_ = _tmp1171_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1172_);
					_vala_code_node_unref0 (_tmp1172_);
				}
			}
		}
		_tmp1173_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1174_ = _tmp1173_;
		if (_tmp1174_ != NULL) {
			ValaDataType* _tmp1175_;
			ValaDataType* _tmp1176_;
			ValaDataType* _tmp1177_;
			ValaDataType* _tmp1178_;
			gboolean _tmp1179_;
			gboolean _tmp1180_;
			_tmp1175_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1176_ = _tmp1175_;
			_tmp1177_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1178_ = _tmp1177_;
			_tmp1179_ = vala_data_type_get_value_owned (_tmp1178_);
			_tmp1180_ = _tmp1179_;
			vala_data_type_set_value_owned (_tmp1176_, _tmp1180_);
		}
	} else {
		gboolean _tmp1181_ = FALSE;
		gboolean _tmp1182_;
		gboolean _tmp1203_ = FALSE;
		gboolean _tmp1204_ = FALSE;
		gboolean _tmp1205_ = FALSE;
		gboolean _tmp1206_ = FALSE;
		gboolean _tmp1207_;
		gboolean _tmp1226_ = FALSE;
		gboolean _tmp1227_ = FALSE;
		gboolean _tmp1228_ = FALSE;
		gboolean _tmp1229_ = FALSE;
		gboolean _tmp1230_ = FALSE;
		gboolean _tmp1231_;
		gboolean _tmp1232_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1260_;
		ValaSymbol* _tmp1261_;
		ValaMethod* _tmp1262_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1263_;
		ValaExpression* _tmp1264_;
		ValaMemberAccess* _tmp1265_;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1267_ = FALSE;
		gboolean _tmp1268_ = FALSE;
		gboolean _tmp1269_ = FALSE;
		gboolean _tmp1270_ = FALSE;
		ValaMethod* _tmp1271_;
		ValaSemanticAnalyzer* _tmp1312_;
		ValaSemanticAnalyzer* _tmp1313_;
		ValaSymbol* _tmp1314_;
		ValaSymbol* _tmp1315_;
		gboolean _tmp1316_;
		gboolean _tmp1317_;
		ValaDataType* _tmp1318_;
		ValaDataType* _tmp1319_;
		gboolean _tmp1320_ = FALSE;
		ValaExpression* _tmp1321_;
		ValaExpression* _tmp1322_;
		ValaSymbol* _tmp1335_;
		ValaSymbol* _tmp1336_;
		_tmp1182_ = instance;
		if (_tmp1182_) {
			ValaExpression* _tmp1183_;
			ValaExpression* _tmp1184_;
			_tmp1183_ = vala_member_access_get_inner (self);
			_tmp1184_ = _tmp1183_;
			_tmp1181_ = _tmp1184_ == NULL;
		} else {
			_tmp1181_ = FALSE;
		}
		if (_tmp1181_) {
			ValaSourceReference* _tmp1185_;
			ValaSourceReference* _tmp1186_;
			ValaMemberAccess* _tmp1187_;
			ValaMemberAccess* _tmp1188_;
			ValaExpression* _tmp1189_;
			ValaExpression* _tmp1190_;
			ValaParameter* _tmp1191_;
			ValaDataType* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaDataType* _tmp1194_;
			ValaDataType* _tmp1195_;
			ValaExpression* _tmp1196_;
			ValaExpression* _tmp1197_;
			ValaDataType* _tmp1198_;
			ValaDataType* _tmp1199_;
			ValaExpression* _tmp1200_;
			ValaExpression* _tmp1201_;
			ValaParameter* _tmp1202_;
			_tmp1185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1186_ = _tmp1185_;
			_tmp1187_ = vala_member_access_new (NULL, "this", _tmp1186_);
			_tmp1188_ = _tmp1187_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1188_);
			_vala_code_node_unref0 (_tmp1188_);
			_tmp1189_ = vala_member_access_get_inner (self);
			_tmp1190_ = _tmp1189_;
			_tmp1191_ = this_parameter;
			_tmp1192_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1191_);
			_tmp1193_ = _tmp1192_;
			_tmp1194_ = vala_data_type_copy (_tmp1193_);
			_tmp1195_ = _tmp1194_;
			vala_expression_set_value_type (_tmp1190_, _tmp1195_);
			_vala_code_node_unref0 (_tmp1195_);
			_tmp1196_ = vala_member_access_get_inner (self);
			_tmp1197_ = _tmp1196_;
			_tmp1198_ = vala_expression_get_value_type (_tmp1197_);
			_tmp1199_ = _tmp1198_;
			vala_data_type_set_value_owned (_tmp1199_, FALSE);
			_tmp1200_ = vala_member_access_get_inner (self);
			_tmp1201_ = _tmp1200_;
			_tmp1202_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1201_, (ValaSymbol*) _tmp1202_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1207_ = instance;
		if (!_tmp1207_) {
			gboolean _tmp1208_;
			_tmp1208_ = klass;
			_tmp1206_ = !_tmp1208_;
		} else {
			_tmp1206_ = FALSE;
		}
		if (_tmp1206_) {
			ValaSymbol* _tmp1209_;
			ValaSymbol* _tmp1210_;
			_tmp1209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1210_ = _tmp1209_;
			_tmp1205_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1210_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1205_ = FALSE;
		}
		if (_tmp1205_) {
			gboolean _tmp1211_;
			_tmp1211_ = may_access_instance_members;
			_tmp1204_ = _tmp1211_;
		} else {
			_tmp1204_ = FALSE;
		}
		if (_tmp1204_) {
			ValaExpression* _tmp1212_;
			ValaExpression* _tmp1213_;
			_tmp1212_ = vala_member_access_get_inner (self);
			_tmp1213_ = _tmp1212_;
			_tmp1203_ = _tmp1213_ != NULL;
		} else {
			_tmp1203_ = FALSE;
		}
		if (_tmp1203_) {
			ValaExpression* _tmp1214_;
			ValaExpression* _tmp1215_;
			ValaSymbol* _tmp1216_;
			ValaSymbol* _tmp1217_;
			_tmp1214_ = vala_member_access_get_inner (self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_expression_get_symbol_reference (_tmp1215_);
			_tmp1217_ = _tmp1216_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1217_, VALA_TYPE_METHOD)) {
			} else {
				ValaSourceReference* _tmp1218_;
				ValaSourceReference* _tmp1219_;
				ValaSymbol* _tmp1220_;
				ValaSymbol* _tmp1221_;
				gchar* _tmp1222_;
				gchar* _tmp1223_;
				gchar* _tmp1224_;
				gchar* _tmp1225_;
				_tmp1218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1219_ = _tmp1218_;
				_tmp1220_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1221_ = _tmp1220_;
				_tmp1222_ = vala_symbol_get_full_name (_tmp1221_);
				_tmp1223_ = _tmp1222_;
				_tmp1224_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1223_);
				_tmp1225_ = _tmp1224_;
				vala_report_warning (_tmp1219_, _tmp1225_);
				_g_free0 (_tmp1225_);
				_g_free0 (_tmp1223_);
			}
		}
		_tmp1231_ = vala_code_context_get_experimental_non_null (context);
		_tmp1232_ = _tmp1231_;
		if (_tmp1232_) {
			gboolean _tmp1233_;
			_tmp1233_ = instance;
			_tmp1230_ = _tmp1233_;
		} else {
			_tmp1230_ = FALSE;
		}
		if (_tmp1230_) {
			ValaExpression* _tmp1234_;
			ValaExpression* _tmp1235_;
			ValaDataType* _tmp1236_;
			ValaDataType* _tmp1237_;
			gboolean _tmp1238_;
			gboolean _tmp1239_;
			_tmp1234_ = vala_member_access_get_inner (self);
			_tmp1235_ = _tmp1234_;
			_tmp1236_ = vala_expression_get_value_type (_tmp1235_);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = vala_data_type_get_nullable (_tmp1237_);
			_tmp1239_ = _tmp1238_;
			_tmp1229_ = _tmp1239_;
		} else {
			_tmp1229_ = FALSE;
		}
		if (_tmp1229_) {
			ValaExpression* _tmp1240_;
			ValaExpression* _tmp1241_;
			ValaDataType* _tmp1242_;
			ValaDataType* _tmp1243_;
			_tmp1240_ = vala_member_access_get_inner (self);
			_tmp1241_ = _tmp1240_;
			_tmp1242_ = vala_expression_get_value_type (_tmp1241_);
			_tmp1243_ = _tmp1242_;
			_tmp1228_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1243_, VALA_TYPE_POINTER_TYPE);
		} else {
			_tmp1228_ = FALSE;
		}
		if (_tmp1228_) {
			ValaExpression* _tmp1244_;
			ValaExpression* _tmp1245_;
			ValaDataType* _tmp1246_;
			ValaDataType* _tmp1247_;
			_tmp1244_ = vala_member_access_get_inner (self);
			_tmp1245_ = _tmp1244_;
			_tmp1246_ = vala_expression_get_value_type (_tmp1245_);
			_tmp1247_ = _tmp1246_;
			_tmp1227_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1247_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1227_ = FALSE;
		}
		if (_tmp1227_) {
			ValaExpression* _tmp1248_;
			ValaExpression* _tmp1249_;
			ValaDataType* _tmp1250_;
			ValaDataType* _tmp1251_;
			_tmp1248_ = vala_member_access_get_inner (self);
			_tmp1249_ = _tmp1248_;
			_tmp1250_ = vala_expression_get_value_type (_tmp1249_);
			_tmp1251_ = _tmp1250_;
			_tmp1226_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1251_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp1226_ = FALSE;
		}
		if (_tmp1226_) {
			ValaSourceReference* _tmp1252_;
			ValaSourceReference* _tmp1253_;
			ValaSymbol* _tmp1254_;
			ValaSymbol* _tmp1255_;
			gchar* _tmp1256_;
			gchar* _tmp1257_;
			gchar* _tmp1258_;
			gchar* _tmp1259_;
			_tmp1252_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1253_ = _tmp1252_;
			_tmp1254_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = vala_symbol_get_full_name (_tmp1255_);
			_tmp1257_ = _tmp1256_;
			_tmp1258_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1257_);
			_tmp1259_ = _tmp1258_;
			vala_report_error (_tmp1253_, _tmp1259_);
			_g_free0 (_tmp1259_);
			_g_free0 (_tmp1257_);
		}
		_tmp1260_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1261_ = _tmp1260_;
		_tmp1262_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1261_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1261_) : NULL);
		m = _tmp1262_;
		_tmp1263_ = vala_member_access_get_inner (self);
		_tmp1264_ = _tmp1263_;
		_tmp1265_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1264_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1264_) : NULL);
		inner_ma = _tmp1265_;
		_tmp1271_ = m;
		if (_tmp1271_ != NULL) {
			ValaMethod* _tmp1272_;
			ValaMemberBinding _tmp1273_;
			ValaMemberBinding _tmp1274_;
			_tmp1272_ = m;
			_tmp1273_ = vala_method_get_binding (_tmp1272_);
			_tmp1274_ = _tmp1273_;
			_tmp1270_ = _tmp1274_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1270_ = FALSE;
		}
		if (_tmp1270_) {
			ValaMethod* _tmp1275_;
			ValaSymbol* _tmp1276_;
			ValaSymbol* _tmp1277_;
			_tmp1275_ = m;
			_tmp1276_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1275_);
			_tmp1277_ = _tmp1276_;
			_tmp1269_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1277_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
		} else {
			_tmp1269_ = FALSE;
		}
		if (_tmp1269_) {
			ValaExpression* _tmp1278_;
			ValaExpression* _tmp1279_;
			_tmp1278_ = vala_member_access_get_inner (self);
			_tmp1279_ = _tmp1278_;
			_tmp1268_ = _tmp1279_ != NULL;
		} else {
			_tmp1268_ = FALSE;
		}
		if (_tmp1268_) {
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaDataType* _tmp1282_;
			ValaDataType* _tmp1283_;
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_expression_get_value_type (_tmp1281_);
			_tmp1283_ = _tmp1282_;
			_tmp1267_ = _tmp1283_ == NULL;
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaMemberAccess* _tmp1284_;
			ValaList* _tmp1285_;
			gint _tmp1286_;
			gint _tmp1287_;
			_tmp1284_ = inner_ma;
			_tmp1285_ = _tmp1284_->priv->type_argument_list;
			_tmp1286_ = vala_collection_get_size ((ValaCollection*) _tmp1285_);
			_tmp1287_ = _tmp1286_;
			_tmp1266_ = _tmp1287_ > 0;
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			ValaExpression* _tmp1288_;
			ValaExpression* _tmp1289_;
			ValaMethod* _tmp1290_;
			ValaSymbol* _tmp1291_;
			ValaSymbol* _tmp1292_;
			ValaObjectType* _tmp1293_;
			ValaObjectType* _tmp1294_;
			_tmp1288_ = vala_member_access_get_inner (self);
			_tmp1289_ = _tmp1288_;
			_tmp1290_ = m;
			_tmp1291_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1290_);
			_tmp1292_ = _tmp1291_;
			_tmp1293_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1292_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1294_ = _tmp1293_;
			vala_expression_set_value_type (_tmp1289_, (ValaDataType*) _tmp1294_);
			_vala_code_node_unref0 (_tmp1294_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1295_;
				ValaList* _tmp1296_;
				ValaList* _tmp1297_;
				gint _type_argument_size = 0;
				ValaList* _tmp1298_;
				gint _tmp1299_;
				gint _tmp1300_;
				gint _type_argument_index = 0;
				_tmp1295_ = inner_ma;
				_tmp1296_ = _tmp1295_->priv->type_argument_list;
				_tmp1297_ = _vala_iterable_ref0 (_tmp1296_);
				_type_argument_list = _tmp1297_;
				_tmp1298_ = _type_argument_list;
				_tmp1299_ = vala_collection_get_size ((ValaCollection*) _tmp1298_);
				_tmp1300_ = _tmp1299_;
				_type_argument_size = _tmp1300_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1301_;
					gint _tmp1302_;
					gint _tmp1303_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1304_;
					gint _tmp1305_;
					gpointer _tmp1306_;
					ValaExpression* _tmp1307_;
					ValaExpression* _tmp1308_;
					ValaDataType* _tmp1309_;
					ValaDataType* _tmp1310_;
					ValaDataType* _tmp1311_;
					_tmp1301_ = _type_argument_index;
					_type_argument_index = _tmp1301_ + 1;
					_tmp1302_ = _type_argument_index;
					_tmp1303_ = _type_argument_size;
					if (!(_tmp1302_ < _tmp1303_)) {
						break;
					}
					_tmp1304_ = _type_argument_list;
					_tmp1305_ = _type_argument_index;
					_tmp1306_ = vala_list_get (_tmp1304_, _tmp1305_);
					type_argument = (ValaDataType*) _tmp1306_;
					_tmp1307_ = vala_member_access_get_inner (self);
					_tmp1308_ = _tmp1307_;
					_tmp1309_ = vala_expression_get_value_type (_tmp1308_);
					_tmp1310_ = _tmp1309_;
					_tmp1311_ = type_argument;
					vala_data_type_add_type_argument (_tmp1310_, _tmp1311_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1312_ = vala_code_context_get_analyzer (context);
		_tmp1313_ = _tmp1312_;
		_tmp1314_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1315_ = _tmp1314_;
		_tmp1316_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1317_ = _tmp1316_;
		_tmp1318_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1313_, _tmp1315_, _tmp1317_);
		_tmp1319_ = _tmp1318_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1319_);
		_vala_code_node_unref0 (_tmp1319_);
		_tmp1321_ = vala_member_access_get_inner (self);
		_tmp1322_ = _tmp1321_;
		if (_tmp1322_ != NULL) {
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			_tmp1323_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1324_ = _tmp1323_;
			_tmp1320_ = _tmp1324_ != NULL;
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaExpression* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaDataType* _tmp1330_;
			ValaDataType* _tmp1331_;
			ValaDataType* _tmp1332_;
			_tmp1325_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = vala_member_access_get_inner (self);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = vala_expression_get_value_type (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = vala_data_type_get_actual_type (_tmp1326_, _tmp1330_, NULL, (ValaCodeNode*) self);
			_tmp1332_ = _tmp1331_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1332_);
			_vala_code_node_unref0 (_tmp1332_);
		} else {
			ValaDataType* _tmp1333_;
			ValaDataType* _tmp1334_;
			_tmp1333_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1334_ = _tmp1333_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1334_);
		}
		_tmp1335_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1336_ = _tmp1335_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1336_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1337_;
			ValaSymbol* _tmp1338_;
			ValaMethod* _tmp1339_;
			ValaDataType* _tmp1340_;
			ValaDataType* _tmp1341_;
			gboolean _tmp1348_ = FALSE;
			gboolean _tmp1349_;
			_tmp1337_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1338_ = _tmp1337_;
			_tmp1339_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1338_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1339_;
			_tmp1340_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1341_ = _tmp1340_;
			if (_tmp1341_ != NULL) {
				ValaDataType* _tmp1342_;
				ValaDataType* _tmp1343_;
				ValaDataType* _tmp1344_;
				ValaDataType* _tmp1345_;
				gboolean _tmp1346_;
				gboolean _tmp1347_;
				_tmp1342_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1343_ = _tmp1342_;
				_tmp1344_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1345_ = _tmp1344_;
				_tmp1346_ = vala_data_type_get_value_owned (_tmp1345_);
				_tmp1347_ = _tmp1346_;
				vala_data_type_set_value_owned (_tmp1343_, _tmp1347_);
			}
			_tmp1349_ = instance;
			if (_tmp1349_) {
				ValaMethod* _tmp1350_;
				ValaSymbol* _tmp1351_;
				ValaSymbol* _tmp1352_;
				_tmp1350_ = method;
				_tmp1351_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1350_);
				_tmp1352_ = _tmp1351_;
				_tmp1348_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1352_, VALA_TYPE_TYPESYMBOL);
			} else {
				_tmp1348_ = FALSE;
			}
			if (_tmp1348_) {
				ValaExpression* _tmp1353_;
				ValaExpression* _tmp1354_;
				ValaMethod* _tmp1355_;
				ValaSymbol* _tmp1356_;
				ValaSymbol* _tmp1357_;
				ValaDataType* _tmp1358_;
				ValaDataType* _tmp1359_;
				ValaExpression* _tmp1360_;
				ValaExpression* _tmp1361_;
				ValaDataType* _tmp1362_;
				ValaDataType* _tmp1363_;
				ValaMethod* _tmp1364_;
				ValaParameter* _tmp1365_;
				ValaParameter* _tmp1366_;
				ValaDataType* _tmp1367_;
				ValaDataType* _tmp1368_;
				gboolean _tmp1369_;
				gboolean _tmp1370_;
				_tmp1353_ = vala_member_access_get_inner (self);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = method;
				_tmp1356_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1355_);
				_tmp1357_ = _tmp1356_;
				_tmp1358_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1357_);
				_tmp1359_ = _tmp1358_;
				vala_expression_set_target_type (_tmp1354_, _tmp1359_);
				_vala_code_node_unref0 (_tmp1359_);
				_tmp1360_ = vala_member_access_get_inner (self);
				_tmp1361_ = _tmp1360_;
				_tmp1362_ = vala_expression_get_target_type (_tmp1361_);
				_tmp1363_ = _tmp1362_;
				_tmp1364_ = method;
				_tmp1365_ = vala_method_get_this_parameter (_tmp1364_);
				_tmp1366_ = _tmp1365_;
				_tmp1367_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1366_);
				_tmp1368_ = _tmp1367_;
				_tmp1369_ = vala_data_type_get_value_owned (_tmp1368_);
				_tmp1370_ = _tmp1369_;
				vala_data_type_set_value_owned (_tmp1363_, _tmp1370_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1371_;
			ValaSymbol* _tmp1372_;
			_tmp1371_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1372_ = _tmp1371_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1372_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1373_;
				ValaSymbol* _tmp1374_;
				ValaProperty* _tmp1375_;
				gboolean _tmp1376_ = FALSE;
				gboolean _tmp1377_;
				_tmp1373_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1374_ = _tmp1373_;
				_tmp1375_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1374_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1375_;
				_tmp1377_ = instance;
				if (_tmp1377_) {
					ValaProperty* _tmp1378_;
					ValaSymbol* _tmp1379_;
					ValaSymbol* _tmp1380_;
					_tmp1378_ = prop;
					_tmp1379_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1378_);
					_tmp1380_ = _tmp1379_;
					_tmp1376_ = _tmp1380_ != NULL;
				} else {
					_tmp1376_ = FALSE;
				}
				if (_tmp1376_) {
					ValaExpression* _tmp1381_;
					ValaExpression* _tmp1382_;
					ValaProperty* _tmp1383_;
					ValaSymbol* _tmp1384_;
					ValaSymbol* _tmp1385_;
					ValaDataType* _tmp1386_;
					ValaDataType* _tmp1387_;
					_tmp1381_ = vala_member_access_get_inner (self);
					_tmp1382_ = _tmp1381_;
					_tmp1383_ = prop;
					_tmp1384_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1383_);
					_tmp1385_ = _tmp1384_;
					_tmp1386_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1385_);
					_tmp1387_ = _tmp1386_;
					vala_expression_set_target_type (_tmp1382_, _tmp1387_);
					_vala_code_node_unref0 (_tmp1387_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1388_ = FALSE;
				gboolean _tmp1389_ = FALSE;
				gboolean _tmp1390_ = FALSE;
				ValaSymbol* _tmp1391_;
				ValaSymbol* _tmp1392_;
				_tmp1391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1392_ = _tmp1391_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1392_, VALA_TYPE_FIELD)) {
					_tmp1390_ = TRUE;
				} else {
					ValaSymbol* _tmp1393_;
					ValaSymbol* _tmp1394_;
					_tmp1393_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1394_ = _tmp1393_;
					_tmp1390_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1394_, VALA_TYPE_SIGNAL);
				}
				if (_tmp1390_) {
					gboolean _tmp1395_;
					_tmp1395_ = instance;
					_tmp1389_ = _tmp1395_;
				} else {
					_tmp1389_ = FALSE;
				}
				if (_tmp1389_) {
					ValaSymbol* _tmp1396_;
					ValaSymbol* _tmp1397_;
					ValaSymbol* _tmp1398_;
					ValaSymbol* _tmp1399_;
					_tmp1396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1397_ = _tmp1396_;
					_tmp1398_ = vala_symbol_get_parent_symbol (_tmp1397_);
					_tmp1399_ = _tmp1398_;
					_tmp1388_ = _tmp1399_ != NULL;
				} else {
					_tmp1388_ = FALSE;
				}
				if (_tmp1388_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1400_;
					ValaSymbol* _tmp1401_;
					ValaSymbol* _tmp1402_;
					ValaSymbol* _tmp1403_;
					ValaDataType* _tmp1404_;
					ValaExpression* _tmp1405_;
					ValaExpression* _tmp1406_;
					ValaDataType* _tmp1407_;
					ValaExpression* _tmp1408_;
					ValaExpression* _tmp1409_;
					ValaDataType* _tmp1410_;
					ValaDataType* _tmp1411_;
					ValaDataType* _tmp1412_;
					ValaDataType* _tmp1413_;
					_tmp1400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1401_ = _tmp1400_;
					_tmp1402_ = vala_symbol_get_parent_symbol (_tmp1401_);
					_tmp1403_ = _tmp1402_;
					_tmp1404_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1403_);
					parent_type = _tmp1404_;
					_tmp1405_ = vala_member_access_get_inner (self);
					_tmp1406_ = _tmp1405_;
					_tmp1407_ = parent_type;
					_tmp1408_ = vala_member_access_get_inner (self);
					_tmp1409_ = _tmp1408_;
					_tmp1410_ = vala_expression_get_value_type (_tmp1409_);
					_tmp1411_ = _tmp1410_;
					_tmp1412_ = vala_data_type_get_actual_type (_tmp1407_, _tmp1411_, NULL, (ValaCodeNode*) self);
					_tmp1413_ = _tmp1412_;
					vala_expression_set_target_type (_tmp1406_, _tmp1413_);
					_vala_code_node_unref0 (_tmp1413_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1414_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1415_ = _tmp1414_;
	result = !_tmp1415_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_FIELD)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_METHOD)) {
			_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_PROPERTY)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_SIGNAL)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_PROPERTY)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_PARAMETER)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_ARRAY_TYPE);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_POINTER_INDIRECTION);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_METHOD)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_VARIABLE);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, VALA_TYPE_ELEMENT_ACCESS);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



