/* valaccodeconstant.c generated by valac, the Vala compiler
 * generated from valaccodeconstant.vala, do not modify */

/* valaccodeconstant.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaCCodeConstantPrivate {
	gchar* _name;
};


static gint ValaCCodeConstant_private_offset;
static gpointer vala_ccode_constant_parent_class = NULL;

#define VALA_CCODE_CONSTANT_LINE_LENGTH 70
static void vala_ccode_constant_real_write (ValaCCodeNode* base,
                                     ValaCCodeWriter* writer);
static void vala_ccode_constant_finalize (ValaCCodeNode * obj);


static inline gpointer
vala_ccode_constant_get_instance_private (ValaCCodeConstant* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCCodeConstant_private_offset);
}


ValaCCodeConstant*
vala_ccode_constant_construct (GType object_type,
                               const gchar* _name)
{
	ValaCCodeConstant* self = NULL;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	vala_ccode_constant_set_name (self, _name);
	return self;
}


ValaCCodeConstant*
vala_ccode_constant_new (const gchar* _name)
{
	return vala_ccode_constant_construct (VALA_TYPE_CCODE_CONSTANT, _name);
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


ValaCCodeConstant*
vala_ccode_constant_construct_string (GType object_type,
                                      const gchar* _name)
{
	ValaCCodeConstant* self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GString* builder = NULL;
	GString* _tmp2_;
	gchar* p = NULL;
	gchar* end = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint col = 0;
	GString* _tmp52_;
	GString* _tmp53_;
	const gchar* _tmp54_;
	g_return_val_if_fail (_name != NULL, NULL);
	self = (ValaCCodeConstant*) vala_ccode_expression_construct (object_type);
	_vala_assert (string_get (_name, (glong) 0) == '\"', "_name[0] == '\\\"'");
	_tmp0_ = strlen (_name);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= VALA_CCODE_CONSTANT_LINE_LENGTH) {
		vala_ccode_constant_set_name (self, _name);
		return self;
	}
	_tmp2_ = g_string_new ("\"");
	builder = _tmp2_;
	p = _name;
	_tmp3_ = p;
	_tmp4_ = strlen (_name);
	_tmp5_ = _tmp4_;
	end = _tmp3_ + _tmp5_;
	_tmp6_ = p;
	p = _tmp6_ + 1;
	_tmp7_ = end;
	end = _tmp7_ - 1;
	col = 0;
	while (TRUE) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gchar* _tmp12_;
		_tmp8_ = p;
		_tmp9_ = end;
		if (!(_tmp8_ < _tmp9_)) {
			break;
		}
		_tmp10_ = col;
		if (_tmp10_ >= VALA_CCODE_CONSTANT_LINE_LENGTH) {
			GString* _tmp11_;
			_tmp11_ = builder;
			g_string_append (_tmp11_, "\" \\\n\"");
			col = 0;
		}
		_tmp12_ = p;
		if ((*_tmp12_) == '\\') {
			gchar* begin_of_char = NULL;
			gchar* _tmp13_;
			GString* _tmp14_;
			gchar* _tmp15_;
			gchar _tmp16_;
			GString* _tmp17_;
			gchar* _tmp18_;
			gchar _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar _tmp22_;
			gint _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp13_ = p;
			begin_of_char = _tmp13_;
			_tmp14_ = builder;
			_tmp15_ = p;
			_tmp16_ = _tmp15_[0];
			g_string_append_c (_tmp14_, _tmp16_);
			_tmp17_ = builder;
			_tmp18_ = p;
			_tmp19_ = _tmp18_[1];
			g_string_append_c (_tmp17_, _tmp19_);
			_tmp20_ = p;
			p = _tmp20_ + 2;
			_tmp21_ = p;
			_tmp22_ = _tmp21_[-1];
			switch (_tmp22_) {
				case 'x':
				{
					while (TRUE) {
						gboolean _tmp23_ = FALSE;
						gchar* _tmp24_;
						gchar* _tmp25_;
						GString* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						_tmp24_ = p;
						_tmp25_ = end;
						if (_tmp24_ < _tmp25_) {
							gchar* _tmp26_;
							_tmp26_ = p;
							_tmp23_ = g_ascii_isxdigit (*_tmp26_);
						} else {
							_tmp23_ = FALSE;
						}
						if (!_tmp23_) {
							break;
						}
						_tmp27_ = builder;
						_tmp28_ = p;
						g_string_append_c (_tmp27_, *_tmp28_);
						_tmp29_ = p;
						p = _tmp29_ + 1;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					while (TRUE) {
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_ = FALSE;
						gboolean _tmp32_ = FALSE;
						gchar* _tmp33_;
						gchar* _tmp34_;
						GString* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp33_ = p;
						_tmp34_ = end;
						if (_tmp33_ < _tmp34_) {
							gchar* _tmp35_;
							gchar* _tmp36_;
							_tmp35_ = p;
							_tmp36_ = begin_of_char;
							_tmp32_ = (_tmp35_ - _tmp36_) <= ((gsize) 3);
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							gchar* _tmp37_;
							_tmp37_ = p;
							_tmp31_ = (*_tmp37_) >= '0';
						} else {
							_tmp31_ = FALSE;
						}
						if (_tmp31_) {
							gchar* _tmp38_;
							_tmp38_ = p;
							_tmp30_ = (*_tmp38_) <= '7';
						} else {
							_tmp30_ = FALSE;
						}
						if (!_tmp30_) {
							break;
						}
						_tmp39_ = builder;
						_tmp40_ = p;
						g_string_append_c (_tmp39_, *_tmp40_);
						_tmp41_ = p;
						p = _tmp41_ + 1;
					}
					break;
				}
				case 'n':
				{
					col = VALA_CCODE_CONSTANT_LINE_LENGTH;
					break;
				}
				default:
				break;
			}
			_tmp42_ = col;
			_tmp43_ = p;
			_tmp44_ = begin_of_char;
			col = _tmp42_ + ((gint) (_tmp43_ - _tmp44_));
		} else {
			GString* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			_tmp45_ = builder;
			_tmp46_ = p;
			g_string_append_unichar (_tmp45_, string_get_char ((const gchar*) _tmp46_, (glong) 0));
			_tmp47_ = p;
			_tmp48_ = p;
			_tmp49_ = g_utf8_next_char ((const gchar*) _tmp48_);
			_tmp50_ = p;
			p = _tmp47_ + (((gchar*) _tmp49_) - _tmp50_);
			_tmp51_ = col;
			col = _tmp51_ + 1;
		}
	}
	_tmp52_ = builder;
	g_string_append_c (_tmp52_, '"');
	_tmp53_ = builder;
	_tmp54_ = _tmp53_->str;
	vala_ccode_constant_set_name (self, _tmp54_);
	_g_string_free0 (builder);
	return self;
}


ValaCCodeConstant*
vala_ccode_constant_new_string (const gchar* _name)
{
	return vala_ccode_constant_construct_string (VALA_TYPE_CCODE_CONSTANT, _name);
}


static void
vala_ccode_constant_real_write (ValaCCodeNode* base,
                                ValaCCodeWriter* writer)
{
	ValaCCodeConstant * self;
	const gchar* _tmp0_;
	self = (ValaCCodeConstant*) base;
	g_return_if_fail (writer != NULL);
	_tmp0_ = self->priv->_name;
	vala_ccode_writer_write_string (writer, _tmp0_);
}


const gchar*
vala_ccode_constant_get_name (ValaCCodeConstant* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void
vala_ccode_constant_set_name (ValaCCodeConstant* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}


static void
vala_ccode_constant_class_init (ValaCCodeConstantClass * klass)
{
	vala_ccode_constant_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_constant_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCCodeConstant_private_offset);
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_constant_real_write;
}


static void
vala_ccode_constant_instance_init (ValaCCodeConstant * self)
{
	self->priv = vala_ccode_constant_get_instance_private (self);
}


static void
vala_ccode_constant_finalize (ValaCCodeNode * obj)
{
	ValaCCodeConstant * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant);
	_g_free0 (self->priv->_name);
	VALA_CCODE_NODE_CLASS (vala_ccode_constant_parent_class)->finalize (obj);
}


/**
 * A constant C expression.
 */
GType
vala_ccode_constant_get_type (void)
{
	static volatile gsize vala_ccode_constant_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_constant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeConstantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_constant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeConstant), 0, (GInstanceInitFunc) vala_ccode_constant_instance_init, NULL };
		GType vala_ccode_constant_type_id;
		vala_ccode_constant_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeConstant", &g_define_type_info, 0);
		ValaCCodeConstant_private_offset = g_type_add_instance_private (vala_ccode_constant_type_id, sizeof (ValaCCodeConstantPrivate));
		g_once_init_leave (&vala_ccode_constant_type_id__volatile, vala_ccode_constant_type_id);
	}
	return vala_ccode_constant_type_id__volatile;
}



