/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _arg_index);
			arg = (ValaExpression*) _tmp14_;
			_tmp15_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp16_ = self->priv->object_initializer;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp21_ = _init_list;
			_tmp22_ = vala_list_get (_tmp21_, _init_index);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaExpression* _tmp12_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _arg_index);
			arg = (ValaExpression*) _tmp11_;
			_tmp12_ = arg;
			if (!vala_expression_is_accessible (_tmp12_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp13_ = self->priv->object_initializer;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaMemberInitializer* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp18_ = _init_list;
			_tmp19_ = vala_list_get (_tmp18_, _init_index);
			init = (ValaMemberInitializer*) _tmp19_;
			_tmp20_ = init;
			_tmp21_ = vala_member_initializer_get_initializer (_tmp20_);
			_tmp22_ = _tmp21_;
			if (!vala_expression_is_accessible (_tmp22_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	gint given_num_type_args = 0;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaList* _tmp114_;
	ValaList* _tmp115_;
	gint _tmp116_;
	gint _tmp117_;
	gint _tmp118_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp119_;
	gboolean _tmp247_ = FALSE;
	ValaSymbol* _tmp248_;
	ValaSymbol* _tmp249_;
	ValaSymbol* _tmp261_;
	ValaSymbol* _tmp262_;
	gboolean _tmp502_;
	gboolean _tmp503_;
	gboolean _tmp556_;
	gboolean _tmp557_;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp55_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		type_args = _tmp30_;
		_tmp31_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp31_)) {
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp36_;
			ValaMethod* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp46_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp47_;
			ValaMemberAccess* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp32_ = constructor_sym;
			_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _vala_code_node_ref0 (_tmp34_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp35_;
			_tmp36_ = constructor_sym;
			_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp37_;
			_tmp38_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp38_)) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMethod* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = constructor;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("`%s' is not a creation method", _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp46_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp46_);
			_tmp47_ = vala_object_creation_expression_get_member_name (self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_member_access_get_inner (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp50_) ? ((ValaMemberAccess*) _tmp50_) : NULL);
			ma = _tmp51_;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp54_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp55_ = type_sym;
		if (VALA_IS_CLASS (_tmp55_)) {
			ValaSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = type_sym;
			_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp57_;
			_tmp58_ = type;
			_tmp59_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_CLASS, ValaClass));
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaErrorType* _tmp63_;
				ValaErrorType* _tmp64_;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_error_type_new (NULL, NULL, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp64_);
				_vala_code_node_unref0 (_tmp64_);
			} else {
				ValaTypeSymbol* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaObjectType* _tmp67_;
				_tmp65_ = type;
				_tmp66_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			}
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_STRUCT (_tmp68_)) {
				ValaSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaStructValueType* _tmp72_;
				ValaStructValueType* _tmp73_;
				_tmp69_ = type_sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp70_;
				_tmp71_ = type;
				_tmp72_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp73_ = _tmp72_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp73_);
				_vala_code_node_unref0 (_tmp73_);
			} else {
				ValaSymbol* _tmp74_;
				_tmp74_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp74_)) {
					ValaSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaErrorType* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaSymbol* _tmp83_;
					_tmp75_ = type_sym;
					_tmp76_ = vala_symbol_get_parent_symbol (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp80_);
					_tmp82_ = _tmp81_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp82_);
					_vala_code_node_unref0 (_tmp82_);
					_tmp83_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp83_);
				} else {
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaSymbol* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_full_name (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp85_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp91_;
			ValaList* _tmp92_;
			gint _type_arg_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _type_arg_index = 0;
			_tmp91_ = type_args;
			_tmp92_ = _vala_iterable_ref0 (_tmp91_);
			_type_arg_list = _tmp92_;
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_type_arg_size = _tmp95_;
			_type_arg_index = -1;
			while (TRUE) {
				ValaDataType* type_arg = NULL;
				ValaList* _tmp96_;
				gpointer _tmp97_;
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				ValaDataType* _tmp100_;
				_type_arg_index = _type_arg_index + 1;
				if (!(_type_arg_index < _type_arg_size)) {
					break;
				}
				_tmp96_ = _type_arg_list;
				_tmp97_ = vala_list_get (_tmp96_, _type_arg_index);
				type_arg = (ValaDataType*) _tmp97_;
				_tmp98_ = vala_object_creation_expression_get_type_reference (self);
				_tmp99_ = _tmp98_;
				_tmp100_ = type_arg;
				vala_data_type_add_type_argument (_tmp99_, _tmp100_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaTypeSymbol* _tmp103_;
		ValaTypeSymbol* _tmp104_;
		ValaTypeSymbol* _tmp105_;
		_tmp101_ = vala_object_creation_expression_get_type_reference (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_get_data_type (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = _vala_code_node_ref0 (_tmp104_);
		_vala_code_node_unref0 (type);
		type = _tmp105_;
	}
	_tmp106_ = vala_object_creation_expression_get_type_reference (self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_data_type_copy (_tmp107_);
	_tmp109_ = _tmp108_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp109_);
	_vala_code_node_unref0 (_tmp109_);
	_tmp110_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp111_ = _tmp110_;
	vala_data_type_set_value_owned (_tmp111_, TRUE);
	_tmp112_ = vala_object_creation_expression_get_type_reference (self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_data_type_get_type_arguments (_tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = _tmp117_;
	_vala_iterable_unref0 (_tmp115_);
	given_num_type_args = _tmp118_;
	expected_num_type_args = 0;
	_tmp119_ = type;
	if (VALA_IS_CLASS (_tmp119_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp120_;
		ValaClass* _tmp121_;
		ValaClass* _tmp122_;
		ValaList* _tmp123_;
		ValaList* _tmp124_;
		gint _tmp125_;
		gint _tmp126_;
		gboolean _tmp127_;
		ValaClass* _tmp130_;
		gboolean _tmp131_;
		gboolean _tmp132_;
		ValaSymbol* _tmp140_;
		ValaSymbol* _tmp141_;
		gboolean _tmp162_ = FALSE;
		ValaSymbol* _tmp163_;
		ValaSymbol* _tmp164_;
		_tmp120_ = type;
		_tmp121_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp121_;
		_tmp122_ = cl;
		_tmp123_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp122_);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
		_tmp126_ = _tmp125_;
		expected_num_type_args = _tmp126_;
		_vala_iterable_unref0 (_tmp124_);
		_tmp127_ = self->priv->_struct_creation;
		if (_tmp127_) {
			ValaSourceReference* _tmp128_;
			ValaSourceReference* _tmp129_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp129_ = _tmp128_;
			vala_report_error (_tmp129_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp130_ = cl;
		_tmp131_ = vala_class_get_is_abstract (_tmp130_);
		_tmp132_ = _tmp131_;
		if (_tmp132_) {
			ValaSourceReference* _tmp133_;
			ValaSourceReference* _tmp134_;
			ValaClass* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp134_ = _tmp133_;
			_tmp135_ = cl;
			_tmp136_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp137_);
			_tmp139_ = _tmp138_;
			vala_report_error (_tmp134_, _tmp139_);
			_g_free0 (_tmp139_);
			_g_free0 (_tmp137_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp141_ = _tmp140_;
		if (_tmp141_ == NULL) {
			ValaClass* _tmp142_;
			ValaCreationMethod* _tmp143_;
			ValaCreationMethod* _tmp144_;
			ValaSymbol* _tmp145_;
			ValaSymbol* _tmp146_;
			ValaSymbol* _tmp154_;
			ValaSymbol* _tmp155_;
			ValaSymbol* _tmp156_;
			ValaSymbol* _tmp157_;
			ValaVersionAttribute* _tmp158_;
			ValaVersionAttribute* _tmp159_;
			ValaSourceReference* _tmp160_;
			ValaSourceReference* _tmp161_;
			_tmp142_ = cl;
			_tmp143_ = vala_class_get_default_construction_method (_tmp142_);
			_tmp144_ = _tmp143_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp144_);
			_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp146_ = _tmp145_;
			if (_tmp146_ == NULL) {
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaClass* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp148_ = _tmp147_;
				_tmp149_ = cl;
				_tmp150_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp151_);
				_tmp153_ = _tmp152_;
				vala_report_error (_tmp148_, _tmp153_);
				_g_free0 (_tmp153_);
				_g_free0 (_tmp151_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp154_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp155_ = _tmp154_;
			vala_symbol_set_used (_tmp155_, TRUE);
			_tmp156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_symbol_get_version (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp161_ = _tmp160_;
			vala_version_attribute_check (_tmp159_, _tmp161_);
		}
		_tmp163_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp164_ = _tmp163_;
		if (_tmp164_ != NULL) {
			gboolean _tmp165_ = FALSE;
			ValaSymbol* _tmp166_;
			ValaSymbol* _tmp167_;
			ValaSymbolAccessibility _tmp168_;
			ValaSymbolAccessibility _tmp169_;
			_tmp166_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_symbol_get_access (_tmp167_);
			_tmp169_ = _tmp168_;
			if (_tmp169_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp165_ = TRUE;
			} else {
				ValaSymbol* _tmp170_;
				ValaSymbol* _tmp171_;
				ValaSymbolAccessibility _tmp172_;
				ValaSymbolAccessibility _tmp173_;
				_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_symbol_get_access (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp165_ = _tmp173_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp162_ = _tmp165_;
		} else {
			_tmp162_ = FALSE;
		}
		if (_tmp162_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp174_;
				ValaSemanticAnalyzer* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp174_ = vala_code_context_get_analyzer (context);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_semantic_analyzer_get_current_symbol (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = _vala_code_node_ref0 (_tmp177_);
				this_symbol = _tmp178_;
				{
					gboolean _tmp179_ = FALSE;
					_tmp179_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp184_;
						ValaSymbol* _tmp185_;
						ValaClass* _tmp186_;
						if (!_tmp179_) {
							ValaSymbol* _tmp180_;
							ValaSymbol* _tmp181_;
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							_tmp180_ = this_symbol;
							_tmp181_ = vala_symbol_get_parent_symbol (_tmp180_);
							_tmp182_ = _tmp181_;
							_tmp183_ = _vala_code_node_ref0 (_tmp182_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp183_;
						}
						_tmp179_ = FALSE;
						_tmp184_ = this_symbol;
						if (!(_tmp184_ != NULL)) {
							break;
						}
						_tmp185_ = this_symbol;
						_tmp186_ = cl;
						if (_tmp185_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp186_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				ValaSymbol* _tmp189_;
				ValaSymbol* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_symbol_get_full_name (_tmp190_);
				_tmp192_ = _tmp191_;
				_tmp193_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp192_);
				_tmp194_ = _tmp193_;
				vala_report_error (_tmp188_, _tmp194_);
				_g_free0 (_tmp194_);
				_g_free0 (_tmp192_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp195_;
			ValaClass* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			gboolean _tmp199_;
			ValaClass* _tmp202_;
			ValaClass* _tmp203_;
			ValaClass* _tmp204_;
			ValaClass* _tmp205_;
			_tmp195_ = cl;
			if (!(_tmp195_ != NULL)) {
				break;
			}
			_tmp196_ = cl;
			_tmp197_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp196_, "CCode", "ref_sink_function", NULL);
			_tmp198_ = _tmp197_;
			_tmp199_ = _tmp198_ != NULL;
			_g_free0 (_tmp198_);
			if (_tmp199_) {
				ValaDataType* _tmp200_;
				ValaDataType* _tmp201_;
				_tmp200_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp201_ = _tmp200_;
				vala_data_type_set_floating_reference (_tmp201_, TRUE);
				break;
			}
			_tmp202_ = cl;
			_tmp203_ = vala_class_get_base_class (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = _vala_code_node_ref0 (_tmp204_);
			_vala_code_node_unref0 (cl);
			cl = _tmp205_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp206_;
		_tmp206_ = type;
		if (VALA_IS_STRUCT (_tmp206_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp207_;
			ValaStruct* _tmp208_;
			ValaStruct* _tmp209_;
			ValaList* _tmp210_;
			ValaList* _tmp211_;
			gint _tmp212_;
			gint _tmp213_;
			gboolean _tmp214_ = FALSE;
			gboolean _tmp215_;
			ValaSymbol* _tmp220_;
			ValaSymbol* _tmp221_;
			gboolean _tmp225_ = FALSE;
			gboolean _tmp226_ = FALSE;
			gboolean _tmp227_ = FALSE;
			ValaProfile _tmp228_;
			ValaProfile _tmp229_;
			_tmp207_ = type;
			_tmp208_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp207_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp208_;
			_tmp209_ = st;
			_tmp210_ = vala_struct_get_type_parameters (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_collection_get_size ((ValaCollection*) _tmp211_);
			_tmp213_ = _tmp212_;
			expected_num_type_args = _tmp213_;
			_vala_iterable_unref0 (_tmp211_);
			_tmp215_ = self->priv->_struct_creation;
			if (!_tmp215_) {
				gboolean _tmp216_;
				gboolean _tmp217_;
				_tmp216_ = vala_code_context_get_deprecated (context);
				_tmp217_ = _tmp216_;
				_tmp214_ = !_tmp217_;
			} else {
				_tmp214_ = FALSE;
			}
			if (_tmp214_) {
				ValaSourceReference* _tmp218_;
				ValaSourceReference* _tmp219_;
				_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp219_ = _tmp218_;
				vala_report_warning (_tmp219_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp220_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp221_ = _tmp220_;
			if (_tmp221_ == NULL) {
				ValaStruct* _tmp222_;
				ValaCreationMethod* _tmp223_;
				ValaCreationMethod* _tmp224_;
				_tmp222_ = st;
				_tmp223_ = vala_struct_get_default_construction_method (_tmp222_);
				_tmp224_ = _tmp223_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp224_);
			}
			_tmp228_ = vala_code_context_get_profile (context);
			_tmp229_ = _tmp228_;
			if (_tmp229_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp230_;
				_tmp230_ = st;
				_tmp227_ = vala_struct_is_simple_type (_tmp230_);
			} else {
				_tmp227_ = FALSE;
			}
			if (_tmp227_) {
				ValaSymbol* _tmp231_;
				ValaSymbol* _tmp232_;
				_tmp231_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp232_ = _tmp231_;
				_tmp226_ = _tmp232_ == NULL;
			} else {
				_tmp226_ = FALSE;
			}
			if (_tmp226_) {
				ValaList* _tmp233_;
				gint _tmp234_;
				gint _tmp235_;
				_tmp233_ = self->priv->object_initializer;
				_tmp234_ = vala_collection_get_size ((ValaCollection*) _tmp233_);
				_tmp235_ = _tmp234_;
				_tmp225_ = _tmp235_ == 0;
			} else {
				_tmp225_ = FALSE;
			}
			if (_tmp225_) {
				ValaSourceReference* _tmp236_;
				ValaSourceReference* _tmp237_;
				ValaStruct* _tmp238_;
				gchar* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp237_ = _tmp236_;
				_tmp238_ = st;
				_tmp239_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp240_);
				_tmp242_ = _tmp241_;
				vala_report_error (_tmp237_, _tmp242_);
				_g_free0 (_tmp242_);
				_g_free0 (_tmp240_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		ValaSourceReference* _tmp243_;
		ValaSourceReference* _tmp244_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp244_ = _tmp243_;
		vala_report_error (_tmp244_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			ValaSourceReference* _tmp245_;
			ValaSourceReference* _tmp246_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp246_ = _tmp245_;
			vala_report_error (_tmp246_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp249_ = _tmp248_;
	if (_tmp249_ == NULL) {
		ValaList* _tmp250_;
		ValaList* _tmp251_;
		gint _tmp252_;
		gint _tmp253_;
		_tmp250_ = vala_object_creation_expression_get_argument_list (self);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_collection_get_size ((ValaCollection*) _tmp251_);
		_tmp253_ = _tmp252_;
		_tmp247_ = _tmp253_ != 0;
		_vala_iterable_unref0 (_tmp251_);
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaTypeSymbol* _tmp256_;
		gchar* _tmp257_;
		gchar* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = type;
		_tmp257_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp256_);
		_tmp258_ = _tmp257_;
		_tmp259_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp258_);
		_tmp260_ = _tmp259_;
		vala_report_error (_tmp255_, _tmp260_);
		_g_free0 (_tmp260_);
		_g_free0 (_tmp258_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp262_ = _tmp261_;
	if (VALA_IS_METHOD (_tmp262_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp263_;
		ValaSymbol* _tmp264_;
		ValaMethod* _tmp265_;
		gboolean _tmp266_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp291_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp292_;
		ValaIterator* _tmp293_;
		ValaMethod* _tmp322_;
		gboolean _tmp323_;
		gboolean _tmp324_;
		ValaSemanticAnalyzer* _tmp381_;
		ValaSemanticAnalyzer* _tmp382_;
		ValaMethod* _tmp383_;
		ValaMethodType* _tmp384_;
		ValaMethodType* _tmp385_;
		ValaMethod* _tmp386_;
		ValaList* _tmp387_;
		ValaList* _tmp388_;
		ValaList* _tmp389_;
		_tmp263_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp264_ = _tmp263_;
		_tmp265_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp265_;
		_tmp266_ = self->priv->_is_yield_expression;
		if (_tmp266_) {
			ValaMethod* _tmp267_;
			gboolean _tmp268_;
			gboolean _tmp269_;
			gboolean _tmp272_ = FALSE;
			ValaSemanticAnalyzer* _tmp273_;
			ValaSemanticAnalyzer* _tmp274_;
			ValaMethod* _tmp275_;
			ValaMethod* _tmp276_;
			_tmp267_ = m;
			_tmp268_ = vala_method_get_coroutine (_tmp267_);
			_tmp269_ = _tmp268_;
			if (!_tmp269_) {
				ValaSourceReference* _tmp270_;
				ValaSourceReference* _tmp271_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp271_ = _tmp270_;
				vala_report_error (_tmp271_, "yield expression requires async method");
			}
			_tmp273_ = vala_code_context_get_analyzer (context);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_semantic_analyzer_get_current_method (_tmp274_);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				_tmp272_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp277_;
				ValaSemanticAnalyzer* _tmp278_;
				ValaMethod* _tmp279_;
				ValaMethod* _tmp280_;
				gboolean _tmp281_;
				gboolean _tmp282_;
				_tmp277_ = vala_code_context_get_analyzer (context);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_semantic_analyzer_get_current_method (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp281_ = vala_method_get_coroutine (_tmp280_);
				_tmp282_ = _tmp281_;
				_tmp272_ = !_tmp282_;
			}
			if (_tmp272_) {
				ValaSourceReference* _tmp283_;
				ValaSourceReference* _tmp284_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp284_ = _tmp283_;
				vala_report_error (_tmp284_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp285_;
			_tmp285_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp285_)) {
				ValaMethod* _tmp286_;
				gboolean _tmp287_;
				gboolean _tmp288_;
				_tmp286_ = m;
				_tmp287_ = vala_method_get_coroutine (_tmp286_);
				_tmp288_ = _tmp287_;
				if (_tmp288_) {
					ValaSourceReference* _tmp289_;
					ValaSourceReference* _tmp290_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp290_ = _tmp289_;
					vala_report_error (_tmp290_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp291_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp291_;
		_tmp292_ = args;
		_tmp293_ = vala_iterable_iterator ((ValaIterable*) _tmp292_);
		arg_it = _tmp293_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp294_;
			ValaList* _tmp295_;
			gint _param_size = 0;
			ValaList* _tmp296_;
			gint _tmp297_;
			gint _tmp298_;
			gint _param_index = 0;
			_tmp294_ = m;
			_tmp295_ = vala_callable_get_parameters ((ValaCallable*) _tmp294_);
			_param_list = _tmp295_;
			_tmp296_ = _param_list;
			_tmp297_ = vala_collection_get_size ((ValaCollection*) _tmp296_);
			_tmp298_ = _tmp297_;
			_param_size = _tmp298_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp299_;
				gpointer _tmp300_;
				ValaParameter* _tmp301_;
				ValaParameter* _tmp302_;
				gboolean _tmp303_;
				gboolean _tmp304_;
				ValaIterator* _tmp305_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp299_ = _param_list;
				_tmp300_ = vala_list_get (_tmp299_, _param_index);
				param = (ValaParameter*) _tmp300_;
				_tmp301_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp301_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp302_ = param;
				_tmp303_ = vala_parameter_get_ellipsis (_tmp302_);
				_tmp304_ = _tmp303_;
				if (_tmp304_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp305_ = arg_it;
				if (vala_iterator_next (_tmp305_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp306_;
					gpointer _tmp307_;
					ValaExpression* _tmp308_;
					ValaParameter* _tmp309_;
					ValaDataType* _tmp310_;
					ValaDataType* _tmp311_;
					ValaExpression* _tmp312_;
					ValaExpression* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaDataType* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaExpression* _tmp320_;
					ValaExpression* _tmp321_;
					_tmp306_ = arg_it;
					_tmp307_ = vala_iterator_get (_tmp306_);
					arg = (ValaExpression*) _tmp307_;
					_tmp308_ = arg;
					_tmp309_ = param;
					_tmp310_ = vala_variable_get_variable_type ((ValaVariable*) _tmp309_);
					_tmp311_ = _tmp310_;
					vala_expression_set_formal_target_type (_tmp308_, _tmp311_);
					_tmp312_ = arg;
					_tmp313_ = arg;
					_tmp314_ = vala_expression_get_formal_target_type (_tmp313_);
					_tmp315_ = _tmp314_;
					_tmp316_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp317_ = _tmp316_;
					_tmp318_ = vala_data_type_get_actual_type (_tmp315_, _tmp317_, NULL, (ValaCodeNode*) self);
					_tmp319_ = _tmp318_;
					vala_expression_set_target_type (_tmp312_, _tmp319_);
					_vala_code_node_unref0 (_tmp319_);
					_tmp320_ = arg;
					_tmp321_ = _vala_code_node_ref0 (_tmp320_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp321_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp322_ = m;
		_tmp323_ = vala_method_get_printf_format (_tmp322_);
		_tmp324_ = _tmp323_;
		if (_tmp324_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp325_;
			ValaStringLiteral* _tmp364_;
			format_literal = NULL;
			_tmp325_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp325_)) {
			} else {
				ValaExpression* _tmp326_;
				_tmp326_ = last_arg;
				if (_tmp326_ != NULL) {
					ValaExpression* _tmp327_;
					ValaStringLiteral* _tmp328_;
					gboolean _tmp329_ = FALSE;
					ValaStringLiteral* _tmp330_;
					_tmp327_ = last_arg;
					_tmp328_ = vala_string_literal_get_format_literal (_tmp327_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp328_;
					_tmp330_ = format_literal;
					if (_tmp330_ == NULL) {
						ValaList* _tmp331_;
						gint _tmp332_;
						gint _tmp333_;
						ValaMethod* _tmp334_;
						ValaList* _tmp335_;
						ValaList* _tmp336_;
						gint _tmp337_;
						gint _tmp338_;
						_tmp331_ = args;
						_tmp332_ = vala_collection_get_size ((ValaCollection*) _tmp331_);
						_tmp333_ = _tmp332_;
						_tmp334_ = m;
						_tmp335_ = vala_callable_get_parameters ((ValaCallable*) _tmp334_);
						_tmp336_ = _tmp335_;
						_tmp337_ = vala_collection_get_size ((ValaCollection*) _tmp336_);
						_tmp338_ = _tmp337_;
						_tmp329_ = _tmp333_ == (_tmp338_ - 1);
						_vala_iterable_unref0 (_tmp336_);
					} else {
						_tmp329_ = FALSE;
					}
					if (_tmp329_) {
						ValaStringLiteral* _tmp339_;
						ValaStringLiteral* _tmp340_;
						ValaSemanticAnalyzer* _tmp341_;
						ValaSemanticAnalyzer* _tmp342_;
						ValaDataType* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						ValaList* _tmp346_;
						ValaList* _tmp347_;
						gint _tmp348_;
						gint _tmp349_;
						ValaStringLiteral* _tmp350_;
						ValaList* _tmp351_;
						ValaIterator* _tmp352_;
						_tmp339_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp339_;
						_tmp340_ = format_literal;
						_tmp341_ = vala_code_context_get_analyzer (context);
						_tmp342_ = _tmp341_;
						_tmp343_ = _tmp342_->string_type;
						_tmp344_ = vala_data_type_copy (_tmp343_);
						_tmp345_ = _tmp344_;
						vala_expression_set_target_type ((ValaExpression*) _tmp340_, _tmp345_);
						_vala_code_node_unref0 (_tmp345_);
						_tmp346_ = self->priv->argument_list;
						_tmp347_ = args;
						_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
						_tmp349_ = _tmp348_;
						_tmp350_ = format_literal;
						vala_list_insert (_tmp346_, _tmp349_ - 1, (ValaExpression*) _tmp350_);
						_tmp351_ = self->priv->argument_list;
						_tmp352_ = vala_iterable_iterator ((ValaIterable*) _tmp351_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp352_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp353_;
							ValaList* _tmp354_;
							gint _param_size = 0;
							ValaList* _tmp355_;
							gint _tmp356_;
							gint _tmp357_;
							gint _param_index = 0;
							_tmp353_ = m;
							_tmp354_ = vala_callable_get_parameters ((ValaCallable*) _tmp353_);
							_param_list = _tmp354_;
							_tmp355_ = _param_list;
							_tmp356_ = vala_collection_get_size ((ValaCollection*) _tmp355_);
							_tmp357_ = _tmp356_;
							_param_size = _tmp357_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp358_;
								gpointer _tmp359_;
								ValaParameter* _tmp360_;
								gboolean _tmp361_;
								gboolean _tmp362_;
								ValaIterator* _tmp363_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp358_ = _param_list;
								_tmp359_ = vala_list_get (_tmp358_, _param_index);
								param = (ValaParameter*) _tmp359_;
								_tmp360_ = param;
								_tmp361_ = vala_parameter_get_ellipsis (_tmp360_);
								_tmp362_ = _tmp361_;
								if (_tmp362_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp363_ = arg_it;
								vala_iterator_next (_tmp363_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp364_ = format_literal;
			if (_tmp364_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp365_;
				gchar* _tmp366_;
				ValaSemanticAnalyzer* _tmp367_;
				ValaSemanticAnalyzer* _tmp368_;
				const gchar* _tmp369_;
				ValaIterator* _tmp370_;
				ValaSourceReference* _tmp371_;
				ValaSourceReference* _tmp372_;
				_tmp365_ = format_literal;
				_tmp366_ = vala_string_literal_eval (_tmp365_);
				format = _tmp366_;
				_tmp367_ = vala_code_context_get_analyzer (context);
				_tmp368_ = _tmp367_;
				_tmp369_ = format;
				_tmp370_ = arg_it;
				_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp372_ = _tmp371_;
				if (!vala_semantic_analyzer_check_print_format (_tmp368_, _tmp369_, _tmp370_, _tmp372_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp373_;
			ValaList* _tmp374_;
			gint _arg_size = 0;
			ValaList* _tmp375_;
			gint _tmp376_;
			gint _tmp377_;
			gint _arg_index = 0;
			_tmp373_ = args;
			_tmp374_ = _vala_iterable_ref0 (_tmp373_);
			_arg_list = _tmp374_;
			_tmp375_ = _arg_list;
			_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
			_tmp377_ = _tmp376_;
			_arg_size = _tmp377_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp378_;
				gpointer _tmp379_;
				ValaExpression* _tmp380_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp378_ = _arg_list;
				_tmp379_ = vala_list_get (_tmp378_, _arg_index);
				arg = (ValaExpression*) _tmp379_;
				_tmp380_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp380_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp381_ = vala_code_context_get_analyzer (context);
		_tmp382_ = _tmp381_;
		_tmp383_ = m;
		_tmp384_ = vala_method_type_new (_tmp383_);
		_tmp385_ = _tmp384_;
		_tmp386_ = m;
		_tmp387_ = vala_callable_get_parameters ((ValaCallable*) _tmp386_);
		_tmp388_ = _tmp387_;
		_tmp389_ = args;
		vala_semantic_analyzer_check_arguments (_tmp382_, (ValaExpression*) self, (ValaDataType*) _tmp385_, _tmp388_, _tmp389_);
		_vala_iterable_unref0 (_tmp388_);
		_vala_code_node_unref0 (_tmp385_);
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp390_;
		ValaDataType* _tmp391_;
		_tmp390_ = vala_object_creation_expression_get_type_reference (self);
		_tmp391_ = _tmp390_;
		if (VALA_IS_ERROR_TYPE (_tmp391_)) {
			ValaDataType* _tmp392_;
			ValaDataType* _tmp393_;
			ValaMemberAccess* _tmp396_;
			ValaMemberAccess* _tmp397_;
			ValaList* _tmp416_;
			ValaList* _tmp417_;
			gint _tmp418_;
			gint _tmp419_;
			gboolean _tmp420_;
			_tmp392_ = vala_object_creation_expression_get_type_reference (self);
			_tmp393_ = _tmp392_;
			if (_tmp393_ != NULL) {
				ValaDataType* _tmp394_;
				ValaDataType* _tmp395_;
				_tmp394_ = vala_object_creation_expression_get_type_reference (self);
				_tmp395_ = _tmp394_;
				vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
			}
			_tmp396_ = vala_object_creation_expression_get_member_name (self);
			_tmp397_ = _tmp396_;
			if (_tmp397_ != NULL) {
				ValaMemberAccess* _tmp398_;
				ValaMemberAccess* _tmp399_;
				_tmp398_ = vala_object_creation_expression_get_member_name (self);
				_tmp399_ = _tmp398_;
				vala_code_node_check ((ValaCodeNode*) _tmp399_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp400_;
				ValaList* _tmp401_;
				gint _arg_size = 0;
				ValaList* _tmp402_;
				gint _tmp403_;
				gint _tmp404_;
				gint _arg_index = 0;
				_tmp400_ = self->priv->argument_list;
				_tmp401_ = _vala_iterable_ref0 (_tmp400_);
				_arg_list = _tmp401_;
				_tmp402_ = _arg_list;
				_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
				_tmp404_ = _tmp403_;
				_arg_size = _tmp404_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp405_;
					gpointer _tmp406_;
					ValaExpression* _tmp407_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp405_ = _arg_list;
					_tmp406_ = vala_list_get (_tmp405_, _arg_index);
					arg = (ValaExpression*) _tmp406_;
					_tmp407_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp407_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp408_;
				ValaList* _tmp409_;
				gint _init_size = 0;
				ValaList* _tmp410_;
				gint _tmp411_;
				gint _tmp412_;
				gint _init_index = 0;
				_tmp408_ = self->priv->object_initializer;
				_tmp409_ = _vala_iterable_ref0 (_tmp408_);
				_init_list = _tmp409_;
				_tmp410_ = _init_list;
				_tmp411_ = vala_collection_get_size ((ValaCollection*) _tmp410_);
				_tmp412_ = _tmp411_;
				_init_size = _tmp412_;
				_init_index = -1;
				while (TRUE) {
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp413_;
					gpointer _tmp414_;
					ValaMemberInitializer* _tmp415_;
					_init_index = _init_index + 1;
					if (!(_init_index < _init_size)) {
						break;
					}
					_tmp413_ = _init_list;
					_tmp414_ = vala_list_get (_tmp413_, _init_index);
					init = (ValaMemberInitializer*) _tmp414_;
					_tmp415_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp415_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp416_ = vala_object_creation_expression_get_argument_list (self);
			_tmp417_ = _tmp416_;
			_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
			_tmp419_ = _tmp418_;
			_tmp420_ = _tmp419_ == 0;
			_vala_iterable_unref0 (_tmp417_);
			if (_tmp420_) {
				ValaSourceReference* _tmp421_;
				ValaSourceReference* _tmp422_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp421_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp422_ = _tmp421_;
				vala_report_error (_tmp422_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp423_;
				ValaList* _tmp424_;
				ValaIterator* _tmp425_;
				ValaIterator* _tmp426_;
				ValaIterator* _tmp427_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp428_;
				gpointer _tmp429_;
				gboolean _tmp430_ = FALSE;
				ValaExpression* _tmp431_;
				ValaDataType* _tmp432_;
				ValaDataType* _tmp433_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp442_;
				ValaStringLiteral* _tmp443_;
				ValaStringLiteral* _tmp444_;
				ValaList* _tmp453_;
				ValaList* _tmp454_;
				ValaIterator* _tmp455_;
				ValaIterator* _tmp456_;
				ValaSemanticAnalyzer* _tmp457_;
				ValaSemanticAnalyzer* _tmp458_;
				ValaIterator* _tmp459_;
				ValaSourceReference* _tmp460_;
				ValaSourceReference* _tmp461_;
				_tmp423_ = vala_object_creation_expression_get_argument_list (self);
				_tmp424_ = _tmp423_;
				_tmp425_ = vala_iterable_iterator ((ValaIterable*) _tmp424_);
				_tmp426_ = _tmp425_;
				_vala_iterable_unref0 (_tmp424_);
				arg_it = _tmp426_;
				_tmp427_ = arg_it;
				vala_iterator_next (_tmp427_);
				_tmp428_ = arg_it;
				_tmp429_ = vala_iterator_get (_tmp428_);
				ex = (ValaExpression*) _tmp429_;
				_tmp431_ = ex;
				_tmp432_ = vala_expression_get_value_type (_tmp431_);
				_tmp433_ = _tmp432_;
				if (_tmp433_ == NULL) {
					_tmp430_ = TRUE;
				} else {
					ValaExpression* _tmp434_;
					ValaDataType* _tmp435_;
					ValaDataType* _tmp436_;
					ValaSemanticAnalyzer* _tmp437_;
					ValaSemanticAnalyzer* _tmp438_;
					ValaDataType* _tmp439_;
					_tmp434_ = ex;
					_tmp435_ = vala_expression_get_value_type (_tmp434_);
					_tmp436_ = _tmp435_;
					_tmp437_ = vala_code_context_get_analyzer (context);
					_tmp438_ = _tmp437_;
					_tmp439_ = _tmp438_->string_type;
					_tmp430_ = !vala_data_type_compatible (_tmp436_, _tmp439_);
				}
				if (_tmp430_) {
					ValaSourceReference* _tmp440_;
					ValaSourceReference* _tmp441_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp441_ = _tmp440_;
					vala_report_error (_tmp441_, "Invalid type for argument 1");
				}
				_tmp442_ = ex;
				_tmp443_ = vala_string_literal_get_format_literal (_tmp442_);
				format_literal = _tmp443_;
				_tmp444_ = format_literal;
				if (_tmp444_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp445_;
					gchar* _tmp446_;
					ValaSemanticAnalyzer* _tmp447_;
					ValaSemanticAnalyzer* _tmp448_;
					const gchar* _tmp449_;
					ValaIterator* _tmp450_;
					ValaSourceReference* _tmp451_;
					ValaSourceReference* _tmp452_;
					_tmp445_ = format_literal;
					_tmp446_ = vala_string_literal_eval (_tmp445_);
					format = _tmp446_;
					_tmp447_ = vala_code_context_get_analyzer (context);
					_tmp448_ = _tmp447_;
					_tmp449_ = format;
					_tmp450_ = arg_it;
					_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp452_ = _tmp451_;
					if (!vala_semantic_analyzer_check_print_format (_tmp448_, _tmp449_, _tmp450_, _tmp452_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp453_ = vala_object_creation_expression_get_argument_list (self);
				_tmp454_ = _tmp453_;
				_tmp455_ = vala_iterable_iterator ((ValaIterable*) _tmp454_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp455_;
				_vala_iterable_unref0 (_tmp454_);
				_tmp456_ = arg_it;
				vala_iterator_next (_tmp456_);
				_tmp457_ = vala_code_context_get_analyzer (context);
				_tmp458_ = _tmp457_;
				_tmp459_ = arg_it;
				_tmp460_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp461_ = _tmp460_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp458_, _tmp459_, 1, _tmp461_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp462_;
		gint _arg_size = 0;
		ValaList* _tmp463_;
		gint _tmp464_;
		gint _tmp465_;
		gint _arg_index = 0;
		_tmp462_ = vala_object_creation_expression_get_argument_list (self);
		_arg_list = _tmp462_;
		_tmp463_ = _arg_list;
		_tmp464_ = vala_collection_get_size ((ValaCollection*) _tmp463_);
		_tmp465_ = _tmp464_;
		_arg_size = _tmp465_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp466_;
			gpointer _tmp467_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp468_;
			gboolean _tmp469_ = FALSE;
			ValaSizeofExpression* _tmp470_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp466_ = _arg_list;
			_tmp467_ = vala_list_get (_tmp466_, _arg_index);
			arg = (ValaExpression*) _tmp467_;
			_tmp468_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp468_) ? ((ValaSizeofExpression*) _tmp468_) : NULL;
			_tmp470_ = sizeof_expr;
			if (_tmp470_ != NULL) {
				ValaSizeofExpression* _tmp471_;
				ValaDataType* _tmp472_;
				ValaDataType* _tmp473_;
				_tmp471_ = sizeof_expr;
				_tmp472_ = vala_sizeof_expression_get_type_reference (_tmp471_);
				_tmp473_ = _tmp472_;
				_tmp469_ = VALA_IS_GENERIC_TYPE (_tmp473_);
			} else {
				_tmp469_ = FALSE;
			}
			if (_tmp469_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp474_;
				ValaDataType* _tmp475_;
				ValaDataType* _tmp476_;
				ValaDataType* _tmp477_;
				ValaDataType* _tmp478_;
				ValaDataType* _tmp479_;
				ValaDataType* _tmp480_;
				ValaList* _tmp481_;
				ValaList* _tmp482_;
				ValaDataType* _tmp483_;
				ValaDataType* _tmp484_;
				ValaExpression* _tmp485_;
				ValaDataType* _tmp486_;
				ValaSourceReference* _tmp487_;
				ValaSourceReference* _tmp488_;
				ValaSizeofExpression* _tmp489_;
				ValaSizeofExpression* _tmp490_;
				_tmp474_ = sizeof_expr;
				_tmp475_ = vala_sizeof_expression_get_type_reference (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_object_creation_expression_get_type_reference (self);
				_tmp478_ = _tmp477_;
				_tmp479_ = vala_object_creation_expression_get_type_reference (self);
				_tmp480_ = _tmp479_;
				_tmp481_ = vala_data_type_get_type_arguments (_tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = vala_data_type_get_actual_type (_tmp476_, _tmp478_, _tmp482_, (ValaCodeNode*) self);
				_tmp484_ = _tmp483_;
				_vala_iterable_unref0 (_tmp482_);
				sizeof_type = _tmp484_;
				_tmp485_ = arg;
				_tmp486_ = sizeof_type;
				_tmp487_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp488_ = _tmp487_;
				_tmp489_ = vala_sizeof_expression_new (_tmp486_, _tmp488_);
				_tmp490_ = _tmp489_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp485_, (ValaExpression*) _tmp490_);
				_vala_code_node_unref0 (_tmp490_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp491_;
		gint _init_size = 0;
		ValaList* _tmp492_;
		gint _tmp493_;
		gint _tmp494_;
		gint _init_index = 0;
		_tmp491_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp491_;
		_tmp492_ = _init_list;
		_tmp493_ = vala_collection_get_size ((ValaCollection*) _tmp492_);
		_tmp494_ = _tmp493_;
		_init_size = _tmp494_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp495_;
			gpointer _tmp496_;
			ValaSemanticAnalyzer* _tmp497_;
			ValaSemanticAnalyzer* _tmp498_;
			ValaMemberInitializer* _tmp499_;
			ValaDataType* _tmp500_;
			ValaDataType* _tmp501_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp495_ = _init_list;
			_tmp496_ = vala_list_get (_tmp495_, _init_index);
			init = (ValaMemberInitializer*) _tmp496_;
			_tmp497_ = vala_code_context_get_analyzer (context);
			_tmp498_ = _tmp497_;
			_tmp499_ = init;
			_tmp500_ = vala_object_creation_expression_get_type_reference (self);
			_tmp501_ = _tmp500_;
			vala_semantic_analyzer_visit_member_initializer (_tmp498_, _tmp499_, _tmp501_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp502_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp503_ = _tmp502_;
	if (_tmp503_) {
		gboolean _tmp504_ = FALSE;
		ValaCodeNode* _tmp505_;
		ValaCodeNode* _tmp506_;
		_tmp505_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp506_ = _tmp505_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp506_)) {
			_tmp504_ = TRUE;
		} else {
			ValaCodeNode* _tmp507_;
			ValaCodeNode* _tmp508_;
			_tmp507_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp508_ = _tmp507_;
			_tmp504_ = VALA_IS_EXPRESSION_STATEMENT (_tmp508_);
		}
		if (_tmp504_) {
		} else {
			ValaSemanticAnalyzer* _tmp509_;
			ValaSemanticAnalyzer* _tmp510_;
			ValaSymbol* _tmp511_;
			ValaSymbol* _tmp512_;
			_tmp509_ = vala_code_context_get_analyzer (context);
			_tmp510_ = _tmp509_;
			_tmp511_ = vala_semantic_analyzer_get_current_symbol (_tmp510_);
			_tmp512_ = _tmp511_;
			if (!VALA_IS_BLOCK (_tmp512_)) {
				ValaSourceReference* _tmp513_;
				ValaSourceReference* _tmp514_;
				_tmp513_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp514_ = _tmp513_;
				vala_report_error (_tmp514_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp515_;
				ValaCodeNode* _tmp516_;
				ValaCodeNode* _tmp517_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp518_;
				ValaDataType* _tmp519_;
				ValaDataType* _tmp520_;
				ValaDataType* _tmp521_;
				gchar* _tmp522_;
				gchar* _tmp523_;
				ValaSourceReference* _tmp524_;
				ValaSourceReference* _tmp525_;
				ValaLocalVariable* _tmp526_;
				ValaLocalVariable* _tmp527_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp528_;
				ValaSourceReference* _tmp529_;
				ValaSourceReference* _tmp530_;
				ValaDeclarationStatement* _tmp531_;
				ValaSemanticAnalyzer* _tmp532_;
				ValaSemanticAnalyzer* _tmp533_;
				ValaBlock* _tmp534_;
				ValaDeclarationStatement* _tmp535_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp536_;
				ValaDataType* _tmp537_;
				ValaDataType* _tmp538_;
				ValaExpression* _tmp539_;
				ValaLocalVariable* _tmp540_;
				ValaDeclarationStatement* _tmp541_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp542_;
				ValaSemanticAnalyzer* _tmp543_;
				ValaSymbol* _tmp544_;
				ValaSymbol* _tmp545_;
				ValaBlock* _tmp546_;
				ValaBlock* _tmp547_;
				ValaLocalVariable* _tmp548_;
				ValaSemanticAnalyzer* _tmp549_;
				ValaSemanticAnalyzer* _tmp550_;
				ValaBlock* _tmp551_;
				ValaLocalVariable* _tmp552_;
				ValaCodeNode* _tmp553_;
				ValaExpression* _tmp554_;
				ValaExpression* _tmp555_;
				_tmp515_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp516_ = _tmp515_;
				_tmp517_ = _vala_code_node_ref0 (_tmp516_);
				old_parent_node = _tmp517_;
				_tmp518_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_data_type_copy (_tmp519_);
				_tmp521_ = _tmp520_;
				_tmp522_ = vala_code_node_get_temp_name ();
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp525_ = _tmp524_;
				_tmp526_ = vala_local_variable_new (_tmp521_, _tmp523_, NULL, _tmp525_);
				_tmp527_ = _tmp526_;
				_g_free0 (_tmp523_);
				_vala_code_node_unref0 (_tmp521_);
				local = _tmp527_;
				_tmp528_ = local;
				_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp530_ = _tmp529_;
				_tmp531_ = vala_declaration_statement_new ((ValaSymbol*) _tmp528_, _tmp530_);
				decl = _tmp531_;
				_tmp532_ = vala_code_context_get_analyzer (context);
				_tmp533_ = _tmp532_;
				_tmp534_ = _tmp533_->insert_block;
				_tmp535_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp534_, (ValaStatement*) _tmp535_);
				_tmp536_ = local;
				_tmp537_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp538_ = _tmp537_;
				_tmp539_ = vala_semantic_analyzer_create_temp_access (_tmp536_, _tmp538_);
				temp_access = _tmp539_;
				_tmp540_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp540_, (ValaExpression*) self);
				_tmp541_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp541_, context);
				_tmp542_ = vala_code_context_get_analyzer (context);
				_tmp543_ = _tmp542_;
				_tmp544_ = vala_semantic_analyzer_get_current_symbol (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp545_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp546_;
				_tmp547_ = block;
				_tmp548_ = local;
				vala_block_remove_local_variable (_tmp547_, _tmp548_);
				_tmp549_ = vala_code_context_get_analyzer (context);
				_tmp550_ = _tmp549_;
				_tmp551_ = _tmp550_->insert_block;
				_tmp552_ = local;
				vala_block_add_local_variable (_tmp551_, _tmp552_);
				_tmp553_ = old_parent_node;
				_tmp554_ = temp_access;
				vala_code_node_replace_expression (_tmp553_, (ValaExpression*) self, _tmp554_);
				_tmp555_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp555_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp556_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp557_ = _tmp556_;
	result = !_tmp557_;
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp8_ = self->priv->object_initializer;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaMemberInitializer* _tmp15_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp13_ = _init_list;
			_tmp14_ = vala_list_get (_tmp13_, _init_index);
			init = (ValaMemberInitializer*) _tmp14_;
			_tmp15_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp15_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp7_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp8_ = self->priv->object_initializer;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaMemberInitializer* _tmp15_;
			_init_index = _init_index + 1;
			if (!(_init_index < _init_size)) {
				break;
			}
			_tmp13_ = _init_list;
			_tmp14_ = vala_list_get (_tmp13_, _init_index);
			init = (ValaMemberInitializer*) _tmp14_;
			_tmp15_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}

