/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp26_ = FALSE;
	ValaExpression* _tmp27_;
	ValaExpression* _tmp28_;
	ValaSemanticAnalyzer* _tmp43_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSymbol* _tmp45_;
	ValaSymbol* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	ValaArrayType* _tmp107_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	ValaArrayType* _tmp122_;
	gboolean _tmp133_ = FALSE;
	ValaExpression* _tmp134_;
	ValaExpression* _tmp135_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp251_;
	ValaSemanticAnalyzer* _tmp252_;
	ValaSymbol* _tmp253_;
	ValaSymbol* _tmp254_;
	ValaBlock* _tmp255_;
	ValaBlock* _tmp256_;
	gboolean _tmp258_;
	gboolean _tmp259_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_experimental_non_null (context);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_REFERENCE_TYPE (_tmp7_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaArrayType* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaArrayType* _tmp12_;
			_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp9_) ? ((ValaArrayType*) _tmp9_) : NULL);
			array_type = _tmp10_;
			_tmp12_ = array_type;
			if (_tmp12_ != NULL) {
				ValaArrayType* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				_tmp13_ = array_type;
				_tmp14_ = vala_array_type_get_fixed_length (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp11_ = _tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
			} else {
				ValaDataType* _tmp16_;
				ValaDataType* _tmp17_;
				_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp17_ = _tmp16_;
				vala_data_type_set_nullable (_tmp17_, TRUE);
			}
			_vala_code_node_unref0 (array_type);
		}
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		_tmp20_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp21_ = _tmp20_;
		if (VALA_IS_VOID_TYPE (_tmp21_)) {
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp23_ = _tmp22_;
			vala_report_error (_tmp23_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp24_;
			ValaDataType* _tmp25_;
			_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp25_ = _tmp24_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp25_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp27_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp30_ = _tmp29_;
		_tmp26_ = !_tmp30_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaExpression* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		_tmp31_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp34_ = _tmp33_;
		vala_expression_set_target_type (_tmp32_, _tmp34_);
		_tmp35_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp36_ = _tmp35_;
		if (VALA_IS_INITIALIZER_LIST (_tmp36_)) {
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp37_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp40_ = _tmp39_;
			initializer_size = _tmp40_;
			is_initializer_list = TRUE;
		}
		_tmp41_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp42_ = _tmp41_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp42_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	}
	_tmp43_ = vala_code_context_get_analyzer (context);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_semantic_analyzer_get_current_symbol (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_symbol_get_scope (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp50_ = _tmp49_;
	vala_scope_add (_tmp48_, _tmp50_, (ValaSymbol*) self);
	_tmp51_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp52_ = _tmp51_;
	if (_tmp52_) {
		result = FALSE;
		return result;
	}
	_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp54_ = _tmp53_;
	if (_tmp54_ == NULL) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		gboolean _tmp65_ = FALSE;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaDataType* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		ValaDataType* _tmp95_;
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaDataType* _tmp98_;
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		if (_tmp56_ == NULL) {
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp58_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_expression_get_value_type (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp62_ == NULL) {
			ValaSourceReference* _tmp63_;
			ValaSourceReference* _tmp64_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp64_ = _tmp63_;
			vala_report_error (_tmp64_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp66_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_expression_get_value_type (_tmp67_);
		_tmp69_ = _tmp68_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp69_)) {
			_tmp65_ = TRUE;
		} else {
			ValaExpression* _tmp70_;
			ValaExpression* _tmp71_;
			ValaDataType* _tmp72_;
			ValaDataType* _tmp73_;
			_tmp70_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_expression_get_value_type (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp65_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp73_);
		}
		if (_tmp65_) {
			ValaExpression* _tmp74_;
			ValaExpression* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceReference* _tmp77_;
			ValaExpression* _tmp78_;
			ValaExpression* _tmp79_;
			ValaSymbol* _tmp80_;
			ValaSymbol* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_expression_get_symbol_reference (_tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_symbol_get_full_name (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp83_);
			_tmp85_ = _tmp84_;
			vala_report_error (_tmp77_, _tmp85_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp83_);
			result = FALSE;
			return result;
		}
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_expression_get_value_type (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_data_type_copy (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp91_);
		_vala_code_node_unref0 (_tmp91_);
		_tmp92_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp93_ = _tmp92_;
		vala_data_type_set_value_owned (_tmp93_, TRUE);
		_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp95_ = _tmp94_;
		vala_data_type_set_floating_reference (_tmp95_, FALSE);
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		vala_expression_set_target_type (_tmp97_, _tmp99_);
		_tmp100_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
	}
	_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp103_ = _tmp102_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp103_) ? ((ValaArrayType*) _tmp103_) : NULL;
	_tmp107_ = variable_array_type;
	if (_tmp107_ != NULL) {
		ValaArrayType* _tmp108_;
		gboolean _tmp109_;
		gboolean _tmp110_;
		_tmp108_ = variable_array_type;
		_tmp109_ = vala_array_type_get_inline_allocated (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp106_ = _tmp110_;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		_tmp105_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp112_);
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaInitializerList* _tmp115_;
		ValaInitializerList* _tmp116_;
		_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp116_ = _tmp115_;
		_tmp104_ = _tmp116_ == NULL;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		vala_report_warning (_tmp118_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp122_ = variable_array_type;
	if (_tmp122_ != NULL) {
		ValaArrayType* _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp125_;
		_tmp123_ = variable_array_type;
		_tmp124_ = vala_array_type_get_inline_allocated (_tmp123_);
		_tmp125_ = _tmp124_;
		_tmp121_ = _tmp125_;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		ValaArrayType* _tmp126_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		_tmp126_ = variable_array_type;
		_tmp127_ = vala_array_type_get_length (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp120_ = _tmp128_ == NULL;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		_tmp129_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		_tmp119_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp130_);
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		vala_report_error (_tmp132_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp134_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp135_ = _tmp134_;
	if (_tmp135_ != NULL) {
		ValaExpression* _tmp136_;
		ValaExpression* _tmp137_;
		gboolean _tmp138_;
		gboolean _tmp139_;
		_tmp136_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_code_node_get_error ((ValaCodeNode*) _tmp137_);
		_tmp139_ = _tmp138_;
		_tmp133_ = !_tmp139_;
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaExpression* _tmp140_;
		ValaExpression* _tmp141_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		ValaExpression* _tmp189_;
		ValaExpression* _tmp190_;
		ValaDataType* _tmp191_;
		ValaDataType* _tmp192_;
		ValaDataType* _tmp193_;
		ValaDataType* _tmp194_;
		gboolean _tmp209_ = FALSE;
		gboolean _tmp210_ = FALSE;
		gboolean _tmp211_ = FALSE;
		ValaArrayType* _tmp212_;
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		ValaArrayType* _tmp228_;
		ValaExpression* _tmp238_;
		ValaExpression* _tmp239_;
		ValaDataType* _tmp240_;
		ValaDataType* _tmp241_;
		_tmp140_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_expression_get_value_type (_tmp141_);
		_tmp143_ = _tmp142_;
		if (_tmp143_ == NULL) {
			gboolean _tmp144_ = FALSE;
			ValaExpression* _tmp145_;
			ValaExpression* _tmp146_;
			gboolean _tmp151_ = FALSE;
			ValaExpression* _tmp152_;
			ValaExpression* _tmp153_;
			ValaSymbol* _tmp154_;
			ValaSymbol* _tmp155_;
			_tmp145_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp146_ = _tmp145_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp146_)) {
				ValaExpression* _tmp147_;
				ValaExpression* _tmp148_;
				_tmp147_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp148_ = _tmp147_;
				_tmp144_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp148_);
			} else {
				_tmp144_ = FALSE;
			}
			if (_tmp144_) {
				ValaSourceReference* _tmp149_;
				ValaSourceReference* _tmp150_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp150_ = _tmp149_;
				vala_report_error (_tmp150_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp152_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_expression_get_symbol_reference (_tmp153_);
			_tmp155_ = _tmp154_;
			if (VALA_IS_METHOD (_tmp155_)) {
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp157_ = _tmp156_;
				_tmp151_ = VALA_IS_DELEGATE_TYPE (_tmp157_);
			} else {
				_tmp151_ = FALSE;
			}
			if (_tmp151_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp158_;
				ValaExpression* _tmp159_;
				ValaSymbol* _tmp160_;
				ValaSymbol* _tmp161_;
				ValaMethod* _tmp162_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				ValaDelegateType* _tmp165_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp166_;
				ValaDelegate* _tmp167_;
				ValaDelegate* _tmp168_;
				ValaDelegate* _tmp169_;
				ValaDelegate* _tmp170_;
				ValaMethod* _tmp171_;
				ValaDelegateType* _tmp172_;
				ValaExpression* _tmp183_;
				ValaExpression* _tmp184_;
				ValaDataType* _tmp185_;
				ValaDataType* _tmp186_;
				_tmp158_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_expression_get_symbol_reference (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp162_;
				_tmp163_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp164_ = _tmp163_;
				_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp165_;
				_tmp166_ = dt;
				_tmp167_ = vala_delegate_type_get_delegate_symbol (_tmp166_);
				_tmp168_ = _tmp167_;
				_tmp169_ = _vala_code_node_ref0 (_tmp168_);
				cb = _tmp169_;
				_tmp170_ = cb;
				_tmp171_ = m;
				_tmp172_ = dt;
				if (!vala_delegate_matches_method (_tmp170_, _tmp171_, (ValaDataType*) _tmp172_)) {
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					ValaMethod* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					ValaDelegate* _tmp178_;
					gchar* _tmp179_;
					gchar* _tmp180_;
					gchar* _tmp181_;
					gchar* _tmp182_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = m;
					_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					_tmp178_ = cb;
					_tmp179_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp177_, _tmp180_);
					_tmp182_ = _tmp181_;
					vala_report_error (_tmp174_, _tmp182_);
					_g_free0 (_tmp182_);
					_g_free0 (_tmp180_);
					_g_free0 (_tmp177_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp183_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp186_ = _tmp185_;
				vala_expression_set_value_type (_tmp184_, _tmp186_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp188_ = _tmp187_;
				vala_report_error (_tmp188_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp189_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp190_ = _tmp189_;
		_tmp191_ = vala_expression_get_value_type (_tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp194_ = _tmp193_;
		if (!vala_data_type_compatible (_tmp192_, _tmp194_)) {
			ValaSourceReference* _tmp195_;
			ValaSourceReference* _tmp196_;
			ValaExpression* _tmp197_;
			ValaExpression* _tmp198_;
			ValaDataType* _tmp199_;
			ValaDataType* _tmp200_;
			gchar* _tmp201_;
			gchar* _tmp202_;
			ValaDataType* _tmp203_;
			ValaDataType* _tmp204_;
			gchar* _tmp205_;
			gchar* _tmp206_;
			gchar* _tmp207_;
			gchar* _tmp208_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp196_ = _tmp195_;
			_tmp197_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp198_ = _tmp197_;
			_tmp199_ = vala_expression_get_value_type (_tmp198_);
			_tmp200_ = _tmp199_;
			_tmp201_ = vala_code_node_to_string ((ValaCodeNode*) _tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_code_node_to_string ((ValaCodeNode*) _tmp204_);
			_tmp206_ = _tmp205_;
			_tmp207_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp202_, _tmp206_);
			_tmp208_ = _tmp207_;
			vala_report_error (_tmp196_, _tmp208_);
			_g_free0 (_tmp208_);
			_g_free0 (_tmp206_);
			_g_free0 (_tmp202_);
			result = FALSE;
			return result;
		}
		_tmp212_ = variable_array_type;
		if (_tmp212_ != NULL) {
			ValaArrayType* _tmp213_;
			gboolean _tmp214_;
			gboolean _tmp215_;
			_tmp213_ = variable_array_type;
			_tmp214_ = vala_array_type_get_inline_allocated (_tmp213_);
			_tmp215_ = _tmp214_;
			_tmp211_ = _tmp215_;
		} else {
			_tmp211_ = FALSE;
		}
		if (_tmp211_) {
			ValaArrayType* _tmp216_;
			gboolean _tmp217_;
			gboolean _tmp218_;
			_tmp216_ = variable_array_type;
			_tmp217_ = vala_array_type_get_fixed_length (_tmp216_);
			_tmp218_ = _tmp217_;
			_tmp210_ = !_tmp218_;
		} else {
			_tmp210_ = FALSE;
		}
		if (_tmp210_) {
			_tmp209_ = is_initializer_list;
		} else {
			_tmp209_ = FALSE;
		}
		if (_tmp209_) {
			ValaArrayType* _tmp219_;
			gchar* _tmp220_;
			gchar* _tmp221_;
			ValaIntegerLiteral* _tmp222_;
			ValaIntegerLiteral* _tmp223_;
			ValaArrayType* _tmp224_;
			ValaArrayType* _tmp225_;
			_tmp219_ = variable_array_type;
			_tmp220_ = g_strdup_printf ("%i", initializer_size);
			_tmp221_ = _tmp220_;
			_tmp222_ = vala_integer_literal_new (_tmp221_, NULL);
			_tmp223_ = _tmp222_;
			vala_array_type_set_length (_tmp219_, (ValaExpression*) _tmp223_);
			_vala_code_node_unref0 (_tmp223_);
			_g_free0 (_tmp221_);
			_tmp224_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp224_, TRUE);
			_tmp225_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp225_, FALSE);
		}
		_tmp228_ = variable_array_type;
		if (_tmp228_ != NULL) {
			ValaArrayType* _tmp229_;
			gboolean _tmp230_;
			gboolean _tmp231_;
			_tmp229_ = variable_array_type;
			_tmp230_ = vala_array_type_get_inline_allocated (_tmp229_);
			_tmp231_ = _tmp230_;
			_tmp227_ = _tmp231_;
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			ValaExpression* _tmp232_;
			ValaExpression* _tmp233_;
			ValaDataType* _tmp234_;
			ValaDataType* _tmp235_;
			_tmp232_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp233_ = _tmp232_;
			_tmp234_ = vala_expression_get_value_type (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp226_ = VALA_IS_ARRAY_TYPE (_tmp235_) == FALSE;
		} else {
			_tmp226_ = FALSE;
		}
		if (_tmp226_) {
			ValaSourceReference* _tmp236_;
			ValaSourceReference* _tmp237_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp237_ = _tmp236_;
			vala_report_error (_tmp237_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp238_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_expression_get_value_type (_tmp239_);
		_tmp241_ = _tmp240_;
		if (vala_data_type_is_disposable (_tmp241_)) {
			gboolean _tmp242_ = FALSE;
			ValaDataType* _tmp243_;
			ValaDataType* _tmp244_;
			_tmp243_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp244_ = _tmp243_;
			if (!VALA_IS_POINTER_TYPE (_tmp244_)) {
				ValaDataType* _tmp245_;
				ValaDataType* _tmp246_;
				gboolean _tmp247_;
				gboolean _tmp248_;
				_tmp245_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_data_type_get_value_owned (_tmp246_);
				_tmp248_ = _tmp247_;
				_tmp242_ = !_tmp248_;
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaSourceReference* _tmp249_;
				ValaSourceReference* _tmp250_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp250_ = _tmp249_;
				vala_report_error (_tmp250_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp251_ = vala_code_context_get_analyzer (context);
	_tmp252_ = _tmp251_;
	_tmp253_ = vala_semantic_analyzer_get_current_symbol (_tmp252_);
	_tmp254_ = _tmp253_;
	_tmp255_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp254_) ? ((ValaBlock*) _tmp254_) : NULL);
	block = _tmp255_;
	_tmp256_ = block;
	if (_tmp256_ != NULL) {
		ValaBlock* _tmp257_;
		_tmp257_ = block;
		vala_block_add_local_variable (_tmp257_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp258_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp259_ = _tmp258_;
	result = !_tmp259_;
	_vala_code_node_unref0 (block);
	return result;
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

