/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaLocalVariable* _params_array_var;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_set_params_array_var (ValaMethod* self,
                                       ValaLocalVariable* value);
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);
static GType vala_method_get_type_once (void);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaLocalVariable*
vala_method_get_params_array_var (ValaMethod* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_params_array_var;
	result = _tmp0_;
	return result;
}

static void
vala_method_set_params_array_var (ValaMethod* self,
                                  ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	self->priv->_params_array_var = _tmp0_;
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_parameter_get_ellipsis (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_params_array (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaList* _tmp24_;
	ValaLocalVariable* _tmp33_;
	ValaLocalVariable* _tmp34_;
	ValaList* _tmp37_;
	ValaList* _tmp46_;
	ValaBlock* _tmp55_;
	ValaBlock* _tmp56_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaTypeParameter* _tmp7_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp5_ = _p_list;
			_tmp6_ = vala_list_get (_tmp5_, _p_index);
			p = (ValaTypeParameter*) _tmp6_;
			_tmp7_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp8_ = vala_method_get_base_interface_type (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_method_get_base_interface_type (self);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
	}
	_tmp12_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp15_ = _tmp14_;
		vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp16_ = self->priv->parameters;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp21_ = _param_list;
			_tmp22_ = vala_list_get (_tmp21_, _param_index);
			param = (ValaParameter*) _tmp22_;
			_tmp23_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp24_ = self->error_types;
	if (_tmp24_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			gint _error_type_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _error_type_index = 0;
			_tmp25_ = self->error_types;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_error_type_list = _tmp26_;
			_tmp27_ = _error_type_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_error_type_size = _tmp29_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp30_;
				gpointer _tmp31_;
				ValaDataType* _tmp32_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp30_ = _error_type_list;
				_tmp31_ = vala_list_get (_tmp30_, _error_type_index);
				error_type = (ValaDataType*) _tmp31_;
				_tmp32_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaLocalVariable* _tmp35_;
		ValaLocalVariable* _tmp36_;
		_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp36_ = _tmp35_;
		vala_code_node_accept ((ValaCodeNode*) _tmp36_, visitor);
	}
	_tmp37_ = self->priv->preconditions;
	if (_tmp37_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp38_;
			ValaList* _tmp39_;
			gint _precondition_size = 0;
			ValaList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _precondition_index = 0;
			_tmp38_ = self->priv->preconditions;
			_tmp39_ = _vala_iterable_ref0 (_tmp38_);
			_precondition_list = _tmp39_;
			_tmp40_ = _precondition_list;
			_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_precondition_size = _tmp42_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp43_;
				gpointer _tmp44_;
				ValaExpression* _tmp45_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp43_ = _precondition_list;
				_tmp44_ = vala_list_get (_tmp43_, _precondition_index);
				precondition = (ValaExpression*) _tmp44_;
				_tmp45_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp46_ = self->priv->postconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _postcondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _postcondition_index = 0;
			_tmp47_ = self->priv->postconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_postcondition_list = _tmp48_;
			_tmp49_ = _postcondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_postcondition_size = _tmp51_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp52_;
				gpointer _tmp53_;
				ValaExpression* _tmp54_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp52_ = _postcondition_list;
				_tmp53_ = vala_list_get (_tmp52_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp53_;
				_tmp54_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp54_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp55_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		ValaBlock* _tmp57_;
		ValaBlock* _tmp58_;
		_tmp57_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp58_ = _tmp57_;
		vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaObjectType* _tmp53_;
	ValaList* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaDataType* _tmp57_;
	ValaDataType* _tmp58_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp67_;
	ValaIterator* _tmp68_;
	gint param_index = 0;
	ValaIterator* _tmp116_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp118_;
	ValaArrayList* _tmp119_;
	ValaArrayList* _tmp120_;
	ValaList* _tmp121_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _type_parameter_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_object_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_type_parameter_list = _tmp12_;
			_tmp13_ = _type_parameter_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_type_parameter_size = _tmp15_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaGenericType* _tmp20_;
				ValaObjectType* _tmp21_;
				ValaGenericType* _tmp22_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp16_ = _type_parameter_list;
				_tmp17_ = vala_list_get (_tmp16_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp17_;
				_tmp18_ = type_parameter;
				_tmp19_ = vala_generic_type_new (_tmp18_);
				type_arg = _tmp19_;
				_tmp20_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp20_, TRUE);
				_tmp21_ = object_type;
				_tmp22_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp21_, (ValaDataType*) _tmp22_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp23_ = vala_method_get_type_parameters (self);
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp25_ < _tmp28_) {
		gchar* _tmp29_;
		_tmp29_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp29_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp30_ = vala_method_get_type_parameters (self);
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_method_get_type_parameters (base_method);
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp32_ > _tmp35_) {
			gchar* _tmp36_;
			_tmp36_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp36_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp37_;
		ValaArrayList* _tmp38_;
		_tmp37_ = g_direct_equal;
		_tmp38_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp37_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp38_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp39_;
			ValaList* _tmp40_;
			gint _type_parameter_size = 0;
			ValaList* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _type_parameter_index = 0;
			_tmp39_ = vala_method_get_type_parameters (self);
			_tmp40_ = _vala_iterable_ref0 (_tmp39_);
			_type_parameter_list = _tmp40_;
			_tmp41_ = _type_parameter_list;
			_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
			_tmp43_ = _tmp42_;
			_type_parameter_size = _tmp43_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp44_;
				gpointer _tmp45_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp46_;
				ValaGenericType* _tmp47_;
				ValaGenericType* _tmp48_;
				ValaList* _tmp49_;
				ValaGenericType* _tmp50_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp44_ = _type_parameter_list;
				_tmp45_ = vala_list_get (_tmp44_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp45_;
				_tmp46_ = type_parameter;
				_tmp47_ = vala_generic_type_new (_tmp46_);
				type_arg = _tmp47_;
				_tmp48_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp48_, TRUE);
				_tmp49_ = method_type_args;
				_tmp50_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp49_, (ValaDataType*) _tmp50_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp51_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp52_ = _tmp51_;
	_tmp53_ = object_type;
	_tmp54_ = method_type_args;
	_tmp55_ = vala_data_type_get_actual_type (_tmp52_, (ValaDataType*) _tmp53_, _tmp54_, node_reference);
	actual_base_type = _tmp55_;
	_tmp56_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = actual_base_type;
	if (!vala_data_type_equals (_tmp57_, _tmp58_)) {
		ValaDataType* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp59_ = actual_base_type;
		_tmp60_ = vala_data_type_to_prototype_string (_tmp59_, NULL);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp61_, _tmp65_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp66_;
		_g_free0 (_tmp65_);
		_g_free0 (_tmp61_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp67_ = self->priv->parameters;
	_tmp68_ = vala_iterable_iterator ((ValaIterable*) _tmp67_);
	method_params_it = _tmp68_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp69_;
		ValaList* _tmp70_;
		gint _base_param_size = 0;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _base_param_index = 0;
		_tmp69_ = base_method->priv->parameters;
		_tmp70_ = _vala_iterable_ref0 (_tmp69_);
		_base_param_list = _tmp70_;
		_tmp71_ = _base_param_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_base_param_size = _tmp73_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp74_;
			gpointer _tmp75_;
			ValaIterator* _tmp76_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp78_;
			gpointer _tmp79_;
			ValaParameter* _tmp80_;
			gboolean _tmp81_;
			gboolean _tmp82_;
			ValaParameter* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp90_;
			gboolean _tmp91_;
			gboolean _tmp92_;
			ValaParameter* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			gint _tmp115_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp74_ = _base_param_list;
			_tmp75_ = vala_list_get (_tmp74_, _base_param_index);
			base_param = (ValaParameter*) _tmp75_;
			_tmp76_ = method_params_it;
			if (!vala_iterator_next (_tmp76_)) {
				gchar* _tmp77_;
				_tmp77_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp77_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp78_ = method_params_it;
			_tmp79_ = vala_iterator_get (_tmp78_);
			param = (ValaParameter*) _tmp79_;
			_tmp80_ = base_param;
			_tmp81_ = vala_parameter_get_ellipsis (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = param;
			_tmp84_ = vala_parameter_get_ellipsis (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp82_ != _tmp85_) {
				gchar* _tmp86_;
				_tmp86_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp86_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp87_ = base_param;
			_tmp88_ = vala_parameter_get_params_array (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = param;
			_tmp91_ = vala_parameter_get_params_array (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp89_ != _tmp92_) {
				gchar* _tmp93_;
				_tmp93_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp93_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp94_ = base_param;
			_tmp95_ = vala_parameter_get_ellipsis (_tmp94_);
			_tmp96_ = _tmp95_;
			if (!_tmp96_) {
				ValaParameter* _tmp97_;
				ValaParameterDirection _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameter* _tmp100_;
				ValaParameterDirection _tmp101_;
				ValaParameterDirection _tmp102_;
				ValaParameter* _tmp104_;
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				ValaObjectType* _tmp107_;
				ValaList* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				ValaParameter* _tmp111_;
				ValaDataType* _tmp112_;
				ValaDataType* _tmp113_;
				_tmp97_ = base_param;
				_tmp98_ = vala_parameter_get_direction (_tmp97_);
				_tmp99_ = _tmp98_;
				_tmp100_ = param;
				_tmp101_ = vala_parameter_get_direction (_tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp99_ != _tmp102_) {
					gchar* _tmp103_;
					_tmp103_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp103_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp104_ = base_param;
				_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = object_type;
				_tmp108_ = method_type_args;
				_tmp109_ = vala_data_type_get_actual_type (_tmp106_, (ValaDataType*) _tmp107_, _tmp108_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp109_;
				_tmp110_ = actual_base_type;
				_tmp111_ = param;
				_tmp112_ = vala_variable_get_variable_type ((ValaVariable*) _tmp111_);
				_tmp113_ = _tmp112_;
				if (!vala_data_type_equals (_tmp110_, _tmp113_)) {
					gchar* _tmp114_;
					_tmp114_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp114_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp115_ = param_index;
			param_index = _tmp115_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp116_ = method_params_it;
	if (vala_iterator_next (_tmp116_)) {
		gchar* _tmp117_;
		_tmp117_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp117_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp118_ = g_direct_equal;
	_tmp119_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp118_);
	base_method_errors = _tmp119_;
	_tmp120_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp120_, NULL);
	_tmp121_ = self->error_types;
	if (_tmp121_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp122_;
			ValaList* _tmp123_;
			gint _method_error_type_size = 0;
			ValaList* _tmp124_;
			gint _tmp125_;
			gint _tmp126_;
			gint _method_error_type_index = 0;
			_tmp122_ = self->error_types;
			_tmp123_ = _vala_iterable_ref0 (_tmp122_);
			_method_error_type_list = _tmp123_;
			_tmp124_ = _method_error_type_list;
			_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
			_tmp126_ = _tmp125_;
			_method_error_type_size = _tmp126_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp127_;
				gpointer _tmp128_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp127_ = _method_error_type_list;
				_tmp128_ = vala_list_get (_tmp127_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp128_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp129_;
					ValaArrayList* _tmp130_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp131_;
					gint _tmp132_;
					gint _tmp133_;
					gint _base_method_error_type_index = 0;
					_tmp129_ = base_method_errors;
					_tmp130_ = _vala_iterable_ref0 (_tmp129_);
					_base_method_error_type_list = _tmp130_;
					_tmp131_ = _base_method_error_type_list;
					_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
					_tmp133_ = _tmp132_;
					_base_method_error_type_size = _tmp133_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp134_;
						gpointer _tmp135_;
						ValaDataType* _tmp136_;
						ValaDataType* _tmp137_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp134_ = _base_method_error_type_list;
						_tmp135_ = vala_list_get ((ValaList*) _tmp134_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp135_;
						_tmp136_ = method_error_type;
						_tmp137_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp136_, _tmp137_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp138_;
					gchar* _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					_tmp138_ = method_error_type;
					_tmp139_ = vala_code_node_to_string ((ValaCodeNode*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = g_strdup_printf ("incompatible error type `%s'", _tmp140_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp141_;
					_g_free0 (_tmp140_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp142_ = base_method->priv->_coroutine;
	_tmp143_ = self->priv->_coroutine;
	if (_tmp142_ != _tmp143_) {
		gchar* _tmp144_;
		_tmp144_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp144_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->type_parameters;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_type_parameter_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_type_parameter_list;
	result = _tmp5_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->preconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp2_;
	ValaList* _tmp5_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->postconditions;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = vala_method__empty_expression_list;
	if (_tmp2_ == NULL) {
		GEqualFunc _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp3_ = g_direct_equal;
		_tmp4_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp3_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp4_;
	}
	_tmp5_ = vala_method__empty_expression_list;
	result = _tmp5_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp11_;
	ValaClass* _tmp35_;
	ValaClass* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = sym;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal);
		_tmp7_ = sig;
		_tmp8_ = vala_signal_get_default_handler (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (sym);
		sym = _tmp10_;
	}
	_tmp11_ = sym;
	if (VALA_IS_METHOD (_tmp11_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp12_;
		gboolean _tmp13_ = FALSE;
		ValaMethod* _tmp14_;
		gboolean _tmp15_;
		_tmp12_ = sym;
		base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_METHOD, ValaMethod);
		_tmp14_ = base_method;
		_tmp15_ = _tmp14_->priv->_is_abstract;
		if (_tmp15_) {
			_tmp13_ = TRUE;
		} else {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			_tmp16_ = base_method;
			_tmp17_ = _tmp16_->priv->_is_virtual;
			_tmp13_ = _tmp17_;
		}
		if (_tmp13_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp18_;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_;
			ValaMethod* _tmp33_;
			ValaMethod* _tmp34_;
			_tmp18_ = base_method;
			_tmp20_ = vala_method_compatible (self, _tmp18_, &_tmp19_);
			_g_free0 (invalid_match);
			invalid_match = _tmp19_;
			if (!_tmp20_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp21_;
				ValaMethodType* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				ValaMethodType* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp21_ = base_method;
				_tmp22_ = vala_method_type_new (_tmp21_);
				base_method_type = _tmp22_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = base_method_type;
				_tmp28_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = invalid_match;
				_tmp31_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp26_, _tmp29_, _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp26_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp33_ = base_method;
			self->priv->_base_method = _tmp33_;
			_tmp34_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp34_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (sym);
			return;
		}
	}
	_tmp35_ = vala_class_get_base_class (cl);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaClass* _tmp37_;
		ValaClass* _tmp38_;
		_tmp37_ = vala_class_get_base_class (cl);
		_tmp38_ = _tmp37_;
		vala_method_find_base_class_method (self, _tmp38_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp86_;
	ValaDataType* _tmp87_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaDataType* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp5_ = _type_list;
			_tmp6_ = vala_list_get (_tmp5_, _type_index);
			type = (ValaDataType*) _tmp6_;
			_tmp7_ = type;
			_tmp8_ = vala_data_type_get_type_symbol (_tmp7_);
			_tmp9_ = _tmp8_;
			if (VALA_IS_INTERFACE (_tmp9_)) {
				gboolean _tmp10_ = FALSE;
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaScope* _tmp23_;
				ValaScope* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp34_;
				_tmp11_ = vala_method_get_base_interface_type (self);
				_tmp12_ = _tmp11_;
				if (_tmp12_ != NULL) {
					ValaDataType* _tmp13_;
					ValaDataType* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaTypeSymbol* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					_tmp13_ = vala_method_get_base_interface_type (self);
					_tmp14_ = _tmp13_;
					_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = type;
					_tmp18_ = vala_data_type_get_type_symbol (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp10_ = _tmp16_ != _tmp19_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp20_ = type;
				_tmp21_ = vala_data_type_get_type_symbol (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_scope_lookup (_tmp24_, _tmp26_);
				sym = _tmp27_;
				_tmp28_ = sym;
				if (VALA_IS_SIGNAL (_tmp28_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp29_ = sym;
					sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_SIGNAL, ValaSignal);
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					gboolean _tmp36_ = FALSE;
					ValaMethod* _tmp37_;
					gboolean _tmp38_;
					_tmp35_ = sym;
					base_method = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod);
					_tmp37_ = base_method;
					_tmp38_ = _tmp37_->priv->_is_abstract;
					if (_tmp38_) {
						_tmp36_ = TRUE;
					} else {
						ValaMethod* _tmp39_;
						gboolean _tmp40_;
						_tmp39_ = base_method;
						_tmp40_ = _tmp39_->priv->_is_virtual;
						_tmp36_ = _tmp40_;
					}
					if (_tmp36_) {
						ValaDataType* _tmp41_;
						ValaDataType* _tmp42_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp41_ = vala_method_get_base_interface_type (self);
						_tmp42_ = _tmp41_;
						if (_tmp42_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp43_;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp43_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_tmp44_ = _vala_iterable_ref0 (_tmp43_);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_;
		gboolean _tmp72_;
		_tmp71_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		if (!_tmp72_) {
			ValaMethod* _tmp73_;
			_tmp73_ = invalid_base_match;
			_tmp70_ = _tmp73_ != NULL;
		} else {
			_tmp70_ = FALSE;
		}
		if (_tmp70_) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp74_;
			ValaMethodType* _tmp75_;
			ValaSourceReference* _tmp76_;
			ValaSourceReference* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			ValaMethodType* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = invalid_base_match;
			_tmp75_ = vala_method_type_new (_tmp74_);
			base_method_type = _tmp75_;
			_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp79_ = _tmp78_;
			_tmp80_ = base_method_type;
			_tmp81_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp80_, NULL);
			_tmp82_ = _tmp81_;
			_tmp83_ = invalid_error;
			_tmp84_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp79_, _tmp82_, _tmp83_);
			_tmp85_ = _tmp84_;
			vala_report_error (_tmp77_, _tmp85_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp86_ = vala_method_get_base_interface_type (self);
	_tmp87_ = _tmp86_;
	if (_tmp87_ != NULL) {
		ValaSourceReference* _tmp88_;
		ValaSourceReference* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp88_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp91_ = _tmp90_;
		_tmp92_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp91_);
		_tmp93_ = _tmp92_;
		vala_report_error (_tmp89_, _tmp93_);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp91_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaParameter* _tmp4_;
	ValaAttribute* _tmp6_;
	ValaAttribute* _tmp10_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp34_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp110_;
	ValaSemanticAnalyzer* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSourceFile* _tmp113_;
	ValaSourceFile* _tmp114_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	gboolean _tmp136_;
	gboolean _tmp137_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaTypeSymbol* _tmp144_;
	ValaTypeSymbol* _tmp145_;
	ValaSemanticAnalyzer* _tmp146_;
	ValaSemanticAnalyzer* _tmp147_;
	ValaDataType* _tmp148_;
	ValaTypeSymbol* _tmp149_;
	ValaTypeSymbol* _tmp150_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp161_;
	ValaAttribute* _tmp162_;
	ValaAttribute* _tmp163_;
	ValaDataType* _tmp170_;
	ValaDataType* _tmp171_;
	gboolean _tmp174_ = FALSE;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp176_ = FALSE;
	ValaList* _tmp177_;
	gint _tmp178_;
	gint _tmp179_;
	gboolean _tmp193_ = FALSE;
	ValaAttribute* _tmp194_;
	gboolean optional_param = FALSE;
	gboolean _tmp331_;
	ValaList* _tmp345_;
	ValaLocalVariable* _tmp366_;
	ValaLocalVariable* _tmp367_;
	ValaList* _tmp370_;
	ValaList* _tmp379_;
	ValaBlock* _tmp388_;
	ValaBlock* _tmp389_;
	ValaSemanticAnalyzer* _tmp392_;
	ValaSemanticAnalyzer* _tmp393_;
	ValaStruct* _tmp394_;
	ValaStruct* _tmp395_;
	gboolean _tmp453_ = FALSE;
	gboolean _tmp454_ = FALSE;
	ValaDataType* _tmp455_;
	ValaDataType* _tmp456_;
	ValaSemanticAnalyzer* _tmp500_;
	ValaSemanticAnalyzer* _tmp501_;
	ValaSourceFile* _tmp502_;
	ValaSemanticAnalyzer* _tmp503_;
	ValaSemanticAnalyzer* _tmp504_;
	ValaSymbol* _tmp505_;
	gboolean _tmp506_ = FALSE;
	gboolean _tmp507_ = FALSE;
	gboolean _tmp508_ = FALSE;
	gboolean _tmp509_;
	gboolean _tmp510_;
	ValaSemanticAnalyzer* _tmp526_;
	ValaSemanticAnalyzer* _tmp527_;
	ValaDataType* _tmp528_;
	ValaDataType* _tmp529_;
	gboolean _tmp578_ = FALSE;
	ValaBlock* _tmp579_;
	ValaBlock* _tmp580_;
	gboolean _tmp621_ = FALSE;
	gboolean _tmp622_ = FALSE;
	gboolean _tmp623_ = FALSE;
	gboolean _tmp624_ = FALSE;
	gboolean _tmp625_ = FALSE;
	ValaAttribute* _tmp683_;
	gboolean _tmp684_;
	gboolean _tmp685_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_this_parameter;
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		_tmp5_ = self->priv->_this_parameter;
		vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	}
	_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp6_ != NULL) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp10_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (VALA_IS_CLASS (_tmp13_)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		ValaClass* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass);
		_tmp20_ = cl;
		_tmp21_ = vala_class_get_is_compact (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			_tmp23_ = cl;
			_tmp24_ = vala_class_get_base_class (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_ != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			return result;
		}
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		_tmp30_ = self->priv->_is_abstract;
		if (_tmp30_) {
			_tmp29_ = TRUE;
		} else {
			gboolean _tmp31_;
			_tmp31_ = self->priv->_is_virtual;
			_tmp29_ = _tmp31_;
		}
		_tmp28_ = _tmp29_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp33_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...' or params-array.");
		result = FALSE;
		return result;
	}
	_tmp34_ = self->priv->_is_abstract;
	if (_tmp34_) {
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		_tmp35_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp36_ = _tmp35_;
		if (VALA_IS_CLASS (_tmp36_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp38_ = _tmp37_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_CLASS, ValaClass);
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				return result;
			}
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		_tmp78_ = self->priv->_is_abstract;
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			gboolean _tmp79_;
			_tmp79_ = self->priv->_is_virtual;
			_tmp77_ = _tmp79_;
		}
		if (_tmp77_) {
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp80_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp76_ = _tmp81_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp82_;
			ValaSourceReference* _tmp83_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp83_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp85_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaBlock* _tmp87_;
				ValaBlock* _tmp88_;
				_tmp87_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = _tmp88_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_;
				_tmp94_ = self->priv->_is_abstract;
				if (!_tmp94_) {
					gboolean _tmp95_;
					gboolean _tmp96_;
					_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp93_ = !_tmp96_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaSourceFileType _tmp97_;
					ValaSourceFileType _tmp98_;
					_tmp97_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp98_ = _tmp97_;
					_tmp92_ = _tmp98_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaBlock* _tmp99_;
					ValaBlock* _tmp100_;
					_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp100_ = _tmp99_;
					_tmp91_ = _tmp100_ == NULL;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp105_ = self->priv->_coroutine;
	if (_tmp105_) {
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp106_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		_tmp104_ = !_tmp107_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		_tmp103_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp109_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp110_ = vala_code_context_get_analyzer (context);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_semantic_analyzer_get_current_source_file (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_source_file_ref0 (_tmp113_);
	old_source_file = _tmp114_;
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_symbol (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (_tmp118_);
	old_symbol = _tmp119_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaSourceFile* _tmp126_;
		ValaSourceFile* _tmp127_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_source_reference_get_file (_tmp125_);
		_tmp127_ = _tmp126_;
		vala_semantic_analyzer_set_current_source_file (_tmp123_, _tmp127_);
	}
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, (ValaSymbol*) self);
	_tmp130_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_method_get_returns_floating_reference (self);
	_tmp133_ = _tmp132_;
	vala_data_type_set_floating_reference (_tmp131_, _tmp133_);
	_tmp134_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp135_ = _tmp134_;
	vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
	_tmp136_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp137_ = _tmp136_;
	if (!_tmp137_) {
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		_tmp138_ = vala_code_context_get_analyzer (context);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp141_ = _tmp140_;
		vala_semantic_analyzer_check_type (_tmp139_, _tmp141_);
	}
	_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_data_type_get_type_symbol (_tmp143_);
	_tmp145_ = _tmp144_;
	_tmp146_ = vala_code_context_get_analyzer (context);
	_tmp147_ = _tmp146_;
	_tmp148_ = _tmp147_->va_list_type;
	_tmp149_ = vala_data_type_get_type_symbol (_tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp145_ == _tmp150_) {
		ValaSourceReference* _tmp151_;
		ValaSourceReference* _tmp152_;
		ValaDataType* _tmp153_;
		ValaDataType* _tmp154_;
		ValaTypeSymbol* _tmp155_;
		ValaTypeSymbol* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		gchar* _tmp159_;
		gchar* _tmp160_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_data_type_get_type_symbol (_tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = g_strdup_printf ("`%s' not supported as return type", _tmp158_);
		_tmp160_ = _tmp159_;
		vala_report_error (_tmp152_, _tmp160_);
		_g_free0 (_tmp160_);
		_g_free0 (_tmp158_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp161_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp162_ = _vala_code_node_ref0 (_tmp161_);
	init_attr = _tmp162_;
	_tmp163_ = init_attr;
	if (_tmp163_ != NULL) {
		ValaSourceReference* _tmp164_;
		ValaSourceReference* _tmp165_;
		ValaSourceFile* _tmp166_;
		ValaSourceFile* _tmp167_;
		ValaCodeContext* _tmp168_;
		ValaCodeContext* _tmp169_;
		_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_source_reference_get_file (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp168_ = vala_source_file_get_context (_tmp167_);
		_tmp169_ = _tmp168_;
		vala_code_context_set_module_init_method (_tmp169_, self);
	}
	_tmp170_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp171_ = _tmp170_;
	if (_tmp171_ != NULL) {
		ValaDataType* _tmp172_;
		ValaDataType* _tmp173_;
		_tmp172_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp173_ = _tmp172_;
		vala_code_node_check ((ValaCodeNode*) _tmp173_, context);
	}
	_tmp177_ = self->priv->parameters;
	_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
	_tmp179_ = _tmp178_;
	if (_tmp179_ == 1) {
		ValaList* _tmp180_;
		gpointer _tmp181_;
		ValaParameter* _tmp182_;
		gboolean _tmp183_;
		gboolean _tmp184_;
		_tmp180_ = self->priv->parameters;
		_tmp181_ = vala_list_get (_tmp180_, 0);
		_tmp182_ = (ValaParameter*) _tmp181_;
		_tmp183_ = vala_parameter_get_ellipsis (_tmp182_);
		_tmp184_ = _tmp183_;
		_tmp176_ = _tmp184_;
		_vala_code_node_unref0 (_tmp182_);
	} else {
		_tmp176_ = FALSE;
	}
	if (_tmp176_) {
		ValaBlock* _tmp185_;
		ValaBlock* _tmp186_;
		_tmp185_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp186_ = _tmp185_;
		_tmp175_ = _tmp186_ != NULL;
	} else {
		_tmp175_ = FALSE;
	}
	if (_tmp175_) {
		ValaMemberBinding _tmp187_;
		_tmp187_ = self->priv->_binding;
		_tmp174_ = _tmp187_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp174_ = FALSE;
	}
	if (_tmp174_) {
		ValaList* _tmp188_;
		gpointer _tmp189_;
		ValaParameter* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaSourceReference* _tmp192_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp188_ = self->priv->parameters;
		_tmp189_ = vala_list_get (_tmp188_, 0);
		_tmp190_ = (ValaParameter*) _tmp189_;
		_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
		_tmp192_ = _tmp191_;
		vala_report_error (_tmp192_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp190_);
	}
	_tmp194_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	if (_tmp194_ != NULL) {
		gboolean _tmp195_ = FALSE;
		ValaList* _tmp196_;
		gint _tmp197_;
		gint _tmp198_;
		_tmp196_ = self->priv->parameters;
		_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
		_tmp198_ = _tmp197_;
		if (_tmp198_ != 1) {
			_tmp195_ = TRUE;
		} else {
			ValaList* _tmp199_;
			gpointer _tmp200_;
			ValaParameter* _tmp201_;
			ValaDataType* _tmp202_;
			ValaDataType* _tmp203_;
			ValaTypeSymbol* _tmp204_;
			ValaTypeSymbol* _tmp205_;
			ValaSemanticAnalyzer* _tmp206_;
			ValaSemanticAnalyzer* _tmp207_;
			ValaDataType* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			ValaTypeSymbol* _tmp210_;
			_tmp199_ = self->priv->parameters;
			_tmp200_ = vala_list_get (_tmp199_, 0);
			_tmp201_ = (ValaParameter*) _tmp200_;
			_tmp202_ = vala_variable_get_variable_type ((ValaVariable*) _tmp201_);
			_tmp203_ = _tmp202_;
			_tmp204_ = vala_data_type_get_type_symbol (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_code_context_get_analyzer (context);
			_tmp207_ = _tmp206_;
			_tmp208_ = _tmp207_->string_type;
			_tmp209_ = vala_data_type_get_type_symbol (_tmp208_);
			_tmp210_ = _tmp209_;
			_tmp195_ = _tmp205_ != _tmp210_;
			_vala_code_node_unref0 (_tmp201_);
		}
		_tmp193_ = _tmp195_;
	} else {
		_tmp193_ = FALSE;
	}
	if (_tmp193_) {
		ValaSourceReference* _tmp211_;
		ValaSourceReference* _tmp212_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp212_ = _tmp211_;
		vala_report_error (_tmp212_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp213_;
		ValaList* _tmp214_;
		gint _param_size = 0;
		ValaList* _tmp215_;
		gint _tmp216_;
		gint _tmp217_;
		gint _param_index = 0;
		_tmp213_ = self->priv->parameters;
		_tmp214_ = _vala_iterable_ref0 (_tmp213_);
		_param_list = _tmp214_;
		_tmp215_ = _param_list;
		_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
		_tmp217_ = _tmp216_;
		_param_size = _tmp217_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp218_;
			gpointer _tmp219_;
			ValaParameter* _tmp220_;
			gboolean _tmp221_ = FALSE;
			gboolean _tmp222_;
			gboolean _tmp229_ = FALSE;
			gboolean _tmp230_ = FALSE;
			gboolean _tmp231_;
			gboolean _tmp232_;
			gboolean _tmp255_;
			gboolean _tmp256_ = FALSE;
			gboolean _tmp257_ = FALSE;
			gboolean _tmp270_ = FALSE;
			ValaParameter* _tmp271_;
			gboolean _tmp272_;
			gboolean _tmp273_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp218_ = _param_list;
			_tmp219_ = vala_list_get (_tmp218_, _param_index);
			param = (ValaParameter*) _tmp219_;
			_tmp220_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp220_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp222_ = self->priv->_coroutine;
			if (_tmp222_) {
				ValaParameter* _tmp223_;
				ValaParameterDirection _tmp224_;
				ValaParameterDirection _tmp225_;
				_tmp223_ = param;
				_tmp224_ = vala_parameter_get_direction (_tmp223_);
				_tmp225_ = _tmp224_;
				_tmp221_ = _tmp225_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaParameter* _tmp226_;
				ValaSourceReference* _tmp227_;
				ValaSourceReference* _tmp228_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp226_ = param;
				_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp226_);
				_tmp228_ = _tmp227_;
				vala_report_error (_tmp228_, "Reference parameters are not supported for async methods");
			}
			_tmp231_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp232_ = _tmp231_;
			if (!_tmp232_) {
				gboolean _tmp233_;
				_tmp233_ = self->priv->_coroutine;
				_tmp230_ = _tmp233_;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				gboolean _tmp234_ = FALSE;
				gboolean _tmp235_ = FALSE;
				ValaParameter* _tmp236_;
				gboolean _tmp237_;
				gboolean _tmp238_;
				_tmp236_ = param;
				_tmp237_ = vala_parameter_get_ellipsis (_tmp236_);
				_tmp238_ = _tmp237_;
				if (_tmp238_) {
					_tmp235_ = TRUE;
				} else {
					ValaParameter* _tmp239_;
					gboolean _tmp240_;
					gboolean _tmp241_;
					_tmp239_ = param;
					_tmp240_ = vala_parameter_get_params_array (_tmp239_);
					_tmp241_ = _tmp240_;
					_tmp235_ = _tmp241_;
				}
				if (_tmp235_) {
					_tmp234_ = TRUE;
				} else {
					ValaParameter* _tmp242_;
					ValaDataType* _tmp243_;
					ValaDataType* _tmp244_;
					ValaTypeSymbol* _tmp245_;
					ValaTypeSymbol* _tmp246_;
					ValaSemanticAnalyzer* _tmp247_;
					ValaSemanticAnalyzer* _tmp248_;
					ValaDataType* _tmp249_;
					ValaTypeSymbol* _tmp250_;
					ValaTypeSymbol* _tmp251_;
					_tmp242_ = param;
					_tmp243_ = vala_variable_get_variable_type ((ValaVariable*) _tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_data_type_get_type_symbol (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_code_context_get_analyzer (context);
					_tmp248_ = _tmp247_;
					_tmp249_ = _tmp248_->va_list_type;
					_tmp250_ = vala_data_type_get_type_symbol (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp234_ = _tmp246_ == _tmp251_;
				}
				_tmp229_ = _tmp234_;
			} else {
				_tmp229_ = FALSE;
			}
			if (_tmp229_) {
				ValaParameter* _tmp252_;
				ValaSourceReference* _tmp253_;
				ValaSourceReference* _tmp254_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp252_ = param;
				_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp252_);
				_tmp254_ = _tmp253_;
				vala_report_error (_tmp254_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp255_ = self->priv->_coroutine;
			if (_tmp255_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp258_;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				_tmp258_ = param;
				_tmp259_ = vala_variable_get_initializer ((ValaVariable*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp257_ = _tmp260_ == NULL;
			} else {
				_tmp257_ = FALSE;
			}
			if (_tmp257_) {
				ValaParameter* _tmp261_;
				gboolean _tmp262_;
				gboolean _tmp263_;
				_tmp261_ = param;
				_tmp262_ = vala_parameter_get_ellipsis (_tmp261_);
				_tmp263_ = _tmp262_;
				_tmp256_ = !_tmp263_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaParameter* _tmp264_;
				ValaSourceReference* _tmp265_;
				ValaSourceReference* _tmp266_;
				_tmp264_ = param;
				_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp264_);
				_tmp266_ = _tmp265_;
				vala_report_warning (_tmp266_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp267_;
				ValaExpression* _tmp268_;
				ValaExpression* _tmp269_;
				_tmp267_ = param;
				_tmp268_ = vala_variable_get_initializer ((ValaVariable*) _tmp267_);
				_tmp269_ = _tmp268_;
				if (_tmp269_ != NULL) {
					optional_param = TRUE;
				}
			}
			_tmp271_ = param;
			_tmp272_ = vala_parameter_get_params_array (_tmp271_);
			_tmp273_ = _tmp272_;
			if (_tmp273_) {
				ValaBlock* _tmp274_;
				ValaBlock* _tmp275_;
				_tmp274_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp275_ = _tmp274_;
				_tmp270_ = _tmp275_ != NULL;
			} else {
				_tmp270_ = FALSE;
			}
			if (_tmp270_) {
				ValaLocalVariable* _tmp276_;
				gboolean _tmp280_;
				gboolean _tmp281_;
				ValaArrayType* type = NULL;
				ValaParameter* _tmp285_;
				ValaDataType* _tmp286_;
				ValaDataType* _tmp287_;
				ValaDataType* _tmp288_;
				ValaArrayType* _tmp289_;
				ValaDataType* _tmp290_;
				ValaDataType* _tmp291_;
				ValaArrayType* _tmp292_;
				gboolean _tmp293_;
				gboolean _tmp294_;
				ValaArrayType* _tmp295_;
				gboolean _tmp296_ = FALSE;
				ValaArrayType* _tmp297_;
				ValaDataType* _tmp298_;
				ValaDataType* _tmp299_;
				ValaArrayType* _tmp308_;
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				ValaArrayType* _tmp314_;
				ValaParameter* _tmp315_;
				const gchar* _tmp316_;
				const gchar* _tmp317_;
				ValaParameter* _tmp318_;
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				ValaLocalVariable* _tmp321_;
				ValaLocalVariable* _tmp322_;
				ValaBlock* _tmp323_;
				ValaBlock* _tmp324_;
				ValaLocalVariable* _tmp325_;
				ValaParameter* _tmp326_;
				ValaSourceReference* _tmp327_;
				ValaSourceReference* _tmp328_;
				ValaDeclarationStatement* _tmp329_;
				ValaDeclarationStatement* _tmp330_;
				_tmp276_ = self->priv->_params_array_var;
				if (_tmp276_ != NULL) {
					ValaParameter* _tmp277_;
					ValaSourceReference* _tmp278_;
					ValaSourceReference* _tmp279_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp277_ = param;
					_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp277_);
					_tmp279_ = _tmp278_;
					vala_report_error (_tmp279_, "Only one params-array parameter is allowed");
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp280_ = vala_code_context_get_experimental (context);
				_tmp281_ = _tmp280_;
				if (!_tmp281_) {
					ValaParameter* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					_tmp282_ = param;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp282_);
					_tmp284_ = _tmp283_;
					vala_report_warning (_tmp284_, "Support of params-arrays is experimental");
				}
				_tmp285_ = param;
				_tmp286_ = vala_variable_get_variable_type ((ValaVariable*) _tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_data_type_copy (_tmp287_);
				type = G_TYPE_CHECK_INSTANCE_CAST (_tmp288_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
				_tmp289_ = type;
				_tmp290_ = vala_array_type_get_element_type (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = type;
				_tmp293_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp292_);
				_tmp294_ = _tmp293_;
				vala_data_type_set_value_owned (_tmp291_, _tmp294_);
				_tmp295_ = type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp295_, TRUE);
				_tmp297_ = type;
				_tmp298_ = vala_array_type_get_element_type (_tmp297_);
				_tmp299_ = _tmp298_;
				if (vala_data_type_is_real_struct_type (_tmp299_)) {
					ValaArrayType* _tmp300_;
					ValaDataType* _tmp301_;
					ValaDataType* _tmp302_;
					gboolean _tmp303_;
					gboolean _tmp304_;
					_tmp300_ = type;
					_tmp301_ = vala_array_type_get_element_type (_tmp300_);
					_tmp302_ = _tmp301_;
					_tmp303_ = vala_data_type_get_nullable (_tmp302_);
					_tmp304_ = _tmp303_;
					_tmp296_ = !_tmp304_;
				} else {
					_tmp296_ = FALSE;
				}
				if (_tmp296_) {
					ValaParameter* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaSourceReference* _tmp307_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = param;
					_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp305_);
					_tmp307_ = _tmp306_;
					vala_report_error (_tmp307_, "Only nullable struct elements are supported in params-array");
				}
				_tmp308_ = type;
				_tmp309_ = vala_array_type_get_length (_tmp308_);
				_tmp310_ = _tmp309_;
				if (_tmp310_ != NULL) {
					ValaParameter* _tmp311_;
					ValaSourceReference* _tmp312_;
					ValaSourceReference* _tmp313_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp311_ = param;
					_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp311_);
					_tmp313_ = _tmp312_;
					vala_report_error (_tmp313_, "Passing length to params-array is not supported yet");
				}
				_tmp314_ = type;
				_tmp315_ = param;
				_tmp316_ = vala_symbol_get_name ((ValaSymbol*) _tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = param;
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp318_);
				_tmp320_ = _tmp319_;
				_tmp321_ = vala_local_variable_new ((ValaDataType*) _tmp314_, _tmp317_, NULL, _tmp320_);
				_tmp322_ = _tmp321_;
				vala_method_set_params_array_var (self, _tmp322_);
				_vala_code_node_unref0 (_tmp322_);
				_tmp323_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp324_ = _tmp323_;
				_tmp325_ = self->priv->_params_array_var;
				_tmp326_ = param;
				_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_declaration_statement_new ((ValaSymbol*) _tmp325_, _tmp328_);
				_tmp330_ = _tmp329_;
				vala_block_insert_statement (_tmp324_, 0, (ValaStatement*) _tmp330_);
				_vala_code_node_unref0 (_tmp330_);
				_vala_code_node_unref0 (type);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp331_ = self->priv->_coroutine;
	if (_tmp331_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp332_;
			gint _tmp333_;
			gint _tmp334_;
			_tmp332_ = self->priv->parameters;
			_tmp333_ = vala_collection_get_size ((ValaCollection*) _tmp332_);
			_tmp334_ = _tmp333_;
			i = _tmp334_ - 1;
			{
				gboolean _tmp335_ = FALSE;
				_tmp335_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp337_;
					gpointer _tmp338_;
					ValaParameter* _tmp339_;
					ValaParameterDirection _tmp340_;
					ValaParameterDirection _tmp341_;
					if (!_tmp335_) {
						gint _tmp336_;
						_tmp336_ = i;
						i = _tmp336_ - 1;
					}
					_tmp335_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp337_ = self->priv->parameters;
					_tmp338_ = vala_list_get (_tmp337_, i);
					param = (ValaParameter*) _tmp338_;
					_tmp339_ = param;
					_tmp340_ = vala_parameter_get_direction (_tmp339_);
					_tmp341_ = _tmp340_;
					if (_tmp341_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp342_;
							ValaSourceReference* _tmp343_;
							ValaSourceReference* _tmp344_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp342_ = param;
							_tmp343_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp342_);
							_tmp344_ = _tmp343_;
							vala_report_error (_tmp344_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp345_ = self->error_types;
	if (_tmp345_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp346_;
			ValaList* _tmp347_;
			gint _error_type_size = 0;
			ValaList* _tmp348_;
			gint _tmp349_;
			gint _tmp350_;
			gint _error_type_index = 0;
			_tmp346_ = self->error_types;
			_tmp347_ = _vala_iterable_ref0 (_tmp346_);
			_error_type_list = _tmp347_;
			_tmp348_ = _error_type_list;
			_tmp349_ = vala_collection_get_size ((ValaCollection*) _tmp348_);
			_tmp350_ = _tmp349_;
			_error_type_size = _tmp350_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp351_;
				gpointer _tmp352_;
				ValaDataType* _tmp353_;
				ValaSemanticAnalyzer* _tmp354_;
				ValaSemanticAnalyzer* _tmp355_;
				ValaDataType* _tmp356_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp351_ = _error_type_list;
				_tmp352_ = vala_list_get (_tmp351_, _error_type_index);
				error_type = (ValaDataType*) _tmp352_;
				_tmp353_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp353_, context);
				_tmp354_ = vala_code_context_get_analyzer (context);
				_tmp355_ = _tmp354_;
				_tmp356_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp355_, (ValaSymbol*) self, _tmp356_)) {
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					ValaDataType* _tmp359_;
					gchar* _tmp360_;
					gchar* _tmp361_;
					gchar* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					gchar* _tmp365_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp358_ = _tmp357_;
					_tmp359_ = error_type;
					_tmp360_ = vala_code_node_to_string ((ValaCodeNode*) _tmp359_);
					_tmp361_ = _tmp360_;
					_tmp362_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp363_ = _tmp362_;
					_tmp364_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp361_, _tmp363_);
					_tmp365_ = _tmp364_;
					vala_report_error (_tmp358_, _tmp365_);
					_g_free0 (_tmp365_);
					_g_free0 (_tmp363_);
					_g_free0 (_tmp361_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp366_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp367_ = _tmp366_;
	if (_tmp367_ != NULL) {
		ValaLocalVariable* _tmp368_;
		ValaLocalVariable* _tmp369_;
		_tmp368_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp369_ = _tmp368_;
		vala_code_node_check ((ValaCodeNode*) _tmp369_, context);
	}
	_tmp370_ = self->priv->preconditions;
	if (_tmp370_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp371_;
			ValaList* _tmp372_;
			gint _precondition_size = 0;
			ValaList* _tmp373_;
			gint _tmp374_;
			gint _tmp375_;
			gint _precondition_index = 0;
			_tmp371_ = self->priv->preconditions;
			_tmp372_ = _vala_iterable_ref0 (_tmp371_);
			_precondition_list = _tmp372_;
			_tmp373_ = _precondition_list;
			_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
			_tmp375_ = _tmp374_;
			_precondition_size = _tmp375_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp376_;
				gpointer _tmp377_;
				ValaExpression* _tmp378_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp376_ = _precondition_list;
				_tmp377_ = vala_list_get (_tmp376_, _precondition_index);
				precondition = (ValaExpression*) _tmp377_;
				_tmp378_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp378_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp379_ = self->priv->postconditions;
	if (_tmp379_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp380_;
			ValaList* _tmp381_;
			gint _postcondition_size = 0;
			ValaList* _tmp382_;
			gint _tmp383_;
			gint _tmp384_;
			gint _postcondition_index = 0;
			_tmp380_ = self->priv->postconditions;
			_tmp381_ = _vala_iterable_ref0 (_tmp380_);
			_postcondition_list = _tmp381_;
			_tmp382_ = _postcondition_list;
			_tmp383_ = vala_collection_get_size ((ValaCollection*) _tmp382_);
			_tmp384_ = _tmp383_;
			_postcondition_size = _tmp384_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp385_;
				gpointer _tmp386_;
				ValaExpression* _tmp387_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp385_ = _postcondition_list;
				_tmp386_ = vala_list_get (_tmp385_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp386_;
				_tmp387_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp387_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp388_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp389_ = _tmp388_;
	if (_tmp389_ != NULL) {
		ValaBlock* _tmp390_;
		ValaBlock* _tmp391_;
		_tmp390_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp391_ = _tmp390_;
		vala_code_node_check ((ValaCodeNode*) _tmp391_, context);
	}
	_tmp392_ = vala_code_context_get_analyzer (context);
	_tmp393_ = _tmp392_;
	_tmp394_ = vala_semantic_analyzer_get_current_struct (_tmp393_);
	_tmp395_ = _tmp394_;
	if (_tmp395_ != NULL) {
		gboolean _tmp396_ = FALSE;
		gboolean _tmp397_ = FALSE;
		gboolean _tmp398_;
		_tmp398_ = self->priv->_is_abstract;
		if (_tmp398_) {
			_tmp397_ = TRUE;
		} else {
			gboolean _tmp399_;
			_tmp399_ = self->priv->_is_virtual;
			_tmp397_ = _tmp399_;
		}
		if (_tmp397_) {
			_tmp396_ = TRUE;
		} else {
			gboolean _tmp400_;
			_tmp400_ = self->priv->_overrides;
			_tmp396_ = _tmp400_;
		}
		if (_tmp396_) {
			ValaSourceReference* _tmp401_;
			ValaSourceReference* _tmp402_;
			gchar* _tmp403_;
			gchar* _tmp404_;
			gchar* _tmp405_;
			gchar* _tmp406_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp401_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp402_ = _tmp401_;
			_tmp403_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp404_ = _tmp403_;
			_tmp405_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp404_);
			_tmp406_ = _tmp405_;
			vala_report_error (_tmp402_, _tmp406_);
			_g_free0 (_tmp406_);
			_g_free0 (_tmp404_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp407_ = FALSE;
		gboolean _tmp408_ = FALSE;
		gboolean _tmp409_ = FALSE;
		gboolean _tmp410_;
		_tmp410_ = self->priv->_overrides;
		if (_tmp410_) {
			ValaMethod* _tmp411_;
			ValaMethod* _tmp412_;
			_tmp411_ = vala_method_get_base_method (self);
			_tmp412_ = _tmp411_;
			_tmp409_ = _tmp412_ == NULL;
		} else {
			_tmp409_ = FALSE;
		}
		if (_tmp409_) {
			ValaMethod* _tmp413_;
			ValaMethod* _tmp414_;
			_tmp413_ = vala_method_get_base_interface_method (self);
			_tmp414_ = _tmp413_;
			_tmp408_ = _tmp414_ != NULL;
		} else {
			_tmp408_ = FALSE;
		}
		if (_tmp408_) {
			ValaMethod* _tmp415_;
			ValaMethod* _tmp416_;
			gboolean _tmp417_;
			_tmp415_ = vala_method_get_base_interface_method (self);
			_tmp416_ = _tmp415_;
			_tmp417_ = _tmp416_->priv->_is_abstract;
			_tmp407_ = _tmp417_;
		} else {
			_tmp407_ = FALSE;
		}
		if (_tmp407_) {
			ValaSourceReference* _tmp418_;
			ValaSourceReference* _tmp419_;
			ValaMethod* _tmp420_;
			ValaMethod* _tmp421_;
			gchar* _tmp422_;
			gchar* _tmp423_;
			gchar* _tmp424_;
			gchar* _tmp425_;
			_tmp418_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp419_ = _tmp418_;
			_tmp420_ = vala_method_get_base_interface_method (self);
			_tmp421_ = _tmp420_;
			_tmp422_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp421_);
			_tmp423_ = _tmp422_;
			_tmp424_ = g_strdup_printf ("`override' not required to implement `abstract' interface method `%s'", _tmp423_);
			_tmp425_ = _tmp424_;
			vala_report_warning (_tmp419_, _tmp425_);
			_g_free0 (_tmp425_);
			_g_free0 (_tmp423_);
			vala_method_set_overrides (self, FALSE);
		} else {
			gboolean _tmp426_ = FALSE;
			gboolean _tmp427_ = FALSE;
			gboolean _tmp428_;
			_tmp428_ = self->priv->_overrides;
			if (_tmp428_) {
				ValaMethod* _tmp429_;
				ValaMethod* _tmp430_;
				_tmp429_ = vala_method_get_base_method (self);
				_tmp430_ = _tmp429_;
				_tmp427_ = _tmp430_ == NULL;
			} else {
				_tmp427_ = FALSE;
			}
			if (_tmp427_) {
				ValaMethod* _tmp431_;
				ValaMethod* _tmp432_;
				_tmp431_ = vala_method_get_base_interface_method (self);
				_tmp432_ = _tmp431_;
				_tmp426_ = _tmp432_ == NULL;
			} else {
				_tmp426_ = FALSE;
			}
			if (_tmp426_) {
				ValaSourceReference* _tmp433_;
				ValaSourceReference* _tmp434_;
				gchar* _tmp435_;
				gchar* _tmp436_;
				gchar* _tmp437_;
				gchar* _tmp438_;
				_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp434_ = _tmp433_;
				_tmp435_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp436_ = _tmp435_;
				_tmp437_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp436_);
				_tmp438_ = _tmp437_;
				vala_report_error (_tmp434_, _tmp438_);
				_g_free0 (_tmp438_);
				_g_free0 (_tmp436_);
			} else {
				gboolean _tmp439_ = FALSE;
				gboolean _tmp440_ = FALSE;
				gboolean _tmp441_ = FALSE;
				gboolean _tmp442_;
				_tmp442_ = self->priv->_is_abstract;
				if (_tmp442_) {
					_tmp441_ = TRUE;
				} else {
					gboolean _tmp443_;
					_tmp443_ = self->priv->_is_virtual;
					_tmp441_ = _tmp443_;
				}
				if (_tmp441_) {
					_tmp440_ = TRUE;
				} else {
					gboolean _tmp444_;
					_tmp444_ = self->priv->_overrides;
					_tmp440_ = _tmp444_;
				}
				if (_tmp440_) {
					ValaSymbolAccessibility _tmp445_;
					ValaSymbolAccessibility _tmp446_;
					_tmp445_ = vala_symbol_get_access ((ValaSymbol*) self);
					_tmp446_ = _tmp445_;
					_tmp439_ = _tmp446_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp439_ = FALSE;
				}
				if (_tmp439_) {
					ValaSourceReference* _tmp447_;
					ValaSourceReference* _tmp448_;
					gchar* _tmp449_;
					gchar* _tmp450_;
					gchar* _tmp451_;
					gchar* _tmp452_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp448_ = _tmp447_;
					_tmp449_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp450_ = _tmp449_;
					_tmp451_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp450_);
					_tmp452_ = _tmp451_;
					vala_report_error (_tmp448_, _tmp452_);
					_g_free0 (_tmp452_);
					_g_free0 (_tmp450_);
					result = FALSE;
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
		}
	}
	_tmp455_ = vala_method_get_base_interface_type (self);
	_tmp456_ = _tmp455_;
	if (_tmp456_ != NULL) {
		ValaMethod* _tmp457_;
		ValaMethod* _tmp458_;
		_tmp457_ = vala_method_get_base_interface_method (self);
		_tmp458_ = _tmp457_;
		_tmp454_ = _tmp458_ != NULL;
	} else {
		_tmp454_ = FALSE;
	}
	if (_tmp454_) {
		ValaSymbol* _tmp459_;
		ValaSymbol* _tmp460_;
		_tmp459_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp460_ = _tmp459_;
		_tmp453_ = VALA_IS_CLASS (_tmp460_);
	} else {
		_tmp453_ = FALSE;
	}
	if (_tmp453_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp461_;
		ValaSymbol* _tmp462_;
		_tmp461_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp462_ = _tmp461_;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp463_;
			ValaList* _tmp464_;
			ValaList* _tmp465_;
			gint _m_size = 0;
			ValaList* _tmp466_;
			gint _tmp467_;
			gint _tmp468_;
			gint _m_index = 0;
			_tmp463_ = cl;
			_tmp464_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp463_);
			_tmp465_ = _vala_iterable_ref0 (_tmp464_);
			_m_list = _tmp465_;
			_tmp466_ = _m_list;
			_tmp467_ = vala_collection_get_size ((ValaCollection*) _tmp466_);
			_tmp468_ = _tmp467_;
			_m_size = _tmp468_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp469_;
				gpointer _tmp470_;
				gboolean _tmp471_ = FALSE;
				ValaMethod* _tmp472_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp469_ = _m_list;
				_tmp470_ = vala_list_get (_tmp469_, _m_index);
				m = (ValaMethod*) _tmp470_;
				_tmp472_ = m;
				if (_tmp472_ != self) {
					ValaMethod* _tmp473_;
					ValaMethod* _tmp474_;
					ValaMethod* _tmp475_;
					ValaMethod* _tmp476_;
					ValaMethod* _tmp477_;
					_tmp473_ = m;
					_tmp474_ = vala_method_get_base_interface_method (_tmp473_);
					_tmp475_ = _tmp474_;
					_tmp476_ = vala_method_get_base_interface_method (self);
					_tmp477_ = _tmp476_;
					_tmp471_ = _tmp475_ == _tmp477_;
				} else {
					_tmp471_ = FALSE;
				}
				if (_tmp471_) {
					ValaMethod* _tmp478_;
					ValaMethod* _tmp479_;
					ValaSourceReference* _tmp480_;
					ValaSourceReference* _tmp481_;
					ValaClass* _tmp482_;
					gchar* _tmp483_;
					gchar* _tmp484_;
					ValaMethod* _tmp485_;
					ValaMethod* _tmp486_;
					gchar* _tmp487_;
					gchar* _tmp488_;
					gchar* _tmp489_;
					gchar* _tmp490_;
					ValaMethod* _tmp491_;
					ValaSourceReference* _tmp492_;
					ValaSourceReference* _tmp493_;
					ValaMethod* _tmp494_;
					ValaMethod* _tmp495_;
					gchar* _tmp496_;
					gchar* _tmp497_;
					gchar* _tmp498_;
					gchar* _tmp499_;
					_tmp478_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp478_, TRUE);
					_tmp479_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp479_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp480_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp481_ = _tmp480_;
					_tmp482_ = cl;
					_tmp483_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = vala_method_get_base_interface_method (self);
					_tmp486_ = _tmp485_;
					_tmp487_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp486_);
					_tmp488_ = _tmp487_;
					_tmp489_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp484_, _tmp488_);
					_tmp490_ = _tmp489_;
					vala_report_error (_tmp481_, _tmp490_);
					_g_free0 (_tmp490_);
					_g_free0 (_tmp488_);
					_g_free0 (_tmp484_);
					_tmp491_ = m;
					_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_method_get_base_interface_method (self);
					_tmp495_ = _tmp494_;
					_tmp496_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp495_);
					_tmp497_ = _tmp496_;
					_tmp498_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp497_);
					_tmp499_ = _tmp498_;
					vala_report_notice (_tmp493_, _tmp499_);
					_g_free0 (_tmp499_);
					_g_free0 (_tmp497_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
	}
	_tmp500_ = vala_code_context_get_analyzer (context);
	_tmp501_ = _tmp500_;
	_tmp502_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp501_, _tmp502_);
	_tmp503_ = vala_code_context_get_analyzer (context);
	_tmp504_ = _tmp503_;
	_tmp505_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp504_, _tmp505_);
	_tmp509_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp510_ = _tmp509_;
	if (!_tmp510_) {
		gboolean _tmp511_;
		_tmp511_ = self->priv->_overrides;
		_tmp508_ = !_tmp511_;
	} else {
		_tmp508_ = FALSE;
	}
	if (_tmp508_) {
		gboolean _tmp512_;
		gboolean _tmp513_;
		_tmp512_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp513_ = _tmp512_;
		_tmp507_ = !_tmp513_;
	} else {
		_tmp507_ = FALSE;
	}
	if (_tmp507_) {
		ValaSymbol* _tmp514_;
		ValaSymbol* _tmp515_;
		_tmp514_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp515_ = _tmp514_;
		_tmp506_ = _tmp515_ != NULL;
		_vala_code_node_unref0 (_tmp515_);
	} else {
		_tmp506_ = FALSE;
	}
	if (_tmp506_) {
		ValaSourceReference* _tmp516_;
		ValaSourceReference* _tmp517_;
		gchar* _tmp518_;
		gchar* _tmp519_;
		ValaSymbol* _tmp520_;
		ValaSymbol* _tmp521_;
		gchar* _tmp522_;
		gchar* _tmp523_;
		gchar* _tmp524_;
		gchar* _tmp525_;
		_tmp516_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp517_ = _tmp516_;
		_tmp518_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp519_ = _tmp518_;
		_tmp520_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp521_ = _tmp520_;
		_tmp522_ = vala_symbol_get_full_name (_tmp521_);
		_tmp523_ = _tmp522_;
		_tmp524_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp519_, _tmp523_);
		_tmp525_ = _tmp524_;
		vala_report_warning (_tmp517_, _tmp525_);
		_g_free0 (_tmp525_);
		_g_free0 (_tmp523_);
		_vala_code_node_unref0 (_tmp521_);
		_g_free0 (_tmp519_);
	}
	_tmp526_ = vala_code_context_get_analyzer (context);
	_tmp527_ = _tmp526_;
	_tmp528_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp529_ = _tmp528_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp527_, (ValaSymbol*) self, _tmp529_)) {
		ValaSourceReference* _tmp530_;
		ValaSourceReference* _tmp531_;
		ValaDataType* _tmp532_;
		ValaDataType* _tmp533_;
		gchar* _tmp534_;
		gchar* _tmp535_;
		gchar* _tmp536_;
		gchar* _tmp537_;
		gchar* _tmp538_;
		gchar* _tmp539_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp530_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp531_ = _tmp530_;
		_tmp532_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp533_ = _tmp532_;
		_tmp534_ = vala_code_node_to_string ((ValaCodeNode*) _tmp533_);
		_tmp535_ = _tmp534_;
		_tmp536_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp537_ = _tmp536_;
		_tmp538_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp535_, _tmp537_);
		_tmp539_ = _tmp538_;
		vala_report_error (_tmp531_, _tmp539_);
		_g_free0 (_tmp539_);
		_g_free0 (_tmp537_);
		_g_free0 (_tmp535_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp540_;
		ValaList* _tmp541_;
		gint _precondition_size = 0;
		ValaList* _tmp542_;
		gint _tmp543_;
		gint _tmp544_;
		gint _precondition_index = 0;
		_tmp540_ = vala_method_get_preconditions (self);
		_tmp541_ = _vala_iterable_ref0 (_tmp540_);
		_precondition_list = _tmp541_;
		_tmp542_ = _precondition_list;
		_tmp543_ = vala_collection_get_size ((ValaCollection*) _tmp542_);
		_tmp544_ = _tmp543_;
		_precondition_size = _tmp544_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp545_;
			gpointer _tmp546_;
			ValaExpression* _tmp547_;
			gboolean _tmp548_;
			gboolean _tmp549_;
			ValaExpression* _tmp550_;
			ValaDataType* _tmp551_;
			ValaDataType* _tmp552_;
			ValaSemanticAnalyzer* _tmp553_;
			ValaSemanticAnalyzer* _tmp554_;
			ValaDataType* _tmp555_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp545_ = _precondition_list;
			_tmp546_ = vala_list_get (_tmp545_, _precondition_index);
			precondition = (ValaExpression*) _tmp546_;
			_tmp547_ = precondition;
			_tmp548_ = vala_code_node_get_error ((ValaCodeNode*) _tmp547_);
			_tmp549_ = _tmp548_;
			if (_tmp549_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp550_ = precondition;
			_tmp551_ = vala_expression_get_value_type (_tmp550_);
			_tmp552_ = _tmp551_;
			_tmp553_ = vala_code_context_get_analyzer (context);
			_tmp554_ = _tmp553_;
			_tmp555_ = _tmp554_->bool_type;
			if (!vala_data_type_compatible (_tmp552_, _tmp555_)) {
				ValaExpression* _tmp556_;
				ValaSourceReference* _tmp557_;
				ValaSourceReference* _tmp558_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp556_ = precondition;
				_tmp557_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp556_);
				_tmp558_ = _tmp557_;
				vala_report_error (_tmp558_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp559_;
		ValaList* _tmp560_;
		gint _postcondition_size = 0;
		ValaList* _tmp561_;
		gint _tmp562_;
		gint _tmp563_;
		gint _postcondition_index = 0;
		_tmp559_ = vala_method_get_postconditions (self);
		_tmp560_ = _vala_iterable_ref0 (_tmp559_);
		_postcondition_list = _tmp560_;
		_tmp561_ = _postcondition_list;
		_tmp562_ = vala_collection_get_size ((ValaCollection*) _tmp561_);
		_tmp563_ = _tmp562_;
		_postcondition_size = _tmp563_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp564_;
			gpointer _tmp565_;
			ValaExpression* _tmp566_;
			gboolean _tmp567_;
			gboolean _tmp568_;
			ValaExpression* _tmp569_;
			ValaDataType* _tmp570_;
			ValaDataType* _tmp571_;
			ValaSemanticAnalyzer* _tmp572_;
			ValaSemanticAnalyzer* _tmp573_;
			ValaDataType* _tmp574_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp564_ = _postcondition_list;
			_tmp565_ = vala_list_get (_tmp564_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp565_;
			_tmp566_ = postcondition;
			_tmp567_ = vala_code_node_get_error ((ValaCodeNode*) _tmp566_);
			_tmp568_ = _tmp567_;
			if (_tmp568_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp569_ = postcondition;
			_tmp570_ = vala_expression_get_value_type (_tmp569_);
			_tmp571_ = _tmp570_;
			_tmp572_ = vala_code_context_get_analyzer (context);
			_tmp573_ = _tmp572_;
			_tmp574_ = _tmp573_->bool_type;
			if (!vala_data_type_compatible (_tmp571_, _tmp574_)) {
				ValaExpression* _tmp575_;
				ValaSourceReference* _tmp576_;
				ValaSourceReference* _tmp577_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp575_ = postcondition;
				_tmp576_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp575_);
				_tmp577_ = _tmp576_;
				vala_report_error (_tmp577_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp579_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp580_ = _tmp579_;
	if (_tmp580_ != NULL) {
		ValaBlock* _tmp581_;
		ValaBlock* _tmp582_;
		gboolean _tmp583_;
		gboolean _tmp584_;
		_tmp581_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp582_ = _tmp581_;
		_tmp583_ = vala_code_node_get_error ((ValaCodeNode*) _tmp582_);
		_tmp584_ = _tmp583_;
		_tmp578_ = !_tmp584_;
	} else {
		_tmp578_ = FALSE;
	}
	if (_tmp578_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp585_;
		ValaArrayList* _tmp586_;
		ValaBlock* _tmp587_;
		ValaBlock* _tmp588_;
		ValaArrayList* _tmp589_;
		_tmp585_ = g_direct_equal;
		_tmp586_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp585_);
		body_errors = _tmp586_;
		_tmp587_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp588_ = _tmp587_;
		_tmp589_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp588_, (ValaCollection*) _tmp589_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp590_;
			ValaArrayList* _tmp591_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp592_;
			gint _tmp593_;
			gint _tmp594_;
			gint _body_error_type_index = 0;
			_tmp590_ = body_errors;
			_tmp591_ = _vala_iterable_ref0 (_tmp590_);
			_body_error_type_list = _tmp591_;
			_tmp592_ = _body_error_type_list;
			_tmp593_ = vala_collection_get_size ((ValaCollection*) _tmp592_);
			_tmp594_ = _tmp593_;
			_body_error_type_size = _tmp594_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp595_;
				gpointer _tmp596_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp597_;
				gboolean _tmp607_ = FALSE;
				ValaDataType* _tmp608_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp612_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp595_ = _body_error_type_list;
				_tmp596_ = vala_list_get ((ValaList*) _tmp595_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp596_;
				can_propagate_error = FALSE;
				_tmp597_ = self->error_types;
				if (_tmp597_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp598_;
						ValaList* _tmp599_;
						gint _method_error_type_size = 0;
						ValaList* _tmp600_;
						gint _tmp601_;
						gint _tmp602_;
						gint _method_error_type_index = 0;
						_tmp598_ = self->error_types;
						_tmp599_ = _vala_iterable_ref0 (_tmp598_);
						_method_error_type_list = _tmp599_;
						_tmp600_ = _method_error_type_list;
						_tmp601_ = vala_collection_get_size ((ValaCollection*) _tmp600_);
						_tmp602_ = _tmp601_;
						_method_error_type_size = _tmp602_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp603_;
							gpointer _tmp604_;
							ValaDataType* _tmp605_;
							ValaDataType* _tmp606_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp603_ = _method_error_type_list;
							_tmp604_ = vala_list_get (_tmp603_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp604_;
							_tmp605_ = body_error_type;
							_tmp606_ = method_error_type;
							if (vala_data_type_compatible (_tmp605_, _tmp606_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp608_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp608_)) {
					ValaDataType* _tmp609_;
					gboolean _tmp610_;
					gboolean _tmp611_;
					_tmp609_ = body_error_type;
					_tmp610_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp609_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp611_ = _tmp610_;
					_tmp607_ = _tmp611_;
				} else {
					_tmp607_ = FALSE;
				}
				is_dynamic_error = _tmp607_;
				if (!can_propagate_error) {
					_tmp612_ = !is_dynamic_error;
				} else {
					_tmp612_ = FALSE;
				}
				if (_tmp612_) {
					ValaDataType* _tmp613_;
					ValaSourceReference* _tmp614_;
					ValaSourceReference* _tmp615_;
					ValaDataType* _tmp616_;
					gchar* _tmp617_;
					gchar* _tmp618_;
					gchar* _tmp619_;
					gchar* _tmp620_;
					_tmp613_ = body_error_type;
					_tmp614_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp613_);
					_tmp615_ = _tmp614_;
					_tmp616_ = body_error_type;
					_tmp617_ = vala_code_node_to_string ((ValaCodeNode*) _tmp616_);
					_tmp618_ = _tmp617_;
					_tmp619_ = g_strdup_printf ("unhandled error `%s'", _tmp618_);
					_tmp620_ = _tmp619_;
					vala_report_warning (_tmp615_, _tmp620_);
					_g_free0 (_tmp620_);
					_g_free0 (_tmp618_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp626_;
		_tmp626_ = self->priv->_binding;
		_tmp625_ = _tmp626_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp625_ = FALSE;
	}
	if (_tmp625_) {
		gboolean _tmp627_;
		_tmp627_ = self->priv->_overrides;
		_tmp624_ = !_tmp627_;
	} else {
		_tmp624_ = FALSE;
	}
	if (_tmp624_) {
		ValaSymbolAccessibility _tmp628_;
		ValaSymbolAccessibility _tmp629_;
		_tmp628_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp629_ = _tmp628_;
		_tmp623_ = _tmp629_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp623_ = FALSE;
	}
	if (_tmp623_) {
		ValaSymbol* _tmp630_;
		ValaSymbol* _tmp631_;
		_tmp630_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp631_ = _tmp630_;
		_tmp622_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp631_);
	} else {
		_tmp622_ = FALSE;
	}
	if (_tmp622_) {
		ValaSymbol* _tmp632_;
		ValaSymbol* _tmp633_;
		ValaAttribute* _tmp634_;
		_tmp632_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp633_ = _tmp632_;
		_tmp634_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp633_, "DBus");
		_tmp621_ = _tmp634_ != NULL;
	} else {
		_tmp621_ = FALSE;
	}
	if (_tmp621_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp635_;
		ValaAttribute* _tmp636_;
		gboolean _tmp637_ = FALSE;
		ValaAttribute* _tmp638_;
		_tmp635_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp636_ = _vala_code_node_ref0 (_tmp635_);
		dbus_attr = _tmp636_;
		_tmp638_ = dbus_attr;
		if (_tmp638_ == NULL) {
			_tmp637_ = TRUE;
		} else {
			ValaAttribute* _tmp639_;
			_tmp639_ = dbus_attr;
			_tmp637_ = vala_attribute_get_bool (_tmp639_, "visible", TRUE);
		}
		if (_tmp637_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp640_;
			ValaArrayList* _tmp641_;
			ValaArrayList* _tmp642_;
			gboolean _tmp659_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp640_ = g_direct_equal;
			_tmp641_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp640_);
			error_types = _tmp641_;
			_tmp642_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp642_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp643_;
				ValaArrayList* _tmp644_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp645_;
				gint _tmp646_;
				gint _tmp647_;
				gint _error_type_index = 0;
				_tmp643_ = error_types;
				_tmp644_ = _vala_iterable_ref0 (_tmp643_);
				_error_type_list = _tmp644_;
				_tmp645_ = _error_type_list;
				_tmp646_ = vala_collection_get_size ((ValaCollection*) _tmp645_);
				_tmp647_ = _tmp646_;
				_error_type_size = _tmp647_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp648_;
					gpointer _tmp649_;
					ValaDataType* _tmp650_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp651_;
					ValaErrorDomain* _tmp652_;
					ValaErrorDomain* _tmp653_;
					ValaErrorDomain* _tmp654_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp655_;
					gchar* _tmp656_;
					const gchar* _tmp657_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp648_ = _error_type_list;
					_tmp649_ = vala_list_get ((ValaList*) _tmp648_, _error_type_index);
					error_type = (ValaDataType*) _tmp649_;
					_tmp650_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp650_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp651_ = error_type;
					_tmp652_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp653_ = _tmp652_;
					error_domain = _tmp653_;
					_tmp654_ = error_domain;
					if (_tmp654_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp655_ = error_domain;
					_tmp656_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp655_);
					full_error_domain = _tmp656_;
					_tmp657_ = full_error_domain;
					if (g_strcmp0 (_tmp657_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp658_;
						_tmp658_ = full_error_domain;
						if (g_strcmp0 (_tmp658_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp660_ = FALSE;
				if (throws_gioerror) {
					_tmp660_ = throws_gdbuserror;
				} else {
					_tmp660_ = FALSE;
				}
				_tmp659_ = !_tmp660_;
			} else {
				_tmp659_ = FALSE;
			}
			if (_tmp659_) {
				ValaSourceReference* _tmp661_;
				ValaSourceReference* _tmp662_;
				_tmp661_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp662_ = _tmp661_;
				vala_report_warning (_tmp662_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp663_;
		ValaMethod* _tmp664_;
		gboolean _tmp673_;
		gboolean _tmp674_;
		gboolean _tmp677_;
		gboolean _tmp680_;
		_tmp663_ = vala_code_context_get_entry_point (context);
		_tmp664_ = _tmp663_;
		if (_tmp664_ != NULL) {
			ValaSourceReference* _tmp665_;
			ValaSourceReference* _tmp666_;
			ValaMethod* _tmp667_;
			ValaMethod* _tmp668_;
			gchar* _tmp669_;
			gchar* _tmp670_;
			gchar* _tmp671_;
			gchar* _tmp672_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp665_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_code_context_get_entry_point (context);
			_tmp668_ = _tmp667_;
			_tmp669_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp668_);
			_tmp670_ = _tmp669_;
			_tmp671_ = g_strdup_printf ("program already has an entry point `%s'", _tmp670_);
			_tmp672_ = _tmp671_;
			vala_report_error (_tmp666_, _tmp672_);
			_g_free0 (_tmp672_);
			_g_free0 (_tmp670_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp673_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp674_ = _tmp673_;
		if (_tmp674_) {
			ValaSourceReference* _tmp675_;
			ValaSourceReference* _tmp676_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp675_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp676_ = _tmp675_;
			vala_report_error (_tmp676_, "\"main\" method cannot throw errors");
		}
		_tmp677_ = self->priv->_is_inline;
		if (_tmp677_) {
			ValaSourceReference* _tmp678_;
			ValaSourceReference* _tmp679_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp678_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp679_ = _tmp678_;
			vala_report_error (_tmp679_, "\"main\" method cannot be inline");
		}
		_tmp680_ = self->priv->_coroutine;
		if (_tmp680_) {
			ValaSourceReference* _tmp681_;
			ValaSourceReference* _tmp682_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp681_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp682_ = _tmp681_;
			vala_report_error (_tmp682_, "\"main\" method cannot be async");
		}
	}
	_tmp683_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp683_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp684_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp685_ = _tmp684_;
	result = !_tmp685_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	ValaList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp34_;
	ValaIterator* _tmp35_;
	ValaIterator* _tmp36_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp37_;
	gpointer _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameterDirection _tmp41_;
	ValaParameter* _tmp42_;
	ValaDataType* _tmp43_;
	ValaDataType* _tmp44_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_type_symbol (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	_tmp27_ = _vala_iterable_ref0 (_tmp26_);
	params = _tmp27_;
	_tmp28_ = params;
	_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp31_ = params;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp34_ = params;
	_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
	params_it = _tmp35_;
	_tmp36_ = params_it;
	vala_iterator_next (_tmp36_);
	_tmp37_ = params_it;
	_tmp38_ = vala_iterator_get (_tmp37_);
	param = (ValaParameter*) _tmp38_;
	_tmp39_ = param;
	_tmp40_ = vala_parameter_get_direction (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp42_ = param;
	_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (!VALA_IS_ARRAY_TYPE (_tmp44_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp45_ = param;
	_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_type_symbol (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp32_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp31_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			ValaList* _tmp23_;
			gint _param_size = 0;
			ValaList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_param_list = _tmp23_;
			_tmp24_ = _param_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_param_size = _tmp26_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp27_;
				gpointer _tmp28_;
				ValaMethod* _tmp29_;
				ValaTypeParameter* _tmp30_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp27_ = _param_list;
				_tmp28_ = vala_list_get (_tmp27_, _param_index);
				param = (ValaTypeParameter*) _tmp28_;
				_tmp29_ = self->priv->end_method;
				_tmp30_ = param;
				vala_method_add_type_parameter (_tmp29_, _tmp30_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp31_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp31_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp32_ = self->priv->end_method;
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	result = _tmp24_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp4_;
	gboolean _tmp6_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_params_array_var;
	if (_tmp4_ != NULL) {
		ValaLocalVariable* _tmp5_;
		_tmp5_ = self->priv->_params_array_var;
		vala_collection_add (collection, (ValaVariable*) _tmp5_);
	}
	_tmp6_ = self->priv->_closure;
	if (_tmp6_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_params_array_var);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
static GType
vala_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
	static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_type_id;
	vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
	ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
	return vala_method_type_id;
}

GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		GType vala_method_type_id;
		vala_method_type_id = vala_method_get_type_once ();
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

