/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);
static GType vala_local_variable_get_type_once (void);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaSemanticAnalyzer* _tmp60_;
	ValaSemanticAnalyzer* _tmp61_;
	ValaSymbol* _tmp62_;
	ValaSymbol* _tmp63_;
	ValaScope* _tmp64_;
	ValaScope* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp135_;
	ValaDataType* _tmp136_;
	gboolean _tmp137_ = FALSE;
	gboolean _tmp138_ = FALSE;
	gboolean _tmp139_ = FALSE;
	ValaArrayType* _tmp140_;
	gboolean _tmp152_ = FALSE;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp154_ = FALSE;
	ValaArrayType* _tmp155_;
	gboolean _tmp166_ = FALSE;
	ValaExpression* _tmp167_;
	ValaExpression* _tmp168_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp303_;
	ValaSemanticAnalyzer* _tmp304_;
	ValaSymbol* _tmp305_;
	ValaSymbol* _tmp306_;
	ValaBlock* _tmp307_;
	gboolean _tmp309_;
	gboolean _tmp310_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaVarType* _tmp6_;
		ValaVarType* _tmp7_;
		_tmp6_ = vala_var_type_new (TRUE);
		_tmp7_ = _tmp6_;
		vala_variable_set_variable_type ((ValaVariable*) self, (ValaDataType*) _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	_tmp8_ = vala_code_context_get_experimental_non_null (context);
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_REFERENCE_TYPE (_tmp11_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaArrayType* _tmp15_;
			_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp13_ = _tmp12_;
			array_type = VALA_IS_ARRAY_TYPE (_tmp13_) ? ((ValaArrayType*) _tmp13_) : NULL;
			_tmp15_ = array_type;
			if (_tmp15_ != NULL) {
				ValaArrayType* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = array_type;
				_tmp17_ = vala_array_type_get_fixed_length (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
			} else {
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp20_ = _tmp19_;
				vala_data_type_set_nullable (_tmp20_, TRUE);
			}
		}
	}
	_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp22_ = _tmp21_;
	if (!VALA_IS_VAR_TYPE (_tmp22_)) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp24_ = _tmp23_;
		if (VALA_IS_VOID_TYPE (_tmp24_)) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			_tmp27_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp28_ = _tmp27_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp28_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
		_tmp29_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		if (!_tmp30_) {
			ValaSemanticAnalyzer* _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			_tmp31_ = vala_code_context_get_analyzer (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp34_ = _tmp33_;
			vala_semantic_analyzer_check_type (_tmp32_, _tmp34_);
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp36_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp38_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp39_ = _tmp38_;
		_tmp35_ = !_tmp39_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp50_;
		ValaExpression* _tmp51_;
		_tmp40_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		vala_expression_set_target_type (_tmp41_, _tmp43_);
		_tmp44_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp45_ = _tmp44_;
		if (VALA_IS_INITIALIZER_LIST (_tmp45_)) {
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp49_ = _tmp48_;
			initializer_size = _tmp49_;
			is_initializer_list = TRUE;
		}
		_tmp50_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp51_ = _tmp50_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp51_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		} else {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			if (VALA_IS_VOID_TYPE (_tmp55_)) {
				ValaExpression* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "'void' not supported as initializer type");
			}
		}
	}
	_tmp60_ = vala_code_context_get_analyzer (context);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_semantic_analyzer_get_current_symbol (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_symbol_get_scope (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp67_ = _tmp66_;
	vala_scope_add (_tmp65_, _tmp67_, (ValaSymbol*) self);
	_tmp68_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp69_ = _tmp68_;
	if (_tmp69_) {
		result = FALSE;
		return result;
	}
	_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp71_ = _tmp70_;
	if (VALA_IS_VAR_TYPE (_tmp71_)) {
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp76_;
		ValaExpression* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		gboolean _tmp82_ = FALSE;
		ValaExpression* _tmp83_;
		ValaExpression* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		gboolean value_owned = FALSE;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		gboolean _tmp103_;
		gboolean _tmp104_;
		ValaExpression* _tmp105_;
		ValaExpression* _tmp106_;
		ValaDataType* _tmp107_;
		ValaDataType* _tmp108_;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		ValaDataType* _tmp111_;
		ValaDataType* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		ValaExpression* _tmp115_;
		ValaExpression* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaDataType* _tmp119_;
		ValaDataType* _tmp120_;
		_tmp72_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp73_ = _tmp72_;
		if (_tmp73_ == NULL) {
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp75_ = _tmp74_;
			vala_report_error (_tmp75_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_expression_get_value_type (_tmp77_);
		_tmp79_ = _tmp78_;
		if (_tmp79_ == NULL) {
			ValaSourceReference* _tmp80_;
			ValaSourceReference* _tmp81_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp81_ = _tmp80_;
			vala_report_error (_tmp81_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_expression_get_value_type (_tmp84_);
		_tmp86_ = _tmp85_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp86_)) {
			_tmp82_ = TRUE;
		} else {
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			ValaDataType* _tmp89_;
			ValaDataType* _tmp90_;
			_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_expression_get_value_type (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp82_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp90_);
		}
		if (_tmp82_) {
			ValaExpression* _tmp91_;
			ValaExpression* _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaExpression* _tmp95_;
			ValaExpression* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp91_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_expression_get_symbol_reference (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_symbol_get_full_name (_tmp98_);
			_tmp100_ = _tmp99_;
			vala_report_error (_tmp94_, "Access to instance member `%s' denied", _tmp100_);
			_g_free0 (_tmp100_);
			result = FALSE;
			return result;
		}
		_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_get_value_owned (_tmp102_);
		_tmp104_ = _tmp103_;
		value_owned = _tmp104_;
		_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_expression_get_value_type (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_data_type_copy (_tmp108_);
		_tmp110_ = _tmp109_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp110_);
		_vala_code_node_unref0 (_tmp110_);
		_tmp111_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		vala_data_type_set_value_owned (_tmp112_, value_owned);
		_tmp113_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		vala_data_type_set_floating_reference (_tmp114_, FALSE);
		_tmp115_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type (_tmp116_, _tmp118_);
		_tmp119_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		vala_code_node_check ((ValaCodeNode*) _tmp120_, context);
	}
	_tmp121_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp122_ = _tmp121_;
	if (!_tmp122_) {
		ValaDataType* _tmp123_;
		ValaDataType* _tmp124_;
		ValaTypeSymbol* _tmp125_;
		ValaTypeSymbol* _tmp126_;
		_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_data_type_get_type_symbol (_tmp124_);
		_tmp126_ = _tmp125_;
		if (_tmp126_ != NULL) {
			ValaDataType* _tmp127_;
			ValaDataType* _tmp128_;
			ValaTypeSymbol* _tmp129_;
			ValaTypeSymbol* _tmp130_;
			ValaVersionAttribute* _tmp131_;
			ValaVersionAttribute* _tmp132_;
			ValaSourceReference* _tmp133_;
			ValaSourceReference* _tmp134_;
			_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_data_type_get_type_symbol (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_symbol_get_version ((ValaSymbol*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp134_ = _tmp133_;
			vala_version_attribute_check (_tmp132_, context, _tmp134_);
		}
	}
	_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp136_ = _tmp135_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp136_) ? ((ValaArrayType*) _tmp136_) : NULL;
	_tmp140_ = variable_array_type;
	if (_tmp140_ != NULL) {
		ValaArrayType* _tmp141_;
		gboolean _tmp142_;
		gboolean _tmp143_;
		_tmp141_ = variable_array_type;
		_tmp142_ = vala_array_type_get_inline_allocated (_tmp141_);
		_tmp143_ = _tmp142_;
		_tmp139_ = _tmp143_;
	} else {
		_tmp139_ = FALSE;
	}
	if (_tmp139_) {
		ValaExpression* _tmp144_;
		ValaExpression* _tmp145_;
		_tmp144_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp145_ = _tmp144_;
		_tmp138_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp145_);
	} else {
		_tmp138_ = FALSE;
	}
	if (_tmp138_) {
		ValaExpression* _tmp146_;
		ValaExpression* _tmp147_;
		ValaInitializerList* _tmp148_;
		ValaInitializerList* _tmp149_;
		_tmp146_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp149_ = _tmp148_;
		_tmp137_ = _tmp149_ == NULL;
	} else {
		_tmp137_ = FALSE;
	}
	if (_tmp137_) {
		ValaSourceReference* _tmp150_;
		ValaSourceReference* _tmp151_;
		_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp151_ = _tmp150_;
		vala_report_warning (_tmp151_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp155_ = variable_array_type;
	if (_tmp155_ != NULL) {
		ValaArrayType* _tmp156_;
		gboolean _tmp157_;
		gboolean _tmp158_;
		_tmp156_ = variable_array_type;
		_tmp157_ = vala_array_type_get_inline_allocated (_tmp156_);
		_tmp158_ = _tmp157_;
		_tmp154_ = _tmp158_;
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaArrayType* _tmp159_;
		ValaExpression* _tmp160_;
		ValaExpression* _tmp161_;
		_tmp159_ = variable_array_type;
		_tmp160_ = vala_array_type_get_length (_tmp159_);
		_tmp161_ = _tmp160_;
		_tmp153_ = _tmp161_ == NULL;
	} else {
		_tmp153_ = FALSE;
	}
	if (_tmp153_) {
		ValaExpression* _tmp162_;
		ValaExpression* _tmp163_;
		_tmp162_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp163_ = _tmp162_;
		_tmp152_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp163_);
	} else {
		_tmp152_ = FALSE;
	}
	if (_tmp152_) {
		ValaSourceReference* _tmp164_;
		ValaSourceReference* _tmp165_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp165_ = _tmp164_;
		vala_report_error (_tmp165_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp167_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp168_ = _tmp167_;
	if (_tmp168_ != NULL) {
		ValaExpression* _tmp169_;
		ValaExpression* _tmp170_;
		gboolean _tmp171_;
		gboolean _tmp172_;
		_tmp169_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp170_ = _tmp169_;
		_tmp171_ = vala_code_node_get_error ((ValaCodeNode*) _tmp170_);
		_tmp172_ = _tmp171_;
		_tmp166_ = !_tmp172_;
	} else {
		_tmp166_ = FALSE;
	}
	if (_tmp166_) {
		ValaExpression* _tmp173_;
		ValaExpression* _tmp174_;
		ValaDataType* _tmp175_;
		ValaDataType* _tmp176_;
		ValaExpression* _tmp216_;
		ValaExpression* _tmp217_;
		ValaDataType* _tmp218_;
		ValaDataType* _tmp219_;
		ValaDataType* _tmp220_;
		ValaDataType* _tmp221_;
		gboolean _tmp261_ = FALSE;
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		ValaArrayType* _tmp264_;
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_ = FALSE;
		ValaArrayType* _tmp280_;
		ValaExpression* _tmp290_;
		ValaExpression* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		_tmp173_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp174_ = _tmp173_;
		_tmp175_ = vala_expression_get_value_type (_tmp174_);
		_tmp176_ = _tmp175_;
		if (VALA_IS_METHOD_TYPE (_tmp176_)) {
			gboolean _tmp177_ = FALSE;
			ValaExpression* _tmp178_;
			ValaExpression* _tmp179_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			_tmp178_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp179_ = _tmp178_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp179_)) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				_tmp180_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp181_ = _tmp180_;
				_tmp177_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp181_);
			} else {
				_tmp177_ = FALSE;
			}
			if (_tmp177_) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				vala_report_error (_tmp183_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp184_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			if (VALA_IS_DELEGATE_TYPE (_tmp185_)) {
				ValaExpression* _tmp186_;
				ValaExpression* _tmp187_;
				ValaDataType* _tmp188_;
				ValaDataType* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				_tmp186_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_expression_get_value_type (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp191_ = _tmp190_;
				if (!vala_data_type_compatible (_tmp189_, _tmp191_)) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp192_;
					ValaExpression* _tmp193_;
					ValaSymbol* _tmp194_;
					ValaSymbol* _tmp195_;
					ValaDelegate* cb = NULL;
					ValaDataType* _tmp196_;
					ValaDataType* _tmp197_;
					ValaDelegate* _tmp198_;
					ValaDelegate* _tmp199_;
					ValaSourceReference* _tmp200_;
					ValaSourceReference* _tmp201_;
					ValaMethod* _tmp202_;
					gchar* _tmp203_;
					gchar* _tmp204_;
					ValaDelegate* _tmp205_;
					gchar* _tmp206_;
					gchar* _tmp207_;
					_tmp192_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_expression_get_symbol_reference (_tmp193_);
					_tmp195_ = _tmp194_;
					m = G_TYPE_CHECK_INSTANCE_CAST (_tmp195_, VALA_TYPE_METHOD, ValaMethod);
					_tmp196_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp199_ = _tmp198_;
					cb = _tmp199_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp201_ = _tmp200_;
					_tmp202_ = m;
					_tmp203_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = cb;
					_tmp206_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp205_);
					_tmp207_ = _tmp206_;
					vala_report_error (_tmp201_, "Declaration of method `%s' is not compatible with delegate `%s'", _tmp204_, _tmp207_);
					_g_free0 (_tmp207_);
					_g_free0 (_tmp204_);
					result = FALSE;
					return result;
				}
			} else {
				ValaSourceReference* _tmp208_;
				ValaSourceReference* _tmp209_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp209_ = _tmp208_;
				vala_report_error (_tmp209_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		} else {
			ValaExpression* _tmp210_;
			ValaExpression* _tmp211_;
			ValaDataType* _tmp212_;
			ValaDataType* _tmp213_;
			_tmp210_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_expression_get_value_type (_tmp211_);
			_tmp213_ = _tmp212_;
			if (_tmp213_ == NULL) {
				ValaSourceReference* _tmp214_;
				ValaSourceReference* _tmp215_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp215_ = _tmp214_;
				vala_report_error (_tmp215_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp216_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_expression_get_value_type (_tmp217_);
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp221_ = _tmp220_;
		if (!vala_data_type_compatible (_tmp219_, _tmp221_)) {
			ValaSourceReference* _tmp222_;
			ValaSourceReference* _tmp223_;
			ValaExpression* _tmp224_;
			ValaExpression* _tmp225_;
			ValaDataType* _tmp226_;
			ValaDataType* _tmp227_;
			gchar* _tmp228_;
			gchar* _tmp229_;
			ValaDataType* _tmp230_;
			ValaDataType* _tmp231_;
			gchar* _tmp232_;
			gchar* _tmp233_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp223_ = _tmp222_;
			_tmp224_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp225_ = _tmp224_;
			_tmp226_ = vala_expression_get_value_type (_tmp225_);
			_tmp227_ = _tmp226_;
			_tmp228_ = vala_code_node_to_string ((ValaCodeNode*) _tmp227_);
			_tmp229_ = _tmp228_;
			_tmp230_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_code_node_to_string ((ValaCodeNode*) _tmp231_);
			_tmp233_ = _tmp232_;
			vala_report_error (_tmp223_, "Assignment: Cannot convert from `%s' to `%s'", _tmp229_, _tmp233_);
			_g_free0 (_tmp233_);
			_g_free0 (_tmp229_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp234_ = FALSE;
			gboolean _tmp235_ = FALSE;
			ValaDataType* _tmp236_;
			ValaDataType* _tmp237_;
			_tmp236_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp237_ = _tmp236_;
			if (VALA_IS_ENUM_VALUE_TYPE (_tmp237_)) {
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaDataType* _tmp240_;
				ValaDataType* _tmp241_;
				_tmp238_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_value_type (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp235_ = VALA_IS_INTEGER_TYPE (_tmp241_);
			} else {
				_tmp235_ = FALSE;
			}
			if (_tmp235_) {
				gboolean _tmp242_ = FALSE;
				ValaExpression* _tmp243_;
				ValaExpression* _tmp244_;
				_tmp243_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp244_ = _tmp243_;
				if (!VALA_IS_INTEGER_LITERAL (_tmp244_)) {
					_tmp242_ = TRUE;
				} else {
					ValaExpression* _tmp245_;
					ValaExpression* _tmp246_;
					const gchar* _tmp247_;
					const gchar* _tmp248_;
					_tmp245_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp246_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
					_tmp248_ = _tmp247_;
					_tmp242_ = g_strcmp0 (_tmp248_, "0") != 0;
				}
				_tmp234_ = _tmp242_;
			} else {
				_tmp234_ = FALSE;
			}
			if (_tmp234_) {
				ValaSourceReference* _tmp249_;
				ValaSourceReference* _tmp250_;
				ValaExpression* _tmp251_;
				ValaExpression* _tmp252_;
				ValaDataType* _tmp253_;
				ValaDataType* _tmp254_;
				gchar* _tmp255_;
				gchar* _tmp256_;
				ValaDataType* _tmp257_;
				ValaDataType* _tmp258_;
				gchar* _tmp259_;
				gchar* _tmp260_;
				_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp250_ = _tmp249_;
				_tmp251_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp252_ = _tmp251_;
				_tmp253_ = vala_expression_get_value_type (_tmp252_);
				_tmp254_ = _tmp253_;
				_tmp255_ = vala_code_node_to_string ((ValaCodeNode*) _tmp254_);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp258_ = _tmp257_;
				_tmp259_ = vala_code_node_to_string ((ValaCodeNode*) _tmp258_);
				_tmp260_ = _tmp259_;
				vala_report_notice (_tmp250_, "Assignment: Unsafe conversion from `%s' to `%s'", _tmp256_, _tmp260_);
				_g_free0 (_tmp260_);
				_g_free0 (_tmp256_);
			}
		}
		_tmp264_ = variable_array_type;
		if (_tmp264_ != NULL) {
			ValaArrayType* _tmp265_;
			gboolean _tmp266_;
			gboolean _tmp267_;
			_tmp265_ = variable_array_type;
			_tmp266_ = vala_array_type_get_inline_allocated (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp263_ = _tmp267_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaArrayType* _tmp268_;
			gboolean _tmp269_;
			gboolean _tmp270_;
			_tmp268_ = variable_array_type;
			_tmp269_ = vala_array_type_get_fixed_length (_tmp268_);
			_tmp270_ = _tmp269_;
			_tmp262_ = !_tmp270_;
		} else {
			_tmp262_ = FALSE;
		}
		if (_tmp262_) {
			_tmp261_ = is_initializer_list;
		} else {
			_tmp261_ = FALSE;
		}
		if (_tmp261_) {
			ValaArrayType* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			ValaIntegerLiteral* _tmp274_;
			ValaIntegerLiteral* _tmp275_;
			ValaArrayType* _tmp276_;
			ValaArrayType* _tmp277_;
			_tmp271_ = variable_array_type;
			_tmp272_ = g_strdup_printf ("%i", initializer_size);
			_tmp273_ = _tmp272_;
			_tmp274_ = vala_integer_literal_new (_tmp273_, NULL);
			_tmp275_ = _tmp274_;
			vala_array_type_set_length (_tmp271_, (ValaExpression*) _tmp275_);
			_vala_code_node_unref0 (_tmp275_);
			_g_free0 (_tmp273_);
			_tmp276_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp276_, TRUE);
			_tmp277_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp277_, FALSE);
		}
		_tmp280_ = variable_array_type;
		if (_tmp280_ != NULL) {
			ValaArrayType* _tmp281_;
			gboolean _tmp282_;
			gboolean _tmp283_;
			_tmp281_ = variable_array_type;
			_tmp282_ = vala_array_type_get_inline_allocated (_tmp281_);
			_tmp283_ = _tmp282_;
			_tmp279_ = _tmp283_;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			ValaExpression* _tmp284_;
			ValaExpression* _tmp285_;
			ValaDataType* _tmp286_;
			ValaDataType* _tmp287_;
			_tmp284_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_expression_get_value_type (_tmp285_);
			_tmp287_ = _tmp286_;
			_tmp278_ = VALA_IS_ARRAY_TYPE (_tmp287_) == FALSE;
		} else {
			_tmp278_ = FALSE;
		}
		if (_tmp278_) {
			ValaSourceReference* _tmp288_;
			ValaSourceReference* _tmp289_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp289_ = _tmp288_;
			vala_report_error (_tmp289_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp290_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp291_ = _tmp290_;
		_tmp292_ = vala_expression_get_value_type (_tmp291_);
		_tmp293_ = _tmp292_;
		if (vala_data_type_is_disposable (_tmp293_)) {
			gboolean _tmp294_ = FALSE;
			ValaDataType* _tmp295_;
			ValaDataType* _tmp296_;
			_tmp295_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp296_ = _tmp295_;
			if (!VALA_IS_POINTER_TYPE (_tmp296_)) {
				ValaDataType* _tmp297_;
				ValaDataType* _tmp298_;
				gboolean _tmp299_;
				gboolean _tmp300_;
				_tmp297_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_data_type_get_value_owned (_tmp298_);
				_tmp300_ = _tmp299_;
				_tmp294_ = !_tmp300_;
			} else {
				_tmp294_ = FALSE;
			}
			if (_tmp294_) {
				ValaSourceReference* _tmp301_;
				ValaSourceReference* _tmp302_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp301_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp302_ = _tmp301_;
				vala_report_error (_tmp302_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp303_ = vala_code_context_get_analyzer (context);
	_tmp304_ = _tmp303_;
	_tmp305_ = vala_semantic_analyzer_get_current_symbol (_tmp304_);
	_tmp306_ = _tmp305_;
	block = VALA_IS_BLOCK (_tmp306_) ? ((ValaBlock*) _tmp306_) : NULL;
	_tmp307_ = block;
	if (_tmp307_ != NULL) {
		ValaBlock* _tmp308_;
		_tmp308_ = block;
		vala_block_add_local_variable (_tmp308_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp309_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp310_ = _tmp309_;
	result = !_tmp310_;
	return result;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
static GType
vala_local_variable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
	GType vala_local_variable_type_id;
	vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
	ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
	return vala_local_variable_type_id;
}

GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = vala_local_variable_get_type_once ();
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

