/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp654_ = FALSE;
	gboolean _tmp655_ = FALSE;
	gboolean _tmp656_ = FALSE;
	ValaExpression* _tmp657_;
	ValaExpression* _tmp658_;
	ValaSymbol* _tmp685_;
	ValaSymbol* _tmp686_;
	ValaSymbol* _tmp755_;
	ValaSymbol* _tmp756_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp792_;
	ValaSymbol* _tmp793_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp794_;
	ValaSymbol* _tmp795_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1243_;
	ValaSymbol* _tmp1244_;
	ValaSymbol* _tmp1246_;
	ValaVersionAttribute* _tmp1247_;
	ValaVersionAttribute* _tmp1248_;
	ValaSourceReference* _tmp1249_;
	ValaSourceReference* _tmp1250_;
	gboolean _tmp1251_ = FALSE;
	ValaSymbolAccessibility _tmp1252_;
	gboolean _tmp1304_ = FALSE;
	gboolean _tmp1331_ = FALSE;
	gboolean _tmp1332_ = FALSE;
	ValaDataType* _tmp1615_;
	ValaDataType* _tmp1616_;
	gboolean _tmp1619_;
	gboolean _tmp1620_;
	gboolean _tmp1621_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp300_ = FALSE;
			ValaExpression* _tmp301_;
			ValaExpression* _tmp302_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp332_ = FALSE;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			gboolean _tmp353_ = FALSE;
			ValaSymbol* _tmp354_;
			ValaSymbol* _tmp355_;
			gboolean _tmp389_ = FALSE;
			gboolean _tmp390_ = FALSE;
			ValaSymbol* _tmp391_;
			ValaSymbol* _tmp392_;
			gboolean _tmp625_ = FALSE;
			ValaSymbol* _tmp626_;
			ValaSymbol* _tmp627_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaPointerIndirection* _tmp282_;
					ValaPointerIndirection* _tmp283_;
					ValaExpression* _tmp284_;
					ValaExpression* _tmp285_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_formal_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					if (VALA_IS_GENERIC_TYPE (_tmp268_)) {
						ValaExpression* _tmp269_;
						ValaExpression* _tmp270_;
						ValaPointerType* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaCastExpression* _tmp276_;
						ValaCastExpression* _tmp277_;
						_tmp269_ = vala_member_access_get_inner (self);
						_tmp270_ = _tmp269_;
						_tmp271_ = pointer_type;
						_tmp272_ = vala_data_type_copy ((ValaDataType*) _tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_cast_expression_new (_tmp270_, _tmp273_, _tmp275_);
						_tmp277_ = _tmp276_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp281_ = _tmp280_;
					_tmp282_ = vala_pointer_indirection_new (_tmp279_, _tmp281_);
					_tmp283_ = _tmp282_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp283_);
					_vala_code_node_unref0 (_tmp283_);
					_tmp284_ = vala_member_access_get_inner (self);
					_tmp285_ = _tmp284_;
					vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaMemberAccess* _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp290_ = ma;
				_tmp291_ = _tmp290_->priv->_prototype_access;
				if (_tmp291_) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaExpression* _tmp294_;
					ValaExpression* _tmp295_;
					ValaSymbol* _tmp296_;
					ValaSymbol* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_member_access_get_inner (self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_symbol_get_full_name (_tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_error (_tmp293_, "Access to instance member `%s' denied", _tmp299_);
					_g_free0 (_tmp299_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp301_ = vala_member_access_get_inner (self);
			_tmp302_ = _tmp301_;
			if (VALA_IS_CAST_EXPRESSION (_tmp302_)) {
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				_tmp303_ = vala_member_access_get_inner (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp304_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp306_ = _tmp305_;
				_tmp300_ = _tmp306_;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_warning (_tmp308_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_MEMBER_ACCESS (_tmp311_)) {
				_tmp309_ = TRUE;
			} else {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp309_ = VALA_IS_BASE_ACCESS (_tmp313_);
			}
			if (_tmp309_) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaSymbol* _tmp316_;
				ValaSymbol* _tmp317_;
				gboolean _tmp318_ = FALSE;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_symbol_reference (_tmp315_);
				_tmp317_ = _tmp316_;
				base_symbol = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp320_ = _tmp319_;
				if (_tmp320_ == NULL) {
					gboolean _tmp321_ = FALSE;
					ValaSymbol* _tmp322_;
					_tmp322_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp322_)) {
						_tmp321_ = TRUE;
					} else {
						ValaSymbol* _tmp323_;
						_tmp323_ = base_symbol;
						_tmp321_ = VALA_IS_TYPESYMBOL (_tmp323_);
					}
					_tmp318_ = _tmp321_;
				} else {
					_tmp318_ = FALSE;
				}
				if (_tmp318_) {
					ValaSymbol* _tmp324_;
					ValaScope* _tmp325_;
					ValaScope* _tmp326_;
					const gchar* _tmp327_;
					ValaSymbol* _tmp328_;
					ValaSymbol* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp324_ = base_symbol;
					_tmp325_ = vala_symbol_get_scope (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = self->priv->_member_name;
					_tmp328_ = vala_scope_lookup (_tmp326_, _tmp327_);
					_tmp329_ = _tmp328_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = vala_member_access_get_inner (self);
					_tmp331_ = _tmp330_;
					if (VALA_IS_BASE_ACCESS (_tmp331_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp333_ = vala_member_access_get_inner (self);
			_tmp334_ = _tmp333_;
			if (VALA_IS_MEMBER_ACCESS (_tmp334_)) {
				ValaExpression* _tmp335_;
				ValaExpression* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaSymbol* _tmp338_;
				_tmp335_ = vala_member_access_get_inner (self);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_expression_get_symbol_reference (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp332_ = VALA_IS_TYPEPARAMETER (_tmp338_);
			} else {
				_tmp332_ = FALSE;
			}
			if (_tmp332_) {
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				ValaGenericType* _tmp345_;
				ValaGenericType* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaDataType* _tmp349_;
				ValaDataType* _tmp350_;
				ValaSourceReference* _tmp351_;
				ValaSourceReference* _tmp352_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp344_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp346_ = _tmp345_;
				vala_expression_set_value_type (_tmp340_, (ValaDataType*) _tmp346_);
				_vala_code_node_unref0 (_tmp346_);
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_value_type (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp352_ = _tmp351_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp350_, _tmp352_);
			}
			_tmp354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp355_ = _tmp354_;
			if (_tmp355_ == NULL) {
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp353_ = _tmp359_ != NULL;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				gboolean _tmp360_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp360_ = self->priv->_pointer_member_access;
				if (_tmp360_) {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					const gchar* _tmp365_;
					ValaSymbol* _tmp366_;
					ValaSymbol* _tmp367_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = self->priv->_member_name;
					_tmp366_ = vala_data_type_get_pointer_member (_tmp364_, _tmp365_);
					_tmp367_ = _tmp366_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
				} else {
					ValaExpression* _tmp368_;
					ValaExpression* _tmp369_;
					ValaDataType* _tmp370_;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaExpression* _tmp380_;
					ValaExpression* _tmp381_;
					ValaDataType* _tmp382_;
					ValaDataType* _tmp383_;
					const gchar* _tmp384_;
					ValaSymbol* _tmp385_;
					ValaSymbol* _tmp386_;
					_tmp368_ = vala_member_access_get_inner (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_expression_get_value_type (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_data_type_get_type_symbol (_tmp371_);
					_tmp373_ = _tmp372_;
					if (_tmp373_ != NULL) {
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaTypeSymbol* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						_tmp374_ = vala_member_access_get_inner (self);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_expression_get_value_type (_tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						base_symbol = (ValaSymbol*) _tmp379_;
					}
					_tmp380_ = vala_member_access_get_inner (self);
					_tmp381_ = _tmp380_;
					_tmp382_ = vala_expression_get_value_type (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = self->priv->_member_name;
					_tmp385_ = vala_data_type_get_member (_tmp383_, _tmp384_);
					_tmp386_ = _tmp385_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp386_);
					_vala_code_node_unref0 (_tmp386_);
				}
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp388_ = _tmp387_;
				if (_tmp388_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp392_ = _tmp391_;
			if (_tmp392_ == NULL) {
				ValaExpression* _tmp393_;
				ValaExpression* _tmp394_;
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp393_ = vala_member_access_get_inner (self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_expression_get_value_type (_tmp394_);
				_tmp396_ = _tmp395_;
				_tmp390_ = _tmp396_ != NULL;
			} else {
				_tmp390_ = FALSE;
			}
			if (_tmp390_) {
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp397_ = vala_member_access_get_inner (self);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_is_dynamic (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp389_ = _tmp402_;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaObjectType* _tmp407_;
				ValaCodeNode* _tmp408_;
				ValaCodeNode* _tmp409_;
				ValaSymbol* _tmp573_;
				ValaSymbol* _tmp574_;
				ValaSymbol* _tmp623_;
				ValaSymbol* _tmp624_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp407_;
				_tmp408_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				if (VALA_IS_METHOD_CALL (_tmp409_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					ValaMethodCall* _tmp412_;
					ValaExpression* _tmp413_;
					ValaExpression* _tmp414_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp412_ = invoc;
					_tmp413_ = vala_method_call_get_call (_tmp412_);
					_tmp414_ = _tmp413_;
					if (_tmp414_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp415_;
						ValaDataType* _tmp416_;
						ValaDataType* _tmp417_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp432_;
						ValaExpression* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						const gchar* _tmp436_;
						ValaDataType* _tmp437_;
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaMethodCall* _tmp442_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp443_;
						ValaErrorType* _tmp444_;
						ValaDynamicMethod* _tmp445_;
						ValaErrorType* _tmp446_;
						ValaDynamicMethod* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						ValaParameter* _tmp449_;
						ValaParameter* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaObjectType* _tmp452_;
						ValaDataType* _tmp453_;
						ValaDataType* _tmp454_;
						ValaDynamicMethod* _tmp455_;
						ValaSourceReference* _tmp456_;
						ValaSourceReference* _tmp457_;
						ValaParameter* _tmp458_;
						ValaParameter* _tmp459_;
						ValaObjectType* _tmp460_;
						ValaTypeSymbol* _tmp461_;
						ValaTypeSymbol* _tmp462_;
						ValaScope* _tmp463_;
						ValaScope* _tmp464_;
						ValaDynamicMethod* _tmp465_;
						ValaDynamicMethod* _tmp466_;
						_tmp415_ = invoc;
						_tmp416_ = vala_expression_get_target_type ((ValaExpression*) _tmp415_);
						_tmp417_ = _tmp416_;
						if (_tmp417_ != NULL) {
							ValaMethodCall* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							_tmp418_ = invoc;
							_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_copy (_tmp420_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp421_;
							_tmp422_ = ret_type;
							vala_data_type_set_value_owned (_tmp422_, TRUE);
						} else {
							ValaMethodCall* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp423_ = invoc;
							_tmp424_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp423_);
							_tmp425_ = _tmp424_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp425_)) {
								ValaVoidType* _tmp426_;
								_tmp426_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp426_;
							} else {
								ValaExpression* _tmp427_;
								ValaExpression* _tmp428_;
								ValaDataType* _tmp429_;
								ValaDataType* _tmp430_;
								ValaDataType* _tmp431_;
								_tmp427_ = vala_member_access_get_inner (self);
								_tmp428_ = _tmp427_;
								_tmp429_ = vala_expression_get_value_type (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_data_type_copy (_tmp430_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp431_;
							}
						}
						_tmp432_ = vala_member_access_get_inner (self);
						_tmp433_ = _tmp432_;
						_tmp434_ = vala_expression_get_value_type (_tmp433_);
						_tmp435_ = _tmp434_;
						_tmp436_ = self->priv->_member_name;
						_tmp437_ = ret_type;
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_dynamic_method_new (_tmp435_, _tmp436_, _tmp437_, _tmp439_, NULL);
						m = _tmp440_;
						_tmp441_ = m;
						_tmp442_ = invoc;
						vala_dynamic_method_set_invocation (_tmp441_, _tmp442_);
						_tmp443_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp443_;
						_tmp444_ = err;
						vala_error_type_set_dynamic_error (_tmp444_, TRUE);
						_tmp445_ = m;
						_tmp446_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp445_, (ValaDataType*) _tmp446_);
						_tmp447_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp447_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp448_ = m;
						_tmp449_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp450_ = _tmp449_;
						vala_callable_add_parameter ((ValaCallable*) _tmp448_, _tmp450_);
						_vala_code_node_unref0 (_tmp450_);
						_tmp451_ = m;
						_tmp452_ = dynamic_object_type;
						_tmp453_ = vala_data_type_copy ((ValaDataType*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = m;
						_tmp456_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp455_);
						_tmp457_ = _tmp456_;
						_tmp458_ = vala_parameter_new ("this", _tmp454_, _tmp457_);
						_tmp459_ = _tmp458_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp451_, _tmp459_);
						_vala_code_node_unref0 (_tmp459_);
						_vala_code_node_unref0 (_tmp454_);
						_tmp460_ = dynamic_object_type;
						_tmp461_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp460_);
						_tmp462_ = _tmp461_;
						_tmp463_ = vala_symbol_get_scope ((ValaSymbol*) _tmp462_);
						_tmp464_ = _tmp463_;
						_tmp465_ = m;
						vala_scope_add (_tmp464_, NULL, (ValaSymbol*) _tmp465_);
						_tmp466_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp466_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp467_;
					ValaCodeNode* _tmp468_;
					_tmp467_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp468_ = _tmp467_;
					if (VALA_IS_ASSIGNMENT (_tmp468_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp469_;
						ValaCodeNode* _tmp470_;
						ValaAssignment* _tmp471_;
						ValaExpression* _tmp472_;
						ValaExpression* _tmp473_;
						_tmp469_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp470_ = _tmp469_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp470_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp471_ = a;
						_tmp472_ = vala_assignment_get_left (_tmp471_);
						_tmp473_ = _tmp472_;
						if (_tmp473_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp474_;
							ValaExpression* _tmp475_;
							ValaDataType* _tmp476_;
							ValaDataType* _tmp477_;
							const gchar* _tmp478_;
							ValaSourceReference* _tmp479_;
							ValaSourceReference* _tmp480_;
							ValaDynamicProperty* _tmp481_;
							ValaDynamicProperty* _tmp482_;
							ValaDynamicProperty* _tmp483_;
							ValaDynamicProperty* _tmp484_;
							ValaSourceReference* _tmp485_;
							ValaSourceReference* _tmp486_;
							ValaPropertyAccessor* _tmp487_;
							ValaPropertyAccessor* _tmp488_;
							ValaDynamicProperty* _tmp489_;
							ValaExpression* _tmp490_;
							ValaExpression* _tmp491_;
							ValaDataType* _tmp492_;
							ValaDataType* _tmp493_;
							ValaTypeSymbol* _tmp494_;
							ValaTypeSymbol* _tmp495_;
							ValaScope* _tmp496_;
							ValaScope* _tmp497_;
							ValaObjectType* _tmp498_;
							ValaTypeSymbol* _tmp499_;
							ValaTypeSymbol* _tmp500_;
							ValaScope* _tmp501_;
							ValaScope* _tmp502_;
							ValaDynamicProperty* _tmp503_;
							ValaDynamicProperty* _tmp504_;
							_tmp474_ = vala_member_access_get_inner (self);
							_tmp475_ = _tmp474_;
							_tmp476_ = vala_expression_get_value_type (_tmp475_);
							_tmp477_ = _tmp476_;
							_tmp478_ = self->priv->_member_name;
							_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp480_ = _tmp479_;
							_tmp481_ = vala_dynamic_property_new (_tmp477_, _tmp478_, _tmp480_, NULL);
							prop = _tmp481_;
							_tmp482_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp482_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp483_ = prop;
							_tmp484_ = prop;
							_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp484_);
							_tmp486_ = _tmp485_;
							_tmp487_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp486_, NULL);
							_tmp488_ = _tmp487_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp483_, _tmp488_);
							_vala_code_node_unref0 (_tmp488_);
							_tmp489_ = prop;
							_tmp490_ = vala_member_access_get_inner (self);
							_tmp491_ = _tmp490_;
							_tmp492_ = vala_expression_get_value_type (_tmp491_);
							_tmp493_ = _tmp492_;
							_tmp494_ = vala_data_type_get_type_symbol (_tmp493_);
							_tmp495_ = _tmp494_;
							_tmp496_ = vala_symbol_get_scope ((ValaSymbol*) _tmp495_);
							_tmp497_ = _tmp496_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp489_, _tmp497_);
							_tmp498_ = dynamic_object_type;
							_tmp499_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp498_);
							_tmp500_ = _tmp499_;
							_tmp501_ = vala_symbol_get_scope ((ValaSymbol*) _tmp500_);
							_tmp502_ = _tmp501_;
							_tmp503_ = prop;
							vala_scope_add (_tmp502_, NULL, (ValaSymbol*) _tmp503_);
							_tmp504_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp504_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp505_ = FALSE;
						gboolean _tmp506_ = FALSE;
						ValaCodeNode* _tmp507_;
						ValaCodeNode* _tmp508_;
						_tmp507_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp508_ = _tmp507_;
						if (VALA_IS_MEMBER_ACCESS (_tmp508_)) {
							ValaExpression* _tmp509_;
							ValaExpression* _tmp510_;
							_tmp509_ = vala_member_access_get_inner (self);
							_tmp510_ = _tmp509_;
							_tmp506_ = VALA_IS_MEMBER_ACCESS (_tmp510_);
						} else {
							_tmp506_ = FALSE;
						}
						if (_tmp506_) {
							ValaCodeNode* _tmp511_;
							ValaCodeNode* _tmp512_;
							ValaCodeNode* _tmp513_;
							ValaCodeNode* _tmp514_;
							_tmp511_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_code_node_get_parent_node (_tmp512_);
							_tmp514_ = _tmp513_;
							_tmp505_ = VALA_IS_METHOD_CALL (_tmp514_);
						} else {
							_tmp505_ = FALSE;
						}
						if (_tmp505_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp515_;
							ValaCodeNode* _tmp516_;
							gboolean _tmp517_ = FALSE;
							ValaMemberAccess* _tmp518_;
							const gchar* _tmp519_;
							_tmp515_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp516_ = _tmp515_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp516_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp518_ = ma;
							_tmp519_ = _tmp518_->priv->_member_name;
							if (g_strcmp0 (_tmp519_, "connect") == 0) {
								_tmp517_ = TRUE;
							} else {
								ValaMemberAccess* _tmp520_;
								const gchar* _tmp521_;
								_tmp520_ = ma;
								_tmp521_ = _tmp520_->priv->_member_name;
								_tmp517_ = g_strcmp0 (_tmp521_, "connect_after") == 0;
							}
							if (_tmp517_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp522_;
								ValaExpression* _tmp523_;
								ValaDataType* _tmp524_;
								ValaDataType* _tmp525_;
								const gchar* _tmp526_;
								ValaVoidType* _tmp527_;
								ValaVoidType* _tmp528_;
								ValaSourceReference* _tmp529_;
								ValaSourceReference* _tmp530_;
								ValaDynamicSignal* _tmp531_;
								ValaDynamicSignal* _tmp532_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp533_;
								ValaCodeNode* _tmp534_;
								ValaCodeNode* _tmp535_;
								ValaCodeNode* _tmp536_;
								ValaMethodCall* _tmp537_;
								ValaMethodCall* _tmp538_;
								ValaList* _tmp539_;
								gint _tmp540_;
								gint _tmp541_;
								ValaDynamicSignal* _tmp565_;
								ValaObjectType* _tmp566_;
								ValaTypeSymbol* _tmp567_;
								ValaTypeSymbol* _tmp568_;
								ValaScope* _tmp569_;
								ValaScope* _tmp570_;
								ValaDynamicSignal* _tmp571_;
								ValaDynamicSignal* _tmp572_;
								_tmp522_ = vala_member_access_get_inner (self);
								_tmp523_ = _tmp522_;
								_tmp524_ = vala_expression_get_value_type (_tmp523_);
								_tmp525_ = _tmp524_;
								_tmp526_ = self->priv->_member_name;
								_tmp527_ = vala_void_type_new (NULL);
								_tmp528_ = _tmp527_;
								_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp530_ = _tmp529_;
								_tmp531_ = vala_dynamic_signal_new (_tmp525_, _tmp526_, (ValaDataType*) _tmp528_, _tmp530_, NULL);
								_tmp532_ = _tmp531_;
								_vala_code_node_unref0 (_tmp528_);
								s = _tmp532_;
								_tmp533_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_code_node_get_parent_node (_tmp534_);
								_tmp536_ = _tmp535_;
								_tmp537_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp536_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp537_;
								_tmp538_ = mcall;
								_tmp539_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp538_);
								_tmp540_ = vala_collection_get_size ((ValaCollection*) _tmp539_);
								_tmp541_ = _tmp540_;
								if (_tmp541_ > 0) {
									ValaDynamicSignal* _tmp542_;
									ValaMethodCall* _tmp543_;
									ValaList* _tmp544_;
									gpointer _tmp545_;
									ValaExpression* _tmp546_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp547_;
									ValaExpression* _tmp548_;
									ValaExpression* _tmp549_;
									gboolean _tmp550_ = FALSE;
									gboolean _tmp551_ = FALSE;
									ValaMemberAccess* _tmp552_;
									_tmp542_ = s;
									_tmp543_ = mcall;
									_tmp544_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp543_);
									_tmp545_ = vala_list_get (_tmp544_, 0);
									_tmp546_ = (ValaExpression*) _tmp545_;
									vala_dynamic_signal_set_handler (_tmp542_, _tmp546_);
									_vala_code_node_unref0 (_tmp546_);
									_tmp547_ = s;
									_tmp548_ = vala_dynamic_signal_get_handler (_tmp547_);
									_tmp549_ = _tmp548_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp549_) ? ((ValaMemberAccess*) _tmp549_) : NULL;
									_tmp552_ = arg;
									if (_tmp552_ == NULL) {
										_tmp551_ = TRUE;
									} else {
										ValaMemberAccess* _tmp553_;
										_tmp553_ = arg;
										_tmp551_ = !vala_code_node_check ((ValaCodeNode*) _tmp553_, context);
									}
									if (_tmp551_) {
										_tmp550_ = TRUE;
									} else {
										ValaMemberAccess* _tmp554_;
										ValaSymbol* _tmp555_;
										ValaSymbol* _tmp556_;
										_tmp554_ = arg;
										_tmp555_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp554_);
										_tmp556_ = _tmp555_;
										_tmp550_ = !VALA_IS_METHOD (_tmp556_);
									}
									if (_tmp550_) {
										ValaDynamicSignal* _tmp557_;
										ValaExpression* _tmp558_;
										ValaExpression* _tmp559_;
										ValaSourceReference* _tmp560_;
										ValaSourceReference* _tmp561_;
										ValaDynamicSignal* _tmp562_;
										gchar* _tmp563_;
										gchar* _tmp564_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp557_ = s;
										_tmp558_ = vala_dynamic_signal_get_handler (_tmp557_);
										_tmp559_ = _tmp558_;
										_tmp560_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp559_);
										_tmp561_ = _tmp560_;
										_tmp562_ = s;
										_tmp563_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp562_);
										_tmp564_ = _tmp563_;
										vala_report_error (_tmp561_, "Invalid handler for `%s'", _tmp564_);
										_g_free0 (_tmp564_);
									}
								}
								_tmp565_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp565_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp566_ = dynamic_object_type;
								_tmp567_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp566_);
								_tmp568_ = _tmp567_;
								_tmp569_ = vala_symbol_get_scope ((ValaSymbol*) _tmp568_);
								_tmp570_ = _tmp569_;
								_tmp571_ = s;
								vala_scope_add (_tmp570_, NULL, (ValaSymbol*) _tmp571_);
								_tmp572_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp572_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp574_ = _tmp573_;
				if (_tmp574_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp575_;
					ValaExpression* _tmp576_;
					ValaDataType* _tmp577_;
					ValaDataType* _tmp578_;
					const gchar* _tmp579_;
					ValaSourceReference* _tmp580_;
					ValaSourceReference* _tmp581_;
					ValaDynamicProperty* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDynamicProperty* _tmp595_;
					ValaDynamicProperty* _tmp596_;
					ValaDynamicProperty* _tmp597_;
					ValaDataType* _tmp598_;
					ValaDataType* _tmp599_;
					ValaDataType* _tmp600_;
					ValaDataType* _tmp601_;
					ValaDynamicProperty* _tmp602_;
					ValaSourceReference* _tmp603_;
					ValaSourceReference* _tmp604_;
					ValaPropertyAccessor* _tmp605_;
					ValaPropertyAccessor* _tmp606_;
					ValaDynamicProperty* _tmp607_;
					ValaExpression* _tmp608_;
					ValaExpression* _tmp609_;
					ValaDataType* _tmp610_;
					ValaDataType* _tmp611_;
					ValaTypeSymbol* _tmp612_;
					ValaTypeSymbol* _tmp613_;
					ValaScope* _tmp614_;
					ValaScope* _tmp615_;
					ValaObjectType* _tmp616_;
					ValaTypeSymbol* _tmp617_;
					ValaTypeSymbol* _tmp618_;
					ValaScope* _tmp619_;
					ValaScope* _tmp620_;
					ValaDynamicProperty* _tmp621_;
					ValaDynamicProperty* _tmp622_;
					_tmp575_ = vala_member_access_get_inner (self);
					_tmp576_ = _tmp575_;
					_tmp577_ = vala_expression_get_value_type (_tmp576_);
					_tmp578_ = _tmp577_;
					_tmp579_ = self->priv->_member_name;
					_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp581_ = _tmp580_;
					_tmp582_ = vala_dynamic_property_new (_tmp578_, _tmp579_, _tmp581_, NULL);
					prop = _tmp582_;
					_tmp583_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp584_ = _tmp583_;
					if (_tmp584_ != NULL) {
						ValaDynamicProperty* _tmp585_;
						ValaDataType* _tmp586_;
						ValaDataType* _tmp587_;
						_tmp585_ = prop;
						_tmp586_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp587_ = _tmp586_;
						vala_property_set_property_type ((ValaProperty*) _tmp585_, _tmp587_);
					} else {
						ValaDynamicProperty* _tmp588_;
						ValaExpression* _tmp589_;
						ValaExpression* _tmp590_;
						ValaDataType* _tmp591_;
						ValaDataType* _tmp592_;
						ValaDataType* _tmp593_;
						ValaDataType* _tmp594_;
						_tmp588_ = prop;
						_tmp589_ = vala_member_access_get_inner (self);
						_tmp590_ = _tmp589_;
						_tmp591_ = vala_expression_get_value_type (_tmp590_);
						_tmp592_ = _tmp591_;
						_tmp593_ = vala_data_type_copy (_tmp592_);
						_tmp594_ = _tmp593_;
						vala_property_set_property_type ((ValaProperty*) _tmp588_, _tmp594_);
						_vala_code_node_unref0 (_tmp594_);
					}
					_tmp595_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp595_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp596_ = prop;
					_tmp597_ = prop;
					_tmp598_ = vala_property_get_property_type ((ValaProperty*) _tmp597_);
					_tmp599_ = _tmp598_;
					_tmp600_ = vala_data_type_copy (_tmp599_);
					_tmp601_ = _tmp600_;
					_tmp602_ = prop;
					_tmp603_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp601_, NULL, _tmp604_, NULL);
					_tmp606_ = _tmp605_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp596_, _tmp606_);
					_vala_code_node_unref0 (_tmp606_);
					_vala_code_node_unref0 (_tmp601_);
					_tmp607_ = prop;
					_tmp608_ = vala_member_access_get_inner (self);
					_tmp609_ = _tmp608_;
					_tmp610_ = vala_expression_get_value_type (_tmp609_);
					_tmp611_ = _tmp610_;
					_tmp612_ = vala_data_type_get_type_symbol (_tmp611_);
					_tmp613_ = _tmp612_;
					_tmp614_ = vala_symbol_get_scope ((ValaSymbol*) _tmp613_);
					_tmp615_ = _tmp614_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp607_, _tmp615_);
					_tmp616_ = dynamic_object_type;
					_tmp617_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp616_);
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_symbol_get_scope ((ValaSymbol*) _tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = prop;
					vala_scope_add (_tmp620_, NULL, (ValaSymbol*) _tmp621_);
					_tmp622_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp622_);
					_vala_code_node_unref0 (prop);
				}
				_tmp623_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp624_ = _tmp623_;
				if (_tmp624_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp626_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp627_ = _tmp626_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp627_)) {
				ValaExpression* _tmp628_;
				ValaExpression* _tmp629_;
				ValaSymbol* _tmp630_;
				ValaSymbol* _tmp631_;
				_tmp628_ = vala_member_access_get_inner (self);
				_tmp629_ = _tmp628_;
				_tmp630_ = vala_expression_get_symbol_reference (_tmp629_);
				_tmp631_ = _tmp630_;
				_tmp625_ = VALA_IS_VARIABLE (_tmp631_);
			} else {
				_tmp625_ = FALSE;
			}
			if (_tmp625_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp632_;
				ValaSemanticAnalyzer* _tmp633_;
				ValaExpression* _tmp634_;
				ValaExpression* _tmp635_;
				ValaSymbol* _tmp636_;
				ValaSymbol* _tmp637_;
				ValaDataType* _tmp638_;
				ValaArrayType* _tmp639_;
				gboolean _tmp640_ = FALSE;
				ValaArrayType* _tmp641_;
				_tmp632_ = vala_code_context_get_analyzer (context);
				_tmp633_ = _tmp632_;
				_tmp634_ = vala_member_access_get_inner (self);
				_tmp635_ = _tmp634_;
				_tmp636_ = vala_expression_get_symbol_reference (_tmp635_);
				_tmp637_ = _tmp636_;
				_tmp638_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp633_, _tmp637_, TRUE);
				_tmp639_ = VALA_IS_ARRAY_TYPE (_tmp638_) ? ((ValaArrayType*) _tmp638_) : NULL;
				if (_tmp639_ == NULL) {
					_vala_code_node_unref0 (_tmp638_);
				}
				inner_type = _tmp639_;
				_tmp641_ = inner_type;
				if (_tmp641_ != NULL) {
					ValaArrayType* _tmp642_;
					gboolean _tmp643_;
					gboolean _tmp644_;
					_tmp642_ = inner_type;
					_tmp643_ = vala_array_type_get_inline_allocated (_tmp642_);
					_tmp644_ = _tmp643_;
					_tmp640_ = _tmp644_;
				} else {
					_tmp640_ = FALSE;
				}
				if (_tmp640_) {
					ValaSourceReference* _tmp645_;
					ValaSourceReference* _tmp646_;
					_tmp645_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp646_ = _tmp645_;
					vala_report_error (_tmp646_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp647_ = FALSE;
					ValaArrayType* _tmp648_;
					_tmp648_ = inner_type;
					if (_tmp648_ != NULL) {
						ValaArrayType* _tmp649_;
						gboolean _tmp650_;
						gboolean _tmp651_;
						_tmp649_ = inner_type;
						_tmp650_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp649_);
						_tmp651_ = _tmp650_;
						_tmp647_ = !_tmp651_;
					} else {
						_tmp647_ = FALSE;
					}
					if (_tmp647_) {
						ValaSourceReference* _tmp652_;
						ValaSourceReference* _tmp653_;
						_tmp652_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp653_ = _tmp652_;
						vala_report_error (_tmp653_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp657_ = vala_member_access_get_inner (self);
	_tmp658_ = _tmp657_;
	if (_tmp658_ == NULL) {
		ValaSymbol* _tmp659_;
		ValaSymbol* _tmp660_;
		_tmp659_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp660_ = _tmp659_;
		_tmp656_ = _tmp660_ == NULL;
	} else {
		_tmp656_ = FALSE;
	}
	if (_tmp656_) {
		ValaDataType* _tmp661_;
		ValaDataType* _tmp662_;
		_tmp661_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp662_ = _tmp661_;
		_tmp655_ = _tmp662_ != NULL;
	} else {
		_tmp655_ = FALSE;
	}
	if (_tmp655_) {
		ValaDataType* _tmp663_;
		ValaDataType* _tmp664_;
		ValaTypeSymbol* _tmp665_;
		ValaTypeSymbol* _tmp666_;
		_tmp663_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp664_ = _tmp663_;
		_tmp665_ = vala_data_type_get_type_symbol (_tmp664_);
		_tmp666_ = _tmp665_;
		_tmp654_ = VALA_IS_ENUM (_tmp666_);
	} else {
		_tmp654_ = FALSE;
	}
	if (_tmp654_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp667_;
		ValaDataType* _tmp668_;
		ValaTypeSymbol* _tmp669_;
		ValaTypeSymbol* _tmp670_;
		_tmp667_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp668_ = _tmp667_;
		_tmp669_ = vala_data_type_get_type_symbol (_tmp668_);
		_tmp670_ = _tmp669_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp670_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp671_;
			ValaList* _tmp672_;
			gint _val_size = 0;
			ValaList* _tmp673_;
			gint _tmp674_;
			gint _tmp675_;
			gint _val_index = 0;
			_tmp671_ = enum_type;
			_tmp672_ = vala_enum_get_values (_tmp671_);
			_val_list = _tmp672_;
			_tmp673_ = _val_list;
			_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
			_tmp675_ = _tmp674_;
			_val_size = _tmp675_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp676_;
				gint _tmp677_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp678_;
				gpointer _tmp679_;
				const gchar* _tmp680_;
				ValaEnumValue* _tmp681_;
				const gchar* _tmp682_;
				const gchar* _tmp683_;
				_val_index = _val_index + 1;
				_tmp676_ = _val_index;
				_tmp677_ = _val_size;
				if (!(_tmp676_ < _tmp677_)) {
					break;
				}
				_tmp678_ = _val_list;
				_tmp679_ = vala_list_get (_tmp678_, _val_index);
				val = (ValaEnumValue*) _tmp679_;
				_tmp680_ = self->priv->_member_name;
				_tmp681_ = val;
				_tmp682_ = vala_symbol_get_name ((ValaSymbol*) _tmp681_);
				_tmp683_ = _tmp682_;
				if (g_strcmp0 (_tmp680_, _tmp683_) == 0) {
					ValaEnumValue* _tmp684_;
					_tmp684_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp684_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp685_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp686_ = _tmp685_;
	if (_tmp686_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp687_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp688_ = FALSE;
		ValaExpression* _tmp689_;
		ValaExpression* _tmp690_;
		gchar* base_type_package = NULL;
		gchar* _tmp710_;
		gboolean _tmp711_ = FALSE;
		ValaSymbol* _tmp712_;
		gchar* visited_types_string = NULL;
		gchar* _tmp727_;
		ValaSourceReference* _tmp743_;
		ValaSourceReference* _tmp744_;
		const gchar* _tmp745_;
		const gchar* _tmp746_;
		const gchar* _tmp747_;
		const gchar* _tmp748_;
		ValaInvalidType* _tmp749_;
		ValaInvalidType* _tmp750_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp687_ = g_strdup ("(null)");
		base_type_name = _tmp687_;
		base_type = NULL;
		_tmp689_ = vala_member_access_get_inner (self);
		_tmp690_ = _tmp689_;
		if (_tmp690_ != NULL) {
			ValaExpression* _tmp691_;
			ValaExpression* _tmp692_;
			ValaDataType* _tmp693_;
			ValaDataType* _tmp694_;
			_tmp691_ = vala_member_access_get_inner (self);
			_tmp692_ = _tmp691_;
			_tmp693_ = vala_expression_get_value_type (_tmp692_);
			_tmp694_ = _tmp693_;
			_tmp688_ = _tmp694_ != NULL;
		} else {
			_tmp688_ = FALSE;
		}
		if (_tmp688_) {
			ValaExpression* _tmp695_;
			ValaExpression* _tmp696_;
			ValaDataType* _tmp697_;
			ValaDataType* _tmp698_;
			gchar* _tmp699_;
			ValaExpression* _tmp700_;
			ValaExpression* _tmp701_;
			ValaDataType* _tmp702_;
			ValaDataType* _tmp703_;
			ValaTypeSymbol* _tmp704_;
			ValaTypeSymbol* _tmp705_;
			_tmp695_ = vala_member_access_get_inner (self);
			_tmp696_ = _tmp695_;
			_tmp697_ = vala_expression_get_value_type (_tmp696_);
			_tmp698_ = _tmp697_;
			_tmp699_ = vala_code_node_to_string ((ValaCodeNode*) _tmp698_);
			_g_free0 (base_type_name);
			base_type_name = _tmp699_;
			_tmp700_ = vala_member_access_get_inner (self);
			_tmp701_ = _tmp700_;
			_tmp702_ = vala_expression_get_value_type (_tmp701_);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_data_type_get_type_symbol (_tmp703_);
			_tmp705_ = _tmp704_;
			base_type = (ValaSymbol*) _tmp705_;
		} else {
			ValaSymbol* _tmp706_;
			_tmp706_ = base_symbol;
			if (_tmp706_ != NULL) {
				ValaSymbol* _tmp707_;
				gchar* _tmp708_;
				ValaSymbol* _tmp709_;
				_tmp707_ = base_symbol;
				_tmp708_ = vala_symbol_get_full_name (_tmp707_);
				_g_free0 (base_type_name);
				base_type_name = _tmp708_;
				_tmp709_ = base_symbol;
				base_type = _tmp709_;
			}
		}
		_tmp710_ = g_strdup ("");
		base_type_package = _tmp710_;
		_tmp712_ = base_type;
		if (_tmp712_ != NULL) {
			ValaSymbol* _tmp713_;
			gboolean _tmp714_;
			gboolean _tmp715_;
			_tmp713_ = base_type;
			_tmp714_ = vala_symbol_get_external_package (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp711_ = _tmp715_;
		} else {
			_tmp711_ = FALSE;
		}
		if (_tmp711_) {
			ValaSymbol* _tmp716_;
			ValaSourceReference* _tmp717_;
			ValaSourceReference* _tmp718_;
			ValaSourceFile* _tmp719_;
			ValaSourceFile* _tmp720_;
			const gchar* _tmp721_;
			const gchar* _tmp722_;
			gchar* _tmp723_;
			const gchar* _tmp724_;
			_tmp716_ = base_symbol;
			_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp716_);
			_tmp718_ = _tmp717_;
			_tmp719_ = vala_source_reference_get_file (_tmp718_);
			_tmp720_ = _tmp719_;
			_tmp721_ = vala_source_file_get_package_name (_tmp720_);
			_tmp722_ = _tmp721_;
			_tmp723_ = g_strdup (_tmp722_);
			_g_free0 (base_type_package);
			base_type_package = _tmp723_;
			_tmp724_ = base_type_package;
			if (_tmp724_ != NULL) {
				const gchar* _tmp725_;
				gchar* _tmp726_;
				_tmp725_ = base_type_package;
				_tmp726_ = g_strdup_printf (" (%s)", _tmp725_);
				_g_free0 (base_type_package);
				base_type_package = _tmp726_;
			}
		}
		_tmp727_ = g_strdup ("");
		visited_types_string = _tmp727_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp728_;
			gint _type_size = 0;
			ValaArrayList* _tmp729_;
			gint _tmp730_;
			gint _tmp731_;
			gint _type_index = 0;
			_tmp728_ = visited_types;
			_type_list = _tmp728_;
			_tmp729_ = _type_list;
			_tmp730_ = vala_collection_get_size ((ValaCollection*) _tmp729_);
			_tmp731_ = _tmp730_;
			_type_size = _tmp731_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp732_;
				gint _tmp733_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp734_;
				gpointer _tmp735_;
				const gchar* _tmp736_;
				ValaDataType* _tmp737_;
				gchar* _tmp738_;
				gchar* _tmp739_;
				gchar* _tmp740_;
				gchar* _tmp741_;
				gchar* _tmp742_;
				_type_index = _type_index + 1;
				_tmp732_ = _type_index;
				_tmp733_ = _type_size;
				if (!(_tmp732_ < _tmp733_)) {
					break;
				}
				_tmp734_ = _type_list;
				_tmp735_ = vala_list_get ((ValaList*) _tmp734_, _type_index);
				type = (ValaDataType*) _tmp735_;
				_tmp736_ = visited_types_string;
				_tmp737_ = type;
				_tmp738_ = vala_code_node_to_string ((ValaCodeNode*) _tmp737_);
				_tmp739_ = _tmp738_;
				_tmp740_ = g_strdup_printf (" or `%s'", _tmp739_);
				_tmp741_ = _tmp740_;
				_tmp742_ = g_strconcat (_tmp736_, _tmp741_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp742_;
				_g_free0 (_tmp741_);
				_g_free0 (_tmp739_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp743_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp744_ = _tmp743_;
		_tmp745_ = self->priv->_member_name;
		_tmp746_ = base_type_name;
		_tmp747_ = base_type_package;
		_tmp748_ = visited_types_string;
		vala_report_error (_tmp744_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp745_, _tmp746_, _tmp747_, _tmp748_);
		_tmp749_ = vala_invalid_type_new ();
		_tmp750_ = _tmp749_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp750_);
		_vala_code_node_unref0 (_tmp750_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp751_;
		ValaSymbol* _tmp752_;
		gboolean _tmp753_;
		gboolean _tmp754_;
		_tmp751_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp752_ = _tmp751_;
		_tmp753_ = vala_code_node_get_error ((ValaCodeNode*) _tmp752_);
		_tmp754_ = _tmp753_;
		if (_tmp754_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp755_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp756_ = _tmp755_;
	if (VALA_IS_SIGNAL (_tmp756_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp757_;
		ValaSymbol* _tmp758_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp765_;
		ValaCodeNode* _tmp766_;
		ValaCodeNode* _tmp767_;
		gboolean _tmp768_ = FALSE;
		gboolean _tmp769_ = FALSE;
		gboolean _tmp770_ = FALSE;
		ValaCodeNode* _tmp771_;
		_tmp757_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp758_ = _tmp757_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp758_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp759_;
			ValaCodeNode* _tmp760_;
			ValaCodeNode* _tmp761_;
			ValaCodeNode* _tmp762_;
			ValaCodeNode* _tmp763_;
			ValaCodeNode* _tmp764_;
			_tmp759_ = ma;
			_tmp760_ = vala_code_node_get_parent_node (_tmp759_);
			_tmp761_ = _tmp760_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp761_)) {
				break;
			}
			_tmp762_ = ma;
			_tmp763_ = vala_code_node_get_parent_node (_tmp762_);
			_tmp764_ = _tmp763_;
			ma = _tmp764_;
		}
		_tmp765_ = ma;
		_tmp766_ = vala_code_node_get_parent_node (_tmp765_);
		_tmp767_ = _tmp766_;
		parent = _tmp767_;
		_tmp771_ = parent;
		if (_tmp771_ != NULL) {
			ValaCodeNode* _tmp772_;
			_tmp772_ = parent;
			_tmp770_ = !VALA_IS_ELEMENT_ACCESS (_tmp772_);
		} else {
			_tmp770_ = FALSE;
		}
		if (_tmp770_) {
			ValaCodeNode* _tmp773_;
			ValaExpression* _tmp774_;
			ValaExpression* _tmp775_;
			_tmp773_ = ma;
			_tmp774_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp773_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp775_ = _tmp774_;
			_tmp769_ = !VALA_IS_BASE_ACCESS (_tmp775_);
		} else {
			_tmp769_ = FALSE;
		}
		if (_tmp769_) {
			gboolean _tmp776_ = FALSE;
			ValaCodeNode* _tmp777_;
			_tmp777_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp777_)) {
				_tmp776_ = TRUE;
			} else {
				ValaCodeNode* _tmp778_;
				ValaList* _tmp779_;
				_tmp778_ = parent;
				_tmp779_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp778_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp776_ = vala_collection_contains ((ValaCollection*) _tmp779_, (ValaExpression*) self);
			}
			_tmp768_ = _tmp776_;
		} else {
			_tmp768_ = FALSE;
		}
		if (_tmp768_) {
			ValaSignal* _tmp780_;
			ValaAttribute* _tmp781_;
			_tmp780_ = sig;
			_tmp781_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp780_, "HasEmitter");
			if (_tmp781_ != NULL) {
				ValaSignal* _tmp782_;
				ValaSignal* _tmp783_;
				ValaMethod* _tmp784_;
				ValaMethod* _tmp785_;
				_tmp782_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp782_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp783_ = sig;
				_tmp784_ = vala_signal_get_emitter (_tmp783_);
				_tmp785_ = _tmp784_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp785_);
			} else {
				ValaSourceReference* _tmp786_;
				ValaSourceReference* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaSymbol* _tmp789_;
				gchar* _tmp790_;
				gchar* _tmp791_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp786_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp787_ = _tmp786_;
				_tmp788_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp789_ = _tmp788_;
				_tmp790_ = vala_symbol_get_full_name (_tmp789_);
				_tmp791_ = _tmp790_;
				vala_report_error (_tmp787_, "Signal `%s' requires emitter in this context", _tmp791_);
				_g_free0 (_tmp791_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp792_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp793_ = _tmp792_;
	member = _tmp793_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp794_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp794_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp795_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp795_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp796_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp797_;
		ValaSymbol* _tmp798_;
		ValaSymbol* _tmp799_;
		gboolean _tmp800_ = FALSE;
		ValaBlock* _tmp801_;
		_tmp796_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp796_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp797_ = local;
		_tmp798_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp797_);
		_tmp799_ = _tmp798_;
		block = VALA_IS_BLOCK (_tmp799_) ? ((ValaBlock*) _tmp799_) : NULL;
		_tmp801_ = block;
		if (_tmp801_ != NULL) {
			ValaBlock* _tmp802_;
			ValaSymbol* _tmp803_;
			ValaSemanticAnalyzer* _tmp804_;
			ValaSemanticAnalyzer* _tmp805_;
			ValaSymbol* _tmp806_;
			ValaSymbol* _tmp807_;
			_tmp802_ = block;
			_tmp803_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp802_);
			_tmp804_ = vala_code_context_get_analyzer (context);
			_tmp805_ = _tmp804_;
			_tmp806_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp805_);
			_tmp807_ = _tmp806_;
			_tmp800_ = _tmp803_ != _tmp807_;
		} else {
			_tmp800_ = FALSE;
		}
		if (_tmp800_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp808_;
			ValaSemanticAnalyzer* _tmp809_;
			ValaSymbol* _tmp810_;
			ValaSymbol* _tmp811_;
			ValaLocalVariable* _tmp822_;
			ValaBlock* _tmp823_;
			ValaLocalVariable* _tmp824_;
			ValaDataType* _tmp825_;
			ValaDataType* _tmp826_;
			ValaTypeSymbol* _tmp827_;
			ValaTypeSymbol* _tmp828_;
			ValaSemanticAnalyzer* _tmp829_;
			ValaSemanticAnalyzer* _tmp830_;
			ValaDataType* _tmp831_;
			ValaTypeSymbol* _tmp832_;
			ValaTypeSymbol* _tmp833_;
			_tmp808_ = vala_code_context_get_analyzer (context);
			_tmp809_ = _tmp808_;
			_tmp810_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp809_);
			_tmp811_ = _tmp810_;
			sym = _tmp811_;
			while (TRUE) {
				ValaSymbol* _tmp812_;
				ValaBlock* _tmp813_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp814_;
				ValaMethod* _tmp815_;
				ValaSymbol* _tmp819_;
				ValaSymbol* _tmp820_;
				ValaSymbol* _tmp821_;
				_tmp812_ = sym;
				_tmp813_ = block;
				if (!(_tmp812_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp813_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp814_ = sym;
				method = VALA_IS_METHOD (_tmp814_) ? ((ValaMethod*) _tmp814_) : NULL;
				_tmp815_ = method;
				if (_tmp815_ != NULL) {
					ValaMethod* _tmp816_;
					ValaMethod* _tmp817_;
					ValaLocalVariable* _tmp818_;
					_tmp816_ = method;
					vala_method_set_closure (_tmp816_, TRUE);
					_tmp817_ = method;
					_tmp818_ = local;
					vala_method_add_captured_variable (_tmp817_, _tmp818_);
				}
				_tmp819_ = sym;
				_tmp820_ = vala_symbol_get_parent_symbol (_tmp819_);
				_tmp821_ = _tmp820_;
				sym = _tmp821_;
			}
			_tmp822_ = local;
			vala_local_variable_set_captured (_tmp822_, TRUE);
			_tmp823_ = block;
			vala_block_set_captured (_tmp823_, TRUE);
			_tmp824_ = local;
			_tmp825_ = vala_variable_get_variable_type ((ValaVariable*) _tmp824_);
			_tmp826_ = _tmp825_;
			_tmp827_ = vala_data_type_get_type_symbol (_tmp826_);
			_tmp828_ = _tmp827_;
			_tmp829_ = vala_code_context_get_analyzer (context);
			_tmp830_ = _tmp829_;
			_tmp831_ = _tmp830_->va_list_type;
			_tmp832_ = vala_data_type_get_type_symbol (_tmp831_);
			_tmp833_ = _tmp832_;
			if (_tmp828_ == _tmp833_) {
				ValaSourceReference* _tmp834_;
				ValaSourceReference* _tmp835_;
				ValaLocalVariable* _tmp836_;
				gchar* _tmp837_;
				gchar* _tmp838_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp834_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp835_ = _tmp834_;
				_tmp836_ = local;
				_tmp837_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp836_);
				_tmp838_ = _tmp837_;
				vala_report_error (_tmp835_, "Capturing `va_list' variable `%s' is not allowed", _tmp838_);
				_g_free0 (_tmp838_);
			}
		}
	} else {
		ValaSymbol* _tmp839_;
		_tmp839_ = member;
		if (VALA_IS_PARAMETER (_tmp839_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp840_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp841_;
			ValaSymbol* _tmp842_;
			ValaSymbol* _tmp843_;
			gboolean _tmp844_ = FALSE;
			gboolean _tmp845_ = FALSE;
			ValaMethod* _tmp846_;
			_tmp840_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp840_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp841_ = param;
			_tmp842_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp841_);
			_tmp843_ = _tmp842_;
			m = VALA_IS_METHOD (_tmp843_) ? ((ValaMethod*) _tmp843_) : NULL;
			_tmp846_ = m;
			if (_tmp846_ != NULL) {
				ValaMethod* _tmp847_;
				ValaSemanticAnalyzer* _tmp848_;
				ValaSemanticAnalyzer* _tmp849_;
				ValaSymbol* _tmp850_;
				ValaSymbol* _tmp851_;
				_tmp847_ = m;
				_tmp848_ = vala_code_context_get_analyzer (context);
				_tmp849_ = _tmp848_;
				_tmp850_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp849_);
				_tmp851_ = _tmp850_;
				_tmp845_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp847_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp851_;
			} else {
				_tmp845_ = FALSE;
			}
			if (_tmp845_) {
				ValaParameter* _tmp852_;
				ValaMethod* _tmp853_;
				ValaParameter* _tmp854_;
				ValaParameter* _tmp855_;
				_tmp852_ = param;
				_tmp853_ = m;
				_tmp854_ = vala_method_get_this_parameter (_tmp853_);
				_tmp855_ = _tmp854_;
				_tmp844_ = _tmp852_ != _tmp855_;
			} else {
				_tmp844_ = FALSE;
			}
			if (_tmp844_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp856_;
				ValaSemanticAnalyzer* _tmp857_;
				ValaSymbol* _tmp858_;
				ValaSymbol* _tmp859_;
				ValaParameter* _tmp868_;
				ValaMethod* _tmp869_;
				ValaBlock* _tmp870_;
				ValaBlock* _tmp871_;
				ValaParameter* _tmp872_;
				ValaParameterDirection _tmp873_;
				ValaParameterDirection _tmp874_;
				ValaParameter* _tmp880_;
				ValaDataType* _tmp881_;
				ValaDataType* _tmp882_;
				ValaTypeSymbol* _tmp883_;
				ValaTypeSymbol* _tmp884_;
				ValaSemanticAnalyzer* _tmp885_;
				ValaSemanticAnalyzer* _tmp886_;
				ValaDataType* _tmp887_;
				ValaTypeSymbol* _tmp888_;
				ValaTypeSymbol* _tmp889_;
				_tmp856_ = vala_code_context_get_analyzer (context);
				_tmp857_ = _tmp856_;
				_tmp858_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp857_);
				_tmp859_ = _tmp858_;
				sym = _tmp859_;
				while (TRUE) {
					ValaSymbol* _tmp860_;
					ValaMethod* _tmp861_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp862_;
					ValaMethod* _tmp863_;
					ValaSymbol* _tmp865_;
					ValaSymbol* _tmp866_;
					ValaSymbol* _tmp867_;
					_tmp860_ = sym;
					_tmp861_ = m;
					if (!(_tmp860_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp861_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp862_ = sym;
					method = VALA_IS_METHOD (_tmp862_) ? ((ValaMethod*) _tmp862_) : NULL;
					_tmp863_ = method;
					if (_tmp863_ != NULL) {
						ValaMethod* _tmp864_;
						_tmp864_ = method;
						vala_method_set_closure (_tmp864_, TRUE);
					}
					_tmp865_ = sym;
					_tmp866_ = vala_symbol_get_parent_symbol (_tmp865_);
					_tmp867_ = _tmp866_;
					sym = _tmp867_;
				}
				_tmp868_ = param;
				vala_parameter_set_captured (_tmp868_, TRUE);
				_tmp869_ = m;
				_tmp870_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp869_);
				_tmp871_ = _tmp870_;
				vala_block_set_captured (_tmp871_, TRUE);
				_tmp872_ = param;
				_tmp873_ = vala_parameter_get_direction (_tmp872_);
				_tmp874_ = _tmp873_;
				if (_tmp874_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp875_;
					ValaSourceReference* _tmp876_;
					ValaParameter* _tmp877_;
					gchar* _tmp878_;
					gchar* _tmp879_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp875_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp876_ = _tmp875_;
					_tmp877_ = param;
					_tmp878_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp877_);
					_tmp879_ = _tmp878_;
					vala_report_error (_tmp876_, "Cannot capture reference or output parameter `%s'", _tmp879_);
					_g_free0 (_tmp879_);
				}
				_tmp880_ = param;
				_tmp881_ = vala_variable_get_variable_type ((ValaVariable*) _tmp880_);
				_tmp882_ = _tmp881_;
				_tmp883_ = vala_data_type_get_type_symbol (_tmp882_);
				_tmp884_ = _tmp883_;
				_tmp885_ = vala_code_context_get_analyzer (context);
				_tmp886_ = _tmp885_;
				_tmp887_ = _tmp886_->va_list_type;
				_tmp888_ = vala_data_type_get_type_symbol (_tmp887_);
				_tmp889_ = _tmp888_;
				if (_tmp884_ == _tmp889_) {
					ValaSourceReference* _tmp890_;
					ValaSourceReference* _tmp891_;
					ValaParameter* _tmp892_;
					gchar* _tmp893_;
					gchar* _tmp894_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp890_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp891_ = _tmp890_;
					_tmp892_ = param;
					_tmp893_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp892_);
					_tmp894_ = _tmp893_;
					vala_report_error (_tmp891_, "Capturing `va_list' parameter `%s' is not allowed", _tmp894_);
					_g_free0 (_tmp894_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp895_;
				ValaSymbol* _tmp896_;
				ValaSymbol* _tmp897_;
				ValaSymbol* _tmp898_;
				ValaSymbol* _tmp899_;
				gboolean _tmp900_ = FALSE;
				gboolean _tmp901_ = FALSE;
				ValaPropertyAccessor* _tmp902_;
				_tmp895_ = param;
				_tmp896_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp895_);
				_tmp897_ = _tmp896_;
				_tmp898_ = vala_symbol_get_parent_symbol (_tmp897_);
				_tmp899_ = _tmp898_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp899_) ? ((ValaPropertyAccessor*) _tmp899_) : NULL;
				_tmp902_ = acc;
				if (_tmp902_ != NULL) {
					ValaPropertyAccessor* _tmp903_;
					ValaSemanticAnalyzer* _tmp904_;
					ValaSemanticAnalyzer* _tmp905_;
					ValaSymbol* _tmp906_;
					ValaSymbol* _tmp907_;
					_tmp903_ = acc;
					_tmp904_ = vala_code_context_get_analyzer (context);
					_tmp905_ = _tmp904_;
					_tmp906_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp905_);
					_tmp907_ = _tmp906_;
					_tmp901_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp903_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp907_;
				} else {
					_tmp901_ = FALSE;
				}
				if (_tmp901_) {
					ValaParameter* _tmp908_;
					ValaPropertyAccessor* _tmp909_;
					ValaProperty* _tmp910_;
					ValaProperty* _tmp911_;
					ValaParameter* _tmp912_;
					ValaParameter* _tmp913_;
					_tmp908_ = param;
					_tmp909_ = acc;
					_tmp910_ = vala_property_accessor_get_prop (_tmp909_);
					_tmp911_ = _tmp910_;
					_tmp912_ = vala_property_get_this_parameter (_tmp911_);
					_tmp913_ = _tmp912_;
					_tmp900_ = _tmp908_ != _tmp913_;
				} else {
					_tmp900_ = FALSE;
				}
				if (_tmp900_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp914_;
					ValaSemanticAnalyzer* _tmp915_;
					ValaSymbol* _tmp916_;
					ValaSymbol* _tmp917_;
					ValaParameter* _tmp926_;
					ValaPropertyAccessor* _tmp927_;
					ValaBlock* _tmp928_;
					ValaBlock* _tmp929_;
					_tmp914_ = vala_code_context_get_analyzer (context);
					_tmp915_ = _tmp914_;
					_tmp916_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp915_);
					_tmp917_ = _tmp916_;
					sym = _tmp917_;
					while (TRUE) {
						ValaSymbol* _tmp918_;
						ValaMethod* _tmp919_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp920_;
						ValaMethod* _tmp921_;
						ValaSymbol* _tmp923_;
						ValaSymbol* _tmp924_;
						ValaSymbol* _tmp925_;
						_tmp918_ = sym;
						_tmp919_ = m;
						if (!(_tmp918_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp919_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp920_ = sym;
						method = VALA_IS_METHOD (_tmp920_) ? ((ValaMethod*) _tmp920_) : NULL;
						_tmp921_ = method;
						if (_tmp921_ != NULL) {
							ValaMethod* _tmp922_;
							_tmp922_ = method;
							vala_method_set_closure (_tmp922_, TRUE);
						}
						_tmp923_ = sym;
						_tmp924_ = vala_symbol_get_parent_symbol (_tmp923_);
						_tmp925_ = _tmp924_;
						sym = _tmp925_;
					}
					_tmp926_ = param;
					vala_parameter_set_captured (_tmp926_, TRUE);
					_tmp927_ = acc;
					_tmp928_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp927_);
					_tmp929_ = _tmp928_;
					vala_block_set_captured (_tmp929_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp930_;
			_tmp930_ = member;
			if (VALA_IS_FIELD (_tmp930_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp931_;
				ValaField* _tmp932_;
				ValaSymbolAccessibility _tmp933_;
				ValaSymbolAccessibility _tmp934_;
				ValaField* _tmp935_;
				ValaMemberBinding _tmp936_;
				ValaMemberBinding _tmp937_;
				ValaField* _tmp938_;
				ValaMemberBinding _tmp939_;
				ValaMemberBinding _tmp940_;
				ValaField* _tmp941_;
				ValaDataType* _tmp942_;
				ValaDataType* _tmp943_;
				_tmp931_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp931_, VALA_TYPE_FIELD, ValaField);
				_tmp932_ = f;
				_tmp933_ = vala_symbol_get_access ((ValaSymbol*) _tmp932_);
				_tmp934_ = _tmp933_;
				access = _tmp934_;
				_tmp935_ = f;
				_tmp936_ = vala_field_get_binding (_tmp935_);
				_tmp937_ = _tmp936_;
				instance = _tmp937_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp938_ = f;
				_tmp939_ = vala_field_get_binding (_tmp938_);
				_tmp940_ = _tmp939_;
				klass = _tmp940_ == VALA_MEMBER_BINDING_CLASS;
				_tmp941_ = f;
				_tmp942_ = vala_variable_get_variable_type ((ValaVariable*) _tmp941_);
				_tmp943_ = _tmp942_;
				if (VALA_IS_GENERIC_TYPE (_tmp943_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp944_;
				_tmp944_ = member;
				if (VALA_IS_CONSTANT (_tmp944_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp945_;
					ValaConstant* _tmp946_;
					ValaSymbolAccessibility _tmp947_;
					ValaSymbolAccessibility _tmp948_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp949_;
					ValaSymbol* _tmp950_;
					ValaSymbol* _tmp951_;
					gboolean _tmp952_ = FALSE;
					ValaBlock* _tmp953_;
					_tmp945_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp945_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp946_ = c;
					_tmp947_ = vala_symbol_get_access ((ValaSymbol*) _tmp946_);
					_tmp948_ = _tmp947_;
					access = _tmp948_;
					_tmp949_ = c;
					_tmp950_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp949_);
					_tmp951_ = _tmp950_;
					block = VALA_IS_BLOCK (_tmp951_) ? ((ValaBlock*) _tmp951_) : NULL;
					_tmp953_ = block;
					if (_tmp953_ != NULL) {
						ValaBlock* _tmp954_;
						ValaSymbol* _tmp955_;
						ValaSemanticAnalyzer* _tmp956_;
						ValaSemanticAnalyzer* _tmp957_;
						ValaSymbol* _tmp958_;
						ValaSymbol* _tmp959_;
						_tmp954_ = block;
						_tmp955_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp954_);
						_tmp956_ = vala_code_context_get_analyzer (context);
						_tmp957_ = _tmp956_;
						_tmp958_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp957_);
						_tmp959_ = _tmp958_;
						_tmp952_ = _tmp955_ != _tmp959_;
					} else {
						_tmp952_ = FALSE;
					}
					if (_tmp952_) {
						ValaSourceReference* _tmp960_;
						ValaSourceReference* _tmp961_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp960_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp961_ = _tmp960_;
						vala_report_error (_tmp961_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp962_;
					_tmp962_ = member;
					if (VALA_IS_METHOD (_tmp962_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp963_;
						ValaMethod* _tmp964_;
						gboolean _tmp965_;
						gboolean _tmp966_;
						ValaMethod* _tmp1053_;
						ValaSymbolAccessibility _tmp1054_;
						ValaSymbolAccessibility _tmp1055_;
						ValaMethod* _tmp1056_;
						ValaMethod* _tmp1060_;
						ValaMemberBinding _tmp1061_;
						ValaMemberBinding _tmp1062_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1082_;
						ValaDataType* _tmp1083_;
						ValaDataType* _tmp1084_;
						gboolean _tmp1085_ = FALSE;
						ValaGenericType* _tmp1086_;
						_tmp963_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp963_, VALA_TYPE_METHOD, ValaMethod);
						_tmp964_ = m;
						_tmp965_ = vala_method_get_is_async_callback (_tmp964_);
						_tmp966_ = _tmp965_;
						if (_tmp966_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp967_;
							ValaSemanticAnalyzer* _tmp968_;
							ValaMethod* _tmp969_;
							ValaMethod* _tmp970_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp971_;
							ValaMethod* _tmp998_;
							ValaSemanticAnalyzer* _tmp999_;
							ValaSemanticAnalyzer* _tmp1000_;
							ValaMethod* _tmp1001_;
							ValaMethod* _tmp1002_;
							ValaMethod* _tmp1018_;
							ValaMethod* _tmp1019_;
							ValaMethod* _tmp1020_;
							ValaSymbol* _tmp1021_;
							ValaSymbol* _tmp1022_;
							_tmp967_ = vala_code_context_get_analyzer (context);
							_tmp968_ = _tmp967_;
							_tmp969_ = vala_semantic_analyzer_get_current_async_method (_tmp968_);
							_tmp970_ = _tmp969_;
							async_method = _tmp970_;
							is_valid_access = FALSE;
							_tmp971_ = async_method;
							if (_tmp971_ != NULL) {
								ValaMethod* _tmp972_;
								ValaMethod* _tmp973_;
								ValaMethod* _tmp974_;
								_tmp972_ = m;
								_tmp973_ = async_method;
								_tmp974_ = vala_method_get_callback_method (_tmp973_);
								if (_tmp972_ == _tmp974_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp975_ = FALSE;
									ValaMethod* _tmp976_;
									ValaMethod* _tmp977_;
									ValaMethod* _tmp978_;
									_tmp976_ = async_method;
									_tmp977_ = vala_method_get_base_method (_tmp976_);
									_tmp978_ = _tmp977_;
									if (_tmp978_ != NULL) {
										ValaMethod* _tmp979_;
										ValaMethod* _tmp980_;
										ValaMethod* _tmp981_;
										ValaMethod* _tmp982_;
										ValaMethod* _tmp983_;
										_tmp979_ = m;
										_tmp980_ = async_method;
										_tmp981_ = vala_method_get_base_method (_tmp980_);
										_tmp982_ = _tmp981_;
										_tmp983_ = vala_method_get_callback_method (_tmp982_);
										_tmp975_ = _tmp979_ == _tmp983_;
									} else {
										_tmp975_ = FALSE;
									}
									if (_tmp975_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp984_ = FALSE;
										ValaMethod* _tmp985_;
										ValaMethod* _tmp986_;
										ValaMethod* _tmp987_;
										_tmp985_ = async_method;
										_tmp986_ = vala_method_get_base_interface_method (_tmp985_);
										_tmp987_ = _tmp986_;
										if (_tmp987_ != NULL) {
											ValaMethod* _tmp988_;
											ValaMethod* _tmp989_;
											ValaMethod* _tmp990_;
											ValaMethod* _tmp991_;
											ValaMethod* _tmp992_;
											_tmp988_ = m;
											_tmp989_ = async_method;
											_tmp990_ = vala_method_get_base_interface_method (_tmp989_);
											_tmp991_ = _tmp990_;
											_tmp992_ = vala_method_get_callback_method (_tmp991_);
											_tmp984_ = _tmp988_ == _tmp992_;
										} else {
											_tmp984_ = FALSE;
										}
										if (_tmp984_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp993_;
								ValaSourceReference* _tmp994_;
								ValaMethod* _tmp995_;
								gchar* _tmp996_;
								gchar* _tmp997_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp993_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp994_ = _tmp993_;
								_tmp995_ = m;
								_tmp996_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp995_);
								_tmp997_ = _tmp996_;
								vala_report_error (_tmp994_, "Access to async callback `%s' not allowed in this context", _tmp997_);
								_g_free0 (_tmp997_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp998_ = async_method;
							_tmp999_ = vala_code_context_get_analyzer (context);
							_tmp1000_ = _tmp999_;
							_tmp1001_ = vala_semantic_analyzer_get_current_method (_tmp1000_);
							_tmp1002_ = _tmp1001_;
							if (_tmp998_ != _tmp1002_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1003_;
								ValaSemanticAnalyzer* _tmp1004_;
								ValaMethod* _tmp1005_;
								ValaMethod* _tmp1006_;
								ValaMethod* _tmp1015_;
								ValaBlock* _tmp1016_;
								ValaBlock* _tmp1017_;
								_tmp1003_ = vala_code_context_get_analyzer (context);
								_tmp1004_ = _tmp1003_;
								_tmp1005_ = vala_semantic_analyzer_get_current_method (_tmp1004_);
								_tmp1006_ = _tmp1005_;
								sym = (ValaSymbol*) _tmp1006_;
								while (TRUE) {
									ValaSymbol* _tmp1007_;
									ValaMethod* _tmp1008_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1009_;
									ValaMethod* _tmp1010_;
									ValaSymbol* _tmp1012_;
									ValaSymbol* _tmp1013_;
									ValaSymbol* _tmp1014_;
									_tmp1007_ = sym;
									_tmp1008_ = async_method;
									if (!(_tmp1007_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1008_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1009_ = sym;
									method = VALA_IS_METHOD (_tmp1009_) ? ((ValaMethod*) _tmp1009_) : NULL;
									_tmp1010_ = method;
									if (_tmp1010_ != NULL) {
										ValaMethod* _tmp1011_;
										_tmp1011_ = method;
										vala_method_set_closure (_tmp1011_, TRUE);
									}
									_tmp1012_ = sym;
									_tmp1013_ = vala_symbol_get_parent_symbol (_tmp1012_);
									_tmp1014_ = _tmp1013_;
									sym = _tmp1014_;
								}
								_tmp1015_ = async_method;
								_tmp1016_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1015_);
								_tmp1017_ = _tmp1016_;
								vala_block_set_captured (_tmp1017_, TRUE);
							}
							_tmp1018_ = async_method;
							_tmp1019_ = vala_method_get_callback_method (_tmp1018_);
							m = _tmp1019_;
							_tmp1020_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1020_);
							_tmp1021_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1022_ = _tmp1021_;
							member = _tmp1022_;
						} else {
							ValaMethod* _tmp1023_;
							ValaMethod* _tmp1024_;
							ValaMethod* _tmp1025_;
							_tmp1023_ = m;
							_tmp1024_ = vala_method_get_base_method (_tmp1023_);
							_tmp1025_ = _tmp1024_;
							if (_tmp1025_ != NULL) {
								ValaMethod* _tmp1026_;
								ValaMethod* _tmp1027_;
								ValaMethod* _tmp1028_;
								ValaMethod* _tmp1029_;
								ValaSignal* _tmp1030_;
								ValaSignal* _tmp1031_;
								ValaSymbol* _tmp1036_;
								ValaSymbol* _tmp1037_;
								_tmp1026_ = m;
								_tmp1027_ = vala_method_get_base_method (_tmp1026_);
								_tmp1028_ = _tmp1027_;
								m = _tmp1028_;
								_tmp1029_ = m;
								_tmp1030_ = vala_method_get_signal_reference (_tmp1029_);
								_tmp1031_ = _tmp1030_;
								if (_tmp1031_ != NULL) {
									ValaMethod* _tmp1032_;
									ValaSignal* _tmp1033_;
									ValaSignal* _tmp1034_;
									_tmp1032_ = m;
									_tmp1033_ = vala_method_get_signal_reference (_tmp1032_);
									_tmp1034_ = _tmp1033_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1034_);
								} else {
									ValaMethod* _tmp1035_;
									_tmp1035_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1035_);
								}
								_tmp1036_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1037_ = _tmp1036_;
								member = _tmp1037_;
							} else {
								ValaMethod* _tmp1038_;
								ValaMethod* _tmp1039_;
								ValaMethod* _tmp1040_;
								_tmp1038_ = m;
								_tmp1039_ = vala_method_get_base_interface_method (_tmp1038_);
								_tmp1040_ = _tmp1039_;
								if (_tmp1040_ != NULL) {
									ValaMethod* _tmp1041_;
									ValaMethod* _tmp1042_;
									ValaMethod* _tmp1043_;
									ValaMethod* _tmp1044_;
									ValaSignal* _tmp1045_;
									ValaSignal* _tmp1046_;
									ValaSymbol* _tmp1051_;
									ValaSymbol* _tmp1052_;
									_tmp1041_ = m;
									_tmp1042_ = vala_method_get_base_interface_method (_tmp1041_);
									_tmp1043_ = _tmp1042_;
									m = _tmp1043_;
									_tmp1044_ = m;
									_tmp1045_ = vala_method_get_signal_reference (_tmp1044_);
									_tmp1046_ = _tmp1045_;
									if (_tmp1046_ != NULL) {
										ValaMethod* _tmp1047_;
										ValaSignal* _tmp1048_;
										ValaSignal* _tmp1049_;
										_tmp1047_ = m;
										_tmp1048_ = vala_method_get_signal_reference (_tmp1047_);
										_tmp1049_ = _tmp1048_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1049_);
									} else {
										ValaMethod* _tmp1050_;
										_tmp1050_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1050_);
									}
									_tmp1051_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1052_ = _tmp1051_;
									member = _tmp1052_;
								}
							}
						}
						_tmp1053_ = m;
						_tmp1054_ = vala_symbol_get_access ((ValaSymbol*) _tmp1053_);
						_tmp1055_ = _tmp1054_;
						access = _tmp1055_;
						_tmp1056_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1056_)) {
							ValaMethod* _tmp1057_;
							ValaMemberBinding _tmp1058_;
							ValaMemberBinding _tmp1059_;
							_tmp1057_ = m;
							_tmp1058_ = vala_method_get_binding (_tmp1057_);
							_tmp1059_ = _tmp1058_;
							instance = _tmp1059_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1060_ = m;
						_tmp1061_ = vala_method_get_binding (_tmp1060_);
						_tmp1062_ = _tmp1061_;
						klass = _tmp1062_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1063_;
							ValaList* _tmp1064_;
							gint _param_size = 0;
							ValaList* _tmp1065_;
							gint _tmp1066_;
							gint _tmp1067_;
							gint _param_index = 0;
							_tmp1063_ = m;
							_tmp1064_ = vala_callable_get_parameters ((ValaCallable*) _tmp1063_);
							_param_list = _tmp1064_;
							_tmp1065_ = _param_list;
							_tmp1066_ = vala_collection_get_size ((ValaCollection*) _tmp1065_);
							_tmp1067_ = _tmp1066_;
							_param_size = _tmp1067_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1068_;
								gint _tmp1069_;
								ValaParameter* param = NULL;
								ValaList* _tmp1070_;
								gpointer _tmp1071_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1072_;
								ValaDataType* _tmp1073_;
								ValaDataType* _tmp1074_;
								gboolean _tmp1075_ = FALSE;
								ValaGenericType* _tmp1076_;
								_param_index = _param_index + 1;
								_tmp1068_ = _param_index;
								_tmp1069_ = _param_size;
								if (!(_tmp1068_ < _tmp1069_)) {
									break;
								}
								_tmp1070_ = _param_list;
								_tmp1071_ = vala_list_get (_tmp1070_, _param_index);
								param = (ValaParameter*) _tmp1071_;
								_tmp1072_ = param;
								_tmp1073_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1072_);
								_tmp1074_ = _tmp1073_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1074_) ? ((ValaGenericType*) _tmp1074_) : NULL;
								_tmp1076_ = generic_type;
								if (_tmp1076_ != NULL) {
									ValaGenericType* _tmp1077_;
									ValaTypeParameter* _tmp1078_;
									ValaTypeParameter* _tmp1079_;
									ValaSymbol* _tmp1080_;
									ValaSymbol* _tmp1081_;
									_tmp1077_ = generic_type;
									_tmp1078_ = vala_generic_type_get_type_parameter (_tmp1077_);
									_tmp1079_ = _tmp1078_;
									_tmp1080_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1079_);
									_tmp1081_ = _tmp1080_;
									_tmp1075_ = VALA_IS_TYPESYMBOL (_tmp1081_);
								} else {
									_tmp1075_ = FALSE;
								}
								if (_tmp1075_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1082_ = m;
						_tmp1083_ = vala_callable_get_return_type ((ValaCallable*) _tmp1082_);
						_tmp1084_ = _tmp1083_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1084_) ? ((ValaGenericType*) _tmp1084_) : NULL;
						_tmp1086_ = generic_type;
						if (_tmp1086_ != NULL) {
							ValaGenericType* _tmp1087_;
							ValaTypeParameter* _tmp1088_;
							ValaTypeParameter* _tmp1089_;
							ValaSymbol* _tmp1090_;
							ValaSymbol* _tmp1091_;
							_tmp1087_ = generic_type;
							_tmp1088_ = vala_generic_type_get_type_parameter (_tmp1087_);
							_tmp1089_ = _tmp1088_;
							_tmp1090_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1089_);
							_tmp1091_ = _tmp1090_;
							_tmp1085_ = VALA_IS_TYPESYMBOL (_tmp1091_);
						} else {
							_tmp1085_ = FALSE;
						}
						if (_tmp1085_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1092_;
						_tmp1092_ = member;
						if (VALA_IS_PROPERTY (_tmp1092_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1093_;
							ValaProperty* _tmp1094_;
							ValaProperty* _tmp1095_;
							ValaProperty* _tmp1096_;
							ValaProperty* _tmp1097_;
							ValaProperty* _tmp1113_;
							ValaSymbolAccessibility _tmp1114_;
							ValaSymbolAccessibility _tmp1115_;
							gboolean _tmp1116_;
							gboolean _tmp1117_;
							ValaProperty* _tmp1216_;
							ValaMemberBinding _tmp1217_;
							ValaMemberBinding _tmp1218_;
							ValaProperty* _tmp1219_;
							ValaDataType* _tmp1220_;
							ValaDataType* _tmp1221_;
							_tmp1093_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1093_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1094_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1094_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1095_ = prop;
							_tmp1096_ = vala_property_get_base_property (_tmp1095_);
							_tmp1097_ = _tmp1096_;
							if (_tmp1097_ != NULL) {
								ValaProperty* _tmp1098_;
								ValaProperty* _tmp1099_;
								ValaProperty* _tmp1100_;
								ValaProperty* _tmp1101_;
								ValaSymbol* _tmp1102_;
								ValaSymbol* _tmp1103_;
								_tmp1098_ = prop;
								_tmp1099_ = vala_property_get_base_property (_tmp1098_);
								_tmp1100_ = _tmp1099_;
								prop = _tmp1100_;
								_tmp1101_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1101_);
								_tmp1102_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1103_ = _tmp1102_;
								member = _tmp1103_;
							} else {
								ValaProperty* _tmp1104_;
								ValaProperty* _tmp1105_;
								ValaProperty* _tmp1106_;
								_tmp1104_ = prop;
								_tmp1105_ = vala_property_get_base_interface_property (_tmp1104_);
								_tmp1106_ = _tmp1105_;
								if (_tmp1106_ != NULL) {
									ValaProperty* _tmp1107_;
									ValaProperty* _tmp1108_;
									ValaProperty* _tmp1109_;
									ValaProperty* _tmp1110_;
									ValaSymbol* _tmp1111_;
									ValaSymbol* _tmp1112_;
									_tmp1107_ = prop;
									_tmp1108_ = vala_property_get_base_interface_property (_tmp1107_);
									_tmp1109_ = _tmp1108_;
									prop = _tmp1109_;
									_tmp1110_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1110_);
									_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1112_ = _tmp1111_;
									member = _tmp1112_;
								}
							}
							_tmp1113_ = prop;
							_tmp1114_ = vala_symbol_get_access ((ValaSymbol*) _tmp1113_);
							_tmp1115_ = _tmp1114_;
							access = _tmp1115_;
							_tmp1116_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1117_ = _tmp1116_;
							if (_tmp1117_) {
								ValaProperty* _tmp1118_;
								ValaPropertyAccessor* _tmp1119_;
								ValaPropertyAccessor* _tmp1120_;
								ValaProperty* _tmp1164_;
								ValaSymbolAccessibility _tmp1165_;
								ValaSymbolAccessibility _tmp1166_;
								_tmp1118_ = prop;
								_tmp1119_ = vala_property_get_set_accessor (_tmp1118_);
								_tmp1120_ = _tmp1119_;
								if (_tmp1120_ == NULL) {
									ValaSourceReference* _tmp1121_;
									ValaSourceReference* _tmp1122_;
									ValaProperty* _tmp1123_;
									gchar* _tmp1124_;
									gchar* _tmp1125_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1122_ = _tmp1121_;
									_tmp1123_ = prop;
									_tmp1124_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1123_);
									_tmp1125_ = _tmp1124_;
									vala_report_error (_tmp1122_, "Property `%s' is read-only", _tmp1125_);
									_g_free0 (_tmp1125_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1126_ = FALSE;
									ValaProperty* _tmp1127_;
									ValaPropertyAccessor* _tmp1128_;
									ValaPropertyAccessor* _tmp1129_;
									gboolean _tmp1130_;
									gboolean _tmp1131_;
									_tmp1127_ = prop;
									_tmp1128_ = vala_property_get_set_accessor (_tmp1127_);
									_tmp1129_ = _tmp1128_;
									_tmp1130_ = vala_property_accessor_get_writable (_tmp1129_);
									_tmp1131_ = _tmp1130_;
									if (!_tmp1131_) {
										ValaProperty* _tmp1132_;
										ValaPropertyAccessor* _tmp1133_;
										ValaPropertyAccessor* _tmp1134_;
										gboolean _tmp1135_;
										gboolean _tmp1136_;
										_tmp1132_ = prop;
										_tmp1133_ = vala_property_get_set_accessor (_tmp1132_);
										_tmp1134_ = _tmp1133_;
										_tmp1135_ = vala_property_accessor_get_construction (_tmp1134_);
										_tmp1136_ = _tmp1135_;
										_tmp1126_ = _tmp1136_;
									} else {
										_tmp1126_ = FALSE;
									}
									if (_tmp1126_) {
										ValaSemanticAnalyzer* _tmp1137_;
										ValaSemanticAnalyzer* _tmp1138_;
										ValaMethod* _tmp1139_;
										_tmp1137_ = vala_code_context_get_analyzer (context);
										_tmp1138_ = _tmp1137_;
										_tmp1139_ = vala_semantic_analyzer_find_current_method (_tmp1138_);
										if (VALA_IS_CREATION_METHOD (_tmp1139_)) {
											ValaSourceReference* _tmp1140_;
											ValaSourceReference* _tmp1141_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1141_ = _tmp1140_;
											vala_report_error (_tmp1141_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1142_;
											ValaSemanticAnalyzer* _tmp1143_;
											_tmp1142_ = vala_code_context_get_analyzer (context);
											_tmp1143_ = _tmp1142_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1143_)) {
												ValaSemanticAnalyzer* _tmp1144_;
												ValaSemanticAnalyzer* _tmp1145_;
												ValaTypeSymbol* _tmp1146_;
												ValaTypeSymbol* _tmp1147_;
												ValaProperty* _tmp1148_;
												ValaSymbol* _tmp1149_;
												ValaSymbol* _tmp1150_;
												_tmp1144_ = vala_code_context_get_analyzer (context);
												_tmp1145_ = _tmp1144_;
												_tmp1146_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1145_);
												_tmp1147_ = _tmp1146_;
												_tmp1148_ = prop;
												_tmp1149_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1148_);
												_tmp1150_ = _tmp1149_;
												if (!vala_typesymbol_is_subtype_of (_tmp1147_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1150_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1151_;
													ValaSourceReference* _tmp1152_;
													ValaProperty* _tmp1153_;
													gchar* _tmp1154_;
													gchar* _tmp1155_;
													ValaSemanticAnalyzer* _tmp1156_;
													ValaSemanticAnalyzer* _tmp1157_;
													ValaTypeSymbol* _tmp1158_;
													ValaTypeSymbol* _tmp1159_;
													gchar* _tmp1160_;
													gchar* _tmp1161_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1152_ = _tmp1151_;
													_tmp1153_ = prop;
													_tmp1154_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1153_);
													_tmp1155_ = _tmp1154_;
													_tmp1156_ = vala_code_context_get_analyzer (context);
													_tmp1157_ = _tmp1156_;
													_tmp1158_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1157_);
													_tmp1159_ = _tmp1158_;
													_tmp1160_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1159_);
													_tmp1161_ = _tmp1160_;
													vala_report_error (_tmp1152_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1155_, _tmp1161_);
													_g_free0 (_tmp1161_);
													_g_free0 (_tmp1155_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1162_;
												ValaSourceReference* _tmp1163_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1163_ = _tmp1162_;
												vala_report_error (_tmp1163_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1164_ = prop;
								_tmp1165_ = vala_symbol_get_access ((ValaSymbol*) _tmp1164_);
								_tmp1166_ = _tmp1165_;
								if (_tmp1166_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1167_;
									ValaPropertyAccessor* _tmp1168_;
									ValaPropertyAccessor* _tmp1169_;
									ValaSymbolAccessibility _tmp1170_;
									ValaSymbolAccessibility _tmp1171_;
									_tmp1167_ = prop;
									_tmp1168_ = vala_property_get_set_accessor (_tmp1167_);
									_tmp1169_ = _tmp1168_;
									_tmp1170_ = vala_symbol_get_access ((ValaSymbol*) _tmp1169_);
									_tmp1171_ = _tmp1170_;
									access = _tmp1171_;
								} else {
									gboolean _tmp1172_ = FALSE;
									ValaProperty* _tmp1173_;
									ValaSymbolAccessibility _tmp1174_;
									ValaSymbolAccessibility _tmp1175_;
									_tmp1173_ = prop;
									_tmp1174_ = vala_symbol_get_access ((ValaSymbol*) _tmp1173_);
									_tmp1175_ = _tmp1174_;
									if (_tmp1175_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1176_;
										ValaPropertyAccessor* _tmp1177_;
										ValaPropertyAccessor* _tmp1178_;
										ValaSymbolAccessibility _tmp1179_;
										ValaSymbolAccessibility _tmp1180_;
										_tmp1176_ = prop;
										_tmp1177_ = vala_property_get_set_accessor (_tmp1176_);
										_tmp1178_ = _tmp1177_;
										_tmp1179_ = vala_symbol_get_access ((ValaSymbol*) _tmp1178_);
										_tmp1180_ = _tmp1179_;
										_tmp1172_ = _tmp1180_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1172_ = FALSE;
									}
									if (_tmp1172_) {
										ValaProperty* _tmp1181_;
										ValaPropertyAccessor* _tmp1182_;
										ValaPropertyAccessor* _tmp1183_;
										ValaSymbolAccessibility _tmp1184_;
										ValaSymbolAccessibility _tmp1185_;
										_tmp1181_ = prop;
										_tmp1182_ = vala_property_get_set_accessor (_tmp1181_);
										_tmp1183_ = _tmp1182_;
										_tmp1184_ = vala_symbol_get_access ((ValaSymbol*) _tmp1183_);
										_tmp1185_ = _tmp1184_;
										access = _tmp1185_;
									}
								}
							} else {
								ValaProperty* _tmp1186_;
								ValaPropertyAccessor* _tmp1187_;
								ValaPropertyAccessor* _tmp1188_;
								ValaProperty* _tmp1194_;
								ValaSymbolAccessibility _tmp1195_;
								ValaSymbolAccessibility _tmp1196_;
								_tmp1186_ = prop;
								_tmp1187_ = vala_property_get_get_accessor (_tmp1186_);
								_tmp1188_ = _tmp1187_;
								if (_tmp1188_ == NULL) {
									ValaSourceReference* _tmp1189_;
									ValaSourceReference* _tmp1190_;
									ValaProperty* _tmp1191_;
									gchar* _tmp1192_;
									gchar* _tmp1193_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1190_ = _tmp1189_;
									_tmp1191_ = prop;
									_tmp1192_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1191_);
									_tmp1193_ = _tmp1192_;
									vala_report_error (_tmp1190_, "Property `%s' is write-only", _tmp1193_);
									_g_free0 (_tmp1193_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1194_ = prop;
								_tmp1195_ = vala_symbol_get_access ((ValaSymbol*) _tmp1194_);
								_tmp1196_ = _tmp1195_;
								if (_tmp1196_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1197_;
									ValaPropertyAccessor* _tmp1198_;
									ValaPropertyAccessor* _tmp1199_;
									ValaSymbolAccessibility _tmp1200_;
									ValaSymbolAccessibility _tmp1201_;
									_tmp1197_ = prop;
									_tmp1198_ = vala_property_get_get_accessor (_tmp1197_);
									_tmp1199_ = _tmp1198_;
									_tmp1200_ = vala_symbol_get_access ((ValaSymbol*) _tmp1199_);
									_tmp1201_ = _tmp1200_;
									access = _tmp1201_;
								} else {
									gboolean _tmp1202_ = FALSE;
									ValaProperty* _tmp1203_;
									ValaSymbolAccessibility _tmp1204_;
									ValaSymbolAccessibility _tmp1205_;
									_tmp1203_ = prop;
									_tmp1204_ = vala_symbol_get_access ((ValaSymbol*) _tmp1203_);
									_tmp1205_ = _tmp1204_;
									if (_tmp1205_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1206_;
										ValaPropertyAccessor* _tmp1207_;
										ValaPropertyAccessor* _tmp1208_;
										ValaSymbolAccessibility _tmp1209_;
										ValaSymbolAccessibility _tmp1210_;
										_tmp1206_ = prop;
										_tmp1207_ = vala_property_get_get_accessor (_tmp1206_);
										_tmp1208_ = _tmp1207_;
										_tmp1209_ = vala_symbol_get_access ((ValaSymbol*) _tmp1208_);
										_tmp1210_ = _tmp1209_;
										_tmp1202_ = _tmp1210_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1202_ = FALSE;
									}
									if (_tmp1202_) {
										ValaProperty* _tmp1211_;
										ValaPropertyAccessor* _tmp1212_;
										ValaPropertyAccessor* _tmp1213_;
										ValaSymbolAccessibility _tmp1214_;
										ValaSymbolAccessibility _tmp1215_;
										_tmp1211_ = prop;
										_tmp1212_ = vala_property_get_get_accessor (_tmp1211_);
										_tmp1213_ = _tmp1212_;
										_tmp1214_ = vala_symbol_get_access ((ValaSymbol*) _tmp1213_);
										_tmp1215_ = _tmp1214_;
										access = _tmp1215_;
									}
								}
							}
							_tmp1216_ = prop;
							_tmp1217_ = vala_property_get_binding (_tmp1216_);
							_tmp1218_ = _tmp1217_;
							instance = _tmp1218_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1219_ = prop;
							_tmp1220_ = vala_property_get_property_type (_tmp1219_);
							_tmp1221_ = _tmp1220_;
							if (VALA_IS_GENERIC_TYPE (_tmp1221_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1222_;
							_tmp1222_ = member;
							if (VALA_IS_SIGNAL (_tmp1222_)) {
								ValaSymbol* _tmp1223_;
								ValaSymbolAccessibility _tmp1224_;
								ValaSymbolAccessibility _tmp1225_;
								instance = TRUE;
								_tmp1223_ = member;
								_tmp1224_ = vala_symbol_get_access (_tmp1223_);
								_tmp1225_ = _tmp1224_;
								access = _tmp1225_;
							} else {
								gboolean _tmp1226_ = FALSE;
								gboolean _tmp1227_;
								_tmp1227_ = self->priv->_creation_member;
								if (!_tmp1227_) {
									ValaSymbol* _tmp1228_;
									_tmp1228_ = member;
									_tmp1226_ = VALA_IS_ERROR_CODE (_tmp1228_);
								} else {
									_tmp1226_ = FALSE;
								}
								if (_tmp1226_) {
									ValaSymbol* _tmp1229_;
									ValaConstant* _tmp1230_;
									ValaConstant* _tmp1231_;
									ValaSymbol* _tmp1232_;
									ValaSymbol* _tmp1233_;
									_tmp1229_ = member;
									_tmp1230_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1229_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1231_ = _tmp1230_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1231_);
									_tmp1232_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1233_ = _tmp1232_;
									member = _tmp1233_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1234_;
		ValaSymbol* _tmp1235_;
		ValaCodeNode* _tmp1236_;
		ValaCodeNode* _tmp1237_;
		ValaCodeNode* _tmp1238_;
		gboolean _tmp1239_ = FALSE;
		ValaCodeNode* _tmp1240_;
		_tmp1234_ = parent;
		_tmp1235_ = member;
		if (!(_tmp1234_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1235_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1236_ = parent;
		_tmp1237_ = vala_code_node_get_parent_node (_tmp1236_);
		_tmp1238_ = _tmp1237_;
		parent = _tmp1238_;
		_tmp1240_ = parent;
		if (_tmp1240_ == NULL) {
			_tmp1239_ = TRUE;
		} else {
			ValaCodeNode* _tmp1241_;
			ValaSymbol* _tmp1242_;
			_tmp1241_ = parent;
			_tmp1242_ = member;
			_tmp1239_ = _tmp1241_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1242_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1239_) {
			break;
		}
	}
	_tmp1243_ = parent;
	_tmp1244_ = member;
	if (_tmp1243_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1244_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1245_;
		_tmp1245_ = member;
		vala_symbol_set_used (_tmp1245_, TRUE);
	}
	_tmp1246_ = member;
	_tmp1247_ = vala_symbol_get_version (_tmp1246_);
	_tmp1248_ = _tmp1247_;
	_tmp1249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1250_ = _tmp1249_;
	vala_version_attribute_check (_tmp1248_, context, _tmp1250_);
	_tmp1252_ = access;
	if (_tmp1252_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1253_;
		ValaSymbol* _tmp1254_;
		ValaSymbol* _tmp1255_;
		_tmp1253_ = member;
		_tmp1254_ = vala_symbol_get_parent_symbol (_tmp1253_);
		_tmp1255_ = _tmp1254_;
		_tmp1251_ = VALA_IS_TYPESYMBOL (_tmp1255_);
	} else {
		_tmp1251_ = FALSE;
	}
	if (_tmp1251_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1256_;
		ValaSymbol* _tmp1257_;
		ValaSymbol* _tmp1258_;
		gboolean in_subtype = FALSE;
		_tmp1256_ = member;
		_tmp1257_ = vala_symbol_get_parent_symbol (_tmp1256_);
		_tmp1258_ = _tmp1257_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1258_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1259_;
			ValaSemanticAnalyzer* _tmp1260_;
			ValaSymbol* _tmp1261_;
			ValaSymbol* _tmp1262_;
			ValaSymbol* _tmp1263_;
			_tmp1259_ = vala_code_context_get_analyzer (context);
			_tmp1260_ = _tmp1259_;
			_tmp1261_ = vala_semantic_analyzer_get_current_symbol (_tmp1260_);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = _vala_code_node_ref0 (_tmp1262_);
			this_symbol = _tmp1263_;
			{
				gboolean _tmp1264_ = FALSE;
				_tmp1264_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1269_;
					ValaSymbol* _tmp1270_;
					ValaTypeSymbol* _tmp1271_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1272_;
					gboolean _tmp1273_ = FALSE;
					ValaClass* _tmp1274_;
					if (!_tmp1264_) {
						ValaSymbol* _tmp1265_;
						ValaSymbol* _tmp1266_;
						ValaSymbol* _tmp1267_;
						ValaSymbol* _tmp1268_;
						_tmp1265_ = this_symbol;
						_tmp1266_ = vala_symbol_get_parent_symbol (_tmp1265_);
						_tmp1267_ = _tmp1266_;
						_tmp1268_ = _vala_code_node_ref0 (_tmp1267_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1268_;
					}
					_tmp1264_ = FALSE;
					_tmp1269_ = this_symbol;
					if (!(_tmp1269_ != NULL)) {
						break;
					}
					_tmp1270_ = this_symbol;
					_tmp1271_ = target_type;
					if (_tmp1270_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1271_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1272_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1272_) ? ((ValaClass*) _tmp1272_) : NULL;
					_tmp1274_ = cl;
					if (_tmp1274_ != NULL) {
						ValaClass* _tmp1275_;
						ValaTypeSymbol* _tmp1276_;
						_tmp1275_ = cl;
						_tmp1276_ = target_type;
						_tmp1273_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1275_, _tmp1276_);
					} else {
						_tmp1273_ = FALSE;
					}
					if (_tmp1273_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1277_;
			ValaSourceReference* _tmp1278_;
			ValaSymbol* _tmp1279_;
			gchar* _tmp1280_;
			gchar* _tmp1281_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1278_ = _tmp1277_;
			_tmp1279_ = member;
			_tmp1280_ = vala_symbol_get_full_name (_tmp1279_);
			_tmp1281_ = _tmp1280_;
			vala_report_error (_tmp1278_, "Access to protected member `%s' denied", _tmp1281_);
			_g_free0 (_tmp1281_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1282_;
		_tmp1282_ = access;
		if (_tmp1282_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1283_;
			ValaSymbol* _tmp1284_;
			ValaSymbol* _tmp1285_;
			gboolean in_target_type = FALSE;
			_tmp1283_ = member;
			_tmp1284_ = vala_symbol_get_parent_symbol (_tmp1283_);
			_tmp1285_ = _tmp1284_;
			target_type = _tmp1285_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1286_;
				ValaSemanticAnalyzer* _tmp1287_;
				ValaSymbol* _tmp1288_;
				ValaSymbol* _tmp1289_;
				ValaSymbol* _tmp1290_;
				_tmp1286_ = vala_code_context_get_analyzer (context);
				_tmp1287_ = _tmp1286_;
				_tmp1288_ = vala_semantic_analyzer_get_current_symbol (_tmp1287_);
				_tmp1289_ = _tmp1288_;
				_tmp1290_ = _vala_code_node_ref0 (_tmp1289_);
				this_symbol = _tmp1290_;
				{
					gboolean _tmp1291_ = FALSE;
					_tmp1291_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1296_;
						ValaSymbol* _tmp1297_;
						ValaSymbol* _tmp1298_;
						if (!_tmp1291_) {
							ValaSymbol* _tmp1292_;
							ValaSymbol* _tmp1293_;
							ValaSymbol* _tmp1294_;
							ValaSymbol* _tmp1295_;
							_tmp1292_ = this_symbol;
							_tmp1293_ = vala_symbol_get_parent_symbol (_tmp1292_);
							_tmp1294_ = _tmp1293_;
							_tmp1295_ = _vala_code_node_ref0 (_tmp1294_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1295_;
						}
						_tmp1291_ = FALSE;
						_tmp1296_ = this_symbol;
						if (!(_tmp1296_ != NULL)) {
							break;
						}
						_tmp1297_ = target_type;
						_tmp1298_ = this_symbol;
						if (_tmp1297_ == _tmp1298_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1299_;
				ValaSourceReference* _tmp1300_;
				ValaSymbol* _tmp1301_;
				gchar* _tmp1302_;
				gchar* _tmp1303_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = member;
				_tmp1302_ = vala_symbol_get_full_name (_tmp1301_);
				_tmp1303_ = _tmp1302_;
				vala_report_error (_tmp1300_, "Access to private member `%s' denied", _tmp1303_);
				_g_free0 (_tmp1303_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1305_;
		ValaExpression* _tmp1306_;
		_tmp1305_ = vala_member_access_get_inner (self);
		_tmp1306_ = _tmp1305_;
		_tmp1304_ = _tmp1306_ != NULL;
	} else {
		_tmp1304_ = FALSE;
	}
	if (_tmp1304_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1307_;
		ValaExpression* _tmp1308_;
		ValaDataType* _tmp1309_;
		ValaDataType* _tmp1310_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1311_;
		ValaExpression* _tmp1312_;
		ValaDataType* _tmp1313_;
		ValaDataType* _tmp1314_;
		ValaPointerType* _tmp1315_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1319_;
		gboolean _tmp1320_ = FALSE;
		gboolean _tmp1321_ = FALSE;
		ValaObjectType* _tmp1322_;
		_tmp1307_ = vala_member_access_get_inner (self);
		_tmp1308_ = _tmp1307_;
		_tmp1309_ = vala_expression_get_value_type (_tmp1308_);
		_tmp1310_ = _tmp1309_;
		instance_type = _tmp1310_;
		_tmp1311_ = vala_member_access_get_inner (self);
		_tmp1312_ = _tmp1311_;
		_tmp1313_ = vala_expression_get_value_type (_tmp1312_);
		_tmp1314_ = _tmp1313_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1314_) ? ((ValaPointerType*) _tmp1314_) : NULL;
		_tmp1315_ = pointer_type;
		if (_tmp1315_ != NULL) {
			ValaPointerType* _tmp1316_;
			ValaDataType* _tmp1317_;
			ValaDataType* _tmp1318_;
			_tmp1316_ = pointer_type;
			_tmp1317_ = vala_pointer_type_get_base_type (_tmp1316_);
			_tmp1318_ = _tmp1317_;
			instance_type = _tmp1318_;
		}
		_tmp1319_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1319_) ? ((ValaObjectType*) _tmp1319_) : NULL;
		_tmp1322_ = object_type;
		if (_tmp1322_ != NULL) {
			ValaObjectType* _tmp1323_;
			ValaObjectTypeSymbol* _tmp1324_;
			ValaObjectTypeSymbol* _tmp1325_;
			_tmp1323_ = object_type;
			_tmp1324_ = vala_object_type_get_object_type_symbol (_tmp1323_);
			_tmp1325_ = _tmp1324_;
			_tmp1321_ = vala_object_type_symbol_has_type_parameters (_tmp1325_);
		} else {
			_tmp1321_ = FALSE;
		}
		if (_tmp1321_) {
			ValaDataType* _tmp1326_;
			_tmp1326_ = instance_type;
			_tmp1320_ = !vala_data_type_has_type_arguments (_tmp1326_);
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaExpression* _tmp1327_;
			ValaExpression* _tmp1328_;
			ValaSourceReference* _tmp1329_;
			ValaSourceReference* _tmp1330_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1327_ = vala_member_access_get_inner (self);
			_tmp1328_ = _tmp1327_;
			_tmp1329_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1328_);
			_tmp1330_ = _tmp1329_;
			vala_report_error (_tmp1330_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1332_ = !may_access_instance_members;
	} else {
		_tmp1332_ = FALSE;
	}
	if (_tmp1332_) {
		_tmp1331_ = TRUE;
	} else {
		gboolean _tmp1333_ = FALSE;
		if (klass) {
			_tmp1333_ = !may_access_klass_members;
		} else {
			_tmp1333_ = FALSE;
		}
		_tmp1331_ = _tmp1333_;
	}
	if (_tmp1331_) {
		ValaSymbol* _tmp1334_;
		ValaSymbol* _tmp1335_;
		ValaDataType* _tmp1358_;
		ValaDataType* _tmp1359_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1334_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1335_ = _tmp1334_;
		if (VALA_IS_METHOD (_tmp1335_)) {
			ValaSemanticAnalyzer* _tmp1336_;
			ValaSemanticAnalyzer* _tmp1337_;
			ValaSymbol* _tmp1338_;
			ValaSymbol* _tmp1339_;
			gboolean _tmp1340_;
			gboolean _tmp1341_;
			ValaDataType* _tmp1342_;
			ValaDataType* _tmp1343_;
			_tmp1336_ = vala_code_context_get_analyzer (context);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1341_ = _tmp1340_;
			_tmp1342_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1337_, _tmp1339_, _tmp1341_);
			_tmp1343_ = _tmp1342_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1343_);
			_vala_code_node_unref0 (_tmp1343_);
		} else {
			ValaSymbol* _tmp1344_;
			ValaSymbol* _tmp1345_;
			_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1345_ = _tmp1344_;
			if (VALA_IS_FIELD (_tmp1345_)) {
				ValaSymbol* _tmp1346_;
				ValaSymbol* _tmp1347_;
				ValaFieldPrototype* _tmp1348_;
				ValaFieldPrototype* _tmp1349_;
				_tmp1346_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1347_ = _tmp1346_;
				_tmp1348_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1347_, VALA_TYPE_FIELD, ValaField));
				_tmp1349_ = _tmp1348_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1349_);
				_vala_code_node_unref0 (_tmp1349_);
			} else {
				ValaSymbol* _tmp1350_;
				ValaSymbol* _tmp1351_;
				_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1351_ = _tmp1350_;
				if (VALA_IS_PROPERTY (_tmp1351_)) {
					ValaSymbol* _tmp1352_;
					ValaSymbol* _tmp1353_;
					ValaPropertyPrototype* _tmp1354_;
					ValaPropertyPrototype* _tmp1355_;
					_tmp1352_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1353_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1355_ = _tmp1354_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1355_);
					_vala_code_node_unref0 (_tmp1355_);
				} else {
					ValaInvalidType* _tmp1356_;
					ValaInvalidType* _tmp1357_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1356_ = vala_invalid_type_new ();
					_tmp1357_ = _tmp1356_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1357_);
					_vala_code_node_unref0 (_tmp1357_);
				}
			}
		}
		_tmp1358_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1359_ = _tmp1358_;
		if (_tmp1359_ != NULL) {
			ValaDataType* _tmp1360_;
			ValaDataType* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			gboolean _tmp1364_;
			gboolean _tmp1365_;
			_tmp1360_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1363_ = _tmp1362_;
			_tmp1364_ = vala_data_type_get_value_owned (_tmp1363_);
			_tmp1365_ = _tmp1364_;
			vala_data_type_set_value_owned (_tmp1361_, _tmp1365_);
		}
	} else {
		gboolean _tmp1366_ = FALSE;
		gboolean _tmp1387_ = FALSE;
		gboolean _tmp1388_ = FALSE;
		gboolean _tmp1389_ = FALSE;
		gboolean _tmp1390_ = FALSE;
		gboolean _tmp1431_ = FALSE;
		gboolean _tmp1432_ = FALSE;
		gboolean _tmp1433_ = FALSE;
		gboolean _tmp1434_ = FALSE;
		gboolean _tmp1435_ = FALSE;
		gboolean _tmp1436_;
		gboolean _tmp1437_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1462_;
		ValaSymbol* _tmp1463_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1464_;
		ValaExpression* _tmp1465_;
		gboolean _tmp1466_ = FALSE;
		gboolean _tmp1467_ = FALSE;
		gboolean _tmp1468_ = FALSE;
		gboolean _tmp1469_ = FALSE;
		gboolean _tmp1470_ = FALSE;
		ValaMethod* _tmp1471_;
		ValaSemanticAnalyzer* _tmp1509_;
		ValaSemanticAnalyzer* _tmp1510_;
		ValaSymbol* _tmp1511_;
		ValaSymbol* _tmp1512_;
		gboolean _tmp1513_;
		gboolean _tmp1514_;
		ValaDataType* _tmp1515_;
		ValaDataType* _tmp1516_;
		gboolean _tmp1517_ = FALSE;
		ValaExpression* _tmp1518_;
		ValaExpression* _tmp1519_;
		ValaSymbol* _tmp1532_;
		ValaSymbol* _tmp1533_;
		gboolean _tmp1607_ = FALSE;
		gboolean _tmp1608_ = FALSE;
		ValaExpression* _tmp1609_;
		ValaExpression* _tmp1610_;
		if (instance) {
			ValaExpression* _tmp1367_;
			ValaExpression* _tmp1368_;
			_tmp1367_ = vala_member_access_get_inner (self);
			_tmp1368_ = _tmp1367_;
			_tmp1366_ = _tmp1368_ == NULL;
		} else {
			_tmp1366_ = FALSE;
		}
		if (_tmp1366_) {
			ValaSourceReference* _tmp1369_;
			ValaSourceReference* _tmp1370_;
			ValaMemberAccess* _tmp1371_;
			ValaMemberAccess* _tmp1372_;
			ValaExpression* _tmp1373_;
			ValaExpression* _tmp1374_;
			ValaParameter* _tmp1375_;
			ValaDataType* _tmp1376_;
			ValaDataType* _tmp1377_;
			ValaDataType* _tmp1378_;
			ValaDataType* _tmp1379_;
			ValaExpression* _tmp1380_;
			ValaExpression* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			ValaExpression* _tmp1384_;
			ValaExpression* _tmp1385_;
			ValaParameter* _tmp1386_;
			_tmp1369_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1370_ = _tmp1369_;
			_tmp1371_ = vala_member_access_new (NULL, "this", _tmp1370_);
			_tmp1372_ = _tmp1371_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1372_);
			_vala_code_node_unref0 (_tmp1372_);
			_tmp1373_ = vala_member_access_get_inner (self);
			_tmp1374_ = _tmp1373_;
			_tmp1375_ = this_parameter;
			_tmp1376_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1375_);
			_tmp1377_ = _tmp1376_;
			_tmp1378_ = vala_data_type_copy (_tmp1377_);
			_tmp1379_ = _tmp1378_;
			vala_expression_set_value_type (_tmp1374_, _tmp1379_);
			_vala_code_node_unref0 (_tmp1379_);
			_tmp1380_ = vala_member_access_get_inner (self);
			_tmp1381_ = _tmp1380_;
			_tmp1382_ = vala_expression_get_value_type (_tmp1381_);
			_tmp1383_ = _tmp1382_;
			vala_data_type_set_value_owned (_tmp1383_, FALSE);
			_tmp1384_ = vala_member_access_get_inner (self);
			_tmp1385_ = _tmp1384_;
			_tmp1386_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1385_, (ValaSymbol*) _tmp1386_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1390_ = !klass;
		} else {
			_tmp1390_ = FALSE;
		}
		if (_tmp1390_) {
			ValaSymbol* _tmp1391_;
			ValaSymbol* _tmp1392_;
			_tmp1391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1392_ = _tmp1391_;
			_tmp1389_ = !VALA_IS_CREATION_METHOD (_tmp1392_);
		} else {
			_tmp1389_ = FALSE;
		}
		if (_tmp1389_) {
			_tmp1388_ = may_access_instance_members;
		} else {
			_tmp1388_ = FALSE;
		}
		if (_tmp1388_) {
			ValaExpression* _tmp1393_;
			ValaExpression* _tmp1394_;
			_tmp1393_ = vala_member_access_get_inner (self);
			_tmp1394_ = _tmp1393_;
			_tmp1387_ = _tmp1394_ != NULL;
		} else {
			_tmp1387_ = FALSE;
		}
		if (_tmp1387_) {
			ValaExpression* _tmp1395_;
			ValaExpression* _tmp1396_;
			ValaSymbol* _tmp1397_;
			ValaSymbol* _tmp1398_;
			_tmp1395_ = vala_member_access_get_inner (self);
			_tmp1396_ = _tmp1395_;
			_tmp1397_ = vala_expression_get_symbol_reference (_tmp1396_);
			_tmp1398_ = _tmp1397_;
			if (VALA_IS_METHOD (_tmp1398_)) {
			} else {
				ValaSourceReference* _tmp1399_;
				ValaSourceReference* _tmp1400_;
				ValaSymbol* _tmp1401_;
				ValaSymbol* _tmp1402_;
				gchar* _tmp1403_;
				gchar* _tmp1404_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1405_;
				ValaSymbol* _tmp1406_;
				ValaSymbol* _tmp1407_;
				ValaSymbol* _tmp1408_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1428_;
				ValaExpression* _tmp1429_;
				ValaExpression* _tmp1430_;
				_tmp1399_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1400_ = _tmp1399_;
				_tmp1401_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1402_ = _tmp1401_;
				_tmp1403_ = vala_symbol_get_full_name (_tmp1402_);
				_tmp1404_ = _tmp1403_;
				vala_report_warning (_tmp1400_, "Access to static member `%s' with an instance reference", _tmp1404_);
				_g_free0 (_tmp1404_);
				_tmp1405_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1406_ = _tmp1405_;
				_tmp1407_ = vala_symbol_get_parent_symbol (_tmp1406_);
				_tmp1408_ = _tmp1407_;
				inner_sym = _tmp1408_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1409_ = FALSE;
					ValaSymbol* _tmp1410_;
					ValaMemberAccess* _tmp1414_;
					ValaSymbol* _tmp1415_;
					const gchar* _tmp1416_;
					const gchar* _tmp1417_;
					ValaSourceReference* _tmp1418_;
					ValaSourceReference* _tmp1419_;
					ValaMemberAccess* _tmp1420_;
					ValaMemberAccess* _tmp1421_;
					ValaMemberAccess* _tmp1422_;
					ValaExpression* _tmp1423_;
					ValaExpression* _tmp1424_;
					ValaSymbol* _tmp1425_;
					ValaSymbol* _tmp1426_;
					ValaSymbol* _tmp1427_;
					_tmp1410_ = inner_sym;
					if (_tmp1410_ != NULL) {
						ValaSymbol* _tmp1411_;
						const gchar* _tmp1412_;
						const gchar* _tmp1413_;
						_tmp1411_ = inner_sym;
						_tmp1412_ = vala_symbol_get_name (_tmp1411_);
						_tmp1413_ = _tmp1412_;
						_tmp1409_ = _tmp1413_ != NULL;
					} else {
						_tmp1409_ = FALSE;
					}
					if (!_tmp1409_) {
						break;
					}
					_tmp1414_ = inner_ma;
					_tmp1415_ = inner_sym;
					_tmp1416_ = vala_symbol_get_name (_tmp1415_);
					_tmp1417_ = _tmp1416_;
					_tmp1418_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1419_ = _tmp1418_;
					_tmp1420_ = vala_member_access_new (NULL, _tmp1417_, _tmp1419_);
					_tmp1421_ = _tmp1420_;
					vala_member_access_set_inner (_tmp1414_, (ValaExpression*) _tmp1421_);
					_vala_code_node_unref0 (_tmp1421_);
					_tmp1422_ = inner_ma;
					_tmp1423_ = vala_member_access_get_inner (_tmp1422_);
					_tmp1424_ = _tmp1423_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1424_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1425_ = inner_sym;
					_tmp1426_ = vala_symbol_get_parent_symbol (_tmp1425_);
					_tmp1427_ = _tmp1426_;
					inner_sym = _tmp1427_;
				}
				_tmp1428_ = inner_ma;
				vala_member_access_set_qualified (_tmp1428_, TRUE);
				_tmp1429_ = vala_member_access_get_inner (self);
				_tmp1430_ = _tmp1429_;
				vala_code_node_check ((ValaCodeNode*) _tmp1430_, context);
			}
		}
		_tmp1436_ = vala_code_context_get_experimental_non_null (context);
		_tmp1437_ = _tmp1436_;
		if (_tmp1437_) {
			_tmp1435_ = instance;
		} else {
			_tmp1435_ = FALSE;
		}
		if (_tmp1435_) {
			ValaExpression* _tmp1438_;
			ValaExpression* _tmp1439_;
			ValaDataType* _tmp1440_;
			ValaDataType* _tmp1441_;
			gboolean _tmp1442_;
			gboolean _tmp1443_;
			_tmp1438_ = vala_member_access_get_inner (self);
			_tmp1439_ = _tmp1438_;
			_tmp1440_ = vala_expression_get_value_type (_tmp1439_);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = vala_data_type_get_nullable (_tmp1441_);
			_tmp1443_ = _tmp1442_;
			_tmp1434_ = _tmp1443_;
		} else {
			_tmp1434_ = FALSE;
		}
		if (_tmp1434_) {
			ValaExpression* _tmp1444_;
			ValaExpression* _tmp1445_;
			ValaDataType* _tmp1446_;
			ValaDataType* _tmp1447_;
			_tmp1444_ = vala_member_access_get_inner (self);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = vala_expression_get_value_type (_tmp1445_);
			_tmp1447_ = _tmp1446_;
			_tmp1433_ = !VALA_IS_POINTER_TYPE (_tmp1447_);
		} else {
			_tmp1433_ = FALSE;
		}
		if (_tmp1433_) {
			ValaExpression* _tmp1448_;
			ValaExpression* _tmp1449_;
			ValaDataType* _tmp1450_;
			ValaDataType* _tmp1451_;
			_tmp1448_ = vala_member_access_get_inner (self);
			_tmp1449_ = _tmp1448_;
			_tmp1450_ = vala_expression_get_value_type (_tmp1449_);
			_tmp1451_ = _tmp1450_;
			_tmp1432_ = !VALA_IS_GENERIC_TYPE (_tmp1451_);
		} else {
			_tmp1432_ = FALSE;
		}
		if (_tmp1432_) {
			ValaExpression* _tmp1452_;
			ValaExpression* _tmp1453_;
			ValaDataType* _tmp1454_;
			ValaDataType* _tmp1455_;
			_tmp1452_ = vala_member_access_get_inner (self);
			_tmp1453_ = _tmp1452_;
			_tmp1454_ = vala_expression_get_value_type (_tmp1453_);
			_tmp1455_ = _tmp1454_;
			_tmp1431_ = !VALA_IS_ARRAY_TYPE (_tmp1455_);
		} else {
			_tmp1431_ = FALSE;
		}
		if (_tmp1431_) {
			ValaSourceReference* _tmp1456_;
			ValaSourceReference* _tmp1457_;
			ValaSymbol* _tmp1458_;
			ValaSymbol* _tmp1459_;
			gchar* _tmp1460_;
			gchar* _tmp1461_;
			_tmp1456_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1457_ = _tmp1456_;
			_tmp1458_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1459_ = _tmp1458_;
			_tmp1460_ = vala_symbol_get_full_name (_tmp1459_);
			_tmp1461_ = _tmp1460_;
			vala_report_error (_tmp1457_, "Access to instance member `%s' from nullable reference denied", _tmp1461_);
			_g_free0 (_tmp1461_);
		}
		_tmp1462_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1463_ = _tmp1462_;
		m = VALA_IS_METHOD (_tmp1463_) ? ((ValaMethod*) _tmp1463_) : NULL;
		_tmp1464_ = vala_member_access_get_inner (self);
		_tmp1465_ = _tmp1464_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1465_) ? ((ValaMemberAccess*) _tmp1465_) : NULL;
		_tmp1471_ = m;
		if (_tmp1471_ != NULL) {
			ValaMethod* _tmp1472_;
			ValaMemberBinding _tmp1473_;
			ValaMemberBinding _tmp1474_;
			_tmp1472_ = m;
			_tmp1473_ = vala_method_get_binding (_tmp1472_);
			_tmp1474_ = _tmp1473_;
			_tmp1470_ = _tmp1474_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1470_ = FALSE;
		}
		if (_tmp1470_) {
			ValaMethod* _tmp1475_;
			ValaSymbol* _tmp1476_;
			ValaSymbol* _tmp1477_;
			_tmp1475_ = m;
			_tmp1476_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1475_);
			_tmp1477_ = _tmp1476_;
			_tmp1469_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1477_);
		} else {
			_tmp1469_ = FALSE;
		}
		if (_tmp1469_) {
			ValaExpression* _tmp1478_;
			ValaExpression* _tmp1479_;
			_tmp1478_ = vala_member_access_get_inner (self);
			_tmp1479_ = _tmp1478_;
			_tmp1468_ = _tmp1479_ != NULL;
		} else {
			_tmp1468_ = FALSE;
		}
		if (_tmp1468_) {
			ValaExpression* _tmp1480_;
			ValaExpression* _tmp1481_;
			ValaDataType* _tmp1482_;
			ValaDataType* _tmp1483_;
			_tmp1480_ = vala_member_access_get_inner (self);
			_tmp1481_ = _tmp1480_;
			_tmp1482_ = vala_expression_get_value_type (_tmp1481_);
			_tmp1483_ = _tmp1482_;
			_tmp1467_ = _tmp1483_ == NULL;
		} else {
			_tmp1467_ = FALSE;
		}
		if (_tmp1467_) {
			ValaMemberAccess* _tmp1484_;
			ValaList* _tmp1485_;
			gint _tmp1486_;
			gint _tmp1487_;
			_tmp1484_ = inner_ma;
			_tmp1485_ = _tmp1484_->priv->type_argument_list;
			_tmp1486_ = vala_collection_get_size ((ValaCollection*) _tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1466_ = _tmp1487_ > 0;
		} else {
			_tmp1466_ = FALSE;
		}
		if (_tmp1466_) {
			ValaExpression* _tmp1488_;
			ValaExpression* _tmp1489_;
			ValaMethod* _tmp1490_;
			ValaSymbol* _tmp1491_;
			ValaSymbol* _tmp1492_;
			ValaObjectType* _tmp1493_;
			ValaObjectType* _tmp1494_;
			_tmp1488_ = vala_member_access_get_inner (self);
			_tmp1489_ = _tmp1488_;
			_tmp1490_ = m;
			_tmp1491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1490_);
			_tmp1492_ = _tmp1491_;
			_tmp1493_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1492_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1494_ = _tmp1493_;
			vala_expression_set_value_type (_tmp1489_, (ValaDataType*) _tmp1494_);
			_vala_code_node_unref0 (_tmp1494_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1495_;
				ValaList* _tmp1496_;
				gint _type_argument_size = 0;
				ValaList* _tmp1497_;
				gint _tmp1498_;
				gint _tmp1499_;
				gint _type_argument_index = 0;
				_tmp1495_ = inner_ma;
				_tmp1496_ = _tmp1495_->priv->type_argument_list;
				_type_argument_list = _tmp1496_;
				_tmp1497_ = _type_argument_list;
				_tmp1498_ = vala_collection_get_size ((ValaCollection*) _tmp1497_);
				_tmp1499_ = _tmp1498_;
				_type_argument_size = _tmp1499_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1500_;
					gint _tmp1501_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1502_;
					gpointer _tmp1503_;
					ValaExpression* _tmp1504_;
					ValaExpression* _tmp1505_;
					ValaDataType* _tmp1506_;
					ValaDataType* _tmp1507_;
					ValaDataType* _tmp1508_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1500_ = _type_argument_index;
					_tmp1501_ = _type_argument_size;
					if (!(_tmp1500_ < _tmp1501_)) {
						break;
					}
					_tmp1502_ = _type_argument_list;
					_tmp1503_ = vala_list_get (_tmp1502_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1503_;
					_tmp1504_ = vala_member_access_get_inner (self);
					_tmp1505_ = _tmp1504_;
					_tmp1506_ = vala_expression_get_value_type (_tmp1505_);
					_tmp1507_ = _tmp1506_;
					_tmp1508_ = type_argument;
					vala_data_type_add_type_argument (_tmp1507_, _tmp1508_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1509_ = vala_code_context_get_analyzer (context);
		_tmp1510_ = _tmp1509_;
		_tmp1511_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1512_ = _tmp1511_;
		_tmp1513_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1514_ = _tmp1513_;
		_tmp1515_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1510_, _tmp1512_, _tmp1514_);
		_tmp1516_ = _tmp1515_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1516_);
		_vala_code_node_unref0 (_tmp1516_);
		_tmp1518_ = vala_member_access_get_inner (self);
		_tmp1519_ = _tmp1518_;
		if (_tmp1519_ != NULL) {
			ValaDataType* _tmp1520_;
			ValaDataType* _tmp1521_;
			_tmp1520_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1521_ = _tmp1520_;
			_tmp1517_ = _tmp1521_ != NULL;
		} else {
			_tmp1517_ = FALSE;
		}
		if (_tmp1517_) {
			ValaDataType* _tmp1522_;
			ValaDataType* _tmp1523_;
			ValaExpression* _tmp1524_;
			ValaExpression* _tmp1525_;
			ValaDataType* _tmp1526_;
			ValaDataType* _tmp1527_;
			ValaDataType* _tmp1528_;
			ValaDataType* _tmp1529_;
			_tmp1522_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1523_ = _tmp1522_;
			_tmp1524_ = vala_member_access_get_inner (self);
			_tmp1525_ = _tmp1524_;
			_tmp1526_ = vala_expression_get_value_type (_tmp1525_);
			_tmp1527_ = _tmp1526_;
			_tmp1528_ = vala_data_type_get_actual_type (_tmp1523_, _tmp1527_, NULL, (ValaCodeNode*) self);
			_tmp1529_ = _tmp1528_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1529_);
			_vala_code_node_unref0 (_tmp1529_);
		} else {
			ValaDataType* _tmp1530_;
			ValaDataType* _tmp1531_;
			_tmp1530_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1531_ = _tmp1530_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1531_);
		}
		_tmp1532_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1533_ = _tmp1532_;
		if (VALA_IS_METHOD (_tmp1533_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1534_;
			ValaSymbol* _tmp1535_;
			ValaDataType* _tmp1536_;
			ValaDataType* _tmp1537_;
			gboolean _tmp1544_ = FALSE;
			_tmp1534_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1535_ = _tmp1534_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1535_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1536_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1537_ = _tmp1536_;
			if (_tmp1537_ != NULL) {
				ValaDataType* _tmp1538_;
				ValaDataType* _tmp1539_;
				ValaDataType* _tmp1540_;
				ValaDataType* _tmp1541_;
				gboolean _tmp1542_;
				gboolean _tmp1543_;
				_tmp1538_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1539_ = _tmp1538_;
				_tmp1540_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1541_ = _tmp1540_;
				_tmp1542_ = vala_data_type_get_value_owned (_tmp1541_);
				_tmp1543_ = _tmp1542_;
				vala_data_type_set_value_owned (_tmp1539_, _tmp1543_);
			}
			if (instance) {
				ValaMethod* _tmp1545_;
				ValaSymbol* _tmp1546_;
				ValaSymbol* _tmp1547_;
				_tmp1545_ = method;
				_tmp1546_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1545_);
				_tmp1547_ = _tmp1546_;
				_tmp1544_ = VALA_IS_TYPESYMBOL (_tmp1547_);
			} else {
				_tmp1544_ = FALSE;
			}
			if (_tmp1544_) {
				ValaExpression* _tmp1548_;
				ValaExpression* _tmp1549_;
				ValaMethod* _tmp1550_;
				ValaSymbol* _tmp1551_;
				ValaSymbol* _tmp1552_;
				ValaDataType* _tmp1553_;
				ValaDataType* _tmp1554_;
				ValaExpression* _tmp1555_;
				ValaExpression* _tmp1556_;
				ValaDataType* _tmp1557_;
				ValaDataType* _tmp1558_;
				ValaMethod* _tmp1559_;
				ValaParameter* _tmp1560_;
				ValaParameter* _tmp1561_;
				ValaDataType* _tmp1562_;
				ValaDataType* _tmp1563_;
				gboolean _tmp1564_;
				gboolean _tmp1565_;
				_tmp1548_ = vala_member_access_get_inner (self);
				_tmp1549_ = _tmp1548_;
				_tmp1550_ = method;
				_tmp1551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1550_);
				_tmp1552_ = _tmp1551_;
				_tmp1553_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1552_);
				_tmp1554_ = _tmp1553_;
				vala_expression_set_target_type (_tmp1549_, _tmp1554_);
				_vala_code_node_unref0 (_tmp1554_);
				_tmp1555_ = vala_member_access_get_inner (self);
				_tmp1556_ = _tmp1555_;
				_tmp1557_ = vala_expression_get_target_type (_tmp1556_);
				_tmp1558_ = _tmp1557_;
				_tmp1559_ = method;
				_tmp1560_ = vala_method_get_this_parameter (_tmp1559_);
				_tmp1561_ = _tmp1560_;
				_tmp1562_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1561_);
				_tmp1563_ = _tmp1562_;
				_tmp1564_ = vala_data_type_get_value_owned (_tmp1563_);
				_tmp1565_ = _tmp1564_;
				vala_data_type_set_value_owned (_tmp1558_, _tmp1565_);
			}
		} else {
			gboolean _tmp1566_ = FALSE;
			gboolean _tmp1567_ = FALSE;
			ValaSymbol* _tmp1568_;
			ValaSymbol* _tmp1569_;
			_tmp1568_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1569_ = _tmp1568_;
			if (VALA_IS_PROPERTY (_tmp1569_)) {
				_tmp1567_ = instance;
			} else {
				_tmp1567_ = FALSE;
			}
			if (_tmp1567_) {
				ValaSymbol* _tmp1570_;
				ValaSymbol* _tmp1571_;
				ValaSymbol* _tmp1572_;
				ValaSymbol* _tmp1573_;
				_tmp1570_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1571_ = _tmp1570_;
				_tmp1572_ = vala_symbol_get_parent_symbol (_tmp1571_);
				_tmp1573_ = _tmp1572_;
				_tmp1566_ = _tmp1573_ != NULL;
			} else {
				_tmp1566_ = FALSE;
			}
			if (_tmp1566_) {
				ValaExpression* _tmp1574_;
				ValaExpression* _tmp1575_;
				ValaSymbol* _tmp1576_;
				ValaSymbol* _tmp1577_;
				ValaSymbol* _tmp1578_;
				ValaSymbol* _tmp1579_;
				ValaDataType* _tmp1580_;
				ValaDataType* _tmp1581_;
				_tmp1574_ = vala_member_access_get_inner (self);
				_tmp1575_ = _tmp1574_;
				_tmp1576_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1577_ = _tmp1576_;
				_tmp1578_ = vala_symbol_get_parent_symbol (_tmp1577_);
				_tmp1579_ = _tmp1578_;
				_tmp1580_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1579_);
				_tmp1581_ = _tmp1580_;
				vala_expression_set_target_type (_tmp1575_, _tmp1581_);
				_vala_code_node_unref0 (_tmp1581_);
			} else {
				gboolean _tmp1582_ = FALSE;
				gboolean _tmp1583_ = FALSE;
				gboolean _tmp1584_ = FALSE;
				ValaSymbol* _tmp1585_;
				ValaSymbol* _tmp1586_;
				_tmp1585_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1586_ = _tmp1585_;
				if (VALA_IS_FIELD (_tmp1586_)) {
					_tmp1584_ = TRUE;
				} else {
					ValaSymbol* _tmp1587_;
					ValaSymbol* _tmp1588_;
					_tmp1587_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1588_ = _tmp1587_;
					_tmp1584_ = VALA_IS_SIGNAL (_tmp1588_);
				}
				if (_tmp1584_) {
					_tmp1583_ = instance;
				} else {
					_tmp1583_ = FALSE;
				}
				if (_tmp1583_) {
					ValaSymbol* _tmp1589_;
					ValaSymbol* _tmp1590_;
					ValaSymbol* _tmp1591_;
					ValaSymbol* _tmp1592_;
					_tmp1589_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1590_ = _tmp1589_;
					_tmp1591_ = vala_symbol_get_parent_symbol (_tmp1590_);
					_tmp1592_ = _tmp1591_;
					_tmp1582_ = _tmp1592_ != NULL;
				} else {
					_tmp1582_ = FALSE;
				}
				if (_tmp1582_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1593_;
					ValaSymbol* _tmp1594_;
					ValaSymbol* _tmp1595_;
					ValaSymbol* _tmp1596_;
					ValaDataType* _tmp1597_;
					ValaExpression* _tmp1598_;
					ValaExpression* _tmp1599_;
					ValaDataType* _tmp1600_;
					ValaExpression* _tmp1601_;
					ValaExpression* _tmp1602_;
					ValaDataType* _tmp1603_;
					ValaDataType* _tmp1604_;
					ValaDataType* _tmp1605_;
					ValaDataType* _tmp1606_;
					_tmp1593_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1594_ = _tmp1593_;
					_tmp1595_ = vala_symbol_get_parent_symbol (_tmp1594_);
					_tmp1596_ = _tmp1595_;
					_tmp1597_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1596_);
					parent_type = _tmp1597_;
					_tmp1598_ = vala_member_access_get_inner (self);
					_tmp1599_ = _tmp1598_;
					_tmp1600_ = parent_type;
					_tmp1601_ = vala_member_access_get_inner (self);
					_tmp1602_ = _tmp1601_;
					_tmp1603_ = vala_expression_get_value_type (_tmp1602_);
					_tmp1604_ = _tmp1603_;
					_tmp1605_ = vala_data_type_get_actual_type (_tmp1600_, _tmp1604_, NULL, (ValaCodeNode*) self);
					_tmp1606_ = _tmp1605_;
					vala_expression_set_target_type (_tmp1599_, _tmp1606_);
					_vala_code_node_unref0 (_tmp1606_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1609_ = vala_member_access_get_inner (self);
		_tmp1610_ = _tmp1609_;
		if (_tmp1610_ == NULL) {
			ValaDataType* _tmp1611_;
			ValaDataType* _tmp1612_;
			_tmp1611_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1612_ = _tmp1611_;
			_tmp1608_ = _tmp1612_ != NULL;
		} else {
			_tmp1608_ = FALSE;
		}
		if (_tmp1608_) {
			ValaProfile _tmp1613_;
			ValaProfile _tmp1614_;
			_tmp1613_ = vala_code_context_get_profile (context);
			_tmp1614_ = _tmp1613_;
			_tmp1607_ = _tmp1614_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1607_ = FALSE;
		}
		if (_tmp1607_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1615_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1616_ = _tmp1615_;
	if (_tmp1616_ != NULL) {
		ValaDataType* _tmp1617_;
		ValaDataType* _tmp1618_;
		_tmp1617_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1618_ = _tmp1617_;
		vala_code_node_check ((ValaCodeNode*) _tmp1618_, context);
	}
	_tmp1619_ = self->priv->_tainted_access;
	if (!_tmp1619_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1620_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1621_ = _tmp1620_;
	result = !_tmp1621_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

