/* valasourcefile.c generated by valac, the Vala compiler
 * generated from valasourcefile.vala, do not modify */

/* valasourcefile.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValaParamSpecSourceFile ValaParamSpecSourceFile;

struct _ValaSourceFilePrivate {
	gchar* _filename;
	gchar* _package_name;
	gchar* _installed_version;
	gboolean _version_requested;
	ValaSourceFileType _file_type;
	gboolean _from_commandline;
	gchar* _gir_namespace;
	gchar* _gir_version;
	gboolean _gir_ambiguous;
	ValaCodeContext* _context;
	gboolean _used;
	ValaArrayList* comments;
	ValaList* _current_using_directives;
	ValaList* nodes;
	gchar* _relative_filename;
	gchar* csource_filename;
	gchar* cinclude_filename;
	ValaArrayList* source_array;
	GMappedFile* mapped_file;
	gchar* _content;
};

struct _ValaParamSpecSourceFile {
	GParamSpec parent_instance;
};

static gint ValaSourceFile_private_offset;
static gpointer vala_source_file_parent_class = NULL;

static void vala_source_file_set_filename (ValaSourceFile* self,
                                    const gchar* value);
static gchar* vala_source_file_get_subdir (ValaSourceFile* self);
static gchar* vala_source_file_get_destination_directory (ValaSourceFile* self);
static gchar* vala_source_file_get_basename (ValaSourceFile* self);
static void vala_source_file_read_source_lines (ValaSourceFile* self,
                                         const gchar* cont);
static void vala_source_file_read_source_file (ValaSourceFile* self);
static void vala_source_file_finalize (ValaSourceFile * obj);
static GType vala_source_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_source_file_get_instance_private (ValaSourceFile* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSourceFile_private_offset);
}

const gchar*
vala_source_file_get_filename (ValaSourceFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
vala_source_file_set_filename (ValaSourceFile* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp0_;
}

void
vala_source_file_set_relative_filename (ValaSourceFile* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_relative_filename);
	self->priv->_relative_filename = _tmp0_;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

const gchar*
vala_source_file_get_package_name (ValaSourceFile* self)
{
	const gchar* result;
	ValaSourceFileType _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file_type;
	if (_tmp0_ != VALA_SOURCE_FILE_TYPE_PACKAGE) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_package_name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp2_ = self->priv->_filename;
		_tmp3_ = self->priv->_filename;
		_tmp4_ = string_slice (_tmp2_, (glong) 0, (glong) string_last_index_of_char (_tmp3_, (gunichar) '.', 0));
		_tmp5_ = _tmp4_;
		_tmp6_ = g_path_get_basename (_tmp5_);
		_g_free0 (self->priv->_package_name);
		self->priv->_package_name = _tmp6_;
		_g_free0 (_tmp5_);
	}
	_tmp7_ = self->priv->_package_name;
	result = _tmp7_;
	return result;
}

void
vala_source_file_set_package_name (ValaSourceFile* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_package_name);
	self->priv->_package_name = _tmp0_;
}

const gchar*
vala_source_file_get_installed_version (ValaSourceFile* self)
{
	const gchar* result;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_version_requested) {
		const gchar* _tmp0_;
		_tmp0_ = self->priv->_installed_version;
		result = _tmp0_;
		return result;
	}
	self->priv->_version_requested = TRUE;
	_tmp1_ = vala_source_file_get_package_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaCodeContext* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->_context;
		_tmp4_ = vala_source_file_get_package_name (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_context_pkg_config_modversion (_tmp3_, _tmp5_);
		_g_free0 (self->priv->_installed_version);
		self->priv->_installed_version = _tmp6_;
	}
	_tmp7_ = self->priv->_installed_version;
	result = _tmp7_;
	return result;
}

void
vala_source_file_set_installed_version (ValaSourceFile* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_version_requested = value != NULL;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_installed_version);
	self->priv->_installed_version = _tmp0_;
}

ValaSourceFileType
vala_source_file_get_file_type (ValaSourceFile* self)
{
	ValaSourceFileType result;
	ValaSourceFileType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_file_type;
	result = _tmp0_;
	return result;
}

void
vala_source_file_set_file_type (ValaSourceFile* self,
                                ValaSourceFileType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_file_type = value;
}

gboolean
vala_source_file_get_from_commandline (ValaSourceFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_from_commandline;
	return result;
}

void
vala_source_file_set_from_commandline (ValaSourceFile* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_from_commandline = value;
}

const gchar*
vala_source_file_get_gir_namespace (ValaSourceFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gir_namespace;
	result = _tmp0_;
	return result;
}

void
vala_source_file_set_gir_namespace (ValaSourceFile* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_gir_namespace);
	self->priv->_gir_namespace = _tmp0_;
}

const gchar*
vala_source_file_get_gir_version (ValaSourceFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gir_version;
	result = _tmp0_;
	return result;
}

void
vala_source_file_set_gir_version (ValaSourceFile* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_gir_version);
	self->priv->_gir_version = _tmp0_;
}

gboolean
vala_source_file_get_gir_ambiguous (ValaSourceFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_gir_ambiguous;
	return result;
}

void
vala_source_file_set_gir_ambiguous (ValaSourceFile* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_gir_ambiguous = value;
}

ValaCodeContext*
vala_source_file_get_context (ValaSourceFile* self)
{
	ValaCodeContext* result;
	ValaCodeContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	result = _tmp0_;
	return result;
}

void
vala_source_file_set_context (ValaSourceFile* self,
                              ValaCodeContext* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}

const gchar*
vala_source_file_get_content (ValaSourceFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

void
vala_source_file_set_content (ValaSourceFile* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp0_;
	_vala_iterable_unref0 (self->priv->source_array);
	self->priv->source_array = NULL;
}

gboolean
vala_source_file_get_used (ValaSourceFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_used;
	return result;
}

void
vala_source_file_set_used (ValaSourceFile* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_used = value;
}

ValaList*
vala_source_file_get_current_using_directives (ValaSourceFile* self)
{
	ValaList* result;
	ValaList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_using_directives;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_source_file_set_current_using_directives (ValaSourceFile* self,
                                               ValaList* value)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_iterable_ref0 (value);
	_vala_iterable_unref0 (self->priv->_current_using_directives);
	self->priv->_current_using_directives = _tmp0_;
}

/**
 * Creates a new source file.
 *
 * @param filename source file name
 * @return         newly created source file
 */
ValaSourceFile*
vala_source_file_construct (GType object_type,
                            ValaCodeContext* context,
                            ValaSourceFileType type,
                            const gchar* filename,
                            const gchar* content,
                            gboolean cmdline)
{
	ValaSourceFile* self = NULL;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaSourceFile*) g_type_create_instance (object_type);
	vala_source_file_set_context (self, context);
	vala_source_file_set_file_type (self, type);
	vala_source_file_set_filename (self, filename);
	vala_source_file_set_content (self, content);
	vala_source_file_set_from_commandline (self, cmdline);
	return self;
}

ValaSourceFile*
vala_source_file_new (ValaCodeContext* context,
                      ValaSourceFileType type,
                      const gchar* filename,
                      const gchar* content,
                      gboolean cmdline)
{
	return vala_source_file_construct (VALA_TYPE_SOURCE_FILE, context, type, filename, content, cmdline);
}

/**
 * Adds a header comment to this source file.
 */
void
vala_source_file_add_comment (ValaSourceFile* self,
                              ValaComment* comment)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->comments;
	vala_collection_add ((ValaCollection*) _tmp0_, comment);
}

/**
 * Returns the list of header comments.
 *
 * @return list of comments
 */
ValaList*
vala_source_file_get_comments (ValaSourceFile* self)
{
	ValaArrayList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->comments;
	result = (ValaList*) _tmp0_;
	return result;
}

/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void
vala_source_file_add_using_directive (ValaSourceFile* self,
                                      ValaUsingDirective* ns)
{
	ValaList* old_using_directives = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->_current_using_directives;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	old_using_directives = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	_tmp4_ = _tmp3_;
	vala_source_file_set_current_using_directives (self, (ValaList*) _tmp4_);
	_vala_iterable_unref0 (_tmp4_);
	{
		ValaList* _using_directive_list = NULL;
		ValaList* _tmp5_;
		gint _using_directive_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _using_directive_index = 0;
		_tmp5_ = old_using_directives;
		_using_directive_list = _tmp5_;
		_tmp6_ = _using_directive_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_using_directive_size = _tmp8_;
		_using_directive_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaUsingDirective* using_directive = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaList* _tmp13_;
			ValaUsingDirective* _tmp14_;
			_using_directive_index = _using_directive_index + 1;
			_tmp9_ = _using_directive_index;
			_tmp10_ = _using_directive_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _using_directive_list;
			_tmp12_ = vala_list_get (_tmp11_, _using_directive_index);
			using_directive = (ValaUsingDirective*) _tmp12_;
			_tmp13_ = self->priv->_current_using_directives;
			_tmp14_ = using_directive;
			vala_collection_add ((ValaCollection*) _tmp13_, _tmp14_);
			_vala_code_node_unref0 (using_directive);
		}
	}
	_tmp15_ = self->priv->_current_using_directives;
	vala_collection_add ((ValaCollection*) _tmp15_, ns);
	_vala_iterable_unref0 (old_using_directives);
}

/**
 * Adds the specified code node to this source file.
 *
 * @param node a code node
 */
void
vala_source_file_add_node (ValaSourceFile* self,
                           ValaCodeNode* node)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->nodes;
	vala_collection_add ((ValaCollection*) _tmp0_, node);
}

void
vala_source_file_remove_node (ValaSourceFile* self,
                              ValaCodeNode* node)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->nodes;
	vala_collection_remove ((ValaCollection*) _tmp0_, node);
}

/**
 * Returns the list of code nodes.
 *
 * @return code node list
 */
ValaList*
vala_source_file_get_nodes (ValaSourceFile* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->nodes;
	result = _tmp0_;
	return result;
}

void
vala_source_file_accept (ValaSourceFile* self,
                         ValaCodeVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_source_file (visitor, self);
}

void
vala_source_file_accept_children (ValaSourceFile* self,
                                  ValaCodeVisitor* visitor)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp0_;
		gint _node_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _node_index = 0;
		_tmp0_ = self->priv->nodes;
		_node_list = _tmp0_;
		_tmp1_ = _node_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_node_size = _tmp3_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaCodeNode* _tmp8_;
			_node_index = _node_index + 1;
			_tmp4_ = _node_index;
			_tmp5_ = _node_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _node_list;
			_tmp7_ = vala_list_get (_tmp6_, _node_index);
			node = (ValaCodeNode*) _tmp7_;
			_tmp8_ = node;
			vala_code_node_accept (_tmp8_, visitor);
			_vala_code_node_unref0 (node);
		}
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
vala_source_file_get_subdir (ValaSourceFile* self)
{
	ValaCodeContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gchar* _tmp34_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	_tmp1_ = vala_code_context_get_basedir (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_filename;
	_tmp5_ = self->priv->_context;
	_tmp6_ = vala_code_context_get_basedir (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_str_has_prefix (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		gchar* basename = NULL;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* subdir = NULL;
		const gchar* _tmp13_;
		ValaCodeContext* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		ValaCodeContext* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		_tmp11_ = self->priv->_filename;
		_tmp12_ = g_path_get_basename (_tmp11_);
		basename = _tmp12_;
		_tmp13_ = self->priv->_filename;
		_tmp14_ = self->priv->_context;
		_tmp15_ = vala_code_context_get_basedir (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_filename;
		_tmp20_ = strlen (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_context;
		_tmp23_ = vala_code_context_get_basedir (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = strlen (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = basename;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = string_substring (_tmp13_, (glong) _tmp18_, (glong) ((_tmp21_ - _tmp26_) - _tmp29_));
		subdir = _tmp30_;
		while (TRUE) {
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			_tmp31_ = subdir;
			if (!(string_get (_tmp31_, (glong) 0) == '/')) {
				break;
			}
			_tmp32_ = subdir;
			_tmp33_ = string_substring (_tmp32_, (glong) 1, (glong) -1);
			_g_free0 (subdir);
			subdir = _tmp33_;
		}
		result = subdir;
		_g_free0 (basename);
		return result;
	}
	_tmp34_ = g_strdup ("");
	result = _tmp34_;
	return result;
}

static gchar*
vala_source_file_get_destination_directory (ValaSourceFile* self)
{
	ValaCodeContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaCodeContext* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	_tmp1_ = vala_code_context_get_directory (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = vala_source_file_get_subdir (self);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_context;
	_tmp5_ = vala_code_context_get_directory (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_source_file_get_subdir (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_path ("/", _tmp6_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	result = _tmp10_;
	return result;
}

static gchar*
vala_source_file_get_basename (ValaSourceFile* self)
{
	gint dot = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	dot = string_last_index_of_char (_tmp0_, (gunichar) '.', 0);
	_tmp1_ = self->priv->_filename;
	_tmp2_ = string_substring (_tmp1_, (glong) 0, (glong) dot);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_path_get_basename (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

gchar*
vala_source_file_get_relative_filename (ValaSourceFile* self)
{
	const gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_relative_filename;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_relative_filename;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_filename;
		_tmp4_ = g_path_get_basename (_tmp3_);
		result = _tmp4_;
		return result;
	}
}

/**
 * Returns the filename to use when generating C source files.
 *
 * @return generated C source filename
 */
gchar*
vala_source_file_get_csource_filename (ValaSourceFile* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->csource_filename;
	if (_tmp0_ == NULL) {
		ValaCodeContext* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_context;
		_tmp2_ = vala_code_context_get_run_output (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			ValaCodeContext* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = self->priv->_context;
			_tmp5_ = vala_code_context_get_output (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strconcat (_tmp6_, ".c", NULL);
			_g_free0 (self->priv->csource_filename);
			self->priv->csource_filename = _tmp7_;
		} else {
			gboolean _tmp8_ = FALSE;
			ValaCodeContext* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = self->priv->_context;
			_tmp10_ = vala_code_context_get_ccode_only (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				_tmp8_ = TRUE;
			} else {
				ValaCodeContext* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp12_ = self->priv->_context;
				_tmp13_ = vala_code_context_get_save_csources (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp8_ = _tmp14_;
			}
			if (_tmp8_) {
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp15_ = vala_source_file_get_destination_directory (self);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_source_file_get_basename (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp18_, ".c", NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_build_path ("/", _tmp16_, _tmp20_, NULL);
				_g_free0 (self->priv->csource_filename);
				self->priv->csource_filename = _tmp21_;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
			} else {
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp22_ = vala_source_file_get_destination_directory (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_source_file_get_basename (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp25_, ".vala.c", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_build_path ("/", _tmp23_, _tmp27_, NULL);
				_g_free0 (self->priv->csource_filename);
				self->priv->csource_filename = _tmp28_;
				_g_free0 (_tmp27_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
			}
		}
	}
	_tmp29_ = self->priv->csource_filename;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	return result;
}

/**
 * Returns the filename to use when including the generated C header
 * file.
 *
 * @return C header filename to include
 */
gchar*
vala_source_file_get_cinclude_filename (ValaSourceFile* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cinclude_filename;
	if (_tmp0_ == NULL) {
		ValaCodeContext* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->_context;
		_tmp2_ = vala_code_context_get_header_filename (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaCodeContext* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			ValaCodeContext* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp4_ = self->priv->_context;
			_tmp5_ = vala_code_context_get_header_filename (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_path_get_basename (_tmp6_);
			_g_free0 (self->priv->cinclude_filename);
			self->priv->cinclude_filename = _tmp7_;
			_tmp8_ = self->priv->_context;
			_tmp9_ = vala_code_context_get_includedir (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				ValaCodeContext* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = self->priv->_context;
				_tmp12_ = vala_code_context_get_includedir (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = self->priv->cinclude_filename;
				_tmp15_ = g_build_path ("/", _tmp13_, _tmp14_, NULL);
				_g_free0 (self->priv->cinclude_filename);
				self->priv->cinclude_filename = _tmp15_;
			}
		} else {
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp16_ = vala_source_file_get_subdir (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_basename (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp19_, ".h", NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_build_path ("/", _tmp17_, _tmp21_, NULL);
			_g_free0 (self->priv->cinclude_filename);
			self->priv->cinclude_filename = _tmp22_;
			_g_free0 (_tmp21_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
		}
	}
	_tmp23_ = self->priv->cinclude_filename;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	return result;
}

/**
 * Returns the requested line from this file, loading it if needed.
 *
 * @param lineno 1-based line number
 * @return       the specified source line
 */
gchar*
vala_source_file_get_source_line (ValaSourceFile* self,
                                  gint lineno)
{
	ValaArrayList* _tmp0_;
	gboolean _tmp5_ = FALSE;
	ValaArrayList* _tmp9_;
	gpointer _tmp10_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->source_array;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_source_file_get_content (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = vala_source_file_get_content (self);
			_tmp4_ = _tmp3_;
			vala_source_file_read_source_lines (self, _tmp4_);
		} else {
			vala_source_file_read_source_file (self);
		}
	}
	if (lineno < 1) {
		_tmp5_ = TRUE;
	} else {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->source_array;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = lineno > _tmp8_;
	}
	if (_tmp5_) {
		result = NULL;
		return result;
	}
	_tmp9_ = self->priv->source_array;
	_tmp10_ = vala_list_get ((ValaList*) _tmp9_, lineno - 1);
	result = (gchar*) _tmp10_;
	return result;
}

/**
 * Parses the input file into ::source_array.
 */
static void
vala_source_file_read_source_file (ValaSourceFile* self)
{
	gchar* cont = NULL;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = self->priv->_filename;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (cont);
		cont = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (cont);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (cont);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (cont);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp2_ = cont;
	vala_source_file_read_source_lines (self, _tmp2_);
	_g_free0 (cont);
}

static void
vala_source_file_read_source_lines (ValaSourceFile* self,
                                    const gchar* cont)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gchar** lines = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint lines_length1;
	gint _lines_size_;
	gint idx = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cont != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp0_);
	_vala_iterable_unref0 (self->priv->source_array);
	self->priv->source_array = _tmp1_;
	_tmp3_ = _tmp2_ = g_strsplit (cont, "\n", 0);
	lines = _tmp3_;
	lines_length1 = _vala_array_length (_tmp2_);
	_lines_size_ = lines_length1;
	{
		gboolean _tmp4_ = FALSE;
		idx = 0;
		_tmp4_ = TRUE;
		while (TRUE) {
			gchar** _tmp6_;
			gint _tmp6__length1;
			const gchar* _tmp7_;
			ValaArrayList* _tmp8_;
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			if (!_tmp4_) {
				gint _tmp5_;
				idx = idx + 1;
				_tmp5_ = idx;
			}
			_tmp4_ = FALSE;
			_tmp6_ = lines;
			_tmp6__length1 = lines_length1;
			_tmp7_ = _tmp6_[idx];
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = self->priv->source_array;
			_tmp9_ = lines;
			_tmp9__length1 = lines_length1;
			_tmp10_ = _tmp9_[idx];
			vala_collection_add ((ValaCollection*) _tmp8_, _tmp10_);
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}

gchar*
vala_source_file_get_mapped_contents (ValaSourceFile* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GMappedFile* _tmp4_;
	GMappedFile* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_source_file_get_content (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = vala_source_file_get_content (self);
		_tmp3_ = _tmp2_;
		result = (gchar*) _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->mapped_file;
	if (_tmp4_ == NULL) {
		{
			GMappedFile* _tmp5_ = NULL;
			const gchar* _tmp6_;
			GMappedFile* _tmp7_;
			GMappedFile* _tmp8_;
			_tmp6_ = self->priv->_filename;
			_tmp7_ = g_mapped_file_new (_tmp6_, FALSE, &_inner_error0_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_mapped_file_unref0 (self->priv->mapped_file);
			self->priv->mapped_file = _tmp8_;
			_g_mapped_file_unref0 (_tmp5_);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			const gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = self->priv->_filename;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			vala_report_error (NULL, "Unable to map file `%s': %s", _tmp9_, _tmp11_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = self->priv->mapped_file;
	_tmp13_ = g_mapped_file_get_contents (_tmp12_);
	result = _tmp13_;
	return result;
}

gsize
vala_source_file_get_mapped_length (ValaSourceFile* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GMappedFile* _tmp6_;
	gsize result = 0UL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = vala_source_file_get_content (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = vala_source_file_get_content (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		result = (gsize) _tmp5_;
		return result;
	}
	_tmp6_ = self->priv->mapped_file;
	result = g_mapped_file_get_length (_tmp6_);
	return result;
}

gboolean
vala_source_file_check (ValaSourceFile* self,
                        ValaCodeContext* context)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp0_;
		gint _node_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _node_index = 0;
		_tmp0_ = self->priv->nodes;
		_node_list = _tmp0_;
		_tmp1_ = _node_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_node_size = _tmp3_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaCodeNode* _tmp8_;
			_node_index = _node_index + 1;
			_tmp4_ = _node_index;
			_tmp5_ = _node_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _node_list;
			_tmp7_ = vala_list_get (_tmp6_, _node_index);
			node = (ValaCodeNode*) _tmp7_;
			_tmp8_ = node;
			vala_code_node_check (_tmp8_, context);
			_vala_code_node_unref0 (node);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_value_source_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_source_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_source_file_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_source_file_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_source_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_source_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_source_file_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaSourceFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_source_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_source_file_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	ValaSourceFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_source_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_source_file (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ValaParamSpecSourceFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SOURCE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_source_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_source_file (GValue* value,
                            gpointer v_object)
{
	ValaSourceFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_source_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}

void
vala_value_take_source_file (GValue* value,
                             gpointer v_object)
{
	ValaSourceFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}

static void
vala_source_file_class_init (ValaSourceFileClass * klass,
                             gpointer klass_data)
{
	vala_source_file_parent_class = g_type_class_peek_parent (klass);
	((ValaSourceFileClass *) klass)->finalize = vala_source_file_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSourceFile_private_offset);
}

static void
vala_source_file_instance_init (ValaSourceFile * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = vala_source_file_get_instance_private (self);
	self->priv->_installed_version = NULL;
	self->priv->_version_requested = FALSE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, (GDestroyNotify) vala_comment_unref, _tmp0_);
	self->priv->comments = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->_current_using_directives = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->nodes = (ValaList*) _tmp5_;
	self->priv->csource_filename = NULL;
	self->priv->cinclude_filename = NULL;
	self->priv->source_array = NULL;
	self->priv->mapped_file = NULL;
	self->priv->_content = NULL;
	self->ref_count = 1;
}

static void
vala_source_file_finalize (ValaSourceFile * obj)
{
	ValaSourceFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SOURCE_FILE, ValaSourceFile);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_package_name);
	_g_free0 (self->priv->_installed_version);
	_g_free0 (self->priv->_gir_namespace);
	_g_free0 (self->priv->_gir_version);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->_current_using_directives);
	_vala_iterable_unref0 (self->priv->nodes);
	_g_free0 (self->priv->_relative_filename);
	_g_free0 (self->priv->csource_filename);
	_g_free0 (self->priv->cinclude_filename);
	_vala_iterable_unref0 (self->priv->source_array);
	_g_mapped_file_unref0 (self->priv->mapped_file);
	_g_free0 (self->priv->_content);
}

/**
 * Represents a Vala source or VAPI package file.
 */
static GType
vala_source_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_source_file_init, vala_value_source_file_free_value, vala_value_source_file_copy_value, vala_value_source_file_peek_pointer, "p", vala_value_source_file_collect_value, "p", vala_value_source_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFile), 0, (GInstanceInitFunc) vala_source_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_source_file_type_id;
	vala_source_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaSourceFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaSourceFile_private_offset = g_type_add_instance_private (vala_source_file_type_id, sizeof (ValaSourceFilePrivate));
	return vala_source_file_type_id;
}

GType
vala_source_file_get_type (void)
{
	static volatile gsize vala_source_file_type_id__volatile = 0;
	if (g_once_init_enter (&vala_source_file_type_id__volatile)) {
		GType vala_source_file_type_id;
		vala_source_file_type_id = vala_source_file_get_type_once ();
		g_once_init_leave (&vala_source_file_type_id__volatile, vala_source_file_type_id);
	}
	return vala_source_file_type_id__volatile;
}

gpointer
vala_source_file_ref (gpointer instance)
{
	ValaSourceFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_source_file_unref (gpointer instance)
{
	ValaSourceFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SOURCE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
vala_source_file_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_SOURCE_FILE_TYPE_NONE, "VALA_SOURCE_FILE_TYPE_NONE", "none"}, {VALA_SOURCE_FILE_TYPE_SOURCE, "VALA_SOURCE_FILE_TYPE_SOURCE", "source"}, {VALA_SOURCE_FILE_TYPE_PACKAGE, "VALA_SOURCE_FILE_TYPE_PACKAGE", "package"}, {VALA_SOURCE_FILE_TYPE_FAST, "VALA_SOURCE_FILE_TYPE_FAST", "fast"}, {0, NULL, NULL}};
	GType vala_source_file_type_type_id;
	vala_source_file_type_type_id = g_enum_register_static ("ValaSourceFileType", values);
	return vala_source_file_type_type_id;
}

GType
vala_source_file_type_get_type (void)
{
	static volatile gsize vala_source_file_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_source_file_type_type_id__volatile)) {
		GType vala_source_file_type_type_id;
		vala_source_file_type_type_id = vala_source_file_type_get_type_once ();
		g_once_init_leave (&vala_source_file_type_type_id__volatile, vala_source_file_type_type_id);
	}
	return vala_source_file_type_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

