/** @file
 * IPRT - Symbol Mangling.
 *
 * This header is used to mangle public IPRT symbol to make it possible to have
 * several IPRT version loaded into one symbol space at the same time.  To
 * enable symbol mangling you create a header which the compiler includes for
 * every compilation unit (check out the -include option of gcc).  Your header
 * will define RT_MANGLER(name) and then include this header to set up the
 * actual mappings.
 */

/*
 * Copyright (C) 2011 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */

#ifndef ___iprt_mangling_h
#define ___iprt_mangling_h

#ifndef RT_MANGLER
# error "RT_MANGLER is not defined."
#endif

#ifndef DOXYGEN_RUNNING

/** @def RT_WITH_MANGLING
 * Indicates that we're mangling symbols.  */
# define RT_WITH_MANGLING


/*
 * Stable functions (alphabetical order):
 */
# define ASMAtomicCmpXchgExU64                          RT_MANGLER(ASMAtomicCmpXchgExU64)   /* not-some-systems... */
# define ASMAtomicCmpXchgExU64_EndProc                  RT_MANGLER(ASMAtomicCmpXchgExU64_EndProc
# define ASMAtomicCmpXchgU64                            RT_MANGLER(ASMAtomicCmpXchgU64)     /* not-some-systems... */
# define ASMAtomicCmpXchgU64_EndProc                    RT_MANGLER(ASMAtomicCmpXchgU64_EndProc
# define ASMAtomicReadU64                               RT_MANGLER(ASMAtomicReadU64)        /* not-some-systems... */
# define ASMAtomicReadU64_EndProc                       RT_MANGLER(ASMAtomicReadU64_EndProc
# define ASMAtomicUoReadU64                             RT_MANGLER(ASMAtomicUoReadU64)      /* not-some-systems... */
# define ASMAtomicUoReadU64_EndProc                     RT_MANGLER(ASMAtomicUoReadU64_EndProc
# define ASMAtomicXchgU64                               RT_MANGLER(ASMAtomicXchgU64)        /* not-some-systems... */
# define ASMAtomicXchgU64_EndProc                       RT_MANGLER(ASMAtomicXchgU64_EndProc
# define RTAssertAreQuiet                               RT_MANGLER(RTAssertAreQuiet)
# define RTAssertMayPanic                               RT_MANGLER(RTAssertMayPanic)
# define RTAssertMsg1                                   RT_MANGLER(RTAssertMsg1)
# define RTAssertMsg1Weak                               RT_MANGLER(RTAssertMsg1Weak)
# define RTAssertMsg2                                   RT_MANGLER(RTAssertMsg2)
# define RTAssertMsg2Add                                RT_MANGLER(RTAssertMsg2Add)
# define RTAssertMsg2AddV                               RT_MANGLER(RTAssertMsg2AddV)
# define RTAssertMsg2AddWeak                            RT_MANGLER(RTAssertMsg2AddWeak)
# define RTAssertMsg2AddWeakV                           RT_MANGLER(RTAssertMsg2AddWeakV)
# define RTAssertMsg2V                                  RT_MANGLER(RTAssertMsg2V)
# define RTAssertMsg2Weak                               RT_MANGLER(RTAssertMsg2Weak)
# define RTAssertMsg2WeakV                              RT_MANGLER(RTAssertMsg2WeakV)
# define RTAssertSetMayPanic                            RT_MANGLER(RTAssertSetMayPanic)
# define RTAssertSetQuiet                               RT_MANGLER(RTAssertSetQuiet)
# define RTAssertShouldPanic                            RT_MANGLER(RTAssertShouldPanic)
# define RTAvlGCPhysDestroy                             RT_MANGLER(RTAvlGCPhysDestroy)
# define RTAvlGCPhysDoWithAll                           RT_MANGLER(RTAvlGCPhysDoWithAll)
# define RTAvlGCPhysGet                                 RT_MANGLER(RTAvlGCPhysGet)
# define RTAvlGCPhysGetBestFit                          RT_MANGLER(RTAvlGCPhysGetBestFit)
# define RTAvlGCPhysInsert                              RT_MANGLER(RTAvlGCPhysInsert)
# define RTAvlGCPhysRemove                              RT_MANGLER(RTAvlGCPhysRemove)
# define RTAvlGCPhysRemoveBestFit                       RT_MANGLER(RTAvlGCPhysRemoveBestFit)
# define RTAvlGCPtrDestroy                              RT_MANGLER(RTAvlGCPtrDestroy)
# define RTAvlGCPtrDoWithAll                            RT_MANGLER(RTAvlGCPtrDoWithAll)
# define RTAvlGCPtrGet                                  RT_MANGLER(RTAvlGCPtrGet)
# define RTAvlGCPtrGetBestFit                           RT_MANGLER(RTAvlGCPtrGetBestFit)
# define RTAvlGCPtrInsert                               RT_MANGLER(RTAvlGCPtrInsert)
# define RTAvlGCPtrRemove                               RT_MANGLER(RTAvlGCPtrRemove)
# define RTAvlGCPtrRemoveBestFit                        RT_MANGLER(RTAvlGCPtrRemoveBestFit)
# define RTAvlHCPhysDestroy                             RT_MANGLER(RTAvlHCPhysDestroy)
# define RTAvlHCPhysDoWithAll                           RT_MANGLER(RTAvlHCPhysDoWithAll)
# define RTAvlHCPhysGet                                 RT_MANGLER(RTAvlHCPhysGet)
# define RTAvlHCPhysGetBestFit                          RT_MANGLER(RTAvlHCPhysGetBestFit)
# define RTAvlHCPhysInsert                              RT_MANGLER(RTAvlHCPhysInsert)
# define RTAvlHCPhysRemove                              RT_MANGLER(RTAvlHCPhysRemove)
# define RTAvlHCPhysRemoveBestFit                       RT_MANGLER(RTAvlHCPhysRemoveBestFit)
# define RTAvllU32Destroy                               RT_MANGLER(RTAvllU32Destroy)
# define RTAvllU32DoWithAll                             RT_MANGLER(RTAvllU32DoWithAll)
# define RTAvllU32Get                                   RT_MANGLER(RTAvllU32Get)
# define RTAvllU32GetBestFit                            RT_MANGLER(RTAvllU32GetBestFit)
# define RTAvllU32Insert                                RT_MANGLER(RTAvllU32Insert)
# define RTAvllU32Remove                                RT_MANGLER(RTAvllU32Remove)
# define RTAvllU32RemoveBestFit                         RT_MANGLER(RTAvllU32RemoveBestFit)
# define RTAvllU32RemoveNode                            RT_MANGLER(RTAvllU32RemoveNode)
# define RTAvloGCPhysDestroy                            RT_MANGLER(RTAvloGCPhysDestroy)
# define RTAvloGCPhysDoWithAll                          RT_MANGLER(RTAvloGCPhysDoWithAll)
# define RTAvloGCPhysGet                                RT_MANGLER(RTAvloGCPhysGet)
# define RTAvloGCPhysGetBestFit                         RT_MANGLER(RTAvloGCPhysGetBestFit)
# define RTAvloGCPhysInsert                             RT_MANGLER(RTAvloGCPhysInsert)
# define RTAvloGCPhysRemove                             RT_MANGLER(RTAvloGCPhysRemove)
# define RTAvloGCPhysRemoveBestFit                      RT_MANGLER(RTAvloGCPhysRemoveBestFit)
# define RTAvloGCPtrDestroy                             RT_MANGLER(RTAvloGCPtrDestroy)
# define RTAvloGCPtrDoWithAll                           RT_MANGLER(RTAvloGCPtrDoWithAll)
# define RTAvloGCPtrGet                                 RT_MANGLER(RTAvloGCPtrGet)
# define RTAvloGCPtrGetBestFit                          RT_MANGLER(RTAvloGCPtrGetBestFit)
# define RTAvloGCPtrInsert                              RT_MANGLER(RTAvloGCPtrInsert)
# define RTAvloGCPtrRemove                              RT_MANGLER(RTAvloGCPtrRemove)
# define RTAvloGCPtrRemoveBestFit                       RT_MANGLER(RTAvloGCPtrRemoveBestFit)
# define RTAvloHCPhysDestroy                            RT_MANGLER(RTAvloHCPhysDestroy)
# define RTAvloHCPhysDoWithAll                          RT_MANGLER(RTAvloHCPhysDoWithAll)
# define RTAvloHCPhysGet                                RT_MANGLER(RTAvloHCPhysGet)
# define RTAvloHCPhysGetBestFit                         RT_MANGLER(RTAvloHCPhysGetBestFit)
# define RTAvloHCPhysInsert                             RT_MANGLER(RTAvloHCPhysInsert)
# define RTAvloHCPhysRemove                             RT_MANGLER(RTAvloHCPhysRemove)
# define RTAvloHCPhysRemoveBestFit                      RT_MANGLER(RTAvloHCPhysRemoveBestFit)
# define RTAvloIOPortDestroy                            RT_MANGLER(RTAvloIOPortDestroy)
# define RTAvloIOPortDoWithAll                          RT_MANGLER(RTAvloIOPortDoWithAll)
# define RTAvloIOPortGet                                RT_MANGLER(RTAvloIOPortGet)
# define RTAvloIOPortGetBestFit                         RT_MANGLER(RTAvloIOPortGetBestFit)
# define RTAvloIOPortInsert                             RT_MANGLER(RTAvloIOPortInsert)
# define RTAvloIOPortRemove                             RT_MANGLER(RTAvloIOPortRemove)
# define RTAvloIOPortRemoveBestFit                      RT_MANGLER(RTAvloIOPortRemoveBestFit)
# define RTAvloU32Destroy                               RT_MANGLER(RTAvloU32Destroy)
# define RTAvloU32DoWithAll                             RT_MANGLER(RTAvloU32DoWithAll)
# define RTAvloU32Get                                   RT_MANGLER(RTAvloU32Get)
# define RTAvloU32GetBestFit                            RT_MANGLER(RTAvloU32GetBestFit)
# define RTAvloU32Insert                                RT_MANGLER(RTAvloU32Insert)
# define RTAvloU32Remove                                RT_MANGLER(RTAvloU32Remove)
# define RTAvloU32RemoveBestFit                         RT_MANGLER(RTAvloU32RemoveBestFit)
# define RTAvlPVDestroy                                 RT_MANGLER(RTAvlPVDestroy)
# define RTAvlPVDoWithAll                               RT_MANGLER(RTAvlPVDoWithAll)
# define RTAvlPVGet                                     RT_MANGLER(RTAvlPVGet)
# define RTAvlPVGetBestFit                              RT_MANGLER(RTAvlPVGetBestFit)
# define RTAvlPVInsert                                  RT_MANGLER(RTAvlPVInsert)
# define RTAvlPVRemove                                  RT_MANGLER(RTAvlPVRemove)
# define RTAvlPVRemoveBestFit                           RT_MANGLER(RTAvlPVRemoveBestFit)
# define RTAvlrFileOffsetDestroy                        RT_MANGLER(RTAvlrFileOffsetDestroy)
# define RTAvlrFileOffsetDoWithAll                      RT_MANGLER(RTAvlrFileOffsetDoWithAll)
# define RTAvlrFileOffsetGet                            RT_MANGLER(RTAvlrFileOffsetGet)
# define RTAvlrFileOffsetGetBestFit                     RT_MANGLER(RTAvlrFileOffsetGetBestFit)
# define RTAvlrFileOffsetGetLeft                        RT_MANGLER(RTAvlrFileOffsetGetLeft)
# define RTAvlrFileOffsetGetRight                       RT_MANGLER(RTAvlrFileOffsetGetRight)
# define RTAvlrFileOffsetGetRoot                        RT_MANGLER(RTAvlrFileOffsetGetRoot)
# define RTAvlrFileOffsetInsert                         RT_MANGLER(RTAvlrFileOffsetInsert)
# define RTAvlrFileOffsetRangeGet                       RT_MANGLER(RTAvlrFileOffsetRangeGet)
# define RTAvlrFileOffsetRangeRemove                    RT_MANGLER(RTAvlrFileOffsetRangeRemove)
# define RTAvlrFileOffsetRemove                         RT_MANGLER(RTAvlrFileOffsetRemove)
# define RTAvlrGCPtrDestroy                             RT_MANGLER(RTAvlrGCPtrDestroy)
# define RTAvlrGCPtrDoWithAll                           RT_MANGLER(RTAvlrGCPtrDoWithAll)
# define RTAvlrGCPtrGet                                 RT_MANGLER(RTAvlrGCPtrGet)
# define RTAvlrGCPtrGetBestFit                          RT_MANGLER(RTAvlrGCPtrGetBestFit)
# define RTAvlrGCPtrGetLeft                             RT_MANGLER(RTAvlrGCPtrGetLeft)
# define RTAvlrGCPtrGetRight                            RT_MANGLER(RTAvlrGCPtrGetRight)
# define RTAvlrGCPtrGetRoot                             RT_MANGLER(RTAvlrGCPtrGetRoot)
# define RTAvlrGCPtrInsert                              RT_MANGLER(RTAvlrGCPtrInsert)
# define RTAvlrGCPtrRangeGet                            RT_MANGLER(RTAvlrGCPtrRangeGet)
# define RTAvlrGCPtrRangeRemove                         RT_MANGLER(RTAvlrGCPtrRangeRemove)
# define RTAvlrGCPtrRemove                              RT_MANGLER(RTAvlrGCPtrRemove)
# define RTAvlroGCPhysDestroy                           RT_MANGLER(RTAvlroGCPhysDestroy)
# define RTAvlroGCPhysDoWithAll                         RT_MANGLER(RTAvlroGCPhysDoWithAll)
# define RTAvlroGCPhysGet                               RT_MANGLER(RTAvlroGCPhysGet)
# define RTAvlroGCPhysGetBestFit                        RT_MANGLER(RTAvlroGCPhysGetBestFit)
# define RTAvlroGCPhysGetLeft                           RT_MANGLER(RTAvlroGCPhysGetLeft)
# define RTAvlroGCPhysGetRight                          RT_MANGLER(RTAvlroGCPhysGetRight)
# define RTAvlroGCPhysGetRoot                           RT_MANGLER(RTAvlroGCPhysGetRoot)
# define RTAvlroGCPhysInsert                            RT_MANGLER(RTAvlroGCPhysInsert)
# define RTAvlroGCPhysRangeGet                          RT_MANGLER(RTAvlroGCPhysRangeGet)
# define RTAvlroGCPhysRangeRemove                       RT_MANGLER(RTAvlroGCPhysRangeRemove)
# define RTAvlroGCPhysRemove                            RT_MANGLER(RTAvlroGCPhysRemove)
# define RTAvlroGCPtrDestroy                            RT_MANGLER(RTAvlroGCPtrDestroy)
# define RTAvlroGCPtrDoWithAll                          RT_MANGLER(RTAvlroGCPtrDoWithAll)
# define RTAvlroGCPtrGet                                RT_MANGLER(RTAvlroGCPtrGet)
# define RTAvlroGCPtrGetBestFit                         RT_MANGLER(RTAvlroGCPtrGetBestFit)
# define RTAvlroGCPtrGetLeft                            RT_MANGLER(RTAvlroGCPtrGetLeft)
# define RTAvlroGCPtrGetRight                           RT_MANGLER(RTAvlroGCPtrGetRight)
# define RTAvlroGCPtrGetRoot                            RT_MANGLER(RTAvlroGCPtrGetRoot)
# define RTAvlroGCPtrInsert                             RT_MANGLER(RTAvlroGCPtrInsert)
# define RTAvlroGCPtrRangeGet                           RT_MANGLER(RTAvlroGCPtrRangeGet)
# define RTAvlroGCPtrRangeRemove                        RT_MANGLER(RTAvlroGCPtrRangeRemove)
# define RTAvlroGCPtrRemove                             RT_MANGLER(RTAvlroGCPtrRemove)
# define RTAvlroIOPortDestroy                           RT_MANGLER(RTAvlroIOPortDestroy)
# define RTAvlroIOPortDoWithAll                         RT_MANGLER(RTAvlroIOPortDoWithAll)
# define RTAvlroIOPortGet                               RT_MANGLER(RTAvlroIOPortGet)
# define RTAvlroIOPortInsert                            RT_MANGLER(RTAvlroIOPortInsert)
# define RTAvlroIOPortRangeGet                          RT_MANGLER(RTAvlroIOPortRangeGet)
# define RTAvlroIOPortRangeRemove                       RT_MANGLER(RTAvlroIOPortRangeRemove)
# define RTAvlroIOPortRemove                            RT_MANGLER(RTAvlroIOPortRemove)
# define RTAvlrooGCPtrDestroy                           RT_MANGLER(RTAvlrooGCPtrDestroy)
# define RTAvlrooGCPtrDoWithAll                         RT_MANGLER(RTAvlrooGCPtrDoWithAll)
# define RTAvlrooGCPtrGet                               RT_MANGLER(RTAvlrooGCPtrGet)
# define RTAvlrooGCPtrGetBestFit                        RT_MANGLER(RTAvlrooGCPtrGetBestFit)
# define RTAvlrooGCPtrGetLeft                           RT_MANGLER(RTAvlrooGCPtrGetLeft)
# define RTAvlrooGCPtrGetNextEqual                      RT_MANGLER(RTAvlrooGCPtrGetNextEqual)
# define RTAvlrooGCPtrGetRight                          RT_MANGLER(RTAvlrooGCPtrGetRight)
# define RTAvlrooGCPtrGetRoot                           RT_MANGLER(RTAvlrooGCPtrGetRoot)
# define RTAvlrooGCPtrInsert                            RT_MANGLER(RTAvlrooGCPtrInsert)
# define RTAvlrooGCPtrRangeGet                          RT_MANGLER(RTAvlrooGCPtrRangeGet)
# define RTAvlrooGCPtrRangeRemove                       RT_MANGLER(RTAvlrooGCPtrRangeRemove)
# define RTAvlrooGCPtrRemove                            RT_MANGLER(RTAvlrooGCPtrRemove)
# define RTAvlrPVDestroy                                RT_MANGLER(RTAvlrPVDestroy)
# define RTAvlrPVDoWithAll                              RT_MANGLER(RTAvlrPVDoWithAll)
# define RTAvlrPVGet                                    RT_MANGLER(RTAvlrPVGet)
# define RTAvlrPVGetBestFit                             RT_MANGLER(RTAvlrPVGetBestFit)
# define RTAvlrPVInsert                                 RT_MANGLER(RTAvlrPVInsert)
# define RTAvlrPVRangeGet                               RT_MANGLER(RTAvlrPVRangeGet)
# define RTAvlrPVRangeRemove                            RT_MANGLER(RTAvlrPVRangeRemove)
# define RTAvlrPVRemove                                 RT_MANGLER(RTAvlrPVRemove)
# define RTAvlrPVRemoveBestFit                          RT_MANGLER(RTAvlrPVRemoveBestFit)
# define RTAvlrU64Destroy                               RT_MANGLER(RTAvlrU64Destroy)
# define RTAvlrU64DoWithAll                             RT_MANGLER(RTAvlrU64DoWithAll)
# define RTAvlrU64Get                                   RT_MANGLER(RTAvlrU64Get)
# define RTAvlrU64GetBestFit                            RT_MANGLER(RTAvlrU64GetBestFit)
# define RTAvlrU64Insert                                RT_MANGLER(RTAvlrU64Insert)
# define RTAvlrU64RangeGet                              RT_MANGLER(RTAvlrU64RangeGet)
# define RTAvlrU64RangeRemove                           RT_MANGLER(RTAvlrU64RangeRemove)
# define RTAvlrU64Remove                                RT_MANGLER(RTAvlrU64Remove)
# define RTAvlrU64RemoveBestFit                         RT_MANGLER(RTAvlrU64RemoveBestFit)
# define RTAvlrUIntPtrDestroy                           RT_MANGLER(RTAvlrUIntPtrDestroy)
# define RTAvlrUIntPtrDoWithAll                         RT_MANGLER(RTAvlrUIntPtrDoWithAll)
# define RTAvlrUIntPtrGet                               RT_MANGLER(RTAvlrUIntPtrGet)
# define RTAvlrUIntPtrGetBestFit                        RT_MANGLER(RTAvlrUIntPtrGetBestFit)
# define RTAvlrUIntPtrGetLeft                           RT_MANGLER(RTAvlrUIntPtrGetLeft)
# define RTAvlrUIntPtrGetRight                          RT_MANGLER(RTAvlrUIntPtrGetRight)
# define RTAvlrUIntPtrGetRoot                           RT_MANGLER(RTAvlrUIntPtrGetRoot)
# define RTAvlrUIntPtrInsert                            RT_MANGLER(RTAvlrUIntPtrInsert)
# define RTAvlrUIntPtrRangeGet                          RT_MANGLER(RTAvlrUIntPtrRangeGet)
# define RTAvlrUIntPtrRangeRemove                       RT_MANGLER(RTAvlrUIntPtrRangeRemove)
# define RTAvlrUIntPtrRemove                            RT_MANGLER(RTAvlrUIntPtrRemove)
# define RTAvlU32Destroy                                RT_MANGLER(RTAvlU32Destroy)
# define RTAvlU32DoWithAll                              RT_MANGLER(RTAvlU32DoWithAll)
# define RTAvlU32Get                                    RT_MANGLER(RTAvlU32Get)
# define RTAvlU32GetBestFit                             RT_MANGLER(RTAvlU32GetBestFit)
# define RTAvlU32Insert                                 RT_MANGLER(RTAvlU32Insert)
# define RTAvlU32Remove                                 RT_MANGLER(RTAvlU32Remove)
# define RTAvlU32RemoveBestFit                          RT_MANGLER(RTAvlU32RemoveBestFit)
# define RTAvlUIntPtrDestroy                            RT_MANGLER(RTAvlUIntPtrDestroy)
# define RTAvlUIntPtrDoWithAll                          RT_MANGLER(RTAvlUIntPtrDoWithAll)
# define RTAvlUIntPtrGet                                RT_MANGLER(RTAvlUIntPtrGet)
# define RTAvlUIntPtrGetBestFit                         RT_MANGLER(RTAvlUIntPtrGetBestFit)
# define RTAvlUIntPtrGetLeft                            RT_MANGLER(RTAvlUIntPtrGetLeft)
# define RTAvlUIntPtrGetRight                           RT_MANGLER(RTAvlUIntPtrGetRight)
# define RTAvlUIntPtrGetRoot                            RT_MANGLER(RTAvlUIntPtrGetRoot)
# define RTAvlUIntPtrInsert                             RT_MANGLER(RTAvlUIntPtrInsert)
# define RTAvlUIntPtrRemove                             RT_MANGLER(RTAvlUIntPtrRemove)
# define RTAvlULDestroy                                 RT_MANGLER(RTAvlULDestroy)
# define RTAvlULDoWithAll                               RT_MANGLER(RTAvlULDoWithAll)
# define RTAvlULGet                                     RT_MANGLER(RTAvlULGet)
# define RTAvlULGetBestFit                              RT_MANGLER(RTAvlULGetBestFit)
# define RTAvlULInsert                                  RT_MANGLER(RTAvlULInsert)
# define RTAvlULRemove                                  RT_MANGLER(RTAvlULRemove)
# define RTAvlULRemoveBestFit                           RT_MANGLER(RTAvlULRemoveBestFit)
# define RTBase64Decode                                 RT_MANGLER(RTBase64Decode)
# define RTBase64DecodedSize                            RT_MANGLER(RTBase64DecodedSize)
# define RTBase64Encode                                 RT_MANGLER(RTBase64Encode)
# define RTBase64EncodedLength                          RT_MANGLER(RTBase64EncodedLength)
# define RTBldCfgCompiler                               RT_MANGLER(RTBldCfgCompiler)
# define RTBldCfgRevision                               RT_MANGLER(RTBldCfgRevision)
# define RTBldCfgRevisionStr                            RT_MANGLER(RTBldCfgRevisionStr)
# define RTBldCfgTarget                                 RT_MANGLER(RTBldCfgTarget)
# define RTBldCfgTargetArch                             RT_MANGLER(RTBldCfgTargetArch)
# define RTBldCfgTargetDotArch                          RT_MANGLER(RTBldCfgTargetDotArch)
# define RTBldCfgType                                   RT_MANGLER(RTBldCfgType)
# define RTBldCfgVersion                                RT_MANGLER(RTBldCfgVersion)
# define RTBldCfgVersionBuild                           RT_MANGLER(RTBldCfgVersionBuild)
# define RTBldCfgVersionMajor                           RT_MANGLER(RTBldCfgVersionMajor)
# define RTBldCfgVersionMinor                           RT_MANGLER(RTBldCfgVersionMinor)
# define RTCdromOpen                                    RT_MANGLER(RTCdromOpen)
# define RTCdromRetain                                  RT_MANGLER(RTCdromRetain)
# define RTCdromRelease                                 RT_MANGLER(RTCdromRelease)
# define RTCdromQueryMountPoint                         RT_MANGLER(RTCdromQueryMountPoint)
# define RTCdromUnmount                                 RT_MANGLER(RTCdromUnmount)
# define RTCdromEject                                   RT_MANGLER(RTCdromEject)
# define RTCdromLock                                    RT_MANGLER(RTCdromLock)
# define RTCdromUnlock                                  RT_MANGLER(RTCdromUnlock)
# define RTCdromCount                                   RT_MANGLER(RTCdromCount)
# define RTCdromOrdinalToName                           RT_MANGLER(RTCdromOrdinalToName)
# define RTCdromOpenByOrdinal                           RT_MANGLER(RTCdromOpenByOrdinal)
# define RTCidrStrToIPv4                                RT_MANGLER(RTCidrStrToIPv4)
# define RTCircBufAcquireReadBlock                      RT_MANGLER(RTCircBufAcquireReadBlock)
# define RTCircBufAcquireWriteBlock                     RT_MANGLER(RTCircBufAcquireWriteBlock)
# define RTCircBufCreate                                RT_MANGLER(RTCircBufCreate)
# define RTCircBufDestroy                               RT_MANGLER(RTCircBufDestroy)
# define RTCircBufFree                                  RT_MANGLER(RTCircBufFree)
# define RTCircBufIsReading                             RT_MANGLER(RTCircBufIsReading)
# define RTCircBufIsWriting                             RT_MANGLER(RTCircBufIsWriting)
# define RTCircBufReleaseReadBlock                      RT_MANGLER(RTCircBufReleaseReadBlock)
# define RTCircBufReleaseWriteBlock                     RT_MANGLER(RTCircBufReleaseWriteBlock)
# define RTCircBufReset                                 RT_MANGLER(RTCircBufReset)
# define RTCircBufSize                                  RT_MANGLER(RTCircBufSize)
# define RTCircBufUsed                                  RT_MANGLER(RTCircBufUsed)
# define RTCoreDumperDisable                            RT_MANGLER(RTCoreDumperDisable)  /* solaris */
# define RTCoreDumperSetup                              RT_MANGLER(RTCoreDumperSetup)    /* solaris */
# define RTCoreDumperTakeDump                           RT_MANGLER(RTCoreDumperTakeDump) /* solaris */
# define RTCrc32                                        RT_MANGLER(RTCrc32)
# define RTCrc32Finish                                  RT_MANGLER(RTCrc32Finish)
# define RTCrc32Process                                 RT_MANGLER(RTCrc32Process)
# define RTCrc32Start                                   RT_MANGLER(RTCrc32Start)
# define RTCrc64                                        RT_MANGLER(RTCrc64)
# define RTCrc64Finish                                  RT_MANGLER(RTCrc64Finish)
# define RTCrc64Process                                 RT_MANGLER(RTCrc64Process)
# define RTCrc64Start                                   RT_MANGLER(RTCrc64Start)
# define RTCrcAdler32                                   RT_MANGLER(RTCrcAdler32)
# define RTCrcAdler32Finish                             RT_MANGLER(RTCrcAdler32Finish)
# define RTCrcAdler32Process                            RT_MANGLER(RTCrcAdler32Process)
# define RTCrcAdler32Start                              RT_MANGLER(RTCrcAdler32Start)
# define RTCritSectDelete                               RT_MANGLER(RTCritSectDelete)
# define RTCritSectEnter                                RT_MANGLER(RTCritSectEnter)
# define RTCritSectEnterDebug                           RT_MANGLER(RTCritSectEnterDebug)
# define RTCritSectEnterMultiple                        RT_MANGLER(RTCritSectEnterMultiple)
# define RTCritSectEnterMultipleDebug                   RT_MANGLER(RTCritSectEnterMultipleDebug)
# define RTCritSectInit                                 RT_MANGLER(RTCritSectInit)
# define RTCritSectInitEx                               RT_MANGLER(RTCritSectInitEx)
# define RTCritSectLeave                                RT_MANGLER(RTCritSectLeave)
# define RTCritSectLeaveMultiple                        RT_MANGLER(RTCritSectLeaveMultiple)
# define RTCritSectSetSubClass                          RT_MANGLER(RTCritSectSetSubClass)
# define RTCritSectTryEnter                             RT_MANGLER(RTCritSectTryEnter)
# define RTCritSectTryEnterDebug                        RT_MANGLER(RTCritSectTryEnterDebug)
# define RTDbgAsCreate                                  RT_MANGLER(RTDbgAsCreate)
# define RTDbgAsCreateF                                 RT_MANGLER(RTDbgAsCreateF)
# define RTDbgAsCreateV                                 RT_MANGLER(RTDbgAsCreateV)
# define RTDbgAsFirstAddr                               RT_MANGLER(RTDbgAsFirstAddr)
# define RTDbgAsLastAddr                                RT_MANGLER(RTDbgAsLastAddr)
# define RTDbgAsLineAdd                                 RT_MANGLER(RTDbgAsLineAdd)
# define RTDbgAsLineByAddr                              RT_MANGLER(RTDbgAsLineByAddr)
# define RTDbgAsLineByAddrA                             RT_MANGLER(RTDbgAsLineByAddrA)
# define RTDbgAsModuleByAddr                            RT_MANGLER(RTDbgAsModuleByAddr)
# define RTDbgAsModuleByIndex                           RT_MANGLER(RTDbgAsModuleByIndex)
# define RTDbgAsModuleByName                            RT_MANGLER(RTDbgAsModuleByName)
# define RTDbgAsModuleCount                             RT_MANGLER(RTDbgAsModuleCount)
# define RTDbgAsModuleLink                              RT_MANGLER(RTDbgAsModuleLink)
# define RTDbgAsModuleLinkSeg                           RT_MANGLER(RTDbgAsModuleLinkSeg)
# define RTDbgAsModuleQueryMapByIndex                   RT_MANGLER(RTDbgAsModuleQueryMapByIndex)
# define RTDbgAsModuleUnlink                            RT_MANGLER(RTDbgAsModuleUnlink)
# define RTDbgAsModuleUnlinkByAddr                      RT_MANGLER(RTDbgAsModuleUnlinkByAddr)
# define RTDbgAsName                                    RT_MANGLER(RTDbgAsName)
# define RTDbgAsRelease                                 RT_MANGLER(RTDbgAsRelease)
# define RTDbgAsRetain                                  RT_MANGLER(RTDbgAsRetain)
# define RTDbgAsSymbolAdd                               RT_MANGLER(RTDbgAsSymbolAdd)
# define RTDbgAsSymbolByAddr                            RT_MANGLER(RTDbgAsSymbolByAddr)
# define RTDbgAsSymbolByAddrA                           RT_MANGLER(RTDbgAsSymbolByAddrA)
# define RTDbgAsSymbolByName                            RT_MANGLER(RTDbgAsSymbolByName)
# define RTDbgAsSymbolByNameA                           RT_MANGLER(RTDbgAsSymbolByNameA)
# define RTDbgLineAlloc                                 RT_MANGLER(RTDbgLineAlloc)
# define RTDbgLineDup                                   RT_MANGLER(RTDbgLineDup)
# define RTDbgLineFree                                  RT_MANGLER(RTDbgLineFree)
# define RTDbgModCreate                                 RT_MANGLER(RTDbgModCreate)
# define RTDbgModCreateDeferred                         RT_MANGLER(RTDbgModCreateDeferred)
# define RTDbgModCreateFromImage                        RT_MANGLER(RTDbgModCreateFromImage)
# define RTDbgModCreateFromMap                          RT_MANGLER(RTDbgModCreateFromMap)
# define RTDbgModGetTag                                 RT_MANGLER(RTDbgModGetTag)
# define RTDbgModImageSize                              RT_MANGLER(RTDbgModImageSize)
# define RTDbgModLineAdd                                RT_MANGLER(RTDbgModLineAdd)
# define RTDbgModLineByAddr                             RT_MANGLER(RTDbgModLineByAddr)
# define RTDbgModLineByAddrA                            RT_MANGLER(RTDbgModLineByAddrA)
# define RTDbgModLineByOrdinal                          RT_MANGLER(RTDbgModLineByOrdinal)
# define RTDbgModLineByOrdinalA                         RT_MANGLER(RTDbgModLineByOrdinalA)
# define RTDbgModLineCount                              RT_MANGLER(RTDbgModLineCount)
# define RTDbgModName                                   RT_MANGLER(RTDbgModName)
# define RTDbgModRelease                                RT_MANGLER(RTDbgModRelease)
# define RTDbgModRetain                                 RT_MANGLER(RTDbgModRetain)
# define RTDbgModRvaToSegOff                            RT_MANGLER(RTDbgModRvaToSegOff)
# define RTDbgModSegmentAdd                             RT_MANGLER(RTDbgModSegmentAdd)
# define RTDbgModSegmentByIndex                         RT_MANGLER(RTDbgModSegmentByIndex)
# define RTDbgModSegmentCount                           RT_MANGLER(RTDbgModSegmentCount)
# define RTDbgModSegmentRva                             RT_MANGLER(RTDbgModSegmentRva)
# define RTDbgModSegmentSize                            RT_MANGLER(RTDbgModSegmentSize)
# define RTDbgModSetTag                                 RT_MANGLER(RTDbgModSetTag)
# define RTDbgModSymbolAdd                              RT_MANGLER(RTDbgModSymbolAdd)
# define RTDbgModSymbolByAddr                           RT_MANGLER(RTDbgModSymbolByAddr)
# define RTDbgModSymbolByAddrA                          RT_MANGLER(RTDbgModSymbolByAddrA)
# define RTDbgModSymbolByName                           RT_MANGLER(RTDbgModSymbolByName)
# define RTDbgModSymbolByNameA                          RT_MANGLER(RTDbgModSymbolByNameA)
# define RTDbgModSymbolByOrdinal                        RT_MANGLER(RTDbgModSymbolByOrdinal)
# define RTDbgModSymbolByOrdinalA                       RT_MANGLER(RTDbgModSymbolByOrdinalA)
# define RTDbgModSymbolCount                            RT_MANGLER(RTDbgModSymbolCount)
# define RTDbgSymbolAlloc                               RT_MANGLER(RTDbgSymbolAlloc)
# define RTDbgSymbolDup                                 RT_MANGLER(RTDbgSymbolDup)
# define RTDbgSymbolFree                                RT_MANGLER(RTDbgSymbolFree)
# define RTDirClose                                     RT_MANGLER(RTDirClose)
# define RTDirCreate                                    RT_MANGLER(RTDirCreate)
# define RTDirCreateFullPath                            RT_MANGLER(RTDirCreateFullPath)
# define RTDirCreateTemp                                RT_MANGLER(RTDirCreateTemp)
# define RTDirCreateUniqueNumbered                      RT_MANGLER(RTDirCreateUniqueNumbered)
# define RTDirExists                                    RT_MANGLER(RTDirExists)
# define RTDirFlush                                     RT_MANGLER(RTDirFlush)
# define RTDirFlushParent                               RT_MANGLER(RTDirFlushParent)
# define RTDirOpen                                      RT_MANGLER(RTDirOpen)
# define RTDirOpenFiltered                              RT_MANGLER(RTDirOpenFiltered)
# define RTDirQueryInfo                                 RT_MANGLER(RTDirQueryInfo)
# define RTDirRead                                      RT_MANGLER(RTDirRead)
# define RTDirReadEx                                    RT_MANGLER(RTDirReadEx)
# define RTDirRemove                                    RT_MANGLER(RTDirRemove)
# define RTDirRemoveRecursive                           RT_MANGLER(RTDirRemoveRecursive)
# define RTDirRename                                    RT_MANGLER(RTDirRename)
# define RTDirSetTimes                                  RT_MANGLER(RTDirSetTimes)
# define RTDvmCreate                                    RT_MANGLER(RTDvmCreate)
# define RTDvmRetain                                    RT_MANGLER(RTDvmRetain)
# define RTDvmRelease                                   RT_MANGLER(RTDvmRelease)
# define RTDvmMapOpen                                   RT_MANGLER(RTDvmMapOpen)
# define RTDvmMapInitialize                             RT_MANGLER(RTDvmMapInitialize)
# define RTDvmMapGetFormat                              RT_MANGLER(RTDvmMapGetFormat)
# define RTDvmMapGetValidVolumes                        RT_MANGLER(RTDvmMapGetValidVolumes)
# define RTDvmMapGetMaxVolumes                          RT_MANGLER(RTDvmMapGetMaxVolumes)
# define RTDvmMapQueryBlockStatus                       RT_MANGLER(RTDvmMapQueryBlockStatus)
# define RTDvmMapQueryFirstVolume                       RT_MANGLER(RTDvmMapQueryFirstVolume)
# define RTDvmMapQueryNextVolume                        RT_MANGLER(RTDvmMapQueryNextVolume)
# define RTDvmVolumeRetain                              RT_MANGLER(RTDvmVolumeRetain)
# define RTDvmVolumeRelease                             RT_MANGLER(RTDvmVolumeRelease)
# define RTDvmVolumeGetSize                             RT_MANGLER(RTDvmVolumeGetSize)
# define RTDvmVolumeQueryName                           RT_MANGLER(RTDvmVolumeQueryName)
# define RTDvmVolumeGetType                             RT_MANGLER(RTDvmVolumeGetType)
# define RTDvmVolumeGetFlags                            RT_MANGLER(RTDvmVolumeGetFlags)
# define RTDvmVolumeRead                                RT_MANGLER(RTDvmVolumeRead)
# define RTDvmVolumeWrite                               RT_MANGLER(RTDvmVolumeWrite)
# define RTDvmVolumeSetQueryBlockStatusCallback         RT_MANGLER(RTDvmVolumeSetQueryBlockStatusCallback)
# define RTDvmVolumeTypeGetDescr                        RT_MANGLER(RTDvmVolumeTypeGetDescr)
# define RTDvmVolumeCreateVfsFile                       RT_MANGLER(RTDvmVolumeCreateVfsFile)
# define RTEnvClone                                     RT_MANGLER(RTEnvClone)
# define RTEnvCreate                                    RT_MANGLER(RTEnvCreate)
# define RTEnvDestroy                                   RT_MANGLER(RTEnvDestroy)
# define RTEnvDupEx                                     RT_MANGLER(RTEnvDupEx)
# define RTEnvExist                                     RT_MANGLER(RTEnvExist)
# define RTEnvExistEx                                   RT_MANGLER(RTEnvExistEx)
# define RTEnvFreeUtf16Block                            RT_MANGLER(RTEnvFreeUtf16Block)
# define RTEnvGet                                       RT_MANGLER(RTEnvGet)
# define RTEnvGetEx                                     RT_MANGLER(RTEnvGetEx)
# define RTEnvGetExecEnvP                               RT_MANGLER(RTEnvGetExecEnvP)
# define RTEnvPut                                       RT_MANGLER(RTEnvPut)
# define RTEnvPutEx                                     RT_MANGLER(RTEnvPutEx)
# define RTEnvQueryUtf16Block                           RT_MANGLER(RTEnvQueryUtf16Block)
# define RTEnvSet                                       RT_MANGLER(RTEnvSet)
# define RTEnvSetEx                                     RT_MANGLER(RTEnvSetEx)
# define RTEnvUnset                                     RT_MANGLER(RTEnvUnset)
# define RTEnvUnsetEx                                   RT_MANGLER(RTEnvUnsetEx)
# define RTErrCOMGet                                    RT_MANGLER(RTErrCOMGet)
# define RTErrConvertFromErrno                          RT_MANGLER(RTErrConvertFromErrno)
# define RTErrConvertToErrno                            RT_MANGLER(RTErrConvertToErrno)
# define RTErrGet                                       RT_MANGLER(RTErrGet)
# define RTErrInfoAlloc                                 RT_MANGLER(RTErrInfoAlloc)
# define RTErrInfoAllocEx                               RT_MANGLER(RTErrInfoAllocEx)
# define RTErrInfoFree                                  RT_MANGLER(RTErrInfoFree)
# define RTErrInfoSet                                   RT_MANGLER(RTErrInfoSet)
# define RTErrInfoSetF                                  RT_MANGLER(RTErrInfoSetF)
# define RTErrInfoSetV                                  RT_MANGLER(RTErrInfoSetV)
# define RTErrVarsAreEqual                              RT_MANGLER(RTErrVarsAreEqual)
# define RTErrVarsHaveChanged                           RT_MANGLER(RTErrVarsHaveChanged)
# define RTErrVarsRestore                               RT_MANGLER(RTErrVarsRestore)
# define RTErrVarsSave                                  RT_MANGLER(RTErrVarsSave)
# define RTFileAioCtxAssociateWithFile                  RT_MANGLER(RTFileAioCtxAssociateWithFile)
# define RTFileAioCtxCreate                             RT_MANGLER(RTFileAioCtxCreate)
# define RTFileAioCtxDestroy                            RT_MANGLER(RTFileAioCtxDestroy)
# define RTFileAioCtxGetMaxReqCount                     RT_MANGLER(RTFileAioCtxGetMaxReqCount)
# define RTFileAioCtxSubmit                             RT_MANGLER(RTFileAioCtxSubmit)
# define RTFileAioCtxWait                               RT_MANGLER(RTFileAioCtxWait)
# define RTFileAioCtxWakeup                             RT_MANGLER(RTFileAioCtxWakeup)
# define RTFileAioGetLimits                             RT_MANGLER(RTFileAioGetLimits)
# define RTFileAioReqCancel                             RT_MANGLER(RTFileAioReqCancel)
# define RTFileAioReqCreate                             RT_MANGLER(RTFileAioReqCreate)
# define RTFileAioReqDestroy                            RT_MANGLER(RTFileAioReqDestroy)
# define RTFileAioReqGetRC                              RT_MANGLER(RTFileAioReqGetRC)
# define RTFileAioReqGetUser                            RT_MANGLER(RTFileAioReqGetUser)
# define RTFileAioReqPrepareFlush                       RT_MANGLER(RTFileAioReqPrepareFlush)
# define RTFileAioReqPrepareRead                        RT_MANGLER(RTFileAioReqPrepareRead)
# define RTFileAioReqPrepareWrite                       RT_MANGLER(RTFileAioReqPrepareWrite)
# define RTFileChangeLock                               RT_MANGLER(RTFileChangeLock)
# define RTFileClose                                    RT_MANGLER(RTFileClose)
# define RTFileCopy                                     RT_MANGLER(RTFileCopy)
# define RTFileCopyByHandles                            RT_MANGLER(RTFileCopyByHandles)
# define RTFileCopyByHandlesEx                          RT_MANGLER(RTFileCopyByHandlesEx)
# define RTFileCopyEx                                   RT_MANGLER(RTFileCopyEx)
# define RTFileDelete                                   RT_MANGLER(RTFileDelete)
# define RTFileExists                                   RT_MANGLER(RTFileExists)
# define RTFileFlush                                    RT_MANGLER(RTFileFlush)
# define RTFileFromNative                               RT_MANGLER(RTFileFromNative)
# define RTFileGetMaxSize                               RT_MANGLER(RTFileGetMaxSize)
# define RTFileGetMaxSizeEx                             RT_MANGLER(RTFileGetMaxSizeEx)
# define RTFileGetSize                                  RT_MANGLER(RTFileGetSize)
# define RTFileIoCtl                                    RT_MANGLER(RTFileIoCtl)
# define RTFileIsValid                                  RT_MANGLER(RTFileIsValid)
# define RTFileLock                                     RT_MANGLER(RTFileLock)
# define RTFileMove                                     RT_MANGLER(RTFileMove)
# define RTFileOpen                                     RT_MANGLER(RTFileOpen)
# define RTFileOpenBitBucket                            RT_MANGLER(RTFileOpenBitBucket)
# define RTFileOpenF                                    RT_MANGLER(RTFileOpenF)
# define RTFileOpenV                                    RT_MANGLER(RTFileOpenV)
# define RTFileQueryFsSizes                             RT_MANGLER(RTFileQueryFsSizes)
# define RTFileQueryInfo                                RT_MANGLER(RTFileQueryInfo)
# define RTFileQuerySize                                RT_MANGLER(RTFileQuerySize)
# define RTFileRead                                     RT_MANGLER(RTFileRead)
# define RTFileReadAll                                  RT_MANGLER(RTFileReadAll)
# define RTFileReadAllByHandle                          RT_MANGLER(RTFileReadAllByHandle)
# define RTFileReadAllByHandleEx                        RT_MANGLER(RTFileReadAllByHandleEx)
# define RTFileReadAllEx                                RT_MANGLER(RTFileReadAllEx)
# define RTFileReadAllFree                              RT_MANGLER(RTFileReadAllFree)
# define RTFileReadAt                                   RT_MANGLER(RTFileReadAt)
# define RTFileRename                                   RT_MANGLER(RTFileRename)
# define RTFileSeek                                     RT_MANGLER(RTFileSeek)
# define RTFileSetForceFlags                            RT_MANGLER(RTFileSetForceFlags)
# define RTFileSetMode                                  RT_MANGLER(RTFileSetMode)
# define RTFileSetSize                                  RT_MANGLER(RTFileSetSize)
# define RTFileSetTimes                                 RT_MANGLER(RTFileSetTimes)
# define RTFileTell                                     RT_MANGLER(RTFileTell)
# define RTFileToNative                                 RT_MANGLER(RTFileToNative)
# define RTFileUnlock                                   RT_MANGLER(RTFileUnlock)
# define RTFileWrite                                    RT_MANGLER(RTFileWrite)
# define RTFileWriteAt                                  RT_MANGLER(RTFileWriteAt)
# define RTFilesystemVfsFromFile                        RT_MANGLER(RTFilesystemVfsFromFile)
# define RTFsQueryProperties                            RT_MANGLER(RTFsQueryProperties)
# define RTFsQuerySerial                                RT_MANGLER(RTFsQuerySerial)
# define RTFsQuerySizes                                 RT_MANGLER(RTFsQuerySizes)
# define RTFsQueryType                                  RT_MANGLER(RTFsQueryType)
# define RTFsTypeName                                   RT_MANGLER(RTFsTypeName)
# define RTGetOpt                                       RT_MANGLER(RTGetOpt)
# define RTGetOptArgvFree                               RT_MANGLER(RTGetOptArgvFree)
# define RTGetOptArgvFromString                         RT_MANGLER(RTGetOptArgvFromString)
# define RTGetOptArgvToString                           RT_MANGLER(RTGetOptArgvToString)
# define RTGetOptArgvToUtf16String                      RT_MANGLER(RTGetOptArgvToUtf16String)
# define RTGetOptFetchValue                             RT_MANGLER(RTGetOptFetchValue)
# define RTGetOptInit                                   RT_MANGLER(RTGetOptInit)
# define RTGetOptPrintError                             RT_MANGLER(RTGetOptPrintError)
# define RTHandleClose                                  RT_MANGLER(RTHandleClose)
# define RTHandleGetStandard                            RT_MANGLER(RTHandleGetStandard)
# define RTHandleTableAlloc                             RT_MANGLER(RTHandleTableAlloc)
# define RTHandleTableAllocWithCtx                      RT_MANGLER(RTHandleTableAllocWithCtx)
# define RTHandleTableCreate                            RT_MANGLER(RTHandleTableCreate)
# define RTHandleTableCreateEx                          RT_MANGLER(RTHandleTableCreateEx)
# define RTHandleTableDestroy                           RT_MANGLER(RTHandleTableDestroy)
# define RTHandleTableFree                              RT_MANGLER(RTHandleTableFree)
# define RTHandleTableFreeWithCtx                       RT_MANGLER(RTHandleTableFreeWithCtx)
# define RTHandleTableLookup                            RT_MANGLER(RTHandleTableLookup)
# define RTHandleTableLookupWithCtx                     RT_MANGLER(RTHandleTableLookupWithCtx)
# define RTHeapOffsetAlloc                              RT_MANGLER(RTHeapOffsetAlloc)
# define RTHeapOffsetAllocZ                             RT_MANGLER(RTHeapOffsetAllocZ)
# define RTHeapOffsetDump                               RT_MANGLER(RTHeapOffsetDump)
# define RTHeapOffsetFree                               RT_MANGLER(RTHeapOffsetFree)
# define RTHeapOffsetGetFreeSize                        RT_MANGLER(RTHeapOffsetGetFreeSize)
# define RTHeapOffsetGetHeapSize                        RT_MANGLER(RTHeapOffsetGetHeapSize)
# define RTHeapOffsetInit                               RT_MANGLER(RTHeapOffsetInit)
# define RTHeapOffsetSize                               RT_MANGLER(RTHeapOffsetSize)
# define RTHeapSimpleAlloc                              RT_MANGLER(RTHeapSimpleAlloc)
# define RTHeapSimpleAllocZ                             RT_MANGLER(RTHeapSimpleAllocZ)
# define RTHeapSimpleDump                               RT_MANGLER(RTHeapSimpleDump)
# define RTHeapSimpleFree                               RT_MANGLER(RTHeapSimpleFree)
# define RTHeapSimpleGetFreeSize                        RT_MANGLER(RTHeapSimpleGetFreeSize)
# define RTHeapSimpleGetHeapSize                        RT_MANGLER(RTHeapSimpleGetHeapSize)
# define RTHeapSimpleInit                               RT_MANGLER(RTHeapSimpleInit)
# define RTHeapSimpleRelocate                           RT_MANGLER(RTHeapSimpleRelocate)
# define RTHeapSimpleSize                               RT_MANGLER(RTHeapSimpleSize)
# define RTIsoFsClose                                   RT_MANGLER(RTIsoFsClose)
# define RTIsoFsExtractFile                             RT_MANGLER(RTIsoFsExtractFile)
# define RTIsoFsGetFileInfo                             RT_MANGLER(RTIsoFsGetFileInfo)
# define RTIsoFsOpen                                    RT_MANGLER(RTIsoFsOpen)
# define RTLatin1CalcUtf16Len                           RT_MANGLER(RTLatin1CalcUtf16Len)
# define RTLatin1CalcUtf16LenEx                         RT_MANGLER(RTLatin1CalcUtf16LenEx)
# define RTLatin1CalcUtf8Len                            RT_MANGLER(RTLatin1CalcUtf8Len)
# define RTLatin1CalcUtf8LenEx                          RT_MANGLER(RTLatin1CalcUtf8LenEx)
# define RTLatin1ToUtf16ExTag                           RT_MANGLER(RTLatin1ToUtf16ExTag)
# define RTLatin1ToUtf16Tag                             RT_MANGLER(RTLatin1ToUtf16Tag)
# define RTLatin1ToUtf8ExTag                            RT_MANGLER(RTLatin1ToUtf8ExTag)
# define RTLatin1ToUtf8Tag                              RT_MANGLER(RTLatin1ToUtf8Tag)
# define RTLdrClose                                     RT_MANGLER(RTLdrClose)
# define RTLdrEnumDbgInfo                               RT_MANGLER(RTLdrEnumDbgInfo)
# define RTLdrEnumSegments                              RT_MANGLER(RTLdrEnumSegments)
# define RTLdrEnumSymbols                               RT_MANGLER(RTLdrEnumSymbols)
# define RTLdrGetBits                                   RT_MANGLER(RTLdrGetBits)
# define RTLdrGetSuff                                   RT_MANGLER(RTLdrGetSuff)
# define RTLdrGetSymbol                                 RT_MANGLER(RTLdrGetSymbol)
# define RTLdrGetSymbolEx                               RT_MANGLER(RTLdrGetSymbolEx)
# define RTLdrIsLoadable                                RT_MANGLER(RTLdrIsLoadable)
# define RTLdrLinkAddressToRva                          RT_MANGLER(RTLdrLinkAddressToRva)
# define RTLdrLinkAddressToSegOffset                    RT_MANGLER(RTLdrLinkAddressToSegOffset)
# define RTLdrLoad                                      RT_MANGLER(RTLdrLoad)
# define RTLdrLoadAppPriv                               RT_MANGLER(RTLdrLoadAppPriv)
# define RTLdrLoadEx                                    RT_MANGLER(RTLdrLoadEx)
# define RTLdrOpen                                      RT_MANGLER(RTLdrOpen)
# define RTLdrOpenkLdr                                  RT_MANGLER(RTLdrOpenkLdr)
# define RTLdrRelocate                                  RT_MANGLER(RTLdrRelocate)
# define RTLdrRvaToSegOffset                            RT_MANGLER(RTLdrRvaToSegOffset)
# define RTLdrSegOffsetToRva                            RT_MANGLER(RTLdrSegOffsetToRva)
# define RTLdrSize                                      RT_MANGLER(RTLdrSize)
# define RTLinuxFindDevicePath                          RT_MANGLER(RTLinuxFindDevicePath)
# define RTLinuxFindDevicePathV                         RT_MANGLER(RTLinuxFindDevicePathV)
# define RTLinuxSysFsClose                              RT_MANGLER(RTLinuxSysFsClose)
# define RTLinuxSysFsExists                             RT_MANGLER(RTLinuxSysFsExists)
# define RTLinuxSysFsExistsV                            RT_MANGLER(RTLinuxSysFsExistsV)
# define RTLinuxSysFsGetLinkDest                        RT_MANGLER(RTLinuxSysFsGetLinkDest)
# define RTLinuxSysFsGetLinkDestV                       RT_MANGLER(RTLinuxSysFsGetLinkDestV)
# define RTLinuxSysFsOpen                               RT_MANGLER(RTLinuxSysFsOpen)
# define RTLinuxSysFsOpenV                              RT_MANGLER(RTLinuxSysFsOpenV)
# define RTLinuxSysFsReadDevNumFile                     RT_MANGLER(RTLinuxSysFsReadDevNumFile)
# define RTLinuxSysFsReadDevNumFileV                    RT_MANGLER(RTLinuxSysFsReadDevNumFileV)
# define RTLinuxSysFsReadFile                           RT_MANGLER(RTLinuxSysFsReadFile)
# define RTLinuxSysFsReadIntFile                        RT_MANGLER(RTLinuxSysFsReadIntFile)
# define RTLinuxSysFsReadIntFileV                       RT_MANGLER(RTLinuxSysFsReadIntFileV)
# define RTLinuxSysFsReadStr                            RT_MANGLER(RTLinuxSysFsReadStr)
# define RTLinuxSysFsReadStrFile                        RT_MANGLER(RTLinuxSysFsReadStrFile)
# define RTLinuxSysFsReadStrFileV                       RT_MANGLER(RTLinuxSysFsReadStrFileV)
# define RTLockValidatorClassAddPriorClass              RT_MANGLER(RTLockValidatorClassAddPriorClass)
# define RTLockValidatorClassCreate                     RT_MANGLER(RTLockValidatorClassCreate)
# define RTLockValidatorClassCreateEx                   RT_MANGLER(RTLockValidatorClassCreateEx)
# define RTLockValidatorClassCreateExV                  RT_MANGLER(RTLockValidatorClassCreateExV)
# define RTLockValidatorClassCreateUnique               RT_MANGLER(RTLockValidatorClassCreateUnique)
# define RTLockValidatorClassEnforceStrictReleaseOrder  RT_MANGLER(RTLockValidatorClassEnforceStrictReleaseOrder)
# define RTLockValidatorClassFindForSrcPos              RT_MANGLER(RTLockValidatorClassFindForSrcPos)
# define RTLockValidatorClassForSrcPos                  RT_MANGLER(RTLockValidatorClassForSrcPos)
# define RTLockValidatorClassRelease                    RT_MANGLER(RTLockValidatorClassRelease)
# define RTLockValidatorClassRetain                     RT_MANGLER(RTLockValidatorClassRetain)
# define RTLockValidatorHoldsLocksInClass               RT_MANGLER(RTLockValidatorHoldsLocksInClass)
# define RTLockValidatorHoldsLocksInSubClass            RT_MANGLER(RTLockValidatorHoldsLocksInSubClass)
# define RTLockValidatorIsBlockedThreadInValidator      RT_MANGLER(RTLockValidatorIsBlockedThreadInValidator)
# define RTLockValidatorIsEnabled                       RT_MANGLER(RTLockValidatorIsEnabled)
# define RTLockValidatorIsQuiet                         RT_MANGLER(RTLockValidatorIsQuiet)
# define RTLockValidatorMayPanic                        RT_MANGLER(RTLockValidatorMayPanic)
# define RTLockValidatorQueryBlocking                   RT_MANGLER(RTLockValidatorQueryBlocking)
# define RTLockValidatorReadLockDec                     RT_MANGLER(RTLockValidatorReadLockDec)
# define RTLockValidatorReadLockGetCount                RT_MANGLER(RTLockValidatorReadLockGetCount)
# define RTLockValidatorReadLockInc                     RT_MANGLER(RTLockValidatorReadLockInc)
# define RTLockValidatorRecExclCheckBlocking            RT_MANGLER(RTLockValidatorRecExclCheckBlocking)
# define RTLockValidatorRecExclCheckOrder               RT_MANGLER(RTLockValidatorRecExclCheckOrder)
# define RTLockValidatorRecExclCheckOrderAndBlocking    RT_MANGLER(RTLockValidatorRecExclCheckOrderAndBlocking)
# define RTLockValidatorRecExclCreate                   RT_MANGLER(RTLockValidatorRecExclCreate)
# define RTLockValidatorRecExclCreateV                  RT_MANGLER(RTLockValidatorRecExclCreateV)
# define RTLockValidatorRecExclDelete                   RT_MANGLER(RTLockValidatorRecExclDelete)
# define RTLockValidatorRecExclDestroy                  RT_MANGLER(RTLockValidatorRecExclDestroy)
# define RTLockValidatorRecExclInit                     RT_MANGLER(RTLockValidatorRecExclInit)
# define RTLockValidatorRecExclInitV                    RT_MANGLER(RTLockValidatorRecExclInitV)
# define RTLockValidatorRecExclRecursion                RT_MANGLER(RTLockValidatorRecExclRecursion)
# define RTLockValidatorRecExclRecursionMixed           RT_MANGLER(RTLockValidatorRecExclRecursionMixed)
# define RTLockValidatorRecExclReleaseOwner             RT_MANGLER(RTLockValidatorRecExclReleaseOwner)
# define RTLockValidatorRecExclReleaseOwnerUnchecked    RT_MANGLER(RTLockValidatorRecExclReleaseOwnerUnchecked)
# define RTLockValidatorRecExclSetOwner                 RT_MANGLER(RTLockValidatorRecExclSetOwner)
# define RTLockValidatorRecExclSetSubClass              RT_MANGLER(RTLockValidatorRecExclSetSubClass)
# define RTLockValidatorRecExclUnwind                   RT_MANGLER(RTLockValidatorRecExclUnwind)
# define RTLockValidatorRecExclUnwindMixed              RT_MANGLER(RTLockValidatorRecExclUnwindMixed)
# define RTLockValidatorRecMakeSiblings                 RT_MANGLER(RTLockValidatorRecMakeSiblings)
# define RTLockValidatorRecSharedAddOwner               RT_MANGLER(RTLockValidatorRecSharedAddOwner)
# define RTLockValidatorRecSharedCheckAndRelease        RT_MANGLER(RTLockValidatorRecSharedCheckAndRelease)
# define RTLockValidatorRecSharedCheckBlocking          RT_MANGLER(RTLockValidatorRecSharedCheckBlocking)
# define RTLockValidatorRecSharedCheckOrder             RT_MANGLER(RTLockValidatorRecSharedCheckOrder)
# define RTLockValidatorRecSharedCheckOrderAndBlocking  RT_MANGLER(RTLockValidatorRecSharedCheckOrderAndBlocking)
# define RTLockValidatorRecSharedCheckSignaller         RT_MANGLER(RTLockValidatorRecSharedCheckSignaller)
# define RTLockValidatorRecSharedDelete                 RT_MANGLER(RTLockValidatorRecSharedDelete)
# define RTLockValidatorRecSharedInit                   RT_MANGLER(RTLockValidatorRecSharedInit)
# define RTLockValidatorRecSharedInitV                  RT_MANGLER(RTLockValidatorRecSharedInitV)
# define RTLockValidatorRecSharedIsOwner                RT_MANGLER(RTLockValidatorRecSharedIsOwner)
# define RTLockValidatorRecSharedRemoveOwner            RT_MANGLER(RTLockValidatorRecSharedRemoveOwner)
# define RTLockValidatorRecSharedResetOwner             RT_MANGLER(RTLockValidatorRecSharedResetOwner)
# define RTLockValidatorRecSharedSetSubClass            RT_MANGLER(RTLockValidatorRecSharedSetSubClass)
# define RTLockValidatorSetEnabled                      RT_MANGLER(RTLockValidatorSetEnabled)
# define RTLockValidatorSetMayPanic                     RT_MANGLER(RTLockValidatorSetMayPanic)
# define RTLockValidatorSetQuiet                        RT_MANGLER(RTLockValidatorSetQuiet)
# define RTLockValidatorWriteLockDec                    RT_MANGLER(RTLockValidatorWriteLockDec)
# define RTLockValidatorWriteLockGetCount               RT_MANGLER(RTLockValidatorWriteLockGetCount)
# define RTLockValidatorWriteLockInc                    RT_MANGLER(RTLockValidatorWriteLockInc)
# define RTLogBackdoorPrintf                            RT_MANGLER(RTLogBackdoorPrintf) /* r0drv-guest */
# define RTLogBackdoorPrintfV                           RT_MANGLER(RTLogBackdoorPrintfV) /* r0drv-guest */
# define RTLogCalcSizeForR0                             RT_MANGLER(RTLogCalcSizeForR0)
# define RTLogCloneRC                                   RT_MANGLER(RTLogCloneRC)
# define RTLogComPrintf                                 RT_MANGLER(RTLogComPrintf)
# define RTLogComPrintfV                                RT_MANGLER(RTLogComPrintfV)
# define RTLogCopyGroupsAndFlagsForR0                   RT_MANGLER(RTLogCopyGroupsAndFlagsForR0)
# define RTLogCreate                                    RT_MANGLER(RTLogCreate)
# define RTLogCreateEx                                  RT_MANGLER(RTLogCreateEx)
# define RTLogCreateExV                                 RT_MANGLER(RTLogCreateExV)
# define RTLogCreateForR0                               RT_MANGLER(RTLogCreateForR0)
# define RTLogDefaultInit                               RT_MANGLER(RTLogDefaultInit)
# define RTLogDefaultInstance                           RT_MANGLER(RTLogDefaultInstance)
# define RTLogDestinations                              RT_MANGLER(RTLogDestinations)
# define RTLogDestroy                                   RT_MANGLER(RTLogDestroy)
# define RTLogFlags                                     RT_MANGLER(RTLogFlags)
# define RTLogFlush                                     RT_MANGLER(RTLogFlush)
# define RTLogFlushRC                                   RT_MANGLER(RTLogFlushRC)
# define RTLogFlushR0                                   RT_MANGLER(RTLogFlushR0)
# define RTLogFlushToLogger                             RT_MANGLER(RTLogFlushToLogger)
# define RTLogFormatV                                   RT_MANGLER(RTLogFormatV)
# define RTLogGetDefaultInstance                        RT_MANGLER(RTLogGetDefaultInstance)
# define RTLogGetDestinations                           RT_MANGLER(RTLogGetDestinations)
# define RTLogGetFlags                                  RT_MANGLER(RTLogGetFlags)
# define RTLogGetGroupSettings                          RT_MANGLER(RTLogGetGroupSettings)
# define RTLogGroupSettings                             RT_MANGLER(RTLogGroupSettings)
# define RTLogLogger                                    RT_MANGLER(RTLogLogger)
# define RTLogLoggerEx                                  RT_MANGLER(RTLogLoggerEx)
# define RTLogLoggerExV                                 RT_MANGLER(RTLogLoggerExV)
# define RTLogLoggerV                                   RT_MANGLER(RTLogLoggerV)
# define RTLogPrintf                                    RT_MANGLER(RTLogPrintf)
# define RTLogPrintfV                                   RT_MANGLER(RTLogPrintfV)
# define RTLogRelDefaultInstance                        RT_MANGLER(RTLogRelDefaultInstance)
# define RTLogRelLogger                                 RT_MANGLER(RTLogRelLogger)
# define RTLogRelLoggerV                                RT_MANGLER(RTLogRelLoggerV)
# define RTLogRelPrintf                                 RT_MANGLER(RTLogRelPrintf)
# define RTLogRelPrintfV                                RT_MANGLER(RTLogRelPrintfV)
# define RTLogRelSetBuffering                           RT_MANGLER(RTLogRelSetBuffering)
# define RTLogRelSetDefaultInstance                     RT_MANGLER(RTLogRelSetDefaultInstance)
# define RTLogSetBuffering                              RT_MANGLER(RTLogSetBuffering)
# define RTLogSetCustomPrefixCallback                   RT_MANGLER(RTLogSetCustomPrefixCallback)
# define RTLogSetCustomPrefixCallbackForR0              RT_MANGLER(RTLogSetCustomPrefixCallbackForR0)
# define RTLogSetDefaultInstance                        RT_MANGLER(RTLogSetDefaultInstance)
# define RTLogSetDefaultInstanceThread                  RT_MANGLER(RTLogSetDefaultInstanceThread) /* r0drv */
# define RTLogSetGroupLimit                             RT_MANGLER(RTLogSetGroupLimit)
# define RTLogWriteCom                                  RT_MANGLER(RTLogWriteCom)
# define RTLogWriteCom                                  RT_MANGLER(RTLogWriteCom)
# define RTLogWriteDebugger                             RT_MANGLER(RTLogWriteDebugger)
# define RTLogWriteStdErr                               RT_MANGLER(RTLogWriteStdErr)
# define RTLogWriteStdOut                               RT_MANGLER(RTLogWriteStdOut)
# define RTLogWriteUser                                 RT_MANGLER(RTLogWriteUser)
# define RTManifestCreate                               RT_MANGLER(RTManifestCreate)
# define RTManifestDup                                  RT_MANGLER(RTManifestDup)
# define RTManifestEntryAdd                             RT_MANGLER(RTManifestEntryAdd)
# define RTManifestEntryAddIoStream                     RT_MANGLER(RTManifestEntryAddIoStream)
# define RTManifestEntryAddPassthruIoStream             RT_MANGLER(RTManifestEntryAddPassthruIoStream)
# define RTManifestEntryExists                          RT_MANGLER(RTManifestEntryExists)
# define RTManifestEntryRemove                          RT_MANGLER(RTManifestEntryRemove)
# define RTManifestEntryQueryAttr                       RT_MANGLER(RTManifestEntryQueryAttr)
# define RTManifestEntrySetAttr                         RT_MANGLER(RTManifestEntrySetAttr)
# define RTManifestEntryUnsetAttr                       RT_MANGLER(RTManifestEntryUnsetAttr)
# define RTManifestEquals                               RT_MANGLER(RTManifestEquals)
# define RTManifestEqualsEx                             RT_MANGLER(RTManifestEqualsEx)
# define RTManifestPtIosAddEntryNow                     RT_MANGLER(RTManifestPtIosAddEntryNow)
# define RTManifestQueryAttr                            RT_MANGLER(RTManifestQueryAttr)
# define RTManifestReadStandard                         RT_MANGLER(RTManifestReadStandard)
# define RTManifestReadStandardEx                       RT_MANGLER(RTManifestReadStandardEx)
# define RTManifestReadStandardFromFile                 RT_MANGLER(RTManifestReadStandardFromFile)
# define RTManifestRelease                              RT_MANGLER(RTManifestRelease)
# define RTManifestRetain                               RT_MANGLER(RTManifestRetain)
# define RTManifestSetAttr                              RT_MANGLER(RTManifestSetAttr)
# define RTManifestUnsetAttr                            RT_MANGLER(RTManifestUnsetAttr)
# define RTManifestVerify                               RT_MANGLER(RTManifestVerify)
# define RTManifestVerifyFiles                          RT_MANGLER(RTManifestVerifyFiles)
# define RTManifestVerifyFilesBuf                       RT_MANGLER(RTManifestVerifyFilesBuf)
# define RTManifestWriteFiles                           RT_MANGLER(RTManifestWriteFiles)
# define RTManifestWriteFilesBuf                        RT_MANGLER(RTManifestWriteFilesBuf)
# define RTManifestWriteStandard                        RT_MANGLER(RTManifestWriteStandard)
# define RTManifestWriteStandardToFile                  RT_MANGLER(RTManifestWriteStandardToFile)
# define RTMd5                                          RT_MANGLER(RTMd5)
# define RTMd5Final                                     RT_MANGLER(RTMd5Final)
# define RTMd5FromString                                RT_MANGLER(RTMd5FromString)
# define RTMd5Init                                      RT_MANGLER(RTMd5Init)
# define RTMd5ToString                                  RT_MANGLER(RTMd5ToString)
# define RTMd5Update                                    RT_MANGLER(RTMd5Update)
# define RTMemAllocExTag                                RT_MANGLER(RTMemAllocExTag) /* r0drv */
# define RTMemAllocTag                                  RT_MANGLER(RTMemAllocTag)
# define RTMemAllocVarTag                               RT_MANGLER(RTMemAllocVarTag)
# define RTMemAllocZTag                                 RT_MANGLER(RTMemAllocZTag)
# define RTMemAllocZVarTag                              RT_MANGLER(RTMemAllocZVarTag)
# define RTMemCacheAlloc                                RT_MANGLER(RTMemCacheAlloc)
# define RTMemCacheAllocEx                              RT_MANGLER(RTMemCacheAllocEx)
# define RTMemCacheCreate                               RT_MANGLER(RTMemCacheCreate)
# define RTMemCacheDestroy                              RT_MANGLER(RTMemCacheDestroy)
# define RTMemCacheFree                                 RT_MANGLER(RTMemCacheFree)
# define RTMemContAlloc                                 RT_MANGLER(RTMemContAlloc) /* r0drv */
# define RTMemContFree                                  RT_MANGLER(RTMemContFree) /* r0drv */
# define RTMemDump                                      RT_MANGLER(RTMemDump)
# define RTMemDupExTag                                  RT_MANGLER(RTMemDupExTag)
# define RTMemDupTag                                    RT_MANGLER(RTMemDupTag)
# define RTMemEfAlloc                                   RT_MANGLER(RTMemEfAlloc)
# define RTMemEfAllocNP                                 RT_MANGLER(RTMemEfAllocNP)
# define RTMemEfAllocVar                                RT_MANGLER(RTMemEfAllocVar)
# define RTMemEfAllocVarNP                              RT_MANGLER(RTMemEfAllocVarNP)
# define RTMemEfAllocZ                                  RT_MANGLER(RTMemEfAllocZ)
# define RTMemEfAllocZNP                                RT_MANGLER(RTMemEfAllocZNP)
# define RTMemEfAllocZVar                               RT_MANGLER(RTMemEfAllocZVar)
# define RTMemEfAllocZVarNP                             RT_MANGLER(RTMemEfAllocZVarNP)
# define RTMemEfDup                                     RT_MANGLER(RTMemEfDup)
# define RTMemEfDupEx                                   RT_MANGLER(RTMemEfDupEx)
# define RTMemEfDupExNP                                 RT_MANGLER(RTMemEfDupExNP)
# define RTMemEfDupNP                                   RT_MANGLER(RTMemEfDupNP)
# define RTMemEfFree                                    RT_MANGLER(RTMemEfFree)
# define RTMemEfFreeNP                                  RT_MANGLER(RTMemEfFreeNP)
# define RTMemEfRealloc                                 RT_MANGLER(RTMemEfRealloc)
# define RTMemEfReallocNP                               RT_MANGLER(RTMemEfReallocNP)
# define RTMemEfTmpAlloc                                RT_MANGLER(RTMemEfTmpAlloc)
# define RTMemEfTmpAllocNP                              RT_MANGLER(RTMemEfTmpAllocNP)
# define RTMemEfTmpAllocZ                               RT_MANGLER(RTMemEfTmpAllocZ)
# define RTMemEfTmpAllocZNP                             RT_MANGLER(RTMemEfTmpAllocZNP)
# define RTMemEfTmpFree                                 RT_MANGLER(RTMemEfTmpFree)
# define RTMemEfTmpFreeNP                               RT_MANGLER(RTMemEfTmpFreeNP)
# define RTMemExecAllocTag                              RT_MANGLER(RTMemExecAllocTag)
# define RTMemExecFree                                  RT_MANGLER(RTMemExecFree)
# define RTMemFree                                      RT_MANGLER(RTMemFree)
# define RTMemFreeEx                                    RT_MANGLER(RTMemFreeEx)     /* r0drv */
# define RTMemPageAllocTag                              RT_MANGLER(RTMemPageAllocTag)
# define RTMemPageAllocZTag                             RT_MANGLER(RTMemPageAllocZTag)
# define RTMemPageFree                                  RT_MANGLER(RTMemPageFree)
# define RTMemPoolAlloc                                 RT_MANGLER(RTMemPoolAlloc)
# define RTMemPoolAllocZ                                RT_MANGLER(RTMemPoolAllocZ)
# define RTMemPoolCreate                                RT_MANGLER(RTMemPoolCreate)
# define RTMemPoolDestroy                               RT_MANGLER(RTMemPoolDestroy)
# define RTMemPoolDup                                   RT_MANGLER(RTMemPoolDup)
# define RTMemPoolDupEx                                 RT_MANGLER(RTMemPoolDupEx)
# define RTMemPoolFree                                  RT_MANGLER(RTMemPoolFree)
# define RTMemPoolRealloc                               RT_MANGLER(RTMemPoolRealloc)
# define RTMemPoolRefCount                              RT_MANGLER(RTMemPoolRefCount)
# define RTMemPoolRelease                               RT_MANGLER(RTMemPoolRelease)
# define RTMemPoolRetain                                RT_MANGLER(RTMemPoolRetain)
# define RTMemProtect                                   RT_MANGLER(RTMemProtect)
# define RTMemReallocTag                                RT_MANGLER(RTMemReallocTag)
# define RTMemTmpAllocTag                               RT_MANGLER(RTMemTmpAllocTag)
# define RTMemTmpAllocZTag                              RT_MANGLER(RTMemTmpAllocZTag)
# define RTMemTmpFree                                   RT_MANGLER(RTMemTmpFree)
# define RTMemTrackerDumpAllToFile                      RT_MANGLER(RTMemTrackerDumpAllToFile)
# define RTMemTrackerDumpAllToLog                       RT_MANGLER(RTMemTrackerDumpAllToLog)
# define RTMemTrackerDumpAllToLogRel                    RT_MANGLER(RTMemTrackerDumpAllToLogRel)
# define RTMemTrackerDumpAllToStdErr                    RT_MANGLER(RTMemTrackerDumpAllToStdErr)
# define RTMemTrackerDumpAllToStdOut                    RT_MANGLER(RTMemTrackerDumpAllToStdOut)
# define RTMemTrackerDumpStatsToFile                    RT_MANGLER(RTMemTrackerDumpStatsToFile)
# define RTMemTrackerDumpStatsToLog                     RT_MANGLER(RTMemTrackerDumpStatsToLog)
# define RTMemTrackerDumpStatsToLogRel                  RT_MANGLER(RTMemTrackerDumpStatsToLogRel)
# define RTMemTrackerDumpStatsToStdErr                  RT_MANGLER(RTMemTrackerDumpStatsToStdErr)
# define RTMemTrackerDumpStatsToStdOut                  RT_MANGLER(RTMemTrackerDumpStatsToStdOut)
# define RTMemTrackerHdrAlloc                           RT_MANGLER(RTMemTrackerHdrAlloc)
# define RTMemTrackerHdrFree                            RT_MANGLER(RTMemTrackerHdrFree)
# define RTMemTrackerHdrReallocDone                     RT_MANGLER(RTMemTrackerHdrReallocDone)
# define RTMemTrackerHdrReallocPrep                     RT_MANGLER(RTMemTrackerHdrReallocPrep)
# define RTMemWipeThoroughly                            RT_MANGLER(RTMemWipeThoroughly)
# define RTMpCpuId                                      RT_MANGLER(RTMpCpuId)
# define RTMpCpuIdFromSetIndex                          RT_MANGLER(RTMpCpuIdFromSetIndex)
# define RTMpCpuIdToSetIndex                            RT_MANGLER(RTMpCpuIdToSetIndex)
# define RTMpGetArraySize                               RT_MANGLER(RTMpGetArraySize)
# define RTMpGetCount                                   RT_MANGLER(RTMpGetCount)
# define RTMpGetCurFrequency                            RT_MANGLER(RTMpGetCurFrequency)
# define RTMpGetDescription                             RT_MANGLER(RTMpGetDescription)
# define RTMpGetMaxCpuId                                RT_MANGLER(RTMpGetMaxCpuId)
# define RTMpGetMaxFrequency                            RT_MANGLER(RTMpGetMaxFrequency)
# define RTMpGetOnlineCount                             RT_MANGLER(RTMpGetOnlineCount)
# define RTMpGetOnlineSet                               RT_MANGLER(RTMpGetOnlineSet)
# define RTMpGetPresentCount                            RT_MANGLER(RTMpGetPresentCount)
# define RTMpGetPresentSet                              RT_MANGLER(RTMpGetPresentSet)
# define RTMpGetSet                                     RT_MANGLER(RTMpGetSet)
# define RTMpIsCpuOnline                                RT_MANGLER(RTMpIsCpuOnline)
# define RTMpIsCpuPossible                              RT_MANGLER(RTMpIsCpuPossible) /* r0drv */
# define RTMpIsCpuPresent                               RT_MANGLER(RTMpIsCpuPresent)
# define RTMpIsCpuWorkPending                           RT_MANGLER(RTMpIsCpuWorkPending)
# define RTMpNotificationDeregister                     RT_MANGLER(RTMpNotificationDeregister) /* r0drv */
# define RTMpNotificationRegister                       RT_MANGLER(RTMpNotificationRegister)   /* r0drv */
# define RTMpOnAll                                      RT_MANGLER(RTMpOnAll)                  /* r0drv */
# define RTMpOnOthers                                   RT_MANGLER(RTMpOnOthers)               /* r0drv */
# define RTMpOnSpecific                                 RT_MANGLER(RTMpOnSpecific)             /* r0drv */
# define RTMpPokeCpu                                    RT_MANGLER(RTMpPokeCpu)                /* r0drv */
# define RTMsgError                                     RT_MANGLER(RTMsgError)
# define RTMsgErrorExit                                 RT_MANGLER(RTMsgErrorExit)
# define RTMsgErrorExitV                                RT_MANGLER(RTMsgErrorExitV)
# define RTMsgErrorRc                                   RT_MANGLER(RTMsgErrorRc)
# define RTMsgErrorRcV                                  RT_MANGLER(RTMsgErrorRcV)
# define RTMsgErrorV                                    RT_MANGLER(RTMsgErrorV)
# define RTMsgInfo                                      RT_MANGLER(RTMsgInfo)
# define RTMsgInfoV                                     RT_MANGLER(RTMsgInfoV)
# define RTMsgInitFailure                               RT_MANGLER(RTMsgInitFailure)
# define RTMsgSetProgName                               RT_MANGLER(RTMsgSetProgName)
# define RTMsgWarning                                   RT_MANGLER(RTMsgWarning)
# define RTMsgWarningV                                  RT_MANGLER(RTMsgWarningV)
# define RTNetIPv4AddDataChecksum                       RT_MANGLER(RTNetIPv4AddDataChecksum)
# define RTNetIPv4AddTCPChecksum                        RT_MANGLER(RTNetIPv4AddTCPChecksum)
# define RTNetIPv4AddUDPChecksum                        RT_MANGLER(RTNetIPv4AddUDPChecksum)
# define RTNetIPv4FinalizeChecksum                      RT_MANGLER(RTNetIPv4FinalizeChecksum)
# define RTNetIPv4HdrChecksum                           RT_MANGLER(RTNetIPv4HdrChecksum)
# define RTNetIPv4IsDHCPValid                           RT_MANGLER(RTNetIPv4IsDHCPValid)
# define RTNetIPv4IsHdrValid                            RT_MANGLER(RTNetIPv4IsHdrValid)
# define RTNetIPv4IsTCPSizeValid                        RT_MANGLER(RTNetIPv4IsTCPSizeValid)
# define RTNetIPv4IsTCPValid                            RT_MANGLER(RTNetIPv4IsTCPValid)
# define RTNetIPv4IsUDPSizeValid                        RT_MANGLER(RTNetIPv4IsUDPSizeValid)
# define RTNetIPv4IsUDPValid                            RT_MANGLER(RTNetIPv4IsUDPValid)
# define RTNetIPv4PseudoChecksum                        RT_MANGLER(RTNetIPv4PseudoChecksum)
# define RTNetIPv4PseudoChecksumBits                    RT_MANGLER(RTNetIPv4PseudoChecksumBits)
# define RTNetIPv4TCPChecksum                           RT_MANGLER(RTNetIPv4TCPChecksum)
# define RTNetIPv4UDPChecksum                           RT_MANGLER(RTNetIPv4UDPChecksum)
# define RTNetIPv6PseudoChecksum                        RT_MANGLER(RTNetIPv6PseudoChecksum)
# define RTNetIPv6PseudoChecksumBits                    RT_MANGLER(RTNetIPv6PseudoChecksumBits)
# define RTNetIPv6PseudoChecksumEx                      RT_MANGLER(RTNetIPv6PseudoChecksumEx)
# define RTNetTCPChecksum                               RT_MANGLER(RTNetTCPChecksum)
# define RTNetUDPChecksum                               RT_MANGLER(RTNetUDPChecksum)
# define RTOnceSlow                                     RT_MANGLER(RTOnceSlow)
# define RTOnceReset                                    RT_MANGLER(RTOnceReset)
# define RTPathAbs                                      RT_MANGLER(RTPathAbs)
# define RTPathAbsDup                                   RT_MANGLER(RTPathAbsDup)
# define RTPathAbsEx                                    RT_MANGLER(RTPathAbsEx)
# define RTPathAbsExDup                                 RT_MANGLER(RTPathAbsExDup)
# define RTPathAppDocs                                  RT_MANGLER(RTPathAppDocs)
# define RTPathAppend                                   RT_MANGLER(RTPathAppend)
# define RTPathAppendEx                                 RT_MANGLER(RTPathAppendEx)
# define RTPathAppPrivateArch                           RT_MANGLER(RTPathAppPrivateArch)
# define RTPathAppPrivateArchTop                        RT_MANGLER(RTPathAppPrivateArchTop)
# define RTPathAppPrivateNoArch                         RT_MANGLER(RTPathAppPrivateNoArch)
# define RTPathChangeToDosSlashes                       RT_MANGLER(RTPathChangeToDosSlashes)
# define RTPathChangeToUnixSlashes                      RT_MANGLER(RTPathChangeToUnixSlashes)
# define RTPathCompare                                  RT_MANGLER(RTPathCompare)
# define RTPathCopyComponents                           RT_MANGLER(RTPathCopyComponents)
# define RTPathCountComponents                          RT_MANGLER(RTPathCountComponents)
# define RTPathExecDir                                  RT_MANGLER(RTPathExecDir)
# define RTPathExists                                   RT_MANGLER(RTPathExists)
# define RTPathExistsEx                                 RT_MANGLER(RTPathExistsEx)
# define RTPathExt                                      RT_MANGLER(RTPathExt)
# define RTPathFilename                                 RT_MANGLER(RTPathFilename)
# define RTPathGetCurrent                               RT_MANGLER(RTPathGetCurrent)
# define RTPathGetMode                                  RT_MANGLER(RTPathGetMode)
# define RTPathHasExt                                   RT_MANGLER(RTPathHasExt)
# define RTPathHasPath                                  RT_MANGLER(RTPathHasPath)
# define RTPathJoin                                     RT_MANGLER(RTPathJoin)
# define RTPathJoinA                                    RT_MANGLER(RTPathJoinA)
# define RTPathJoinEx                                   RT_MANGLER(RTPathJoinEx)
# define RTPathParse                                    RT_MANGLER(RTPathParse)
# define RTPathQueryInfo                                RT_MANGLER(RTPathQueryInfo)
# define RTPathQueryInfoEx                              RT_MANGLER(RTPathQueryInfoEx)
# define RTPathReal                                     RT_MANGLER(RTPathReal)
# define RTPathRealDup                                  RT_MANGLER(RTPathRealDup)
# define RTPathRename                                   RT_MANGLER(RTPathRename)
# define RTPathSetCurrent                               RT_MANGLER(RTPathSetCurrent)
# define RTPathSetMode                                  RT_MANGLER(RTPathSetMode)                   /* not-win */
# define RTPathSetOwner                                 RT_MANGLER(RTPathSetOwner)                  /* not-win */
# define RTPathSetOwnerEx                               RT_MANGLER(RTPathSetOwnerEx)                /* not-win */
# define RTPathSetTimes                                 RT_MANGLER(RTPathSetTimes)
# define RTPathSetTimesEx                               RT_MANGLER(RTPathSetTimesEx)
# define RTPathSharedLibs                               RT_MANGLER(RTPathSharedLibs)
# define RTPathStartsWith                               RT_MANGLER(RTPathStartsWith)
# define RTPathStartsWithRoot                           RT_MANGLER(RTPathStartsWithRoot)
# define RTPathStripExt                                 RT_MANGLER(RTPathStripExt)
# define RTPathStripFilename                            RT_MANGLER(RTPathStripFilename)
# define RTPathStripTrailingSlash                       RT_MANGLER(RTPathStripTrailingSlash)
# define RTPathTemp                                     RT_MANGLER(RTPathTemp)
# define RTPathTraverseList                             RT_MANGLER(RTPathTraverseList)
# define RTPathUnlink                                   RT_MANGLER(RTPathUnlink)
# define RTPathUserDocuments                            RT_MANGLER(RTPathUserDocuments)
# define RTPathUserHome                                 RT_MANGLER(RTPathUserHome)
# define RTPipeClose                                    RT_MANGLER(RTPipeClose)
# define RTPipeCreate                                   RT_MANGLER(RTPipeCreate)
# define RTPipeFlush                                    RT_MANGLER(RTPipeFlush)
# define RTPipeFromNative                               RT_MANGLER(RTPipeFromNative)
# define RTPipeQueryReadable                            RT_MANGLER(RTPipeQueryReadable)
# define RTPipeRead                                     RT_MANGLER(RTPipeRead)
# define RTPipeReadBlocking                             RT_MANGLER(RTPipeReadBlocking)
# define RTPipeSelectOne                                RT_MANGLER(RTPipeSelectOne)
# define RTPipeToNative                                 RT_MANGLER(RTPipeToNative)
# define RTPipeWrite                                    RT_MANGLER(RTPipeWrite)
# define RTPipeWriteBlocking                            RT_MANGLER(RTPipeWriteBlocking)
# define RTPoll                                         RT_MANGLER(RTPoll)
# define RTPollNoResume                                 RT_MANGLER(RTPollNoResume)
# define RTPollSetAdd                                   RT_MANGLER(RTPollSetAdd)
# define RTPollSetCreate                                RT_MANGLER(RTPollSetCreate)
# define RTPollSetDestroy                               RT_MANGLER(RTPollSetDestroy)
# define RTPollSetEventsChange                          RT_MANGLER(RTPollSetEventsChange)
# define RTPollSetGetCount                              RT_MANGLER(RTPollSetGetCount)
# define RTPollSetQueryHandle                           RT_MANGLER(RTPollSetQueryHandle)
# define RTPollSetRemove                                RT_MANGLER(RTPollSetRemove)
# define RTPowerNotificationDeregister                  RT_MANGLER(RTPowerNotificationDeregister) /* r0drv */
# define RTPowerNotificationRegister                    RT_MANGLER(RTPowerNotificationRegister) /* r0drv */
# define RTPowerSignalEvent                             RT_MANGLER(RTPowerSignalEvent)         /* r0drv */
# define RTPrintf                                       RT_MANGLER(RTPrintf)
# define RTPrintfV                                      RT_MANGLER(RTPrintfV)
# define RTProcCreate                                   RT_MANGLER(RTProcCreate)
# define RTProcCreateEx                                 RT_MANGLER(RTProcCreateEx)
# define RTProcDaemonize                                RT_MANGLER(RTProcDaemonize)
# define RTProcDaemonizeUsingFork                       RT_MANGLER(RTProcDaemonizeUsingFork)
# define RTProcGetAffinityMask                          RT_MANGLER(RTProcGetAffinityMask)
# define RTProcGetExecutablePath                        RT_MANGLER(RTProcGetExecutablePath)
# define RTProcGetPriority                              RT_MANGLER(RTProcGetPriority)
# define RTProcIsRunningByName                          RT_MANGLER(RTProcIsRunningByName)
# define RTProcQueryUsername                            RT_MANGLER(RTProcQueryUsername)
# define RTProcQueryUsernameA                           RT_MANGLER(RTProcQueryUsernameA)
# define RTProcSelf                                     RT_MANGLER(RTProcSelf)
# define RTProcSetPriority                              RT_MANGLER(RTProcSetPriority)
# define RTProcShortName                                RT_MANGLER(RTProcShortName)
# define RTProcTerminate                                RT_MANGLER(RTProcTerminate)
# define RTProcWait                                     RT_MANGLER(RTProcWait)
# define RTProcWaitNoResume                             RT_MANGLER(RTProcWaitNoResume)
# define RTR0AssertPanicSystem                          RT_MANGLER(RTR0AssertPanicSystem)      /* r0drv */
# define RTR0DbgKrnlInfoOpen                            RT_MANGLER(RTR0DbgKrnlInfoOpen)        /* r0drv */
# define RTR0DbgKrnlInfoQueryMember                     RT_MANGLER(RTR0DbgKrnlInfoQueryMember) /* r0drv */
# define RTR0DbgKrnlInfoQuerySymbol                     RT_MANGLER(RTR0DbgKrnlInfoQuerySymbol) /* r0drv */
# define RTR0DbgKrnlInfoRelease                         RT_MANGLER(RTR0DbgKrnlInfoRelease)     /* r0drv */
# define RTR0DbgKrnlInfoRetain                          RT_MANGLER(RTR0DbgKrnlInfoRetain)      /* r0drv */
# define RTR0Init                                       RT_MANGLER(RTR0Init)                   /* r0drv */
# define RTR0MemAreKrnlAndUsrDifferent                  RT_MANGLER(RTR0MemAreKrnlAndUsrDifferent) /* r0drv */
# define RTR0MemExecDonate                              RT_MANGLER(RTR0MemExecDonate)          /* r0drv */
# define RTR0MemKernelIsValidAddr                       RT_MANGLER(RTR0MemKernelIsValidAddr)   /* r0drv */
# define RTR0MemObjAddress                              RT_MANGLER(RTR0MemObjAddress)          /* r0drv */
# define RTR0MemObjAddressR3                            RT_MANGLER(RTR0MemObjAddressR3)        /* r0drv */
# define RTR0MemKernelCopyFrom                          RT_MANGLER(RTR0MemKernelCopyFrom)      /* r0drv */
# define RTR0MemKernelCopyTo                            RT_MANGLER(RTR0MemKernelCopyTo)        /* r0drv */
# define RTR0MemObjAllocContTag                         RT_MANGLER(RTR0MemObjAllocContTag)     /* r0drv */
# define RTR0MemObjAllocLowTag                          RT_MANGLER(RTR0MemObjAllocLowTag)      /* r0drv */
# define RTR0MemObjAllocPageTag                         RT_MANGLER(RTR0MemObjAllocPageTag)     /* r0drv */
# define RTR0MemObjAllocPhysExTag                       RT_MANGLER(RTR0MemObjAllocPhysExTag)   /* r0drv */
# define RTR0MemObjAllocPhysNCTag                       RT_MANGLER(RTR0MemObjAllocPhysNCTag)   /* r0drv */
# define RTR0MemObjAllocPhysTag                         RT_MANGLER(RTR0MemObjAllocPhysTag)     /* r0drv */
# define RTR0MemObjEnterPhysTag                         RT_MANGLER(RTR0MemObjEnterPhysTag)     /* r0drv */
# define RTR0MemObjFree                                 RT_MANGLER(RTR0MemObjFree)             /* r0drv */
# define RTR0MemObjGetPagePhysAddr                      RT_MANGLER(RTR0MemObjGetPagePhysAddr)  /* r0drv */
# define RTR0MemObjIsMapping                            RT_MANGLER(RTR0MemObjIsMapping)        /* r0drv */
# define RTR0MemObjLockKernelTag                        RT_MANGLER(RTR0MemObjLockKernelTag)    /* r0drv */
# define RTR0MemObjLockUserTag                          RT_MANGLER(RTR0MemObjLockUserTag)      /* r0drv */
# define RTR0MemObjMapKernelExTag                       RT_MANGLER(RTR0MemObjMapKernelExTag)   /* r0drv */
# define RTR0MemObjMapKernelTag                         RT_MANGLER(RTR0MemObjMapKernelTag)     /* r0drv */
# define RTR0MemObjMapUserTag                           RT_MANGLER(RTR0MemObjMapUserTag)       /* r0drv */
# define RTR0MemObjProtect                              RT_MANGLER(RTR0MemObjProtect)          /* r0drv */
# define RTR0MemObjReserveKernelTag                     RT_MANGLER(RTR0MemObjReserveKernelTag) /* r0drv */
# define RTR0MemObjReserveUserTag                       RT_MANGLER(RTR0MemObjReserveUserTag)   /* r0drv */
# define RTR0MemObjSize                                 RT_MANGLER(RTR0MemObjSize)             /* r0drv */
# define RTR0MemUserCopyFrom                            RT_MANGLER(RTR0MemUserCopyFrom)        /* r0drv */
# define RTR0MemUserCopyTo                              RT_MANGLER(RTR0MemUserCopyTo)          /* r0drv */
# define RTR0MemUserIsValidAddr                         RT_MANGLER(RTR0MemUserIsValidAddr)     /* r0drv */
# define RTR0ProcHandleSelf                             RT_MANGLER(RTR0ProcHandleSelf)         /* r0drv */
# define RTR0Term                                       RT_MANGLER(RTR0Term)                   /* r0drv */
# define RTR0TermForced                                 RT_MANGLER(RTR0TermForced)             /* r0drv */
# define RTR3InitDll                                    RT_MANGLER(RTR3InitDll)
# define RTR3InitExe                                    RT_MANGLER(RTR3InitExe)
# define RTR3InitExeNoArguments                         RT_MANGLER(RTR3InitExeNoArguments)
# define RTR3InitEx                                     RT_MANGLER(RTR3InitEx)
# define rtR3MemAlloc                                   RT_MANGLER(rtR3MemAlloc)
# define rtR3MemFree                                    RT_MANGLER(rtR3MemFree)
# define rtR3MemRealloc                                 RT_MANGLER(rtR3MemRealloc)
# define RTRCInit                                       RT_MANGLER(RTRCInit)
# define RTRCTerm                                       RT_MANGLER(RTRCTerm)
# define RTRandAdvBytes                                 RT_MANGLER(RTRandAdvBytes)
# define RTRandAdvCreateParkMiller                      RT_MANGLER(RTRandAdvCreateParkMiller)
# define RTRandAdvCreateSystemFaster                    RT_MANGLER(RTRandAdvCreateSystemFaster)
# define RTRandAdvCreateSystemTruer                     RT_MANGLER(RTRandAdvCreateSystemTruer)
# define RTRandAdvDestroy                               RT_MANGLER(RTRandAdvDestroy)
# define RTRandAdvRestoreState                          RT_MANGLER(RTRandAdvRestoreState)
# define RTRandAdvS32                                   RT_MANGLER(RTRandAdvS32)
# define RTRandAdvS32Ex                                 RT_MANGLER(RTRandAdvS32Ex)
# define RTRandAdvS64                                   RT_MANGLER(RTRandAdvS64)
# define RTRandAdvS64Ex                                 RT_MANGLER(RTRandAdvS64Ex)
# define RTRandAdvSaveState                             RT_MANGLER(RTRandAdvSaveState)
# define RTRandAdvSeed                                  RT_MANGLER(RTRandAdvSeed)
# define RTRandAdvU32                                   RT_MANGLER(RTRandAdvU32)
# define RTRandAdvU32Ex                                 RT_MANGLER(RTRandAdvU32Ex)
# define RTRandAdvU64                                   RT_MANGLER(RTRandAdvU64)
# define RTRandAdvU64Ex                                 RT_MANGLER(RTRandAdvU64Ex)
# define RTRandBytes                                    RT_MANGLER(RTRandBytes)
# define RTRandS32                                      RT_MANGLER(RTRandS32)
# define RTRandS32Ex                                    RT_MANGLER(RTRandS32Ex)
# define RTRandS64                                      RT_MANGLER(RTRandS64)
# define RTRandS64Ex                                    RT_MANGLER(RTRandS64Ex)
# define RTRandU32                                      RT_MANGLER(RTRandU32)
# define RTRandU32Ex                                    RT_MANGLER(RTRandU32Ex)
# define RTRandU64                                      RT_MANGLER(RTRandU64)
# define RTRandU64Ex                                    RT_MANGLER(RTRandU64Ex)
# define RTReqPoolAlloc                                 RT_MANGLER(RTReqPoolAlloc)
# define RTReqPoolCallEx                                RT_MANGLER(RTReqPoolCallEx)
# define RTReqPoolCallExV                               RT_MANGLER(RTReqPoolCallExV)
# define RTReqPoolCallWait                              RT_MANGLER(RTReqPoolCallWait)
# define RTReqPoolCallNoWait                            RT_MANGLER(RTReqPoolCallNoWait)
# define RTReqPoolCallVoidWait                          RT_MANGLER(RTReqPoolCallVoidWait)
# define RTReqPoolCallVoidNoWait                        RT_MANGLER(RTReqPoolCallVoidNoWait)
# define RTReqPoolCreate                                RT_MANGLER(RTReqPoolCreate)
# define RTReqPoolGetCfgVar                             RT_MANGLER(RTReqPoolGetCfgVar)
# define RTReqPoolGetStat                               RT_MANGLER(RTReqPoolGetStat)
# define RTReqPoolRetain                                RT_MANGLER(RTReqPoolRetain)
# define RTReqPoolRelease                               RT_MANGLER(RTReqPoolRelease)
# define RTReqPoolSetCfgVar                             RT_MANGLER(RTReqPoolSetCfgVar)
# define RTReqQueueAlloc                                RT_MANGLER(RTReqQueueAlloc)
# define RTReqQueueCall                                 RT_MANGLER(RTReqQueueCall)
# define RTReqQueueCallEx                               RT_MANGLER(RTReqQueueCallEx)
# define RTReqQueueCallV                                RT_MANGLER(RTReqQueueCallV)
# define RTReqQueueCallVoid                             RT_MANGLER(RTReqQueueCallVoid)
# define RTReqQueueCreate                               RT_MANGLER(RTReqQueueCreate)
# define RTReqQueueDestroy                              RT_MANGLER(RTReqQueueDestroy)
# define RTReqQueueIsBusy                               RT_MANGLER(RTReqQueueIsBusy)
# define RTReqQueueProcess                              RT_MANGLER(RTReqQueueProcess)
# define RTReqSubmit                                    RT_MANGLER(RTReqSubmit)
# define RTReqRelease                                   RT_MANGLER(RTReqRelease)
# define RTReqRetain                                    RT_MANGLER(RTReqRetain)
# define RTReqWait                                      RT_MANGLER(RTReqWait)
# define RTReqGetStatus                                 RT_MANGLER(RTReqGetStatus)
# define RTS3BucketsDestroy                             RT_MANGLER(RTS3BucketsDestroy)
# define RTS3Create                                     RT_MANGLER(RTS3Create)
# define RTS3CreateBucket                               RT_MANGLER(RTS3CreateBucket)
# define RTS3DeleteBucket                               RT_MANGLER(RTS3DeleteBucket)
# define RTS3DeleteKey                                  RT_MANGLER(RTS3DeleteKey)
# define RTS3Destroy                                    RT_MANGLER(RTS3Destroy)
# define RTS3GetBucketKeys                              RT_MANGLER(RTS3GetBucketKeys)
# define RTS3GetBuckets                                 RT_MANGLER(RTS3GetBuckets)
# define RTS3GetKey                                     RT_MANGLER(RTS3GetKey)
# define RTS3KeysDestroy                                RT_MANGLER(RTS3KeysDestroy)
# define RTS3PutKey                                     RT_MANGLER(RTS3PutKey)
# define RTS3SetProgressCallback                        RT_MANGLER(RTS3SetProgressCallback)
# define RTSemEventAddSignaller                         RT_MANGLER(RTSemEventAddSignaller)
# define RTSemEventCreate                               RT_MANGLER(RTSemEventCreate)
# define RTSemEventCreateEx                             RT_MANGLER(RTSemEventCreateEx)
# define RTSemEventDestroy                              RT_MANGLER(RTSemEventDestroy)
# define RTSemEventGetResolution                        RT_MANGLER(RTSemEventGetResolution)    /* r0drv */
# define RTSemEventMultiAddSignaller                    RT_MANGLER(RTSemEventMultiAddSignaller)
# define RTSemEventMultiCreate                          RT_MANGLER(RTSemEventMultiCreate)
# define RTSemEventMultiCreateEx                        RT_MANGLER(RTSemEventMultiCreateEx)
# define RTSemEventMultiDestroy                         RT_MANGLER(RTSemEventMultiDestroy)
# define RTSemEventMultiGetResolution                   RT_MANGLER(RTSemEventMultiGetResolution) /* r0drv */
# define RTSemEventMultiRemoveSignaller                 RT_MANGLER(RTSemEventMultiRemoveSignaller)
# define RTSemEventMultiReset                           RT_MANGLER(RTSemEventMultiReset)
# define RTSemEventMultiSetSignaller                    RT_MANGLER(RTSemEventMultiSetSignaller)
# define RTSemEventMultiSignal                          RT_MANGLER(RTSemEventMultiSignal)
# define RTSemEventMultiWait                            RT_MANGLER(RTSemEventMultiWait)
# define RTSemEventMultiWaitEx                          RT_MANGLER(RTSemEventMultiWaitEx)
# define RTSemEventMultiWaitEx                          RT_MANGLER(RTSemEventMultiWaitEx)      /* r0drv */
# define RTSemEventMultiWaitExDebug                     RT_MANGLER(RTSemEventMultiWaitExDebug)
# define RTSemEventMultiWaitExDebug                     RT_MANGLER(RTSemEventMultiWaitExDebug) /* r0drv */
# define RTSemEventMultiWaitNoResume                    RT_MANGLER(RTSemEventMultiWaitNoResume)
# define RTSemEventRemoveSignaller                      RT_MANGLER(RTSemEventRemoveSignaller)
# define RTSemEventSetSignaller                         RT_MANGLER(RTSemEventSetSignaller)
# define RTSemEventSignal                               RT_MANGLER(RTSemEventSignal)
# define RTSemEventWait                                 RT_MANGLER(RTSemEventWait)
# define RTSemEventWaitEx                               RT_MANGLER(RTSemEventWaitEx)           /* r0drv */
# define RTSemEventWaitExDebug                          RT_MANGLER(RTSemEventWaitExDebug)      /* r0drv */
# define RTSemEventWaitNoResume                         RT_MANGLER(RTSemEventWaitNoResume)
# define RTSemFastMutexCreate                           RT_MANGLER(RTSemFastMutexCreate)
# define RTSemFastMutexDestroy                          RT_MANGLER(RTSemFastMutexDestroy)
# define RTSemFastMutexRelease                          RT_MANGLER(RTSemFastMutexRelease)
# define RTSemFastMutexRequest                          RT_MANGLER(RTSemFastMutexRequest)
# define RTSemMutexCreate                               RT_MANGLER(RTSemMutexCreate)
# define RTSemMutexCreateEx                             RT_MANGLER(RTSemMutexCreateEx)
# define RTSemMutexDestroy                              RT_MANGLER(RTSemMutexDestroy)
# define RTSemMutexIsOwned                              RT_MANGLER(RTSemMutexIsOwned)
# define RTSemMutexRelease                              RT_MANGLER(RTSemMutexRelease)
# define RTSemMutexRequest                              RT_MANGLER(RTSemMutexRequest)
# define RTSemMutexRequestDebug                         RT_MANGLER(RTSemMutexRequestDebug)
# define RTSemMutexRequestNoResume                      RT_MANGLER(RTSemMutexRequestNoResume)
# define RTSemMutexRequestNoResumeDebug                 RT_MANGLER(RTSemMutexRequestNoResumeDebug)
# define RTSemMutexSetSubClass                          RT_MANGLER(RTSemMutexSetSubClass)
# define RTSemPing                                      RT_MANGLER(RTSemPing)
# define RTSemPingPongDelete                            RT_MANGLER(RTSemPingPongDelete)
# define RTSemPingPongInit                              RT_MANGLER(RTSemPingPongInit)
# define RTSemPingWait                                  RT_MANGLER(RTSemPingWait)
# define RTSemPong                                      RT_MANGLER(RTSemPong)
# define RTSemPongWait                                  RT_MANGLER(RTSemPongWait)
# define RTSemRWCreate                                  RT_MANGLER(RTSemRWCreate)
# define RTSemRWCreateEx                                RT_MANGLER(RTSemRWCreateEx)
# define RTSemRWDestroy                                 RT_MANGLER(RTSemRWDestroy)
# define RTSemRWGetReadCount                            RT_MANGLER(RTSemRWGetReadCount)
# define RTSemRWGetWriteRecursion                       RT_MANGLER(RTSemRWGetWriteRecursion)
# define RTSemRWGetWriterReadRecursion                  RT_MANGLER(RTSemRWGetWriterReadRecursion)
# define RTSemRWIsReadOwner                             RT_MANGLER(RTSemRWIsReadOwner)
# define RTSemRWIsWriteOwner                            RT_MANGLER(RTSemRWIsWriteOwner)
# define RTSemRWReleaseRead                             RT_MANGLER(RTSemRWReleaseRead)
# define RTSemRWReleaseWrite                            RT_MANGLER(RTSemRWReleaseWrite)
# define RTSemRWRequestRead                             RT_MANGLER(RTSemRWRequestRead)
# define RTSemRWRequestReadDebug                        RT_MANGLER(RTSemRWRequestReadDebug)
# define RTSemRWRequestReadNoResume                     RT_MANGLER(RTSemRWRequestReadNoResume)
# define RTSemRWRequestReadNoResumeDebug                RT_MANGLER(RTSemRWRequestReadNoResumeDebug)
# define RTSemRWRequestWrite                            RT_MANGLER(RTSemRWRequestWrite)
# define RTSemRWRequestWriteDebug                       RT_MANGLER(RTSemRWRequestWriteDebug)
# define RTSemRWRequestWriteNoResume                    RT_MANGLER(RTSemRWRequestWriteNoResume)
# define RTSemRWRequestWriteNoResumeDebug               RT_MANGLER(RTSemRWRequestWriteNoResumeDebug)
# define RTSemRWSetSubClass                             RT_MANGLER(RTSemRWSetSubClass)
# define RTSemSpinMutexCreate                           RT_MANGLER(RTSemSpinMutexCreate)
# define RTSemSpinMutexDestroy                          RT_MANGLER(RTSemSpinMutexDestroy)
# define RTSemSpinMutexRelease                          RT_MANGLER(RTSemSpinMutexRelease)
# define RTSemSpinMutexRequest                          RT_MANGLER(RTSemSpinMutexRequest)
# define RTSemSpinMutexTryRequest                       RT_MANGLER(RTSemSpinMutexTryRequest)
# define RTSemXRoadsCreate                              RT_MANGLER(RTSemXRoadsCreate)
# define RTSemXRoadsDestroy                             RT_MANGLER(RTSemXRoadsDestroy)
# define RTSemXRoadsEWEnter                             RT_MANGLER(RTSemXRoadsEWEnter)
# define RTSemXRoadsEWLeave                             RT_MANGLER(RTSemXRoadsEWLeave)
# define RTSemXRoadsNSEnter                             RT_MANGLER(RTSemXRoadsNSEnter)
# define RTSemXRoadsNSLeave                             RT_MANGLER(RTSemXRoadsNSLeave)
# define RTSgBufAdvance                                 RT_MANGLER(RTSgBufAdvance)
# define RTSgBufClone                                   RT_MANGLER(RTSgBufClone)
# define RTSgBufCmp                                     RT_MANGLER(RTSgBufCmp)
# define RTSgBufCmpEx                                   RT_MANGLER(RTSgBufCmpEx)
# define RTSgBufCopy                                    RT_MANGLER(RTSgBufCopy)
# define RTSgBufCopyFromBuf                             RT_MANGLER(RTSgBufCopyFromBuf)
# define RTSgBufCopyToBuf                               RT_MANGLER(RTSgBufCopyToBuf)
# define RTSgBufInit                                    RT_MANGLER(RTSgBufInit)
# define RTSgBufReset                                   RT_MANGLER(RTSgBufReset)
# define RTSgBufSegArrayCreate                          RT_MANGLER(RTSgBufSegArrayCreate)
# define RTSgBufSet                                     RT_MANGLER(RTSgBufSet)
# define RTSgBufGetNextSegment                          RT_MANGLER(RTSgBufGetNextSegment)
# define RTSha1                                         RT_MANGLER(RTSha1)
# define RTSha1Digest                                   RT_MANGLER(RTSha1Digest)
# define RTSha1DigestFromFile                           RT_MANGLER(RTSha1DigestFromFile)
# define RTSha1Final                                    RT_MANGLER(RTSha1Final)
# define RTSha1FromString                               RT_MANGLER(RTSha1FromString)
# define RTSha1Init                                     RT_MANGLER(RTSha1Init)
# define RTSha1ToString                                 RT_MANGLER(RTSha1ToString)
# define RTSha1Update                                   RT_MANGLER(RTSha1Update)
# define RTSha256                                       RT_MANGLER(RTSha256)
# define RTSha256Final                                  RT_MANGLER(RTSha256Final)
# define RTSha256FromString                             RT_MANGLER(RTSha256FromString)
# define RTSha256Init                                   RT_MANGLER(RTSha256Init)
# define RTSha256ToString                               RT_MANGLER(RTSha256ToString)
# define RTSha256Update                                 RT_MANGLER(RTSha256Update)
# define RTSha512                                       RT_MANGLER(RTSha512)
# define RTSha512Final                                  RT_MANGLER(RTSha512Final)
# define RTSha512FromString                             RT_MANGLER(RTSha512FromString)
# define RTSha512Init                                   RT_MANGLER(RTSha512Init)
# define RTSha512ToString                               RT_MANGLER(RTSha512ToString)
# define RTSha512Update                                 RT_MANGLER(RTSha512Update)
# define RTSocketClose                                  RT_MANGLER(RTSocketClose)
# define RTSocketFromNative                             RT_MANGLER(RTSocketFromNative)
# define RTSocketGetLocalAddress                        RT_MANGLER(RTSocketGetLocalAddress)
# define RTSocketGetPeerAddress                         RT_MANGLER(RTSocketGetPeerAddress)
# define RTSocketParseInetAddress                       RT_MANGLER(RTSocketParseInetAddress)
# define RTSocketRead                                   RT_MANGLER(RTSocketRead)
# define RTSocketReadFrom                               RT_MANGLER(RTSocketReadFrom)
# define RTSocketReadNB                                 RT_MANGLER(RTSocketReadNB)
# define RTSocketRelease                                RT_MANGLER(RTSocketRelease)
# define RTSocketRetain                                 RT_MANGLER(RTSocketRetain)
# define RTSocketSelectOne                              RT_MANGLER(RTSocketSelectOne)
# define RTSocketSelectOneEx                            RT_MANGLER(RTSocketSelectOneEx)
# define RTSocketSetInheritance                         RT_MANGLER(RTSocketSetInheritance)
# define RTSocketSgWrite                                RT_MANGLER(RTSocketSgWrite)
# define RTSocketSgWriteL                               RT_MANGLER(RTSocketSgWriteL)
# define RTSocketSgWriteLNB                             RT_MANGLER(RTSocketSgWriteLNB)
# define RTSocketSgWriteLV                              RT_MANGLER(RTSocketSgWriteLV)
# define RTSocketSgWriteLVNB                            RT_MANGLER(RTSocketSgWriteLVNB)
# define RTSocketSgWriteNB                              RT_MANGLER(RTSocketSgWriteNB)
# define RTSocketShutdown                               RT_MANGLER(RTSocketShutdown)
# define RTSocketToNative                               RT_MANGLER(RTSocketToNative)
# define RTSocketWrite                                  RT_MANGLER(RTSocketWrite)
# define RTSocketWriteNB                                RT_MANGLER(RTSocketWriteNB)
# define RTSocketWriteTo                                RT_MANGLER(RTSocketWriteTo)
# define RTSortApvIsSorted                              RT_MANGLER(RTSortApvIsSorted)
# define RTSortApvShell                                 RT_MANGLER(RTSortApvShell)
# define RTSortIsSorted                                 RT_MANGLER(RTSortIsSorted)
# define RTSpinlockAcquire                              RT_MANGLER(RTSpinlockAcquire)
# define RTSpinlockAcquireNoInts                        RT_MANGLER(RTSpinlockAcquireNoInts)
# define RTSpinlockCreate                               RT_MANGLER(RTSpinlockCreate)
# define RTSpinlockDestroy                              RT_MANGLER(RTSpinlockDestroy)
# define RTSpinlockRelease                              RT_MANGLER(RTSpinlockRelease)
# define RTSpinlockReleaseNoInts                        RT_MANGLER(RTSpinlockReleaseNoInts)
# define RTStrAAppendExNVTag                            RT_MANGLER(RTStrAAppendExNVTag)
# define RTStrAAppendNTag                               RT_MANGLER(RTStrAAppendNTag)
# define RTStrAAppendTag                                RT_MANGLER(RTStrAAppendTag)
# define RTStrAllocExTag                                RT_MANGLER(RTStrAllocExTag)
# define RTStrAllocTag                                  RT_MANGLER(RTStrAllocTag)
# define RTStrAPrintf2VTag                              RT_MANGLER(RTStrAPrintf2VTag)
# define RTStrAPrintfVTag                               RT_MANGLER(RTStrAPrintfVTag)
# define RTStrATruncateTag                              RT_MANGLER(RTStrATruncateTag)
# define RTStrCacheCreate                               RT_MANGLER(RTStrCacheCreate)
# define RTStrCacheDestroy                              RT_MANGLER(RTStrCacheDestroy)
# define RTStrCacheEnter                                RT_MANGLER(RTStrCacheEnter)
# define RTStrCacheEnterN                               RT_MANGLER(RTStrCacheEnterN)
# define RTStrCacheLength                               RT_MANGLER(RTStrCacheLength)
# define RTStrCacheRelease                              RT_MANGLER(RTStrCacheRelease)
# define RTStrCacheRetain                               RT_MANGLER(RTStrCacheRetain)
# define RTStrCalcLatin1Len                             RT_MANGLER(RTStrCalcLatin1Len)
# define RTStrCalcLatin1LenEx                           RT_MANGLER(RTStrCalcLatin1LenEx)
# define RTStrCalcUtf16Len                              RT_MANGLER(RTStrCalcUtf16Len)
# define RTStrCalcUtf16LenEx                            RT_MANGLER(RTStrCalcUtf16LenEx)
# define RTStrCat                                       RT_MANGLER(RTStrCat)
# define RTStrCatEx                                     RT_MANGLER(RTStrCatEx)
# define RTStrCatP                                      RT_MANGLER(RTStrCatP)
# define RTStrCatPEx                                    RT_MANGLER(RTStrCatPEx)
# define RTStrCmp                                       RT_MANGLER(RTStrCmp)
# define RTStrConvertHexBytes                           RT_MANGLER(RTStrConvertHexBytes)
# define RTStrCopy                                      RT_MANGLER(RTStrCopy)
# define RTStrCopyEx                                    RT_MANGLER(RTStrCopyEx)
# define RTStrCopyP                                     RT_MANGLER(RTStrCopyP)
# define RTStrCopyPEx                                   RT_MANGLER(RTStrCopyPEx)
# define RTStrCurrentCPToUtf8Tag                        RT_MANGLER(RTStrCurrentCPToUtf8Tag)
# define RTStrDupExTag                                  RT_MANGLER(RTStrDupExTag)
# define RTStrDupNTag                                   RT_MANGLER(RTStrDupNTag)
# define RTStrDupTag                                    RT_MANGLER(RTStrDupTag)
# define RTStrFormat                                    RT_MANGLER(RTStrFormat)
# define RTStrFormatNumber                              RT_MANGLER(RTStrFormatNumber)
# define RTStrFormatR80                                 RT_MANGLER(RTStrFormatR80)
# define RTStrFormatR80u2                               RT_MANGLER(RTStrFormatR80u2)
# define RTStrFormatTypeDeregister                      RT_MANGLER(RTStrFormatTypeDeregister)
# define RTStrFormatTypeRegister                        RT_MANGLER(RTStrFormatTypeRegister)
# define RTStrFormatTypeSetUser                         RT_MANGLER(RTStrFormatTypeSetUser)
# define RTStrFormatU128                                RT_MANGLER(RTStrFormatU128)
# define RTStrFormatU16                                 RT_MANGLER(RTStrFormatU16)
# define RTStrFormatU32                                 RT_MANGLER(RTStrFormatU32)
# define RTStrFormatU64                                 RT_MANGLER(RTStrFormatU64)
# define RTStrFormatU8                                  RT_MANGLER(RTStrFormatU8)
# define RTStrFormatV                                   RT_MANGLER(RTStrFormatV)
# define RTStrFree                                      RT_MANGLER(RTStrFree)
# define RTStrGetCpExInternal                           RT_MANGLER(RTStrGetCpExInternal)
# define RTStrGetCpInternal                             RT_MANGLER(RTStrGetCpInternal)
# define RTStrGetCpNExInternal                          RT_MANGLER(RTStrGetCpNExInternal)
# define RTStrHash1                                     RT_MANGLER(RTStrHash1)
# define RTStrHash1ExN                                  RT_MANGLER(RTStrHash1ExN)
# define RTStrHash1ExNV                                 RT_MANGLER(RTStrHash1ExNV)
# define RTStrHash1N                                    RT_MANGLER(RTStrHash1N)
# define RTStrICmp                                      RT_MANGLER(RTStrICmp)
# define RTStrIStr                                      RT_MANGLER(RTStrIStr)
# define RTStrIsValidEncoding                           RT_MANGLER(RTStrIsValidEncoding)
# define RTStrmClearError                               RT_MANGLER(RTStrmClearError)
# define RTStrmClose                                    RT_MANGLER(RTStrmClose)
# define RTStrmError                                    RT_MANGLER(RTStrmError)
# define RTStrmFlush                                    RT_MANGLER(RTStrmFlush)
# define RTStrmGetCh                                    RT_MANGLER(RTStrmGetCh)
# define RTStrmGetLine                                  RT_MANGLER(RTStrmGetLine)
# define RTStrmOpen                                     RT_MANGLER(RTStrmOpen)
# define RTStrmOpenF                                    RT_MANGLER(RTStrmOpenF)
# define RTStrmOpenFV                                   RT_MANGLER(RTStrmOpenFV)
# define RTStrmPrintf                                   RT_MANGLER(RTStrmPrintf)
# define RTStrmPrintfV                                  RT_MANGLER(RTStrmPrintfV)
# define RTStrmPutCh                                    RT_MANGLER(RTStrmPutCh)
# define RTStrmPutStr                                   RT_MANGLER(RTStrmPutStr)
# define RTStrmReadEx                                   RT_MANGLER(RTStrmReadEx)
# define RTStrmRewind                                   RT_MANGLER(RTStrmRewind)
# define RTStrmSetMode                                  RT_MANGLER(RTStrmSetMode)
# define RTStrmWriteEx                                  RT_MANGLER(RTStrmWriteEx)
# define RTStrNCmp                                      RT_MANGLER(RTStrNCmp)
# define RTStrNICmp                                     RT_MANGLER(RTStrNICmp)
# define RTStrNLen                                      RT_MANGLER(RTStrNLen)
# define RTStrNLenEx                                    RT_MANGLER(RTStrNLenEx)
# define RTStrPrevCp                                    RT_MANGLER(RTStrPrevCp)
# define RTStrPrintf                                    RT_MANGLER(RTStrPrintf)
# define RTStrPrintfEx                                  RT_MANGLER(RTStrPrintfEx)
# define RTStrPrintfExV                                 RT_MANGLER(RTStrPrintfExV)
# define RTStrPrintfV                                   RT_MANGLER(RTStrPrintfV)
# define RTStrPrintHexBytes                             RT_MANGLER(RTStrPrintHexBytes)
# define RTStrPurgeEncoding                             RT_MANGLER(RTStrPurgeEncoding)
# define RTStrPurgeComplementSet                        RT_MANGLER(RTStrPurgeComplimentSet)
# define RTStrPutCpInternal                             RT_MANGLER(RTStrPutCpInternal)
# define RTStrReallocTag                                RT_MANGLER(RTStrReallocTag)
# define RTStrSimplePatternMatch                        RT_MANGLER(RTStrSimplePatternMatch)
# define RTStrSimplePatternMultiMatch                   RT_MANGLER(RTStrSimplePatternMultiMatch)
# define RTStrSimplePatternNMatch                       RT_MANGLER(RTStrSimplePatternNMatch)
# define RTStrSpaceDestroy                              RT_MANGLER(RTStrSpaceDestroy)
# define RTStrSpaceEnumerate                            RT_MANGLER(RTStrSpaceEnumerate)
# define RTStrSpaceGet                                  RT_MANGLER(RTStrSpaceGet)
# define RTStrSpaceGetN                                 RT_MANGLER(RTStrSpaceGetN)
# define RTStrSpaceInsert                               RT_MANGLER(RTStrSpaceInsert)
# define RTStrSpaceRemove                               RT_MANGLER(RTStrSpaceRemove)
# define RTStrStr                                       RT_MANGLER(RTStrStr)
# define RTStrStrip                                     RT_MANGLER(RTStrStrip)
# define RTStrStripL                                    RT_MANGLER(RTStrStripL)
# define RTStrStripR                                    RT_MANGLER(RTStrStripR)
# define RTStrToInt16                                   RT_MANGLER(RTStrToInt16)
# define RTStrToInt16Ex                                 RT_MANGLER(RTStrToInt16Ex)
# define RTStrToInt16Full                               RT_MANGLER(RTStrToInt16Full)
# define RTStrToInt32                                   RT_MANGLER(RTStrToInt32)
# define RTStrToInt32Ex                                 RT_MANGLER(RTStrToInt32Ex)
# define RTStrToInt32Full                               RT_MANGLER(RTStrToInt32Full)
# define RTStrToInt64                                   RT_MANGLER(RTStrToInt64)
# define RTStrToInt64Ex                                 RT_MANGLER(RTStrToInt64Ex)
# define RTStrToInt64Full                               RT_MANGLER(RTStrToInt64Full)
# define RTStrToInt8                                    RT_MANGLER(RTStrToInt8)
# define RTStrToInt8Ex                                  RT_MANGLER(RTStrToInt8Ex)
# define RTStrToInt8Full                                RT_MANGLER(RTStrToInt8Full)
# define RTStrToLatin1ExTag                             RT_MANGLER(RTStrToLatin1ExTag)
# define RTStrToLatin1Tag                               RT_MANGLER(RTStrToLatin1Tag)
# define RTStrToLower                                   RT_MANGLER(RTStrToLower)
# define RTStrToUInt16                                  RT_MANGLER(RTStrToUInt16)
# define RTStrToUInt16Ex                                RT_MANGLER(RTStrToUInt16Ex)
# define RTStrToUInt16Full                              RT_MANGLER(RTStrToUInt16Full)
# define RTStrToUInt32                                  RT_MANGLER(RTStrToUInt32)
# define RTStrToUInt32Ex                                RT_MANGLER(RTStrToUInt32Ex)
# define RTStrToUInt32Full                              RT_MANGLER(RTStrToUInt32Full)
# define RTStrToUInt64                                  RT_MANGLER(RTStrToUInt64)
# define RTStrToUInt64Ex                                RT_MANGLER(RTStrToUInt64Ex)
# define RTStrToUInt64Full                              RT_MANGLER(RTStrToUInt64Full)
# define RTStrToUInt8                                   RT_MANGLER(RTStrToUInt8)
# define RTStrToUInt8Ex                                 RT_MANGLER(RTStrToUInt8Ex)
# define RTStrToUInt8Full                               RT_MANGLER(RTStrToUInt8Full)
# define RTStrToUni                                     RT_MANGLER(RTStrToUni)
# define RTStrToUniEx                                   RT_MANGLER(RTStrToUniEx)
# define RTStrToUpper                                   RT_MANGLER(RTStrToUpper)
# define RTStrToUtf16ExTag                              RT_MANGLER(RTStrToUtf16ExTag)
# define RTStrToUtf16Tag                                RT_MANGLER(RTStrToUtf16Tag)
# define RTStrUniLen                                    RT_MANGLER(RTStrUniLen)
# define RTStrUniLenEx                                  RT_MANGLER(RTStrUniLenEx)
# define RTStrUtf8ToCurrentCPTag                        RT_MANGLER(RTStrUtf8ToCurrentCPTag)
# define RTStrValidateEncoding                          RT_MANGLER(RTStrValidateEncoding)
# define RTStrValidateEncodingEx                        RT_MANGLER(RTStrValidateEncodingEx)
# define RTStrVersionCompare                            RT_MANGLER(RTStrVersionCompare)
# define RTSymlinkCreate                                RT_MANGLER(RTSymlinkCreate)
# define RTSymlinkDelete                                RT_MANGLER(RTSymlinkDelete)
# define RTSymlinkExists                                RT_MANGLER(RTSymlinkExists)
# define RTSymlinkIsDangling                            RT_MANGLER(RTSymlinkIsDangling)
# define RTSymlinkRead                                  RT_MANGLER(RTSymlinkRead)
# define RTSymlinkReadA                                 RT_MANGLER(RTSymlinkReadA)
# define RTSystemQueryAvailableRam                      RT_MANGLER(RTSystemQueryAvailableRam)
# define RTSystemQueryDmiString                         RT_MANGLER(RTSystemQueryDmiString)
# define RTSystemQueryOSInfo                            RT_MANGLER(RTSystemQueryOSInfo)
# define RTSystemQueryTotalRam                          RT_MANGLER(RTSystemQueryTotalRam)
# define RTSystemShutdown                               RT_MANGLER(RTSystemShutdown)
# define RTTarClose                                     RT_MANGLER(RTTarClose)
# define RTTarCreate                                    RT_MANGLER(RTTarCreate)
# define RTTarCurrentFile                               RT_MANGLER(RTTarCurrentFile)
# define RTTarExtractAll                                RT_MANGLER(RTTarExtractAll)
# define RTTarExtractFiles                              RT_MANGLER(RTTarExtractFiles)
# define RTTarExtractFileToBuf                          RT_MANGLER(RTTarExtractFileToBuf)
# define RTTarFileClose                                 RT_MANGLER(RTTarFileClose)
# define RTTarFileExists                                RT_MANGLER(RTTarFileExists)
# define RTTarFileGetMode                               RT_MANGLER(RTTarFileGetMode)
# define RTTarFileGetOwner                              RT_MANGLER(RTTarFileGetOwner)
# define RTTarFileGetSize                               RT_MANGLER(RTTarFileGetSize)
# define RTTarFileGetTime                               RT_MANGLER(RTTarFileGetTime)
# define RTTarFileOpen                                  RT_MANGLER(RTTarFileOpen)
# define RTTarFileOpenCurrentFile                       RT_MANGLER(RTTarFileOpenCurrentFile)
# define RTTarFileRead                                  RT_MANGLER(RTTarFileRead)
# define RTTarFileReadAt                                RT_MANGLER(RTTarFileReadAt)
# define RTTarFileSeek                                  RT_MANGLER(RTTarFileSeek)
# define RTTarFileSetMode                               RT_MANGLER(RTTarFileSetMode)
# define RTTarFileSetOwner                              RT_MANGLER(RTTarFileSetOwner)
# define RTTarFileSetSize                               RT_MANGLER(RTTarFileSetSize)
# define RTTarFileSetTime                               RT_MANGLER(RTTarFileSetTime)
# define RTTarFileTell                                  RT_MANGLER(RTTarFileTell)
# define RTTarFileWrite                                 RT_MANGLER(RTTarFileWrite)
# define RTTarFileWriteAt                               RT_MANGLER(RTTarFileWriteAt)
# define RTTarList                                      RT_MANGLER(RTTarList)
# define RTTarOpen                                      RT_MANGLER(RTTarOpen)
# define RTTarSeekNextFile                              RT_MANGLER(RTTarSeekNextFile)
# define RTTcpClientClose                               RT_MANGLER(RTTcpClientClose)
# define RTTcpClientCloseEx                             RT_MANGLER(RTTcpClientCloseEx)
# define RTTcpClientConnect                             RT_MANGLER(RTTcpClientConnect)
# define RTTcpFlush                                     RT_MANGLER(RTTcpFlush)
# define RTTcpGetLocalAddress                           RT_MANGLER(RTTcpGetLocalAddress)
# define RTTcpGetPeerAddress                            RT_MANGLER(RTTcpGetPeerAddress)
# define RTTcpRead                                      RT_MANGLER(RTTcpRead)
# define RTTcpReadNB                                    RT_MANGLER(RTTcpReadNB)
# define RTTcpSelectOne                                 RT_MANGLER(RTTcpSelectOne)
# define RTTcpSelectOneEx                               RT_MANGLER(RTTcpSelectOneEx)
# define RTTcpServerCreate                              RT_MANGLER(RTTcpServerCreate)
# define RTTcpServerCreateEx                            RT_MANGLER(RTTcpServerCreateEx)
# define RTTcpServerDestroy                             RT_MANGLER(RTTcpServerDestroy)
# define RTTcpServerDisconnectClient                    RT_MANGLER(RTTcpServerDisconnectClient)
# define RTTcpServerDisconnectClient2                   RT_MANGLER(RTTcpServerDisconnectClient2)
# define RTTcpServerListen                              RT_MANGLER(RTTcpServerListen)
# define RTTcpServerListen2                             RT_MANGLER(RTTcpServerListen2)
# define RTTcpServerShutdown                            RT_MANGLER(RTTcpServerShutdown)
# define RTTcpSetSendCoalescing                         RT_MANGLER(RTTcpSetSendCoalescing)
# define RTTcpSgWrite                                   RT_MANGLER(RTTcpSgWrite)
# define RTTcpSgWriteL                                  RT_MANGLER(RTTcpSgWriteL)
# define RTTcpSgWriteLNB                                RT_MANGLER(RTTcpSgWriteLNB)
# define RTTcpSgWriteLV                                 RT_MANGLER(RTTcpSgWriteLV)
# define RTTcpSgWriteLVNB                               RT_MANGLER(RTTcpSgWriteLVNB)
# define RTTcpSgWriteNB                                 RT_MANGLER(RTTcpSgWriteNB)
# define RTTcpWrite                                     RT_MANGLER(RTTcpWrite)
# define RTTcpWriteNB                                   RT_MANGLER(RTTcpWriteNB)
# define RTTermDeregisterCallback                       RT_MANGLER(RTTermDeregisterCallback)
# define RTTermRegisterCallback                         RT_MANGLER(RTTermRegisterCallback)
# define RTTermRunCallbacks                             RT_MANGLER(RTTermRunCallbacks)
# define RTTestBanner                                   RT_MANGLER(RTTestBanner)
# define RTTestCreate                                   RT_MANGLER(RTTestCreate)
# define RTTestDestroy                                  RT_MANGLER(RTTestDestroy)
# define RTTestErrorCount                               RT_MANGLER(RTTestErrorCount)
# define RTTestErrorInc                                 RT_MANGLER(RTTestErrorInc)
# define RTTestFailed                                   RT_MANGLER(RTTestFailed)
# define RTTestFailedV                                  RT_MANGLER(RTTestFailedV)
# define RTTestFailureDetails                           RT_MANGLER(RTTestFailureDetails)
# define RTTestFailureDetailsV                          RT_MANGLER(RTTestFailureDetailsV)
# define RTTestGuardedAlloc                             RT_MANGLER(RTTestGuardedAlloc)
# define RTTestGuardedAllocHead                         RT_MANGLER(RTTestGuardedAllocHead)
# define RTTestGuardedAllocTail                         RT_MANGLER(RTTestGuardedAllocTail)
# define RTTestGuardedFree                              RT_MANGLER(RTTestGuardedFree)
# define RTTestIErrorCount                              RT_MANGLER(RTTestIErrorCount)
# define RTTestIErrorInc                                RT_MANGLER(RTTestIErrorInc)
# define RTTestIFailed                                  RT_MANGLER(RTTestIFailed)
# define RTTestIFailedRc                                RT_MANGLER(RTTestIFailedRc)
# define RTTestIFailedRcV                               RT_MANGLER(RTTestIFailedRcV)
# define RTTestIFailedV                                 RT_MANGLER(RTTestIFailedV)
# define RTTestIFailureDetails                          RT_MANGLER(RTTestIFailureDetails)
# define RTTestIFailureDetailsV                         RT_MANGLER(RTTestIFailureDetailsV)
# define RTTestInitAndCreate                            RT_MANGLER(RTTestInitAndCreate)
# define RTTestIPassed                                  RT_MANGLER(RTTestIPassed)
# define RTTestIPassedV                                 RT_MANGLER(RTTestIPassedV)
# define RTTestIPrintf                                  RT_MANGLER(RTTestIPrintf)
# define RTTestIPrintfV                                 RT_MANGLER(RTTestIPrintfV)
# define RTTestISub                                     RT_MANGLER(RTTestISub)
# define RTTestISubDone                                 RT_MANGLER(RTTestISubDone)
# define RTTestISubF                                    RT_MANGLER(RTTestISubF)
# define RTTestISubV                                    RT_MANGLER(RTTestISubV)
# define RTTestIValue                                   RT_MANGLER(RTTestIValue)
# define RTTestIValueF                                  RT_MANGLER(RTTestIValueF)
# define RTTestIValueV                                  RT_MANGLER(RTTestIValueV)
# define RTTestPassed                                   RT_MANGLER(RTTestPassed)
# define RTTestPassedV                                  RT_MANGLER(RTTestPassedV)
# define RTTestPrintf                                   RT_MANGLER(RTTestPrintf)
# define RTTestPrintfNl                                 RT_MANGLER(RTTestPrintfNl)
# define RTTestPrintfNlV                                RT_MANGLER(RTTestPrintfNlV)
# define RTTestPrintfV                                  RT_MANGLER(RTTestPrintfV)
# define RTTestSetDefault                               RT_MANGLER(RTTestSetDefault)
# define RTTestSkipAndDestroy                           RT_MANGLER(RTTestSkipAndDestroy)
# define RTTestSkipAndDestroyV                          RT_MANGLER(RTTestSkipAndDestroyV)
# define RTTestSub                                      RT_MANGLER(RTTestSub)
# define RTTestSubDone                                  RT_MANGLER(RTTestSubDone)
# define RTTestSubF                                     RT_MANGLER(RTTestSubF)
# define RTTestSubV                                     RT_MANGLER(RTTestSubV)
# define RTTestSummaryAndDestroy                        RT_MANGLER(RTTestSummaryAndDestroy)
# define RTTestValue                                    RT_MANGLER(RTTestValue)
# define RTTestValueF                                   RT_MANGLER(RTTestValueF)
# define RTTestValueV                                   RT_MANGLER(RTTestValueV)
# define RTThreadAdopt                                  RT_MANGLER(RTThreadAdopt)
# define RTThreadBlocking                               RT_MANGLER(RTThreadBlocking)
# define RTThreadCreate                                 RT_MANGLER(RTThreadCreate)
# define RTThreadCreateF                                RT_MANGLER(RTThreadCreateF)
# define RTThreadCreateV                                RT_MANGLER(RTThreadCreateV)
# define RTThreadFromNative                             RT_MANGLER(RTThreadFromNative)
# define RTThreadGetAffinity                            RT_MANGLER(RTThreadGetAffinity)
# define RTThreadGetExecutionTimeMilli                  RT_MANGLER(RTThreadGetExecutionTimeMilli)
# define RTThreadGetName                                RT_MANGLER(RTThreadGetName)
# define RTThreadGetNative                              RT_MANGLER(RTThreadGetNative)
# define RTThreadGetNativeState                         RT_MANGLER(RTThreadGetNativeState)
# define RTThreadGetReallySleeping                      RT_MANGLER(RTThreadGetReallySleeping)
# define RTThreadGetState                               RT_MANGLER(RTThreadGetState)
# define RTThreadGetType                                RT_MANGLER(RTThreadGetType)
# define RTThreadIsInInterrupt                          RT_MANGLER(RTThreadIsInInterrupt)      /* r0drv */
# define RTThreadIsInitialized                          RT_MANGLER(RTThreadIsInitialized)
# define RTThreadIsMain                                 RT_MANGLER(RTThreadIsMain)
# define RTThreadIsSelfAlive                            RT_MANGLER(RTThreadIsSelfAlive)
# define RTThreadIsSelfKnown                            RT_MANGLER(RTThreadIsSelfKnown)
# define RTThreadNativeSelf                             RT_MANGLER(RTThreadNativeSelf)
# define RTThreadPoke                                   RT_MANGLER(RTThreadPoke) /* not-win not-os2 */
# define RTThreadPreemptDisable                         RT_MANGLER(RTThreadPreemptDisable)     /* r0drv */
# define RTThreadPreemptIsEnabled                       RT_MANGLER(RTThreadPreemptIsEnabled)   /* r0drv */
# define RTThreadPreemptIsPending                       RT_MANGLER(RTThreadPreemptIsPending)   /* r0drv */
# define RTThreadPreemptIsPendingTrusty                 RT_MANGLER(RTThreadPreemptIsPendingTrusty) /* r0drv */
# define RTThreadPreemptIsPossible                      RT_MANGLER(RTThreadPreemptIsPossible)  /* r0drv */
# define RTThreadPreemptRestore                         RT_MANGLER(RTThreadPreemptRestore)     /* r0drv */
# define RTThreadSelf                                   RT_MANGLER(RTThreadSelf)
# define RTThreadSelfAutoAdopt                          RT_MANGLER(RTThreadSelfAutoAdopt)
# define RTThreadSelfName                               RT_MANGLER(RTThreadSelfName)
# define RTThreadSetAffinity                            RT_MANGLER(RTThreadSetAffinity)
# define RTThreadSetAffinityToCpu                       RT_MANGLER(RTThreadSetAffinityToCpu)
# define RTThreadSetName                                RT_MANGLER(RTThreadSetName)
# define RTThreadSetType                                RT_MANGLER(RTThreadSetType)
# define RTThreadSleep                                  RT_MANGLER(RTThreadSleep)
# define RTThreadSleepNoLog                             RT_MANGLER(RTThreadSleepNoLog)
# define RTThreadStateName                              RT_MANGLER(RTThreadStateName)
# define RTThreadUnblocked                              RT_MANGLER(RTThreadUnblocked)
# define RTThreadUserReset                              RT_MANGLER(RTThreadUserReset)
# define RTThreadUserSignal                             RT_MANGLER(RTThreadUserSignal)
# define RTThreadUserWait                               RT_MANGLER(RTThreadUserWait)
# define RTThreadUserWaitNoResume                       RT_MANGLER(RTThreadUserWaitNoResume)
# define RTThreadWait                                   RT_MANGLER(RTThreadWait)
# define RTThreadWaitNoResume                           RT_MANGLER(RTThreadWaitNoResume)
# define RTThreadYield                                  RT_MANGLER(RTThreadYield)
# define RTTimeDbgBad                                   RT_MANGLER(RTTimeDbgBad)
# define RTTimeDbgExpired                               RT_MANGLER(RTTimeDbgExpired)
# define RTTimeDbgRaces                                 RT_MANGLER(RTTimeDbgRaces)
# define RTTimeDbgSteps                                 RT_MANGLER(RTTimeDbgSteps)
# define RTTimeExplode                                  RT_MANGLER(RTTimeExplode)
# define RTTimeImplode                                  RT_MANGLER(RTTimeImplode)
# define RTTimeIsLeapYear                               RT_MANGLER(RTTimeIsLeapYear)
# define RTTimeLocalDeltaNano                           RT_MANGLER(RTTimeLocalDeltaNano)
# define RTTimeLocalExplode                             RT_MANGLER(RTTimeLocalExplode)
# define RTTimeLocalNow                                 RT_MANGLER(RTTimeLocalNow)
# define RTTimeMilliTS                                  RT_MANGLER(RTTimeMilliTS)
# define RTTimeNanoTS                                   RT_MANGLER(RTTimeNanoTS)
# define RTTimeNanoTSLegacyAsync                        RT_MANGLER(RTTimeNanoTSLegacyAsync)
# define RTTimeNanoTSLegacySync                         RT_MANGLER(RTTimeNanoTSLegacySync)
# define RTTimeNanoTSLFenceAsync                        RT_MANGLER(RTTimeNanoTSLFenceAsync)
# define RTTimeNanoTSLFenceSync                         RT_MANGLER(RTTimeNanoTSLFenceSync)
# define RTTimeNormalize                                RT_MANGLER(RTTimeNormalize)
# define RTTimeNow                                      RT_MANGLER(RTTimeNow)
# define RTTimeProgramMicroTS                           RT_MANGLER(RTTimeProgramMicroTS)
# define RTTimeProgramMilliTS                           RT_MANGLER(RTTimeProgramMilliTS)
# define RTTimeProgramNanoTS                            RT_MANGLER(RTTimeProgramNanoTS)
# define RTTimeProgramSecTS                             RT_MANGLER(RTTimeProgramSecTS)
# define RTTimeProgramStartNanoTS                       RT_MANGLER(RTTimeProgramStartNanoTS)
# define RTTimerCanDoHighResolution                     RT_MANGLER(RTTimerCanDoHighResolution)
# define RTTimerChangeInterval                          RT_MANGLER(RTTimerChangeInterval)
# define RTTimerCreate                                  RT_MANGLER(RTTimerCreate)
# define RTTimerCreateEx                                RT_MANGLER(RTTimerCreateEx)
# define RTTimerDestroy                                 RT_MANGLER(RTTimerDestroy)
# define RTTimerGetSystemGranularity                    RT_MANGLER(RTTimerGetSystemGranularity) /* r0drv */
# define RTTimerLRCreate                                RT_MANGLER(RTTimerLRCreate)
# define RTTimerLRCreateEx                              RT_MANGLER(RTTimerLRCreateEx)
# define RTTimerLRDestroy                               RT_MANGLER(RTTimerLRDestroy)
# define RTTimerLRStart                                 RT_MANGLER(RTTimerLRStart)
# define RTTimerLRStop                                  RT_MANGLER(RTTimerLRStop)
# define RTTimerLRChangeInterval                        RT_MANGLER(RTTimerLRChangeInterval)
# define RTTimerReleaseSystemGranularity                RT_MANGLER(RTTimerReleaseSystemGranularity) /* r0drv */
# define RTTimerRequestSystemGranularity                RT_MANGLER(RTTimerRequestSystemGranularity) /* r0drv */
# define RTTimerStart                                   RT_MANGLER(RTTimerStart)
# define RTTimerStop                                    RT_MANGLER(RTTimerStop)
# define RTTimeSet                                      RT_MANGLER(RTTimeSet)
# define RTTimeSpecToString                             RT_MANGLER(RTTimeSpecToString)
# define RTTimeSystemMilliTS                            RT_MANGLER(RTTimeSystemMilliTS)
# define RTTimeSystemNanoTS                             RT_MANGLER(RTTimeSystemNanoTS)
# define RTTimeToString                                 RT_MANGLER(RTTimeToString)
# define RTTlsAlloc                                     RT_MANGLER(RTTlsAlloc)
# define RTTlsAllocEx                                   RT_MANGLER(RTTlsAllocEx)
# define RTTlsFree                                      RT_MANGLER(RTTlsFree)
# define RTTlsGet                                       RT_MANGLER(RTTlsGet)
# define RTTlsGetEx                                     RT_MANGLER(RTTlsGetEx)
# define RTTlsSet                                       RT_MANGLER(RTTlsSet)
# define RTTraceBufAddMsg                               RT_MANGLER(RTTraceBufAddMsg)
# define RTTraceBufAddMsgEx                             RT_MANGLER(RTTraceBufAddMsgEx)
# define RTTraceBufAddMsgF                              RT_MANGLER(RTTraceBufAddMsgF)
# define RTTraceBufAddMsgV                              RT_MANGLER(RTTraceBufAddMsgV)
# define RTTraceBufAddPos                               RT_MANGLER(RTTraceBufAddPos)
# define RTTraceBufAddPosMsg                            RT_MANGLER(RTTraceBufAddPosMsg)
# define RTTraceBufAddPosMsgEx                          RT_MANGLER(RTTraceBufAddPosMsgEx)
# define RTTraceBufAddPosMsgF                           RT_MANGLER(RTTraceBufAddPosMsgF)
# define RTTraceBufAddPosMsgV                           RT_MANGLER(RTTraceBufAddPosMsgV)
# define RTTraceBufCarve                                RT_MANGLER(RTTraceBufCarve)
# define RTTraceBufCreate                               RT_MANGLER(RTTraceBufCreate)
# define RTTraceBufDisable                              RT_MANGLER(RTTraceBufDisable)
# define RTTraceBufDumpToAssert                         RT_MANGLER(RTTraceBufDumpToAssert)
# define RTTraceBufDumpToLog                            RT_MANGLER(RTTraceBufDumpToLog)
# define RTTraceBufEnable                               RT_MANGLER(RTTraceBufEnable)
# define RTTraceBufEnumEntries                          RT_MANGLER(RTTraceBufEnumEntries)
# define RTTraceBufGetEntryCount                        RT_MANGLER(RTTraceBufGetEntryCount)
# define RTTraceBufGetEntrySize                         RT_MANGLER(RTTraceBufGetEntrySize)
# define RTTraceBufRelease                              RT_MANGLER(RTTraceBufRelease)
# define RTTraceBufRetain                               RT_MANGLER(RTTraceBufRetain)
# define RTTraceGetDefaultBuf                           RT_MANGLER(RTTraceGetDefaultBuf)
# define RTTraceSetDefaultBuf                           RT_MANGLER(RTTraceSetDefaultBuf)
# define RTUdpRead                                      RT_MANGLER(RTUdpRead)
# define RTUdpServerCreate                              RT_MANGLER(RTUdpServerCreate)
# define RTUdpServerCreateEx                            RT_MANGLER(RTUdpServerCreateEx)
# define RTUdpServerDestroy                             RT_MANGLER(RTUdpServerDestroy)
# define RTUdpServerListen                              RT_MANGLER(RTUdpServerListen)
# define RTUdpServerShutdown                            RT_MANGLER(RTUdpServerShutdown)
# define RTUdpWrite                                     RT_MANGLER(RTUdpWrite)
# define RTUniFree                                      RT_MANGLER(RTUniFree)
# define RTUriAuthority                                 RT_MANGLER(RTUriAuthority)
# define RTUriCreate                                    RT_MANGLER(RTUriCreate)
# define RTUriFileCreate                                RT_MANGLER(RTUriFileCreate)
# define RTUriFileNPath                                 RT_MANGLER(RTUriFileNPath)
# define RTUriFilePath                                  RT_MANGLER(RTUriFilePath)
# define RTUriFragment                                  RT_MANGLER(RTUriFragment)
# define RTUriHasScheme                                 RT_MANGLER(RTUriHasScheme)
# define RTUriPath                                      RT_MANGLER(RTUriPath)
# define RTUriQuery                                     RT_MANGLER(RTUriQuery)
# define RTUriScheme                                    RT_MANGLER(RTUriScheme)
# define RTUtf16CalcLatin1Len                           RT_MANGLER(RTUtf16CalcLatin1Len)
# define RTUtf16CalcLatin1LenEx                         RT_MANGLER(RTUtf16CalcLatin1LenEx)
# define RTUtf16CalcUtf8Len                             RT_MANGLER(RTUtf16CalcUtf8Len)
# define RTUtf16CalcUtf8LenEx                           RT_MANGLER(RTUtf16CalcUtf8LenEx)
# define RTUtf16Cmp                                     RT_MANGLER(RTUtf16Cmp)
# define RTUtf16DupExTag                                RT_MANGLER(RTUtf16DupExTag)
# define RTUtf16DupTag                                  RT_MANGLER(RTUtf16DupTag)
# define RTUtf16Free                                    RT_MANGLER(RTUtf16Free)
# define RTUtf16GetCpExInternal                         RT_MANGLER(RTUtf16GetCpExInternal)
# define RTUtf16GetCpInternal                           RT_MANGLER(RTUtf16GetCpInternal)
# define RTUtf16ICmp                                    RT_MANGLER(RTUtf16ICmp)
# define RTUtf16Len                                     RT_MANGLER(RTUtf16Len)
# define RTUtf16LocaleICmp                              RT_MANGLER(RTUtf16LocaleICmp)
# define RTUtf16PutCpInternal                           RT_MANGLER(RTUtf16PutCpInternal)
# define RTUtf16ToLatin1ExTag                           RT_MANGLER(RTUtf16ToLatin1ExTag)
# define RTUtf16ToLatin1Tag                             RT_MANGLER(RTUtf16ToLatin1Tag)
# define RTUtf16ToLower                                 RT_MANGLER(RTUtf16ToLower)
# define RTUtf16ToUpper                                 RT_MANGLER(RTUtf16ToUpper)
# define RTUtf16PurgeComplementSet                      RT_MANGLER(RTUtf16PurgeComplementSet)
# define RTUtf16ToUtf8ExTag                             RT_MANGLER(RTUtf16ToUtf8ExTag)
# define RTUtf16ToUtf8Tag                               RT_MANGLER(RTUtf16ToUtf8Tag)
# define RTUuidClear                                    RT_MANGLER(RTUuidClear)
# define RTUuidCompare                                  RT_MANGLER(RTUuidCompare)
# define RTUuidCompare2Strs                             RT_MANGLER(RTUuidCompare2Strs)
# define RTUuidCompareStr                               RT_MANGLER(RTUuidCompareStr)
# define RTUuidCreate                                   RT_MANGLER(RTUuidCreate)
# define RTUuidFromStr                                  RT_MANGLER(RTUuidFromStr)
# define RTUuidFromUtf16                                RT_MANGLER(RTUuidFromUtf16)
# define RTUuidIsNull                                   RT_MANGLER(RTUuidIsNull)
# define RTUuidToStr                                    RT_MANGLER(RTUuidToStr)
# define RTUuidToUtf16                                  RT_MANGLER(RTUuidToUtf16)
# define RTVfsChainElementDeregisterProvider            RT_MANGLER(RTVfsChainElementDeregisterProvider)
# define RTVfsChainElementRegisterProvider              RT_MANGLER(RTVfsChainElementRegisterProvider)
# define RTVfsChainIsSpec                               RT_MANGLER(RTVfsChainIsSpec)
# define RTVfsChainOpenFile                             RT_MANGLER(RTVfsChainOpenFile)
# define RTVfsChainOpenIoStream                         RT_MANGLER(RTVfsChainOpenIoStream)
# define RTVfsChainSpecFree                             RT_MANGLER(RTVfsChainSpecFree)
# define RTVfsChainSpecParse                            RT_MANGLER(RTVfsChainSpecParse)
# define RTVfsDirRelease                                RT_MANGLER(RTVfsDirRelease)
# define RTVfsDirRetain                                 RT_MANGLER(RTVfsDirRetain)
# define RTVfsFileFlush                                 RT_MANGLER(RTVfsFileFlush)
# define RTVfsFileFromRTFile                            RT_MANGLER(RTVfsFileFromRTFile)
# define RTVfsFileGetSize                               RT_MANGLER(RTVfsFileGetSize)
# define RTVfsFileOpen                                  RT_MANGLER(RTVfsFileOpen)
# define RTVfsFilePoll                                  RT_MANGLER(RTVfsFilePoll)
# define RTVfsFileQueryInfo                             RT_MANGLER(RTVfsFileQueryInfo)
# define RTVfsFileRead                                  RT_MANGLER(RTVfsFileRead)
# define RTVfsFileReadAt                                RT_MANGLER(RTVfsFileReadAt)
# define RTVfsFileRelease                               RT_MANGLER(RTVfsFileRelease)
# define RTVfsFileRetain                                RT_MANGLER(RTVfsFileRetain)
# define RTVfsFileSeek                                  RT_MANGLER(RTVfsFileSeek)
# define RTVfsFileTell                                  RT_MANGLER(RTVfsFileTell)
# define RTVfsFileToIoStream                            RT_MANGLER(RTVfsFileToIoStream)
# define RTVfsFileWrite                                 RT_MANGLER(RTVfsFileWrite)
# define RTVfsFileWriteAt                               RT_MANGLER(RTVfsFileWriteAt)
# define RTVfsFsStrmNext                                RT_MANGLER(RTVfsFsStrmNext)
# define RTVfsFsStrmQueryInfo                           RT_MANGLER(RTVfsFsStrmQueryInfo)
# define RTVfsFsStrmRelease                             RT_MANGLER(RTVfsFsStrmRelease)
# define RTVfsFsStrmRetain                              RT_MANGLER(RTVfsFsStrmRetain)
# define RTVfsIoStreamToPrivate                         RT_MANGLER(RTVfsIoStreamToPrivate)
# define RTVfsIoStrmFlush                               RT_MANGLER(RTVfsIoStrmFlush)
# define RTVfsIoStrmFromRTFile                          RT_MANGLER(RTVfsIoStrmFromRTFile)
# define RTVfsIoStrmFromStdHandle                       RT_MANGLER(RTVfsIoStrmFromStdHandle)
# define RTVfsIoStrmIsAtEnd                             RT_MANGLER(RTVfsIoStrmIsAtEnd)
# define RTVfsIoStrmPoll                                RT_MANGLER(RTVfsIoStrmPoll)
# define RTVfsIoStrmQueryInfo                           RT_MANGLER(RTVfsIoStrmQueryInfo)
# define RTVfsIoStrmRead                                RT_MANGLER(RTVfsIoStrmRead)
# define RTVfsIoStrmReadAt                              RT_MANGLER(RTVfsIoStrmReadAt)
# define RTVfsIoStrmRelease                             RT_MANGLER(RTVfsIoStrmRelease)
# define RTVfsIoStrmRetain                              RT_MANGLER(RTVfsIoStrmRetain)
# define RTVfsIoStrmSgRead                              RT_MANGLER(RTVfsIoStrmSgRead)
# define RTVfsIoStrmSgWrite                             RT_MANGLER(RTVfsIoStrmSgWrite)
# define RTVfsIoStrmSkip                                RT_MANGLER(RTVfsIoStrmSkip)
# define RTVfsIoStrmTell                                RT_MANGLER(RTVfsIoStrmTell)
# define RTVfsIoStrmToFile                              RT_MANGLER(RTVfsIoStrmToFile)
# define RTVfsIoStrmValidateUtf8Encoding                RT_MANGLER(RTVfsIoStrmValidateUtf8Encoding)
# define RTVfsIoStrmWrite                               RT_MANGLER(RTVfsIoStrmWrite)
# define RTVfsIoStrmWriteAt                             RT_MANGLER(RTVfsIoStrmWriteAt)
# define RTVfsIoStrmZeroFill                            RT_MANGLER(RTVfsIoStrmZeroFill)
# define RTVfsIsRangeInUse                              RT_MANGLER(RTVfsIsRangeInUse)
# define RTVfsLockAcquireReadSlow                       RT_MANGLER(RTVfsLockAcquireReadSlow)
# define RTVfsLockAcquireWriteSlow                      RT_MANGLER(RTVfsLockAcquireWriteSlow)
# define RTVfsLockRelease                               RT_MANGLER(RTVfsLockRelease)
# define RTVfsLockReleaseReadSlow                       RT_MANGLER(RTVfsLockReleaseReadSlow)
# define RTVfsLockReleaseWriteSlow                      RT_MANGLER(RTVfsLockReleaseWriteSlow)
# define RTVfsLockRetain                                RT_MANGLER(RTVfsLockRetain)
# define RTVfsMemorizeIoStreamAsFile                    RT_MANGLER(RTVfsMemorizeIoStreamAsFile)
# define RTVfsNew                                       RT_MANGLER(RTVfsNew)
# define RTVfsNewBaseObj                                RT_MANGLER(RTVfsNewBaseObj)
# define RTVfsNewFile                                   RT_MANGLER(RTVfsNewFile)
# define RTVfsNewFsStream                               RT_MANGLER(RTVfsNewFsStream)
# define RTVfsNewIoStream                               RT_MANGLER(RTVfsNewIoStream)
# define RTVfsNewSymlink                                RT_MANGLER(RTVfsNewSymlink)
# define RTVfsObjFromDir                                RT_MANGLER(RTVfsObjFromDir)
# define RTVfsObjFromFile                               RT_MANGLER(RTVfsObjFromFile)
# define RTVfsObjFromFsStream                           RT_MANGLER(RTVfsObjFromFsStream)
# define RTVfsObjFromIoStream                           RT_MANGLER(RTVfsObjFromIoStream)
# define RTVfsObjFromSymlink                            RT_MANGLER(RTVfsObjFromSymlink)
# define RTVfsObjFromVfs                                RT_MANGLER(RTVfsObjFromVfs)
# define RTVfsObjQueryInfo                              RT_MANGLER(RTVfsObjQueryInfo)
# define RTVfsObjRelease                                RT_MANGLER(RTVfsObjRelease)
# define RTVfsObjRetain                                 RT_MANGLER(RTVfsObjRetain)
# define RTVfsObjToDir                                  RT_MANGLER(RTVfsObjToDir)
# define RTVfsObjToFile                                 RT_MANGLER(RTVfsObjToFile)
# define RTVfsObjToFsStream                             RT_MANGLER(RTVfsObjToFsStream)
# define RTVfsObjToIoStream                             RT_MANGLER(RTVfsObjToIoStream)
# define RTVfsObjToSymlink                              RT_MANGLER(RTVfsObjToSymlink)
# define RTVfsObjToVfs                                  RT_MANGLER(RTVfsObjToVfs)
# define RTVfsParsePath                                 RT_MANGLER(RTVfsParsePath)
# define RTVfsParsePathA                                RT_MANGLER(RTVfsParsePathA)
# define RTVfsParsePathAppend                           RT_MANGLER(RTVfsParsePathAppend)
# define RTVfsParsePathFree                             RT_MANGLER(RTVfsParsePathFree)
# define RTVfsRelease                                   RT_MANGLER(RTVfsRelease)
# define RTVfsRetain                                    RT_MANGLER(RTVfsRetain)
# define RTVfsSymlinkQueryInfo                          RT_MANGLER(RTVfsSymlinkQueryInfo)
# define RTVfsSymlinkRead                               RT_MANGLER(RTVfsSymlinkRead)
# define RTVfsSymlinkRelease                            RT_MANGLER(RTVfsSymlinkRelease)
# define RTVfsSymlinkRetain                             RT_MANGLER(RTVfsSymlinkRetain)
# define RTVfsSymlinkSetMode                            RT_MANGLER(RTVfsSymlinkSetMode)
# define RTVfsSymlinkSetOwner                           RT_MANGLER(RTVfsSymlinkSetOwner)
# define RTVfsSymlinkSetTimes                           RT_MANGLER(RTVfsSymlinkSetTimes)
# define RTVfsUtilDummyPollOne                          RT_MANGLER(RTVfsUtilDummyPollOne)
# define RTVfsUtilPumpIoStreams                         RT_MANGLER(RTVfsUtilPumpIoStreams)
# define RTZipBlockCompress                             RT_MANGLER(RTZipBlockCompress)
# define RTZipBlockDecompress                           RT_MANGLER(RTZipBlockDecompress)
# define RTZipCompCreate                                RT_MANGLER(RTZipCompCreate)
# define RTZipCompDestroy                               RT_MANGLER(RTZipCompDestroy)
# define RTZipCompFinish                                RT_MANGLER(RTZipCompFinish)
# define RTZipCompress                                  RT_MANGLER(RTZipCompress)
# define RTZipDecompCreate                              RT_MANGLER(RTZipDecompCreate)
# define RTZipDecompDestroy                             RT_MANGLER(RTZipDecompDestroy)
# define RTZipDecompress                                RT_MANGLER(RTZipDecompress)
# define RTZipGzipDecompressIoStream                    RT_MANGLER(RTZipGzipDecompressIoStream)
# define RTZipTarCmd                                    RT_MANGLER(RTZipTarCmd)
# define RTZipTarFsStreamFromIoStream                   RT_MANGLER(RTZipTarFsStreamFromIoStream)

/*
 * Stable variables (alphabetical order):
 */
# define g_apfnRTZlibDeps                               RT_MANGLER(g_apfnRTZlibDeps) /* os2 win solaris */
# define g_aRTUniFlagsRanges                            RT_MANGLER(g_aRTUniFlagsRanges)
# define g_aRTUniLowerRanges                            RT_MANGLER(g_aRTUniLowerRanges)
# define g_aRTUniUpperRanges                            RT_MANGLER(g_aRTUniUpperRanges)
# define g_fRTAlignmentChecks                           RT_MANGLER(g_fRTAlignmentChecks)
# define g_hKrnlDbgInfo                                 RT_MANGLER(g_hKrnlDbgInfo) /* solaris */
# define g_pStdErr                                      RT_MANGLER(g_pStdErr)
# define g_pStdIn                                       RT_MANGLER(g_pStdIn)
# define g_pStdOut                                      RT_MANGLER(g_pStdOut)
# define g_pszRTAssertExpr                              RT_MANGLER(g_pszRTAssertExpr)
# define g_pszRTAssertFile                              RT_MANGLER(g_pszRTAssertFile)
# define g_pszRTAssertFunction                          RT_MANGLER(g_pszRTAssertFunction)
# define g_szRTAssertMsg1                               RT_MANGLER(g_szRTAssertMsg1)
# define g_szRTAssertMsg2                               RT_MANGLER(g_szRTAssertMsg2)
# define g_u32RTAssertLine                              RT_MANGLER(g_u32RTAssertLine)



/*
 * Unstable functions (alphabetical order):
 */
/** @todo the list is incomplete! See the .def files + libraries. */


/*
 * Unstable variables (alphabetical order):
 */
/* none */

#endif /* !DOXYGEN_RUNNING */

#endif

