/* $Id: RTAssertShouldPanic-generic.cpp 135976 2020-02-04 10:35:17Z bird $ */
/** @file
 * IPRT - Assertions, generic RTAssertShouldPanic.
 */

/*
 * Copyright (C) 2006-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */


/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include <iprt/assert.h>
#include "internal/iprt.h"

#ifdef IN_RING
# if 0
#  include <iprt/asm.h>
#  include <iprt/asm-amd64-x86.h>
# endif
#endif


RTDECL(bool) RTAssertShouldPanic(void)
{
#ifdef IN_RING0
# if 0 /* this can be useful when debugging guests. */
    ASMIntDisable();
    ASMHalt();
# endif
#endif
#if 0 /* Enable this to not panic on assertions. (Make sure this code is used!) */
    return false;
#else
    return RTAssertMayPanic();
#endif
}
RT_EXPORT_SYMBOL(RTAssertShouldPanic);

