#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <string.h>
#include <time.h>
#include <math.h>


GtkWidget *day_spinner;
GtkWidget *month_spinner;
GtkWidget *hour_spinner;
GtkWidget *min_spinner;
GtkWidget *name_entry;
GtkWidget *preset_combo;
GtkWidget *dur_spinner1;
GtkWidget *dur_spinner2;
GtkWidget *bitrate_spinner;

int mp3=0;
int widescr=0;
int month_today, date_today, year_today;
int debug=0;





/*****************************************************************************/
/* get current date for default values	                                     */
/*****************************************************************************/

void get_date() 
{
    time_t     time_today;
    struct tm  *ts;
    if (debug) printf("getting date:\n");
    time(&time_today);
    ts = localtime(&time_today);
    
    date_today = ts->tm_mday;
    month_today = ts->tm_mon + 1;
    year_today = ts->tm_year+1900;
    if (debug) printf("today: %d.%d.%d\n",date_today,month_today,year_today);
}



/*****************************************************************************/
/* exit, right now...                                                        */
/*****************************************************************************/

void myexit() 
{
    gtk_main_quit();
}



void done_dialog(gchar *message)
{
    GtkWidget *window;
    GtkWidget *button;
    GtkWidget *label;
    
    window = gtk_dialog_new ();
    label = gtk_label_new (message);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->vbox),
                        label, TRUE, TRUE, 0);
    gtk_widget_show (label);
    button = gtk_button_new_with_label ("OK");
    gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (window));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window)->action_area),
                        button, TRUE, TRUE, 0);
    gtk_widget_show (button);
    gtk_container_set_border_width (GTK_CONTAINER (window), 10);
    gtk_widget_show_all(window);
}    
    
/*****************************************************************************/
/* after "ok" was clicked, get values and run "at" with vcr-commandline...   */
/*****************************************************************************/

void ok_clicked( GtkWidget *widget,
                 gpointer   data )
{
    int hr, min, day, mnth, year;
    gchar buf[256];
    gchar filename[256];
    FILE * tmpfile;

    hr =   gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (hour_spinner));
    min =  gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (min_spinner));
    day =  gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (day_spinner));
    mnth = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (month_spinner));
    year = year_today;
    if (mnth < month_today) year = year_today+1;
    else if ((mnth == month_today) && (day < date_today))
       year = year_today+1;
    printf("\n\n\n************************\n");
    printf(      "  schedule task:\n");
    sprintf(buf, "vcr -p %s -t %dm -a BitRate=%d ",
         gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(preset_combo)->entry)),
	 gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(dur_spinner2)),
	 gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(bitrate_spinner)) );
    if (mp3) strcat(buf,"-b 128 ");
    if (widescr) strcat(buf,"-w 0,42,384,204 ");
    strcat(buf,gtk_entry_get_text(GTK_ENTRY(name_entry)) );
    
    sprintf(filename, "vcr%d_%d_%d_%d", mnth,day,hr,min);

    strcat(buf," >> ");
    strcat(buf,filename);
    strcat(buf,"\n");
    g_print (buf);

    tmpfile = fopen(filename,"w");
    if (tmpfile == NULL) 
    {
       printf("\n could not create file %s!\n",filename);
       myexit();
    }
    fprintf(tmpfile,buf);
    fclose(tmpfile);

    sprintf (buf, "at %d:%d %d.%d.%d -f %s\n",
             hr,min,day,mnth,year,filename);
    g_print(buf);
    printf ("************************\n\n\n");
    /* execute 'at' from command line */
    system(buf);
    
    done_dialog("Scheduled this job. You can add \n more now if you want.");
}



/*****************************************************************************/
/* if one of the "duration"-spinners was changed, look if we have to change  */
/* the other...                                                              */
/*****************************************************************************/

void change_dur( GtkWidget *widget,
                 GtkWidget *spin )
{
  gfloat d1 = gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (dur_spinner1));
  gfloat d2 = gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (dur_spinner2));
  
  if (spin==dur_spinner1) {
     if (d1>d2)
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (dur_spinner2),d1); 
  }
  else if (spin==dur_spinner2) {
     if (d1>d2)
       gtk_spin_button_set_value (GTK_SPIN_BUTTON (dur_spinner1),d2); 
  }
}



/*****************************************************************************/
/* calculate a bitrate depending on the duration without advertising.        */
/* this one assumes 128 kbps audio and tries to get files fitting on 700 MB. */
/* works for low-motion DivX. I use 384x288, don't know if it works for      */
/* resolutions as well.                                                      */
/*****************************************************************************/

void recommend_bitrate( GtkWidget     *widget,
                        gpointer      data )
{
  gfloat d1 = gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (dur_spinner1));
  gfloat rec_br = 812956 * pow(d1,-1.1143);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (bitrate_spinner),rec_br);
}


/*****************************************************************************/

void toggle_mp3( GtkWidget     *widget,
                 gpointer      data )
{
  if (mp3) mp3=0; else mp3=1;
}

/*****************************************************************************/

void toggle_widescr( GtkWidget     *widget,
                     gpointer      data )
{
  if (widescr) widescr=0; else widescr=1;
}



/*****************************************************************************/
/* read ~/.vcrrc for channel-presets and fill the combobox with them...      */
/*****************************************************************************/

void fill_combo( GtkWidget  *widget, char **env)
{
   GList *glist=NULL;
   FILE  *rcfile;
   char  line[1024],value[256][192];
   int nr=0;
   char homedir[256];

   if (debug) printf("Filling stations-combobox...\n");   
   while (*env !=NULL) 
   {
     strcpy(line,*env++);
     if (1== sscanf(line,"HOME=%s",homedir))
     {
	   strcpy(homedir,(line+5));
	   break;
     }
   }
   if (homedir == NULL)
   {
     printf("\n Could not get $HOME !\n");
     myexit();
   } 
   else
     if (debug) printf("found homedir: %s\n",homedir);  
   strcat(homedir,"/.vcrrc");
   rcfile = fopen(homedir,"r");
   if ( rcfile == NULL) 
   {
     printf("\n Could not open vcr config file %s !\n",homedir);
     exit(1);
   }   
   while (NULL != fgets(line,255,rcfile)) {
	if (line[0] == '\n' || line[0] == '#' || line[0] == '%')
	    continue;
	if (1 == sscanf(line,"[%99[^]]]",value[nr])) {}
	if ((line[0]=='c') && (line[1]=='h') &&
	    (line[2]=='a') && (line[3]=='n') &&
	    (line[4]=='n') && (line[5]=='e') &&
	    (line[6]=='l')) 
        {
	    glist = g_list_append(glist, value[nr]);
	    if (debug) printf("found: %s\n",value[nr]);
	    nr++;
        } 
   }
   fclose(rcfile);
   if ( glist == NULL ) 
   {
     printf("\n No station presets found in config file!\n");
     myexit();
   }
   gtk_combo_set_popdown_strings( GTK_COMBO(widget), glist) ;
}



/*****************************************************************************/
/* build gui and show it                                                     */ 
/*****************************************************************************/

void make_gui()
{
  GtkWidget *window;
  GtkWidget *frame;
  GtkWidget *hbox;
  GtkWidget *main_vbox;
  GtkWidget *vbox;
  GtkWidget *vbox2;
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);

  gtk_window_set_title (GTK_WINDOW (window), "sched");

  main_vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 10);
  gtk_container_add (GTK_CONTAINER (window), main_vbox);


  frame = gtk_frame_new ("Record:");
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);

  label = gtk_label_new ("Name:");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);

  name_entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(name_entry),"~/Video/movie.avi");
  gtk_box_pack_start (GTK_BOX (hbox), name_entry, TRUE, TRUE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
  gtk_container_add (GTK_CONTAINER (vbox), hbox);
  
  label = gtk_label_new ("From station:");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 5);

  preset_combo = gtk_combo_new();
  gtk_box_pack_start (GTK_BOX (hbox), preset_combo, TRUE, TRUE, 0);
  

  frame = gtk_frame_new ("At time:");
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("Day :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (date_today, 1.0, 31.0, 1.0,
                                               5.0, 0.0);
   day_spinner = gtk_spin_button_new (adj, 0, 0);
   gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (day_spinner), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox2), day_spinner, FALSE, TRUE, 0);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("Month :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (month_today, 1.0, 12.0, 1.0,
                                               5.0, 0.0);
   month_spinner = gtk_spin_button_new (adj, 0, 0);
   gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (month_spinner), TRUE);
  gtk_box_pack_start (GTK_BOX (vbox2), month_spinner, FALSE, TRUE, 0);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("Hour :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (20.0, 0.0, 23.0,
                                               1.0, 5.0, 0.0);
   hour_spinner = gtk_spin_button_new (adj, 0, 0);
   gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (hour_spinner), FALSE);
  gtk_box_pack_start (GTK_BOX (vbox2), hour_spinner, FALSE, TRUE, 0);

  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("Min :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (14.0, 0.0, 59.0,
                                               1.0, 100.0, 0.0);
   min_spinner = gtk_spin_button_new (adj, 0, 0);
   gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (min_spinner), FALSE);
  gtk_box_pack_start (GTK_BOX (vbox2), min_spinner, FALSE, TRUE, 0);


  frame = gtk_frame_new ("Duration:");
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), hbox);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("without ads :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (100.0, 1.0, 1000.0, 1.0,
                                               10.0, 0.0);
   dur_spinner1 = gtk_spin_button_new (adj, 0, 0);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (change_dur),
                       (gpointer) dur_spinner1);

  gtk_box_pack_start (GTK_BOX (vbox2), dur_spinner1, FALSE, TRUE, 0);
  
  vbox2 = gtk_vbox_new (FALSE, 0);
   gtk_box_pack_start (GTK_BOX (hbox), vbox2, TRUE, TRUE, 5);
  
   label = gtk_label_new ("with ads :");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_box_pack_start (GTK_BOX (vbox2), label, FALSE, TRUE, 0);
  
   adj = (GtkAdjustment *) gtk_adjustment_new (100.0, 1.0, 1000.0, 1.0,
                                               10.0, 0.0);
   dur_spinner2 = gtk_spin_button_new (adj, 0, 0);
   gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
                       GTK_SIGNAL_FUNC (change_dur),
                       (gpointer) dur_spinner2);
  gtk_box_pack_start (GTK_BOX (vbox2), dur_spinner2, FALSE, TRUE, 0);
  


  frame = gtk_frame_new ("Options");
  gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 0);
  
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
      
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 5);

  label = gtk_label_new ("BitRate :");
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 5);

  adj = (GtkAdjustment *) gtk_adjustment_new (4800.0, 1.0, 10000.0, 1.0,
                                               10.0, 0.0);
  bitrate_spinner = gtk_spin_button_new (adj, 0, 0);
  gtk_spin_button_set_wrap (GTK_SPIN_BUTTON (bitrate_spinner), FALSE);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (bitrate_spinner), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), bitrate_spinner, TRUE, TRUE, 0);

  button = gtk_button_new_with_label ("recommend");
  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (recommend_bitrate),
                      NULL);
      
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 5);
  
  button = gtk_check_button_new_with_label ("Audio mp3-compressed");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (toggle_mp3),
                      NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
  
  button = gtk_check_button_new_with_label ("widescreen");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (toggle_widescr),
                      NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);


  hbox = gtk_hbox_new (TRUE, 0);
  gtk_box_pack_start (GTK_BOX (main_vbox), hbox, FALSE, TRUE, 5);
  
  button = gtk_button_new_with_label ("OK");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (ok_clicked),
                             NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

  button = gtk_button_new_with_label ("Exit");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_main_quit),
                             NULL);
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);

  gtk_widget_show_all (window);
}




int main( int   argc,
          char *argv[],
	  char **env )
{

  
  get_date();
  gtk_init(&argc, &argv);
  
  /* build gui and show it */ 
  make_gui();
  /* fill the channel-combobox with presets from .vcrrc */
  fill_combo (preset_combo,env);
  
  gtk_main ();
    
  return(0);
}
