/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import virtuoso.jdbc2.VirtuosoBlob;

class VirtuosoClobStream
extends InputStream {
    private VirtuosoBlob clob;
    protected long pos = 1L;

    VirtuosoClobStream(VirtuosoBlob virtuosoBlob) {
        this.clob = virtuosoBlob;
    }

    public int read() throws IOException {
        try {
            return this.pos > this.clob.length() ? -1 : this.clob.getSubString(this.pos++, 1).getBytes("ASCII")[0];
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            byte[] byArray2 = null;
            if (n2 <= 0) {
                return 0;
            }
            if (this.pos + (long)n2 > this.clob.length()) {
                int n3 = (int)(this.clob.length() - this.pos + 1L);
                if (n3 > 0) {
                    byArray2 = this.clob.getSubString(this.pos, n3).getBytes("ASCII");
                }
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                    this.pos = this.clob.length() + 1L;
                    return byArray2.length;
                }
                return -1;
            }
            byArray2 = this.clob.getSubString(this.pos, n2).getBytes("ASCII");
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray, n, n2);
                this.pos += (long)byArray2.length;
                return byArray2.length;
            }
            return -1;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public long skip(long l) throws IOException {
        try {
            if (l <= 0L) {
                return 0L;
            }
            if (this.pos + l > this.clob.length()) {
                long l2 = this.clob.length() - this.pos;
                this.pos = this.clob.length();
                return l2;
            }
            this.pos += l;
            return l;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public int available() throws IOException {
        try {
            return (int)(this.clob.length() - this.pos + 1L);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }
}

