static const char gears_hlsl[] =
"cbuffer gear_block : register(b0)\n"
"{\n"
"    float4x4 mvp_matrix;\n"
"    float3x3 normal_matrix;\n"
"};\n"
"\n"
"struct vs_in\n"
"{\n"
"    float4 position : POSITION;\n"
"    float3 normal : NORMAL;\n"
"    float3 diffuse : DIFFUSE;\n"
"    float4 transform : TRANSFORM;\n"
"};\n"
"\n"
"struct vs_out\n"
"{\n"
"    float4 position : SV_POSITION;\n"
"    float4 colour : COLOR;\n"
"};\n"
"\n"
"struct vs_out vs_main(struct vs_in i)\n"
"{\n"
"    const float3 l_pos = float3(5.0, 5.0, 10.0);\n"
"    float3 dir, normal;\n"
"    float4 position;\n"
"    struct vs_out o;\n"
"    float att;\n"
"\n"
"    position.x = i.transform.x * i.position.x - i.transform.y * i.position.y + i.transform.z;\n"
"    position.y = i.transform.x * i.position.y + i.transform.y * i.position.x + i.transform.w;\n"
"    position.zw = i.position.zw;\n"
"\n"
"    o.position = mul(mvp_matrix, position);\n"
"    dir = normalize(l_pos - o.position.xyz / o.position.w);\n"
"\n"
"    normal.x = i.transform.x * i.normal.x - i.transform.y * i.normal.y;\n"
"    normal.y = i.transform.x * i.normal.y + i.transform.y * i.normal.x;\n"
"    normal.z = i.normal.z;\n"
"    att = 0.2 + dot(dir, normalize(mul(normal_matrix, normal)));\n"
"\n"
"    o.colour.xyz = i.diffuse.xyz * att;\n"
"    o.colour.w = 1.0;\n"
"\n"
"    return o;\n"
"}\n"
"\n"
"float4 ps_main_smooth(float4 position : SV_POSITION, float4 colour : COLOR) : SV_TARGET\n"
"{\n"
"    return colour;\n"
"}\n"
"\n"
"float4 ps_main_flat(float4 position : SV_POSITION, nointerpolation float4 colour : COLOR) : SV_TARGET\n"
"{\n"
"    return colour;\n"
"}\n";
