/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef _VNET_H
#define _VNET_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_VMMEXT
#include "includeCheck.h"
#include "vm_basic_types.h"
#include "vm_atomic.h"


#define VNET_PVN_ABI_ID_LEN    (256 / 8)  // bytes used on ioctl()
#define VNET_PVN_ID_LEN        (160 / 8)  // actual length used

#define VNET_BIND_VERSION  0x1
#define VNET_BIND_TO_VNET  0x1
#define VNET_BIND_TO_PVN   0x2

typedef struct VNet_Bind {
   uint32 version;                 // VNET_BIND_VERSION
   uint32 bindType;                // VNET_BIND_TO_xxx
   int32 number;                   // used for VNET_BIND_TO_VNET
   uint8  id[VNET_PVN_ABI_ID_LEN]; // used for VNET_BIND_TO_PVN
} VNet_Bind;

/*
 * We define customized ioctl commands by adding 0x1000
 * to the standard Linux definitions.
 * 
 * See comments in iocontrols.h
 */

#define VNET_FIRST_CMD     0x99F2

// #define SIOCSKEEP          0x99F0  // not used
// #define SIOCGKEEP          0x99F1  // not used
#define SIOCSLADRF         0x99F2
#define SIOCPORT           0x99F3
#define SIOCBRIDGE         0x99F4
#define SIOCNETIF          0x99F5

#define SIOCSETMACADDR     0x99F6
#define SIOCSSWITCHMAP     0x99F7
#define SIOCSETNOTIFY      0x99F8
#define SIOCUNSETNOTIFY    0x99F9
#define SIOCSETCLUSTERSIZE 0x99FA
#define SIOCSETNOTIFY2     0x99FB
#define SIOCGETAPIVERSION  0x99FC

#define VNET_LAST_CMD      0x99FC

#ifdef linux
#define SIOCGETAPIVERSION2 _IOWR(0x99, 0xE0, uint32)
#define SIOCGBRSTATUS	    _IOR(0x99, 0xFD, uint32)
#define SIOCSPEER	    _IOW(0x99, 0xFE, char[8])
#define SIOCSPEER2          _IOW(0x99, 0xFE, char[32])
#define SIOCSBIND           _IOW(0x99, 0xFF, VNet_Bind)
#endif

// #define OLD_SIOCSKEEP          0x89F0  // not used
// #define OLD_SIOCGKEEP          0x89F1  // not used
#define OLD_SIOCSLADRF         0x89F2
#define OLD_SIOCPORT           0x89F3
#define OLD_SIOCBRIDGE         0x89F4
#define OLD_SIOCNETIF          0x89F5
#define OLD_SIOCSETMACADDR     0x89F6
#define OLD_SIOCSSWITCHMAP     0x89F7
#define OLD_SIOCSETNOTIFY      0x89F8
#define OLD_SIOCUNSETNOTIFY    0x89F9
#define OLD_SIOCSETCLUSTERSIZE 0x89FA
#define OLD_SIOCSETNOTIFY2     0x89FB
#define OLD_SIOCGETAPIVERSION  0x89FC


/*
 * VMnet driver version.
 *
 * Increment major version when you make an incompatible change.
 * Compatibility goes both ways (old driver with new executable
 * as well as new driver with old executable).
 *
 * Features under the VNET_API_DEPRECATED define are deprecated (so don't use
 * them), but are not important enough to justify an increase of major version.
 * However, if for some other reason you need to bump the major version, please
 * also remove all code under the VNET_API_DEPRECATED define. --hpreg
 */

#define VNET_API_VERSION_WS45		(2 << 16 | 0)
#ifdef linux
#define VNET_API_VERSION		(3 << 16 | 0)
#else
#define VNET_API_VERSION                (4 << 16 | 0)
#endif
#define VNET_API_VERSION_MAJOR(v)	((uint32) (v) >> 16)
#define VNET_API_VERSION_MINOR(v)	((uint16) (v))

/*
 * Make sure the deprecated code will not be compiled anymore starting with the
 * next major version. --hpreg
 */
#ifdef linux
#   if VNET_API_VERSION < (999 << 16 | 0)
#      define VNET_API_DEPRECATED 1
#   endif
#else
#   if VNET_API_VERSION < (4 << 16 | 0)
#      define VNET_API_DEPRECATED 1
#   endif
#endif

/* version 1 structure */

typedef struct VNet_SetMacAddrIOCTL {
   int             version;
   unsigned char   addr[6];
   unsigned        flags;
} VNet_SetMacAddrIOCTL;

typedef struct VNet_NotifyH {
   int              version;
} VNet_NotifyH;

typedef struct VNet_Notify1 {
   int              version;
   uint32           actPtr;
   uint32 volatile  pollPtr;
   uint32           actMask;
   uint32           pollMask;
} VNet_Notify1;

typedef struct VNet_Notify2 {
   int              version;
   uint32           actPtr;
   uint32 volatile  pollPtr;
   uint32 volatile  recvClusterPtr;
   uint32           actMask;
   uint32           pollMask;
} VNet_Notify2;

#define VNET_SETMACADDRF_UNIQUE      0x01
/*
 * The latest 802.3 standard sort of says that the length field ought to
 * be less than 1536 (for VLAN tagging support). I am choosing 1532
 * as our max VNET_MTU size, as I'd rather keep it a multiple of 4 and
 * VLAN tagging uses only upto 1518 bytes.
 */
#define VNET_MTU                     1532


#define VNET_BUF_TOO_SMALL           -1

/*
 *  vlan switch stuff
 */


#define VNET_MAX_VLANS     255

struct VNetSwitchMap {
   int  trunk;
   int  vlan;
   int  connect;
   int  vnet;
};

#endif
