/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved.
 * -- VMware Confidential
 * **********************************************************/

/*
 * vm_asm_x86_64.h
 *
 *	x86-64 asm macros
 */

#ifndef _VM_ASM_X86_64_H_
#define _VM_ASM_X86_64_H_

#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMKERNEL
#include "includeCheck.h"

#include "x86.h"
#ifdef __GNUC__
#include "vm_asm_x86.h"
#endif

/*
 * This file contains inline assembly routines used by x86_64 code.
 * 
 * XXX TODO: All code under _MSC_VER have not been implemented.
 */

#ifdef __GNUC__

_BUILD_SET_R(SET_CR8, cr8)
_BUILD_GET_R(cr8)
#define GET_CR8(var) do { \
   var = _Get_cr8();      \
} while (0)

#elif _MSC_VER  /* !__GNUC__ */

/*
 * x86-64 windows doesn't support inline asm so we have to use these
 * intrinsic functions defined in the compiler.  Not all of these are well
 * documented.  There is an array in the compiler dll (c1.dll) which has
 * an array of the names of all the intrinsics minus the leading
 * underscore.  Searching around in the ntddk.h file can also be helpful.
 *
 * The declarations for the intrinsic functions were taken from the DDK. 
 * Our declarations must match the ddk's otherwise the 64-bit c++ compiler
 * will complain about second linkage of the intrinsic functions.
 * We define the intrinsic using the basic types corresponding to the 
 * Windows typedefs. This avoids having to include windows header files
 * to get to the windows types.
 */

#ifdef __cplusplus
extern "C" {
#endif
unsigned __int64  __readmsr(unsigned long);
void              __writemsr(unsigned long, unsigned __int64);
#pragma intrinsic(__readmsr, __writemsr)
#ifdef __cplusplus
}
#endif

static INLINE uint64 __GET_MSR(int input)
{
   return __readmsr((unsigned long)input);
}   
static INLINE void __SET_MSR(int cx, uint64 val)
{
  __writemsr((unsigned long)cx, (unsigned __int64)val);
}

#else
#error No compiler defined for get/set
#endif /* !__GNUC__ && !_MSC_VER */


static INLINE void SET_FS64(uint64 fs64)
{
   __SET_MSR(0xc0000100, fs64);
}

static INLINE void SET_GS64(uint64 gs64)
{
   __SET_MSR(0xc0000101, gs64);
}

static INLINE void SET_KernelGS64(uint64 kgs64)
{
   __SET_MSR(0xc0000102, kgs64);
}

static INLINE uint64 GET_FS64(void)
{
   return __GET_MSR(0xc0000100);
}

static INLINE uint64 GET_GS64(void)
{
   return __GET_MSR(0xc0000101);
}

static INLINE uint64 GET_KernelGS64(void)
{
   return __GET_MSR(0xc0000102);
}

#ifdef __GNUC__
static INLINE void
SWAPGS(void)
{
   __asm__ __volatile__("swapgs");
}
#endif

#endif
