/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * basic_initblock.h --
 *
 *    VM initialization block.
 */

#ifndef _BASIC_INITBLOCK_H_
#define _BASIC_INITBLOCK_H_


#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_VMMEXT
#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMNIXMOD
#define INCLUDE_ALLOW_VMKERNEL
#define INCLUDE_ALLOW_VMK_MODULE
#define INCLUDE_ALLOW_DISTRIBUTE
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"


#include "vcpuid.h"


#define MAX_INITBLOCK_CPUS      32


typedef
#include "vmware_pack_begin.h"
struct InitBlock {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC) */
#ifdef _WIN32
   int    usercallHandle;
#endif
   Vcpuid numVCPUs;
   VA32   crosspage[MAX_INITBLOCK_CPUS];
   uint32 vmInitFailurePeriod;
}
#include "vmware_pack_end.h"
InitBlock;


#endif // _BASIC_INITBLOCK_H_
