/* **********************************************************
 * Copyright (C) 2006 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 19)
#include <linux/fs.h>

/*
 * Around 2.6.18, the super_block pointer in statfs was changed to a dentry
 * pointer. Red Hat backported this behavior into a 2.6.17 kernel.
 *
 * This test will fail on a kernel with such a patch.
 */
static int LinuxDriverStatFs(struct super_block *sb,
                             struct kstatfs *stat) 
{
   return 0;
}

struct super_operations super_ops = {
   .statfs = LinuxDriverStatFs
};
#else
#error "This test intentionally fails on 2.6.19 and newer kernels."
#endif
