/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/



#ifndef TASK_H
#define TASK_H

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

struct InitBlock;

extern int Task_InitCrosspage(VMDriver *vm, struct InitBlock *params);
extern void Task_Switch(VMDriver *vm, Vcpuid vcpuid);
extern Bool Task_Initialize(void);
extern void Task_Terminate(void);

extern Bool Task_SystemCallMSRInitialize(void);
extern void Task_SystemCallMSRReset(void);
extern void Task_Switch_V45(VMDriver *vm, Vcpuid vcpuid);
extern void Task_Switch_V5(VMDriver *vm, Vcpuid vcpuid);
extern void Task_Switch_V55(VMDriver *vm, Vcpuid vcpuid);
extern void Task_Switch_S1B1(VMDriver *vm, Vcpuid vcpuid);
extern void Task_Switch_V6(VMDriver *vm, Vcpuid vcpuid);
extern void Task_Switch_TOT(VMDriver *vm, Vcpuid vcpuid);
extern int Task_CheckPadding(void);
#endif



