/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciHashtable.h --
 *
 *	Hash table for use in the APIs.
 */

#ifndef _VMCI_HASHTABLE_H_
#define _VMCI_HASHTABLE_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmci_kernel_defs.h"
#include "vmci_defs.h"

typedef struct VMCIHashEntry {
   VMCIHandle             handle;
   int                  refCount;
   struct VMCIHashEntry *next;
} VMCIHashEntry;

typedef struct VMCIHashTable {
   VMCIHashEntry **entries;
   int           size; // Number of buckets in above array.
   VMCILock lock;
} VMCIHashTable;

VMCIHashTable *VMCIHashTable_Create(int size);
void VMCIHashTable_Destroy(VMCIHashTable *table);
void VMCIHashTable_InitEntry(VMCIHashEntry *entry, VMCIHandle handle);
int VMCIHashTable_AddEntry(VMCIHashTable *table, VMCIHashEntry *entry);
int VMCIHashTable_RemoveEntry(VMCIHashTable *table, VMCIHashEntry *entry);
VMCIHashEntry *VMCIHashTable_GetEntry(VMCIHashTable *table, VMCIHandle handle);
int VMCIHashTable_ReleaseEntry(VMCIHashTable *table, VMCIHashEntry *entry);
Bool VMCIHashTable_EntryExists(VMCIHashTable *table, VMCIHandle handle);

#endif // _VMCI_HASHTABLE_H_
