/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciSharedMem.h --
 *
 *	Internal functions in the VMCI Simple Shared Memory API.
 */

#ifndef _VMCI_SHAREDMEM_H_
#define _VMCI_SHAREDMEM_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"
#include "vmciContext.h"
#include "vmciProcess.h"
#include "iocontrols.h"

int VMCISharedMem_Init(void);
void VMCISharedMem_Exit(void);
void VMCISharedMem_AddContext(VMCIId contextID);
void VMCISharedMem_RemoveContext(VMCIId contextID);
int VMCISharedMem_IOCTLHandler(VMCIId contextID,
                               VMCIProcess *process, unsigned int iocmd,
                               VMCISharedMemInfo *memInfo);
int VMCISharedMem_Detach(VMCIContext *context, VMCIProcess *process,
                         VMCIHandle handle);
Bool VMCISharedMem_CheckGuestCalls(VMCIContext *context);

#endif // _VMCI_SHAREDMEM_H_
