/* **********************************************************
 * Copyright (C) 2006 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 19)

#include <linux/fs.h>

/*
 * Around 2.6.18, a pointer to a vfsmount was added to get_sb. Red Hat 
 * backported this behavior into a 2.6.17 kernel.
 *
 * This test will fail on a kernel with such a patch.
 */
static struct super_block * LinuxDriverGetSb(struct file_system_type *fs_type,
                                             int flags,
                                             const char *dev_name,
                                             void *rawData)
{
   return 0;
}

struct file_system_type fs_type = {
   .get_sb = LinuxDriverGetSb
};
#else
#error "This test intentionally fails on 2.6.19 or newer kernels."
#endif
