/* **********************************************************
 * Copyright (C) 2006 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

#ifndef __COMPAT_NAMEI_H__
#   define __COMPAT_NAMEI_H__

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 5, 18)
#include <linux/namei.h>
#endif

/* path_lookup was exported in 2.4.25 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 25)
#define compat_path_lookup(path, flags, nd)     path_lookup(path, flags, nd)
#else
#define compat_path_lookup(path, flags, nd)     \
         ({                                     \
            int ret = 0;                        \
            if (path_init(path, flags, nd)) {   \
               ret = path_walk(path, nd);       \
            }                                   \
            ret;                                \
         })
#endif

#endif /* __COMPAT_NAMEI_H__ */
