/* **********************************************************
 * Copyright (C) 2007 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/


/*
 * os.h --
 *
 *      OS-specific definitions.
 */


#ifndef __OS_H__
#define __OS_H__

#include "driver-config.h"
#include "compat_list.h"
#include "compat_completion.h"
#include <linux/limits.h>
#include "compat_slab.h"
#include "compat_wait.h"
#include <asm/atomic.h>
#include <asm/errno.h>
#include "compat_sched.h"
#include <asm/current.h>
#include "compat_kernel.h"
#include "compat_spinlock.h"

typedef rwlock_t os_rwlock_t;
typedef compat_kmem_cache os_kmem_cache_t;
typedef compat_completion os_completion_t;
typedef atomic_t os_atomic_t;
typedef struct file * os_blocker_id_t;

#define OS_UNKNOWN_BLOCKER              NULL
#define OS_ENOMEM                       -ENOMEM
#define OS_ENOENT                       -ENOENT
#define OS_EEXIST                       -EEXIST
#define OS_PATH_MAX                     PATH_MAX

#define OS_FMTTID                       "d"
#define os_threadid                     current->pid
/*
 * XXX vprintk() wasn't exported until 2.6.9; we should do something more
 * intelligent here eventually.
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 9)
# define os_panic(fmt, args)             \
      ({                                 \
          vprintk(fmt, args);            \
          BUG();                         \
      })
#else
# define os_panic(fmt, args)             \
      ({                                 \
          BUG();                         \
      })
#endif

#define os_rwlock_init(lock)            rwlock_init(lock)
#define os_rwlock_destroy(lock)
/*
 * XXX We'd like to check for kernel version 2.5.34 as the patches indicate,
 * but SLES10's 2.6.16.21-0.8-i586default doesn't seem to have this defined.
 */
#if defined(rwlock_is_locked)
# define os_rwlock_held(lock)           rwlock_is_locked(lock)
#else
/* XXX Is there something we can come up with for this? */
# define os_rwlock_held(lock)           TRUE
#endif
#define os_read_lock(lock)              read_lock(lock)
#define os_write_lock(lock)             write_lock(lock)
#define os_read_unlock(lock)            read_unlock(lock)
#define os_write_unlock(lock)           write_unlock(lock)

#define os_kmem_cache_create(name, size, align, ctor) \
   compat_kmem_cache_create(name, size, align, SLAB_HWCACHE_ALIGN, ctor)
#define os_kmem_cache_destroy(cache)    kmem_cache_destroy(cache)
#define os_kmem_cache_alloc(cache)      kmem_cache_alloc(cache, GFP_KERNEL)
#define os_kmem_cache_free(cache, elem) kmem_cache_free(cache, elem)

#define os_completion_init(comp)        compat_init_completion(comp)
#define os_completion_destroy(comp)
#define os_wait_for_completion(comp)    compat_wait_for_completion(comp)
#define os_complete_all(comp)           compat_complete_all(comp)

#define os_atomic_dec_and_test(atomic)  atomic_dec_and_test(atomic)
#define os_atomic_dec(atomic)           atomic_dec(atomic)
#define os_atomic_set(atomic, val)      atomic_set(atomic, val)
#define os_atomic_inc(atomic)           atomic_inc(atomic)
#define os_atomic_read(atomic)          atomic_read(atomic)

#endif /* __OS_H__ */
