/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/************************************************************
 *
 * memtrack.h  - Utility module for tracking memory allocated 
 *               and/or locked by the driver. 
 *
 ************************************************************/


#ifndef MEMTRACK_H
#define MEMTRACK_H

#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#if 1
#define MEMTRACK_MPN_LOOKUP   
#endif

typedef struct MemTrackEntry {
   VPN vpn;
   MPN mpn;

   struct MemTrackEntry *vpnHashChain;
#ifdef MEMTRACK_MPN_LOOKUP
   struct MemTrackEntry *mpnHashChain;
#endif
   struct MemTrackEntry *reclist; // list of pages to be recycled
} MemTrackEntry;

extern void          *MemTrack_Init(void);
extern MemTrackEntry *MemTrack_Add(void *s, VPN vpn, MPN mpn);
extern MemTrackEntry *MemTrack_LookupVPN(void *s, VPN vpn);
#ifdef MEMTRACK_MPN_LOOKUP
extern MemTrackEntry *MemTrack_LookupMPN(void *s, MPN mpn);
#endif
extern MemTrackEntry *MemTrack_GetRecycledPage(void *s);
extern void           MemTrack_RecyclePage(void *s, MemTrackEntry *e);
extern int            MemTrack_Cleanup(void *s,
				       void (*cleanProc)(void *, MemTrackEntry *),
				       void *clientData);
extern void          *MemTrack_Scan(void *s, void *arg,
				    void *(*searchFunc)(void *, MemTrackEntry *)); 

#endif 
