/* **********************************************************
 * Copyright 2006 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * vmciContext.h --
 *
 *	VMCI state to enable sending calls between VMs.
 */

#ifndef _VMCI_CONTEXT_H_
#define _VMCI_CONTEXT_H_

#define INCLUDE_ALLOW_MODULE
#define INCLUDE_ALLOW_VMMON
#define INCLUDE_ALLOW_VMCORE
#include "includeCheck.h"

#include "vmci_kernel_defs.h"
#include "vmci_defs.h"
#include "vmci_infrastructure.h"
#include "vmci_handle_array.h"

#define MAX_QUEUED_GUESTCALLS_PER_VM  100

typedef struct VMCIContext VMCIContext;

int VMCIContext_Init(void);
void VMCIContext_Exit(void);
int VMCIContext_InitContext(VMCIId cid, uintptr_t eventHnd,
                            VMCIContext **context);
void VMCIContext_ReleaseContext(VMCIContext *context);
int VMCIContext_SendCall(VMCIId cid, VMCICall *guestCall,
                         Bool mustCopy);
int VMCIContext_ReadCall(VMCIContext *context, void *buf, size_t bufSize);
VMCIContext *VMCIContext_Get(VMCIId cid);
Bool VMCIContext_SupportsGuestCall(VMCIContext *context,
                                   VMCI_Vector vector);
Bool VMCIContext_CheckGuestCalls(VMCIContext *context);

VMCIId VMCIContext_GetId(VMCIContext *context);
int VMCIContext_AddGroupEntry(VMCIContext *context,
                              VMCIHandle entryHandle);
VMCIHandle VMCIContext_RemoveGroupEntry(VMCIContext *context,
                                      VMCIHandle entryHandle);

#endif // _VMCI_CONTEXT_H_
